/**
 * Framework7 6.3.12
 * Full featured mobile HTML framework for building iOS & Android apps
 * https://framework7.io/
 *
 * Copyright 2014-2021 Vladimir Kharlampidi
 *
 * Released under the MIT License
 *
 * Released on: December 13, 2021
 */

!(function (e, t) {
    "object" == typeof exports && "undefined" != typeof module
        ? (module.exports = t())
        : "function" == typeof define && define.amd
        ? define(t)
        : ((e =
              "undefined" != typeof globalThis
                  ? globalThis
                  : e || self).Framework7 = t());
})(this, function () {
    "use strict";
    function e(e) {
        return (
            null !== e &&
            "object" == typeof e &&
            "constructor" in e &&
            e.constructor === Object
        );
    }
    function t(a, r) {
        void 0 === a && (a = {}),
            void 0 === r && (r = {}),
            Object.keys(r).forEach(function (n) {
                void 0 === a[n]
                    ? (a[n] = r[n])
                    : e(r[n]) &&
                      e(a[n]) &&
                      Object.keys(r[n]).length > 0 &&
                      t(a[n], r[n]);
            });
    }
    var a = {
        body: {},
        addEventListener: function () {},
        removeEventListener: function () {},
        activeElement: { blur: function () {}, nodeName: "" },
        querySelector: function () {
            return null;
        },
        querySelectorAll: function () {
            return [];
        },
        getElementById: function () {
            return null;
        },
        createEvent: function () {
            return { initEvent: function () {} };
        },
        createElement: function () {
            return {
                children: [],
                childNodes: [],
                style: {},
                setAttribute: function () {},
                getElementsByTagName: function () {
                    return [];
                },
            };
        },
        createElementNS: function () {
            return {};
        },
        importNode: function () {
            return null;
        },
        location: {
            hash: "",
            host: "",
            hostname: "",
            href: "",
            origin: "",
            pathname: "",
            protocol: "",
            search: "",
        },
    };
    function r() {
        var e = "undefined" != typeof document ? document : {};
        return t(e, a), e;
    }
    var n = {
        document: a,
        navigator: { userAgent: "" },
        location: {
            hash: "",
            host: "",
            hostname: "",
            href: "",
            origin: "",
            pathname: "",
            protocol: "",
            search: "",
        },
        history: {
            replaceState: function () {},
            pushState: function () {},
            go: function () {},
            back: function () {},
        },
        CustomEvent: function () {
            return this;
        },
        addEventListener: function () {},
        removeEventListener: function () {},
        getComputedStyle: function () {
            return {
                getPropertyValue: function () {
                    return "";
                },
            };
        },
        Image: function () {},
        Date: function () {},
        screen: {},
        setTimeout: function () {},
        clearTimeout: function () {},
        matchMedia: function () {
            return {};
        },
        requestAnimationFrame: function (e) {
            return "undefined" == typeof setTimeout
                ? (e(), null)
                : setTimeout(e, 0);
        },
        cancelAnimationFrame: function (e) {
            "undefined" != typeof setTimeout && clearTimeout(e);
        },
    };
    function o() {
        var e = "undefined" != typeof window ? window : {};
        return t(e, n), e;
    }
    function i(e) {
        return (i = Object.setPrototypeOf
            ? Object.getPrototypeOf
            : function (e) {
                  return e.__proto__ || Object.getPrototypeOf(e);
              })(e);
    }
    function s(e, t) {
        return (s =
            Object.setPrototypeOf ||
            function (e, t) {
                return (e.__proto__ = t), e;
            })(e, t);
    }
    function l() {
        if ("undefined" == typeof Reflect || !Reflect.construct) return !1;
        if (Reflect.construct.sham) return !1;
        if ("function" == typeof Proxy) return !0;
        try {
            return (
                Date.prototype.toString.call(
                    Reflect.construct(Date, [], function () {})
                ),
                !0
            );
        } catch (e) {
            return !1;
        }
    }
    function c(e, t, a) {
        return (c = l()
            ? Reflect.construct
            : function (e, t, a) {
                  var r = [null];
                  r.push.apply(r, t);
                  var n = new (Function.bind.apply(e, r))();
                  return a && s(n, a.prototype), n;
              }).apply(null, arguments);
    }
    function p(e) {
        var t = "function" == typeof Map ? new Map() : void 0;
        return (p = function (e) {
            if (
                null === e ||
                ((a = e),
                -1 === Function.toString.call(a).indexOf("[native code]"))
            )
                return e;
            var a;
            if ("function" != typeof e)
                throw new TypeError(
                    "Super expression must either be null or a function"
                );
            if (void 0 !== t) {
                if (t.has(e)) return t.get(e);
                t.set(e, r);
            }
            function r() {
                return c(e, arguments, i(this).constructor);
            }
            return (
                (r.prototype = Object.create(e.prototype, {
                    constructor: {
                        value: r,
                        enumerable: !1,
                        writable: !0,
                        configurable: !0,
                    },
                })),
                s(r, e)
            );
        })(e);
    }
    var d = (function (e) {
        var t, a;
        function r(t) {
            var a, r, n;
            return (
                (a = e.call.apply(e, [this].concat(t)) || this),
                (r = (function (e) {
                    if (void 0 === e)
                        throw new ReferenceError(
                            "this hasn't been initialised - super() hasn't been called"
                        );
                    return e;
                })(a)),
                (n = r.__proto__),
                Object.defineProperty(r, "__proto__", {
                    get: function () {
                        return n;
                    },
                    set: function (e) {
                        n.__proto__ = e;
                    },
                }),
                a
            );
        }
        return (
            (a = e),
            ((t = r).prototype = Object.create(a.prototype)),
            (t.prototype.constructor = t),
            (t.__proto__ = a),
            r
        );
    })(p(Array));
    function u(e) {
        void 0 === e && (e = []);
        var t = [];
        return (
            e.forEach(function (e) {
                Array.isArray(e) ? t.push.apply(t, u(e)) : t.push(e);
            }),
            t
        );
    }
    function h(e, t) {
        return Array.prototype.filter.call(e, t);
    }
    function f(e, t) {
        var a = o(),
            n = r(),
            i = [];
        if (!t && e instanceof d) return e;
        if (!e) return new d(i);
        if ("string" == typeof e) {
            var s = e.trim();
            if (s.indexOf("<") >= 0 && s.indexOf(">") >= 0) {
                var l = "div";
                0 === s.indexOf("<li") && (l = "ul"),
                    0 === s.indexOf("<tr") && (l = "tbody"),
                    (0 !== s.indexOf("<td") && 0 !== s.indexOf("<th")) ||
                        (l = "tr"),
                    0 === s.indexOf("<tbody") && (l = "table"),
                    0 === s.indexOf("<option") && (l = "select");
                var c = n.createElement(l);
                c.innerHTML = s;
                for (var p = 0; p < c.childNodes.length; p += 1)
                    i.push(c.childNodes[p]);
            } else
                i = (function (e, t) {
                    if ("string" != typeof e) return [e];
                    for (
                        var a = [], r = t.querySelectorAll(e), n = 0;
                        n < r.length;
                        n += 1
                    )
                        a.push(r[n]);
                    return a;
                })(e.trim(), t || n);
        } else if (e.nodeType || e === a || e === n) i.push(e);
        else if (Array.isArray(e)) {
            if (e instanceof d) return e;
            i = e;
        }
        return new d(
            (function (e) {
                for (var t = [], a = 0; a < e.length; a += 1)
                    -1 === t.indexOf(e[a]) && t.push(e[a]);
                return t;
            })(i)
        );
    }
    function v() {
        for (var e = arguments.length, t = new Array(e), a = 0; a < e; a++)
            t[a] = arguments[a];
        var r = u(
            t.map(function (e) {
                return e.split(" ");
            })
        );
        return (
            this.forEach(function (e) {
                var t;
                (t = e.classList).add.apply(t, r);
            }),
            this
        );
    }
    function m() {
        for (var e = arguments.length, t = new Array(e), a = 0; a < e; a++)
            t[a] = arguments[a];
        var r = u(
            t.map(function (e) {
                return e.split(" ");
            })
        );
        return (
            this.forEach(function (e) {
                var t;
                (t = e.classList).remove.apply(t, r);
            }),
            this
        );
    }
    function g() {
        for (var e = arguments.length, t = new Array(e), a = 0; a < e; a++)
            t[a] = arguments[a];
        var r = u(
            t.map(function (e) {
                return e.split(" ");
            })
        );
        this.forEach(function (e) {
            r.forEach(function (t) {
                e.classList.toggle(t);
            });
        });
    }
    function b() {
        for (var e = arguments.length, t = new Array(e), a = 0; a < e; a++)
            t[a] = arguments[a];
        var r = u(
            t.map(function (e) {
                return e.split(" ");
            })
        );
        return (
            h(this, function (e) {
                return (
                    r.filter(function (t) {
                        return e.classList.contains(t);
                    }).length > 0
                );
            }).length > 0
        );
    }
    function y(e, t) {
        if (1 === arguments.length && "string" == typeof e)
            return this[0] ? this[0].getAttribute(e) : void 0;
        for (var a = 0; a < this.length; a += 1)
            if (2 === arguments.length) this[a].setAttribute(e, t);
            else
                for (var r in e)
                    (this[a][r] = e[r]), this[a].setAttribute(r, e[r]);
        return this;
    }
    function w(e) {
        for (var t = 0; t < this.length; t += 1) this[t].removeAttribute(e);
        return this;
    }
    function C(e) {
        for (var t = 0; t < this.length; t += 1) this[t].style.transform = e;
        return this;
    }
    function E(e) {
        for (var t = 0; t < this.length; t += 1)
            this[t].style.transitionDuration =
                "string" != typeof e ? e + "ms" : e;
        return this;
    }
    function k() {
        for (var e = arguments.length, t = new Array(e), a = 0; a < e; a++)
            t[a] = arguments[a];
        var r = t[0],
            n = t[1],
            o = t[2],
            i = t[3];
        function s(e) {
            var t = e.target;
            if (t) {
                var a = e.target.dom7EventData || [];
                if ((a.indexOf(e) < 0 && a.unshift(e), f(t).is(n)))
                    o.apply(t, a);
                else
                    for (var r = f(t).parents(), i = 0; i < r.length; i += 1)
                        f(r[i]).is(n) && o.apply(r[i], a);
            }
        }
        function l(e) {
            var t = (e && e.target && e.target.dom7EventData) || [];
            t.indexOf(e) < 0 && t.unshift(e), o.apply(this, t);
        }
        "function" == typeof t[1] &&
            ((r = t[0]), (o = t[1]), (i = t[2]), (n = void 0)),
            i || (i = !1);
        for (var c, p = r.split(" "), d = 0; d < this.length; d += 1) {
            var u = this[d];
            if (n)
                for (c = 0; c < p.length; c += 1) {
                    var h = p[c];
                    u.dom7LiveListeners || (u.dom7LiveListeners = {}),
                        u.dom7LiveListeners[h] || (u.dom7LiveListeners[h] = []),
                        u.dom7LiveListeners[h].push({
                            listener: o,
                            proxyListener: s,
                        }),
                        u.addEventListener(h, s, i);
                }
            else
                for (c = 0; c < p.length; c += 1) {
                    var v = p[c];
                    u.dom7Listeners || (u.dom7Listeners = {}),
                        u.dom7Listeners[v] || (u.dom7Listeners[v] = []),
                        u.dom7Listeners[v].push({
                            listener: o,
                            proxyListener: l,
                        }),
                        u.addEventListener(v, l, i);
                }
        }
        return this;
    }
    function x() {
        for (var e = arguments.length, t = new Array(e), a = 0; a < e; a++)
            t[a] = arguments[a];
        var r = t[0],
            n = t[1],
            o = t[2],
            i = t[3];
        "function" == typeof t[1] &&
            ((r = t[0]), (o = t[1]), (i = t[2]), (n = void 0)),
            i || (i = !1);
        for (var s = r.split(" "), l = 0; l < s.length; l += 1)
            for (var c = s[l], p = 0; p < this.length; p += 1) {
                var d = this[p],
                    u = void 0;
                if (
                    (!n && d.dom7Listeners
                        ? (u = d.dom7Listeners[c])
                        : n &&
                          d.dom7LiveListeners &&
                          (u = d.dom7LiveListeners[c]),
                    u && u.length)
                )
                    for (var h = u.length - 1; h >= 0; h -= 1) {
                        var f = u[h];
                        (o && f.listener === o) ||
                        (o &&
                            f.listener &&
                            f.listener.dom7proxy &&
                            f.listener.dom7proxy === o)
                            ? (d.removeEventListener(c, f.proxyListener, i),
                              u.splice(h, 1))
                            : o ||
                              (d.removeEventListener(c, f.proxyListener, i),
                              u.splice(h, 1));
                    }
            }
        return this;
    }
    function $() {
        for (
            var e = o(), t = arguments.length, a = new Array(t), r = 0;
            r < t;
            r++
        )
            a[r] = arguments[r];
        for (var n = a[0].split(" "), i = a[1], s = 0; s < n.length; s += 1)
            for (var l = n[s], c = 0; c < this.length; c += 1) {
                var p = this[c];
                if (e.CustomEvent) {
                    var d = new e.CustomEvent(l, {
                        detail: i,
                        bubbles: !0,
                        cancelable: !0,
                    });
                    (p.dom7EventData = a.filter(function (e, t) {
                        return t > 0;
                    })),
                        p.dispatchEvent(d),
                        (p.dom7EventData = []),
                        delete p.dom7EventData;
                }
            }
        return this;
    }
    function T(e) {
        var t = this;
        return (
            e &&
                t.on("transitionend", function a(r) {
                    r.target === this &&
                        (e.call(this, r), t.off("transitionend", a));
                }),
            this
        );
    }
    function S(e) {
        if (this.length > 0) {
            if (e) {
                var t = this.styles();
                return (
                    this[0].offsetWidth +
                    parseFloat(t.getPropertyValue("margin-right")) +
                    parseFloat(t.getPropertyValue("margin-left"))
                );
            }
            return this[0].offsetWidth;
        }
        return null;
    }
    function M(e) {
        if (this.length > 0) {
            if (e) {
                var t = this.styles();
                return (
                    this[0].offsetHeight +
                    parseFloat(t.getPropertyValue("margin-top")) +
                    parseFloat(t.getPropertyValue("margin-bottom"))
                );
            }
            return this[0].offsetHeight;
        }
        return null;
    }
    function P() {
        if (this.length > 0) {
            var e = o(),
                t = r(),
                a = this[0],
                n = a.getBoundingClientRect(),
                i = t.body,
                s = a.clientTop || i.clientTop || 0,
                l = a.clientLeft || i.clientLeft || 0,
                c = a === e ? e.scrollY : a.scrollTop,
                p = a === e ? e.scrollX : a.scrollLeft;
            return { top: n.top + c - s, left: n.left + p - l };
        }
        return null;
    }
    function O() {
        var e = o();
        return this[0] ? e.getComputedStyle(this[0], null) : {};
    }
    function I(e, t) {
        var a,
            r = o();
        if (1 === arguments.length) {
            if ("string" != typeof e) {
                for (a = 0; a < this.length; a += 1)
                    for (var n in e) this[a].style[n] = e[n];
                return this;
            }
            if (this[0])
                return r.getComputedStyle(this[0], null).getPropertyValue(e);
        }
        if (2 === arguments.length && "string" == typeof e) {
            for (a = 0; a < this.length; a += 1) this[a].style[e] = t;
            return this;
        }
        return this;
    }
    function B(e) {
        return e
            ? (this.forEach(function (t, a) {
                  e.apply(t, [t, a]);
              }),
              this)
            : this;
    }
    function L(e) {
        return f(h(this, e));
    }
    function z(e) {
        if (void 0 === e) return this[0] ? this[0].innerHTML : null;
        for (var t = 0; t < this.length; t += 1) this[t].innerHTML = e;
        return this;
    }
    function R(e) {
        if (void 0 === e) return this[0] ? this[0].textContent.trim() : null;
        for (var t = 0; t < this.length; t += 1) this[t].textContent = e;
        return this;
    }
    function A(e) {
        var t,
            a,
            n = o(),
            i = r(),
            s = this[0];
        if (!s || void 0 === e) return !1;
        if ("string" == typeof e) {
            if (s.matches) return s.matches(e);
            if (s.webkitMatchesSelector) return s.webkitMatchesSelector(e);
            if (s.msMatchesSelector) return s.msMatchesSelector(e);
            for (t = f(e), a = 0; a < t.length; a += 1)
                if (t[a] === s) return !0;
            return !1;
        }
        if (e === i) return s === i;
        if (e === n) return s === n;
        if (e.nodeType || e instanceof d) {
            for (t = e.nodeType ? [e] : e, a = 0; a < t.length; a += 1)
                if (t[a] === s) return !0;
            return !1;
        }
        return !1;
    }
    function D() {
        var e,
            t = this[0];
        if (t) {
            for (e = 0; null !== (t = t.previousSibling); )
                1 === t.nodeType && (e += 1);
            return e;
        }
    }
    function H(e) {
        if (void 0 === e) return this;
        var t = this.length;
        if (e > t - 1) return f([]);
        if (e < 0) {
            var a = t + e;
            return f(a < 0 ? [] : [this[a]]);
        }
        return f([this[e]]);
    }
    function N() {
        for (var e, t = r(), a = 0; a < arguments.length; a += 1) {
            e = a < 0 || arguments.length <= a ? void 0 : arguments[a];
            for (var n = 0; n < this.length; n += 1)
                if ("string" == typeof e) {
                    var o = t.createElement("div");
                    for (o.innerHTML = e; o.firstChild; )
                        this[n].appendChild(o.firstChild);
                } else if (e instanceof d)
                    for (var i = 0; i < e.length; i += 1)
                        this[n].appendChild(e[i]);
                else this[n].appendChild(e);
        }
        return this;
    }
    function V(e) {
        var t,
            a,
            n = r();
        for (t = 0; t < this.length; t += 1)
            if ("string" == typeof e) {
                var o = n.createElement("div");
                for (
                    o.innerHTML = e, a = o.childNodes.length - 1;
                    a >= 0;
                    a -= 1
                )
                    this[t].insertBefore(
                        o.childNodes[a],
                        this[t].childNodes[0]
                    );
            } else if (e instanceof d)
                for (a = 0; a < e.length; a += 1)
                    this[t].insertBefore(e[a], this[t].childNodes[0]);
            else this[t].insertBefore(e, this[t].childNodes[0]);
        return this;
    }
    function F(e) {
        return this.length > 0
            ? e
                ? this[0].nextElementSibling &&
                  f(this[0].nextElementSibling).is(e)
                    ? f([this[0].nextElementSibling])
                    : f([])
                : this[0].nextElementSibling
                ? f([this[0].nextElementSibling])
                : f([])
            : f([]);
    }
    function q(e) {
        var t = [],
            a = this[0];
        if (!a) return f([]);
        for (; a.nextElementSibling; ) {
            var r = a.nextElementSibling;
            e ? f(r).is(e) && t.push(r) : t.push(r), (a = r);
        }
        return f(t);
    }
    function j(e) {
        if (this.length > 0) {
            var t = this[0];
            return e
                ? t.previousElementSibling && f(t.previousElementSibling).is(e)
                    ? f([t.previousElementSibling])
                    : f([])
                : t.previousElementSibling
                ? f([t.previousElementSibling])
                : f([]);
        }
        return f([]);
    }
    function _(e) {
        var t = [],
            a = this[0];
        if (!a) return f([]);
        for (; a.previousElementSibling; ) {
            var r = a.previousElementSibling;
            e ? f(r).is(e) && t.push(r) : t.push(r), (a = r);
        }
        return f(t);
    }
    function Y(e) {
        for (var t = [], a = 0; a < this.length; a += 1)
            null !== this[a].parentNode &&
                (e
                    ? f(this[a].parentNode).is(e) && t.push(this[a].parentNode)
                    : t.push(this[a].parentNode));
        return f(t);
    }
    function W(e) {
        for (var t = [], a = 0; a < this.length; a += 1)
            for (var r = this[a].parentNode; r; )
                e ? f(r).is(e) && t.push(r) : t.push(r), (r = r.parentNode);
        return f(t);
    }
    function X(e) {
        var t = this;
        return void 0 === e ? f([]) : (t.is(e) || (t = t.parents(e).eq(0)), t);
    }
    function G(e) {
        for (var t = [], a = 0; a < this.length; a += 1)
            for (
                var r = this[a].querySelectorAll(e), n = 0;
                n < r.length;
                n += 1
            )
                t.push(r[n]);
        return f(t);
    }
    function U(e) {
        for (var t = [], a = 0; a < this.length; a += 1)
            for (var r = this[a].children, n = 0; n < r.length; n += 1)
                (e && !f(r[n]).is(e)) || t.push(r[n]);
        return f(t);
    }
    function K() {
        for (var e = 0; e < this.length; e += 1)
            this[e].parentNode && this[e].parentNode.removeChild(this[e]);
        return this;
    }
    f.fn = d.prototype;
    var Q = "resize scroll".split(" ");
    function J(e) {
        return function () {
            for (var t = arguments.length, a = new Array(t), r = 0; r < t; r++)
                a[r] = arguments[r];
            if (void 0 === a[0]) {
                for (var n = 0; n < this.length; n += 1)
                    Q.indexOf(e) < 0 &&
                        (e in this[n] ? this[n][e]() : f(this[n]).trigger(e));
                return this;
            }
            return this.on.apply(this, [e].concat(a));
        };
    }
    var Z = J("click"),
        ee = J("blur"),
        te = J("focus"),
        ae = J("focusin"),
        re = J("focusout"),
        ne = J("keyup"),
        oe = J("keydown"),
        ie = J("keypress"),
        se = J("submit"),
        le = J("change"),
        ce = J("mousedown"),
        pe = J("mousemove"),
        de = J("mouseup"),
        ue = J("mouseenter"),
        he = J("mouseleave"),
        fe = J("mouseout"),
        ve = J("mouseover"),
        me = J("touchstart"),
        ge = J("touchend"),
        be = J("touchmove"),
        ye = J("resize"),
        we = J("scroll"),
        Ce = Object.freeze({
            __proto__: null,
            default: f,
            $: f,
            add: function () {
                for (
                    var e,
                        t,
                        a = this,
                        r = arguments.length,
                        n = new Array(r),
                        o = 0;
                    o < r;
                    o++
                )
                    n[o] = arguments[o];
                for (e = 0; e < n.length; e += 1) {
                    var i = f(n[e]);
                    for (t = 0; t < i.length; t += 1) a.push(i[t]);
                }
                return a;
            },
            addClass: v,
            animate: function (e, t) {
                var a,
                    r = o(),
                    n = this,
                    i = {
                        props: Object.assign({}, e),
                        params: Object.assign(
                            { duration: 300, easing: "swing" },
                            t
                        ),
                        elements: n,
                        animating: !1,
                        que: [],
                        easingProgress: function (e, t) {
                            return "swing" === e
                                ? 0.5 - Math.cos(t * Math.PI) / 2
                                : "function" == typeof e
                                ? e(t)
                                : t;
                        },
                        stop: function () {
                            i.frameId && r.cancelAnimationFrame(i.frameId),
                                (i.animating = !1),
                                i.elements.each(function (e) {
                                    delete e.dom7AnimateInstance;
                                }),
                                (i.que = []);
                        },
                        done: function (e) {
                            if (
                                ((i.animating = !1),
                                i.elements.each(function (e) {
                                    delete e.dom7AnimateInstance;
                                }),
                                e && e(n),
                                i.que.length > 0)
                            ) {
                                var t = i.que.shift();
                                i.animate(t[0], t[1]);
                            }
                        },
                        animate: function (e, t) {
                            if (i.animating) return i.que.push([e, t]), i;
                            var a = [];
                            i.elements.each(function (t, n) {
                                var o, s, l, c, p;
                                t.dom7AnimateInstance ||
                                    (i.elements[n].dom7AnimateInstance = i),
                                    (a[n] = { container: t }),
                                    Object.keys(e).forEach(function (i) {
                                        (o = r
                                            .getComputedStyle(t, null)
                                            .getPropertyValue(i)
                                            .replace(",", ".")),
                                            (s = parseFloat(o)),
                                            (l = o.replace(s, "")),
                                            (c = parseFloat(e[i])),
                                            (p = e[i] + l),
                                            (a[n][i] = {
                                                initialFullValue: o,
                                                initialValue: s,
                                                unit: l,
                                                finalValue: c,
                                                finalFullValue: p,
                                                currentValue: s,
                                            });
                                    });
                            });
                            var o,
                                s,
                                l = null,
                                c = 0,
                                p = 0,
                                d = !1;
                            return (
                                (i.animating = !0),
                                (i.frameId = r.requestAnimationFrame(
                                    function u() {
                                        var h, f;
                                        (o = new Date().getTime()),
                                            d ||
                                                ((d = !0),
                                                t.begin && t.begin(n)),
                                            null === l && (l = o),
                                            t.progress &&
                                                t.progress(
                                                    n,
                                                    Math.max(
                                                        Math.min(
                                                            (o - l) /
                                                                t.duration,
                                                            1
                                                        ),
                                                        0
                                                    ),
                                                    l + t.duration - o < 0
                                                        ? 0
                                                        : l + t.duration - o,
                                                    l
                                                ),
                                            a.forEach(function (r) {
                                                var n = r;
                                                s ||
                                                    n.done ||
                                                    Object.keys(e).forEach(
                                                        function (r) {
                                                            if (!s && !n.done) {
                                                                (h = Math.max(
                                                                    Math.min(
                                                                        (o -
                                                                            l) /
                                                                            t.duration,
                                                                        1
                                                                    ),
                                                                    0
                                                                )),
                                                                    (f =
                                                                        i.easingProgress(
                                                                            t.easing,
                                                                            h
                                                                        ));
                                                                var d = n[r],
                                                                    u =
                                                                        d.initialValue,
                                                                    v =
                                                                        d.finalValue,
                                                                    m = d.unit;
                                                                n[
                                                                    r
                                                                ].currentValue =
                                                                    u +
                                                                    f * (v - u);
                                                                var g =
                                                                    n[r]
                                                                        .currentValue;
                                                                ((v > u &&
                                                                    g >= v) ||
                                                                    (v < u &&
                                                                        g <=
                                                                            v)) &&
                                                                    ((n.container.style[
                                                                        r
                                                                    ] = v + m),
                                                                    (p += 1) ===
                                                                        Object.keys(
                                                                            e
                                                                        )
                                                                            .length &&
                                                                        ((n.done =
                                                                            !0),
                                                                        (c += 1)),
                                                                    c ===
                                                                        a.length &&
                                                                        (s =
                                                                            !0)),
                                                                    s
                                                                        ? i.done(
                                                                              t.complete
                                                                          )
                                                                        : (n.container.style[
                                                                              r
                                                                          ] =
                                                                              g +
                                                                              m);
                                                            }
                                                        }
                                                    );
                                            }),
                                            s ||
                                                (i.frameId =
                                                    r.requestAnimationFrame(u));
                                    }
                                )),
                                i
                            );
                        },
                    };
                if (0 === i.elements.length) return n;
                for (var s = 0; s < i.elements.length; s += 1)
                    i.elements[s].dom7AnimateInstance
                        ? (a = i.elements[s].dom7AnimateInstance)
                        : (i.elements[s].dom7AnimateInstance = i);
                return (
                    a || (a = i),
                    "stop" === e ? a.stop() : a.animate(i.props, i.params),
                    n
                );
            },
            animationEnd: function (e) {
                var t = this;
                return (
                    e &&
                        t.on("animationend", function a(r) {
                            r.target === this &&
                                (e.call(this, r), t.off("animationend", a));
                        }),
                    this
                );
            },
            append: N,
            appendTo: function (e) {
                return f(e).append(this), this;
            },
            attr: y,
            blur: ee,
            change: le,
            children: U,
            click: Z,
            closest: X,
            css: I,
            data: function (e, t) {
                var a;
                if (void 0 === t) {
                    if (!(a = this[0])) return;
                    if (
                        a.dom7ElementDataStorage &&
                        e in a.dom7ElementDataStorage
                    )
                        return a.dom7ElementDataStorage[e];
                    var r = a.getAttribute("data-" + e);
                    return r || void 0;
                }
                for (var n = 0; n < this.length; n += 1)
                    (a = this[n]).dom7ElementDataStorage ||
                        (a.dom7ElementDataStorage = {}),
                        (a.dom7ElementDataStorage[e] = t);
                return this;
            },
            dataset: function () {
                var e = this[0];
                if (e) {
                    var t,
                        a = {};
                    if (e.dataset) for (var r in e.dataset) a[r] = e.dataset[r];
                    else
                        for (var n = 0; n < e.attributes.length; n += 1) {
                            var o = e.attributes[n];
                            o.name.indexOf("data-") >= 0 &&
                                (a[
                                    ((t = o.name.split("data-")[1]),
                                    t
                                        .toLowerCase()
                                        .replace(/-(.)/g, function (e, t) {
                                            return t.toUpperCase();
                                        }))
                                ] = o.value);
                        }
                    for (var i in a)
                        "false" === a[i]
                            ? (a[i] = !1)
                            : "true" === a[i]
                            ? (a[i] = !0)
                            : parseFloat(a[i]) === 1 * a[i] && (a[i] *= 1);
                    return a;
                }
            },
            detach: function () {
                return this.remove();
            },
            each: B,
            empty: function () {
                for (var e = 0; e < this.length; e += 1) {
                    var t = this[e];
                    if (1 === t.nodeType) {
                        for (var a = 0; a < t.childNodes.length; a += 1)
                            t.childNodes[a].parentNode &&
                                t.childNodes[a].parentNode.removeChild(
                                    t.childNodes[a]
                                );
                        t.textContent = "";
                    }
                }
                return this;
            },
            eq: H,
            filter: L,
            find: G,
            focus: te,
            focusin: ae,
            focusout: re,
            hasClass: b,
            height: function () {
                var e = o();
                return this[0] === e
                    ? e.innerHeight
                    : this.length > 0
                    ? parseFloat(this.css("height"))
                    : null;
            },
            hide: function () {
                for (var e = 0; e < this.length; e += 1)
                    this[e].style.display = "none";
                return this;
            },
            html: z,
            index: D,
            insertAfter: function (e) {
                for (var t = f(e), a = 0; a < this.length; a += 1)
                    if (1 === t.length)
                        t[0].parentNode.insertBefore(this[a], t[0].nextSibling);
                    else if (t.length > 1)
                        for (var r = 0; r < t.length; r += 1)
                            t[r].parentNode.insertBefore(
                                this[a].cloneNode(!0),
                                t[r].nextSibling
                            );
            },
            insertBefore: function (e) {
                for (var t = f(e), a = 0; a < this.length; a += 1)
                    if (1 === t.length)
                        t[0].parentNode.insertBefore(this[a], t[0]);
                    else if (t.length > 1)
                        for (var r = 0; r < t.length; r += 1)
                            t[r].parentNode.insertBefore(
                                this[a].cloneNode(!0),
                                t[r]
                            );
            },
            is: A,
            keydown: oe,
            keypress: ie,
            keyup: ne,
            mousedown: ce,
            mouseenter: ue,
            mouseleave: he,
            mousemove: pe,
            mouseout: fe,
            mouseover: ve,
            mouseup: de,
            next: F,
            nextAll: q,
            off: x,
            offset: P,
            on: k,
            once: function () {
                for (
                    var e = this, t = arguments.length, a = new Array(t), r = 0;
                    r < t;
                    r++
                )
                    a[r] = arguments[r];
                var n = a[0],
                    o = a[1],
                    i = a[2],
                    s = a[3];
                function l() {
                    for (
                        var t = arguments.length, a = new Array(t), r = 0;
                        r < t;
                        r++
                    )
                        a[r] = arguments[r];
                    i.apply(this, a),
                        e.off(n, o, l, s),
                        l.dom7proxy && delete l.dom7proxy;
                }
                return (
                    "function" == typeof a[1] &&
                        ((n = a[0]), (i = a[1]), (s = a[2]), (o = void 0)),
                    (l.dom7proxy = i),
                    e.on(n, o, l, s)
                );
            },
            outerHeight: M,
            outerWidth: S,
            parent: Y,
            parents: W,
            prepend: V,
            prependTo: function (e) {
                return f(e).prepend(this), this;
            },
            prev: j,
            prevAll: _,
            prop: function (e, t) {
                if (1 !== arguments.length || "string" != typeof e) {
                    for (var a = 0; a < this.length; a += 1)
                        if (2 === arguments.length) this[a][e] = t;
                        else for (var r in e) this[a][r] = e[r];
                    return this;
                }
                return this[0] ? this[0][e] : this;
            },
            remove: K,
            removeAttr: w,
            removeClass: m,
            removeData: function (e) {
                for (var t = 0; t < this.length; t += 1) {
                    var a = this[t];
                    a.dom7ElementDataStorage &&
                        a.dom7ElementDataStorage[e] &&
                        ((a.dom7ElementDataStorage[e] = null),
                        delete a.dom7ElementDataStorage[e]);
                }
            },
            resize: ye,
            scroll: we,
            scrollLeft: function () {
                for (
                    var e = arguments.length, t = new Array(e), a = 0;
                    a < e;
                    a++
                )
                    t[a] = arguments[a];
                var r = t[0],
                    n = t[1],
                    o = t[2],
                    i = t[3];
                3 === t.length &&
                    "function" == typeof o &&
                    ((r = t[0]), (n = t[1]), (i = t[2]), (o = t[3]));
                var s = this;
                return void 0 === r
                    ? s.length > 0
                        ? s[0].scrollLeft
                        : null
                    : s.scrollTo(r, void 0, n, o, i);
            },
            scrollTo: function () {
                for (
                    var e = o(), t = arguments.length, a = new Array(t), r = 0;
                    r < t;
                    r++
                )
                    a[r] = arguments[r];
                var n = a[0],
                    i = a[1],
                    s = a[2],
                    l = a[3],
                    c = a[4];
                return (
                    4 === a.length &&
                        "function" == typeof l &&
                        ((c = l),
                        (n = a[0]),
                        (i = a[1]),
                        (s = a[2]),
                        (c = a[3]),
                        (l = a[4])),
                    void 0 === l && (l = "swing"),
                    this.each(function () {
                        var t,
                            a,
                            r,
                            o,
                            p,
                            d,
                            u,
                            h,
                            f = this,
                            v = i > 0 || 0 === i,
                            m = n > 0 || 0 === n;
                        if (
                            (void 0 === l && (l = "swing"),
                            v && ((t = f.scrollTop), s || (f.scrollTop = i)),
                            m && ((a = f.scrollLeft), s || (f.scrollLeft = n)),
                            s)
                        ) {
                            v &&
                                ((r = f.scrollHeight - f.offsetHeight),
                                (p = Math.max(Math.min(i, r), 0))),
                                m &&
                                    ((o = f.scrollWidth - f.offsetWidth),
                                    (d = Math.max(Math.min(n, o), 0)));
                            var g = null;
                            v && p === t && (v = !1),
                                m && d === a && (m = !1),
                                e.requestAnimationFrame(function r(n) {
                                    void 0 === n && (n = new Date().getTime()),
                                        null === g && (g = n);
                                    var o,
                                        i = Math.max(
                                            Math.min((n - g) / s, 1),
                                            0
                                        ),
                                        b =
                                            "linear" === l
                                                ? i
                                                : 0.5 -
                                                  Math.cos(i * Math.PI) / 2;
                                    v && (u = t + b * (p - t)),
                                        m && (h = a + b * (d - a)),
                                        v &&
                                            p > t &&
                                            u >= p &&
                                            ((f.scrollTop = p), (o = !0)),
                                        v &&
                                            p < t &&
                                            u <= p &&
                                            ((f.scrollTop = p), (o = !0)),
                                        m &&
                                            d > a &&
                                            h >= d &&
                                            ((f.scrollLeft = d), (o = !0)),
                                        m &&
                                            d < a &&
                                            h <= d &&
                                            ((f.scrollLeft = d), (o = !0)),
                                        o
                                            ? c && c()
                                            : (v && (f.scrollTop = u),
                                              m && (f.scrollLeft = h),
                                              e.requestAnimationFrame(r));
                                });
                        }
                    })
                );
            },
            scrollTop: function () {
                for (
                    var e = arguments.length, t = new Array(e), a = 0;
                    a < e;
                    a++
                )
                    t[a] = arguments[a];
                var r = t[0],
                    n = t[1],
                    o = t[2],
                    i = t[3];
                3 === t.length &&
                    "function" == typeof o &&
                    ((r = t[0]), (n = t[1]), (i = t[2]), (o = t[3]));
                var s = this;
                return void 0 === r
                    ? s.length > 0
                        ? s[0].scrollTop
                        : null
                    : s.scrollTo(void 0, r, n, o, i);
            },
            show: function () {
                for (var e = o(), t = 0; t < this.length; t += 1) {
                    var a = this[t];
                    "none" === a.style.display && (a.style.display = ""),
                        "none" ===
                            e
                                .getComputedStyle(a, null)
                                .getPropertyValue("display") &&
                            (a.style.display = "block");
                }
                return this;
            },
            siblings: function (e) {
                return this.nextAll(e).add(this.prevAll(e));
            },
            stop: function () {
                for (var e = this, t = 0; t < e.length; t += 1)
                    e[t].dom7AnimateInstance && e[t].dom7AnimateInstance.stop();
            },
            styles: O,
            submit: se,
            text: R,
            toggleClass: g,
            touchend: ge,
            touchmove: be,
            touchstart: me,
            transform: C,
            transition: E,
            transitionEnd: T,
            trigger: $,
            val: function (e) {
                if (void 0 === e) {
                    var t = this[0];
                    if (!t) return;
                    if (t.multiple && "select" === t.nodeName.toLowerCase()) {
                        for (
                            var a = [], r = 0;
                            r < t.selectedOptions.length;
                            r += 1
                        )
                            a.push(t.selectedOptions[r].value);
                        return a;
                    }
                    return t.value;
                }
                for (var n = 0; n < this.length; n += 1) {
                    var o = this[n];
                    if (
                        Array.isArray(e) &&
                        o.multiple &&
                        "select" === o.nodeName.toLowerCase()
                    )
                        for (var i = 0; i < o.options.length; i += 1)
                            o.options[i].selected =
                                e.indexOf(o.options[i].value) >= 0;
                    else o.value = e;
                }
                return this;
            },
            value: function (e) {
                return this.val(e);
            },
            width: function () {
                var e = o();
                return this[0] === e
                    ? e.innerWidth
                    : this.length > 0
                    ? parseFloat(this.css("width"))
                    : null;
            },
        });
    Object.keys(Ce).forEach(function (e) {
        "$" !== e && (f.fn[e] = Ce[e]);
    });
    var Ee = f;
    function ke(e) {
        this.wrapped = e;
    }
    function xe(e) {
        var t, a;
        function r(t, a) {
            try {
                var o = e[t](a),
                    i = o.value,
                    s = i instanceof ke;
                Promise.resolve(s ? i.wrapped : i).then(
                    function (e) {
                        s
                            ? r("return" === t ? "return" : "next", e)
                            : n(o.done ? "return" : "normal", e);
                    },
                    function (e) {
                        r("throw", e);
                    }
                );
            } catch (e) {
                n("throw", e);
            }
        }
        function n(e, n) {
            switch (e) {
                case "return":
                    t.resolve({ value: n, done: !0 });
                    break;
                case "throw":
                    t.reject(n);
                    break;
                default:
                    t.resolve({ value: n, done: !1 });
            }
            (t = t.next) ? r(t.key, t.arg) : (a = null);
        }
        (this._invoke = function (e, n) {
            return new Promise(function (o, i) {
                var s = { key: e, arg: n, resolve: o, reject: i, next: null };
                a ? (a = a.next = s) : ((t = a = s), r(e, n));
            });
        }),
            "function" != typeof e.return && (this.return = void 0);
    }
    function $e(e, t) {
        for (var a = 0; a < t.length; a++) {
            var r = t[a];
            (r.enumerable = r.enumerable || !1),
                (r.configurable = !0),
                "value" in r && (r.writable = !0),
                Object.defineProperty(e, r.key, r);
        }
    }
    function Te(e, t, a) {
        return t && $e(e.prototype, t), a && $e(e, a), e;
    }
    function Se() {
        return (Se =
            Object.assign ||
            function (e) {
                for (var t = 1; t < arguments.length; t++) {
                    var a = arguments[t];
                    for (var r in a)
                        Object.prototype.hasOwnProperty.call(a, r) &&
                            (e[r] = a[r]);
                }
                return e;
            }).apply(this, arguments);
    }
    function Me(e, t) {
        (e.prototype = Object.create(t.prototype)),
            (e.prototype.constructor = e),
            Oe(e, t);
    }
    function Pe(e) {
        return (Pe = Object.setPrototypeOf
            ? Object.getPrototypeOf
            : function (e) {
                  return e.__proto__ || Object.getPrototypeOf(e);
              })(e);
    }
    function Oe(e, t) {
        return (Oe =
            Object.setPrototypeOf ||
            function (e, t) {
                return (e.__proto__ = t), e;
            })(e, t);
    }
    function Ie() {
        if ("undefined" == typeof Reflect || !Reflect.construct) return !1;
        if (Reflect.construct.sham) return !1;
        if ("function" == typeof Proxy) return !0;
        try {
            return (
                Boolean.prototype.valueOf.call(
                    Reflect.construct(Boolean, [], function () {})
                ),
                !0
            );
        } catch (e) {
            return !1;
        }
    }
    function Be(e, t, a) {
        return (Be = Ie()
            ? Reflect.construct
            : function (e, t, a) {
                  var r = [null];
                  r.push.apply(r, t);
                  var n = new (Function.bind.apply(e, r))();
                  return a && Oe(n, a.prototype), n;
              }).apply(null, arguments);
    }
    function Le(e) {
        var t = "function" == typeof Map ? new Map() : void 0;
        return (Le = function (e) {
            if (
                null === e ||
                ((a = e),
                -1 === Function.toString.call(a).indexOf("[native code]"))
            )
                return e;
            var a;
            if ("function" != typeof e)
                throw new TypeError(
                    "Super expression must either be null or a function"
                );
            if (void 0 !== t) {
                if (t.has(e)) return t.get(e);
                t.set(e, r);
            }
            function r() {
                return Be(e, arguments, Pe(this).constructor);
            }
            return (
                (r.prototype = Object.create(e.prototype, {
                    constructor: {
                        value: r,
                        enumerable: !1,
                        writable: !0,
                        configurable: !0,
                    },
                })),
                Oe(r, e)
            );
        })(e);
    }
    function ze(e) {
        if (void 0 === e)
            throw new ReferenceError(
                "this hasn't been initialised - super() hasn't been called"
            );
        return e;
    }
    (xe.prototype[
        ("function" == typeof Symbol && Symbol.asyncIterator) ||
            "@@asyncIterator"
    ] = function () {
        return this;
    }),
        (xe.prototype.next = function (e) {
            return this._invoke("next", e);
        }),
        (xe.prototype.throw = function (e) {
            return this._invoke("throw", e);
        }),
        (xe.prototype.return = function (e) {
            return this._invoke("return", e);
        });
    var Re = 0;
    function Ae(e, t) {
        void 0 === e && (e = "xxxxxxxxxx"),
            void 0 === t && (t = "0123456789abcdef");
        var a = t.length;
        return e.replace(/x/g, function () {
            return t[Math.floor(Math.random() * a)];
        });
    }
    var De =
            '\n  <span class="preloader-inner">\n    <svg viewBox="0 0 36 36">\n      <circle cx="18" cy="18" r="16"></circle>\n    </svg>\n  </span>\n'.trim(),
        He = (
            '\n  <span class="preloader-inner">\n    ' +
            [0, 1, 2, 3, 4, 5, 6, 7]
                .map(function () {
                    return '<span class="preloader-inner-line"></span>';
                })
                .join("") +
            "\n  </span>\n"
        ).trim(),
        Ne =
            '\n  <span class="preloader-inner">\n    <span class="preloader-inner-circle"></span>\n  </span>\n';
    function Ve(e) {
        var t;
        return e
            .split("")
            .map(function (e, a) {
                return e.match(/[A-Z]/) && 0 !== a && !t
                    ? ((t = !0), ":" + e.toLowerCase())
                    : e.toLowerCase();
            })
            .join("");
    }
    function Fe(e) {
        var t = e;
        Object.keys(t).forEach(function (e) {
            try {
                t[e] = null;
            } catch (e) {}
            try {
                delete t[e];
            } catch (e) {}
        });
    }
    function qe(e) {
        return o().requestAnimationFrame(e);
    }
    function je(e, t) {
        return void 0 === t && (t = 0), setTimeout(e, t);
    }
    function _e(e) {
        return qe(function () {
            qe(e);
        });
    }
    function Ye() {
        return Date.now();
    }
    function We(e) {
        var t,
            a,
            r,
            n,
            i = o(),
            s = {},
            l = e || i.location.href;
        if ("string" == typeof l && l.length)
            for (
                n = (a = (l = l.indexOf("?") > -1 ? l.replace(/\S*\?/, "") : "")
                    .split("&")
                    .filter(function (e) {
                        return "" !== e;
                    })).length,
                    t = 0;
                t < n;
                t += 1
            )
                (r = a[t].replace(/#\S+/g, "").split("=")),
                    (s[decodeURIComponent(r[0])] =
                        void 0 === r[1]
                            ? void 0
                            : decodeURIComponent(r.slice(1).join("=")) || "");
        return s;
    }
    function Xe(e, t) {
        void 0 === t && (t = "x");
        var a,
            r,
            n,
            i = o(),
            s = i.getComputedStyle(e, null);
        return (
            i.WebKitCSSMatrix
                ? ((r = s.transform || s.webkitTransform).split(",").length >
                      6 &&
                      (r = r
                          .split(", ")
                          .map(function (e) {
                              return e.replace(",", ".");
                          })
                          .join(", ")),
                  (n = new i.WebKitCSSMatrix("none" === r ? "" : r)))
                : (a = (n =
                      s.MozTransform ||
                      s.OTransform ||
                      s.MsTransform ||
                      s.msTransform ||
                      s.transform ||
                      s
                          .getPropertyValue("transform")
                          .replace("translate(", "matrix(1, 0, 0, 1,"))
                      .toString()
                      .split(",")),
            "x" === t &&
                (r = i.WebKitCSSMatrix
                    ? n.m41
                    : 16 === a.length
                    ? parseFloat(a[12])
                    : parseFloat(a[4])),
            "y" === t &&
                (r = i.WebKitCSSMatrix
                    ? n.m42
                    : 16 === a.length
                    ? parseFloat(a[13])
                    : parseFloat(a[5])),
            r || 0
        );
    }
    function Ge(e, t) {
        if ((void 0 === t && (t = []), "string" == typeof e)) return e;
        var a,
            r = [];
        function n(e) {
            if (t.length > 0) {
                for (var a = "", r = 0; r < t.length; r += 1)
                    a += 0 === r ? t[r] : "[" + encodeURIComponent(t[r]) + "]";
                return a + "[" + encodeURIComponent(e) + "]";
            }
            return encodeURIComponent(e);
        }
        function o(e) {
            return encodeURIComponent(e);
        }
        return (
            Object.keys(e).forEach(function (i) {
                var s;
                if (Array.isArray(e[i])) {
                    s = [];
                    for (var l = 0; l < e[i].length; l += 1)
                        Array.isArray(e[i][l]) || "object" != typeof e[i][l]
                            ? s.push(n(i) + "[]=" + o(e[i][l]))
                            : ((a = t.slice()).push(i),
                              a.push(String(l)),
                              s.push(Ge(e[i][l], a)));
                    s.length > 0 && r.push(s.join("&"));
                } else null === e[i] || "" === e[i] ? r.push(n(i) + "=") : "object" == typeof e[i] ? ((a = t.slice()).push(i), "" !== (s = Ge(e[i], a)) && r.push(s)) : void 0 !== e[i] && "" !== e[i] ? r.push(n(i) + "=" + o(e[i])) : "" === e[i] && r.push(n(i));
            }),
            r.join("&")
        );
    }
    function Ue(e) {
        return (
            "object" == typeof e &&
            null !== e &&
            e.constructor &&
            e.constructor === Object
        );
    }
    function Ke() {
        for (var e = arguments.length, t = new Array(e), a = 0; a < e; a++)
            t[a] = arguments[a];
        var r = t[0];
        t.splice(0, 1);
        for (var n = t, o = 0; o < n.length; o += 1) {
            var i = t[o];
            if (null != i)
                for (
                    var s = Object.keys(Object(i)), l = 0, c = s.length;
                    l < c;
                    l += 1
                ) {
                    var p = s[l],
                        d = Object.getOwnPropertyDescriptor(i, p);
                    void 0 !== d && d.enumerable && (r[p] = i[p]);
                }
        }
        return r;
    }
    function Qe() {
        for (
            var e, t, a = !0, r = arguments.length, n = new Array(r), o = 0;
            o < r;
            o++
        )
            n[o] = arguments[o];
        "boolean" == typeof n[0]
            ? ((a = n[0]), (e = n[1]), n.splice(0, 2), (t = n))
            : ((e = n[0]), n.splice(0, 1), (t = n));
        for (var i = 0; i < t.length; i += 1) {
            var s = n[i];
            if (null != s)
                for (
                    var l = Object.keys(Object(s)), c = 0, p = l.length;
                    c < p;
                    c += 1
                ) {
                    var d = l[c],
                        u = Object.getOwnPropertyDescriptor(s, d);
                    void 0 !== u &&
                        u.enumerable &&
                        (a
                            ? Ue(e[d]) && Ue(s[d])
                                ? Qe(e[d], s[d])
                                : !Ue(e[d]) && Ue(s[d])
                                ? ((e[d] = {}), Qe(e[d], s[d]))
                                : (e[d] = s[d])
                            : (e[d] = s[d]));
                }
        }
        return e;
    }
    function Je(e) {
        var t = e.replace(
                /^#?([a-f\d])([a-f\d])([a-f\d])$/i,
                function (e, t, a, r) {
                    return t + t + a + a + r + r;
                }
            ),
            a = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(t);
        return a
            ? a.slice(1).map(function (e) {
                  return parseInt(e, 16);
              })
            : null;
    }
    function Ze(e, t, a) {
        return (
            "#" +
            [e, t, a]
                .map(function (e) {
                    var t = e.toString(16);
                    return 1 === t.length ? "0" + t : t;
                })
                .join("")
        );
    }
    function et(e, t, a) {
        (e /= 255), (t /= 255), (a /= 255);
        var r,
            n = Math.max(e, t, a),
            o = Math.min(e, t, a),
            i = n - o;
        0 === i
            ? (r = 0)
            : n === e
            ? (r = ((t - a) / i) % 6)
            : n === t
            ? (r = (a - e) / i + 2)
            : n === a && (r = (e - t) / i + 4);
        var s = (o + n) / 2;
        return (
            r < 0 && (r = 6 + r),
            [60 * r, 0 === i ? 0 : i / (1 - Math.abs(2 * s - 1)), s]
        );
    }
    function tt(e, t, a) {
        var r,
            n = (1 - Math.abs(2 * a - 1)) * t,
            o = e / 60,
            i = n * (1 - Math.abs((o % 2) - 1));
        Number.isNaN(e) || void 0 === e
            ? (r = [0, 0, 0])
            : o <= 1
            ? (r = [n, i, 0])
            : o <= 2
            ? (r = [i, n, 0])
            : o <= 3
            ? (r = [0, n, i])
            : o <= 4
            ? (r = [0, i, n])
            : o <= 5
            ? (r = [i, 0, n])
            : o <= 6 && (r = [n, 0, i]);
        var s = a - n / 2;
        return r.map(function (e) {
            return Math.max(0, Math.min(255, Math.round(255 * (e + s))));
        });
    }
    function at(e, t, a) {
        var r = { h: e, s: 0, l: 0 },
            n = t,
            o = a;
        return (
            (r.l = ((2 - n) * o) / 2),
            (r.s =
                r.l && r.l < 1
                    ? (n * o) / (r.l < 0.5 ? 2 * r.l : 2 - 2 * r.l)
                    : r.s),
            [r.h, r.s, r.l]
        );
    }
    function rt(e, t, a) {
        var r = { h: e, s: 0, b: 0 },
            n = a,
            o = t * (n < 0.5 ? n : 1 - n);
        return (
            (r.b = n + o), (r.s = n > 0 ? (2 * o) / r.b : r.s), [r.h, r.s, r.b]
        );
    }
    function nt(e, t) {
        Object.keys(t).forEach(function (a) {
            Ue(t[a]) &&
                Object.keys(t[a]).forEach(function (r) {
                    "function" == typeof t[a][r] && (t[a][r] = t[a][r].bind(e));
                }),
                (e[a] = t[a]);
        });
    }
    function ot() {
        for (
            var e = [], t = arguments.length, a = new Array(t), r = 0;
            r < t;
            r++
        )
            a[r] = arguments[r];
        return (
            a.forEach(function (t) {
                Array.isArray(t)
                    ? e.push.apply(e, ot.apply(void 0, t))
                    : e.push(t);
            }),
            e
        );
    }
    var it,
        st,
        lt = Object.freeze({
            __proto__: null,
            uniqueNumber: function () {
                return (Re += 1);
            },
            id: Ae,
            mdPreloaderContent: De,
            iosPreloaderContent: He,
            auroraPreloaderContent: Ne,
            eventNameToColonCase: Ve,
            deleteProps: Fe,
            requestAnimationFrame: qe,
            cancelAnimationFrame: function (e) {
                return o().cancelAnimationFrame(e);
            },
            nextTick: je,
            nextFrame: _e,
            now: Ye,
            parseUrlQuery: We,
            getTranslate: Xe,
            serializeObject: Ge,
            isObject: Ue,
            merge: Ke,
            extend: Qe,
            colorHexToRgb: Je,
            colorRgbToHex: Ze,
            colorRgbToHsl: et,
            colorHslToRgb: tt,
            colorHsbToHsl: at,
            colorHslToHsb: rt,
            colorThemeCSSProperties: function () {
                for (
                    var e, t, a = arguments.length, r = new Array(a), n = 0;
                    n < a;
                    n++
                )
                    r[n] = arguments[n];
                if (
                    (1 === r.length
                        ? (t = Je((e = r[0])))
                        : 3 === r.length &&
                          ((t = r), (e = Ze.apply(void 0, t))),
                    !t)
                )
                    return {};
                var o = et.apply(void 0, t),
                    i = [o[0], o[1], Math.max(0, o[2] - 0.08)],
                    s = [o[0], o[1], Math.max(0, o[2] + 0.08)],
                    l = Ze.apply(void 0, tt.apply(void 0, i)),
                    c = Ze.apply(void 0, tt.apply(void 0, s));
                return {
                    "--f7-theme-color": e,
                    "--f7-theme-color-rgb": t.join(", "),
                    "--f7-theme-color-shade": l,
                    "--f7-theme-color-tint": c,
                };
            },
            bindMethods: nt,
            flattenArray: ot,
        });
    function ct() {
        return (
            it ||
                (it = (function () {
                    var e = o(),
                        t = r();
                    return {
                        touch: !!(
                            "ontouchstart" in e ||
                            (e.DocumentTouch && t instanceof e.DocumentTouch)
                        ),
                        pointerEvents:
                            !!e.PointerEvent &&
                            "maxTouchPoints" in e.navigator &&
                            e.navigator.maxTouchPoints >= 0,
                        passiveListener: (function () {
                            var t = !1;
                            try {
                                var a = Object.defineProperty({}, "passive", {
                                    get: function () {
                                        t = !0;
                                    },
                                });
                                e.addEventListener(
                                    "testPassiveListener",
                                    null,
                                    a
                                );
                            } catch (e) {}
                            return t;
                        })(),
                        intersectionObserver: "IntersectionObserver" in e,
                    };
                })()),
            it
        );
    }
    function pt(e, t) {
        return (
            void 0 === e && (e = {}),
            (st && !t) ||
                (st = (function (e) {
                    var t = (void 0 === e ? {} : e).userAgent,
                        a = ct(),
                        r = o(),
                        n = r.navigator.platform,
                        i = t || r.navigator.userAgent,
                        s = {
                            ios: !1,
                            android: !1,
                            androidChrome: !1,
                            desktop: !1,
                            iphone: !1,
                            ipod: !1,
                            ipad: !1,
                            edge: !1,
                            ie: !1,
                            firefox: !1,
                            macos: !1,
                            windows: !1,
                            cordova: !(!r.cordova && !r.phonegap),
                            phonegap: !(!r.cordova && !r.phonegap),
                            electron: !1,
                            capacitor: !!r.Capacitor,
                            nwjs: !1,
                        },
                        l = r.screen.width,
                        c = r.screen.height,
                        p = i.match(/(Android);?[\s\/]+([\d.]+)?/),
                        d = i.match(/(iPad).*OS\s([\d_]+)/),
                        u = i.match(/(iPod)(.*OS\s([\d_]+))?/),
                        h =
                            !d &&
                            i.match(
                                /(iPhone\sOS|iOS|iPhone;\sCPU\sOS)\s([\d_]+)/
                            ),
                        f =
                            i.indexOf("MSIE ") >= 0 ||
                            i.indexOf("Trident/") >= 0,
                        v = i.indexOf("Edge/") >= 0,
                        m =
                            i.indexOf("Gecko/") >= 0 &&
                            i.indexOf("Firefox/") >= 0,
                        g = "Win32" === n,
                        b = i.toLowerCase().indexOf("electron") >= 0,
                        y =
                            "undefined" != typeof nw &&
                            "undefined" != typeof process &&
                            void 0 !== process.versions &&
                            void 0 !== process.versions.nw,
                        w = "MacIntel" === n;
                    return (
                        !d &&
                            w &&
                            a.touch &&
                            [
                                "1024x1366",
                                "1366x1024",
                                "834x1194",
                                "1194x834",
                                "834x1112",
                                "1112x834",
                                "768x1024",
                                "1024x768",
                                "820x1180",
                                "1180x820",
                                "810x1080",
                                "1080x810",
                            ].indexOf(l + "x" + c) >= 0 &&
                            ((d = i.match(/(Version)\/([\d.]+)/)) ||
                                (d = [0, 1, "13_0_0"]),
                            (w = !1)),
                        (s.ie = f),
                        (s.edge = v),
                        (s.firefox = m),
                        p &&
                            ((s.os = "android"),
                            (s.osVersion = p[2]),
                            (s.android = !0),
                            (s.androidChrome =
                                i.toLowerCase().indexOf("chrome") >= 0)),
                        (d || h || u) && ((s.os = "ios"), (s.ios = !0)),
                        h &&
                            !u &&
                            ((s.osVersion = h[2].replace(/_/g, ".")),
                            (s.iphone = !0)),
                        d &&
                            ((s.osVersion = d[2].replace(/_/g, ".")),
                            (s.ipad = !0)),
                        u &&
                            ((s.osVersion = u[3]
                                ? u[3].replace(/_/g, ".")
                                : null),
                            (s.ipod = !0)),
                        s.ios &&
                            s.osVersion &&
                            i.indexOf("Version/") >= 0 &&
                            "10" === s.osVersion.split(".")[0] &&
                            (s.osVersion = i
                                .toLowerCase()
                                .split("version/")[1]
                                .split(" ")[0]),
                        (s.webView =
                            !(
                                !(h || d || u) ||
                                (!i.match(/.*AppleWebKit(?!.*Safari)/i) &&
                                    !r.navigator.standalone)
                            ) ||
                            (r.matchMedia &&
                                r.matchMedia("(display-mode: standalone)")
                                    .matches)),
                        (s.webview = s.webView),
                        (s.standalone = s.webView),
                        (s.desktop = !(s.ios || s.android) || b || y),
                        s.desktop &&
                            ((s.electron = b),
                            (s.nwjs = y),
                            (s.macos = w),
                            (s.windows = g),
                            s.macos && (s.os = "macos"),
                            s.windows && (s.os = "windows")),
                        (s.pixelRatio = r.devicePixelRatio || 1),
                        (s.prefersColorScheme = function () {
                            var e;
                            return (
                                r.matchMedia &&
                                    r.matchMedia(
                                        "(prefers-color-scheme: light)"
                                    ).matches &&
                                    (e = "light"),
                                r.matchMedia &&
                                    r.matchMedia("(prefers-color-scheme: dark)")
                                        .matches &&
                                    (e = "dark"),
                                e
                            );
                        }),
                        s
                    );
                })(e)),
            st
        );
    }
    var dt = (function () {
            function e(e) {
                void 0 === e && (e = []);
                (this.eventsParents = e), (this.eventsListeners = {});
            }
            var t = e.prototype;
            return (
                (t.on = function (e, t, a) {
                    var r = this;
                    if ("function" != typeof t) return r;
                    var n = a ? "unshift" : "push";
                    return (
                        e.split(" ").forEach(function (e) {
                            r.eventsListeners[e] || (r.eventsListeners[e] = []),
                                r.eventsListeners[e][n](t);
                        }),
                        r
                    );
                }),
                (t.once = function (e, t, a) {
                    var r = this;
                    if ("function" != typeof t) return r;
                    function n() {
                        r.off(e, n), n.f7proxy && delete n.f7proxy;
                        for (
                            var a = arguments.length, o = new Array(a), i = 0;
                            i < a;
                            i++
                        )
                            o[i] = arguments[i];
                        t.apply(r, o);
                    }
                    return (n.f7proxy = t), r.on(e, n, a);
                }),
                (t.off = function (e, t) {
                    var a = this;
                    return a.eventsListeners
                        ? (e.split(" ").forEach(function (e) {
                              void 0 === t
                                  ? (a.eventsListeners[e] = [])
                                  : a.eventsListeners[e] &&
                                    a.eventsListeners[e].forEach(function (
                                        r,
                                        n
                                    ) {
                                        (r === t ||
                                            (r.f7proxy && r.f7proxy === t)) &&
                                            a.eventsListeners[e].splice(n, 1);
                                    });
                          }),
                          a)
                        : a;
                }),
                (t.emit = function () {
                    var e,
                        t,
                        a,
                        r,
                        n = this;
                    if (!n.eventsListeners) return n;
                    for (
                        var o = arguments.length, i = new Array(o), s = 0;
                        s < o;
                        s++
                    )
                        i[s] = arguments[s];
                    "string" == typeof i[0] || Array.isArray(i[0])
                        ? ((e = i[0]),
                          (t = i.slice(1, i.length)),
                          (a = n),
                          (r = n.eventsParents))
                        : ((e = i[0].events),
                          (t = i[0].data),
                          (a = i[0].context || n),
                          (r = i[0].local
                              ? []
                              : i[0].parents || n.eventsParents));
                    var l = Array.isArray(e) ? e : e.split(" "),
                        c = l.map(function (e) {
                            return e.replace("local::", "");
                        }),
                        p = l.filter(function (e) {
                            return e.indexOf("local::") < 0;
                        });
                    return (
                        c.forEach(function (e) {
                            if (n.eventsListeners && n.eventsListeners[e]) {
                                var r = [];
                                n.eventsListeners[e].forEach(function (e) {
                                    r.push(e);
                                }),
                                    r.forEach(function (e) {
                                        e.apply(a, t);
                                    });
                            }
                        }),
                        r &&
                            r.length > 0 &&
                            r.forEach(function (e) {
                                e.emit.apply(e, [p].concat(t));
                            }),
                        n
                    );
                }),
                e
            );
        })(),
        ut = (function (e) {
            function t(t, a) {
                var r;
                void 0 === t && (t = {}), void 0 === a && (a = []);
                var n = ze((r = e.call(this, a) || this));
                return (
                    (n.params = t),
                    n.params &&
                        n.params.on &&
                        Object.keys(n.params.on).forEach(function (e) {
                            n.on(e, n.params.on[e]);
                        }),
                    r
                );
            }
            Me(t, e);
            var a = t.prototype;
            return (
                (a.useModuleParams = function (e, t) {
                    if (e.params) {
                        var a = {};
                        Object.keys(e.params).forEach(function (e) {
                            void 0 !== t[e] && (a[e] = Qe({}, t[e]));
                        }),
                            Qe(t, e.params),
                            Object.keys(a).forEach(function (e) {
                                Qe(t[e], a[e]);
                            });
                    }
                }),
                (a.useModulesParams = function (e) {
                    var t = this;
                    t.modules &&
                        Object.keys(t.modules).forEach(function (a) {
                            var r = t.modules[a];
                            r.params && Qe(e, r.params);
                        });
                }),
                (a.useModule = function (e, t) {
                    void 0 === e && (e = ""), void 0 === t && (t = {});
                    var a = this;
                    if (a.modules) {
                        var r = "string" == typeof e ? a.modules[e] : e;
                        r &&
                            (r.instance &&
                                Object.keys(r.instance).forEach(function (e) {
                                    var t = r.instance[e];
                                    a[e] =
                                        "function" == typeof t ? t.bind(a) : t;
                                }),
                            r.on &&
                                a.on &&
                                Object.keys(r.on).forEach(function (e) {
                                    a.on(e, r.on[e]);
                                }),
                            r.vnode &&
                                (a.vnodeHooks || (a.vnodeHooks = {}),
                                Object.keys(r.vnode).forEach(function (e) {
                                    Object.keys(r.vnode[e]).forEach(function (
                                        t
                                    ) {
                                        var n = r.vnode[e][t];
                                        a.vnodeHooks[t] ||
                                            (a.vnodeHooks[t] = {}),
                                            a.vnodeHooks[t][e] ||
                                                (a.vnodeHooks[t][e] = []),
                                            a.vnodeHooks[t][e].push(n.bind(a));
                                    });
                                })),
                            r.create && r.create.bind(a)(t));
                    }
                }),
                (a.useModules = function (e) {
                    void 0 === e && (e = {});
                    var t = this;
                    t.modules &&
                        Object.keys(t.modules).forEach(function (a) {
                            var r = e[a] || {};
                            t.useModule(a, r);
                        });
                }),
                (t.installModule = function (e) {
                    var t = this;
                    t.prototype.modules || (t.prototype.modules = {});
                    var a =
                        e.name ||
                        Object.keys(t.prototype.modules).length + "_" + Ye();
                    if (
                        ((t.prototype.modules[a] = e),
                        e.proto &&
                            Object.keys(e.proto).forEach(function (a) {
                                t.prototype[a] = e.proto[a];
                            }),
                        e.static &&
                            Object.keys(e.static).forEach(function (a) {
                                t[a] = e.static[a];
                            }),
                        e.install)
                    ) {
                        for (
                            var r = arguments.length,
                                n = new Array(r > 1 ? r - 1 : 0),
                                o = 1;
                            o < r;
                            o++
                        )
                            n[o - 1] = arguments[o];
                        e.install.apply(t, n);
                    }
                    return t;
                }),
                (t.use = function (e) {
                    var t = this;
                    if (Array.isArray(e))
                        return (
                            e.forEach(function (e) {
                                return t.installModule(e);
                            }),
                            t
                        );
                    for (
                        var a = arguments.length,
                            r = new Array(a > 1 ? a - 1 : 0),
                            n = 1;
                        n < a;
                        n++
                    )
                        r[n - 1] = arguments[n];
                    return t.installModule.apply(t, [e].concat(r));
                }),
                Te(t, null, [
                    {
                        key: "components",
                        set: function (e) {
                            this.use && this.use(e);
                        },
                    },
                ]),
                t
            );
        })(dt);
    function ht(e) {
        void 0 === e && (e = {});
        var t = e,
            a = t.defaultSelector,
            r = t.constructor,
            n = t.domProp,
            o = t.app,
            i = t.addMethods,
            s = {
                create: function () {
                    for (
                        var e = arguments.length, t = new Array(e), a = 0;
                        a < e;
                        a++
                    )
                        t[a] = arguments[a];
                    return Be(r, o ? [o].concat(t) : t);
                },
                get: function (e) {
                    if ((void 0 === e && (e = a), e instanceof r)) return e;
                    var t = Ee(e);
                    return 0 !== t.length ? t[0][n] : void 0;
                },
                destroy: function (e) {
                    var t = s.get(e);
                    if (t && t.destroy) return t.destroy();
                },
            };
        return (
            i &&
                Array.isArray(i) &&
                i.forEach(function (e) {
                    s[e] = function (t) {
                        void 0 === t && (t = a);
                        for (
                            var r = s.get(t),
                                n = arguments.length,
                                o = new Array(n > 1 ? n - 1 : 0),
                                i = 1;
                            i < n;
                            i++
                        )
                            o[i - 1] = arguments[i];
                        if (r && r[e]) return r[e].apply(r, o);
                    };
                }),
            s
        );
    }
    function ft(e) {
        void 0 === e && (e = {});
        var t = e,
            a = t.defaultSelector,
            r = t.constructor,
            n = t.app;
        return Qe(
            ht({
                defaultSelector: a,
                constructor: r,
                app: n,
                domProp: "f7Modal",
            }),
            {
                open: function (e, t, a) {
                    var o = Ee(e);
                    if (o.length > 1 && a) {
                        var i = Ee(a).parents(".page");
                        i.length &&
                            o.each(function (e) {
                                var t = Ee(e);
                                t.parents(i)[0] === i[0] && (o = t);
                            });
                    }
                    if ((o.length > 1 && (o = o.eq(o.length - 1)), o.length)) {
                        var s = o[0].f7Modal;
                        if (!s) {
                            var l = o.dataset();
                            s = new r(n, Se({ el: o }, l));
                        }
                        return s.open(t);
                    }
                },
                close: function (e, t, o) {
                    void 0 === e && (e = a);
                    var i = Ee(e);
                    if (i.length) {
                        if (i.length > 1) {
                            var s;
                            if (o) {
                                var l = Ee(o);
                                l.length && (s = l.parents(i));
                            }
                            i = s && s.length > 0 ? s : i.eq(i.length - 1);
                        }
                        var c = i[0].f7Modal;
                        if (!c) {
                            var p = i.dataset();
                            c = new r(n, Se({ el: i }, p));
                        }
                        return c.close(t);
                    }
                },
            }
        );
    }
    var vt = [];
    var mt = (function (e) {
        function t(a) {
            var n;
            if (
                (void 0 === a && (a = {}),
                (n = e.call(this, a) || this),
                t.instance && "undefined" != typeof window)
            )
                throw new Error(
                    "Framework7 is already initialized and can't be initialized more than once"
                );
            var i = pt({ userAgent: a.userAgent || void 0 }),
                s = ct(),
                l = Qe({}, a),
                c = ze(n);
            (c.device = i), (c.support = s);
            var p = o(),
                d = r();
            t.instance = c;
            var u = {
                version: "1.0.0",
                id: "io.framework7.myapp",
                el: "body",
                theme: "auto",
                language: p.navigator.language,
                routes: [],
                name: "Framework7",
                lazyModulesPath: null,
                initOnDeviceReady: !0,
                init: !0,
                autoDarkTheme: !1,
                iosTranslucentBars: !0,
                iosTranslucentModals: !0,
                component: void 0,
                componentUrl: void 0,
                userAgent: null,
                url: null,
            };
            return (
                c.useModulesParams(u),
                (c.params = Qe(u, a)),
                Qe(c, {
                    id: c.params.id,
                    name: c.params.name,
                    version: c.params.version,
                    routes: c.params.routes,
                    language: c.params.language,
                    theme:
                        "auto" === c.params.theme
                            ? i.ios
                                ? "ios"
                                : i.desktop && i.electron
                                ? "aurora"
                                : "md"
                            : c.params.theme,
                    passedParams: l,
                    online: p.navigator.onLine,
                }),
                a.store && (c.params.store = a.store),
                c.$el && c.$el[0] && (c.$el[0].f7 = c),
                c.useModules(),
                c.initStore(),
                c.params.init &&
                    (i.cordova && c.params.initOnDeviceReady
                        ? Ee(d).on("deviceready", function () {
                              c.init();
                          })
                        : c.init()),
                c || ze(n)
            );
        }
        Me(t, e);
        var a = t.prototype;
        return (
            (a.mount = function (e) {
                var t = this,
                    a = o(),
                    n = r(),
                    i = Ee(e || t.params.el).eq(0);
                (t.$el = i),
                    t.$el &&
                        t.$el[0] &&
                        ((t.el = t.$el[0]),
                        (t.el.f7 = t),
                        (t.rtl = "rtl" === i.css("direction")));
                var s = "(prefers-color-scheme: dark)",
                    l = "(prefers-color-scheme: light)";
                (t.mq = {}),
                    a.matchMedia &&
                        ((t.mq.dark = a.matchMedia(s)),
                        (t.mq.light = a.matchMedia(l))),
                    (t.colorSchemeListener = function (e) {
                        var a = e.matches,
                            r = e.media;
                        if (a) {
                            var o = n.querySelector("html");
                            r === s
                                ? (o.classList.add("theme-dark"),
                                  (t.darkTheme = !0),
                                  t.emit("darkThemeChange", !0))
                                : r === l &&
                                  (o.classList.remove("theme-dark"),
                                  (t.darkTheme = !1),
                                  t.emit("darkThemeChange", !1));
                        }
                    }),
                    t.emit("mount");
            }),
            (a.initStore = function () {
                var e = this;
                void 0 !== e.params.store && e.params.store.__store
                    ? (e.store = e.params.store)
                    : (e.store = e.createStore(e.params.store));
            }),
            (a.enableAutoDarkTheme = function () {
                var e = o(),
                    t = r();
                if (e.matchMedia) {
                    var a = this,
                        n = t.querySelector("html");
                    a.mq.dark &&
                        a.mq.light &&
                        (a.mq.dark.addListener(a.colorSchemeListener),
                        a.mq.light.addListener(a.colorSchemeListener)),
                        a.mq.dark && a.mq.dark.matches
                            ? (n.classList.add("theme-dark"),
                              (a.darkTheme = !0),
                              a.emit("darkThemeChange", !0))
                            : a.mq.light &&
                              a.mq.light.matches &&
                              (n.classList.remove("theme-dark"),
                              (a.darkTheme = !1),
                              a.emit("darkThemeChange", !1));
                }
            }),
            (a.disableAutoDarkTheme = function () {
                if (o().matchMedia) {
                    var e = this;
                    e.mq.dark &&
                        e.mq.dark.removeListener(e.colorSchemeListener),
                        e.mq.light &&
                            e.mq.light.removeListener(e.colorSchemeListener);
                }
            }),
            (a.initAppComponent = function (e) {
                var t = this;
                t.router.componentLoader(
                    t.params.component,
                    t.params.componentUrl,
                    { componentOptions: { el: t.$el[0] } },
                    function (a) {
                        (t.$el = Ee(a)),
                            (t.$el[0].f7 = t),
                            (t.$elComponent = a.f7Component),
                            (t.el = t.$el[0]),
                            e && e();
                    },
                    function () {}
                );
            }),
            (a.init = function (e) {
                var t = this;
                t.mount(e);
                var a = function () {
                    if (!t.initialized) {
                        t.$el.addClass("framework7-initializing"),
                            t.rtl && Ee("html").attr("dir", "rtl"),
                            t.params.autoDarkTheme && t.enableAutoDarkTheme();
                        var e = o();
                        e.addEventListener("offline", function () {
                            (t.online = !1),
                                t.emit("offline"),
                                t.emit("connection", !1);
                        }),
                            e.addEventListener("online", function () {
                                (t.online = !0),
                                    t.emit("online"),
                                    t.emit("connection", !0);
                            }),
                            t.$el.addClass("framework7-root"),
                            Ee("html")
                                .removeClass("ios md aurora")
                                .addClass(t.theme);
                        var a = t.device;
                        t.params.iosTranslucentBars &&
                            "ios" === t.theme &&
                            a.ios &&
                            Ee("html").addClass("ios-translucent-bars"),
                            t.params.iosTranslucentModals &&
                                "ios" === t.theme &&
                                a.ios &&
                                Ee("html").addClass("ios-translucent-modals"),
                            _e(function () {
                                t.$el.removeClass("framework7-initializing");
                            }),
                            (t.initialized = !0),
                            t.emit("init");
                    }
                };
                return (
                    t.params.component || t.params.componentUrl
                        ? t.initAppComponent(function () {
                              a();
                          })
                        : a(),
                    t
                );
            }),
            (a.loadModule = function () {
                return t.loadModule.apply(t, arguments);
            }),
            (a.loadModules = function () {
                return t.loadModules.apply(t, arguments);
            }),
            (a.getVnodeHooks = function (e, t) {
                var a = this;
                return (
                    (a.vnodeHooks && a.vnodeHooks[e] && a.vnodeHooks[e][t]) ||
                    []
                );
            }),
            Te(
                t,
                [
                    {
                        key: "$",
                        get: function () {
                            return Ee;
                        },
                    },
                ],
                [
                    {
                        key: "Dom7",
                        get: function () {
                            return Ee;
                        },
                    },
                    {
                        key: "$",
                        get: function () {
                            return Ee;
                        },
                    },
                    {
                        key: "device",
                        get: function () {
                            return pt();
                        },
                    },
                    {
                        key: "support",
                        get: function () {
                            return ct();
                        },
                    },
                    {
                        key: "Class",
                        get: function () {
                            return ut;
                        },
                    },
                    {
                        key: "Events",
                        get: function () {
                            return dt;
                        },
                    },
                ]
            ),
            t
        );
    })(ut);
    (mt.ModalMethods = ft),
        (mt.ConstructorMethods = ht),
        (mt.loadModule = function (e) {
            var t = this,
                a = o(),
                n = r();
            return new Promise(function (r, o) {
                var i,
                    s,
                    l,
                    c = t.instance;
                if (e) {
                    if ("string" == typeof e) {
                        var p = e.match(/([a-z0-9-]*)/i);
                        if (
                            e.indexOf(".") < 0 &&
                            p &&
                            p[0].length === e.length
                        ) {
                            if (!c || (c && !c.params.lazyModulesPath))
                                return void o(
                                    new Error(
                                        'Framework7: "lazyModulesPath" app parameter must be specified to fetch module by name'
                                    )
                                );
                            i =
                                c.params.lazyModulesPath +
                                "/" +
                                e +
                                "/" +
                                e +
                                ".js";
                        } else i = e;
                    } else "function" == typeof e ? (l = e) : (s = e);
                    if (l) {
                        var d = l(t, !1);
                        if (!d)
                            return void o(
                                new Error(
                                    "Framework7: Can't find Framework7 component in specified component function"
                                )
                            );
                        if (t.prototype.modules && t.prototype.modules[d.name])
                            return void r();
                        v(d), r();
                    }
                    if (s) {
                        var u = s;
                        if (!u)
                            return void o(
                                new Error(
                                    "Framework7: Can't find Framework7 component in specified component"
                                )
                            );
                        if (t.prototype.modules && t.prototype.modules[u.name])
                            return void r();
                        v(u), r();
                    }
                    if (i) {
                        if (vt.indexOf(i) >= 0) return void r();
                        vt.push(i);
                        var h = new Promise(function (e, r) {
                                t.request.get(
                                    i,
                                    function (o) {
                                        var s =
                                                "f7_component_loader_callback_" +
                                                Ae(),
                                            l = n.createElement("script");
                                        (l.innerHTML =
                                            "window." +
                                            s +
                                            " = function (Framework7, Framework7AutoInstallComponent) {return " +
                                            o.trim() +
                                            "}"),
                                            Ee("head").append(l);
                                        var c = a[s];
                                        delete a[s], Ee(l).remove();
                                        var p = c(t, !1);
                                        p
                                            ? ((t.prototype.modules &&
                                                  t.prototype.modules[
                                                      p.name
                                                  ]) ||
                                                  v(p),
                                              e())
                                            : r(
                                                  new Error(
                                                      "Framework7: Can't find Framework7 component in " +
                                                          i +
                                                          " file"
                                                  )
                                              );
                                    },
                                    function (e, t) {
                                        r(e, t);
                                    }
                                );
                            }),
                            f = new Promise(function (e) {
                                t.request.get(
                                    i.replace(
                                        ".js",
                                        c.rtl ? ".rtl.css" : ".css"
                                    ),
                                    function (t) {
                                        var a = n.createElement("style");
                                        (a.innerHTML = t),
                                            Ee("head").append(a),
                                            e();
                                    },
                                    function () {
                                        e();
                                    }
                                );
                            });
                        Promise.all([h, f])
                            .then(function () {
                                r();
                            })
                            .catch(function (e) {
                                o(e);
                            });
                    }
                } else
                    o(new Error("Framework7: Lazy module must be specified"));
                function v(e) {
                    t.use(e),
                        c && (c.useModuleParams(e, c.params), c.useModule(e));
                }
            });
        }),
        (mt.loadModules = function (e) {
            return Promise.all(
                e.map(function (e) {
                    return mt.loadModule(e);
                })
            );
        });
    var gt = {
            name: "device",
            static: { getDevice: pt },
            on: {
                init: function () {
                    var e = r(),
                        t = pt(),
                        a = [],
                        n = e.querySelector("html"),
                        o = e.querySelector(
                            'meta[name="apple-mobile-web-app-status-bar-style"]'
                        );
                    n &&
                        (t.standalone &&
                            t.ios &&
                            o &&
                            "black-translucent" === o.content &&
                            a.push("device-full-viewport"),
                        a.push(
                            "device-pixel-ratio-" + Math.floor(t.pixelRatio)
                        ),
                        t.os && !t.desktop
                            ? a.push("device-" + t.os)
                            : t.desktop &&
                              (a.push("device-desktop"),
                              t.os && a.push("device-" + t.os)),
                        (t.cordova || t.phonegap) && a.push("device-cordova"),
                        t.capacitor && a.push("device-capacitor"),
                        a.forEach(function (e) {
                            n.classList.add(e);
                        }));
                },
            },
        },
        bt = { name: "support", static: { getSupport: ct } },
        yt = { name: "utils", proto: { utils: lt }, static: { utils: lt } },
        wt = {
            name: "resize",
            create: function () {
                var e = this;
                e.getSize = function () {
                    if (!e.el) return { width: 0, height: 0, left: 0, top: 0 };
                    var t = e.$el.offset(),
                        a = [
                            e.el.offsetWidth,
                            e.el.offsetHeight,
                            t.left,
                            t.top,
                        ],
                        r = a[0],
                        n = a[1],
                        o = a[2],
                        i = a[3];
                    return (
                        (e.width = r),
                        (e.height = n),
                        (e.left = o),
                        (e.top = i),
                        { width: r, height: n, left: o, top: i }
                    );
                };
            },
            on: {
                init: function () {
                    var e = this,
                        t = o();
                    e.getSize(),
                        t.addEventListener(
                            "resize",
                            function () {
                                e.emit("resize");
                            },
                            !1
                        ),
                        t.addEventListener("orientationchange", function () {
                            e.emit("orientationchange");
                        });
                },
                orientationchange: function () {
                    var e = r();
                    pt().ipad &&
                        ((e.body.scrollLeft = 0),
                        setTimeout(function () {
                            e.body.scrollLeft = 0;
                        }, 0));
                },
                resize: function () {
                    this.getSize();
                },
            },
        },
        Ct = {},
        Et = 0,
        kt = function (e) {
            Object.assign(this, e);
        },
        xt = (function (e) {
            function t(t) {
                var a;
                return (a = e.call(this) || this), Object.assign(ze(a), t), a;
            }
            return Me(t, e), t;
        })(Le(Error)),
        $t = function (e) {
            return new Promise(function (t, a) {
                var n = o(),
                    i = r(),
                    s = Qe({}, Ct);
                "beforeCreate beforeOpen beforeSend error complete success statusCode"
                    .split(" ")
                    .forEach(function (e) {
                        delete s[e];
                    });
                var l = Qe(
                        {
                            url: n.location.toString(),
                            method: "GET",
                            data: !1,
                            async: !0,
                            cache: !0,
                            user: "",
                            password: "",
                            headers: {},
                            xhrFields: {},
                            statusCode: {},
                            processData: !0,
                            dataType: "text",
                            contentType: "application/x-www-form-urlencoded",
                            timeout: 0,
                        },
                        s
                    ),
                    c = Qe({}, l, e);
                if (
                    (e.abortController &&
                        (c.abortController = e.abortController),
                    c.abortController && c.abortController.canceled)
                )
                    a(
                        new xt({
                            options: c,
                            status: "canceled",
                            message: "canceled",
                        })
                    );
                else if (!1 !== T("beforeCreate", c)) {
                    c.type && (c.method = c.type);
                    var p,
                        d = c.url.indexOf("?") >= 0 ? "&" : "?",
                        u = c.method.toUpperCase();
                    if (
                        ("GET" === u ||
                            "HEAD" === u ||
                            "OPTIONS" === u ||
                            "DELETE" === u) &&
                        c.data
                    )
                        (p =
                            "string" == typeof c.data
                                ? c.data.indexOf("?") >= 0
                                    ? c.data.split("?")[1]
                                    : c.data
                                : Ge(c.data)).length &&
                            ((c.url += d + p), "?" === d && (d = "&"));
                    if (
                        "json" === c.dataType &&
                        c.url.indexOf("callback=") >= 0
                    ) {
                        var h,
                            f = "f7jsonp_" + (Date.now() + (Et += 1)),
                            v = c.url.split("callback="),
                            m = v[0] + "callback=" + f;
                        if (v[1].indexOf("&") >= 0) {
                            var g = v[1]
                                .split("&")
                                .filter(function (e) {
                                    return e.indexOf("=") > 0;
                                })
                                .join("&");
                            g.length > 0 && (m += "&" + g);
                        }
                        var b = i.createElement("script");
                        return (
                            (b.type = "text/javascript"),
                            (b.onerror = function () {
                                clearTimeout(h),
                                    T(
                                        "error",
                                        null,
                                        "scripterror",
                                        "scripterror"
                                    ),
                                    a(
                                        new xt({
                                            options: c,
                                            status: "scripterror",
                                            message: "scripterror",
                                        })
                                    ),
                                    T("complete", null, "scripterror");
                            }),
                            (b.src = m),
                            (n[f] = function (e) {
                                clearTimeout(h),
                                    T("success", e),
                                    b.parentNode.removeChild(b),
                                    (b = null),
                                    delete n[f],
                                    t(new kt({ options: c, data: e }));
                            }),
                            i.querySelector("head").appendChild(b),
                            void (
                                c.timeout > 0 &&
                                (h = setTimeout(function () {
                                    b.parentNode.removeChild(b),
                                        (b = null),
                                        T("error", null, "timeout", "timeout"),
                                        a(
                                            new xt({
                                                options: c,
                                                status: "timeout",
                                                message: "timeout",
                                            })
                                        );
                                }, c.timeout))
                            )
                        );
                    }
                    ("GET" !== u &&
                        "HEAD" !== u &&
                        "OPTIONS" !== u &&
                        "DELETE" !== u) ||
                        (!1 === c.cache &&
                            (c.url += d + "_nocache" + Date.now()));
                    var y = new XMLHttpRequest();
                    if (c.abortController) {
                        var w = !1;
                        c.abortController.onAbort = function () {
                            w ||
                                ((w = !0),
                                y.abort(),
                                a(
                                    new xt({
                                        options: c,
                                        xhr: y,
                                        status: "canceled",
                                        message: "canceled",
                                    })
                                ));
                        };
                    }
                    if (
                        ((y.requestUrl = c.url),
                        (y.requestParameters = c),
                        !1 !== T("beforeOpen", y, c))
                    ) {
                        y.open(u, c.url, c.async, c.user, c.password);
                        var C = null;
                        if (
                            ("POST" === u || "PUT" === u || "PATCH" === u) &&
                            c.data
                        )
                            if (c.processData)
                                if (
                                    [
                                        ArrayBuffer,
                                        Blob,
                                        Document,
                                        FormData,
                                    ].indexOf(c.data.constructor) >= 0
                                )
                                    C = c.data;
                                else {
                                    var E =
                                        "---------------------------" +
                                        Date.now().toString(16);
                                    "multipart/form-data" === c.contentType
                                        ? y.setRequestHeader(
                                              "Content-Type",
                                              "multipart/form-data; boundary=" +
                                                  E
                                          )
                                        : y.setRequestHeader(
                                              "Content-Type",
                                              c.contentType
                                          ),
                                        (C = "");
                                    var k = Ge(c.data);
                                    if (
                                        "multipart/form-data" === c.contentType
                                    ) {
                                        k = k.split("&");
                                        for (
                                            var x = [], $ = 0;
                                            $ < k.length;
                                            $ += 1
                                        )
                                            x.push(
                                                'Content-Disposition: form-data; name="' +
                                                    k[$].split("=")[0] +
                                                    '"\r\n\r\n' +
                                                    k[$].split("=")[1] +
                                                    "\r\n"
                                            );
                                        C =
                                            "--" +
                                            E +
                                            "\r\n" +
                                            x.join("--" + E + "\r\n") +
                                            "--" +
                                            E +
                                            "--\r\n";
                                    } else
                                        C =
                                            "application/json" === c.contentType
                                                ? JSON.stringify(c.data)
                                                : k;
                                }
                            else
                                (C = c.data),
                                    y.setRequestHeader(
                                        "Content-Type",
                                        c.contentType
                                    );
                        "json" !== c.dataType ||
                            (c.headers && c.headers.Accept) ||
                            y.setRequestHeader("Accept", "application/json"),
                            c.headers &&
                                Object.keys(c.headers).forEach(function (e) {
                                    void 0 !== c.headers[e] &&
                                        y.setRequestHeader(e, c.headers[e]);
                                }),
                            void 0 === c.crossDomain &&
                                (c.crossDomain =
                                    /^([\w-]+:)?\/\/([^\/]+)/.test(c.url) &&
                                    RegExp.$2 !== n.location.host),
                            c.crossDomain ||
                                y.setRequestHeader(
                                    "X-Requested-With",
                                    "XMLHttpRequest"
                                ),
                            c.xhrFields && Qe(y, c.xhrFields),
                            (y.onload = function () {
                                var e;
                                if (
                                    (y.status >= 200 && y.status < 300) ||
                                    0 === y.status
                                )
                                    if ("json" === c.dataType) {
                                        var r;
                                        try {
                                            e = JSON.parse(y.responseText);
                                        } catch (e) {
                                            r = !0;
                                        }
                                        r
                                            ? (T(
                                                  "error",
                                                  y,
                                                  "parseerror",
                                                  "parseerror"
                                              ),
                                              a(
                                                  new xt({
                                                      options: c,
                                                      xhr: y,
                                                      status: "parseerror",
                                                      message: "parseerror",
                                                  })
                                              ))
                                            : (T("success", e, y.status, y),
                                              t(
                                                  new kt({
                                                      options: c,
                                                      data: e,
                                                      status: y.status,
                                                      xhr: y,
                                                  })
                                              ));
                                    } else
                                        T(
                                            "success",
                                            (e =
                                                "text" === y.responseType ||
                                                "" === y.responseType
                                                    ? y.responseText
                                                    : y.response),
                                            y.status,
                                            y
                                        ),
                                            t(
                                                new kt({
                                                    options: c,
                                                    data: e,
                                                    status: y.status,
                                                    xhr: y,
                                                })
                                            );
                                else
                                    T("error", y, y.status, y.statusText),
                                        a(
                                            new xt({
                                                options: c,
                                                xhr: y,
                                                status: y.status,
                                                message: y.statusText,
                                            })
                                        );
                                c.statusCode &&
                                    (Ct.statusCode &&
                                        Ct.statusCode[y.status] &&
                                        Ct.statusCode[y.status](y),
                                    c.statusCode[y.status] &&
                                        c.statusCode[y.status](y)),
                                    T("complete", y, y.status);
                            }),
                            (y.onerror = function () {
                                T("error", y, y.status, y.status),
                                    a(
                                        new xt({
                                            options: c,
                                            xhr: y,
                                            status: y.status,
                                            message: y.statusText,
                                        })
                                    ),
                                    T("complete", y, "error");
                            }),
                            c.timeout > 0 &&
                                ((y.timeout = c.timeout),
                                (y.ontimeout = function () {
                                    T("error", y, "timeout", "timeout"),
                                        a(
                                            new xt({
                                                options: c,
                                                xhr: y,
                                                status: "timeout",
                                                message: "timeout",
                                            })
                                        ),
                                        T("complete", y, "timeout");
                                })),
                            !1 !== T("beforeSend", y, c)
                                ? y.send(C)
                                : a(
                                      new xt({
                                          options: c,
                                          xhr: y,
                                          status: "canceled",
                                          message: "canceled",
                                      })
                                  );
                    } else
                        a(
                            new xt({
                                options: c,
                                xhr: y,
                                status: "canceled",
                                message: "canceled",
                            })
                        );
                } else
                    a(
                        new xt({
                            options: c,
                            status: "canceled",
                            message: "canceled",
                        })
                    );
                function T(e) {
                    for (
                        var t,
                            a,
                            r = arguments.length,
                            n = new Array(r > 1 ? r - 1 : 0),
                            o = 1;
                        o < r;
                        o++
                    )
                        n[o - 1] = arguments[o];
                    return (
                        Ct[e] && (t = Ct[e].apply(Ct, n)),
                        c[e] && (a = c[e].apply(c, n)),
                        "boolean" != typeof t && (t = !0),
                        "boolean" != typeof a && (a = !0),
                        (!c.abortController ||
                            !c.abortController.canceled ||
                            ("beforeCreate" !== e &&
                                "beforeOpen" !== e &&
                                "beforeSend" !== e)) &&
                            t &&
                            a
                    );
                }
            });
        };
    function Tt(e) {
        for (
            var t = [],
                a = t[0],
                r = t[1],
                n = t[2],
                o = t[3],
                i = t[4],
                s = arguments.length,
                l = new Array(s > 1 ? s - 1 : 0),
                c = 1;
            c < s;
            c++
        )
            l[c - 1] = arguments[c];
        "function" == typeof l[1]
            ? ((a = l[0]), (n = l[1]), (o = l[2]), (i = l[3]))
            : ((a = l[0]), (r = l[1]), (n = l[2]), (o = l[3]), (i = l[4])),
            [n, o].forEach(function (e) {
                "string" == typeof e &&
                    ((i = e), e === n ? (n = void 0) : (o = void 0));
            });
        var p = {
            url: a,
            method: "post" === e || "postJSON" === e ? "POST" : "GET",
            data: r,
            success: n,
            error: o,
            dataType: (i =
                i || ("json" === e || "postJSON" === e ? "json" : void 0)),
        };
        return (
            "postJSON" === e &&
                Qe(p, {
                    contentType: "application/json",
                    processData: !1,
                    crossDomain: !0,
                    data: "string" == typeof r ? r : JSON.stringify(r),
                }),
            $t(p)
        );
    }
    Object.assign($t, {
        get: function () {
            for (var e = arguments.length, t = new Array(e), a = 0; a < e; a++)
                t[a] = arguments[a];
            return Tt.apply(void 0, ["get"].concat(t));
        },
        post: function () {
            for (var e = arguments.length, t = new Array(e), a = 0; a < e; a++)
                t[a] = arguments[a];
            return Tt.apply(void 0, ["post"].concat(t));
        },
        json: function () {
            for (var e = arguments.length, t = new Array(e), a = 0; a < e; a++)
                t[a] = arguments[a];
            return Tt.apply(void 0, ["json"].concat(t));
        },
        getJSON: function () {
            for (var e = arguments.length, t = new Array(e), a = 0; a < e; a++)
                t[a] = arguments[a];
            return Tt.apply(void 0, ["json"].concat(t));
        },
        postJSON: function () {
            for (var e = arguments.length, t = new Array(e), a = 0; a < e; a++)
                t[a] = arguments[a];
            return Tt.apply(void 0, ["postJSON"].concat(t));
        },
    }),
        ($t.abortController = function () {
            var e = {
                canceled: !1,
                onAbort: null,
                abort: function () {
                    (e.canceled = !0), e.onAbort && e.onAbort();
                },
            };
            return e;
        }),
        ($t.setup = function (e) {
            e.type && !e.method && Qe(e, { method: e.type }), Qe(Ct, e);
        });
    var St = {
        name: "request",
        proto: { request: $t },
        static: { request: $t },
    };
    var Mt = {
        name: "touch",
        params: {
            touch: {
                touchClicksDistanceThreshold: 5,
                disableContextMenu: !1,
                tapHold: !1,
                tapHoldDelay: 750,
                tapHoldPreventClicks: !0,
                activeState: !0,
                activeStateElements:
                    "a, button, label, span, .actions-button, .stepper-button, .stepper-button-plus, .stepper-button-minus, .card-expandable, .menu-item, .link, .item-link, .accordion-item-toggle",
                activeStateOnMouseMove: !1,
                mdTouchRipple: !0,
                iosTouchRipple: !1,
                auroraTouchRipple: !1,
                touchRippleElements:
                    ".ripple, .link, .item-link, .list-button, .links-list a, .button, button, .input-clear-button, .dialog-button, .tab-link, .item-radio, .item-checkbox, .actions-button, .searchbar-disable-button, .fab a, .checkbox, .radio, .data-table .sortable-cell:not(.input-cell), .notification-close-button, .stepper-button, .stepper-button-minus, .stepper-button-plus, .menu-item-content, .list.accordion-list .accordion-item-toggle",
                touchRippleInsetElements:
                    ".ripple-inset, .icon-only, .searchbar-disable-button, .input-clear-button, .notification-close-button, .md .navbar .link.back",
            },
        },
        create: function () {
            var e = ct();
            Qe(this, {
                touchEvents: {
                    start: e.touch
                        ? "touchstart"
                        : e.pointerEvents
                        ? "pointerdown"
                        : "mousedown",
                    move: e.touch
                        ? "touchmove"
                        : e.pointerEvents
                        ? "pointermove"
                        : "mousemove",
                    end: e.touch
                        ? "touchend"
                        : e.pointerEvents
                        ? "pointerup"
                        : "mouseup",
                },
            });
        },
        on: {
            init: function () {
                var e,
                    t,
                    a,
                    n,
                    i,
                    s,
                    l,
                    c,
                    p,
                    d,
                    u,
                    h,
                    f,
                    v = this,
                    m = pt(),
                    g = ct(),
                    b = o(),
                    y = r(),
                    w = v.params.touch,
                    C = w[v.theme + "TouchRipple"];
                function E(e) {
                    var t,
                        a = Ee(e),
                        r = a.parents(w.activeStateElements);
                    if (a.closest(".no-active-state").length) return null;
                    if (
                        (a.is(w.activeStateElements) && (t = a),
                        r.length > 0 && (t = t ? t.add(r) : r),
                        t && t.length > 1)
                    ) {
                        for (var n, o = [], i = 0; i < t.length; i += 1)
                            n ||
                                (o.push(t[i]),
                                (t
                                    .eq(i)
                                    .hasClass(
                                        "prevent-active-state-propagation"
                                    ) ||
                                    t
                                        .eq(i)
                                        .hasClass(
                                            "no-active-state-propagation"
                                        )) &&
                                    (n = !0));
                        t = Ee(o);
                    }
                    return t || a;
                }
                function k(e) {
                    return e.parents(".page-content").length > 0;
                }
                function x() {
                    c && c.addClass("active-state");
                }
                function $() {
                    c && (c.removeClass("active-state"), (c = null));
                }
                function T(e, t, a) {
                    e && (d = v.touchRipple.create(v, e, t, a));
                }
                function S() {
                    d && (d.remove(), (d = void 0), (u = void 0));
                }
                function M(a) {
                    (u = (function (e) {
                        var t = w.touchRippleElements,
                            a = Ee(e);
                        if (a.is(t)) return !a.hasClass("no-ripple") && a;
                        if (a.parents(t).length > 0) {
                            var r = a.parents(t).eq(0);
                            return !r.hasClass("no-ripple") && r;
                        }
                        return !1;
                    })(a)) && 0 !== u.length
                        ? k(u)
                            ? (clearTimeout(h),
                              (h = setTimeout(function () {
                                  S(), T(u, e, t);
                              }, 80)))
                            : (S(), T(u, e, t))
                        : (u = void 0);
                }
                function P() {
                    clearTimeout(h), S();
                }
                function O() {
                    d || !u || n
                        ? S()
                        : (clearTimeout(h), T(u, e, t), setTimeout(S, 0));
                }
                function I() {
                    Ee(".active-state").removeClass("active-state"), C && O();
                }
                m.ios &&
                    m.webView &&
                    b.addEventListener("touchstart", function () {});
                var B = !1,
                    L = null,
                    z = ".dialog-button, .actions-button",
                    R = !1,
                    A = null;
                function D(e, t) {
                    v.emit({ events: e, data: [t] });
                }
                function H(e) {
                    D("touchstart touchstart:active", e);
                }
                function N(e) {
                    D("touchmove touchmove:active", e);
                }
                function V(e) {
                    D("touchend touchend:active", e);
                }
                function F(e) {
                    D("touchstart:passive", e);
                }
                function q(e) {
                    D("touchmove:passive", e);
                }
                function j(e) {
                    D("touchend:passive", e);
                }
                var _ = !!g.passiveListener && { passive: !0 },
                    Y = !g.passiveListener || { passive: !0, capture: !0 },
                    W = !!g.passiveListener && { passive: !1 },
                    X = !g.passiveListener || { passive: !1, capture: !0 };
                y.addEventListener(
                    "click",
                    function (e) {
                        D("click", e);
                    },
                    !0
                ),
                    g.passiveListener
                        ? (y.addEventListener(v.touchEvents.start, H, X),
                          y.addEventListener(v.touchEvents.move, N, W),
                          y.addEventListener(v.touchEvents.end, V, W),
                          y.addEventListener(v.touchEvents.start, F, Y),
                          y.addEventListener(v.touchEvents.move, q, _),
                          y.addEventListener(v.touchEvents.end, j, _))
                        : (y.addEventListener(
                              v.touchEvents.start,
                              function (e) {
                                  H(e), F(e);
                              },
                              !0
                          ),
                          y.addEventListener(
                              v.touchEvents.move,
                              function (e) {
                                  N(e), q(e);
                              },
                              !1
                          ),
                          y.addEventListener(
                              v.touchEvents.end,
                              function (e) {
                                  V(e), j(e);
                              },
                              !1
                          )),
                    g.touch
                        ? (v.on("click", function (e) {
                              var t =
                                      e &&
                                      e.detail &&
                                      "f7Overswipe" === e.detail,
                                  r =
                                      e &&
                                      e.detail &&
                                      "f7Segmented" === e.detail,
                                  n =
                                      e &&
                                      e.detail &&
                                      "f7TouchMoveActivable" === e.detail,
                                  o = l;
                              return (
                                  a && e.target !== a
                                      ? (o = !(t || r || n))
                                      : n && (o = !1),
                                  w.tapHold &&
                                      w.tapHoldPreventClicks &&
                                      i &&
                                      (o = !0),
                                  o &&
                                      (e.stopImmediatePropagation(),
                                      e.stopPropagation(),
                                      e.preventDefault()),
                                  w.tapHold &&
                                      (s = setTimeout(
                                          function () {
                                              i = !1;
                                          },
                                          m.ios || m.androidChrome ? 100 : 400
                                      )),
                                  (l = !1),
                                  (a = null),
                                  !o
                              );
                          }),
                          v.on("touchstart", function (r) {
                              return (
                                  (n = !1),
                                  (i = !1),
                                  (l = !1),
                                  (f = void 0),
                                  r.targetTouches.length > 1
                                      ? (c && $(), !0)
                                      : (r.touches.length > 1 && c && $(),
                                        w.tapHold &&
                                            (s && clearTimeout(s),
                                            (s = setTimeout(function () {
                                                (r &&
                                                    r.touches &&
                                                    r.touches.length > 1) ||
                                                    ((i = !0),
                                                    r.preventDefault(),
                                                    (l = !0),
                                                    Ee(r.target).trigger(
                                                        "taphold",
                                                        r
                                                    ),
                                                    v.emit("taphold", r));
                                            }, w.tapHoldDelay))),
                                        (a = r.target),
                                        (e = r.targetTouches[0].pageX),
                                        (t = r.targetTouches[0].pageY),
                                        (B = r.target.closest(
                                            ".segmented-strong .button-active, .segmented-strong .tab-link-active"
                                        )),
                                        (R =
                                            "ios" === v.theme &&
                                            r.target.closest(z)),
                                        B &&
                                            (L =
                                                B.closest(".segmented-strong")),
                                        w.activeState &&
                                            ((c = E(a)) && !k(c)
                                                ? x()
                                                : c && (p = setTimeout(x, 80))),
                                        C && M(a),
                                        !0)
                              );
                          }),
                          v.on("touchmove", function (r) {
                              var o,
                                  i,
                                  d = !0;
                              "touchmove" === r.type &&
                                  ((o = r.targetTouches[0]),
                                  (i = w.touchClicksDistanceThreshold));
                              var u = r.targetTouches[0].pageX,
                                  h = r.targetTouches[0].pageY;
                              if (
                                  (void 0 === f &&
                                      (f = !!(
                                          f || Math.abs(h - t) > Math.abs(u - e)
                                      )),
                                  (R || (!f && B && L)) &&
                                      r.cancelable &&
                                      r.preventDefault(),
                                  !f && B && L)
                              ) {
                                  var v = y
                                      .elementFromPoint(
                                          r.targetTouches[0].clientX,
                                          r.targetTouches[0].clientY
                                      )
                                      .closest(
                                          ".segmented-strong .button:not(.button-active):not(.tab-link-active)"
                                      );
                                  v &&
                                      L.contains(v) &&
                                      (Ee(v).trigger("click", "f7Segmented"),
                                      (a = v));
                              }
                              if (i && o) {
                                  var m = o.pageX,
                                      g = o.pageY;
                                  (Math.abs(m - e) > i ||
                                      Math.abs(g - t) > i) &&
                                      (n = !0);
                              } else n = !0;
                              if (n) {
                                  if (((l = !0), R)) {
                                      var b = y.elementFromPoint(
                                          r.targetTouches[0].clientX,
                                          r.targetTouches[0].clientY
                                      );
                                      (A = b.closest(z)) && c && c[0] === A
                                          ? (d = !1)
                                          : A &&
                                            setTimeout(function () {
                                                (c = E(A)), x();
                                            });
                                  }
                                  w.tapHold && clearTimeout(s),
                                      w.activeState &&
                                          d &&
                                          (clearTimeout(p), $()),
                                      C && P();
                              }
                          }),
                          v.on("touchend", function (e) {
                              return (
                                  (f = void 0),
                                  (B = !1),
                                  (L = null),
                                  (R = !1),
                                  clearTimeout(p),
                                  clearTimeout(s),
                                  A &&
                                      (Ee(A).trigger(
                                          "click",
                                          "f7TouchMoveActivable"
                                      ),
                                      (A = null)),
                                  y.activeElement === e.target
                                      ? (w.activeState && $(), C && O(), !0)
                                      : (w.activeState &&
                                            (x(), setTimeout($, 0)),
                                        C && O(),
                                        !((w.tapHoldPreventClicks && i) || l) ||
                                            (e.cancelable && e.preventDefault(),
                                            (l = !0),
                                            !1))
                              );
                          }),
                          y.addEventListener(
                              "touchcancel",
                              function () {
                                  (a = null),
                                      clearTimeout(p),
                                      clearTimeout(s),
                                      w.activeState && $(),
                                      C && O();
                              },
                              { passive: !0 }
                          ))
                        : w.activeState &&
                          (v.on("touchstart", function (a) {
                              var r = E(a.target);
                              r &&
                                  (r.addClass("active-state"),
                                  "which" in a &&
                                      3 === a.which &&
                                      setTimeout(function () {
                                          Ee(".active-state").removeClass(
                                              "active-state"
                                          );
                                      }, 0)),
                                  C &&
                                      ((e = a.pageX),
                                      (t = a.pageY),
                                      M(a.target, a.pageX, a.pageY));
                          }),
                          v.on("touchmove", function () {
                              w.activeStateOnMouseMove ||
                                  Ee(".active-state").removeClass(
                                      "active-state"
                                  ),
                                  C && P();
                          }),
                          v.on("touchend", I),
                          y.addEventListener("pointercancel", I, {
                              passive: !0,
                          })),
                    y.addEventListener("contextmenu", function (e) {
                        w.disableContextMenu &&
                            (m.ios ||
                                m.android ||
                                m.cordova ||
                                (b.Capacitor && b.Capacitor.isNative)) &&
                            e.preventDefault(),
                            C && (c && $(), O());
                    });
            },
        },
    };
    function Pt(e, t) {
        void 0 === t && (t = {});
        for (
            var a = (function (e) {
                    for (var t = [], a = 0; a < e.length; ) {
                        var r = e[a];
                        if ("*" !== r && "+" !== r && "?" !== r)
                            if ("\\" !== r)
                                if ("{" !== r)
                                    if ("}" !== r)
                                        if (":" !== r)
                                            if ("(" !== r)
                                                t.push({
                                                    type: "CHAR",
                                                    index: a,
                                                    value: e[a++],
                                                });
                                            else {
                                                var n = 1,
                                                    o = "";
                                                if ("?" === e[(s = a + 1)])
                                                    throw new TypeError(
                                                        'Pattern cannot start with "?" at ' +
                                                            s
                                                    );
                                                for (; s < e.length; )
                                                    if ("\\" !== e[s]) {
                                                        if (")" === e[s]) {
                                                            if (0 == --n) {
                                                                s++;
                                                                break;
                                                            }
                                                        } else if (
                                                            "(" === e[s] &&
                                                            (n++,
                                                            "?" !== e[s + 1])
                                                        )
                                                            throw new TypeError(
                                                                "Capturing groups are not allowed at " +
                                                                    s
                                                            );
                                                        o += e[s++];
                                                    } else o += e[s++] + e[s++];
                                                if (n)
                                                    throw new TypeError(
                                                        "Unbalanced pattern at " +
                                                            a
                                                    );
                                                if (!o)
                                                    throw new TypeError(
                                                        "Missing pattern at " +
                                                            a
                                                    );
                                                t.push({
                                                    type: "PATTERN",
                                                    index: a,
                                                    value: o,
                                                }),
                                                    (a = s);
                                            }
                                        else {
                                            for (
                                                var i = "", s = a + 1;
                                                s < e.length;

                                            ) {
                                                var l = e.charCodeAt(s);
                                                if (
                                                    !(
                                                        (l >= 48 && l <= 57) ||
                                                        (l >= 65 && l <= 90) ||
                                                        (l >= 97 && l <= 122) ||
                                                        95 === l
                                                    )
                                                )
                                                    break;
                                                i += e[s++];
                                            }
                                            if (!i)
                                                throw new TypeError(
                                                    "Missing parameter name at " +
                                                        a
                                                );
                                            t.push({
                                                type: "NAME",
                                                index: a,
                                                value: i,
                                            }),
                                                (a = s);
                                        }
                                    else
                                        t.push({
                                            type: "CLOSE",
                                            index: a,
                                            value: e[a++],
                                        });
                                else
                                    t.push({
                                        type: "OPEN",
                                        index: a,
                                        value: e[a++],
                                    });
                            else
                                t.push({
                                    type: "ESCAPED_CHAR",
                                    index: a++,
                                    value: e[a++],
                                });
                        else
                            t.push({
                                type: "MODIFIER",
                                index: a,
                                value: e[a++],
                            });
                    }
                    return t.push({ type: "END", index: a, value: "" }), t;
                })(e),
                r = t.prefixes,
                n = void 0 === r ? "./" : r,
                o = "[^" + It(t.delimiter || "/#?") + "]+?",
                i = [],
                s = 0,
                l = 0,
                c = "",
                p = function (e) {
                    if (l < a.length && a[l].type === e) return a[l++].value;
                },
                d = function (e) {
                    var t = p(e);
                    if (void 0 !== t) return t;
                    var r = a[l],
                        n = r.type,
                        o = r.index;
                    throw new TypeError(
                        "Unexpected " + n + " at " + o + ", expected " + e
                    );
                },
                u = function () {
                    for (var e, t = ""; (e = p("CHAR") || p("ESCAPED_CHAR")); )
                        t += e;
                    return t;
                };
            l < a.length;

        ) {
            var h = p("CHAR"),
                f = p("NAME"),
                v = p("PATTERN");
            if (f || v) {
                var m = h || "";
                -1 === n.indexOf(m) && ((c += m), (m = "")),
                    c && (i.push(c), (c = "")),
                    i.push({
                        name: f || s++,
                        prefix: m,
                        suffix: "",
                        pattern: v || o,
                        modifier: p("MODIFIER") || "",
                    });
            } else {
                var g = h || p("ESCAPED_CHAR");
                if (g) c += g;
                else if ((c && (i.push(c), (c = "")), p("OPEN"))) {
                    m = u();
                    var b = p("NAME") || "",
                        y = p("PATTERN") || "",
                        w = u();
                    d("CLOSE"),
                        i.push({
                            name: b || (y ? s++ : ""),
                            pattern: b && !y ? o : y,
                            prefix: m,
                            suffix: w,
                            modifier: p("MODIFIER") || "",
                        });
                } else d("END");
            }
        }
        return i;
    }
    function Ot(e, t) {
        return (function (e, t) {
            void 0 === t && (t = {});
            var a = Bt(t),
                r = t.encode,
                n =
                    void 0 === r
                        ? function (e) {
                              return e;
                          }
                        : r,
                o = t.validate,
                i = void 0 === o || o,
                s = e.map(function (e) {
                    if ("object" == typeof e)
                        return new RegExp("^(?:" + e.pattern + ")$", a);
                });
            return function (t) {
                for (var a = "", r = 0; r < e.length; r++) {
                    var o = e[r];
                    if ("string" != typeof o) {
                        var l = t ? t[o.name] : void 0,
                            c = "?" === o.modifier || "*" === o.modifier,
                            p = "*" === o.modifier || "+" === o.modifier;
                        if (Array.isArray(l)) {
                            if (!p)
                                throw new TypeError(
                                    'Expected "' +
                                        o.name +
                                        '" to not repeat, but got an array'
                                );
                            if (0 === l.length) {
                                if (c) continue;
                                throw new TypeError(
                                    'Expected "' + o.name + '" to not be empty'
                                );
                            }
                            for (var d = 0; d < l.length; d++) {
                                var u = n(l[d], o);
                                if (i && !s[r].test(u))
                                    throw new TypeError(
                                        'Expected all "' +
                                            o.name +
                                            '" to match "' +
                                            o.pattern +
                                            '", but got "' +
                                            u +
                                            '"'
                                    );
                                a += o.prefix + u + o.suffix;
                            }
                        } else if (
                            "string" != typeof l &&
                            "number" != typeof l
                        ) {
                            if (!c) {
                                var h = p ? "an array" : "a string";
                                throw new TypeError(
                                    'Expected "' + o.name + '" to be ' + h
                                );
                            }
                        } else {
                            u = n(String(l), o);
                            if (i && !s[r].test(u))
                                throw new TypeError(
                                    'Expected "' +
                                        o.name +
                                        '" to match "' +
                                        o.pattern +
                                        '", but got "' +
                                        u +
                                        '"'
                                );
                            a += o.prefix + u + o.suffix;
                        }
                    } else a += o;
                }
                return a;
            };
        })(Pt(e, t), t);
    }
    function It(e) {
        return e.replace(/([.+*?=^!:${}()[\]|/\\])/g, "\\$1");
    }
    function Bt(e) {
        return e && e.sensitive ? "" : "i";
    }
    function Lt(e, t, a) {
        return (function (e, t, a) {
            void 0 === a && (a = {});
            for (
                var r = a.strict,
                    n = void 0 !== r && r,
                    o = a.start,
                    i = void 0 === o || o,
                    s = a.end,
                    l = void 0 === s || s,
                    c = a.encode,
                    p =
                        void 0 === c
                            ? function (e) {
                                  return e;
                              }
                            : c,
                    d = "[" + It(a.endsWith || "") + "]|$",
                    u = "[" + It(a.delimiter || "/#?") + "]",
                    h = i ? "^" : "",
                    f = 0,
                    v = e;
                f < v.length;
                f++
            ) {
                var m = v[f];
                if ("string" == typeof m) h += It(p(m));
                else {
                    var g = It(p(m.prefix)),
                        b = It(p(m.suffix));
                    if (m.pattern)
                        if ((t && t.push(m), g || b))
                            if ("+" === m.modifier || "*" === m.modifier) {
                                var y = "*" === m.modifier ? "?" : "";
                                h +=
                                    "(?:" +
                                    g +
                                    "((?:" +
                                    m.pattern +
                                    ")(?:" +
                                    b +
                                    g +
                                    "(?:" +
                                    m.pattern +
                                    "))*)" +
                                    b +
                                    ")" +
                                    y;
                            } else
                                h +=
                                    "(?:" +
                                    g +
                                    "(" +
                                    m.pattern +
                                    ")" +
                                    b +
                                    ")" +
                                    m.modifier;
                        else h += "(" + m.pattern + ")" + m.modifier;
                    else h += "(?:" + g + b + ")" + m.modifier;
                }
            }
            if (l)
                n || (h += u + "?"), (h += a.endsWith ? "(?=" + d + ")" : "$");
            else {
                var w = e[e.length - 1],
                    C =
                        "string" == typeof w
                            ? u.indexOf(w[w.length - 1]) > -1
                            : void 0 === w;
                n || (h += "(?:" + u + "(?=" + d + "))?"),
                    C || (h += "(?=" + u + "|" + d + ")");
            }
            return new RegExp(h, Bt(a));
        })(Pt(e, a), t, a);
    }
    function zt(e, t, a) {
        return e instanceof RegExp
            ? (function (e, t) {
                  if (!t) return e;
                  for (
                      var a = /\((?:\?<(.*?)>)?(?!\?)/g,
                          r = 0,
                          n = a.exec(e.source);
                      n;

                  )
                      t.push({
                          name: n[1] || r++,
                          prefix: "",
                          suffix: "",
                          modifier: "",
                          pattern: "",
                      }),
                          (n = a.exec(e.source));
                  return e;
              })(e, t)
            : Array.isArray(e)
            ? (function (e, t, a) {
                  var r = e.map(function (e) {
                      return zt(e, t, a).source;
                  });
                  return new RegExp("(?:" + r.join("|") + ")", Bt(a));
              })(e, t, a)
            : Lt(e, t, a);
    }
    var Rt = {
        queue: [],
        clearQueue: function () {
            0 !== Rt.queue.length && Rt.queue.shift()();
        },
        routerQueue: [],
        clearRouterQueue: function () {
            if (0 !== Rt.routerQueue.length) {
                var e = Rt.routerQueue.pop(),
                    t = e.router,
                    a = e.stateUrl,
                    r = e.action,
                    n = t.params.animate;
                !1 === t.params.browserHistoryAnimate && (n = !1),
                    "back" === r && t.back({ animate: n, browserHistory: !1 }),
                    "load" === r &&
                        t.navigate(a, { animate: n, browserHistory: !1 });
            }
        },
        handle: function (e) {
            if (!Rt.blockPopstate) {
                var t = e.state;
                (Rt.previousState = Rt.state),
                    (Rt.state = t),
                    (Rt.allowChange = !0),
                    Rt.clearQueue(),
                    (t = Rt.state) || (t = {}),
                    this.views.forEach(function (e) {
                        var a = e.router,
                            r = t[e.id];
                        if (
                            (!r &&
                                e.params.browserHistory &&
                                (r = { url: e.router.history[0] }),
                            r)
                        ) {
                            var n = r.url || void 0,
                                o = a.params.animate;
                            !1 === a.params.browserHistoryAnimate && (o = !1),
                                n !== a.url &&
                                    (a.history.indexOf(n) >= 0
                                        ? a.allowPageChange
                                            ? a.back({
                                                  animate: o,
                                                  browserHistory: !1,
                                              })
                                            : Rt.routerQueue.push({
                                                  action: "back",
                                                  router: a,
                                              })
                                        : a.allowPageChange
                                        ? a.navigate(n, {
                                              animate: o,
                                              browserHistory: !1,
                                          })
                                        : Rt.routerQueue.unshift({
                                              action: "load",
                                              stateUrl: n,
                                              router: a,
                                          }));
                        }
                    });
            }
        },
        initViewState: function (e, t) {
            var a,
                r = o(),
                n = Qe({}, Rt.state || {}, (((a = {})[e] = t), a));
            (Rt.state = n), r.history.replaceState(n, "");
        },
        push: function (e, t, a) {
            var r,
                n = o();
            if (
                ("#!/" === a.substr(-3) && (a = a.replace("#!/", "")),
                Rt.allowChange)
            ) {
                Rt.previousState = Rt.state;
                var i = Qe({}, Rt.previousState || {}, (((r = {})[e] = t), r));
                (Rt.state = i), n.history.pushState(i, "", a);
            } else
                Rt.queue.push(function () {
                    Rt.push(e, t, a);
                });
        },
        replace: function (e, t, a) {
            var r,
                n = o();
            if (
                ("#!/" === a.substr(-3) && (a = a.replace("#!/", "")),
                Rt.allowChange)
            ) {
                Rt.previousState = Rt.state;
                var i = Qe({}, Rt.previousState || {}, (((r = {})[e] = t), r));
                (Rt.state = i), n.history.replaceState(i, "", a);
            } else
                Rt.queue.push(function () {
                    Rt.replace(e, t, a);
                });
        },
        go: function (e) {
            var t = o();
            (Rt.allowChange = !1), t.history.go(e);
        },
        back: function () {
            var e = o();
            (Rt.allowChange = !1), e.history.back();
        },
        allowChange: !0,
        previousState: {},
        state: {},
        blockPopstate: !0,
        init: function (e) {
            var t = o(),
                a = r();
            (Rt.state = t.history.state),
                Ee(t).on("load", function () {
                    setTimeout(function () {
                        Rt.blockPopstate = !1;
                    }, 0);
                }),
                a.readyState &&
                    "complete" === a.readyState &&
                    (Rt.blockPopstate = !1),
                Ee(t).on("popstate", Rt.handle.bind(e));
        },
    };
    function At(e) {
        var t,
            a,
            r,
            n,
            o,
            i,
            s,
            l,
            c,
            p = e,
            d = p.$el,
            u = p.$navbarsEl,
            h = p.app,
            f = p.params,
            v = ct(),
            m = pt(),
            g = !1,
            b = !1,
            y = {},
            w = [],
            C = [],
            E = !0,
            k = [],
            x = [],
            $ = f[h.theme + "SwipeBackAnimateShadow"],
            T = f[h.theme + "SwipeBackAnimateOpacity"],
            S = f[h.theme + "SwipeBackActiveArea"],
            M = f[h.theme + "SwipeBackThreshold"],
            P = h.rtl ? "right center" : "left center",
            O = h.rtl
                ? "calc(100% - var(--f7-navbar-large-title-padding-left) - var(--f7-safe-area-left)) center"
                : "calc(var(--f7-navbar-large-title-padding-left) + var(--f7-safe-area-left)) center";
        function I(e) {
            var t = void 0 === e ? {} : e,
                a = t.progress,
                r = t.reset,
                n = t.transition,
                o = t.reflow,
                i = ["overflow", "transform", "transform-origin", "opacity"];
            if (!0 === n || !1 === n)
                for (var s = 0; s < l.length; s += 1) {
                    var c = l[s];
                    c &&
                        c.el &&
                        (!0 === n &&
                            c.el.classList.add("navbar-page-transitioning"),
                        !1 === n &&
                            c.el.classList.remove("navbar-page-transitioning"));
                }
            o &&
                l.length &&
                l[0] &&
                l[0].el &&
                (l[0].el._clientLeft = l[0].el.clientLeft);
            for (var p = 0; p < l.length; p += 1) {
                var d = l[p];
                if (d && d.el) {
                    !d.className ||
                        d.classNameSet ||
                        r ||
                        (d.el.classList.add(d.className),
                        (d.classNameSet = !0)),
                        d.className && r && d.el.classList.remove(d.className);
                    for (var u = 0; u < i.length; u += 1) {
                        var h = i[u];
                        d[h] &&
                            (r
                                ? (d.el.style[h] = "")
                                : "function" == typeof d[h]
                                ? (d.el.style[h] = d[h](a))
                                : (d.el.style[h] = d[h]));
                    }
                }
            }
        }
        function B(e) {
            var a = f[h.theme + "SwipeBack"];
            !E ||
                !a ||
                g ||
                (h.swipeout && h.swipeout.el) ||
                !p.allowPageChange ||
                Ee(e.target).closest(".range-slider, .calendar-months").length >
                    0 ||
                (Ee(e.target).closest(".page-master, .page-master-detail")
                    .length > 0 &&
                    f.masterDetailBreakpoint > 0 &&
                    h.width >= f.masterDetailBreakpoint) ||
                ((b = !1),
                (g = !0),
                (t = void 0),
                (y.x =
                    "touchstart" === e.type
                        ? e.targetTouches[0].pageX
                        : e.pageX),
                (y.y =
                    "touchstart" === e.type
                        ? e.targetTouches[0].pageY
                        : e.pageY),
                (n = Ye()),
                (o = p.dynamicNavbar));
        }
        function L(e) {
            if (g) {
                var n =
                        "touchmove" === e.type
                            ? e.targetTouches[0].pageX
                            : e.pageX,
                    c =
                        "touchmove" === e.type
                            ? e.targetTouches[0].pageY
                            : e.pageY;
                if (
                    (void 0 === t &&
                        (t =
                            !!(t || Math.abs(c - y.y) > Math.abs(n - y.x)) ||
                            (n < y.x && !h.rtl) ||
                            (n > y.x && h.rtl)),
                    t || e.f7PreventSwipeBack || h.preventSwipeBack)
                )
                    g = !1;
                else {
                    if (!b) {
                        var v = !1,
                            E = Ee(e.target),
                            B = E.closest(".swipeout");
                        B.length > 0 &&
                            (!h.rtl &&
                                B.find(".swipeout-actions-left").length > 0 &&
                                (v = !0),
                            h.rtl &&
                                B.find(".swipeout-actions-right").length > 0 &&
                                (v = !0)),
                            ((w = E.closest(".page")).hasClass(
                                "no-swipeback"
                            ) ||
                                E.closest(".no-swipeback, .card-opened")
                                    .length > 0) &&
                                (v = !0),
                            (C = d.find(".page-previous:not(.stacked)"))
                                .length > 1 && (C = C.eq(C.length - 1));
                        y.x, d.offset().left;
                        if (
                            ((a = d.width()),
                            (h.rtl
                                ? y.x <
                                  d.offset().left - d[0].scrollLeft + (a - S)
                                : y.x - d.offset().left > S) && (v = !0),
                            (0 !== C.length && 0 !== w.length) || (v = !0),
                            v)
                        )
                            return void (g = !1);
                        $ &&
                            0 === (i = w.find(".page-shadow-effect")).length &&
                            ((i = Ee('<div class="page-shadow-effect"></div>')),
                            w.append(i)),
                            T &&
                                0 ===
                                    (s = C.find(".page-opacity-effect"))
                                        .length &&
                                ((s = Ee(
                                    '<div class="page-opacity-effect"></div>'
                                )),
                                C.append(s)),
                            o &&
                                ((k = u.find(".navbar-current:not(.stacked)")),
                                (x = u.find(".navbar-previous:not(.stacked)"))
                                    .length > 1 && (x = x.eq(x.length - 1)),
                                (l = (function () {
                                    var e,
                                        t,
                                        a = [],
                                        r = h.rtl ? -1 : 1,
                                        n =
                                            k.hasClass("navbar-transparent") &&
                                            !k.hasClass("navbar-large") &&
                                            !k.hasClass(
                                                "navbar-transparent-visible"
                                            ),
                                        o = k.hasClass("navbar-large"),
                                        i = k.hasClass(
                                            "navbar-large-collapsed"
                                        ),
                                        s =
                                            k.hasClass(
                                                "navbar-large-transparent"
                                            ) ||
                                            (k.hasClass("navbar-large") &&
                                                k.hasClass(
                                                    "navbar-transparent"
                                                )),
                                        l =
                                            x.hasClass("navbar-transparent") &&
                                            !x.hasClass("navbar-large") &&
                                            !x.hasClass(
                                                "navbar-transparent-visible"
                                            ),
                                        c = x.hasClass("navbar-large"),
                                        p = x.hasClass(
                                            "navbar-large-collapsed"
                                        ),
                                        d =
                                            x.hasClass(
                                                "navbar-large-transparent"
                                            ) ||
                                            (x.hasClass("navbar-large") &&
                                                x.hasClass(
                                                    "navbar-transparent"
                                                )),
                                        u = o && !i,
                                        v = c && !p,
                                        g = k.find(
                                            ".left, .title, .right, .subnavbar, .fading, .title-large, .navbar-bg"
                                        ),
                                        b = x.find(
                                            ".left, .title, .right, .subnavbar, .fading, .title-large, .navbar-bg"
                                        );
                                    return (
                                        f.iosAnimateNavbarBackIcon &&
                                            ((e =
                                                k.hasClass("sliding") ||
                                                k.find(".navbar-inner.sliding")
                                                    .length
                                                    ? k
                                                          .find(".left")
                                                          .find(
                                                              ".back .icon + span"
                                                          )
                                                          .eq(0)
                                                    : k
                                                          .find(".left.sliding")
                                                          .find(
                                                              ".back .icon + span"
                                                          )
                                                          .eq(0)),
                                            (t =
                                                x.hasClass("sliding") ||
                                                x.find(".navbar-inner.sliding")
                                                    .length
                                                    ? x
                                                          .find(".left")
                                                          .find(
                                                              ".back .icon + span"
                                                          )
                                                          .eq(0)
                                                    : x
                                                          .find(".left.sliding")
                                                          .find(
                                                              ".back .icon + span"
                                                          )
                                                          .eq(0)),
                                            e.length &&
                                                b.each(function (t) {
                                                    Ee(t).hasClass("title") &&
                                                        (t.f7NavbarLeftOffset +=
                                                            e.prev(
                                                                ".icon"
                                                            )[0].offsetWidth);
                                                })),
                                        g.each(function (t) {
                                            var l = Ee(t),
                                                c = l.hasClass("subnavbar"),
                                                p = l.hasClass("left"),
                                                d = l.hasClass("title"),
                                                h = l.hasClass("navbar-bg");
                                            if (
                                                ((!d && !h) || !n) &&
                                                (u ||
                                                    !l.hasClass(".title-large"))
                                            ) {
                                                var g = { el: t };
                                                if (u) {
                                                    if (d) return;
                                                    if (
                                                        l.hasClass(
                                                            "title-large"
                                                        )
                                                    )
                                                        return (
                                                            a.indexOf(g) < 0 &&
                                                                a.push(g),
                                                            (g.overflow =
                                                                "visible"),
                                                            void l
                                                                .find(
                                                                    ".title-large-text"
                                                                )
                                                                .each(function (
                                                                    e
                                                                ) {
                                                                    a.push({
                                                                        el: e,
                                                                        transform:
                                                                            function (
                                                                                e
                                                                            ) {
                                                                                return (
                                                                                    "translateX(" +
                                                                                    100 *
                                                                                        e *
                                                                                        r +
                                                                                    "%)"
                                                                                );
                                                                            },
                                                                    });
                                                                })
                                                        );
                                                }
                                                if (
                                                    v &&
                                                    (u ||
                                                        (l.hasClass(
                                                            "title-large"
                                                        ) &&
                                                            (a.indexOf(g) < 0 &&
                                                                a.push(g),
                                                            (g.opacity = 0))),
                                                    p)
                                                )
                                                    return (
                                                        a.indexOf(g) < 0 &&
                                                            a.push(g),
                                                        (g.opacity = function (
                                                            e
                                                        ) {
                                                            return (
                                                                1 -
                                                                Math.pow(
                                                                    e,
                                                                    0.33
                                                                )
                                                            );
                                                        }),
                                                        void l
                                                            .find(".back span")
                                                            .each(function (e) {
                                                                a.push({
                                                                    el: e,
                                                                    "transform-origin":
                                                                        P,
                                                                    transform:
                                                                        function (
                                                                            e
                                                                        ) {
                                                                            return (
                                                                                "translateX(calc(" +
                                                                                e +
                                                                                " * (var(--f7-navbarTitleLargeOffset) - var(--f7-navbarLeftTextOffset)))) translateY(calc(" +
                                                                                e +
                                                                                " * (var(--f7-navbar-large-title-height) - var(--f7-navbar-large-title-padding-vertical) / 2))) scale(" +
                                                                                (1 +
                                                                                    1 *
                                                                                        e) +
                                                                                ")"
                                                                            );
                                                                        },
                                                                });
                                                            })
                                                    );
                                                if (h)
                                                    return (
                                                        a.indexOf(g) < 0 &&
                                                            a.push(g),
                                                        u ||
                                                            v ||
                                                            (i
                                                                ? (s &&
                                                                      (g.className =
                                                                          "ios-swipeback-navbar-bg-large"),
                                                                  (g.transform =
                                                                      function (
                                                                          e
                                                                      ) {
                                                                          return (
                                                                              "translateX(" +
                                                                              100 *
                                                                                  e *
                                                                                  r +
                                                                              "%) translateY(calc(-1 * var(--f7-navbar-large-title-height)))"
                                                                          );
                                                                      }))
                                                                : (g.transform =
                                                                      function (
                                                                          e
                                                                      ) {
                                                                          return (
                                                                              "translateX(" +
                                                                              100 *
                                                                                  e *
                                                                                  r +
                                                                              "%)"
                                                                          );
                                                                      })),
                                                        !u &&
                                                            v &&
                                                            ((g.className =
                                                                "ios-swipeback-navbar-bg-large"),
                                                            (g.transform =
                                                                function (e) {
                                                                    return (
                                                                        "translateX(" +
                                                                        100 *
                                                                            e *
                                                                            r +
                                                                        "%) translateY(calc(-1 * " +
                                                                        (1 -
                                                                            e) +
                                                                        " * var(--f7-navbar-large-title-height)))"
                                                                    );
                                                                })),
                                                        u &&
                                                            v &&
                                                            (g.transform =
                                                                function (e) {
                                                                    return (
                                                                        "translateX(" +
                                                                        100 *
                                                                            e *
                                                                            r +
                                                                        "%)"
                                                                    );
                                                                }),
                                                        void (
                                                            u &&
                                                            !v &&
                                                            (g.transform =
                                                                function (e) {
                                                                    return (
                                                                        "translateX(" +
                                                                        100 *
                                                                            e *
                                                                            r +
                                                                        "%) translateY(calc(-" +
                                                                        e +
                                                                        " * var(--f7-navbar-large-title-height)))"
                                                                    );
                                                                })
                                                        )
                                                    );
                                                if (
                                                    !l.hasClass("title-large")
                                                ) {
                                                    var b =
                                                        l.hasClass("sliding") ||
                                                        l.parents(
                                                            ".navbar-inner.sliding"
                                                        ).length;
                                                    if (
                                                        (a.indexOf(g) < 0 &&
                                                            a.push(g),
                                                        (!c || (c && !b)) &&
                                                            (g.opacity =
                                                                function (e) {
                                                                    return (
                                                                        1 -
                                                                        Math.pow(
                                                                            e,
                                                                            0.33
                                                                        )
                                                                    );
                                                                }),
                                                        b)
                                                    ) {
                                                        var y = g;
                                                        if (
                                                            p &&
                                                            e.length &&
                                                            f.iosAnimateNavbarBackIcon
                                                        ) {
                                                            var w = {
                                                                el: e[0],
                                                            };
                                                            (y = w), a.push(w);
                                                        }
                                                        y.transform = function (
                                                            e
                                                        ) {
                                                            var t =
                                                                e *
                                                                y.el
                                                                    .f7NavbarRightOffset;
                                                            return (
                                                                1 ===
                                                                    m.pixelRatio &&
                                                                    (t =
                                                                        Math.round(
                                                                            t
                                                                        )),
                                                                c && o
                                                                    ? "translate3d(" +
                                                                      t +
                                                                      "px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)"
                                                                    : "translate3d(" +
                                                                      t +
                                                                      "px,0,0)"
                                                            );
                                                        };
                                                    }
                                                }
                                            }
                                        }),
                                        b.each(function (e) {
                                            var n = Ee(e),
                                                o = n.hasClass("subnavbar"),
                                                i = n.hasClass("left"),
                                                s = n.hasClass("title"),
                                                h = n.hasClass("navbar-bg");
                                            if ((!s && !h) || !l) {
                                                var g = { el: e };
                                                if (v) {
                                                    if (s) return;
                                                    if (
                                                        (a.indexOf(g) < 0 &&
                                                            a.push(g),
                                                        n.hasClass(
                                                            "title-large"
                                                        ))
                                                    )
                                                        return (
                                                            (g.opacity = 1),
                                                            (g.overflow =
                                                                "visible"),
                                                            void n
                                                                .find(
                                                                    ".title-large-text"
                                                                )
                                                                .each(function (
                                                                    e
                                                                ) {
                                                                    a.push({
                                                                        el: e,
                                                                        "transform-origin":
                                                                            O,
                                                                        opacity:
                                                                            function (
                                                                                e
                                                                            ) {
                                                                                return Math.pow(
                                                                                    e,
                                                                                    3
                                                                                );
                                                                            },
                                                                        transform:
                                                                            function (
                                                                                e
                                                                            ) {
                                                                                return (
                                                                                    "translateX(calc(" +
                                                                                    (1 -
                                                                                        e) +
                                                                                    " * (var(--f7-navbarLeftTextOffset) - var(--f7-navbarTitleLargeOffset)))) translateY(calc(" +
                                                                                    (e -
                                                                                        1) +
                                                                                    " * var(--f7-navbar-large-title-height) + " +
                                                                                    (1 -
                                                                                        e) +
                                                                                    " * var(--f7-navbar-large-title-padding-vertical))) scale(" +
                                                                                    (0.5 +
                                                                                        0.5 *
                                                                                            e) +
                                                                                    ")"
                                                                                );
                                                                            },
                                                                    });
                                                                })
                                                        );
                                                }
                                                if (h)
                                                    return (
                                                        a.indexOf(g) < 0 &&
                                                            a.push(g),
                                                        u ||
                                                            v ||
                                                            (p
                                                                ? (d &&
                                                                      (g.className =
                                                                          "ios-swipeback-navbar-bg-large"),
                                                                  (g.transform =
                                                                      function (
                                                                          e
                                                                      ) {
                                                                          return (
                                                                              "translateX(" +
                                                                              (100 *
                                                                                  e -
                                                                                  100) *
                                                                                  r +
                                                                              "%) translateY(calc(-1 * var(--f7-navbar-large-title-height)))"
                                                                          );
                                                                      }))
                                                                : (g.transform =
                                                                      function (
                                                                          e
                                                                      ) {
                                                                          return (
                                                                              "translateX(" +
                                                                              (100 *
                                                                                  e -
                                                                                  100) *
                                                                                  r +
                                                                              "%)"
                                                                          );
                                                                      })),
                                                        !u &&
                                                            v &&
                                                            (g.transform =
                                                                function (e) {
                                                                    return (
                                                                        "translateX(" +
                                                                        (100 *
                                                                            e -
                                                                            100) *
                                                                            r +
                                                                        "%) translateY(calc(-1 * " +
                                                                        (1 -
                                                                            e) +
                                                                        " * var(--f7-navbar-large-title-height)))"
                                                                    );
                                                                }),
                                                        u &&
                                                            !v &&
                                                            ((g.className =
                                                                "ios-swipeback-navbar-bg-large"),
                                                            (g.transform =
                                                                function (e) {
                                                                    return (
                                                                        "translateX(" +
                                                                        (100 *
                                                                            e -
                                                                            100) *
                                                                            r +
                                                                        "%) translateY(calc(-" +
                                                                        e +
                                                                        " * var(--f7-navbar-large-title-height)))"
                                                                    );
                                                                })),
                                                        void (
                                                            u &&
                                                            v &&
                                                            (g.transform =
                                                                function (e) {
                                                                    return (
                                                                        "translateX(" +
                                                                        (100 *
                                                                            e -
                                                                            100) *
                                                                            r +
                                                                        "%)"
                                                                    );
                                                                })
                                                        )
                                                    );
                                                if (
                                                    !n.hasClass("title-large")
                                                ) {
                                                    var b =
                                                        n.hasClass("sliding") ||
                                                        x.children(
                                                            ".navbar-inner.sliding"
                                                        ).length;
                                                    if (
                                                        (a.indexOf(g) < 0 &&
                                                            a.push(g),
                                                        (!o || (o && !b)) &&
                                                            (g.opacity =
                                                                function (e) {
                                                                    return Math.pow(
                                                                        e,
                                                                        3
                                                                    );
                                                                }),
                                                        b)
                                                    ) {
                                                        var y = g;
                                                        if (
                                                            i &&
                                                            t.length &&
                                                            f.iosAnimateNavbarBackIcon
                                                        ) {
                                                            var w = {
                                                                el: t[0],
                                                            };
                                                            (y = w), a.push(w);
                                                        }
                                                        y.transform = function (
                                                            e
                                                        ) {
                                                            var t =
                                                                y.el
                                                                    .f7NavbarLeftOffset *
                                                                (1 - e);
                                                            return (
                                                                1 ===
                                                                    m.pixelRatio &&
                                                                    (t =
                                                                        Math.round(
                                                                            t
                                                                        )),
                                                                o && c
                                                                    ? "translate3d(" +
                                                                      t +
                                                                      "px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)"
                                                                    : "translate3d(" +
                                                                      t +
                                                                      "px,0,0)"
                                                            );
                                                        };
                                                    }
                                                }
                                            }
                                        }),
                                        a
                                    );
                                })())),
                            Ee(".sheet.modal-in").length > 0 &&
                                h.sheet &&
                                h.sheet.close(Ee(".sheet.modal-in"));
                    }
                    (e.f7PreventSwipePanel = !0),
                        (b = !0),
                        (h.preventSwipePanelBySwipeBack = !0),
                        e.preventDefault();
                    var L = h.rtl ? -1 : 1;
                    (r = (n - y.x - M) * L) < 0 && (r = 0);
                    var z = Math.min(Math.max(r / a, 0), 1),
                        R = {
                            percentage: z,
                            progress: z,
                            currentPageEl: w[0],
                            previousPageEl: C[0],
                            currentNavbarEl: k[0],
                            previousNavbarEl: x[0],
                        };
                    d.trigger("swipeback:move", R), p.emit("swipebackMove", R);
                    var A = r * L,
                        D = (r / 5 - a / 5) * L;
                    h.rtl
                        ? ((A = Math.max(A, -a)), (D = Math.max(D, 0)))
                        : ((A = Math.min(A, a)), (D = Math.min(D, 0))),
                        1 === m.pixelRatio &&
                            ((A = Math.round(A)), (D = Math.round(D))),
                        (p.swipeBackActive = !0),
                        Ee([w[0], C[0]]).addClass("page-swipeback-active"),
                        w.transform("translate3d(" + A + "px,0,0)"),
                        $ && (i[0].style.opacity = 1 - 1 * z),
                        "ios" === h.theme &&
                            C.transform("translate3d(" + D + "px,0,0)"),
                        T && (s[0].style.opacity = 1 - 1 * z),
                        o && I({ progress: z });
                }
            }
        }
        function z() {
            if (((h.preventSwipePanelBySwipeBack = !1), !g || !b))
                return (g = !1), void (b = !1);
            (g = !1), (b = !1), (p.swipeBackActive = !1);
            var e = Ee([w[0], C[0]]);
            if ((e.removeClass("page-swipeback-active"), 0 === r))
                return (
                    e.transform(""),
                    i && i.length > 0 && i.remove(),
                    s && s.length > 0 && s.remove(),
                    void (o && I({ reset: !0 }))
                );
            var t = Ye() - n,
                l = !1;
            ((t < 300 && r > 10) || (t >= 300 && r > a / 2)) &&
                (w
                    .removeClass("page-current")
                    .addClass(
                        "page-next" +
                            ("ios" !== h.theme ? " page-next-on-right" : "")
                    ),
                C.removeClass("page-previous")
                    .addClass("page-current")
                    .removeAttr("aria-hidden"),
                i && (i[0].style.opacity = ""),
                s && (s[0].style.opacity = ""),
                o &&
                    (p.setNavbarPosition(k, "next"),
                    p.setNavbarPosition(x, "current", !1)),
                (l = !0)),
                e.addClass("page-transitioning page-transitioning-swipeback"),
                m.ios && (w[0]._clientLeft = w[0].clientLeft),
                e.transform(""),
                o &&
                    I({ progress: l ? 1 : 0, transition: !0, reflow: !!m.ios }),
                (E = !1),
                (p.allowPageChange = !1);
            var c = {
                currentPageEl: w[0],
                previousPageEl: C[0],
                currentNavbarEl: k[0],
                previousNavbarEl: x[0],
            };
            l
                ? ((p.currentRoute = C[0].f7Page.route),
                  (p.currentPage = C[0]),
                  p.pageCallback("beforeOut", w, k, "current", "next", {
                      route: w[0].f7Page.route,
                      swipeBack: !0,
                  }),
                  p.pageCallback(
                      "beforeIn",
                      C,
                      x,
                      "previous",
                      "current",
                      { route: C[0].f7Page.route, swipeBack: !0 },
                      w[0]
                  ),
                  d.trigger("swipeback:beforechange", c),
                  p.emit("swipebackBeforeChange", c))
                : (d.trigger("swipeback:beforereset", c),
                  p.emit("swipebackBeforeReset", c)),
                w.transitionEnd(function () {
                    e.removeClass(
                        "page-transitioning page-transitioning-swipeback"
                    ),
                        o && I({ reset: !0, transition: !1 }),
                        (E = !0),
                        (p.allowPageChange = !0),
                        l
                            ? (1 === p.history.length &&
                                  p.history.unshift(p.url),
                              p.history.pop(),
                              p.saveHistory(),
                              f.browserHistory && Rt.back(),
                              p.pageCallback(
                                  "afterOut",
                                  w,
                                  k,
                                  "current",
                                  "next",
                                  { route: w[0].f7Page.route, swipeBack: !0 }
                              ),
                              p.pageCallback(
                                  "afterIn",
                                  C,
                                  x,
                                  "previous",
                                  "current",
                                  { route: C[0].f7Page.route, swipeBack: !0 }
                              ),
                              f.stackPages && p.initialPages.indexOf(w[0]) >= 0
                                  ? (w.addClass("stacked"),
                                    o && k.addClass("stacked"))
                                  : (p.pageCallback(
                                        "beforeRemove",
                                        w,
                                        k,
                                        "next",
                                        { swipeBack: !0 }
                                    ),
                                    p.removePage(w),
                                    o && p.removeNavbar(k)),
                              d.trigger("swipeback:afterchange", c),
                              p.emit("swipebackAfterChange", c),
                              p.emit(
                                  "routeChanged",
                                  p.currentRoute,
                                  p.previousRoute,
                                  p
                              ),
                              f.preloadPreviousPage &&
                                  p.back(p.history[p.history.length - 2], {
                                      preload: !0,
                                  }))
                            : (d.trigger("swipeback:afterreset", c),
                              p.emit("swipebackAfterReset", c)),
                        i && i.length > 0 && i.remove(),
                        s && s.length > 0 && s.remove();
                });
        }
        (c = !("touchstart" !== h.touchEvents.start || !v.passiveListener) && {
            passive: !0,
            capture: !1,
        }),
            d.on(h.touchEvents.start, B, c),
            h.on("touchmove:active", L),
            h.on("touchend:passive", z),
            p.on("routerDestroy", function () {
                var e = !(
                    "touchstart" !== h.touchEvents.start || !v.passiveListener
                ) && { passive: !0, capture: !1 };
                d.off(h.touchEvents.start, B, e),
                    h.off("touchmove:active", L),
                    h.off("touchend:passive", z);
            });
    }
    function Dt(e, t, a) {
        var r = this,
            n = t.route.redirect,
            o = "forward" === e ? "navigate" : "back";
        if (
            (a.initial &&
                r.params.browserHistory &&
                ((a.replaceState = !0), (a.history = !0)),
            "function" == typeof n)
        ) {
            r.allowPageChange = !1;
            var i = n.call(r, {
                router: r,
                to: t,
                resolve: function (e, t) {
                    void 0 === t && (t = {}),
                        (r.allowPageChange = !0),
                        r[o](e, Qe({}, a, t));
                },
                reject: function () {
                    r.allowPageChange = !0;
                },
                direction: e,
                app: r.app,
            });
            return i && "string" == typeof i
                ? ((r.allowPageChange = !0), r[o](i, a))
                : r;
        }
        return r[o](n, a);
    }
    function Ht(e, t, a, r, n, o, i, s) {
        var l = [];
        Array.isArray(a)
            ? l.push.apply(l, a)
            : a && "function" == typeof a && l.push(a),
            t && (Array.isArray(t) ? l.push.apply(l, t) : l.push(t)),
            (function t() {
                0 !== l.length
                    ? l.shift().call(e, {
                          router: e,
                          to: r,
                          from: n,
                          resolve: function () {
                              t();
                          },
                          reject: function () {
                              i();
                          },
                          direction: s,
                          app: e.app,
                      })
                    : o();
            })();
    }
    function Nt(e, t, a, r, n) {
        var o = this;
        function i() {
            e && e.route && (o.params.routesBeforeEnter || e.route.beforeEnter)
                ? ((o.allowPageChange = !1),
                  Ht(
                      o,
                      o.params.routesBeforeEnter,
                      e.route.beforeEnter,
                      e,
                      t,
                      function () {
                          (o.allowPageChange = !0), a();
                      },
                      function () {
                          r();
                      },
                      n
                  ))
                : a();
        }
        t && t.route && (o.params.routesBeforeLeave || t.route.beforeLeave)
            ? ((o.allowPageChange = !1),
              Ht(
                  o,
                  o.params.routesBeforeLeave,
                  t.route.beforeLeave,
                  e,
                  t,
                  function () {
                      (o.allowPageChange = !0), i();
                  },
                  function () {
                      r();
                  },
                  n
              ))
            : i();
    }
    function Vt(e, t) {
        if (!e.view)
            throw new Error(
                "Framework7: it is not allowed to use router methods on global app router. Use router methods only on related View, e.g. app.views.main.router." +
                    t +
                    "(...)"
            );
    }
    function Ft(e, t, a, r) {
        function n(e) {
            e.then(function (e) {
                a({ component: e.default || e._default || e });
            }).catch(function (e) {
                throw (r(), new Error(e));
            });
        }
        if (t instanceof Promise) n(t);
        else {
            var o = t.call(e);
            o instanceof Promise ? n(o) : a({ component: o });
        }
    }
    function qt(e, t, a) {
        void 0 === a && (a = {});
        var n,
            o,
            i,
            s = r(),
            l = Ee(t),
            c = e.app,
            p = e.view,
            d = Qe(
                !1,
                {
                    animate: e.params.animate,
                    browserHistory: !0,
                    replaceState: !1,
                    history: !0,
                    reloadCurrent: e.params.reloadPages,
                    reloadPrevious: !1,
                    reloadAll: !1,
                    clearPreviousHistory: !1,
                    reloadDetail: e.params.reloadDetail,
                    on: {},
                },
                a
            ),
            u = e.params.masterDetailBreakpoint > 0,
            h =
                u &&
                d.route &&
                d.route.route &&
                (!0 === d.route.route.master ||
                    ("function" == typeof d.route.route.master &&
                        d.route.route.master(c, e))),
            f = 0,
            v = e.currentRoute.modal;
        if (
            (v ||
                "popup popover sheet loginScreen actions customModal panel"
                    .split(" ")
                    .forEach(function (t) {
                        e.currentRoute &&
                            e.currentRoute.route &&
                            e.currentRoute.route[t] &&
                            ((v = !0), (i = t));
                    }),
            v)
        ) {
            var m =
                    e.currentRoute.modal ||
                    e.currentRoute.route.modalInstance ||
                    c[i].get(),
                g = e.history[e.history.length - 2],
                b = e.findMatchingRoute(g);
            !b &&
                g &&
                (b = {
                    url: g,
                    path: g.split("?")[0],
                    query: We(g),
                    route: { path: g.split("?")[0], url: g },
                }),
                e.modalRemove(m);
        }
        var y,
            w,
            C,
            E,
            k = e.dynamicNavbar,
            x = e.$el,
            $ = l,
            T = d.reloadPrevious || d.reloadCurrent || d.reloadAll;
        if (((e.allowPageChange = !1), 0 === $.length))
            return (e.allowPageChange = !0), e;
        $.length && e.removeThemeElements($),
            k &&
                ((C = $.children(".navbar")),
                (w = e.$navbarsEl),
                0 === C.length &&
                    $[0] &&
                    $[0].f7Page &&
                    (C = $[0].f7Page.$navbarEl)),
            d.route &&
                d.route.route &&
                d.route.route.keepAlive &&
                !d.route.route.keepAliveData &&
                (d.route.route.keepAliveData = { pageEl: l[0] });
        var S,
            M,
            P,
            O,
            I = x.children(".page:not(.stacked)").filter(function (e) {
                return e !== $[0];
            });
        if (
            (k &&
                (S = w.children(".navbar:not(.stacked)").filter(function (e) {
                    return e !== C[0];
                })),
            d.reloadPrevious && I.length < 2)
        )
            return (e.allowPageChange = !0), e;
        if (u && !d.reloadAll) {
            for (var B = 0; B < I.length; B += 1)
                n || !I[B].classList.contains("page-master") || (n = I[B]);
            if ((M = !h && n) && n)
                for (var L = 0; L < I.length; L += 1)
                    I[L].classList.contains("page-master-detail") && (o = I[L]);
            P =
                M &&
                d.reloadDetail &&
                c.width >= e.params.masterDetailBreakpoint &&
                n;
        }
        M && (O = !o || P || d.reloadAll || d.reloadCurrent);
        var z = "next";
        if (
            (d.reloadCurrent || d.reloadAll || P
                ? (z = "current")
                : d.reloadPrevious && (z = "previous"),
            $.removeClass("page-previous page-current page-next")
                .addClass(
                    "page-" +
                        z +
                        (h ? " page-master" : "") +
                        (M ? " page-master-detail" : "") +
                        (O ? " page-master-detail-root" : "")
                )
                .removeClass("stacked")
                .trigger("page:unstack")
                .trigger("page:position", { position: z }),
            e.emit("pageUnstack", $[0]),
            e.emit("pagePosition", $[0], z),
            (h || M) &&
                ($.trigger("page:role", {
                    role: h ? "master" : "detail",
                    root: !!O,
                }),
                e.emit("pageRole", $[0], {
                    role: h ? "master" : "detail",
                    detailRoot: !!O,
                })),
            k &&
                C.length &&
                (C.removeClass("navbar-previous navbar-current navbar-next")
                    .addClass(
                        "navbar-" +
                            z +
                            (h ? " navbar-master" : "") +
                            (M ? " navbar-master-detail" : "") +
                            (O ? " navbar-master-detail-root" : "")
                    )
                    .removeClass("stacked"),
                C.trigger("navbar:position", { position: z }),
                e.emit("navbarPosition", C[0], z),
                (h || M) &&
                    e.emit("navbarRole", C[0], {
                        role: h ? "master" : "detail",
                        detailRoot: !!O,
                    })),
            d.reloadCurrent || P)
        )
            P
                ? ((y = I.filter(function (e) {
                      return !e.classList.contains("page-master");
                  })),
                  k &&
                      (E = Ee(
                          y.map(function (e) {
                              return c.navbar.getElByPage(e);
                          })
                      )),
                  y.length > 1 &&
                      n &&
                      ((f = y.length - 1),
                      Ee(n)
                          .removeClass("page-master-stacked")
                          .trigger("page:masterunstack"),
                      e.emit("pageMasterUnstack", n),
                      k &&
                          (Ee(c.navbar.getElByPage(n)).removeClass(
                              "navbar-master-stacked"
                          ),
                          e.emit(
                              "navbarMasterUnstack",
                              c.navbar.getElByPage(n)
                          ))))
                : ((y = I.eq(I.length - 1)),
                  k && (E = Ee(c.navbar.getElByPage(y))));
        else if (d.reloadPrevious)
            (y = I.eq(I.length - 2)), k && (E = Ee(c.navbar.getElByPage(y)));
        else if (d.reloadAll)
            (y = I.filter(function (e) {
                return e !== $[0];
            })),
                k &&
                    (E = S.filter(function (e) {
                        return e !== C[0];
                    }));
        else {
            var R = [],
                A = [];
            if (I.length > 1) {
                var D = 0;
                for (D = 0; D < I.length - 1; D += 1)
                    if (n && I[D] === n)
                        I.eq(D).addClass("page-master-stacked"),
                            I.eq(D).trigger("page:masterstack"),
                            e.emit("pageMasterStack", I[D]),
                            k &&
                                (Ee(c.navbar.getElByPage(n)).addClass(
                                    "navbar-master-stacked"
                                ),
                                e.emit(
                                    "navbarMasterStack",
                                    c.navbar.getElByPage(n)
                                ));
                    else {
                        var H = c.navbar.getElByPage(I.eq(D));
                        e.params.stackPages
                            ? (I.eq(D).addClass("stacked"),
                              I.eq(D).trigger("page:stack"),
                              e.emit("pageStack", I[D]),
                              k && Ee(H).addClass("stacked"))
                            : (R.push(I[D]),
                              e.pageCallback(
                                  "beforeRemove",
                                  I[D],
                                  S && S[D],
                                  "previous",
                                  void 0,
                                  d
                              ),
                              e.removePage(I[D]),
                              k && H && (A.push(H), e.removeNavbar(H)));
                    }
            }
            (y = x.children(".page:not(.stacked)").filter(function (e) {
                return e !== $[0] && R.indexOf(e) < 0;
            })),
                k &&
                    (E = w
                        .children(".navbar:not(.stacked)")
                        .filter(function (e) {
                            return e !== C[0] && A.indexOf(A) < 0;
                        })),
                (R = []),
                (A = []);
        }
        if (
            (M &&
                !d.reloadAll &&
                ((y.length > 1 || P) &&
                    (y = y.filter(function (e) {
                        return !e.classList.contains("page-master");
                    })),
                E &&
                    (E.length > 1 || P) &&
                    (E = E.filter(function (e) {
                        return !e.classList.contains("navbar-master");
                    }))),
            e.params.browserHistory &&
                (d.browserHistory || d.replaceState) &&
                !d.reloadPrevious)
        ) {
            var N = e.params.browserHistoryRoot || "";
            Rt[
                d.reloadCurrent || (P && o) || d.reloadAll || d.replaceState
                    ? "replace"
                    : "push"
            ](
                p.id,
                { url: d.route.url },
                N + e.params.browserHistorySeparator + d.route.url
            );
        }
        d.reloadPrevious ||
            ((e.currentPageEl = $[0]),
            k && C.length
                ? (e.currentNavbarEl = C[0])
                : delete e.currentNavbarEl,
            (e.currentRoute = d.route));
        var V = d.route.url;
        d.history &&
            (((d.reloadCurrent || (P && o)) && e.history.length) > 0 ||
            d.replaceState
                ? (P &&
                      f > 0 &&
                      (e.history = e.history.slice(0, e.history.length - f)),
                  (e.history[e.history.length - (d.reloadPrevious ? 2 : 1)] =
                      V))
                : d.reloadPrevious
                ? (e.history[e.history.length - 2] = V)
                : d.reloadAll
                ? (e.history = [V])
                : e.history.push(V)),
            e.saveHistory();
        var F = $.parents(s).length > 0,
            q = $[0].f7Component;
        if (
            (d.reloadPrevious
                ? (q && !F
                      ? q.mount(function (e) {
                            Ee(e).insertBefore(y);
                        })
                      : $.insertBefore(y),
                  k &&
                      C.length &&
                      (C.find(".title-large").length &&
                          C.addClass("navbar-large"),
                      E.length
                          ? C.insertBefore(E)
                          : (e.$navbarsEl.parents(s).length ||
                                e.$el.prepend(e.$navbarsEl),
                            w.append(C))))
                : (y.next(".page")[0] !== $[0] &&
                      (q && !F
                          ? q.mount(function (e) {
                                x.append(e);
                            })
                          : x.append($[0])),
                  k &&
                      C.length &&
                      (C.find(".title-large").length &&
                          C.addClass("navbar-large"),
                      e.$navbarsEl.parents(s).length ||
                          e.$el.prepend(e.$navbarsEl),
                      w.append(C[0]))),
            F
                ? d.route &&
                  d.route.route &&
                  d.route.route.keepAlive &&
                  !$[0].f7PageMounted &&
                  (($[0].f7PageMounted = !0),
                  e.pageCallback("mounted", $, C, z, T ? z : "current", d, y))
                : e.pageCallback("mounted", $, C, z, T ? z : "current", d, y),
            (d.reloadCurrent || P) && y.length > 0
                ? e.params.stackPages && e.initialPages.indexOf(y[0]) >= 0
                    ? (y.addClass("stacked"),
                      y.trigger("page:stack"),
                      e.emit("pageStack", y[0]),
                      k && E.addClass("stacked"))
                    : (e.pageCallback("beforeOut", y, E, "current", void 0, d),
                      e.pageCallback("afterOut", y, E, "current", void 0, d),
                      e.pageCallback(
                          "beforeRemove",
                          y,
                          E,
                          "current",
                          void 0,
                          d
                      ),
                      e.removePage(y),
                      k && E && E.length && e.removeNavbar(E))
                : d.reloadAll
                ? y.each(function (t, a) {
                      var r = Ee(t),
                          n = Ee(c.navbar.getElByPage(r));
                      e.params.stackPages && e.initialPages.indexOf(r[0]) >= 0
                          ? (r.addClass("stacked"),
                            r.trigger("page:stack"),
                            e.emit("pageStack", r[0]),
                            k && n.addClass("stacked"))
                          : (r.hasClass("page-current") &&
                                (e.pageCallback(
                                    "beforeOut",
                                    y,
                                    E,
                                    "current",
                                    void 0,
                                    d
                                ),
                                e.pageCallback(
                                    "afterOut",
                                    y,
                                    E,
                                    "current",
                                    void 0,
                                    d
                                )),
                            e.pageCallback(
                                "beforeRemove",
                                r,
                                E && E.eq(a),
                                "previous",
                                void 0,
                                d
                            ),
                            e.removePage(r),
                            k && n.length && e.removeNavbar(n));
                  })
                : d.reloadPrevious &&
                  (e.params.stackPages && e.initialPages.indexOf(y[0]) >= 0
                      ? (y.addClass("stacked"),
                        y.trigger("page:stack"),
                        e.emit("pageStack", y[0]),
                        k && E.addClass("stacked"))
                      : (e.pageCallback(
                            "beforeRemove",
                            y,
                            E,
                            "previous",
                            void 0,
                            d
                        ),
                        e.removePage(y),
                        k && E && E.length && e.removeNavbar(E))),
            d.route.route.tab &&
                e.tabLoad(
                    d.route.route.tab,
                    Qe({}, d, { history: !1, browserHistory: !1 })
                ),
            u && p.checkMasterDetailBreakpoint(),
            e.pageCallback("init", $, C, z, T ? z : "current", d, y),
            d.reloadCurrent || d.reloadAll || P)
        )
            return (
                (e.allowPageChange = !0),
                e.pageCallback("beforeIn", $, C, z, "current", d),
                $.removeAttr("aria-hidden"),
                k && C && C.removeAttr("aria-hidden"),
                e.pageCallback("afterIn", $, C, z, "current", d),
                d.reloadCurrent &&
                    d.clearPreviousHistory &&
                    e.clearPreviousHistory(),
                P &&
                    (e.setPagePosition(Ee(n), "previous"),
                    n.f7Page &&
                        n.f7Page.navbarEl &&
                        e.setNavbarPosition(Ee(n.f7Page.navbarEl), "previous")),
                e
            );
        if (d.reloadPrevious) return (e.allowPageChange = !0), e;
        function j() {
            e.setPagePosition($, "current", !1),
                e.setPagePosition(y, "previous", !y.hasClass("page-master")),
                k &&
                    (e.setNavbarPosition(C, "current", !1),
                    e.setNavbarPosition(
                        E,
                        "previous",
                        !E.hasClass("navbar-master")
                    )),
                (e.allowPageChange = !0),
                e.pageCallback("afterOut", y, E, "current", "previous", d),
                e.pageCallback("afterIn", $, C, "next", "current", d);
            var t =
                (e.params.preloadPreviousPage ||
                    e.params[c.theme + "SwipeBack"]) &&
                !h;
            t ||
                (($.hasClass("smart-select-page") ||
                    $.hasClass("photo-browser-page") ||
                    $.hasClass("autocomplete-page") ||
                    $.hasClass("color-picker-page")) &&
                    (t = !0)),
                t ||
                    (e.params.stackPages
                        ? (y.addClass("stacked"),
                          y.trigger("page:stack"),
                          e.emit("pageStack", y[0]),
                          k && E.addClass("stacked"))
                        : ($.attr("data-name") &&
                              "smart-select-page" === $.attr("data-name")) ||
                          (e.pageCallback(
                              "beforeRemove",
                              y,
                              E,
                              "previous",
                              void 0,
                              d
                          ),
                          e.removePage(y),
                          k && E.length && e.removeNavbar(E))),
                d.clearPreviousHistory && e.clearPreviousHistory(),
                e.emit("routeChanged", e.currentRoute, e.previousRoute, e),
                e.params.browserHistory && Rt.clearRouterQueue();
        }
        function _() {
            e.setPagePosition(y, "current", !1),
                e.setPagePosition($, "next", !1),
                k &&
                    (e.setNavbarPosition(E, "current", !1),
                    e.setNavbarPosition(C, "next", !1));
        }
        if (
            (e.pageCallback("beforeOut", y, E, "current", "previous", d),
            e.pageCallback("beforeIn", $, C, "next", "current", d),
            !d.animate || (h && c.width >= e.params.masterDetailBreakpoint))
        )
            j();
        else {
            var Y = e.params[e.app.theme + "PageLoadDelay"],
                W = e.params.transition;
            d.transition && (W = d.transition),
                !W &&
                    e.currentRoute &&
                    e.currentRoute.route &&
                    (W = e.currentRoute.route.transition),
                !W &&
                    e.currentRoute &&
                    e.currentRoute.route.options &&
                    (W = e.currentRoute.route.options.transition),
                W && ($[0].f7PageTransition = W),
                Y
                    ? setTimeout(function () {
                          _(),
                              e.animate(y, $, E, C, "forward", W, function () {
                                  j();
                              });
                      }, Y)
                    : (_(),
                      e.animate(y, $, E, C, "forward", W, function () {
                          j();
                      }));
        }
        return e;
    }
    function jt(e, t, a, r) {
        if (
            (void 0 === t && (t = {}),
            void 0 === a && (a = {}),
            !e.allowPageChange && !r)
        )
            return e;
        var n = t,
            o = a,
            i = n.url,
            s = n.content,
            l = n.el,
            c = n.pageName,
            p = n.component,
            d = n.componentUrl;
        if (
            !o.reloadCurrent &&
            o.route &&
            o.route.route &&
            o.route.route.parentPath &&
            e.currentRoute.route &&
            e.currentRoute.route.parentPath === o.route.route.parentPath
        ) {
            if (o.route.url === e.url) return (e.allowPageChange = !0), !1;
            var u =
                Object.keys(o.route.params).length ===
                Object.keys(e.currentRoute.params).length;
            if (
                (u &&
                    Object.keys(o.route.params).forEach(function (t) {
                        (t in e.currentRoute.params &&
                            e.currentRoute.params[t] === o.route.params[t]) ||
                            (u = !1);
                    }),
                u)
            )
                return !!o.route.route.tab && e.tabLoad(o.route.route.tab, o);
            if (
                !u &&
                o.route.route.tab &&
                e.currentRoute.route.tab &&
                e.currentRoute.parentPath === o.route.parentPath
            )
                return e.tabLoad(o.route.route.tab, o);
        }
        if (
            o.route &&
            o.route.url &&
            e.url === o.route.url &&
            !o.reloadCurrent &&
            !o.reloadPrevious &&
            !e.params.allowDuplicateUrls
        )
            return (e.allowPageChange = !0), !1;
        if (
            (!o.route &&
                i &&
                ((o.route = e.parseRouteUrl(i)),
                Qe(o.route, { route: { url: i, path: i } })),
            (i || d || p) && (e.allowPageChange = !1),
            s)
        )
            qt(e, e.getPageEl(s), o);
        else if (l) qt(e, e.getPageEl(l), o);
        else if (c)
            qt(e, e.$el.children('.page[data-name="' + c + '"]').eq(0), o);
        else if (p || d)
            try {
                e.pageComponentLoader({
                    routerEl: e.el,
                    component: p,
                    componentUrl: d,
                    options: o,
                    resolve: function (t, a) {
                        return qt(e, t, Qe(o, a));
                    },
                    reject: function () {
                        return (e.allowPageChange = !0), e;
                    },
                });
            } catch (t) {
                throw ((e.allowPageChange = !0), t);
            }
        else
            i &&
                (e.xhrAbortController &&
                    (e.xhrAbortController.abort(), (e.xhrAbortController = !1)),
                e
                    .xhrRequest(i, o)
                    .then(function (t) {
                        qt(e, e.getPageEl(t), o);
                    })
                    .catch(function () {
                        e.allowPageChange = !0;
                    }));
        return e;
    }
    function _t(e, t, a) {
        var n,
            o,
            i,
            s,
            l,
            c,
            p,
            d,
            u = pt(),
            h = r(),
            f = Ee(t),
            v = e.app,
            m = e.view,
            g = Qe(
                {
                    animate: e.params.animate,
                    browserHistory: !0,
                    replaceState: !1,
                },
                a
            ),
            b = e.params.masterDetailBreakpoint > 0,
            y =
                b &&
                g.route &&
                g.route.route &&
                (!0 === g.route.route.master ||
                    ("function" == typeof g.route.route.master &&
                        g.route.route.master(v, e))),
            w = e.dynamicNavbar,
            C = f,
            E = e.$el.children(".page-current"),
            k = 0 === E.length && g.preload,
            x = b && E.hasClass("page-master");
        if (
            (C.length && e.removeThemeElements(C),
            w &&
                ((s = C.children(".navbar")),
                (i = e.$navbarsEl),
                0 === s.length &&
                    C[0] &&
                    C[0].f7Page &&
                    (s = C[0].f7Page.$navbarEl),
                (l = i.find(".navbar-current"))),
            (e.allowPageChange = !1),
            0 === C.length || (0 === E.length && !g.preload))
        )
            return (e.allowPageChange = !0), e;
        if (
            (e.removeThemeElements(C),
            g.route &&
                g.route.route &&
                g.route.route.keepAlive &&
                !g.route.route.keepAliveData &&
                (g.route.route.keepAliveData = { pageEl: f[0] }),
            b)
        ) {
            for (
                var $ = e.$el
                        .children(".page:not(.stacked)")
                        .filter(function (e) {
                            return e !== C[0];
                        }),
                    T = 0;
                T < $.length;
                T += 1
            )
                n || !$[T].classList.contains("page-master") || (n = $[T]);
            !(c =
                !y &&
                n &&
                e.history.indexOf(g.route.url) >
                    e.history.indexOf(n.f7Page.route.url)) &&
                !y &&
                n &&
                n.f7Page &&
                g.route.route.masterRoute &&
                (c =
                    g.route.route.masterRoute.path ===
                    n.f7Page.route.route.path);
        }
        if (
            (c &&
                n &&
                n.f7Page &&
                (p =
                    e.history.indexOf(g.route.url) -
                        e.history.indexOf(n.f7Page.route.url) ==
                    1),
            C.addClass(
                "page-" +
                    (k ? "current" : "previous") +
                    (y ? " page-master" : "") +
                    (c ? " page-master-detail" : "") +
                    (p ? " page-master-detail-root" : "")
            )
                .removeClass("stacked")
                .removeAttr("aria-hidden")
                .trigger("page:unstack")
                .trigger("page:position", {
                    position: k ? "current" : "previous",
                }),
            e.emit("pageUnstack", C[0]),
            e.emit("pagePosition", C[0], k ? "current" : "previous"),
            (y || c) &&
                (C.trigger("page:role", {
                    role: y ? "master" : "detail",
                    root: !!p,
                }),
                e.emit("pageRole", C[0], {
                    role: y ? "master" : "detail",
                    detailRoot: !!p,
                })),
            w &&
                s.length > 0 &&
                (s
                    .addClass(
                        "navbar-" +
                            (k ? "current" : "previous") +
                            (y ? " navbar-master" : "") +
                            (c ? " navbar-master-detail" : "") +
                            (p ? " navbar-master-detail-root" : "")
                    )
                    .removeClass("stacked")
                    .removeAttr("aria-hidden"),
                s.trigger("navbar:position", {
                    position: k ? "current" : "previous",
                }),
                e.emit("navbarPosition", s[0], k ? "current" : "previous"),
                (y || p) &&
                    e.emit("navbarRole", s[0], {
                        role: y ? "master" : "detail",
                        detailRoot: !!p,
                    })),
            g.force &&
                (E.prev(".page-previous:not(.stacked)").length > 0 ||
                    0 === E.prev(".page-previous").length))
        )
            if (
                (e.history.indexOf(g.route.url) >= 0
                    ? ((d =
                          e.history.length -
                          e.history.indexOf(g.route.url) -
                          1),
                      (e.history = e.history.slice(
                          0,
                          e.history.indexOf(g.route.url) + 2
                      )),
                      (m.history = e.history))
                    : e.history[[e.history.length - 2]]
                    ? (e.history[e.history.length - 2] = g.route.url)
                    : e.history.unshift(e.url),
                d && e.params.stackPages)
            )
                E.prevAll(".page-previous").each(function (t) {
                    var a,
                        r = Ee(t);
                    w && (a = Ee(v.navbar.getElByPage(r))),
                        r[0] !== C[0] &&
                            r.index() > C.index() &&
                            (e.initialPages.indexOf(r[0]) >= 0
                                ? (r.addClass("stacked"),
                                  r.trigger("page:stack"),
                                  e.emit("pageStack", r[0]),
                                  w && a.addClass("stacked"))
                                : (e.pageCallback(
                                      "beforeRemove",
                                      r,
                                      a,
                                      "previous",
                                      void 0,
                                      g
                                  ),
                                  r[0] === n && (o = !0),
                                  e.removePage(r),
                                  w && a.length > 0 && e.removeNavbar(a)));
                });
            else {
                var S,
                    M = E.prev(".page-previous:not(.stacked)");
                w && (S = Ee(v.navbar.getElByPage(M))),
                    e.params.stackPages && e.initialPages.indexOf(M[0]) >= 0
                        ? (M.addClass("stacked"),
                          M.trigger("page:stack"),
                          e.emit("pageStack", M[0]),
                          S.addClass("stacked"))
                        : M.length > 0 &&
                          (e.pageCallback(
                              "beforeRemove",
                              M,
                              S,
                              "previous",
                              void 0,
                              g
                          ),
                          M[0] === n && (o = !0),
                          e.removePage(M),
                          w && S.length && e.removeNavbar(S));
            }
        var P = C.parents(h).length > 0,
            O = C[0].f7Component;
        function I() {
            k &&
                (!P && O
                    ? O.mount(function (t) {
                          e.$el.append(t);
                      })
                    : e.$el.append(C)),
                0 === C.next(E).length &&
                    (!P && O
                        ? O.mount(function (e) {
                              Ee(e).insertBefore(E);
                          })
                        : C.insertBefore(E)),
                w &&
                    s.length &&
                    (s.find(".title-large").length &&
                        s.addClass("navbar-large"),
                    s.insertBefore(l),
                    l.length > 0
                        ? s.insertBefore(l)
                        : (e.$navbarsEl.parents(h).length ||
                              e.$el.prepend(e.$navbarsEl),
                          i.append(s))),
                P
                    ? g.route &&
                      g.route.route &&
                      g.route.route.keepAlive &&
                      !C[0].f7PageMounted &&
                      ((C[0].f7PageMounted = !0),
                      e.pageCallback(
                          "mounted",
                          C,
                          s,
                          "previous",
                          "current",
                          g,
                          E
                      ))
                    : e.pageCallback(
                          "mounted",
                          C,
                          s,
                          "previous",
                          "current",
                          g,
                          E
                      );
        }
        if (g.preload) {
            I(),
                g.route.route.tab &&
                    e.tabLoad(
                        g.route.route.tab,
                        Qe({}, g, {
                            history: !1,
                            browserHistory: !1,
                            preload: !0,
                        })
                    ),
                y &&
                    (C.removeClass("page-master-stacked").trigger(
                        "page:masterunstack"
                    ),
                    e.emit("pageMasterUnstack", C[0]),
                    w &&
                        (Ee(v.navbar.getElByPage(C)).removeClass(
                            "navbar-master-stacked"
                        ),
                        e.emit(
                            "navbarMasterUnstack",
                            v.navbar.getElByPage(C)
                        ))),
                e.pageCallback("init", C, s, "previous", "current", g, E),
                k &&
                    (e.pageCallback("beforeIn", C, s, "current", void 0, g),
                    e.pageCallback("afterIn", C, s, "current", void 0, g));
            var B = C.prevAll(".page-previous:not(.stacked):not(.page-master)");
            return (
                B.length > 0 &&
                    B.each(function (t) {
                        var a,
                            r = Ee(t);
                        w && (a = Ee(v.navbar.getElByPage(r))),
                            e.params.stackPages &&
                            e.initialPages.indexOf(t) >= 0
                                ? (r.addClass("stacked"),
                                  r.trigger("page:stack"),
                                  e.emit("pageStack", r[0]),
                                  w && a.addClass("stacked"))
                                : (e.pageCallback(
                                      "beforeRemove",
                                      r,
                                      a,
                                      "previous",
                                      void 0
                                  ),
                                  e.removePage(r),
                                  w && a.length && e.removeNavbar(a));
                    }),
                (e.allowPageChange = !0),
                e
            );
        }
        if (
            !(u.ie || u.edge || (u.firefox && !u.ios)) &&
            e.params.browserHistory &&
            g.browserHistory
        )
            if (g.replaceState) {
                var L = e.params.browserHistoryRoot || "";
                Rt.replace(
                    m.id,
                    { url: g.route.url },
                    L + e.params.browserHistorySeparator + g.route.url
                );
            } else d ? Rt.go(-d) : Rt.back();
        if (
            (g.replaceState
                ? (e.history[e.history.length - 1] = g.route.url)
                : (1 === e.history.length && e.history.unshift(e.url),
                  e.history.pop()),
            e.saveHistory(),
            (e.currentPageEl = C[0]),
            w && s.length
                ? (e.currentNavbarEl = s[0])
                : delete e.currentNavbarEl,
            (e.currentRoute = g.route),
            (u.ie || u.edge || (u.firefox && !u.ios)) &&
                e.params.browserHistory &&
                g.browserHistory)
        )
            if (g.replaceState) {
                var z = e.params.browserHistoryRoot || "";
                Rt.replace(
                    m.id,
                    { url: g.route.url },
                    z + e.params.browserHistorySeparator + g.route.url
                );
            } else d ? Rt.go(-d) : Rt.back();
        function R() {
            e.setPagePosition(C, "current", !1),
                e.setPagePosition(E, "next", !0),
                w &&
                    (e.setNavbarPosition(s, "current", !1),
                    e.setNavbarPosition(l, "next", !0)),
                e.pageCallback("afterOut", E, l, "current", "next", g),
                e.pageCallback("afterIn", C, s, "previous", "current", g),
                e.params.stackPages && e.initialPages.indexOf(E[0]) >= 0
                    ? (E.addClass("stacked"),
                      E.trigger("page:stack"),
                      e.emit("pageStack", E[0]),
                      w && l.addClass("stacked"))
                    : (e.pageCallback("beforeRemove", E, l, "next", void 0, g),
                      e.removePage(E),
                      w && l.length && e.removeNavbar(l)),
                (e.allowPageChange = !0),
                e.emit("routeChanged", e.currentRoute, e.previousRoute, e),
                (e.params.preloadPreviousPage ||
                    e.params[v.theme + "SwipeBack"]) &&
                    e.history[e.history.length - 2] &&
                    !y &&
                    e.back(e.history[e.history.length - 2], { preload: !0 }),
                e.params.browserHistory && Rt.clearRouterQueue();
        }
        if (
            (I(),
            g.route.route.tab &&
                e.tabLoad(
                    g.route.route.tab,
                    Qe({}, g, { history: !1, browserHistory: !1 })
                ),
            b && (x || o) && m.checkMasterDetailBreakpoint(!1),
            e.pageCallback("init", C, s, "previous", "current", g, E),
            e.pageCallback("beforeOut", E, l, "current", "next", g),
            e.pageCallback("beforeIn", C, s, "previous", "current", g),
            !g.animate || (x && v.width >= e.params.masterDetailBreakpoint))
        )
            R();
        else {
            var A = e.params.transition;
            E[0] &&
                E[0].f7PageTransition &&
                ((A = E[0].f7PageTransition), delete E[0].f7PageTransition),
                g.transition && (A = g.transition),
                !A &&
                    e.previousRoute &&
                    e.previousRoute.route &&
                    (A = e.previousRoute.route.transition),
                !A &&
                    e.previousRoute &&
                    e.previousRoute.route &&
                    e.previousRoute.route.options &&
                    (A = e.previousRoute.route.options.transition),
                e.setPagePosition(E, "current"),
                e.setPagePosition(C, "previous", !1),
                w &&
                    (e.setNavbarPosition(l, "current"),
                    e.setNavbarPosition(s, "previous", !1)),
                e.animate(E, C, l, s, "backward", A, function () {
                    R();
                });
        }
        return e;
    }
    function Yt(e, t, a, r) {
        if (!e.allowPageChange && !r) return e;
        var n = t,
            o = a,
            i = n.url,
            s = n.content,
            l = n.el,
            c = n.pageName,
            p = n.component,
            d = n.componentUrl;
        if (
            o.route.url &&
            e.url === o.route.url &&
            !o.reloadCurrent &&
            !o.reloadPrevious &&
            !e.params.allowDuplicateUrls
        )
            return !1;
        if (
            (!o.route && i && (o.route = e.parseRouteUrl(i)),
            (i || d || p) && (e.allowPageChange = !1),
            s)
        )
            _t(e, e.getPageEl(s), o);
        else if (l) _t(e, e.getPageEl(l), o);
        else if (c)
            _t(e, e.$el.children('.page[data-name="' + c + '"]').eq(0), o);
        else if (p || d)
            try {
                e.pageComponentLoader({
                    routerEl: e.el,
                    component: p,
                    componentUrl: d,
                    options: o,
                    resolve: function (t, a) {
                        return _t(e, t, Qe(o, a));
                    },
                    reject: function () {
                        return (e.allowPageChange = !0), e;
                    },
                });
            } catch (t) {
                throw ((e.allowPageChange = !0), t);
            }
        else
            i &&
                (e.xhrAbortController &&
                    (e.xhrAbortController.abort(), (e.xhrAbortController = !1)),
                e
                    .xhrRequest(i, o)
                    .then(function (t) {
                        _t(e, e.getPageEl(t), o);
                    })
                    .catch(function () {
                        e.allowPageChange = !0;
                    }));
        return e;
    }
    var Wt = (function (e) {
        function t(t, a) {
            var r,
                n = ze((r = e.call(this, {}, [void 0 === a ? t : a]) || this));
            (n.isAppRouter = void 0 === a),
                n.isAppRouter
                    ? Qe(!1, n, {
                          app: t,
                          params: t.params.view,
                          routes: t.routes || [],
                          cache: t.cache,
                      })
                    : Qe(!1, n, {
                          app: t,
                          view: a,
                          viewId: a.id,
                          id: a.params.routerId,
                          params: a.params,
                          routes: a.routes,
                          history: a.history,
                          scrollHistory: a.scrollHistory,
                          cache: t.cache,
                          dynamicNavbar:
                              "ios" === t.theme && a.params.iosDynamicNavbar,
                          initialPages: [],
                          initialNavbars: [],
                      }),
                n.useModules(),
                (n.allowPageChange = !0);
            var o = {},
                i = {};
            return (
                Object.defineProperty(n, "currentRoute", {
                    enumerable: !0,
                    configurable: !0,
                    set: function (e) {
                        void 0 === e && (e = {}),
                            (i = Qe({}, o)),
                            (o = e) &&
                                ((n.url = o.url),
                                n.emit("routeChange", e, i, n));
                    },
                    get: function () {
                        return o;
                    },
                }),
                Object.defineProperty(n, "previousRoute", {
                    enumerable: !0,
                    configurable: !0,
                    get: function () {
                        return i;
                    },
                    set: function (e) {
                        i = e;
                    },
                }),
                n || ze(r)
            );
        }
        Me(t, e);
        var a = t.prototype;
        return (
            (a.mount = function () {
                var e = this,
                    t = e.view;
                Qe(!1, e, {
                    tempDom: r().createElement("div"),
                    $el: t.$el,
                    el: t.el,
                    $navbarsEl: t.$navbarsEl,
                    navbarsEl: t.navbarsEl,
                }),
                    e.emit("local::mount routerMount", e);
            }),
            (a.animatableNavElements = function (e, t, a, r, n) {
                var o,
                    i,
                    s = this,
                    l = s.dynamicNavbar,
                    c = s.params.iosAnimateNavbarBackIcon;
                function p(e, t) {
                    var a,
                        r = e.hasClass("sliding") || t.hasClass("sliding"),
                        n = e.hasClass("subnavbar"),
                        o = !r || !n,
                        i = e.find(".back .icon");
                    return (
                        r &&
                            c &&
                            e.hasClass("left") &&
                            i.length > 0 &&
                            i.next("span").length &&
                            ((e = i.next("span")), (a = !0)),
                        {
                            $el: e,
                            isIconLabel: a,
                            leftOffset: e[0].f7NavbarLeftOffset,
                            rightOffset: e[0].f7NavbarRightOffset,
                            isSliding: r,
                            isSubnavbar: n,
                            needsOpacityTransition: o,
                        }
                    );
                }
                return (
                    l &&
                        ((o = []),
                        (i = []),
                        e
                            .children(".navbar-inner")
                            .children(".left, .right, .title, .subnavbar")
                            .each(function (t) {
                                var i = Ee(t);
                                (i.hasClass("left") && r && "forward" === n) ||
                                    (i.hasClass("title") && a) ||
                                    o.push(p(i, e.children(".navbar-inner")));
                            }),
                        (t.hasClass("navbar-master") &&
                            s.params.masterDetailBreakpoint > 0 &&
                            s.app.width >= s.params.masterDetailBreakpoint) ||
                            t
                                .children(".navbar-inner")
                                .children(".left, .right, .title, .subnavbar")
                                .each(function (e) {
                                    var o = Ee(e);
                                    (o.hasClass("left") &&
                                        a &&
                                        !r &&
                                        "forward" === n) ||
                                        (o.hasClass("left") &&
                                            a &&
                                            "backward" === n) ||
                                        (o.hasClass("title") && r) ||
                                        i.push(
                                            p(o, t.children(".navbar-inner"))
                                        );
                                }),
                        [i, o].forEach(function (e) {
                            e.forEach(function (t) {
                                var a = t,
                                    r = t.isSliding,
                                    n = t.$el,
                                    s = e === i ? o : i;
                                r &&
                                    n.hasClass("title") &&
                                    s &&
                                    s.forEach(function (e) {
                                        if (e.isIconLabel) {
                                            var t = e.$el[0];
                                            a.leftOffset +=
                                                (t && t.offsetLeft) || 0;
                                        }
                                    });
                            });
                        })),
                    { newNavEls: o, oldNavEls: i }
                );
            }),
            (a.animate = function (e, t, a, r, n, o, i) {
                var s = this;
                if (s.params.animateCustom)
                    s.params.animateCustom.apply(s, [e, t, a, r, n, i]);
                else {
                    var l = s.dynamicNavbar,
                        c = "ios" === s.app.theme;
                    if (o) {
                        var p =
                            "router-transition-custom router-transition-" +
                            o +
                            "-" +
                            n;
                        return (
                            ("forward" === n ? t : e).animationEnd(function () {
                                s.$el.removeClass(p),
                                    l &&
                                        s.$navbarsEl.length &&
                                        (r && s.$navbarsEl.prepend(r),
                                        a && s.$navbarsEl.prepend(a)),
                                    i && i();
                            }),
                            l &&
                                (r &&
                                    t &&
                                    (s.setNavbarPosition(r, ""),
                                    r.removeClass(
                                        "navbar-next navbar-previous navbar-current"
                                    ),
                                    t.prepend(r)),
                                a &&
                                    e &&
                                    (s.setNavbarPosition(a, ""),
                                    a.removeClass(
                                        "navbar-next navbar-previous navbar-current"
                                    ),
                                    e.prepend(a))),
                            void s.$el.addClass(p)
                        );
                    }
                    var d,
                        u,
                        h,
                        f,
                        v,
                        m,
                        g,
                        b = "router-transition-" + n + " router-transition";
                    if (c && l) {
                        (s.params.masterDetailBreakpoint > 0 &&
                            s.app.width >= s.params.masterDetailBreakpoint &&
                            ((a.hasClass("navbar-master") &&
                                r.hasClass("navbar-master-detail")) ||
                                (a.hasClass("navbar-master-detail") &&
                                    r.hasClass("navbar-master")))) ||
                            ((m = a && a.hasClass("navbar-large")),
                            (g = r && r.hasClass("navbar-large")),
                            (h = m && !a.hasClass("navbar-large-collapsed")),
                            (f = g && !r.hasClass("navbar-large-collapsed")),
                            (v = (h && !f) || (f && !h)));
                        var y = s.animatableNavElements(r, a, f, h, n);
                        (d = y.newNavEls), (u = y.oldNavEls);
                    }
                    ("forward" === n ? t : e).animationEnd(function () {
                        s.dynamicNavbar &&
                            (r &&
                                (r.removeClass(
                                    "router-navbar-transition-to-large router-navbar-transition-from-large"
                                ),
                                r.addClass("navbar-no-title-large-transition"),
                                _e(function () {
                                    r.removeClass(
                                        "navbar-no-title-large-transition"
                                    );
                                })),
                            a &&
                                a.removeClass(
                                    "router-navbar-transition-to-large router-navbar-transition-from-large"
                                ),
                            r.hasClass("sliding") ||
                            r.children(".navbar-inner.sliding").length
                                ? r
                                      .find(
                                          ".title, .left, .right, .left .icon, .subnavbar"
                                      )
                                      .transform("")
                                : r.find(".sliding").transform(""),
                            a.hasClass("sliding") ||
                            a.children(".navbar-inner.sliding").length
                                ? a
                                      .find(
                                          ".title, .left, .right, .left .icon, .subnavbar"
                                      )
                                      .transform("")
                                : a.find(".sliding").transform("")),
                            s.$el.removeClass(b),
                            i && i();
                    }),
                        l
                            ? (w(0),
                              _e(function () {
                                  s.$el.addClass(b),
                                      v && (s.el._clientLeft = s.el.clientLeft),
                                      w(1);
                              }))
                            : s.$el.addClass(b);
                }
                function w(e) {
                    c &&
                        l &&
                        (1 === e &&
                            (f &&
                                (r.addClass(
                                    "router-navbar-transition-to-large"
                                ),
                                a.addClass(
                                    "router-navbar-transition-to-large"
                                )),
                            h &&
                                (r.addClass(
                                    "router-navbar-transition-from-large"
                                ),
                                a.addClass(
                                    "router-navbar-transition-from-large"
                                ))),
                        d.forEach(function (t) {
                            var a = t.$el,
                                r =
                                    "forward" === n
                                        ? t.rightOffset
                                        : t.leftOffset;
                            t.isSliding &&
                                (t.isSubnavbar && g
                                    ? a[0].style.setProperty(
                                          "transform",
                                          "translate3d(" +
                                              r * (1 - e) +
                                              "px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)",
                                          "important"
                                      )
                                    : a.transform(
                                          "translate3d(" +
                                              r * (1 - e) +
                                              "px,0,0)"
                                      ));
                        }),
                        u.forEach(function (t) {
                            var a = t.$el,
                                r =
                                    "forward" === n
                                        ? t.leftOffset
                                        : t.rightOffset;
                            t.isSliding &&
                                (t.isSubnavbar && m
                                    ? a.transform(
                                          "translate3d(" +
                                              r * e +
                                              "px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)"
                                      )
                                    : a.transform(
                                          "translate3d(" + r * e + "px,0,0)"
                                      ));
                        }));
                }
            }),
            (a.removeModal = function (e) {
                this.removeEl(e);
            }),
            (a.removeTabContent = function (e) {
                Ee(e).html("");
            }),
            (a.removeNavbar = function (e) {
                this.removeEl(e);
            }),
            (a.removePage = function (e) {
                var t = Ee(e),
                    a = t && t[0] && t[0].f7Page;
                a && a.route && a.route.route && a.route.route.keepAlive
                    ? t.remove()
                    : this.removeEl(e);
            }),
            (a.removeEl = function (e) {
                if (e) {
                    var t = this,
                        a = Ee(e);
                    0 !== a.length &&
                        (a.find(".tab").each(function (e) {
                            Ee(e)
                                .children()
                                .each(function (e) {
                                    e.f7Component &&
                                        (Ee(e).trigger("tab:beforeremove"),
                                        e.f7Component.destroy());
                                });
                        }),
                        a[0].f7Component &&
                            a[0].f7Component.destroy &&
                            a[0].f7Component.destroy(),
                        t.params.removeElements &&
                            (t.params.removeElementsWithTimeout
                                ? setTimeout(function () {
                                      a.remove();
                                  }, t.params.removeElementsTimeout)
                                : a.remove()));
                }
            }),
            (a.getPageEl = function (e) {
                var t = this;
                if ("string" == typeof e) t.tempDom.innerHTML = e;
                else {
                    if (Ee(e).hasClass("page")) return e;
                    (t.tempDom.innerHTML = ""), Ee(t.tempDom).append(e);
                }
                return t.findElement(".page", t.tempDom);
            }),
            (a.findElement = function (e, t, a) {
                var r = this,
                    n = r.view,
                    o = r.app,
                    i = Ee(t),
                    s = e;
                a && (s += ":not(.stacked)");
                var l = i.find(s).filter(function (e) {
                    return (
                        0 ===
                        Ee(e).parents(
                            ".popup, .dialog, .popover, .actions-modal, .sheet-modal, .login-screen, .page"
                        ).length
                    );
                });
                return (
                    l.length > 1 &&
                        ("string" == typeof n.selector &&
                            (l = i.find(n.selector + " " + s)),
                        l.length > 1 &&
                            (l = i.find(
                                "." + o.params.viewMainClass + " " + s
                            ))),
                    1 === l.length
                        ? l
                        : (a || (l = r.findElement(s, i, !0)),
                          l && 1 === l.length
                              ? l
                              : l && l.length > 1
                              ? Ee(l[0])
                              : void 0)
                );
            }),
            (a.flattenRoutes = function (e) {
                void 0 === e && (e = this.routes);
                var t = this,
                    a = [];
                return (
                    e.forEach(function (e) {
                        var r = !1;
                        if ("tabs" in e && e.tabs) {
                            var n = e.tabs.map(function (t) {
                                var a = Qe({}, e, {
                                    path: (e.path + "/" + t.path)
                                        .replace("///", "/")
                                        .replace("//", "/"),
                                    parentPath: e.path,
                                    tab: t,
                                });
                                return delete a.tabs, delete a.routes, a;
                            });
                            (r = !0), (a = a.concat(t.flattenRoutes(n)));
                        }
                        if ("detailRoutes" in e) {
                            var o = e.detailRoutes.map(function (t) {
                                var a = Qe({}, t);
                                return (
                                    (a.masterRoute = e),
                                    (a.masterRoutePath = e.path),
                                    a
                                );
                            });
                            a = a.concat(e, t.flattenRoutes(o));
                        }
                        if ("routes" in e) {
                            var i = e.routes.map(function (t) {
                                var a = Qe({}, t);
                                return (
                                    (a.path = (e.path + "/" + a.path)
                                        .replace("///", "/")
                                        .replace("//", "/")),
                                    a
                                );
                            });
                            a = r
                                ? a.concat(t.flattenRoutes(i))
                                : a.concat(e, t.flattenRoutes(i));
                        }
                        "routes" in e ||
                            ("tabs" in e && e.tabs) ||
                            "detailRoutes" in e ||
                            a.push(e);
                    }),
                    a
                );
            }),
            (a.parseRouteUrl = function (e) {
                if (!e) return {};
                var t = We(e),
                    a = e.split("#")[1],
                    r = e.split("#")[0].split("?")[0];
                return { query: t, hash: a, params: {}, url: e, path: r };
            }),
            (a.generateUrl = function (e) {
                if ((void 0 === e && (e = {}), "string" == typeof e)) return e;
                var t = e,
                    a = t.name,
                    r = t.path,
                    n = t.params,
                    o = t.query;
                if (!a && !r)
                    throw new Error(
                        'Framework7: "name" or "path" parameter is required'
                    );
                var i = this,
                    s = a
                        ? i.findRouteByKey("name", a)
                        : i.findRouteByKey("path", r);
                if (!s)
                    throw a
                        ? new Error(
                              'Framework7: route with name "' +
                                  a +
                                  '" not found'
                          )
                        : new Error(
                              'Framework7: route with path "' +
                                  r +
                                  '" not found'
                          );
                var l = i.constructRouteUrl(s, { params: n, query: o });
                if (!l)
                    throw new Error(
                        "Framework7: can't construct URL for route with name \"" +
                            a +
                            '"'
                    );
                return l;
            }),
            (a.constructRouteUrl = function (e, t) {
                var a,
                    r = void 0 === t ? {} : t,
                    n = r.params,
                    o = r.query,
                    i = e.path,
                    s = Ot(i);
                try {
                    a = s(n || {});
                } catch (e) {
                    throw new Error(
                        "Framework7: error constructing route URL from passed params:\nRoute: " +
                            i +
                            "\n" +
                            e.toString()
                    );
                }
                return (
                    o &&
                        ("string" == typeof o
                            ? (a += "?" + o)
                            : Object.keys(o).length && (a += "?" + Ge(o))),
                    a
                );
            }),
            (a.findTabRouteUrl = function (e) {
                var t,
                    a = this,
                    r = Ee(e),
                    n = a.currentRoute.route.parentPath,
                    o = r.attr("id");
                return (
                    a.flattenRoutes(a.routes).forEach(function (e) {
                        e.parentPath === n &&
                            e.tab &&
                            e.tab.id === o &&
                            (t =
                                a.currentRoute.params &&
                                Object.keys(a.currentRoute.params).length > 0
                                    ? a.constructRouteUrl(e, {
                                          params: a.currentRoute.params,
                                          query: a.currentRoute.query,
                                      })
                                    : e.path);
                    }),
                    t
                );
            }),
            (a.findRouteByKey = function (e, t) {
                var a,
                    r = this.routes;
                return (
                    this.flattenRoutes(r).forEach(function (r) {
                        a || (r[e] === t && (a = r));
                    }),
                    a
                );
            }),
            (a.findMatchingRoute = function (e) {
                if (e) {
                    var t,
                        a = this,
                        r = a.routes,
                        n = a.flattenRoutes(r),
                        o = a.parseRouteUrl(e),
                        i = o.path,
                        s = o.query,
                        l = o.hash,
                        c = o.params;
                    return (
                        n.forEach(function (a) {
                            if (!t) {
                                var r,
                                    n,
                                    o = [],
                                    p = [a.path];
                                if (
                                    (a.alias &&
                                        ("string" == typeof a.alias
                                            ? p.push(a.alias)
                                            : Array.isArray(a.alias) &&
                                              a.alias.forEach(function (e) {
                                                  p.push(e);
                                              })),
                                    p.forEach(function (e) {
                                        r || (r = zt(e, o).exec(i));
                                    }),
                                    r)
                                )
                                    o.forEach(function (e, t) {
                                        if ("number" != typeof e.name) {
                                            var a = r[t + 1];
                                            c[e.name] =
                                                null == a
                                                    ? a
                                                    : decodeURIComponent(a);
                                        }
                                    }),
                                        a.parentPath &&
                                            (n = i
                                                .split("/")
                                                .slice(
                                                    0,
                                                    a.parentPath.split("/")
                                                        .length - 1
                                                )
                                                .join("/")),
                                        (t = {
                                            query: s,
                                            hash: l,
                                            params: c,
                                            url: e,
                                            path: i,
                                            parentPath: n,
                                            route: a,
                                            name: a.name,
                                        });
                            }
                        }),
                        t
                    );
                }
            }),
            (a.replaceRequestUrlParams = function (e, t) {
                void 0 === e && (e = ""), void 0 === t && (t = {});
                var a = e;
                return (
                    "string" == typeof a &&
                        a.indexOf("{{") >= 0 &&
                        t &&
                        t.route &&
                        t.route.params &&
                        Object.keys(t.route.params).length &&
                        Object.keys(t.route.params).forEach(function (e) {
                            var r = new RegExp("{{" + e + "}}", "g");
                            a = a.replace(r, t.route.params[e] || "");
                        }),
                    a
                );
            }),
            (a.removeFromXhrCache = function (e) {
                for (
                    var t = this.cache.xhr, a = !1, r = 0;
                    r < t.length;
                    r += 1
                )
                    t[r].url === e && (a = r);
                !1 !== a && t.splice(a, 1);
            }),
            (a.xhrRequest = function (e, t) {
                var a = this,
                    r = a.params,
                    n = t.ignoreCache,
                    o = e,
                    i = o.indexOf("?") >= 0;
                return (
                    r.passRouteQueryToRequest &&
                        t &&
                        t.route &&
                        t.route.query &&
                        Object.keys(t.route.query).length &&
                        ((o += (i ? "&" : "?") + Ge(t.route.query)), (i = !0)),
                    r.passRouteParamsToRequest &&
                        t &&
                        t.route &&
                        t.route.params &&
                        Object.keys(t.route.params).length &&
                        ((o += (i ? "&" : "?") + Ge(t.route.params)), (i = !0)),
                    o.indexOf("{{") >= 0 &&
                        (o = a.replaceRequestUrlParams(o, t)),
                    r.xhrCacheIgnoreGetParameters &&
                        o.indexOf("?") >= 0 &&
                        (o = o.split("?")[0]),
                    new Promise(function (e, i) {
                        if (
                            r.xhrCache &&
                            !n &&
                            o.indexOf("nocache") < 0 &&
                            r.xhrCacheIgnore.indexOf(o) < 0
                        )
                            for (var s = 0; s < a.cache.xhr.length; s += 1) {
                                var l = a.cache.xhr[s];
                                if (
                                    l.url === o &&
                                    Ye() - l.time < r.xhrCacheDuration
                                )
                                    return void e(l.content);
                            }
                        (a.xhrAbortController =
                            a.app.request.abortController()),
                            a.app.request({
                                abortController: a.xhrAbortController,
                                url: o,
                                method: "GET",
                                beforeSend: function (e) {
                                    a.emit("routerAjaxStart", e, t);
                                },
                                complete: function (n, s) {
                                    a.emit("routerAjaxComplete", n),
                                        ("error" !== s &&
                                            "timeout" !== s &&
                                            n.status >= 200 &&
                                            n.status < 300) ||
                                        0 === n.status
                                            ? (r.xhrCache &&
                                                  "" !== n.responseText &&
                                                  (a.removeFromXhrCache(o),
                                                  a.cache.xhr.push({
                                                      url: o,
                                                      time: Ye(),
                                                      content: n.responseText,
                                                  })),
                                              a.emit("routerAjaxSuccess", n, t),
                                              e(n.responseText))
                                            : (a.emit("routerAjaxError", n, t),
                                              i(n));
                                },
                                error: function (e) {
                                    a.emit("routerAjaxError", e, t), i(e);
                                },
                            });
                    })
                );
            }),
            (a.setNavbarPosition = function (e, t, a) {
                e.removeClass("navbar-previous navbar-current navbar-next"),
                    t && e.addClass("navbar-" + t),
                    !1 === a
                        ? e.removeAttr("aria-hidden")
                        : !0 === a && e.attr("aria-hidden", "true"),
                    e.trigger("navbar:position", { position: t }),
                    this.emit("navbarPosition", e[0], t);
            }),
            (a.setPagePosition = function (e, t, a) {
                e.removeClass("page-previous page-current page-next"),
                    e.addClass("page-" + t),
                    !1 === a
                        ? e.removeAttr("aria-hidden")
                        : !0 === a && e.attr("aria-hidden", "true"),
                    e.trigger("page:position", { position: t }),
                    this.emit("pagePosition", e[0], t);
            }),
            (a.removeThemeElements = function (e) {
                var t,
                    a = this.app.theme;
                "ios" === a
                    ? (t =
                          ".md-only, .aurora-only, .if-md, .if-aurora, .if-not-ios, .not-ios")
                    : "md" === a
                    ? (t =
                          ".ios-only, .aurora-only, .if-ios, .if-aurora, .if-not-md, .not-md")
                    : "aurora" === a &&
                      (t =
                          ".ios-only, .md-only, .if-ios, .if-md, .if-not-aurora, .not-aurora"),
                    Ee(e).find(t).remove();
            }),
            (a.getPageData = function (e, t, a, r, n, o) {
                void 0 === n && (n = {});
                var i,
                    s,
                    l = this,
                    c = Ee(e).eq(0),
                    p = Ee(t).eq(0),
                    d = c[0].f7Page || {};
                if (
                    ((("next" === a && "current" === r) ||
                        ("current" === a && "previous" === r)) &&
                        (i = "forward"),
                    (("current" === a && "next" === r) ||
                        ("previous" === a && "current" === r)) &&
                        (i = "backward"),
                    d && !d.fromPage)
                ) {
                    var u = Ee(o);
                    u.length && (s = u[0].f7Page);
                }
                (s = d.pageFrom || s) && s.pageFrom && (s.pageFrom = null);
                var h = {
                    app: l.app,
                    view: l.view,
                    router: l,
                    $el: c,
                    el: c[0],
                    $pageEl: c,
                    pageEl: c[0],
                    $navbarEl: p,
                    navbarEl: p[0],
                    name: c.attr("data-name"),
                    position: a,
                    from: a,
                    to: r,
                    direction: i,
                    route: d.route ? d.route : n,
                    pageFrom: s,
                };
                return (c[0].f7Page = h), h;
            }),
            (a.pageCallback = function (e, t, a, r, n, o, i) {
                if ((void 0 === o && (o = {}), t)) {
                    var s = this,
                        l = Ee(t);
                    if (l.length) {
                        var c = Ee(a),
                            p = o.route,
                            d =
                                s.params.restoreScrollTopOnBack &&
                                !(
                                    s.params.masterDetailBreakpoint > 0 &&
                                    l.hasClass("page-master") &&
                                    s.app.width >=
                                        s.params.masterDetailBreakpoint
                                ),
                            u =
                                l[0].f7Page &&
                                l[0].f7Page.route &&
                                l[0].f7Page.route.route &&
                                l[0].f7Page.route.route.keepAlive;
                        "beforeRemove" === e && u && (e = "beforeUnmount");
                        var h =
                                "page" +
                                (e[0].toUpperCase() + e.slice(1, e.length)),
                            f = "page:" + e.toLowerCase(),
                            v = {};
                        (v =
                            "beforeRemove" === e && l[0].f7Page
                                ? Qe(l[0].f7Page, {
                                      from: r,
                                      to: n,
                                      position: r,
                                  })
                                : s.getPageData(
                                      l[0],
                                      c[0],
                                      r,
                                      n,
                                      p,
                                      i
                                  )).swipeBack = !!o.swipeBack;
                        var m = o.route ? o.route.route : {},
                            g = m.on,
                            b = void 0 === g ? {} : g,
                            y = m.once,
                            w = void 0 === y ? {} : y;
                        if (
                            (o.on && Qe(b, o.on),
                            o.once && Qe(w, o.once),
                            "mounted" === e && k(),
                            "init" === e)
                        ) {
                            if (
                                d &&
                                ("previous" === r || !r) &&
                                "current" === n &&
                                s.scrollHistory[v.route.url] &&
                                !l.hasClass("no-restore-scroll")
                            ) {
                                var C = l.find(".page-content");
                                C.length > 0 &&
                                    (C = C.filter(function (e) {
                                        return (
                                            0 ===
                                                Ee(e).parents(
                                                    ".tab:not(.tab-active)"
                                                ).length &&
                                            !Ee(e).is(".tab:not(.tab-active)")
                                        );
                                    })),
                                    C.scrollTop(s.scrollHistory[v.route.url]);
                            }
                            if ((k(), l[0].f7PageInitialized))
                                return (
                                    l.trigger("page:reinit", v),
                                    void s.emit("pageReinit", v)
                                );
                            l[0].f7PageInitialized = !0;
                        }
                        if (
                            d &&
                            "beforeOut" === e &&
                            "current" === r &&
                            "previous" === n
                        ) {
                            var E = l.find(".page-content");
                            E.length > 0 &&
                                (E = E.filter(function (e) {
                                    return (
                                        0 ===
                                            Ee(e).parents(
                                                ".tab:not(.tab-active)"
                                            ).length &&
                                        !Ee(e).is(".tab:not(.tab-active)")
                                    );
                                })),
                                (s.scrollHistory[v.route.url] = E.scrollTop());
                        }
                        d &&
                            "beforeOut" === e &&
                            "current" === r &&
                            "next" === n &&
                            delete s.scrollHistory[v.route.url],
                            l.trigger(f, v),
                            s.emit(h, v),
                            ("beforeRemove" !== e && "beforeUnmount" !== e) ||
                                (l[0].f7RouteEventsAttached &&
                                    (l[0].f7RouteEventsOn &&
                                        Object.keys(
                                            l[0].f7RouteEventsOn
                                        ).forEach(function (e) {
                                            l.off(
                                                Ve(e),
                                                l[0].f7RouteEventsOn[e]
                                            );
                                        }),
                                    l[0].f7RouteEventsOnce &&
                                        Object.keys(
                                            l[0].f7RouteEventsOnce
                                        ).forEach(function (e) {
                                            l.off(
                                                Ve(e),
                                                l[0].f7RouteEventsOnce[e]
                                            );
                                        }),
                                    (l[0].f7RouteEventsAttached = null),
                                    (l[0].f7RouteEventsOn = null),
                                    (l[0].f7RouteEventsOnce = null),
                                    delete l[0].f7RouteEventsAttached,
                                    delete l[0].f7RouteEventsOn,
                                    delete l[0].f7RouteEventsOnce),
                                u ||
                                    (l[0].f7Page &&
                                        l[0].f7Page.navbarEl &&
                                        delete l[0].f7Page.navbarEl.f7Page,
                                    (l[0].f7Page = null)));
                    }
                }
                function k() {
                    l[0].f7RouteEventsAttached ||
                        ((l[0].f7RouteEventsAttached = !0),
                        b &&
                            Object.keys(b).length > 0 &&
                            ((l[0].f7RouteEventsOn = b),
                            Object.keys(b).forEach(function (e) {
                                (b[e] = b[e].bind(s)), l.on(Ve(e), b[e]);
                            })),
                        w &&
                            Object.keys(w).length > 0 &&
                            ((l[0].f7RouteEventsOnce = w),
                            Object.keys(w).forEach(function (e) {
                                (w[e] = w[e].bind(s)), l.once(Ve(e), w[e]);
                            })));
                }
            }),
            (a.saveHistory = function () {
                var e = this,
                    t = o();
                (e.view.history = e.history),
                    e.params.browserHistory &&
                        e.params.browserHistoryStoreHistory &&
                        t.localStorage &&
                        (t.localStorage["f7router-" + e.view.id + "-history"] =
                            JSON.stringify(e.history));
            }),
            (a.restoreHistory = function () {
                var e = this,
                    t = o();
                e.params.browserHistory &&
                    e.params.browserHistoryStoreHistory &&
                    t.localStorage &&
                    t.localStorage["f7router-" + e.view.id + "-history"] &&
                    ((e.history = JSON.parse(
                        t.localStorage["f7router-" + e.view.id + "-history"]
                    )),
                    (e.view.history = e.history));
            }),
            (a.clearHistory = function () {
                var e = this;
                (e.history = []),
                    e.view && (e.view.history = []),
                    e.saveHistory();
            }),
            (a.updateCurrentUrl = function (e) {
                var t = this;
                Vt(t, "updateCurrentUrl"),
                    t.history.length
                        ? (t.history[t.history.length - 1] = e)
                        : t.history.push(e);
                var a = t.parseRouteUrl(e),
                    r = a.query,
                    n = a.hash,
                    o = a.params,
                    i = a.url,
                    s = a.path;
                if (
                    (t.currentRoute &&
                        Qe(t.currentRoute, {
                            query: r,
                            hash: n,
                            params: o,
                            url: i,
                            path: s,
                        }),
                    t.params.browserHistory)
                ) {
                    var l = t.params.browserHistoryRoot || "";
                    Rt.replace(
                        t.view.id,
                        { url: e },
                        l + t.params.browserHistorySeparator + e
                    );
                }
                t.saveHistory(), t.emit("routeUrlUpdate", t.currentRoute, t);
            }),
            (a.getInitialUrl = function () {
                var e = this;
                if (e.initialUrl)
                    return {
                        initialUrl: e.initialUrl,
                        historyRestored: e.historyRestored,
                    };
                var t,
                    a = e.app,
                    n = e.view,
                    i = r(),
                    s = o(),
                    l =
                        a.params.url &&
                        "string" == typeof a.params.url &&
                        "undefined" != typeof URL
                            ? new URL(a.params.url)
                            : i.location,
                    c = e.params.url,
                    p = l.href.split(l.origin)[1],
                    d = e.params,
                    u = d.browserHistory,
                    h = d.browserHistoryOnLoad,
                    f = d.browserHistorySeparator,
                    v = e.params.browserHistoryRoot;
                return (
                    (s.cordova || (s.Capacitor && s.Capacitor.isNative)) &&
                        u &&
                        !f &&
                        !v &&
                        l.pathname.indexOf("index.html") &&
                        (console.warn(
                            "Framework7: wrong or not complete browserHistory configuration, trying to guess browserHistoryRoot"
                        ),
                        (v = l.pathname.split("index.html")[0])),
                    u && h
                        ? (v &&
                              p.indexOf(v) >= 0 &&
                              "" === (p = p.split(v)[1]) &&
                              (p = "/"),
                          (c =
                              f.length > 0 && p.indexOf(f) >= 0
                                  ? p.split(f)[1]
                                  : p),
                          e.restoreHistory(),
                          e.history.indexOf(c) >= 0
                              ? (e.history = e.history.slice(
                                    0,
                                    e.history.indexOf(c) + 1
                                ))
                              : e.params.url === c
                              ? (e.history = [c])
                              : Rt.state &&
                                Rt.state[n.id] &&
                                Rt.state[n.id].url ===
                                    e.history[e.history.length - 1]
                              ? (c = e.history[e.history.length - 1])
                              : (e.history = [p.split(f)[0] || "/", c]),
                          e.history.length > 1 ? (t = !0) : (e.history = []),
                          e.saveHistory())
                        : (c || (c = p),
                          l.search && c.indexOf("?") < 0 && (c += l.search),
                          l.hash && c.indexOf("#") < 0 && (c += l.hash)),
                    (e.initialUrl = c),
                    (e.historyRestored = t),
                    { initialUrl: c, historyRestored: t }
                );
            }),
            (a.init = function () {
                var e = this,
                    t = e.app,
                    a = e.view,
                    n = r();
                e.mount();
                var o = e.getInitialUrl(),
                    i = o.initialUrl,
                    s = o.historyRestored;
                ((a && e.params.iosSwipeBack && "ios" === t.theme) ||
                    (a && e.params.mdSwipeBack && "md" === t.theme) ||
                    (a && e.params.auroraSwipeBack && "aurora" === t.theme)) &&
                    At(e);
                var l,
                    c = e.params,
                    p = c.browserHistory,
                    d = c.browserHistoryOnLoad,
                    u = c.browserHistoryAnimateOnLoad,
                    h = c.browserHistoryInitialMatch;
                if (e.history.length > 1) {
                    var f = h ? i : e.history[0];
                    (l = e.findMatchingRoute(f)) ||
                        (l = Qe(e.parseRouteUrl(f), {
                            route: { url: f, path: f.split("?")[0] },
                        }));
                } else
                    (l = e.findMatchingRoute(i)) ||
                        (l = Qe(e.parseRouteUrl(i), {
                            route: { url: i, path: i.split("?")[0] },
                        }));
                if (
                    (e.params.stackPages &&
                        e.$el.children(".page").each(function (t) {
                            var a = Ee(t);
                            e.initialPages.push(a[0]),
                                e.dynamicNavbar &&
                                    a.children(".navbar").length > 0 &&
                                    e.initialNavbars.push(
                                        a.children(".navbar")[0]
                                    );
                        }),
                    0 === e.$el.children(".page:not(.stacked)").length &&
                        i &&
                        e.params.loadInitialPage)
                )
                    e.navigate(i, {
                        initial: !0,
                        reloadCurrent: !0,
                        browserHistory: !1,
                        animate: !1,
                        once: {
                            modalOpen: function () {
                                s &&
                                    (e.params.preloadPreviousPage ||
                                        e.params[t.theme + "SwipeBack"]) &&
                                    e.history.length > 1 &&
                                    e.back({ preload: !0 });
                            },
                            pageAfterIn: function () {
                                s &&
                                    (e.params.preloadPreviousPage ||
                                        e.params[t.theme + "SwipeBack"]) &&
                                    e.history.length > 1 &&
                                    e.back({ preload: !0 });
                            },
                        },
                    });
                else if (e.$el.children(".page:not(.stacked)").length) {
                    var v;
                    if (
                        ((e.currentRoute = l),
                        e.$el
                            .children(".page:not(.stacked)")
                            .each(function (r) {
                                var o,
                                    i = Ee(r);
                                e.setPagePosition(i, "current"),
                                    e.dynamicNavbar &&
                                        ((o = i.children(".navbar")).length > 0
                                            ? (e.$navbarsEl.parents(n).length ||
                                                  e.$el.prepend(e.$navbarsEl),
                                              e.setNavbarPosition(o, "current"),
                                              e.$navbarsEl.append(o),
                                              o.children(".title-large")
                                                  .length &&
                                                  o.addClass("navbar-large"),
                                              i.children(".navbar").remove())
                                            : (e.$navbarsEl.addClass(
                                                  "navbar-hidden"
                                              ),
                                              o.children(".title-large")
                                                  .length &&
                                                  e.$navbarsEl.addClass(
                                                      "navbar-hidden navbar-large-hidden"
                                                  ))),
                                    e.currentRoute &&
                                        e.currentRoute.route &&
                                        (!0 === e.currentRoute.route.master ||
                                            ("function" ==
                                                typeof e.currentRoute.route
                                                    .master &&
                                                e.currentRoute.route.master(
                                                    t,
                                                    e
                                                ))) &&
                                        e.params.masterDetailBreakpoint > 0 &&
                                        (i.addClass("page-master"),
                                        i.trigger("page:role", {
                                            role: "master",
                                        }),
                                        o &&
                                            o.length &&
                                            o.addClass("navbar-master"),
                                        a.checkMasterDetailBreakpoint());
                                var s = { route: e.currentRoute };
                                e.currentRoute &&
                                    e.currentRoute.route &&
                                    e.currentRoute.route.options &&
                                    Qe(s, e.currentRoute.route.options),
                                    (e.currentPageEl = i[0]),
                                    e.dynamicNavbar &&
                                        o.length &&
                                        (e.currentNavbarEl = o[0]),
                                    e.removeThemeElements(i),
                                    e.dynamicNavbar &&
                                        o.length &&
                                        e.removeThemeElements(o),
                                    s.route.route.tab &&
                                        ((v = !0),
                                        e.tabLoad(
                                            s.route.route.tab,
                                            Qe({}, s)
                                        )),
                                    e.pageCallback(
                                        "init",
                                        i,
                                        o,
                                        "current",
                                        void 0,
                                        s
                                    ),
                                    e.pageCallback(
                                        "beforeIn",
                                        i,
                                        o,
                                        "current",
                                        void 0,
                                        s
                                    ),
                                    e.pageCallback(
                                        "afterIn",
                                        i,
                                        o,
                                        "current",
                                        void 0,
                                        s
                                    );
                            }),
                        s)
                    )
                        if (h)
                            (e.params.preloadPreviousPage ||
                                e.params[t.theme + "SwipeBack"]) &&
                                e.history.length > 1 &&
                                e.back({ preload: !0 });
                        else
                            e.navigate(i, {
                                initial: !0,
                                browserHistory: !1,
                                history: !1,
                                animate: u,
                                once: {
                                    pageAfterIn: function () {
                                        (e.params.preloadPreviousPage ||
                                            e.params[t.theme + "SwipeBack"]) &&
                                            e.history.length > 2 &&
                                            e.back({ preload: !0 });
                                    },
                                },
                            });
                    s || v || (e.history.push(i), e.saveHistory());
                }
                !(i && p && d) ||
                    (Rt.state && Rt.state[a.id]) ||
                    Rt.initViewState(a.id, { url: i }),
                    e.emit("local::init routerInit", e);
            }),
            (a.destroy = function () {
                var e = this;
                e.emit("local::destroy routerDestroy", e),
                    Object.keys(e).forEach(function (t) {
                        (e[t] = null), delete e[t];
                    }),
                    (e = null);
            }),
            t
        );
    })(ut);
    (Wt.prototype.navigate = function (e, t) {
        void 0 === t && (t = {});
        var a,
            r,
            n,
            o,
            i,
            s,
            l,
            c = this;
        if (c.swipeBackActive) return c;
        if (
            ("string" == typeof e
                ? (a = e)
                : ((a = e.url),
                  (r = e.route),
                  (n = e.name),
                  (o = e.path),
                  (i = e.query),
                  (s = e.params)),
            n || o)
        )
            return (a = c.generateUrl({
                path: o,
                name: n,
                params: s,
                query: i,
            }))
                ? c.navigate(a, t)
                : c;
        var p = c.app;
        if ((Vt(c, "navigate"), "#" === a || "" === a)) return c;
        var d = a.replace("./", "");
        if ("/" !== d[0] && 0 !== d.indexOf("#")) {
            var u = c.currentRoute.parentPath || c.currentRoute.path;
            d = ((u ? u + "/" : "/") + d)
                .replace("///", "/")
                .replace("//", "/");
        }
        if (
            !(l = r
                ? Qe(c.parseRouteUrl(d), { route: Qe({}, r) })
                : c.findMatchingRoute(d))
        )
            return c;
        if (l.route && l.route.viewName) {
            var h = l.route.viewName,
                f = p.views[h];
            if (!f)
                throw new Error(
                    'Framework7: There is no View with "' +
                        h +
                        '" name that was specified in this route'
                );
            if (f !== c.view) return f.router.navigate(e, t);
        }
        if (l.route.redirect) return Dt.call(c, "forward", l, t);
        var v = {};
        if (
            (l.route.options ? Qe(v, l.route.options, t) : Qe(v, t),
            v.openIn &&
                (!c.params.ignoreOpenIn ||
                    (c.params.ignoreOpenIn && c.history.length > 0)))
        )
            return (function (e, t, a) {
                var r = {
                        url: t,
                        route: {
                            path: t,
                            options: Se({}, a, { openIn: void 0 }),
                        },
                    },
                    n = Se({}, a);
                if (
                    ("popup" === a.openIn &&
                        ((n.content =
                            '<div class="popup popup-router-open-in" data-url="' +
                            t +
                            '"><div class="view view-init" data-links-view="' +
                            e.view.selector +
                            '" data-url="' +
                            t +
                            '" data-ignore-open-in="true"></div></div>'),
                        (r.route.popup = n)),
                    "loginScreen" === a.openIn &&
                        ((n.content =
                            '<div class="login-screen login-screen-router-open-in" data-url="' +
                            t +
                            '"><div class="view view-init" data-links-view="' +
                            e.view.selector +
                            '" data-url="' +
                            t +
                            '" data-ignore-open-in="true"></div></div>'),
                        (r.route.loginScreen = n)),
                    "sheet" === a.openIn &&
                        ((n.content =
                            '<div class="sheet-modal sheet-modal-router-open-in" data-url="' +
                            t +
                            '"><div class="sheet-modal-inner"><div class="view view-init" data-links-view="' +
                            e.view.selector +
                            '" data-url="' +
                            t +
                            '" data-ignore-open-in="true"></div></div></div>'),
                        (r.route.sheet = n)),
                    "popover" === a.openIn &&
                        ((n.targetEl = a.clickedEl || a.targetEl),
                        (n.content =
                            '<div class="popover popover-router-open-in" data-url="' +
                            t +
                            '"><div class="popover-inner"><div class="view view-init" data-links-view="' +
                            e.view.selector +
                            '" data-url="' +
                            t +
                            '" data-ignore-open-in="true"></div></div></div>'),
                        (r.route.popover = n)),
                    a.openIn.indexOf("panel") >= 0)
                ) {
                    var o = a.openIn.split(":"),
                        i = o[1] || "left",
                        s = o[2] || "cover";
                    (n.targetEl = a.clickedEl || a.targetEl),
                        (n.content =
                            '<div class="panel panel-router-open-in panel-' +
                            i +
                            " panel-" +
                            s +
                            '" data-url="' +
                            t +
                            '"><div class="view view-init" data-links-view="' +
                            e.view.selector +
                            '" data-url="' +
                            t +
                            '" data-ignore-open-in="true"></div></div>'),
                        (r.route.panel = n);
                }
                return e.navigate(r);
            })(c, d, v);
        function m() {
            var e = !1;
            function t(e, t) {
                c.allowPageChange = !1;
                var a = !1;
                "popup popover sheet loginScreen actions customModal panel"
                    .split(" ")
                    .forEach(function (r) {
                        if (e[r]) {
                            a = !0;
                            var n = Qe({}, l, { route: e });
                            (c.allowPageChange = !0),
                                c.modalLoad(r, n, Qe(v, t), "forward");
                        }
                    }),
                    a || jt(c, e, Qe(v, t), !0);
            }
            function a() {
                c.allowPageChange = !0;
            }
            "popup popover sheet loginScreen actions customModal panel"
                .split(" ")
                .forEach(function (t) {
                    l.route[t] &&
                        !e &&
                        ((e = !0), c.modalLoad(t, l, v, "forward"));
                }),
                l.route.keepAlive &&
                    l.route.keepAliveData &&
                    (jt(c, { el: l.route.keepAliveData.pageEl }, v, !1),
                    (e = !0)),
                "url content component pageName el componentUrl"
                    .split(" ")
                    .forEach(function (t) {
                        var a;
                        l.route[t] &&
                            !e &&
                            ((e = !0),
                            jt(c, (((a = {})[t] = l.route[t]), a), v, !1));
                    }),
                e ||
                    (l.route.async &&
                        ((c.allowPageChange = !1),
                        l.route.async.call(c, {
                            router: c,
                            to: v.route,
                            from: c.currentRoute,
                            resolve: t,
                            reject: a,
                            direction: "forward",
                            app: p,
                        })),
                    l.route.asyncComponent &&
                        Ft(c, l.route.asyncComponent, t, a));
        }
        function g() {
            c.allowPageChange = !0;
        }
        if (
            ((v.route = l),
            c.params.masterDetailBreakpoint > 0 && l.route.masterRoute)
        ) {
            var b = !0,
                y = !1;
            if (
                (c.currentRoute &&
                    c.currentRoute.route &&
                    (!(
                        !0 === c.currentRoute.route.master ||
                        ("function" == typeof c.currentRoute.route.master &&
                            c.currentRoute.route.master(p, c))
                    ) ||
                        (c.currentRoute.route !== l.route.masterRoute &&
                            c.currentRoute.route.path !==
                                l.route.masterRoute.path) ||
                        (b = !1),
                    !c.currentRoute.route.masterRoute ||
                        (c.currentRoute.route.masterRoute !==
                            l.route.masterRoute &&
                            c.currentRoute.route.masterRoute.path !==
                                l.route.masterRoute.path) ||
                        ((b = !1), (y = !0))),
                b || (y && t.reloadAll))
            )
                return (
                    c.navigate(
                        {
                            path: l.route.masterRoute.path,
                            params: l.params || {},
                        },
                        {
                            animate: !1,
                            reloadAll: t.reloadAll,
                            reloadCurrent: t.reloadCurrent,
                            reloadPrevious: t.reloadPrevious,
                            browserHistory: !t.initial,
                            history: !t.initial,
                            once: {
                                pageAfterIn: function () {
                                    c.navigate(
                                        e,
                                        Qe({}, t, {
                                            animate: !1,
                                            reloadAll: !1,
                                            reloadCurrent: !1,
                                            reloadPrevious: !1,
                                            history: !t.initial,
                                            browserHistory: !t.initial,
                                        })
                                    );
                                },
                            },
                        }
                    ),
                    c
                );
        }
        return (
            Nt.call(
                c,
                l,
                c.currentRoute,
                function () {
                    l.route.modules
                        ? p
                              .loadModules(
                                  Array.isArray(l.route.modules)
                                      ? l.route.modules
                                      : [l.route.modules]
                              )
                              .then(function () {
                                  m();
                              })
                              .catch(function () {
                                  g();
                              })
                        : m();
                },
                function () {
                    g();
                },
                "forward"
            ),
            c
        );
    }),
        (Wt.prototype.refreshPage = function () {
            var e = this;
            return (
                Vt(e, "refreshPage"),
                e.navigate(e.currentRoute.url, {
                    ignoreCache: !0,
                    reloadCurrent: !0,
                })
            );
        }),
        (Wt.prototype.tabLoad = function (e, t) {
            void 0 === t && (t = {});
            var a,
                r,
                n = this,
                o = Qe(
                    {
                        animate: n.params.animate,
                        browserHistory: !0,
                        history: !0,
                        parentPageEl: null,
                        preload: !1,
                        on: {},
                    },
                    t
                );
            o.route &&
                (o.preload ||
                    o.route === n.currentRoute ||
                    ((r = n.previousRoute), (n.currentRoute = o.route)),
                o.preload
                    ? ((a = o.route), (r = n.currentRoute))
                    : ((a = n.currentRoute), r || (r = n.previousRoute)),
                n.params.browserHistory &&
                    o.browserHistory &&
                    !o.reloadPrevious &&
                    Rt.replace(
                        n.view.id,
                        { url: o.route.url },
                        (n.params.browserHistoryRoot || "") +
                            n.params.browserHistorySeparator +
                            o.route.url
                    ),
                o.history &&
                    ((n.history[Math.max(n.history.length - 1, 0)] =
                        o.route.url),
                    n.saveHistory()));
            var i,
                s = Ee(o.parentPageEl || n.currentPageEl);
            i =
                s.length && s.find("#" + e.id).length
                    ? s.find("#" + e.id).eq(0)
                    : n.view.selector
                    ? n.view.selector + " #" + e.id
                    : "#" + e.id;
            var l,
                c = n.app.tab.show({
                    tabEl: i,
                    animate: o.animate,
                    tabRoute: o.route,
                }),
                p = c.$newTabEl,
                d = c.$oldTabEl,
                u = c.animated,
                h = c.onTabsChanged;
            if (p && p.parents(".page").length > 0 && o.route) {
                var f = p.parents(".page")[0].f7Page;
                f && o.route && (f.route = o.route);
            }
            if (p[0].f7RouterTabLoaded)
                return d && d.length
                    ? (u
                          ? h(function () {
                                n.emit(
                                    "routeChanged",
                                    n.currentRoute,
                                    n.previousRoute,
                                    n
                                );
                            })
                          : n.emit(
                                "routeChanged",
                                n.currentRoute,
                                n.previousRoute,
                                n
                            ),
                      n)
                    : n;
            function v(t, a) {
                var r = t.url,
                    o = t.content,
                    i = t.el,
                    s = t.component,
                    l = t.componentUrl;
                function c(t) {
                    (n.allowPageChange = !0),
                        t &&
                            ("string" == typeof t
                                ? p.html(t)
                                : (p.html(""),
                                  t.f7Component
                                      ? t.f7Component.mount(function (e) {
                                            p.append(e);
                                        })
                                      : p.append(t)),
                            (p[0].f7RouterTabLoaded = !0),
                            (function (t) {
                                n.removeThemeElements(p);
                                var a = p;
                                "string" != typeof t && (a = Ee(t)),
                                    a.trigger("tab:init tab:mounted", e),
                                    n.emit("tabInit tabMounted", p[0], e),
                                    d &&
                                        d.length &&
                                        (u
                                            ? h(function () {
                                                  n.emit(
                                                      "routeChanged",
                                                      n.currentRoute,
                                                      n.previousRoute,
                                                      n
                                                  ),
                                                      n.params
                                                          .unloadTabContent &&
                                                          n.tabRemove(d, p, e);
                                              })
                                            : (n.emit(
                                                  "routeChanged",
                                                  n.currentRoute,
                                                  n.previousRoute,
                                                  n
                                              ),
                                              n.params.unloadTabContent &&
                                                  n.tabRemove(d, p, e)));
                            })(t));
                }
                if (o) c(o);
                else if (i) c(i);
                else if (s || l)
                    try {
                        n.tabComponentLoader({
                            tabEl: p[0],
                            component: s,
                            componentUrl: l,
                            options: a,
                            resolve: c,
                            reject: function () {
                                return (n.allowPageChange = !0), n;
                            },
                        });
                    } catch (e) {
                        throw ((n.allowPageChange = !0), e);
                    }
                else
                    r &&
                        (n.xhrAbortController &&
                            (n.xhrAbortController.abort(),
                            (n.xhrAbortController = !1)),
                        n
                            .xhrRequest(r, a)
                            .then(function (e) {
                                c(e);
                            })
                            .catch(function () {
                                n.allowPageChange = !0;
                            }));
            }
            function m(e, t) {
                v(e, Qe(o, t));
            }
            function g() {
                n.allowPageChange = !0;
            }
            return (
                "url content component el componentUrl"
                    .split(" ")
                    .forEach(function (t) {
                        var a;
                        e[t] && ((l = !0), v((((a = {})[t] = e[t]), a), o));
                    }),
                e.async
                    ? e.async.call(n, {
                          router: n,
                          to: a,
                          from: r,
                          resolve: m,
                          reject: g,
                          app: n.app,
                      })
                    : e.asyncComponent
                    ? Ft(n, e.asyncComponent, m, g)
                    : l || (n.allowPageChange = !0),
                n
            );
        }),
        (Wt.prototype.tabRemove = function (e, t, a) {
            var r;
            e[0] &&
                ((e[0].f7RouterTabLoaded = !1), delete e[0].f7RouterTabLoaded),
                e.children().each(function (e) {
                    e.f7Component &&
                        ((r = !0),
                        Ee(e).trigger("tab:beforeremove", a),
                        e.f7Component.destroy());
                }),
                r || e.trigger("tab:beforeremove", a),
                this.emit("tabBeforeRemove", e[0], t[0], a),
                this.removeTabContent(e[0], a);
        }),
        (Wt.prototype.modalLoad = function (e, t, a, r) {
            void 0 === a && (a = {});
            var n,
                o = this,
                i = o.app,
                s = "panel" === e,
                l = s ? "panel" : "modal",
                c = Qe(
                    {
                        animate: o.params.animate,
                        browserHistory: !0,
                        history: !0,
                        on: {},
                        once: {},
                    },
                    a
                ),
                p = Qe({}, t.route[e]),
                d = t.route,
                u = function (e, t) {
                    var a,
                        r = c.on,
                        n = c.once;
                    "open" === t &&
                        (a =
                            r.modalOpen ||
                            n.modalOpen ||
                            r.panelOpen ||
                            n.panelOpen),
                        "close" === t &&
                            (a =
                                r.modalClose ||
                                n.modalClose ||
                                r.panelClose ||
                                n.panelClose),
                        "closed" === t &&
                            (a =
                                r.modalClosed ||
                                n.modalClosed ||
                                r.panelClosed ||
                                n.panelClosed),
                        a && a(e);
                };
            function h() {
                var a = i[e].create(p);
                d.modalInstance = a;
                var r = a.el;
                function n() {
                    a.close();
                }
                a.on(l + "Open", function () {
                    r ||
                        (o.removeThemeElements(a.el),
                        a.$el.trigger(
                            e.toLowerCase() +
                                ":init " +
                                e.toLowerCase() +
                                ":mounted",
                            t,
                            a
                        ),
                        o.emit(
                            (s ? "" : "modalInit") +
                                " " +
                                e +
                                "Init " +
                                e +
                                "Mounted",
                            a.el,
                            t,
                            a
                        )),
                        o.once("swipeBackMove", n),
                        u(a, "open");
                }),
                    a.on(l + "Close", function () {
                        o.off("swipeBackMove", n),
                            a.closeByRouter || o.back(),
                            u(a, "close");
                    }),
                    a.on(l + "Closed", function () {
                        a.$el.trigger(e.toLowerCase() + ":beforeremove", t, a),
                            a.emit(
                                (s ? "" : "modalBeforeRemove ") +
                                    e +
                                    "BeforeRemove",
                                a.el,
                                t,
                                a
                            );
                        var r = a.el.f7Component;
                        u(a, "closed"),
                            r && r.destroy(),
                            je(function () {
                                (r || p.component || p.asyncComponent) &&
                                    o.removeModal(a.el),
                                    a.destroy(),
                                    delete a.route,
                                    delete d.modalInstance;
                            });
                    }),
                    c.route &&
                        (o.params.browserHistory &&
                            c.browserHistory &&
                            Rt.push(
                                o.view.id,
                                { url: c.route.url, modal: e },
                                (o.params.browserHistoryRoot || "") +
                                    o.params.browserHistorySeparator +
                                    c.route.url
                            ),
                        c.route !== o.currentRoute &&
                            ((a.route = Qe(c.route, { modal: a })),
                            (o.currentRoute = a.route)),
                        c.history &&
                            !c.reloadCurrent &&
                            (o.history.push(c.route.url), o.saveHistory())),
                    r &&
                        (o.removeThemeElements(a.el),
                        a.$el.trigger(
                            e.toLowerCase() +
                                ":init " +
                                e.toLowerCase() +
                                ":mounted",
                            t,
                            a
                        ),
                        o.emit(
                            l + "Init " + e + "Init " + e + "Mounted",
                            a.el,
                            t,
                            a
                        )),
                    a.open(
                        !1 === c.animate || !0 === c.animate
                            ? c.animate
                            : void 0
                    );
            }
            function f(e, t) {
                var a = e.url,
                    r = e.content,
                    n = e.component,
                    s = e.componentUrl;
                function l(e) {
                    e &&
                        ("string" == typeof e
                            ? (p.content = e)
                            : e.f7Component
                            ? e.f7Component.mount(function (e) {
                                  (p.el = e), i.$el.append(e);
                              })
                            : (p.el = e),
                        h());
                }
                if (r) l(r);
                else if (n || s)
                    try {
                        o.modalComponentLoader({
                            rootEl: i.el,
                            component: n,
                            componentUrl: s,
                            options: t,
                            resolve: l,
                            reject: function () {
                                return (o.allowPageChange = !0), o;
                            },
                        });
                    } catch (e) {
                        throw ((o.allowPageChange = !0), e);
                    }
                else
                    a
                        ? (o.xhrAbortController &&
                              (o.xhrAbortController.abort(),
                              (o.xhrAbortController = !1)),
                          o
                              .xhrRequest(a, t)
                              .then(function (e) {
                                  (p.content = e), h();
                              })
                              .catch(function () {
                                  o.allowPageChange = !0;
                              }))
                        : h();
            }
            function v(e, t) {
                f(e, Qe(c, t));
            }
            function m() {
                o.allowPageChange = !0;
            }
            return (
                "url content component el componentUrl template"
                    .split(" ")
                    .forEach(function (e) {
                        var t;
                        p[e] &&
                            !n &&
                            ((n = !0), f((((t = {})[e] = p[e]), t), c));
                    }),
                n || "actions" !== e || h(),
                p.async &&
                    p.async.call(o, {
                        router: o,
                        to: c.route,
                        from: o.currentRoute,
                        resolve: v,
                        reject: m,
                        direction: r,
                        app: i,
                    }),
                p.asyncComponent && Ft(o, p.asyncComponent, v, m),
                o
            );
        }),
        (Wt.prototype.modalRemove = function (e) {
            Qe(e, { closeByRouter: !0 }), e.close();
        }),
        (Wt.prototype.back = function () {
            var e,
                t,
                a,
                r = this,
                n = pt();
            if (r.swipeBackActive) return r;
            "object" == typeof (arguments.length <= 0 ? void 0 : arguments[0])
                ? (t = (arguments.length <= 0 ? void 0 : arguments[0]) || {})
                : ((e = arguments.length <= 0 ? void 0 : arguments[0]),
                  (t = (arguments.length <= 1 ? void 0 : arguments[1]) || {}));
            var o = t,
                i = o.name,
                s = o.params,
                l = o.query;
            if (i)
                return (e = r.generateUrl({ name: i, params: s, query: l }))
                    ? r.back(
                          e,
                          Qe({}, t, { name: null, params: null, query: null })
                      )
                    : r;
            var c = r.app;
            Vt(r, "back");
            var p,
                d = r.currentRoute.modal;
            if (
                (d ||
                    "popup popover sheet loginScreen actions customModal panel"
                        .split(" ")
                        .forEach(function (e) {
                            r.currentRoute.route[e] && ((d = !0), (p = e));
                        }),
                d && !t.preload)
            ) {
                var u,
                    h =
                        r.currentRoute.modal ||
                        r.currentRoute.route.modalInstance ||
                        c[p].get(),
                    f = r.history[r.history.length - 2];
                if (h && h.$el) {
                    var v = h.$el.prevAll(".modal-in");
                    if (v.length && v[0].f7Modal) {
                        var m = v[0];
                        r.$el.parents(m).length || (u = m.f7Modal.route);
                    }
                }
                if (
                    (u || (u = r.findMatchingRoute(f)),
                    !u &&
                        f &&
                        (u = {
                            url: f,
                            path: f.split("?")[0],
                            query: We(f),
                            route: { path: f.split("?")[0], url: f },
                        }),
                    !(
                        (e && 0 !== e.replace(/[# ]/g, "").trim().length) ||
                        (u && h)
                    ))
                )
                    return r;
                var g = t.force && u && e;
                if (u && h) {
                    var b = n.ie || n.edge || (n.firefox && !n.ios),
                        y = r.params.browserHistory && !1 !== t.browserHistory,
                        w =
                            r.currentRoute &&
                            r.currentRoute.route &&
                            r.currentRoute.route.options &&
                            !1 === r.currentRoute.route.options.browserHistory;
                    !y || b || w || Rt.back(),
                        (r.currentRoute = u),
                        r.history.pop(),
                        r.saveHistory(),
                        y && b && !w && Rt.back(),
                        r.modalRemove(h),
                        g && r.navigate(e, { reloadCurrent: !0 });
                } else
                    h &&
                        (r.modalRemove(h),
                        e && r.navigate(e, { reloadCurrent: !0 }));
                return r;
            }
            var C,
                E = r.$el
                    .children(".page-current")
                    .prevAll(".page-previous:not(.page-master)")
                    .eq(0);
            if (r.params.masterDetailBreakpoint > 0) {
                var k = [];
                r.$el.children(".page").each(function (e) {
                    k.push(e.className);
                });
                var x = r.$el
                    .children(".page-current")
                    .prevAll(".page-master")
                    .eq(0);
                if (x.length) {
                    var $ = r.history[r.history.length - 2],
                        T = r.findMatchingRoute($);
                    T &&
                        x[0].f7Page &&
                        T.route === x[0].f7Page.route.route &&
                        ((E = x),
                        t.preload ||
                            (C = c.width >= r.params.masterDetailBreakpoint));
                }
            }
            if (!t.force && E.length && !C) {
                if (
                    r.params.browserHistory &&
                    E[0].f7Page &&
                    r.history[r.history.length - 2] !== E[0].f7Page.route.url
                )
                    return (
                        r.back(
                            r.history[r.history.length - 2],
                            Qe(t, { force: !0 })
                        ),
                        r
                    );
                var S = E[0].f7Page.route;
                return (
                    Nt.call(
                        r,
                        S,
                        r.currentRoute,
                        function () {
                            Yt(r, { el: E }, Qe(t, { route: S }));
                        },
                        function () {},
                        "backward"
                    ),
                    r
                );
            }
            if (
                ("#" === e && (e = void 0),
                e &&
                    "/" !== e[0] &&
                    0 !== e.indexOf("#") &&
                    (e = ((r.path || "/") + e).replace("//", "/")),
                !e &&
                    r.history.length > 1 &&
                    (e = r.history[r.history.length - 2]),
                C && !t.force && r.history[r.history.length - 3])
            )
                return r.back(
                    r.history[r.history.length - 3],
                    Qe({}, t || {}, { force: !0, animate: !1 })
                );
            if (C && !t.force) return r;
            if (
                ((a = r.findMatchingRoute(e)) ||
                    (e &&
                        (a = {
                            url: e,
                            path: e.split("?")[0],
                            query: We(e),
                            route: { path: e.split("?")[0], url: e },
                        })),
                !a)
            )
                return r;
            if (a.route.redirect) return Dt.call(r, "backward", a, t);
            var M,
                P = {};
            if (
                (a.route.options ? Qe(P, a.route.options, t) : Qe(P, t),
                (P.route = a),
                P.force &&
                    r.params.stackPages &&
                    (r.$el
                        .children(".page-previous.stacked")
                        .each(function (e) {
                            e.f7Page &&
                                e.f7Page.route &&
                                e.f7Page.route.url === a.url &&
                                ((M = !0), Yt(r, { el: e }, P));
                        }),
                    M))
            )
                return r;
            function O() {
                var e = !1;
                function t(e, t) {
                    (r.allowPageChange = !1), Yt(r, e, Qe(P, t), !0);
                }
                function n() {
                    r.allowPageChange = !0;
                }
                a.route.keepAlive &&
                    a.route.keepAliveData &&
                    (Yt(r, { el: a.route.keepAliveData.pageEl }, P), (e = !0)),
                    "url content component pageName el componentUrl"
                        .split(" ")
                        .forEach(function (t) {
                            var n;
                            a.route[t] &&
                                !e &&
                                ((e = !0),
                                Yt(r, (((n = {})[t] = a.route[t]), n), P));
                        }),
                    e ||
                        (a.route.async &&
                            ((r.allowPageChange = !1),
                            a.route.async.call(r, {
                                router: r,
                                to: a,
                                from: r.currentRoute,
                                resolve: t,
                                reject: n,
                                direction: "backward",
                                app: c,
                            })),
                        a.route.asyncComponent &&
                            Ft(r, a.route.asyncComponent, t, n));
            }
            function I() {
                r.allowPageChange = !0;
            }
            return (
                P.preload
                    ? O()
                    : Nt.call(
                          r,
                          a,
                          r.currentRoute,
                          function () {
                              a.route.modules
                                  ? c
                                        .loadModules(
                                            Array.isArray(a.route.modules)
                                                ? a.route.modules
                                                : [a.route.modules]
                                        )
                                        .then(function () {
                                            O();
                                        })
                                        .catch(function () {
                                            I();
                                        })
                                  : O();
                          },
                          function () {
                              I();
                          },
                          "backward"
                      ),
                r
            );
        }),
        (Wt.prototype.clearPreviousHistory = function () {
            var e = this;
            Vt(e, "clearPreviousHistory");
            var t = e.history[e.history.length - 1];
            !(function (e) {
                Vt(e, "clearPreviousPages");
                var t = e.app,
                    a = e.dynamicNavbar;
                e.$el
                    .children(".page")
                    .filter(function (t) {
                        return (
                            !(
                                !e.currentRoute ||
                                (!e.currentRoute.modal && !e.currentRoute.panel)
                            ) || t !== e.currentPageEl
                        );
                    })
                    .each(function (r) {
                        var n = Ee(r),
                            o = Ee(t.navbar.getElByPage(n));
                        e.params.stackPages && e.initialPages.indexOf(n[0]) >= 0
                            ? (n.addClass("stacked"),
                              a && o.addClass("stacked"))
                            : (e.pageCallback(
                                  "beforeRemove",
                                  n,
                                  o,
                                  "previous",
                                  void 0,
                                  {}
                              ),
                              e.removePage(n),
                              a && o.length && e.removeNavbar(o));
                    });
            })(e),
                (e.history = [t]),
                (e.view.history = [t]),
                e.saveHistory();
        });
    var Xt = {
        name: "router",
        static: { Router: Wt },
        instance: { cache: { xhr: [], templates: [], components: [] } },
        create: function () {
            var e = this;
            e.app
                ? e.params.router && (e.router = new Wt(e.app, e))
                : (e.router = new Wt(e));
        },
    };
    function Gt(e) {
        var t = e.app,
            a = ct();
        if (!e.resizableInitialized) {
            Qe(e, {
                resizable: !0,
                resizableWidth: null,
                resizableInitialized: !0,
            });
            var r = Ee("html"),
                n = e.$el;
            if (n) {
                var o,
                    i,
                    s,
                    l,
                    c,
                    p,
                    d,
                    u = {};
                (o = e.$el.children(".view-resize-handler")).length ||
                    (e.$el.append('<div class="view-resize-handler"></div>'),
                    (o = e.$el.children(".view-resize-handler"))),
                    (e.$resizeHandlerEl = o),
                    n.addClass("view-resizable");
                var h = !!a.passiveListener && { passive: !0 };
                e.$el.on(t.touchEvents.start, ".view-resize-handler", v, h),
                    t.on("touchmove:active", m),
                    t.on("touchend:passive", g),
                    t.on("resize", b),
                    e.on("beforeOpen", b),
                    e.once("viewDestroy", function () {
                        n.removeClass("view-resizable"),
                            e.$resizeHandlerEl.remove(),
                            e.$el.off(
                                t.touchEvents.start,
                                ".view-resize-handler",
                                v,
                                h
                            ),
                            t.off("touchmove:active", m),
                            t.off("touchend:passive", g),
                            t.off("resize", b),
                            e.off("beforeOpen", b);
                    });
            }
        }
        function f(e) {
            if (!e) return null;
            if (e.indexOf("%") >= 0 || e.indexOf("vw") >= 0)
                return (parseInt(e, 10) / 100) * t.width;
            var a = parseInt(e, 10);
            return Number.isNaN(a) ? null : a;
        }
        function v(t) {
            if (
                e.resizable &&
                n.hasClass("view-resizable") &&
                n.hasClass("view-master-detail")
            ) {
                (u.x =
                    "touchstart" === t.type
                        ? t.targetTouches[0].pageX
                        : t.pageX),
                    (u.y =
                        "touchstart" === t.type
                            ? t.targetTouches[0].pageY
                            : t.pageY),
                    (s = !1),
                    (i = !0);
                var a = n.children(".page-master");
                (p = f(a.css("min-width"))), (d = f(a.css("max-width")));
            }
        }
        function m(a) {
            if (i) {
                a.f7PreventSwipePanel = !0;
                var h =
                    "touchmove" === a.type ? a.targetTouches[0].pageX : a.pageX;
                s ||
                    ((c = o[0].offsetLeft + o[0].offsetWidth),
                    n.addClass("view-resizing"),
                    r.css("cursor", "col-resize")),
                    (s = !0),
                    a.preventDefault(),
                    (l = h - u.x);
                var f = c + l;
                p && !Number.isNaN(p) && (f = Math.max(f, p)),
                    d && !Number.isNaN(d) && (f = Math.min(f, d)),
                    (f = Math.min(Math.max(f, 0), t.width)),
                    (e.resizableWidth = f),
                    r[0].style.setProperty("--f7-page-master-width", f + "px"),
                    n.trigger("view:resize", f),
                    e.emit("local::resize viewResize", e, f);
            }
        }
        function g() {
            if ((Ee("html").css("cursor", ""), !i || !s))
                return (i = !1), void (s = !1);
            (i = !1),
                (s = !1),
                r[0].style.setProperty(
                    "--f7-page-master-width",
                    e.resizableWidth + "px"
                ),
                n.removeClass("view-resizing");
        }
        function b() {
            e.resizableWidth &&
                ((p = f(o.css("min-width"))),
                (d = f(o.css("max-width"))),
                p &&
                    !Number.isNaN(p) &&
                    e.resizableWidth < p &&
                    (e.resizableWidth = Math.max(e.resizableWidth, p)),
                d &&
                    !Number.isNaN(d) &&
                    e.resizableWidth > d &&
                    (e.resizableWidth = Math.min(e.resizableWidth, d)),
                (e.resizableWidth = Math.min(
                    Math.max(e.resizableWidth, 0),
                    t.width
                )),
                r[0].style.setProperty(
                    "--f7-page-master-width",
                    e.resizableWidth + "px"
                ));
        }
    }
    var Ut = (function (e) {
        function t(t, a, r) {
            var n;
            void 0 === r && (r = {});
            var o,
                i = ze((n = e.call(this, r, [t]) || this));
            if (!i.params.routerId && !Ee(a).length) {
                var s = "Framework7: can't create a View instance because ";
                throw new Error(
                    (s +=
                        "string" == typeof a
                            ? 'the selector "' +
                              a +
                              "\" didn't match any element"
                            : "el must be an HTMLElement or Dom7 object")
                );
            }
            return (
                (i.params = Qe(
                    { el: a },
                    { routes: [], routesAdd: [] },
                    t.params.view,
                    r
                )),
                i.params.routes.length > 0
                    ? (i.routes = i.params.routes)
                    : (i.routes = [].concat(t.routes, i.params.routesAdd)),
                Qe(!1, i, {
                    app: t,
                    name: i.params.name,
                    main: i.params.main,
                    history: [],
                    scrollHistory: {},
                }),
                i.useModules(),
                t.views.push(i),
                i.main && (t.views.main = i),
                i.name && (t.views[i.name] = i),
                (i.index = t.views.indexOf(i)),
                (o = i.name
                    ? "view_" + i.name
                    : i.main
                    ? "view_main"
                    : "view_" + i.index),
                (i.id = o),
                i.params.init
                    ? (t.initialized
                          ? i.init()
                          : t.on("init", function () {
                                i.init();
                            }),
                      i || ze(n))
                    : i || ze(n)
            );
        }
        Me(t, e);
        var a = t.prototype;
        return (
            (a.destroy = function () {
                var e = this,
                    t = e.app;
                e.$el.trigger("view:beforedestroy"),
                    e.emit("local::beforeDestroy viewBeforeDestroy", e),
                    t.off("resize", e.checkMasterDetailBreakpoint),
                    e.main
                        ? ((t.views.main = null), delete t.views.main)
                        : e.name &&
                          ((t.views[e.name] = null), delete t.views[e.name]),
                    (e.$el[0].f7View = null),
                    delete e.$el[0].f7View,
                    t.views.splice(t.views.indexOf(e), 1),
                    e.params.router && e.router && e.router.destroy(),
                    e.emit("local::destroy viewDestroy", e),
                    Object.keys(e).forEach(function (t) {
                        (e[t] = null), delete e[t];
                    }),
                    (e = null);
            }),
            (a.checkMasterDetailBreakpoint = function (e) {
                var t = this,
                    a = t.app,
                    r = t.$el.hasClass("view-master-detail"),
                    n =
                        a.width >= t.params.masterDetailBreakpoint &&
                        t.$el.children(".page-master").length;
                (void 0 === e && n) || !0 === e
                    ? (t.$el.addClass("view-master-detail"),
                      r ||
                          (t.emit(
                              "local::masterDetailBreakpoint viewMasterDetailBreakpoint",
                              t
                          ),
                          t.$el.trigger("view:masterDetailBreakpoint")))
                    : (t.$el.removeClass("view-master-detail"),
                      r &&
                          (t.emit(
                              "local::masterDetailBreakpoint viewMasterDetailBreakpoint",
                              t
                          ),
                          t.$el.trigger("view:masterDetailBreakpoint")));
            }),
            (a.initMasterDetail = function () {
                var e = this,
                    t = e.app;
                (e.checkMasterDetailBreakpoint =
                    e.checkMasterDetailBreakpoint.bind(e)),
                    e.checkMasterDetailBreakpoint(),
                    e.params.masterDetailResizable && Gt(e),
                    t.on("resize", e.checkMasterDetailBreakpoint);
            }),
            (a.mount = function (e) {
                var t,
                    a,
                    r = this,
                    n = r.app,
                    o = r.params.el || e,
                    i = Ee(o);
                (t =
                    "string" == typeof o
                        ? o
                        : (i.attr("id") ? "#" + i.attr("id") : "") +
                          (i.attr("class")
                              ? "." +
                                i
                                    .attr("class")
                                    .replace(/ /g, ".")
                                    .replace(".active", "")
                              : "")),
                    "ios" === n.theme &&
                        r.params.iosDynamicNavbar &&
                        0 === (a = i.children(".navbars").eq(0)).length &&
                        (a = Ee('<div class="navbars"></div>')),
                    Qe(r, {
                        $el: i,
                        el: i[0],
                        main: r.main || i.hasClass("view-main"),
                        $navbarsEl: a,
                        navbarsEl: a ? a[0] : void 0,
                        selector: t,
                    }),
                    r.main && (n.views.main = r),
                    i && i[0] && (i[0].f7View = r),
                    r.emit("local::mount viewMount", r);
            }),
            (a.init = function (e) {
                var t = this;
                t.mount(e),
                    t.params.router &&
                        (t.params.masterDetailBreakpoint > 0 &&
                            t.initMasterDetail(),
                        t.router.init(),
                        t.$el.trigger("view:init"),
                        t.emit("local::init viewInit", t));
            }),
            t
        );
    })(ut);
    Ut.use(Xt);
    var Kt = {
            name: "clicks",
            params: { clicks: { externalLinks: ".external" } },
            on: {
                init: function () {
                    !(function (e) {
                        e.on("click", function (t) {
                            var a = o(),
                                r = Ee(t.target),
                                n = r.closest("a"),
                                i = n.length > 0,
                                s = i && n.attr("href");
                            if (
                                i &&
                                (n.is(e.params.clicks.externalLinks) ||
                                    (s && s.indexOf("javascript:") >= 0))
                            ) {
                                var l = n.attr("target");
                                s &&
                                a.cordova &&
                                a.cordova.InAppBrowser &&
                                ("_system" === l || "_blank" === l)
                                    ? (t.preventDefault(),
                                      a.cordova.InAppBrowser.open(s, l))
                                    : s &&
                                      a.Capacitor &&
                                      a.Capacitor.Plugins &&
                                      a.Capacitor.Plugins.Browser &&
                                      ("_system" === l || "_blank" === l) &&
                                      (t.preventDefault(),
                                      a.Capacitor.Plugins.Browser.open({
                                          url: s,
                                      }));
                            } else {
                                Object.keys(e.modules).forEach(function (a) {
                                    var n = e.modules[a].clicks;
                                    n &&
                                        (t.preventF7Router ||
                                            Object.keys(n).forEach(function (
                                                a
                                            ) {
                                                var o = r.closest(a).eq(0);
                                                o.length > 0 &&
                                                    n[a].call(
                                                        e,
                                                        o,
                                                        o.dataset(),
                                                        t
                                                    );
                                            }));
                                });
                                var c = {};
                                if (
                                    (i &&
                                        (t.preventDefault(), (c = n.dataset())),
                                    (c.clickedEl = n[0]),
                                    !t.preventF7Router &&
                                        !n.hasClass("prevent-router") &&
                                        !n.hasClass("router-prevent") &&
                                        ((s && s.length > 0 && "#" !== s[0]) ||
                                            n.hasClass("back")))
                                ) {
                                    var p;
                                    if (
                                        (c.view && "current" === c.view
                                            ? (p = e.views.current)
                                            : c.view
                                            ? (p = Ee(c.view)[0].f7View)
                                            : ((p =
                                                  r.parents(".view")[0] &&
                                                  r.parents(".view")[0].f7View),
                                              !n.hasClass("back") &&
                                                  p &&
                                                  p.params.linksView &&
                                                  ("string" ==
                                                  typeof p.params.linksView
                                                      ? (p = Ee(
                                                            p.params.linksView
                                                        )[0].f7View)
                                                      : p.params
                                                            .linksView instanceof
                                                            Ut &&
                                                        (p =
                                                            p.params
                                                                .linksView))),
                                        p ||
                                            (e.views.main &&
                                                (p = e.views.main)),
                                        !p || !p.router)
                                    )
                                        return;
                                    n[0].f7RouteProps &&
                                        (c.props = n[0].f7RouteProps),
                                        n.hasClass("back")
                                            ? p.router.back(s, c)
                                            : p.router.navigate(s, c);
                                }
                            }
                        });
                    })(this);
                },
            },
        },
        Qt = {
            name: "routerComponentLoader",
            proto: {
                componentLoader: function (e, t, a, r, n) {
                    void 0 === a && (a = {});
                    var o,
                        i = this,
                        s = i.app,
                        l = "string" == typeof e ? e : t,
                        c = i.replaceRequestUrlParams(l, a);
                    function p(e) {
                        var t = a.context || {};
                        if ("function" == typeof t) t = t.call(i);
                        else if ("string" == typeof t)
                            try {
                                t = JSON.parse(t);
                            } catch (e) {
                                throw (n(e), e);
                            }
                        var o,
                            l,
                            c = Ke({}, t, { f7route: a.route, f7router: i }),
                            p = Ke(
                                (a.route && a.route.params) || {},
                                a.props || {},
                                a.routeProps || {}
                            );
                        a.componentOptions &&
                            a.componentOptions.el &&
                            (o = a.componentOptions.el),
                            a.componentOptions &&
                                a.componentOptions.root &&
                                (l = a.componentOptions.root),
                            s.component
                                .create(e, p, { context: c, el: o, root: l })
                                .then(function (e) {
                                    r(e.el);
                                })
                                .catch(function (e) {
                                    throw (n(e), new Error(e));
                                });
                    }
                    c &&
                        i.params.componentCache &&
                        i.cache.components.forEach(function (e) {
                            e.url === c && (o = e.component);
                        }),
                        c && o
                            ? p(o)
                            : c && !o
                            ? (i.xhrAbortController &&
                                  (i.xhrAbortController.abort(),
                                  (i.xhrAbortController = !1)),
                              i
                                  .xhrRequest(l, a)
                                  .then(function (e) {
                                      var t = s.component.parse(e);
                                      i.params.componentCache &&
                                          i.cache.components.push({
                                              url: c,
                                              component: t,
                                          }),
                                          p(t);
                                  })
                                  .catch(function (e) {
                                      throw (n(), e);
                                  }))
                            : p(e);
                },
                modalComponentLoader: function (e) {
                    var t = void 0 === e ? {} : e,
                        a = t.component,
                        r = t.componentUrl,
                        n = t.options,
                        o = t.resolve,
                        i = t.reject;
                    this.componentLoader(
                        a,
                        r,
                        n,
                        function (e) {
                            o(e);
                        },
                        i
                    );
                },
                tabComponentLoader: function (e) {
                    var t = void 0 === e ? {} : e,
                        a = t.component,
                        r = t.componentUrl,
                        n = t.options,
                        o = t.resolve,
                        i = t.reject;
                    this.componentLoader(
                        a,
                        r,
                        n,
                        function (e) {
                            o(e);
                        },
                        i
                    );
                },
                pageComponentLoader: function (e) {
                    var t = void 0 === e ? {} : e,
                        a = t.component,
                        r = t.componentUrl,
                        n = t.options,
                        o = t.resolve,
                        i = t.reject;
                    this.componentLoader(
                        a,
                        r,
                        n,
                        function (e, t) {
                            void 0 === t && (t = {}), o(e, t);
                        },
                        i
                    );
                },
            },
        },
        Jt = function e(t, a, r, n) {
            var o;
            a[0] = 0;
            for (var i = 1; i < a.length; i++) {
                var s = a[i++],
                    l = a[i] ? ((a[0] |= s ? 1 : 2), r[a[i++]]) : a[++i];
                3 === s
                    ? (n[0] = l)
                    : 4 === s
                    ? (n[1] = Object.assign(n[1] || {}, l))
                    : 5 === s
                    ? ((n[1] = n[1] || {})[a[++i]] = l)
                    : 6 === s
                    ? (n[1][a[++i]] += l + "")
                    : s
                    ? ((o = t.apply(l, e(t, l, r, ["", null]))),
                      n.push(o),
                      l[0] ? (a[0] |= 2) : ((a[i - 2] = 0), (a[i] = o)))
                    : n.push(l);
            }
            return n;
        },
        Zt = new Map();
    var ea = [!1, null, "", void 0],
        ta = function (e) {
            var t = Zt.get(this);
            return (
                t || ((t = new Map()), Zt.set(this, t)),
                (t = Jt(
                    this,
                    t.get(e) ||
                        (t.set(
                            e,
                            (t = (function (e) {
                                for (
                                    var t,
                                        a,
                                        r = 1,
                                        n = "",
                                        o = "",
                                        i = [0],
                                        s = function (e) {
                                            1 === r &&
                                            (e ||
                                                (n = n.replace(
                                                    /^\s*\n\s*|\s*\n\s*$/g,
                                                    ""
                                                )))
                                                ? i.push(0, e, n)
                                                : 3 === r && (e || n)
                                                ? (i.push(3, e, n), (r = 2))
                                                : 2 === r && "..." === n && e
                                                ? i.push(4, e, 0)
                                                : 2 === r && n && !e
                                                ? i.push(5, 0, !0, n)
                                                : r >= 5 &&
                                                  ((n || (!e && 5 === r)) &&
                                                      (i.push(r, 0, n, a),
                                                      (r = 6)),
                                                  e &&
                                                      (i.push(r, e, 0, a),
                                                      (r = 6))),
                                                (n = "");
                                        },
                                        l = 0;
                                    l < e.length;
                                    l++
                                ) {
                                    l && (1 === r && s(), s(l));
                                    for (var c = 0; c < e[l].length; c++)
                                        (t = e[l][c]),
                                            1 === r
                                                ? "<" === t
                                                    ? (s(), (i = [i]), (r = 3))
                                                    : (n += t)
                                                : 4 === r
                                                ? "--" === n && ">" === t
                                                    ? ((r = 1), (n = ""))
                                                    : (n = t + n[0])
                                                : o
                                                ? t === o
                                                    ? (o = "")
                                                    : (n += t)
                                                : '"' === t || "'" === t
                                                ? (o = t)
                                                : ">" === t
                                                ? (s(), (r = 1))
                                                : r &&
                                                  ("=" === t
                                                      ? ((r = 5),
                                                        (a = n),
                                                        (n = ""))
                                                      : "/" === t &&
                                                        (r < 5 ||
                                                            ">" === e[l][c + 1])
                                                      ? (s(),
                                                        3 === r && (i = i[0]),
                                                        (r = i),
                                                        (i = i[0]).push(
                                                            2,
                                                            0,
                                                            r
                                                        ),
                                                        (r = 0))
                                                      : " " === t ||
                                                        "\t" === t ||
                                                        "\n" === t ||
                                                        "\r" === t
                                                      ? (s(), (r = 2))
                                                      : (n += t)),
                                            3 === r &&
                                                "!--" === n &&
                                                ((r = 4), (i = i[0]));
                                }
                                return s(), i;
                            })(e))
                        ),
                        t),
                    arguments,
                    []
                )).length > 1
                    ? t
                    : t[0]
            );
        }.bind(function (e, t) {
            for (
                var a = arguments.length,
                    r = new Array(a > 2 ? a - 2 : 0),
                    n = 2;
                n < a;
                n++
            )
                r[n - 2] = arguments[n];
            return {
                type: e,
                props: t || {},
                children: ot(
                    r.filter(function (e) {
                        return ea.indexOf(e) < 0;
                    })
                ),
            };
        });
    function aa(e, t, a, r, n) {
        return {
            sel: e,
            data: t,
            children: a,
            text: r,
            elm: n,
            key: void 0 === t ? void 0 : t.key,
        };
    }
    var ra = Array.isArray;
    function na(e) {
        return "string" == typeof e || "number" == typeof e;
    }
    function oa(e, t, a) {
        if (
            ((e.ns = "http://www.w3.org/2000/svg"),
            "foreignObject" !== a && void 0 !== t)
        )
            for (var r = 0; r < t.length; ++r) {
                var n = t[r].data;
                void 0 !== n && oa(n, t[r].children, t[r].sel);
            }
    }
    function ia(e, t, a) {
        var r,
            n,
            o,
            i = {};
        if (
            (void 0 !== a
                ? ((i = t),
                  ra(a) ? (r = a) : na(a) ? (n = a) : a && a.sel && (r = [a]))
                : void 0 !== t &&
                  (ra(t)
                      ? (r = t)
                      : na(t)
                      ? (n = t)
                      : t && t.sel
                      ? (r = [t])
                      : (i = t)),
            ra(r))
        )
            for (o = 0; o < r.length; ++o)
                na(r[o]) && (r[o] = aa(void 0, void 0, void 0, r[o], void 0));
        return (
            "s" !== e[0] ||
                "v" !== e[1] ||
                "g" !== e[2] ||
                (3 !== e.length && "." !== e[3] && "#" !== e[3]) ||
                oa(i, r, e),
            aa(e, i, r, n, void 0)
        );
    }
    var sa = {},
        la =
            "area base br col command embed hr img input keygen link menuitem meta param source track wbr".split(
                " "
            ),
        ca =
            "hidden checked disabled readonly selected autofocus autoplay required multiple value indeterminate routeProps innerHTML".split(
                " "
            ),
        pa =
            "hidden checked disabled readonly selected autofocus autoplay required multiple readOnly indeterminate".split(
                " "
            ),
        da = function (e) {
            return "function" == typeof e.type
                ? e.type.name || "CustomComponent"
                : e.type;
        },
        ua = function (e) {
            return e
                .split("-")
                .map(function (e, t) {
                    return 0 === t
                        ? e.toLowerCase()
                        : e[0].toUpperCase() + e.substr(1);
                })
                .join("");
        },
        ha = function () {
            for (
                var e = {}, t = arguments.length, a = new Array(t), r = 0;
                r < t;
                r++
            )
                a[r] = arguments[r];
            return (
                a.forEach(function (t) {
                    void 0 === t && (t = {}),
                        Object.keys(t).forEach(function (a) {
                            e[ua(a)] = t[a];
                        });
                }),
                e
            );
        },
        fa = function (e) {
            return "function" == typeof e || (e && e.indexOf("-") > 0 && sa[e]);
        };
    function va(e, t, a, r, n) {
        var o = {},
            i = [],
            s = [],
            l = [],
            c = [],
            p = !1,
            d = da(e);
        t &&
            t.attrs &&
            t.attrs.component &&
            (t.attrs.component,
            (function (e) {
                throw new TypeError('"' + e + '" is read-only');
            })("tagName"),
            delete t.attrs.component,
            (p = !0));
        var u = fa(e.type);
        if (
            (u &&
                (i.push(function (r) {
                    (r.sel === d || p) &&
                        (function (e) {
                            var t = e.f7,
                                a = e.treeNode,
                                r = e.vnode,
                                n = e.data,
                                o =
                                    "function" == typeof a.type
                                        ? a.type
                                        : sa[a.type];
                            t.component
                                .create(o, ha(n.attrs || {}, n.props || {}), {
                                    el: r.elm,
                                    children: a.children,
                                })
                                .then(function (e) {
                                    r.data &&
                                        r.data.on &&
                                        e &&
                                        e.$el &&
                                        Object.keys(r.data.on).forEach(
                                            function (t) {
                                                e.$el.on(t, r.data.on[t]);
                                            }
                                        ),
                                        (r.elm.__component__ = e);
                                });
                        })({ f7: a, treeNode: e, vnode: r, data: t });
                }),
                s.push(function (e) {
                    !(function (e) {
                        var t = e && e.elm && e.elm.__component__;
                        if (t) {
                            var a = t.el,
                                r = t.$el;
                            e.data &&
                                e.data.on &&
                                r &&
                                Object.keys(e.data.on).forEach(function (t) {
                                    r.off(t, e.data.on[t]);
                                }),
                                t.destroy && t.destroy(),
                                a &&
                                    a.parentNode &&
                                    a.parentNode.removeChild(a),
                                delete e.elm.__component__;
                        }
                    })(e);
                }),
                l.push(function (e, t) {
                    !(function (e) {
                        var t = e && e.elm && e.elm.__component__;
                        if (t) {
                            var a = ha(e.data.attrs || {}, e.data.props || {});
                            (t.children = e.data.treeNode.children),
                                Object.assign(t.props, a),
                                t.update();
                        }
                    })(t);
                })),
            !u)
        ) {
            if (!t || !t.attrs || !t.attrs.class) return o;
            t.attrs.class.split(" ").forEach(function (e) {
                r || i.push.apply(i, a.getVnodeHooks("insert", e)),
                    s.push.apply(s, a.getVnodeHooks("destroy", e)),
                    l.push.apply(l, a.getVnodeHooks("update", e)),
                    c.push.apply(c, a.getVnodeHooks("postpatch", e));
            });
        }
        return (
            n &&
                !r &&
                c.push(function (e, t) {
                    var a = t || e;
                    a &&
                        a.data &&
                        a.data.component &&
                        a.data.component.hook("onUpdated");
                }),
            (0 === i.length &&
                0 === s.length &&
                0 === l.length &&
                0 === c.length) ||
                (i.length &&
                    (o.insert = function (e) {
                        i.forEach(function (t) {
                            return t(e);
                        });
                    }),
                s.length &&
                    (o.destroy = function (e) {
                        s.forEach(function (t) {
                            return t(e);
                        });
                    }),
                l.length &&
                    (o.update = function (e, t) {
                        l.forEach(function (a) {
                            return a(e, t);
                        });
                    }),
                c.length &&
                    (o.postpatch = function (e, t) {
                        c.forEach(function (a) {
                            return a(e, t);
                        });
                    })),
            o
        );
    }
    var ma = function (e, t, a, r) {
            if (e && e.type && la.indexOf(e.type) >= 0) return [];
            for (var n = [], o = e.children, i = 0; i < o.length; i += 1) {
                var s = o[i],
                    l = ba(s, t, a, r, !1);
                Array.isArray(l) ? n.push.apply(n, l) : l && n.push(l);
            }
            return n;
        },
        ga = function (e, t, a, r) {
            var n = e.props.name || "default",
                o = (t.children || []).filter(function (e) {
                    var t = "default";
                    return e.props && (t = e.props.slot || "default"), t === n;
                });
            return 0 === o.length
                ? ma(e, t, a, r)
                : o.map(function (e) {
                      return ba(e, t, a, r);
                  });
        },
        ba = function (e, t, a, r, n) {
            if (
                !(function (e) {
                    return (
                        Ue(e) && "props" in e && "type" in e && "children" in e
                    );
                })(e)
            )
                return String(e);
            if ("slot" === e.type) return ga(e, t, a, r);
            var o = (function (e, t, a, r, n) {
                    var o = { component: t, treeNode: e },
                        i = da(e);
                    Object.keys(e.props).forEach(function (t) {
                        var a = e.props[t];
                        if (void 0 !== a)
                            if (ca.indexOf(t) >= 0)
                                o.props || (o.props = {}),
                                    "readonly" === t && (t = "readOnly"),
                                    "routeProps" === t && (t = "f7RouteProps"),
                                    "option" === i &&
                                        "value" === t &&
                                        (o.attrs || (o.attrs = {}),
                                        (o.attrs.value = a)),
                                    pa.indexOf(t) >= 0
                                        ? (o.props[t] = !1 !== a)
                                        : (o.props[t] = a);
                            else if ("key" === t) o.key = a;
                            else if (
                                0 === t.indexOf("@") ||
                                (0 === t.indexOf("on") && t.length > 2)
                            ) {
                                o.on || (o.on = {});
                                var r =
                                        0 === t.indexOf("@")
                                            ? t.substr(1)
                                            : Ve(t.substr(2)),
                                    s = !1,
                                    l = !1,
                                    c = !1;
                                r.indexOf(".") >= 0 &&
                                    r.split(".").forEach(function (e, t) {
                                        0 === t
                                            ? (r = e)
                                            : ("stop" === e && (s = !0),
                                              "prevent" === e && (l = !0),
                                              "once" === e && (c = !0));
                                    }),
                                    (o.on[r] = (function (e, t) {
                                        var a = void 0 === t ? {} : t,
                                            r = a.stop,
                                            n = a.prevent,
                                            o = a.once,
                                            i = !1;
                                        return function () {
                                            var t =
                                                arguments.length <= 0
                                                    ? void 0
                                                    : arguments[0];
                                            (o && i) ||
                                                (r && t.stopPropagation(),
                                                n && t.preventDefault(),
                                                (i = !0),
                                                e.apply(void 0, arguments));
                                        };
                                    })(a, { stop: s, prevent: l, once: c }));
                            } else
                                "style" === t
                                    ? "string" != typeof a
                                        ? (o.style = a)
                                        : (o.attrs || (o.attrs = {}),
                                          (o.attrs.style = a))
                                    : (o.attrs || (o.attrs = {}),
                                      (o.attrs[t] = a),
                                      "id" !== t || o.key || n || (o.key = a));
                    });
                    var s = va(e, o, a, r, n);
                    return (
                        (s.prepatch = function (e, t) {
                            e &&
                                t &&
                                e &&
                                e.data &&
                                e.data.props &&
                                Object.keys(e.data.props).forEach(function (a) {
                                    pa.indexOf(a) < 0 ||
                                        (t.data || (t.data = {}),
                                        t.data.props || (t.data.props = {}),
                                        !0 !== e.data.props[a] ||
                                            a in t.data.props ||
                                            (t.data.props[a] = !1));
                                });
                        }),
                        (o.hook = s),
                        o
                    );
                })(e, t, a, r, n),
                i = fa(e.type) ? [] : ma(e, t, a, r);
            return ia(da(e), o, i);
        };
    function ya(e, t, a) {
        return void 0 === e && (e = {}), ba(e, t, t.f7, a, !0);
    }
    var wa = {
        createElement: function (e) {
            return document.createElement(e);
        },
        createElementNS: function (e, t) {
            return document.createElementNS(e, t);
        },
        createTextNode: function (e) {
            return document.createTextNode(e);
        },
        createComment: function (e) {
            return document.createComment(e);
        },
        insertBefore: function (e, t, a) {
            a &&
                a.parentNode !== e &&
                a.__component__ &&
                (a = a.__component__.el),
                e.insertBefore(t, a);
        },
        removeChild: function (e, t) {
            e && e.removeChild(t);
        },
        appendChild: function (e, t) {
            e.appendChild(t);
        },
        parentNode: function (e) {
            return e.parentNode;
        },
        nextSibling: function (e) {
            return e.nextSibling;
        },
        tagName: function (e) {
            return e.tagName;
        },
        setTextContent: function (e, t) {
            e.textContent = t;
        },
        getTextContent: function (e) {
            return e.textContent;
        },
        isElement: function (e) {
            return 1 === e.nodeType;
        },
        isText: function (e) {
            return 3 === e.nodeType;
        },
        isComment: function (e) {
            return 8 === e.nodeType;
        },
    };
    function Ca(e) {
        return void 0 === e;
    }
    function Ea(e) {
        return void 0 !== e;
    }
    var ka = aa("", {}, [], void 0, void 0);
    function xa(e, t) {
        return e.key === t.key && e.sel === t.sel;
    }
    function $a(e, t, a) {
        var r,
            n,
            o,
            i = {};
        for (r = t; r <= a; ++r)
            null != (o = e[r]) && void 0 !== (n = o.key) && (i[n] = r);
        return i;
    }
    var Ta = ["create", "update", "remove", "destroy", "pre", "post"];
    function Sa(e, t) {
        var a,
            r = t.elm,
            n = e.data.attrs,
            o = t.data.attrs;
        if ((n || o) && n !== o) {
            for (a in ((n = n || {}), (o = o || {}))) {
                var i = o[a];
                n[a] !== i &&
                    (!0 === i
                        ? r.setAttribute(a, "")
                        : !1 === i
                        ? r.removeAttribute(a)
                        : 120 !== a.charCodeAt(0)
                        ? r.setAttribute(a, i)
                        : 58 === a.charCodeAt(3)
                        ? r.setAttributeNS(
                              "http://www.w3.org/XML/1998/namespace",
                              a,
                              i
                          )
                        : 58 === a.charCodeAt(5)
                        ? r.setAttributeNS("http://www.w3.org/1999/xlink", a, i)
                        : r.setAttribute(a, i));
            }
            for (a in n) a in o || r.removeAttribute(a);
        }
    }
    var Ma = { create: Sa, update: Sa };
    function Pa(e, t) {
        var a,
            r,
            n = t.elm,
            o = e.data.props,
            i = t.data.props;
        if ((o || i) && o !== i) {
            for (a in ((i = i || {}), (o = o || {}))) i[a] || delete n[a];
            for (a in i)
                (r = i[a]),
                    o[a] === r || ("value" === a && n[a] === r) || (n[a] = r);
        }
    }
    var Oa = { create: Pa, update: Pa },
        Ia =
            ("undefined" != typeof window && window.requestAnimationFrame) ||
            setTimeout;
    function Ba(e, t, a) {
        var r;
        (r = function () {
            e[t] = a;
        }),
            Ia(function () {
                Ia(r);
            });
    }
    function La(e, t) {
        var a,
            r,
            n = t.elm,
            o = e.data.style,
            i = t.data.style;
        if ((o || i) && o !== i) {
            i = i || {};
            var s = "delayed" in (o = o || {});
            for (r in o)
                i[r] ||
                    ("-" === r[0] && "-" === r[1]
                        ? n.style.removeProperty(r)
                        : (n.style[r] = ""));
            for (r in i)
                if (((a = i[r]), "delayed" === r && i.delayed))
                    for (var l in i.delayed)
                        (a = i.delayed[l]),
                            (s && a === o.delayed[l]) || Ba(n.style, l, a);
                else
                    "remove" !== r &&
                        a !== o[r] &&
                        ("-" === r[0] && "-" === r[1]
                            ? n.style.setProperty(r, a)
                            : (n.style[r] = a));
        }
    }
    function za(e, t, a) {
        var r = e.type,
            n = a.data.on;
        n &&
            n[r] &&
            (function (e, t, a) {
                "function" == typeof e && e.apply(void 0, [t].concat(a));
            })(n[r], e, t);
    }
    function Ra(e, t) {
        var a = e.data.on,
            r = e.listener,
            n = e.elm,
            o = t && t.data.on,
            i = t && t.elm;
        if (
            a !== o &&
            (a &&
                r &&
                (o
                    ? Object.keys(a).forEach(function (e) {
                          o[e] || Ee(n).off(e, r);
                      })
                    : Object.keys(a).forEach(function (e) {
                          Ee(n).off(e, r);
                      })),
            o)
        ) {
            var s =
                e.listener ||
                function e(t) {
                    for (
                        var a = arguments.length,
                            r = new Array(a > 1 ? a - 1 : 0),
                            n = 1;
                        n < a;
                        n++
                    )
                        r[n - 1] = arguments[n];
                    za(t, r, e.vnode);
                };
            (t.listener = s),
                (s.vnode = t),
                a
                    ? Object.keys(o).forEach(function (e) {
                          a[e] || Ee(i).on(e, s);
                      })
                    : Object.keys(o).forEach(function (e) {
                          Ee(i).on(e, s);
                      });
        }
    }
    var Aa = (function (e, t) {
            var a,
                r,
                n = {},
                o = void 0 !== t ? t : wa;
            for (a = 0; a < Ta.length; ++a)
                for (n[Ta[a]] = [], r = 0; r < e.length; ++r) {
                    var i = e[r][Ta[a]];
                    void 0 !== i && n[Ta[a]].push(i);
                }
            function s(e) {
                var t = e.id ? "#" + e.id : "",
                    a = e.className
                        ? "." + e.className.split(" ").join(".")
                        : "";
                return aa(
                    o.tagName(e).toLowerCase() + t + a,
                    {},
                    [],
                    void 0,
                    e
                );
            }
            function l(e, t) {
                return function () {
                    if (0 == --t) {
                        var a = o.parentNode(e);
                        o.removeChild(a, e);
                    }
                };
            }
            function c(e, t) {
                var a,
                    r = e.data;
                void 0 !== r &&
                    Ea((a = r.hook)) &&
                    Ea((a = a.init)) &&
                    (a(e), (r = e.data));
                var i = e.children,
                    s = e.sel;
                if ("!" === s)
                    Ca(e.text) && (e.text = ""),
                        (e.elm = o.createComment(e.text));
                else if (void 0 !== s) {
                    var l = s.indexOf("#"),
                        p = s.indexOf(".", l),
                        d = l > 0 ? l : s.length,
                        u = p > 0 ? p : s.length,
                        h =
                            -1 !== l || -1 !== p
                                ? s.slice(0, Math.min(d, u))
                                : s,
                        f = (e.elm =
                            Ea(r) && Ea((a = r.ns))
                                ? o.createElementNS(a, h)
                                : o.createElement(h));
                    for (
                        d < u && f.setAttribute("id", s.slice(d + 1, u)),
                            p > 0 &&
                                f.setAttribute(
                                    "class",
                                    s.slice(u + 1).replace(/\./g, " ")
                                ),
                            a = 0;
                        a < n.create.length;
                        ++a
                    )
                        n.create[a](ka, e);
                    if (ra(i))
                        for (a = 0; a < i.length; ++a) {
                            var v = i[a];
                            null != v && o.appendChild(f, c(v, t));
                        }
                    else
                        na(e.text) &&
                            o.appendChild(f, o.createTextNode(e.text));
                    Ea((a = e.data.hook)) &&
                        (a.create && a.create(ka, e), a.insert && t.push(e));
                } else e.elm = o.createTextNode(e.text);
                return e.elm;
            }
            function p(e, t, a, r, n, i) {
                for (; r <= n; ++r) {
                    var s = a[r];
                    null != s && o.insertBefore(e, c(s, i), t);
                }
            }
            function d(e) {
                var t,
                    a,
                    r = e.data;
                if (void 0 !== r) {
                    for (
                        Ea((t = r.hook)) && Ea((t = t.destroy)) && t(e), t = 0;
                        t < n.destroy.length;
                        ++t
                    )
                        n.destroy[t](e);
                    if (void 0 !== e.children)
                        for (a = 0; a < e.children.length; ++a)
                            null != (t = e.children[a]) &&
                                "string" != typeof t &&
                                d(t);
                }
            }
            function u(e, t, a, r) {
                for (; a <= r; ++a) {
                    var i = void 0,
                        s = void 0,
                        c = void 0,
                        p = t[a];
                    if (null != p)
                        if (Ea(p.sel)) {
                            for (
                                d(p),
                                    s = n.remove.length + 1,
                                    c = l(p.elm, s),
                                    i = 0;
                                i < n.remove.length;
                                ++i
                            )
                                n.remove[i](p, c);
                            Ea((i = p.data)) &&
                            Ea((i = i.hook)) &&
                            Ea((i = i.remove))
                                ? i(p, c)
                                : c();
                        } else o.removeChild(e, p.elm);
                }
            }
            function h(e, t, a) {
                var r, i;
                Ea((r = t.data)) &&
                    Ea((i = r.hook)) &&
                    Ea((r = i.prepatch)) &&
                    r(e, t);
                var s = (t.elm = e.elm),
                    l = e.children,
                    d = t.children;
                if (e !== t) {
                    if (void 0 !== t.data) {
                        for (r = 0; r < n.update.length; ++r) n.update[r](e, t);
                        Ea((r = t.data.hook)) && Ea((r = r.update)) && r(e, t);
                    }
                    Ca(t.text)
                        ? Ea(l) && Ea(d)
                            ? l !== d &&
                              (function (e, t, a, r) {
                                  for (
                                      var n,
                                          i,
                                          s,
                                          l = 0,
                                          d = 0,
                                          f = t.length - 1,
                                          v = t[0],
                                          m = t[f],
                                          g = a.length - 1,
                                          b = a[0],
                                          y = a[g];
                                      l <= f && d <= g;

                                  )
                                      null == v
                                          ? (v = t[++l])
                                          : null == m
                                          ? (m = t[--f])
                                          : null == b
                                          ? (b = a[++d])
                                          : null == y
                                          ? (y = a[--g])
                                          : xa(v, b)
                                          ? (h(v, b, r),
                                            (v = t[++l]),
                                            (b = a[++d]))
                                          : xa(m, y)
                                          ? (h(m, y, r),
                                            (m = t[--f]),
                                            (y = a[--g]))
                                          : xa(v, y)
                                          ? (h(v, y, r),
                                            o.insertBefore(
                                                e,
                                                v.elm,
                                                o.nextSibling(m.elm)
                                            ),
                                            (v = t[++l]),
                                            (y = a[--g]))
                                          : xa(m, b)
                                          ? (h(m, b, r),
                                            o.insertBefore(e, m.elm, v.elm),
                                            (m = t[--f]),
                                            (b = a[++d]))
                                          : (void 0 === n && (n = $a(t, l, f)),
                                            Ca((i = n[b.key]))
                                                ? (o.insertBefore(
                                                      e,
                                                      c(b, r),
                                                      v.elm
                                                  ),
                                                  (b = a[++d]))
                                                : ((s = t[i]).sel !== b.sel
                                                      ? o.insertBefore(
                                                            e,
                                                            c(b, r),
                                                            v.elm
                                                        )
                                                      : (h(s, b, r),
                                                        (t[i] = void 0),
                                                        o.insertBefore(
                                                            e,
                                                            s.elm,
                                                            v.elm
                                                        )),
                                                  (b = a[++d])));
                                  (l <= f || d <= g) &&
                                      (l > f
                                          ? p(
                                                e,
                                                null == a[g + 1]
                                                    ? null
                                                    : a[g + 1].elm,
                                                a,
                                                d,
                                                g,
                                                r
                                            )
                                          : u(e, t, l, f));
                              })(s, l, d, a)
                            : Ea(d)
                            ? (Ea(e.text) && o.setTextContent(s, ""),
                              p(s, null, d, 0, d.length - 1, a))
                            : Ea(l)
                            ? u(s, l, 0, l.length - 1)
                            : Ea(e.text) && o.setTextContent(s, "")
                        : e.text !== t.text && o.setTextContent(s, t.text),
                        Ea(i) && Ea((r = i.postpatch)) && r(e, t);
                }
            }
            return function (e, t) {
                var a,
                    r,
                    i,
                    l = [];
                for (a = 0; a < n.pre.length; ++a) n.pre[a]();
                for (
                    (function (e) {
                        return void 0 !== e.sel;
                    })(e) || (e = s(e)),
                        xa(e, t)
                            ? h(e, t, l)
                            : ((r = e.elm),
                              (i = o.parentNode(r)),
                              c(t, l),
                              null !== i &&
                                  (o.insertBefore(i, t.elm, o.nextSibling(r)),
                                  u(i, [e], 0, 0))),
                        a = 0;
                    a < l.length;
                    ++a
                )
                    l[a].data.hook.insert(l[a]);
                for (a = 0; a < n.post.length; ++a) n.post[a]();
                return t;
            };
        })([
            Ma,
            Oa,
            {
                create: La,
                update: La,
                destroy: function (e) {
                    var t,
                        a,
                        r = e.elm,
                        n = e.data.style;
                    if (n && (t = n.destroy)) for (a in t) r.style[a] = t[a];
                },
                remove: function (e, t) {
                    var a = e.data.style;
                    if (a && a.remove) {
                        var r,
                            n = e.elm,
                            o = 0,
                            i = a.remove,
                            s = 0,
                            l = [];
                        for (r in i) l.push(r), (n.style[r] = i[r]);
                        for (
                            var c =
                                getComputedStyle(n)[
                                    "transition-property"
                                ].split(", ");
                            o < c.length;
                            ++o
                        )
                            -1 !== l.indexOf(c[o]) && s++;
                        n.addEventListener("transitionend", function (e) {
                            e.target === n && --s, 0 === s && t();
                        });
                    } else t();
                },
            },
            { create: Ra, update: Ra, destroy: Ra },
        ]),
        Da = (function () {
            function e(e, t, a, n) {
                var o = this;
                void 0 === a && (a = {});
                var i = void 0 === n ? {} : n,
                    s = i.el,
                    l = i.context,
                    c = i.children,
                    p = r();
                Ke(this, {
                    f7: e,
                    props: a || {},
                    context: l || {},
                    id: t.id || Ae(),
                    children: c || [],
                    theme: {
                        ios: "ios" === e.theme,
                        md: "md" === e.theme,
                        aurora: "aurora" === e.theme,
                    },
                    style: t.style,
                    __updateQueue: [],
                    __eventHandlers: [],
                    __onceEventHandlers: [],
                    __onBeforeMount: [],
                    __onMounted: [],
                    __onBeforeUpdate: [],
                    __onUpdated: [],
                    __onBeforeUnmount: [],
                    __onUnmounted: [],
                });
                return new Promise(function (e, a) {
                    (function (e) {
                        return new Promise(function (t, a) {
                            "function" == typeof e
                                ? t(e)
                                : e instanceof Promise
                                ? e
                                      .then(function (e) {
                                          t(e);
                                      })
                                      .catch(function (e) {
                                          a(e);
                                      })
                                : a(
                                      new Error(
                                          'Framework7: Component render function is not a "function" type. Didn\'t you forget to "return $render"?'
                                      )
                                  );
                        });
                    })(t(o.props, o.getComponentContext(!0)))
                        .then(function (t) {
                            o.renderFunction = t;
                            var a = o.render();
                            if (s)
                                return (
                                    (o.vnode = ya(a, o, !0)),
                                    o.style &&
                                        ((o.styleEl = p.createElement("style")),
                                        (o.styleEl.innerHTML = o.style)),
                                    (o.el = s),
                                    Aa(o.el, o.vnode),
                                    (o.el = o.vnode.elm),
                                    (o.$el = Ee(o.el)),
                                    o.attachEvents(),
                                    (o.el.f7Component = o),
                                    o.mount(),
                                    void e(o)
                                );
                            a &&
                                ((o.vnode = ya(a, o, !0)),
                                (o.el = p.createElement(o.vnode.sel || "div")),
                                Aa(o.el, o.vnode),
                                (o.$el = Ee(o.el))),
                                o.style &&
                                    ((o.styleEl = p.createElement("style")),
                                    (o.styleEl.innerHTML = o.style)),
                                o.attachEvents(),
                                o.el && (o.el.f7Component = o),
                                e(o);
                        })
                        .catch(function (e) {
                            a(e);
                        });
                });
            }
            var t = e.prototype;
            return (
                (t.on = function (e, t) {
                    this.__eventHandlers &&
                        this.__eventHandlers.push({ eventName: e, handler: t });
                }),
                (t.once = function (e, t) {
                    this.__eventHandlers &&
                        this.__onceEventHandlers.push({
                            eventName: e,
                            handler: t,
                        });
                }),
                (t.getComponentRef = function () {
                    var e = this;
                    return function (t) {
                        var a = t,
                            r = {};
                        return (
                            Object.defineProperty(r, "value", {
                                get: function () {
                                    return a;
                                },
                                set: function (t) {
                                    (a = t), e.update();
                                },
                            }),
                            r
                        );
                    };
                }),
                (t.getComponentStore = function () {
                    var e = this,
                        t = this.f7.store,
                        a = t.state,
                        r = t._gettersPlain,
                        n = { state: a, dispatch: t.dispatch };
                    return (
                        (n.getters = new Proxy(r, {
                            get: function (t, a) {
                                var r = t[a];
                                return (
                                    r.onUpdated(function (t) {
                                        (r.value = t), e.update();
                                    }),
                                    r
                                );
                            },
                        })),
                        n
                    );
                }),
                (t.getComponentContext = function (e) {
                    var t = this,
                        a = {
                            $f7route: this.context.f7route,
                            $f7router: this.context.f7router,
                            $h: ta,
                            $: Ee,
                            $id: this.id,
                            $f7: this.f7,
                            $f7ready: this.f7ready.bind(this),
                            $theme: this.theme,
                            $tick: this.tick.bind(this),
                            $update: this.update.bind(this),
                            $emit: this.emit.bind(this),
                            $store: this.getComponentStore(),
                            $ref: this.getComponentRef(),
                            $el: {},
                        };
                    return (
                        Object.defineProperty(a.$el, "value", {
                            get: function () {
                                return t.$el;
                            },
                        }),
                        e &&
                            Object.assign(a, {
                                $on: this.on.bind(this),
                                $once: this.once.bind(this),
                                $onBeforeMount: function (e) {
                                    return t.__onBeforeMount.push(e);
                                },
                                $onMounted: function (e) {
                                    return t.__onMounted.push(e);
                                },
                                $onBeforeUpdate: function (e) {
                                    return t.__onBeforeUpdate.push(e);
                                },
                                $onUpdated: function (e) {
                                    return t.__onUpdated.push(e);
                                },
                                $onBeforeUnmount: function (e) {
                                    return t.__onBeforeUnmount.push(e);
                                },
                                $onUnmounted: function (e) {
                                    return t.__onUnmounted.push(e);
                                },
                            }),
                        a
                    );
                }),
                (t.render = function () {
                    return this.renderFunction(this.getComponentContext());
                }),
                (t.emit = function (e, t) {
                    this.el && this.$el.trigger(e, t);
                }),
                (t.attachEvents = function () {
                    var e = this.$el;
                    this.__eventHandlers &&
                        (this.__eventHandlers.forEach(function (t) {
                            var a = t.eventName,
                                r = t.handler;
                            e.on(Ve(a), r);
                        }),
                        this.__onceEventHandlers.forEach(function (t) {
                            var a = t.eventName,
                                r = t.handler;
                            e.once(Ve(a), r);
                        }));
                }),
                (t.detachEvents = function () {
                    var e = this.$el;
                    this.__eventHandlers &&
                        (this.__eventHandlers.forEach(function (t) {
                            var a = t.eventName,
                                r = t.handler;
                            e.on(Ve(a), r);
                        }),
                        this.__onceEventHandlers.forEach(function (t) {
                            var a = t.eventName,
                                r = t.handler;
                            e.once(Ve(a), r);
                        }));
                }),
                (t.startUpdateQueue = function () {
                    var e = this,
                        t = o();
                    if (!this.__requestAnimationFrameId) {
                        this.__requestAnimationFrameId =
                            t.requestAnimationFrame(function () {
                                e.__updateIsPending &&
                                    (function () {
                                        e.hook("onBeforeUpdate");
                                        var t = e.render();
                                        if (t) {
                                            var a = ya(t, e, !1);
                                            e.vnode = Aa(e.vnode, a);
                                        }
                                    })();
                                var a = [].concat(e.__updateQueue);
                                (e.__updateQueue = []),
                                    (e.__updateIsPending = !1),
                                    t.cancelAnimationFrame(
                                        e.__requestAnimationFrameId
                                    ),
                                    delete e.__requestAnimationFrameId,
                                    delete e.__updateIsPending,
                                    a.forEach(function (e) {
                                        return e();
                                    }),
                                    (a = []);
                            });
                    }
                }),
                (t.tick = function (e) {
                    var t = this;
                    return new Promise(function (a) {
                        t.__updateQueue.push(function () {
                            a(), e && e();
                        }),
                            t.startUpdateQueue();
                    });
                }),
                (t.update = function (e) {
                    var t = this;
                    return this.__destroyed
                        ? new Promise(function () {})
                        : new Promise(function (a) {
                              (t.__updateIsPending = !0),
                                  t.__updateQueue.push(function () {
                                      a(), e && e();
                                  }),
                                  t.startUpdateQueue();
                          });
                }),
                (t.setState = function (e) {
                    return this.update(e);
                }),
                (t.f7ready = function (e) {
                    var t = this;
                    this.f7.initialized
                        ? e(this.f7)
                        : this.f7.once("init", function () {
                              e(t.f7);
                          });
                }),
                (t.mount = function (e) {
                    this.hook("onBeforeMount", this.$el),
                        this.styleEl && Ee("head").append(this.styleEl),
                        e && e(this.el),
                        this.hook("onMounted", this.$el);
                }),
                (t.destroy = function () {
                    if (!this.__destroyed) {
                        var e = o();
                        this.hook("onBeforeUnmount"),
                            this.styleEl && Ee(this.styleEl).remove(),
                            this.detachEvents(),
                            this.hook("onUnmounted"),
                            this.el &&
                                this.el.f7Component &&
                                ((this.el.f7Component = null),
                                delete this.el.f7Component),
                            this.vnode &&
                                (this.vnode = Aa(this.vnode, {
                                    sel: this.vnode.sel,
                                    data: {},
                                })),
                            e.cancelAnimationFrame(
                                this.__requestAnimationFrameId
                            ),
                            (this.__updateQueue = []),
                            (this.__eventHandlers = []),
                            (this.__onceEventHandlers = []),
                            (this.__onBeforeMount = []),
                            (this.__onMounted = []),
                            (this.__onBeforeUpdate = []),
                            (this.__onUpdated = []),
                            (this.__onBeforeUnmount = []),
                            (this.__onUnmounted = []),
                            Fe(this),
                            (this.__destroyed = !0);
                    }
                }),
                (t.hook = function (e) {
                    for (
                        var t = arguments.length,
                            a = new Array(t > 1 ? t - 1 : 0),
                            r = 1;
                        r < t;
                        r++
                    )
                        a[r - 1] = arguments[r];
                    this.__destroyed ||
                        this["__" + e].forEach(function (e) {
                            e.apply(void 0, a);
                        });
                }),
                e
            );
        })();
    function Ha(e, t) {
        sa[e] = t;
    }
    function Na(e) {
        delete sa[e];
    }
    var Va = {
            name: "component",
            static: {
                Component: Da,
                registerComponent: Ha,
                unregisterComponent: Na,
            },
            create: function () {
                var e = this;
                e.component = {
                    registerComponent: Ha,
                    unregisterComponent: Na,
                    parse: function (e) {
                        return (function (e) {
                            var t,
                                a = o(),
                                n = r(),
                                i = Ae(),
                                s = "f7_component_create_callback_" + i;
                            e.match(/<template([ ]?)([a-z0-9-]*)>/) &&
                                (t = e
                                    .split(/<template[ ]?[a-z0-9-]*>/)
                                    .filter(function (e, t) {
                                        return t > 0;
                                    })
                                    .join("<template>")
                                    .split("</template>")
                                    .filter(function (e, t, a) {
                                        return t < a.length - 1;
                                    })
                                    .join("</template>")
                                    .replace(
                                        /{{#raw}}([ \n]*)<template/g,
                                        "{{#raw}}<template"
                                    )
                                    .replace(
                                        /\/template>([ \n]*){{\/raw}}/g,
                                        "/template>{{/raw}}"
                                    )
                                    .replace(
                                        /([ \n])<template/g,
                                        "$1{{#raw}}<template"
                                    )
                                    .replace(
                                        /\/template>([ \n])/g,
                                        "/template>{{/raw}}$1"
                                    ));
                            var l,
                                c = null;
                            if (
                                (e.indexOf("<style>") >= 0 &&
                                    (c = e
                                        .split("<style>")[1]
                                        .split("</style>")[0]),
                                e.indexOf("<style scoped>") >= 0 &&
                                    (c = e
                                        .split("<style scoped>")[1]
                                        .split("</style>")[0]),
                                e.indexOf("<script>") >= 0)
                            ) {
                                var p = e.split("<script>");
                                l = p[p.length - 1]
                                    .split("</script>")[0]
                                    .trim();
                            } else l = "return () => {return $render}";
                            (l && l.trim()) ||
                                (l = "return () => {return $render}"),
                                t &&
                                    (l = l
                                        .replace(
                                            "$render",
                                            "function ($$ctx) {\n          var $ = $$ctx.$$;\n          var $h = $$ctx.$h;\n          var $root = $$ctx.$root;\n          var $f7 = $$ctx.$f7;\n          var $f7route = $$ctx.$f7route;\n          var $f7router = $$ctx.$f7router;\n          var $theme = $$ctx.$theme;\n          var $update = $$ctx.$update;\n          var $store = $$ctx.$store;\n          var $ref = $$ctx.$ref;\n\n          return $h`" +
                                                t +
                                                "`\n        }\n        "
                                        )
                                        .replace(/export default/g, "return")),
                                (l =
                                    "window." +
                                    s +
                                    " = function () {" +
                                    l +
                                    "}");
                            var d = n.createElement("script");
                            (d.innerHTML = l), Ee("head").append(d);
                            var u = a[s]();
                            return (
                                Ee(d).remove(),
                                (a[s] = null),
                                delete a[s],
                                c && (u.style = c),
                                (u.id = i),
                                u
                            );
                        })(e);
                    },
                    create: function (t, a, r) {
                        var n = r.root,
                            o = r.el,
                            i = r.context,
                            s = r.children;
                        return new Da(e, t, a, {
                            root: n,
                            el: o,
                            context: i,
                            children: s,
                        });
                    },
                };
            },
        },
        Fa = {
            name: "history",
            static: { history: Rt },
            on: {
                init: function () {
                    Rt.init(this);
                },
            },
        },
        qa = {
            registrations: [],
            register: function (e, t) {
                var a = this;
                return "serviceWorker" in o().navigator &&
                    a.serviceWorker.container
                    ? new Promise(function (r, n) {
                          a.serviceWorker.container
                              .register(e, t ? { scope: t } : {})
                              .then(function (e) {
                                  qa.registrations.push(e),
                                      a.emit("serviceWorkerRegisterSuccess", e),
                                      r(e);
                              })
                              .catch(function (e) {
                                  a.emit("serviceWorkerRegisterError", e), n(e);
                              });
                      })
                    : new Promise(function (e, t) {
                          t(new Error("Service worker is not supported"));
                      });
            },
            unregister: function (e) {
                var t,
                    a = this;
                return "serviceWorker" in o().navigator &&
                    a.serviceWorker.container
                    ? ((t = e
                          ? Array.isArray(e)
                              ? e
                              : [e]
                          : qa.registrations),
                      Promise.all(
                          t.map(function (e) {
                              return new Promise(function (t, r) {
                                  e.unregister()
                                      .then(function () {
                                          qa.registrations.indexOf(e) >= 0 &&
                                              qa.registrations.splice(
                                                  qa.registrations.indexOf(e),
                                                  1
                                              ),
                                              a.emit(
                                                  "serviceWorkerUnregisterSuccess",
                                                  e
                                              ),
                                              t();
                                      })
                                      .catch(function (t) {
                                          a.emit(
                                              "serviceWorkerUnregisterError",
                                              e,
                                              t
                                          ),
                                              r(t);
                                      });
                              });
                          })
                      ))
                    : new Promise(function (e, t) {
                          t(new Error("Service worker is not supported"));
                      });
            },
        },
        ja = {
            name: "sw",
            params: { serviceWorker: { path: void 0, scope: void 0 } },
            create: function () {
                var e = this,
                    t = o();
                Qe(e, {
                    serviceWorker: {
                        container:
                            "serviceWorker" in t.navigator
                                ? t.navigator.serviceWorker
                                : void 0,
                        registrations: qa.registrations,
                        register: qa.register.bind(e),
                        unregister: qa.unregister.bind(e),
                    },
                });
            },
            on: {
                init: function () {
                    var e = o();
                    if ("serviceWorker" in e.navigator) {
                        var t = this;
                        if (
                            !(
                                t.device.cordova ||
                                (e.Capacitor && e.Capacitor.isNative)
                            ) &&
                            t.serviceWorker.container
                        ) {
                            var a = t.params.serviceWorker.path,
                                r = t.params.serviceWorker.scope;
                            if (a && (!Array.isArray(a) || a.length))
                                (Array.isArray(a) ? a : [a]).forEach(function (
                                    e
                                ) {
                                    t.serviceWorker.register(e, r);
                                });
                        }
                    }
                },
            },
        };
    function _a(e) {
        void 0 === e && (e = {});
        var t = { __store: !0 },
            a = Se({}, e.state || {}),
            r = Se({}, e.actions || {}),
            n = Se({}, e.getters || {}),
            o = Qe({}, a),
            i = [],
            s = {},
            l = {};
        Object.keys(n).forEach(function (e) {
            (s[e] = []), (l[e] = []);
        });
        var c = function (e) {
                return n[e]({ state: t.state });
            },
            p = function (e, t) {
                l[e] || (l[e] = []), l[e].push(t);
            };
        t.__removeCallback = function (e) {
            !(function (e) {
                Object.keys(l).forEach(function (t) {
                    var a = l[t];
                    a.indexOf(e) >= 0 && a.splice(a.indexOf(e), 1);
                });
            })(e);
        };
        var d = function (e, t) {
            if ((void 0 === t && (t = !0), "constructor" !== e)) {
                i = [];
                var a = c(e);
                !(function (e, t) {
                    s[e] || (s[e] = []),
                        t.forEach(function (t) {
                            s[e].indexOf(t) < 0 && s[e].push(t);
                        });
                })(e, i);
                var r = {
                    value: a,
                    onUpdated: function (t) {
                        p(e, t);
                    },
                };
                if (!t) return r;
                var n = function (e) {
                    r.value = e;
                };
                return (r.__callback = n), p(e, n), r;
            }
        };
        return (
            (t.state = new Proxy(o, {
                set: function (e, t, a) {
                    var r;
                    return (
                        (e[t] = a),
                        (r = t),
                        Object.keys(s)
                            .filter(function (e) {
                                return s[e].indexOf(r) >= 0;
                            })
                            .forEach(function (e) {
                                l[e] &&
                                    l[e].length &&
                                    l[e].forEach(function (t) {
                                        t(c(e));
                                    });
                            }),
                        !0
                    );
                },
                get: function (e, t) {
                    return i.push(t), e[t];
                },
            })),
            (t.getters = new Proxy(n, {
                set: function () {
                    return !1;
                },
                get: function (e, t) {
                    if (e[t]) return d(t, !0);
                },
            })),
            (t._gettersPlain = new Proxy(n, {
                set: function () {
                    return !1;
                },
                get: function (e, t) {
                    if (e[t]) return d(t, !1);
                },
            })),
            (t.dispatch = function (e, a) {
                return new Promise(function (n, o) {
                    if (!r[e])
                        throw (
                            (o(),
                            new Error(
                                'Framework7: Store action "' +
                                    e +
                                    '" is not found'
                            ))
                        );
                    n(r[e]({ state: t.state, dispatch: t.dispatch }, a));
                });
            }),
            t
        );
    }
    var Ya = {
            name: "store",
            static: { createStore: _a },
            proto: { createStore: _a },
        },
        Wa = function () {
            var e = o();
            return (
                e.Capacitor &&
                e.Capacitor.isNative &&
                e.Capacitor.Plugins &&
                e.Capacitor.Plugins.StatusBar
            );
        },
        Xa = {
            hide: function () {
                var e = o();
                pt().cordova && e.StatusBar && e.StatusBar.hide(),
                    Wa() && e.Capacitor.Plugins.StatusBar.hide();
            },
            show: function () {
                var e = o();
                pt().cordova && e.StatusBar && e.StatusBar.show(),
                    Wa() && e.Capacitor.Plugins.StatusBar.show();
            },
            onClick: function () {
                var e;
                (e =
                    Ee(".popup.modal-in").length > 0
                        ? Ee(".popup.modal-in")
                              .find(
                                  ".page:not(.page-previous):not(.page-next):not(.cached)"
                              )
                              .find(".page-content")
                        : Ee(".panel.panel-in").length > 0
                        ? Ee(".panel.panel-in")
                              .find(
                                  ".page:not(.page-previous):not(.page-next):not(.cached)"
                              )
                              .find(".page-content")
                        : Ee(".views > .view.tab-active").length > 0
                        ? Ee(".views > .view.tab-active")
                              .find(
                                  ".page:not(.page-previous):not(.page-next):not(.cached)"
                              )
                              .find(".page-content")
                        : Ee(".views").length > 0
                        ? Ee(".views")
                              .find(
                                  ".page:not(.page-previous):not(.page-next):not(.cached)"
                              )
                              .find(".page-content")
                        : this.$el
                              .children(".view")
                              .find(
                                  ".page:not(.page-previous):not(.page-next):not(.cached)"
                              )
                              .find(".page-content")) &&
                    e.length > 0 &&
                    (e.hasClass("tab") &&
                        (e = e
                            .parent(".tabs")
                            .children(".page-content.tab-active")),
                    e.length > 0 && e.scrollTop(0, 300));
            },
            setTextColor: function (e) {
                var t = o();
                pt().cordova &&
                    t.StatusBar &&
                    ("white" === e
                        ? t.StatusBar.styleLightContent()
                        : t.StatusBar.styleDefault()),
                    Wa() &&
                        ("white" === e
                            ? t.Capacitor.Plugins.StatusBar.setStyle({
                                  style: "DARK",
                              })
                            : t.Capacitor.Plugins.StatusBar.setStyle({
                                  style: "LIGHT",
                              }));
            },
            setBackgroundColor: function (e) {
                var t = o();
                pt().cordova &&
                    t.StatusBar &&
                    t.StatusBar.backgroundColorByHexString(e),
                    Wa() &&
                        t.Capacitor.Plugins.StatusBar.setBackgroundColor({
                            color: e,
                        });
            },
            isVisible: function () {
                var e = o(),
                    t = pt();
                return new Promise(function (a) {
                    t.cordova && e.StatusBar && a(e.StatusBar.isVisible),
                        Wa() &&
                            e.Capacitor.Plugins.StatusBar.getInfo().then(
                                function (e) {
                                    a(e.visible);
                                }
                            ),
                        a(!1);
                });
            },
            overlaysWebView: function (e) {
                void 0 === e && (e = !0);
                var t = o();
                pt().cordova && t.StatusBar && t.StatusBar.overlaysWebView(e),
                    Wa() &&
                        t.Capacitor.Plugins.StatusBar.setOverlaysWebView({
                            overlay: e,
                        });
            },
            init: function () {
                var e = o(),
                    t = pt(),
                    a = this.params.statusbar;
                if (a.enabled) {
                    var r = t.cordova && e.StatusBar,
                        n = Wa();
                    (r || n) &&
                        (a.scrollTopOnClick &&
                            Ee(e).on("statusTap", Xa.onClick.bind(this)),
                        t.ios &&
                            (a.iosOverlaysWebView
                                ? Xa.overlaysWebView(!0)
                                : Xa.overlaysWebView(!1),
                            "white" === a.iosTextColor
                                ? Xa.setTextColor("white")
                                : Xa.setTextColor("black")),
                        t.android &&
                            (a.androidOverlaysWebView
                                ? Xa.overlaysWebView(!0)
                                : Xa.overlaysWebView(!1),
                            "white" === a.androidTextColor
                                ? Xa.setTextColor("white")
                                : Xa.setTextColor("black"))),
                        a.iosBackgroundColor &&
                            t.ios &&
                            Xa.setBackgroundColor(a.iosBackgroundColor),
                        a.androidBackgroundColor &&
                            t.android &&
                            Xa.setBackgroundColor(a.androidBackgroundColor);
                }
            },
        },
        Ga = {
            name: "statusbar",
            params: {
                statusbar: {
                    enabled: !0,
                    scrollTopOnClick: !0,
                    iosOverlaysWebView: !0,
                    iosTextColor: "black",
                    iosBackgroundColor: null,
                    androidOverlaysWebView: !1,
                    androidTextColor: "black",
                    androidBackgroundColor: null,
                },
            },
            create: function () {
                nt(this, { statusbar: Xa });
            },
            on: {
                init: function () {
                    Xa.init.call(this);
                },
            },
        };
    var Ua = {
            name: "view",
            params: {
                view: {
                    init: !0,
                    name: void 0,
                    main: !1,
                    router: !0,
                    linksView: null,
                    stackPages: !1,
                    xhrCache: !0,
                    xhrCacheIgnore: [],
                    xhrCacheIgnoreGetParameters: !1,
                    xhrCacheDuration: 6e5,
                    componentCache: !0,
                    preloadPreviousPage: !0,
                    allowDuplicateUrls: !1,
                    reloadPages: !1,
                    reloadDetail: !1,
                    masterDetailBreakpoint: 0,
                    masterDetailResizable: !1,
                    removeElements: !0,
                    removeElementsWithTimeout: !1,
                    removeElementsTimeout: 0,
                    restoreScrollTopOnBack: !0,
                    unloadTabContent: !0,
                    passRouteQueryToRequest: !0,
                    passRouteParamsToRequest: !1,
                    loadInitialPage: !0,
                    iosSwipeBack: !0,
                    iosSwipeBackAnimateShadow: !0,
                    iosSwipeBackAnimateOpacity: !0,
                    iosSwipeBackActiveArea: 30,
                    iosSwipeBackThreshold: 0,
                    mdSwipeBack: !1,
                    mdSwipeBackAnimateShadow: !0,
                    mdSwipeBackAnimateOpacity: !1,
                    mdSwipeBackActiveArea: 30,
                    mdSwipeBackThreshold: 0,
                    auroraSwipeBack: !1,
                    auroraSwipeBackAnimateShadow: !1,
                    auroraSwipeBackAnimateOpacity: !0,
                    auroraSwipeBackActiveArea: 30,
                    auroraSwipeBackThreshold: 0,
                    browserHistory: !1,
                    browserHistoryRoot: void 0,
                    browserHistoryAnimate: !0,
                    browserHistoryAnimateOnLoad: !1,
                    browserHistorySeparator: "#!",
                    browserHistoryOnLoad: !0,
                    browserHistoryInitialMatch: !1,
                    browserHistoryStoreHistory: !0,
                    animate: !0,
                    iosDynamicNavbar: !0,
                    iosAnimateNavbarBackIcon: !0,
                    iosPageLoadDelay: 0,
                    mdPageLoadDelay: 0,
                    auroraPageLoadDelay: 0,
                    routesBeforeEnter: null,
                    routesBeforeLeave: null,
                },
            },
            static: { View: Ut },
            create: function () {
                var e = this;
                Qe(e, {
                    views: Qe([], {
                        create: function (t, a) {
                            return new Ut(e, t, a);
                        },
                        get: function (e) {
                            var t = Ee(e);
                            if (t.length && t[0].f7View) return t[0].f7View;
                        },
                    }),
                }),
                    Object.defineProperty(e.views, "current", {
                        enumerable: !0,
                        configurable: !0,
                        get: function () {
                            return (function (e) {
                                var t = Ee(".popover.modal-in .view"),
                                    a = Ee(".popup.modal-in .view"),
                                    r = Ee(".panel.panel-in .view"),
                                    n = Ee(".views");
                                0 === n.length && (n = e.$el);
                                var o = n.children(".view");
                                if (
                                    (0 === o.length &&
                                        (o = n
                                            .children(".tabs")
                                            .children(".view")),
                                    o.length > 1 &&
                                        o.hasClass("tab") &&
                                        0 ===
                                            (o = n.children(".view.tab-active"))
                                                .length &&
                                        (o = n
                                            .children(".tabs")
                                            .children(".view.tab-active")),
                                    t.length > 0 && t[0].f7View)
                                )
                                    return t[0].f7View;
                                if (a.length > 0 && a[0].f7View)
                                    return a[0].f7View;
                                if (r.length > 0 && r[0].f7View)
                                    return r[0].f7View;
                                if (o.length > 0) {
                                    if (1 === o.length && o[0].f7View)
                                        return o[0].f7View;
                                    if (o.length > 1) return e.views.main;
                                }
                            })(e);
                        },
                    }),
                    (e.view = e.views);
            },
            on: {
                init: function () {
                    var e = this;
                    Ee(".view-init").each(function (t) {
                        if (!t.f7View) {
                            var a = Ee(t).dataset();
                            e.views.create(t, a);
                        }
                    });
                },
                "modalOpen panelOpen": function (e) {
                    var t = this;
                    e.$el.find(".view-init").each(function (e) {
                        if (!e.f7View) {
                            var a = Ee(e).dataset();
                            t.views.create(e, a);
                        }
                    });
                },
                "modalBeforeDestroy panelBeforeDestroy": function (e) {
                    e &&
                        e.$el &&
                        e.$el.find(".view-init").each(function (e) {
                            var t = e.f7View;
                            t && t.destroy();
                        });
                },
            },
            vnode: {
                "view-init": {
                    insert: function (e) {
                        var t = e.elm;
                        if (!t.f7View) {
                            var a = Ee(t).dataset();
                            this.views.create(t, a);
                        }
                    },
                    destroy: function (e) {
                        var t = e.elm.f7View;
                        t && t.destroy();
                    },
                },
            },
        },
        Ka = {
            size: function (e) {
                var t = this,
                    a = Ee(e);
                if (a.hasClass("navbars"))
                    a = a.children(".navbar").each(function (e) {
                        t.navbar.size(e);
                    });
                else {
                    var r = a.children(".navbar-inner");
                    if (r.length) {
                        var n =
                                r.hasClass("navbar-inner-centered-title") ||
                                t.params.navbar[t.theme + "CenterTitle"],
                            o =
                                "ios" === t.theme &&
                                !t.params.navbar[t.theme + "CenterTitle"];
                        if (
                            (n || o) &&
                            !(
                                a.hasClass("stacked") ||
                                a.parents(".stacked").length > 0 ||
                                a.parents(".tab:not(.tab-active)").length > 0 ||
                                a.parents(".popup:not(.modal-in)").length > 0
                            )
                        ) {
                            "ios" !== t.theme &&
                                t.params.navbar[t.theme + "CenterTitle"] &&
                                r.addClass("navbar-inner-centered-title"),
                                "ios" !== t.theme ||
                                    t.params.navbar.iosCenterTitle ||
                                    r.addClass("navbar-inner-left-title");
                            var i,
                                s,
                                l,
                                c,
                                p = a.parents(".view").eq(0),
                                d = t.rtl
                                    ? r.children(".right")
                                    : r.children(".left"),
                                u = t.rtl
                                    ? r.children(".left")
                                    : r.children(".right"),
                                h = r.children(".title"),
                                f = r.children(".subnavbar"),
                                v = 0 === d.length,
                                m = 0 === u.length,
                                g = v ? 0 : d.outerWidth(!0),
                                b = m ? 0 : u.outerWidth(!0),
                                y = h.outerWidth(!0),
                                w = r.styles(),
                                C =
                                    r[0].offsetWidth -
                                    parseInt(w.paddingLeft, 10) -
                                    parseInt(w.paddingRight, 10),
                                E = a.hasClass("navbar-previous"),
                                k = r.hasClass("sliding");
                            p.length > 0 &&
                                p[0].f7View &&
                                (s =
                                    (i = p[0].f7View.router) &&
                                    i.dynamicNavbar),
                                m && (l = C - y),
                                v && (l = 0),
                                v || m || (l = (C - b - y + g) / 2);
                            var x = (C - y) / 2;
                            C - g - b > y
                                ? (x < g && (x = g),
                                  x + y > C - b && (x = C - b - y),
                                  (c = x - l))
                                : (c = 0);
                            var $ = t.rtl ? -1 : 1;
                            if (s && "ios" === t.theme) {
                                if (
                                    h.hasClass("sliding") ||
                                    (h.length > 0 && k)
                                ) {
                                    var T = -(l + c) * $,
                                        S = (C - l - c - y) * $;
                                    if (
                                        E &&
                                        i &&
                                        i.params.iosAnimateNavbarBackIcon
                                    ) {
                                        var M = a
                                            .parent()
                                            .find(".navbar-current")
                                            .children(".left.sliding")
                                            .find(".back .icon ~ span");
                                        M.length > 0 && (T += M[0].offsetLeft);
                                    }
                                    (h[0].f7NavbarLeftOffset = T),
                                        (h[0].f7NavbarRightOffset = S);
                                }
                                if (!v && (d.hasClass("sliding") || k))
                                    if (t.rtl)
                                        (d[0].f7NavbarLeftOffset =
                                            (-(C - d[0].offsetWidth) / 2) * $),
                                            (d[0].f7NavbarRightOffset = g * $);
                                    else if (
                                        ((d[0].f7NavbarLeftOffset = -g),
                                        (d[0].f7NavbarRightOffset =
                                            (C - d[0].offsetWidth) / 2),
                                        i &&
                                            i.params.iosAnimateNavbarBackIcon &&
                                            d.find(".back .icon").length > 0 &&
                                            d.find(".back .icon ~ span").length)
                                    ) {
                                        var P = d[0].f7NavbarLeftOffset,
                                            O = d[0].f7NavbarRightOffset;
                                        (d[0].f7NavbarLeftOffset = 0),
                                            (d[0].f7NavbarRightOffset = 0),
                                            (d.find(
                                                ".back .icon ~ span"
                                            )[0].f7NavbarLeftOffset = P),
                                            (d.find(
                                                ".back .icon ~ span"
                                            )[0].f7NavbarRightOffset =
                                                O -
                                                d.find(".back .icon")[0]
                                                    .offsetWidth);
                                    }
                                m ||
                                    (!u.hasClass("sliding") && !k) ||
                                    (t.rtl
                                        ? ((u[0].f7NavbarLeftOffset = -b * $),
                                          (u[0].f7NavbarRightOffset =
                                              ((C - u[0].offsetWidth) / 2) * $))
                                        : ((u[0].f7NavbarLeftOffset =
                                              -(C - u[0].offsetWidth) / 2),
                                          (u[0].f7NavbarRightOffset = b))),
                                    f.length &&
                                        (f.hasClass("sliding") || k) &&
                                        ((f[0].f7NavbarLeftOffset = t.rtl
                                            ? f[0].offsetWidth
                                            : -f[0].offsetWidth),
                                        (f[0].f7NavbarRightOffset =
                                            -f[0].f7NavbarLeftOffset));
                            }
                            if (n) {
                                var I = c;
                                t.rtl && v && m && h.length > 0 && (I = -I),
                                    h.css({ left: I + "px" });
                            }
                        }
                    }
                }
            },
            hide: function (e, t, a, r) {
                void 0 === t && (t = !0),
                    void 0 === a && (a = !1),
                    void 0 === r && (r = !1);
                var n = this,
                    o = Ee(e),
                    i =
                        o.hasClass("navbar") &&
                        o.parent(".navbars").length &&
                        !r;
                if (
                    (i && (o = o.parents(".navbars")),
                    o.length && !o.hasClass("navbar-hidden"))
                ) {
                    var s =
                        "navbar-hidden" + (t ? " navbar-transitioning" : "");
                    (i
                        ? o.find(".navbar-current .title-large").length
                        : o.find(".title-large").length) &&
                        (s += " navbar-large-hidden"),
                        a && (s += " navbar-hidden-statusbar"),
                        o.transitionEnd(function () {
                            o.removeClass("navbar-transitioning");
                        }),
                        o.addClass(s),
                        i
                            ? o.children(".navbar").each(function (e) {
                                  Ee(e).trigger("navbar:hide"),
                                      n.emit("navbarHide", e);
                              })
                            : (o.trigger("navbar:hide"),
                              n.emit("navbarHide", o[0]));
                }
            },
            show: function (e, t, a) {
                void 0 === e && (e = ".navbar-hidden"),
                    void 0 === t && (t = !0),
                    void 0 === a && (a = !1);
                var r = this,
                    n = Ee(e),
                    o =
                        n.hasClass("navbar") &&
                        n.parent(".navbars").length &&
                        !a;
                o && (n = n.parents(".navbars")),
                    n.length &&
                        n.hasClass("navbar-hidden") &&
                        (t &&
                            (n.addClass("navbar-transitioning"),
                            n.transitionEnd(function () {
                                n.removeClass("navbar-transitioning");
                            })),
                        n.removeClass(
                            "navbar-hidden navbar-large-hidden navbar-hidden-statusbar"
                        ),
                        o
                            ? n.children(".navbar").each(function (e) {
                                  Ee(e).trigger("navbar:show"),
                                      r.emit("navbarShow", e);
                              })
                            : (n.trigger("navbar:show"),
                              r.emit("navbarShow", n[0])));
            },
            getElByPage: function (e) {
                var t, a, r;
                if (
                    (e.$navbarEl || e.$el
                        ? ((r = e), (t = e.$el))
                        : (t = Ee(e)).length > 0 && (r = t[0].f7Page),
                    r && r.$navbarEl && r.$navbarEl.length > 0
                        ? (a = r.$navbarEl)
                        : t && (a = t.children(".navbar")),
                    a && (!a || 0 !== a.length))
                )
                    return a[0];
            },
            getPageByEl: function (e) {
                var t,
                    a = Ee(e);
                return a.parents(".page").length
                    ? a.parents(".page")[0]
                    : (a
                          .parents(".view")
                          .find(".page")
                          .each(function (e) {
                              e &&
                                  e.f7Page &&
                                  e.f7Page.navbarEl &&
                                  a[0] === e.f7Page.navbarEl &&
                                  (t = e);
                          }),
                      t);
            },
            collapseLargeTitle: function (e) {
                var t = this,
                    a = Ee(e);
                if (
                    !(
                        a.hasClass("navbars") &&
                        ((a = a.find(".navbar")).length > 1 &&
                            (a = Ee(e).find(".navbar-large.navbar-current")),
                        a.length > 1 || !a.length)
                    )
                ) {
                    var r = Ee(t.navbar.getPageByEl(a));
                    a.addClass("navbar-large-collapsed"),
                        r
                            .eq(0)
                            .addClass("page-with-navbar-large-collapsed")
                            .trigger("page:navbarlargecollapsed"),
                        t.emit("pageNavbarLargeCollapsed", r[0]),
                        a.trigger("navbar:collapse"),
                        t.emit("navbarCollapse", a[0]);
                }
            },
            expandLargeTitle: function (e) {
                var t = this,
                    a = Ee(e);
                if (
                    !(
                        a.hasClass("navbars") &&
                        ((a = a.find(".navbar-large")).length > 1 &&
                            (a = Ee(e).find(".navbar-large.navbar-current")),
                        a.length > 1 || !a.length)
                    )
                ) {
                    var r = Ee(t.navbar.getPageByEl(a));
                    a.removeClass("navbar-large-collapsed"),
                        r
                            .eq(0)
                            .removeClass("page-with-navbar-large-collapsed")
                            .trigger("page:navbarlargeexpanded"),
                        t.emit("pageNavbarLargeExpanded", r[0]),
                        a.trigger("navbar:expand"),
                        t.emit("navbarExpand", a[0]);
                }
            },
            toggleLargeTitle: function (e) {
                var t = Ee(e);
                (t.hasClass("navbars") &&
                    ((t = t.find(".navbar-large")).length > 1 &&
                        (t = Ee(e).find(".navbar-large.navbar-current")),
                    t.length > 1 || !t.length)) ||
                    (t.hasClass("navbar-large-collapsed")
                        ? this.navbar.expandLargeTitle(t)
                        : this.navbar.collapseLargeTitle(t));
            },
            initNavbarOnScroll: function (e, t, a, r, n) {
                var o,
                    i,
                    s,
                    l,
                    c,
                    p,
                    d,
                    u,
                    h,
                    f,
                    v,
                    m,
                    g,
                    b,
                    y = this,
                    w = ct(),
                    C = Ee(e),
                    E = Ee(t),
                    k = E.find(".title-large"),
                    x = k.length || E.hasClass(".navbar-large"),
                    $ = 44,
                    T = y.params.navbar.snapPageScrollToLargeTitle,
                    S = y.params.navbar.snapPageScrollToTransparentNavbar;
                (r || (a && x)) &&
                    ((h = E.css("--f7-navbar-large-title-height")) &&
                    h.indexOf("px") >= 0
                        ? ((h = parseInt(h, 10)),
                          Number.isNaN(h) && k.length
                              ? (h = k[0].offsetHeight)
                              : Number.isNaN(h) &&
                                ("ios" === y.theme
                                    ? (h = 52)
                                    : "md" === y.theme
                                    ? (h = 48)
                                    : "aurora" === y.theme && (h = 38)))
                        : k.length
                        ? (h = k[0].offsetHeight)
                        : "ios" === y.theme
                        ? (h = 52)
                        : "md" === y.theme
                        ? (h = 48)
                        : "aurora" === y.theme && (h = 38)),
                    a && x && ($ += h);
                function M() {
                    C.find(".page-content").each(function (e) {
                        e.f7ScrollableDistance =
                            e.scrollHeight - e.offsetHeight;
                    });
                }
                function P() {
                    E.hasClass("with-searchbar-expandable-enabled") ||
                        !m ||
                        i < 0 ||
                        (i >= h / 2 && i < h
                            ? Ee(m).scrollTop(h, 100)
                            : i < h && Ee(m).scrollTop(0, 200));
                }
                function O() {
                    E.hasClass("with-searchbar-expandable-enabled") ||
                        !m ||
                        i < 0 ||
                        (i >= f / 2 && i < f
                            ? Ee(m).scrollTop(f, 100)
                            : i < f && Ee(m).scrollTop(0, 200));
                }
                var I = null,
                    B = null;
                function L(e) {
                    (m = this),
                        (e && e.target && e.target !== m) ||
                            ((i = m.scrollTop),
                            (v = i),
                            r
                                ? (function (e) {
                                      if (
                                          !E.hasClass("navbar-hidden") &&
                                          !E.parent(".navbars").hasClass(
                                              "navbar-hidden"
                                          )
                                      ) {
                                          var t =
                                              E.hasClass(
                                                  "navbar-large-transparent"
                                              ) ||
                                              (E.hasClass("navbar-large") &&
                                                  E.hasClass(
                                                      "navbar-transparent"
                                                  ));
                                          I = B;
                                          var a = Math.min(
                                              h,
                                              e.f7ScrollableDistance || h
                                          );
                                          B = Math.min(Math.max(i / a, 0), 1);
                                          var r = I > 0 && I < 1;
                                          E.hasClass(
                                              "with-searchbar-expandable-enabled"
                                          ) ||
                                              ((u = E.hasClass(
                                                  "navbar-large-collapsed"
                                              )),
                                              0 === B && u
                                                  ? y.navbar.expandLargeTitle(
                                                        E[0]
                                                    )
                                                  : 1 !== B ||
                                                    u ||
                                                    y.navbar.collapseLargeTitle(
                                                        E[0]
                                                    ),
                                              (0 === B && u) ||
                                              (0 === B && r) ||
                                              (1 === B && !u) ||
                                              (1 === B && r)
                                                  ? ("md" === y.theme &&
                                                        E.find(
                                                            ".navbar-inner"
                                                        ).css("overflow", ""),
                                                    E.find(".title").css(
                                                        "opacity",
                                                        ""
                                                    ),
                                                    E.find(
                                                        ".title-large-text, .subnavbar"
                                                    ).css("transform", ""),
                                                    t
                                                        ? E.find(
                                                              ".navbar-bg"
                                                          ).css("opacity", "")
                                                        : E.find(
                                                              ".navbar-bg"
                                                          ).css(
                                                              "transform",
                                                              ""
                                                          ))
                                                  : B > 0 &&
                                                    B < 1 &&
                                                    ("md" === y.theme &&
                                                        E.find(
                                                            ".navbar-inner"
                                                        ).css(
                                                            "overflow",
                                                            "visible"
                                                        ),
                                                    E.find(".title").css(
                                                        "opacity",
                                                        B
                                                    ),
                                                    E.find(
                                                        ".title-large-text, .subnavbar"
                                                    ).css(
                                                        "transform",
                                                        "translate3d(0px, " +
                                                            -1 * B * h +
                                                            "px, 0)"
                                                    ),
                                                    t
                                                        ? E.find(
                                                              ".navbar-bg"
                                                          ).css("opacity", B)
                                                        : E.find(
                                                              ".navbar-bg"
                                                          ).css(
                                                              "transform",
                                                              "translate3d(0px, " +
                                                                  -1 * B * h +
                                                                  "px, 0)"
                                                          )),
                                              T &&
                                                  (w.touch
                                                      ? b &&
                                                        (clearTimeout(b),
                                                        (b = null),
                                                        (b = setTimeout(
                                                            function () {
                                                                P(),
                                                                    clearTimeout(
                                                                        b
                                                                    ),
                                                                    (b = null);
                                                            },
                                                            70
                                                        )))
                                                      : (clearTimeout(g),
                                                        (g = setTimeout(
                                                            function () {
                                                                P();
                                                            },
                                                            300
                                                        )))));
                                      }
                                  })(m)
                                : n &&
                                  (function () {
                                      var e =
                                          E.hasClass("navbar-hidden") ||
                                          E.parent(".navbars").hasClass(
                                              "navbar-hidden"
                                          );
                                      if (
                                          !E.hasClass(
                                              "with-searchbar-expandable-enabled"
                                          ) &&
                                          !e
                                      ) {
                                          f || (f = t.offsetHeight);
                                          var a = i / f,
                                              r = E.hasClass(
                                                  "navbar-transparent-visible"
                                              );
                                          if (
                                              ((a = Math.max(
                                                  Math.min(a, 1),
                                                  0
                                              )),
                                              (r && 1 === a) || (!r && 0 === a))
                                          )
                                              E.find(".navbar-bg, .title").css(
                                                  "opacity",
                                                  ""
                                              );
                                          else {
                                              if (r && 0 === a)
                                                  return (
                                                      E.trigger(
                                                          "navbar:transparenthide"
                                                      ),
                                                      y.emit(
                                                          "navbarTransparentHide",
                                                          E[0]
                                                      ),
                                                      E.removeClass(
                                                          "navbar-transparent-visible"
                                                      ),
                                                      void E.find(
                                                          ".navbar-bg, .title"
                                                      ).css("opacity", "")
                                                  );
                                              if (!r && 1 === a)
                                                  return (
                                                      E.trigger(
                                                          "navbar:transparentshow"
                                                      ),
                                                      y.emit(
                                                          "navbarTransparentShow",
                                                          E[0]
                                                      ),
                                                      E.addClass(
                                                          "navbar-transparent-visible"
                                                      ),
                                                      void E.find(
                                                          ".navbar-bg, .title"
                                                      ).css("opacity", "")
                                                  );
                                              E.find(".navbar-bg, .title").css(
                                                  "opacity",
                                                  a
                                              ),
                                                  S &&
                                                      (w.touch
                                                          ? b &&
                                                            (clearTimeout(b),
                                                            (b = null),
                                                            (b = setTimeout(
                                                                function () {
                                                                    O(),
                                                                        clearTimeout(
                                                                            b
                                                                        ),
                                                                        (b =
                                                                            null);
                                                                },
                                                                70
                                                            )))
                                                          : (clearTimeout(g),
                                                            (g = setTimeout(
                                                                function () {
                                                                    O();
                                                                },
                                                                300
                                                            ))));
                                          }
                                      }
                                  })(),
                            C.hasClass("page-previous") ||
                                (a &&
                                    (C.hasClass("page-with-card-opened") ||
                                        ((s = m.scrollHeight),
                                        (l = m.offsetHeight),
                                        (c = i + l >= s),
                                        (d =
                                            E.hasClass("navbar-hidden") ||
                                            E.parent(".navbars").hasClass(
                                                "navbar-hidden"
                                            )),
                                        c
                                            ? y.params.navbar
                                                  .showOnPageScrollEnd &&
                                              (p = "show")
                                            : (p =
                                                  o > i
                                                      ? y.params.navbar
                                                            .showOnPageScrollTop ||
                                                        i <= $
                                                          ? "show"
                                                          : "hide"
                                                      : i > $
                                                      ? "hide"
                                                      : "show"),
                                        "show" === p && d
                                            ? (y.navbar.show(E, !0, !0),
                                              (d = !1))
                                            : "hide" !== p ||
                                              d ||
                                              (y.navbar.hide(E, !0, !1, !0),
                                              (d = !0)),
                                        (o = i)))));
                }
                function z() {
                    v = !1;
                }
                function R() {
                    clearTimeout(b),
                        (b = null),
                        (b = setTimeout(function () {
                            !1 !== v &&
                                (n && !r ? O() : P(),
                                clearTimeout(b),
                                (b = null));
                        }, 70));
                }
                C.on("scroll", ".page-content", L, !0),
                    w.touch &&
                        ((r && T) || (n && S)) &&
                        (y.on("touchstart:passive", z),
                        y.on("touchend:passive", R)),
                    M(),
                    (r || n) &&
                        C.find(".page-content").each(function (e) {
                            e.scrollTop > 0 && L.call(e);
                        }),
                    y.on("resize", M),
                    (C[0].f7DetachNavbarScrollHandlers = function () {
                        y.off("resize", M),
                            delete C[0].f7DetachNavbarScrollHandlers,
                            C.off("scroll", ".page-content", L, !0),
                            w.touch &&
                                ((r && T) || (n && S)) &&
                                (y.off("touchstart:passive", z),
                                y.off("touchend:passive", R));
                    });
            },
        },
        Qa = {
            name: "navbar",
            create: function () {
                nt(this, { navbar: Ka });
            },
            params: {
                navbar: {
                    scrollTopOnTitleClick: !0,
                    iosCenterTitle: !0,
                    mdCenterTitle: !1,
                    auroraCenterTitle: !0,
                    hideOnPageScroll: !1,
                    showOnPageScrollEnd: !0,
                    showOnPageScrollTop: !0,
                    collapseLargeTitleOnScroll: !0,
                    snapPageScrollToLargeTitle: !0,
                    snapPageScrollToTransparentNavbar: !0,
                },
            },
            on: {
                "panelBreakpoint panelCollapsedBreakpoint panelResize viewResize resize viewMasterDetailBreakpoint":
                    function () {
                        var e = this;
                        Ee(".navbar").each(function (t) {
                            e.navbar.size(t);
                        });
                    },
                pageBeforeRemove: function (e) {
                    e.$el[0].f7DetachNavbarScrollHandlers &&
                        e.$el[0].f7DetachNavbarScrollHandlers();
                },
                pageBeforeIn: function (e) {
                    var t = this;
                    if ("ios" === t.theme) {
                        var a,
                            r = e.$el.parents(".view")[0].f7View,
                            n = t.navbar.getElByPage(e);
                        if (
                            ((a = n
                                ? Ee(n).parents(".navbars")
                                : e.$el.parents(".view").children(".navbars")),
                            e.$el.hasClass("no-navbar") ||
                                (r.router.dynamicNavbar && !n))
                        ) {
                            var o = !!(
                                e.pageFrom && e.router.history.length > 0
                            );
                            t.navbar.hide(a, o);
                        } else t.navbar.show(a);
                    }
                },
                pageReinit: function (e) {
                    var t = Ee(this.navbar.getElByPage(e));
                    t && 0 !== t.length && this.navbar.size(t);
                },
                pageInit: function (e) {
                    var t,
                        a,
                        r,
                        n = this,
                        o = Ee(n.navbar.getElByPage(e));
                    o &&
                        0 !== o.length &&
                        (n.navbar.size(o),
                        o.find(".title-large").length > 0 &&
                            o.addClass("navbar-large"),
                        o.hasClass("navbar-large") &&
                            (n.params.navbar.collapseLargeTitleOnScroll &&
                                (t = !0),
                            e.$el.addClass("page-with-navbar-large")),
                        !t && o.hasClass("navbar-transparent") && (a = !0),
                        (n.params.navbar.hideOnPageScroll ||
                            e.$el.find(".hide-navbar-on-scroll").length ||
                            e.$el.hasClass("hide-navbar-on-scroll") ||
                            e.$el.find(".hide-bars-on-scroll").length ||
                            e.$el.hasClass("hide-bars-on-scroll")) &&
                            (r = !(
                                e.$el.find(".keep-navbar-on-scroll").length ||
                                e.$el.hasClass("keep-navbar-on-scroll") ||
                                e.$el.find(".keep-bars-on-scroll").length ||
                                e.$el.hasClass("keep-bars-on-scroll")
                            )),
                        (t || r || a) &&
                            n.navbar.initNavbarOnScroll(e.el, o[0], r, t, a));
                },
                "panelOpen panelSwipeOpen modalOpen": function (e) {
                    var t = this;
                    e.$el
                        .find(".navbar:not(.navbar-previous):not(.stacked)")
                        .each(function (e) {
                            t.navbar.size(e);
                        });
                },
                tabShow: function (e) {
                    var t = this;
                    Ee(e)
                        .find(".navbar:not(.navbar-previous):not(.stacked)")
                        .each(function (e) {
                            t.navbar.size(e);
                        });
                },
            },
            clicks: {
                ".navbar .title": function (e, t, a) {
                    if (
                        this.params.navbar.scrollTopOnTitleClick &&
                        !(Ee(a.target).closest("a, button").length > 0)
                    ) {
                        var r,
                            n = e.parents(".navbar"),
                            o = n.parents(".navbars");
                        0 === (r = n.parents(".page-content")).length &&
                            (n.parents(".page").length > 0 &&
                                (r = n.parents(".page").find(".page-content")),
                            0 === r.length &&
                                o.length &&
                                o.nextAll(".page-current:not(.stacked)")
                                    .length > 0 &&
                                (r = o
                                    .nextAll(".page-current:not(.stacked)")
                                    .find(".page-content")),
                            0 === r.length &&
                                n.nextAll(".page-current:not(.stacked)")
                                    .length > 0 &&
                                (r = n
                                    .nextAll(".page-current:not(.stacked)")
                                    .find(".page-content"))),
                            r &&
                                r.length > 0 &&
                                (r.hasClass("tab") &&
                                    (r = r
                                        .parent(".tabs")
                                        .children(".page-content.tab-active")),
                                r.length > 0 && r.scrollTop(0, 300));
                    }
                },
            },
            vnode: {
                navbar: {
                    postpatch: function (e) {
                        this.navbar.size(e.elm);
                    },
                },
            },
        },
        Ja = {
            setHighlight: function (e) {
                var t = Ee(e);
                if (
                    ("ios" !== this.theme || t.hasClass("tabbar-highlight")) &&
                    0 !== t.length &&
                    (t.hasClass("tabbar") || t.hasClass("tabbar-labels"))
                ) {
                    var a = t.find(".tab-link-highlight"),
                        r = t.find(".tab-link").length;
                    if (0 !== r) {
                        0 === a.length
                            ? (t
                                  .children(".toolbar-inner")
                                  .append(
                                      '<span class="tab-link-highlight"></span>'
                                  ),
                              (a = t.find(".tab-link-highlight")))
                            : a.next().length &&
                              t.children(".toolbar-inner").append(a);
                        var n,
                            o,
                            i = t.find(".tab-link-active");
                        if (t.hasClass("tabbar-scrollable") && i && i[0])
                            (n = i[0].offsetWidth + "px"),
                                (o = i[0].offsetLeft + "px");
                        else {
                            var s = i.index();
                            (n = 100 / r + "%"),
                                (o = 100 * (this.rtl ? -s : s) + "%");
                        }
                        _e(function () {
                            a.css("width", n).transform(
                                "translate3d(" + o + ",0,0)"
                            );
                        });
                    } else a.remove();
                }
            },
            init: function (e) {
                this.toolbar.setHighlight(e);
            },
            hide: function (e, t) {
                void 0 === t && (t = !0);
                var a = Ee(e);
                if (!a.hasClass("toolbar-hidden")) {
                    var r =
                        "toolbar-hidden" + (t ? " toolbar-transitioning" : "");
                    a.transitionEnd(function () {
                        a.removeClass("toolbar-transitioning");
                    }),
                        a.addClass(r),
                        a.trigger("toolbar:hide"),
                        this.emit("toolbarHide", a[0]);
                }
            },
            show: function (e, t) {
                void 0 === t && (t = !0);
                var a = Ee(e);
                a.hasClass("toolbar-hidden") &&
                    (t &&
                        (a.addClass("toolbar-transitioning"),
                        a.transitionEnd(function () {
                            a.removeClass("toolbar-transitioning");
                        })),
                    a.removeClass("toolbar-hidden"),
                    a.trigger("toolbar:show"),
                    this.emit("toolbarShow", a[0]));
            },
            initToolbarOnScroll: function (e) {
                var t,
                    a,
                    r,
                    n,
                    o,
                    i,
                    s,
                    l = this,
                    c = Ee(e),
                    p = c.parents(".view").children(".toolbar");
                (0 === p.length && (p = c.find(".toolbar")),
                0 === p.length &&
                    (p = c
                        .parents(".views")
                        .children(".tabbar, .tabbar-labels")),
                0 !== p.length) &&
                    (c.on("scroll", ".page-content", d, !0),
                    (c[0].f7ScrollToolbarHandler = d));
                function d(e) {
                    if (
                        !c.hasClass("page-with-card-opened") &&
                        !c.hasClass("page-previous")
                    ) {
                        var d = this;
                        (e && e.target && e.target !== d) ||
                            ((a = d.scrollTop),
                            (r = d.scrollHeight),
                            (n = d.offsetHeight),
                            (o = a + n >= r),
                            (s = p.hasClass("toolbar-hidden")),
                            o
                                ? l.params.toolbar.showOnPageScrollEnd &&
                                  (i = "show")
                                : (i =
                                      t > a
                                          ? l.params.toolbar
                                                .showOnPageScrollTop || a <= 44
                                              ? "show"
                                              : "hide"
                                          : a > 44
                                          ? "hide"
                                          : "show"),
                            "show" === i && s
                                ? (l.toolbar.show(p), (s = !1))
                                : "hide" !== i ||
                                  s ||
                                  (l.toolbar.hide(p), (s = !0)),
                            (t = a));
                    }
                }
            },
        },
        Za = {
            name: "toolbar",
            create: function () {
                nt(this, { toolbar: Ja });
            },
            params: {
                toolbar: {
                    hideOnPageScroll: !1,
                    showOnPageScrollEnd: !0,
                    showOnPageScrollTop: !0,
                },
            },
            on: {
                pageBeforeRemove: function (e) {
                    e.$el[0].f7ScrollToolbarHandler &&
                        e.$el.off(
                            "scroll",
                            ".page-content",
                            e.$el[0].f7ScrollToolbarHandler,
                            !0
                        );
                },
                pageBeforeIn: function (e) {
                    var t = e.$el.parents(".view").children(".toolbar");
                    0 === t.length &&
                        (t = e.$el
                            .parents(".views")
                            .children(".tabbar, .tabbar-labels")),
                        0 === t.length && (t = e.$el.find(".toolbar")),
                        0 !== t.length &&
                            (e.$el.hasClass("no-toolbar")
                                ? this.toolbar.hide(t)
                                : this.toolbar.show(t));
                },
                pageInit: function (e) {
                    var t = this;
                    if (
                        (e.$el
                            .find(".tabbar, .tabbar-labels")
                            .each(function (e) {
                                t.toolbar.init(e);
                            }),
                        t.params.toolbar.hideOnPageScroll ||
                            e.$el.find(".hide-toolbar-on-scroll").length ||
                            e.$el.hasClass("hide-toolbar-on-scroll") ||
                            e.$el.find(".hide-bars-on-scroll").length ||
                            e.$el.hasClass("hide-bars-on-scroll"))
                    ) {
                        if (
                            e.$el.find(".keep-toolbar-on-scroll").length ||
                            e.$el.hasClass("keep-toolbar-on-scroll") ||
                            e.$el.find(".keep-bars-on-scroll").length ||
                            e.$el.hasClass("keep-bars-on-scroll")
                        )
                            return;
                        t.toolbar.initToolbarOnScroll(e.el);
                    }
                },
                init: function () {
                    var e = this;
                    e.$el.find(".tabbar, .tabbar-labels").each(function (t) {
                        e.toolbar.init(t);
                    });
                },
            },
            vnode: {
                tabbar: {
                    insert: function (e) {
                        this.toolbar.init(e.elm);
                    },
                },
            },
        },
        er = {
            name: "subnavbar",
            on: {
                pageInit: function (e) {
                    e.$navbarEl &&
                        e.$navbarEl.length &&
                        e.$navbarEl.find(".subnavbar").length &&
                        e.$el.addClass("page-with-subnavbar"),
                        e.$el.find(".subnavbar").filter(function (t) {
                            return Ee(t).parents(".page")[0] === e.$el[0];
                        }).length && e.$el.addClass("page-with-subnavbar");
                },
            },
        },
        tr = (function () {
            function e(e, t, a, r) {
                var n = this;
                if (t) {
                    var o = t[0].getBoundingClientRect(),
                        i = o.left,
                        s = o.top,
                        l = o.width,
                        c = o.height,
                        p = a - i,
                        d = r - s,
                        u = Math.max(
                            Math.pow(Math.pow(c, 2) + Math.pow(l, 2), 0.5),
                            48
                        ),
                        h = !1,
                        f = e.params.touch.touchRippleInsetElements || "";
                    if (
                        (f && t.is(f) && (h = !0),
                        h && (u = Math.max(Math.min(l, c), 48)),
                        h || "hidden" !== t.css("overflow"))
                    )
                        n.rippleTransform =
                            "translate3d(" +
                            (l / 2 - p) +
                            "px, " +
                            (c / 2 - d) +
                            "px, 0) scale(1)";
                    else {
                        var v =
                            (u / 2 +
                                Math.pow(
                                    Math.pow(p - l / 2, 2) +
                                        Math.pow(d - c / 2, 2),
                                    0.5
                                )) /
                            (u / 2);
                        n.rippleTransform =
                            "translate3d(0px, 0px, 0) scale(" + v + ")";
                    }
                    return (
                        h && t.addClass("ripple-inset"),
                        (n.$rippleWaveEl = Ee(
                            '<div class="ripple-wave" style="width: ' +
                                u +
                                "px; height: " +
                                u +
                                "px; margin-top:-" +
                                u / 2 +
                                "px; margin-left:-" +
                                u / 2 +
                                "px; left:" +
                                p +
                                "px; top:" +
                                d +
                                "px; --f7-ripple-transform: " +
                                n.rippleTransform +
                                '"></div>'
                        )),
                        t.prepend(n.$rippleWaveEl),
                        n.$rippleWaveEl.animationEnd(function () {
                            n.$rippleWaveEl &&
                                (n.$rippleWaveEl.hasClass("ripple-wave-out") ||
                                    (n.$rippleWaveEl.addClass("ripple-wave-in"),
                                    n.shouldBeRemoved && n.out()));
                        }),
                        n
                    );
                }
            }
            var t = e.prototype;
            return (
                (t.destroy = function () {
                    var e = this;
                    e.$rippleWaveEl && e.$rippleWaveEl.remove(),
                        Object.keys(e).forEach(function (t) {
                            (e[t] = null), delete e[t];
                        }),
                        (e = null);
                }),
                (t.out = function () {
                    var e = this,
                        t = this.$rippleWaveEl;
                    clearTimeout(e.removeTimeout),
                        t.addClass("ripple-wave-out"),
                        (e.removeTimeout = setTimeout(function () {
                            e.destroy();
                        }, 300)),
                        t.animationEnd(function () {
                            clearTimeout(e.removeTimeout), e.destroy();
                        });
                }),
                (t.remove = function () {
                    var e = this;
                    e.shouldBeRemoved ||
                        ((e.removeTimeout = setTimeout(function () {
                            e.destroy();
                        }, 400)),
                        (e.shouldBeRemoved = !0),
                        e.$rippleWaveEl.hasClass("ripple-wave-in") && e.out());
                }),
                e
            );
        })(),
        ar = {
            name: "touch-ripple",
            static: { TouchRipple: tr },
            create: function () {
                this.touchRipple = {
                    create: function () {
                        for (
                            var e = arguments.length, t = new Array(e), a = 0;
                            a < e;
                            a++
                        )
                            t[a] = arguments[a];
                        return Be(tr, t);
                    },
                };
            },
        },
        rr = [],
        nr = [];
    var or = (function (e) {
            function t(t, a) {
                var r,
                    n = ze((r = e.call(this, a, [t]) || this)),
                    o = {};
                n.useModulesParams(o), (n.params = Qe(o, a)), (n.opened = !1);
                var i = n.params.containerEl
                    ? Ee(n.params.containerEl).eq(0)
                    : t.$el;
                return (
                    i.length || (i = t.$el),
                    (n.$containerEl = i),
                    (n.containerEl = i[0]),
                    n.useModules(),
                    ze(r) || ze(r)
                );
            }
            Me(t, e);
            var a = t.prototype;
            return (
                (a.onOpen = function () {
                    var e = this;
                    (e.opened = !0),
                        rr.push(e),
                        Ee("html").addClass(
                            "with-modal-" + e.type.toLowerCase()
                        ),
                        e.$el.trigger(
                            "modal:open " + e.type.toLowerCase() + ":open"
                        ),
                        e.emit("local::open modalOpen " + e.type + "Open", e);
                }),
                (a.onOpened = function () {
                    var e = this;
                    e.$el.trigger(
                        "modal:opened " + e.type.toLowerCase() + ":opened"
                    ),
                        e.emit(
                            "local::opened modalOpened " + e.type + "Opened",
                            e
                        );
                }),
                (a.onClose = function () {
                    var e = this;
                    (e.opened = !1),
                        e.type &&
                            e.$el &&
                            (rr.splice(rr.indexOf(e), 1),
                            Ee("html").removeClass(
                                "with-modal-" + e.type.toLowerCase()
                            ),
                            e.$el.trigger(
                                "modal:close " + e.type.toLowerCase() + ":close"
                            ),
                            e.emit(
                                "local::close modalClose " + e.type + "Close",
                                e
                            ));
                }),
                (a.onClosed = function () {
                    var e = this;
                    e.type &&
                        e.$el &&
                        (e.$el.removeClass("modal-out"),
                        e.$el.hide(),
                        e.$el.trigger(
                            "modal:closed " + e.type.toLowerCase() + ":closed"
                        ),
                        e.emit(
                            "local::closed modalClosed " + e.type + "Closed",
                            e
                        ));
                }),
                (a.open = function (e) {
                    var t,
                        a = this,
                        n = r(),
                        o = a.app,
                        i = a.$el,
                        s = a.$backdropEl,
                        l = a.type,
                        c = !0;
                    if (
                        (void 0 !== e
                            ? (c = e)
                            : void 0 !== a.params.animate &&
                              (c = a.params.animate),
                        !i || i.hasClass("modal-in"))
                    )
                        return (
                            !1 === e &&
                                i[0] &&
                                "dialog" !== l &&
                                (i[0].style.display = "block"),
                            a
                        );
                    if (
                        "dialog" === l &&
                        o.params.modal.queueDialogs &&
                        (Ee(".dialog.modal-in").length > 0
                            ? (t = !0)
                            : rr.length > 0 &&
                              rr.forEach(function (e) {
                                  "dialog" === e.type && (t = !0);
                              }),
                        t)
                    )
                        return nr.push(a), a;
                    var p = i.parent(),
                        d = i.parents(n).length > 0;
                    function u() {
                        i.hasClass("modal-out")
                            ? a.onClosed()
                            : i.hasClass("modal-in") && a.onOpened();
                    }
                    return (
                        p.is(a.$containerEl) ||
                            (a.$containerEl.append(i),
                            a.once(l + "Closed", function () {
                                d ? p.append(i) : i.remove();
                            })),
                        i.show(),
                        (a._clientLeft = i[0].clientLeft),
                        c
                            ? (s &&
                                  (s.removeClass("not-animated"),
                                  s.addClass("backdrop-in")),
                              i.animationEnd(function () {
                                  u();
                              }),
                              i.transitionEnd(function () {
                                  u();
                              }),
                              i
                                  .removeClass("modal-out not-animated")
                                  .addClass("modal-in"),
                              a.onOpen())
                            : (s && s.addClass("backdrop-in not-animated"),
                              i
                                  .removeClass("modal-out")
                                  .addClass("modal-in not-animated"),
                              a.onOpen(),
                              a.onOpened()),
                        a
                    );
                }),
                (a.close = function (e) {
                    var t = this,
                        a = t.$el,
                        r = t.$backdropEl,
                        n = !0;
                    if (
                        (void 0 !== e
                            ? (n = e)
                            : void 0 !== t.params.animate &&
                              (n = t.params.animate),
                        !a || !a.hasClass("modal-in"))
                    )
                        return (
                            nr.indexOf(t) >= 0 && nr.splice(nr.indexOf(t), 1), t
                        );
                    if (r) {
                        var o = !0;
                        "popup" === t.type &&
                            t.$el
                                .prevAll(".popup.modal-in")
                                .add(t.$el.nextAll(".popup.modal-in"))
                                .each(function (e) {
                                    var a = e.f7Modal;
                                    a &&
                                        a.params.closeByBackdropClick &&
                                        a.params.backdrop &&
                                        a.backdropEl === t.backdropEl &&
                                        (o = !1);
                                }),
                            o &&
                                (r[n ? "removeClass" : "addClass"](
                                    "not-animated"
                                ),
                                r.removeClass("backdrop-in"));
                    }
                    function i() {
                        a.hasClass("modal-out")
                            ? t.onClosed()
                            : a.hasClass("modal-in") && t.onOpened();
                    }
                    return (
                        a[n ? "removeClass" : "addClass"]("not-animated"),
                        n
                            ? (a.animationEnd(function () {
                                  i();
                              }),
                              a.transitionEnd(function () {
                                  i();
                              }),
                              a.removeClass("modal-in").addClass("modal-out"),
                              t.onClose())
                            : (a
                                  .addClass("not-animated")
                                  .removeClass("modal-in")
                                  .addClass("modal-out"),
                              t.onClose(),
                              t.onClosed()),
                        "dialog" === t.type &&
                            0 !== nr.length &&
                            nr.shift().open(),
                        t
                    );
                }),
                (a.destroy = function () {
                    var e = this;
                    e.destroyed ||
                        (e.emit(
                            "local::beforeDestroy modalBeforeDestroy " +
                                e.type +
                                "BeforeDestroy",
                            e
                        ),
                        e.$el &&
                            (e.$el.trigger(
                                "modal:beforedestroy " +
                                    e.type.toLowerCase() +
                                    ":beforedestroy"
                            ),
                            e.$el.length &&
                                e.$el[0].f7Modal &&
                                delete e.$el[0].f7Modal),
                        Fe(e),
                        (e.destroyed = !0));
                }),
                t
            );
        })(ut),
        ir = (function (e) {
            function t(t, a) {
                var r,
                    n,
                    o,
                    i = Qe(
                        { backdrop: !0, closeByBackdropClick: !0, on: {} },
                        a
                    ),
                    s = ze((r = e.call(this, t, i) || this));
                if (
                    ((s.params = i),
                    (n = s.params.el
                        ? Ee(s.params.el)
                        : Ee(s.params.content)) &&
                        n.length > 0 &&
                        n[0].f7Modal)
                )
                    return n[0].f7Modal || ze(r);
                if (0 === n.length) return s.destroy() || ze(r);
                function l(e) {
                    s && !s.destroyed && o && e.target === o[0] && s.close();
                }
                return (
                    s.params.backdrop &&
                        0 ===
                            (o = t.$el.children(".custom-modal-backdrop"))
                                .length &&
                        ((o = Ee('<div class="custom-modal-backdrop"></div>')),
                        t.$el.append(o)),
                    s.on("customModalOpened", function () {
                        s.params.closeByBackdropClick &&
                            s.params.backdrop &&
                            t.on("click", l);
                    }),
                    s.on("customModalClose", function () {
                        s.params.closeByBackdropClick &&
                            s.params.backdrop &&
                            t.off("click", l);
                    }),
                    Qe(s, {
                        app: t,
                        $el: n,
                        el: n[0],
                        $backdropEl: o,
                        backdropEl: o && o[0],
                        type: "customModal",
                    }),
                    (n[0].f7Modal = s),
                    s || ze(r)
                );
            }
            return Me(t, e), t;
        })(or),
        sr = {
            name: "modal",
            static: { Modal: or, CustomModal: ir },
            create: function () {
                var e = this;
                e.customModal = {
                    create: function (t) {
                        return new ir(e, t);
                    },
                };
            },
            params: { modal: { queueDialogs: !0 } },
        },
        lr = function (e, t) {
            for (
                var a = t || {},
                    r = arguments.length,
                    n = new Array(r > 2 ? r - 2 : 0),
                    o = 2;
                o < r;
                o++
            )
                n[o - 2] = arguments[o];
            var i = n || [],
                s = Object.keys(a)
                    .map(function (e) {
                        return "_" === e[0]
                            ? a[e]
                                ? e.replace("_", "")
                                : ""
                            : e + '="' + a[e] + '"';
                    })
                    .filter(function (e) {
                        return !!e;
                    })
                    .join(" ");
            if (
                ["path", "img", "circle", "polygon", "line", "input"].indexOf(
                    e
                ) >= 0
            )
                return ("<" + e + " " + s + " />").trim();
            var l = i
                .filter(function (e) {
                    return !!e;
                })
                .map(function (e) {
                    return Array.isArray(e) ? e.join("") : e;
                })
                .join("");
            return ("<" + e + " " + s + ">" + l + "</" + e + ">").trim();
        },
        cr = (function (e) {
            function t(t, a) {
                var n,
                    o = Qe(
                        {
                            title: t.params.dialog.title,
                            text: void 0,
                            content: "",
                            buttons: [],
                            verticalButtons: !1,
                            onClick: void 0,
                            cssClass: void 0,
                            destroyOnClose: !1,
                            on: {},
                        },
                        a
                    );
                void 0 === o.closeByBackdropClick &&
                    (o.closeByBackdropClick =
                        t.params.dialog.closeByBackdropClick),
                    void 0 === o.backdrop &&
                        (o.backdrop = t.params.dialog.backdrop);
                var i,
                    s,
                    l,
                    c = ze((n = e.call(this, t, o) || this)),
                    p = pt(),
                    d = r(),
                    u = o.title,
                    h = o.text,
                    f = o.content,
                    v = o.buttons,
                    m = o.verticalButtons,
                    g = o.cssClass,
                    b = o.backdrop;
                if (((c.params = o), c.params.el)) i = Ee(c.params.el);
                else {
                    var y = ["dialog"];
                    0 === v.length && y.push("dialog-no-buttons"),
                        v.length > 0 && y.push("dialog-buttons-" + v.length),
                        m && y.push("dialog-buttons-vertical"),
                        g && y.push(g);
                    var w = "";
                    v.length > 0 &&
                        (w = lr(
                            "div",
                            { class: "dialog-buttons" },
                            v.map(function (e) {
                                return lr(
                                    "span",
                                    {
                                        class:
                                            "dialog-button" +
                                            (e.bold
                                                ? " dialog-button-bold"
                                                : "") +
                                            (e.color
                                                ? " color-" + e.color
                                                : "") +
                                            (e.cssClass
                                                ? " " + e.cssClass
                                                : ""),
                                    },
                                    e.text
                                );
                            })
                        ));
                    var C = lr(
                        "div",
                        { class: y.join(" ") },
                        lr(
                            "div",
                            { class: "dialog-inner" },
                            u && lr("div", { class: "dialog-title" }, u),
                            h && lr("div", { class: "dialog-text" }, h),
                            f
                        ),
                        w
                    );
                    i = Ee(C);
                }
                if (i && i.length > 0 && i[0].f7Modal)
                    return i[0].f7Modal || ze(n);
                if (0 === i.length) return c.destroy() || ze(n);
                function E(e) {
                    var t = Ee(this).index(),
                        a = v[t];
                    a.onClick && a.onClick(c, e),
                        c.params.onClick && c.params.onClick(c, t),
                        !1 !== a.close && c.close();
                }
                function k(e) {
                    var t = e.keyCode;
                    v.forEach(function (a, r) {
                        a.keyCodes &&
                            a.keyCodes.indexOf(t) >= 0 &&
                            (d.activeElement && d.activeElement.blur(),
                            a.onClick && a.onClick(c, e),
                            c.params.onClick && c.params.onClick(c, r),
                            !1 !== a.close && c.close());
                    });
                }
                function x(e) {
                    var t = e.target;
                    0 === Ee(t).closest(c.el).length &&
                        c.params.closeByBackdropClick &&
                        c.backdropEl &&
                        c.backdropEl === t &&
                        c.close();
                }
                return (
                    b &&
                        0 === (s = t.$el.children(".dialog-backdrop")).length &&
                        ((s = Ee('<div class="dialog-backdrop"></div>')),
                        t.$el.append(s)),
                    v &&
                        v.length > 0 &&
                        (c.on("open", function () {
                            i.find(".dialog-button").each(function (e, t) {
                                v[t].keyCodes && (l = !0), Ee(e).on("click", E);
                            }),
                                !l ||
                                    p.ios ||
                                    p.android ||
                                    p.cordova ||
                                    p.capacitor ||
                                    Ee(d).on("keydown", k);
                        }),
                        c.on("close", function () {
                            i.find(".dialog-button").each(function (e) {
                                Ee(e).off("click", E);
                            }),
                                !l ||
                                    p.ios ||
                                    p.android ||
                                    p.cordova ||
                                    p.capacitor ||
                                    Ee(d).off("keydown", k),
                                (l = !1);
                        })),
                    Qe(c, {
                        app: t,
                        $el: i,
                        el: i[0],
                        $backdropEl: s,
                        backdropEl: s && s[0],
                        type: "dialog",
                        setProgress: function (e, a) {
                            return (
                                t.progressbar.set(i.find(".progressbar"), e, a),
                                c
                            );
                        },
                        setText: function (e) {
                            var t = i.find(".dialog-text");
                            return (
                                0 === t.length &&
                                    ((t = Ee(
                                        '<div class="dialog-text"></div>'
                                    )),
                                    void 0 !== u
                                        ? t.insertAfter(i.find(".dialog-title"))
                                        : i.find(".dialog-inner").prepend(t)),
                                t.html(e),
                                (c.params.text = e),
                                c
                            );
                        },
                        setTitle: function (e) {
                            var t = i.find(".dialog-title");
                            return (
                                0 === t.length &&
                                    ((t = Ee(
                                        '<div class="dialog-title"></div>'
                                    )),
                                    i.find(".dialog-inner").prepend(t)),
                                t.html(e),
                                (c.params.title = e),
                                c
                            );
                        },
                    }),
                    c.on("opened", function () {
                        c.params.closeByBackdropClick && t.on("click", x);
                    }),
                    c.on("close", function () {
                        c.params.closeByBackdropClick && t.off("click", x);
                    }),
                    (i[0].f7Modal = c),
                    c.params.destroyOnClose &&
                        c.once("closed", function () {
                            setTimeout(function () {
                                c.destroy();
                            }, 0);
                        }),
                    c || ze(n)
                );
            }
            return Me(t, e), t;
        })(or),
        pr = {
            name: "dialog",
            params: {
                dialog: {
                    title: void 0,
                    buttonOk: "OK",
                    buttonCancel: "Cancel",
                    usernamePlaceholder: "Username",
                    passwordPlaceholder: "Password",
                    preloaderTitle: "Loading... ",
                    progressTitle: "Loading... ",
                    backdrop: !0,
                    closeByBackdropClick: !1,
                    destroyPredefinedDialogs: !0,
                    keyboardActions: !0,
                    autoFocus: !0,
                },
            },
            static: { Dialog: cr },
            create: function () {
                var e = this;
                function t() {
                    return e.params.dialog.title || e.name;
                }
                var a = e.params.dialog.destroyPredefinedDialogs,
                    r = e.params.dialog.keyboardActions,
                    n = e.params.dialog.autoFocus
                        ? {
                              on: {
                                  opened: function (e) {
                                      e.$el.find("input").eq(0).focus();
                                  },
                              },
                          }
                        : {};
                e.dialog = Qe(
                    ft({
                        app: e,
                        constructor: cr,
                        defaultSelector: ".dialog.modal-in",
                    }),
                    {
                        alert: function () {
                            for (
                                var n = arguments.length,
                                    o = new Array(n),
                                    i = 0;
                                i < n;
                                i++
                            )
                                o[i] = arguments[i];
                            var s = o[0],
                                l = o[1],
                                c = o[2];
                            return (
                                2 === o.length &&
                                    "function" == typeof o[1] &&
                                    ((s = o[0]), (c = o[1]), (l = o[2])),
                                new cr(e, {
                                    title: void 0 === l ? t() : l,
                                    text: s,
                                    buttons: [
                                        {
                                            text: e.params.dialog.buttonOk,
                                            bold: !0,
                                            onClick: c,
                                            keyCodes: r ? [13, 27] : null,
                                        },
                                    ],
                                    destroyOnClose: a,
                                }).open()
                            );
                        },
                        prompt: function () {
                            for (
                                var o = arguments.length,
                                    i = new Array(o),
                                    s = 0;
                                s < o;
                                s++
                            )
                                i[s] = arguments[s];
                            var l = i[0],
                                c = i[1],
                                p = i[2],
                                d = i[3],
                                u = i[4];
                            return (
                                "function" == typeof i[1] &&
                                    ((l = i[0]),
                                    (p = i[1]),
                                    (d = i[2]),
                                    (u = i[3]),
                                    (c = i[4])),
                                (u = null == u ? "" : u),
                                new cr(
                                    e,
                                    Se(
                                        {
                                            title: void 0 === c ? t() : c,
                                            text: l,
                                            content:
                                                '<div class="dialog-input-field input"><input type="text" class="dialog-input" value="' +
                                                u +
                                                '"></div>',
                                            buttons: [
                                                {
                                                    text: e.params.dialog
                                                        .buttonCancel,
                                                    keyCodes: r ? [27] : null,
                                                    color:
                                                        "aurora" === e.theme
                                                            ? "gray"
                                                            : null,
                                                },
                                                {
                                                    text: e.params.dialog
                                                        .buttonOk,
                                                    bold: !0,
                                                    keyCodes: r ? [13] : null,
                                                },
                                            ],
                                            onClick: function (e, t) {
                                                var a = e.$el
                                                    .find(".dialog-input")
                                                    .val();
                                                0 === t && d && d(a),
                                                    1 === t && p && p(a);
                                            },
                                            destroyOnClose: a,
                                        },
                                        n
                                    )
                                ).open()
                            );
                        },
                        confirm: function () {
                            for (
                                var n = arguments.length,
                                    o = new Array(n),
                                    i = 0;
                                i < n;
                                i++
                            )
                                o[i] = arguments[i];
                            var s = o[0],
                                l = o[1],
                                c = o[2],
                                p = o[3];
                            return (
                                "function" == typeof o[1] &&
                                    ((s = o[0]),
                                    (c = o[1]),
                                    (p = o[2]),
                                    (l = o[3])),
                                new cr(e, {
                                    title: void 0 === l ? t() : l,
                                    text: s,
                                    buttons: [
                                        {
                                            text: e.params.dialog.buttonCancel,
                                            onClick: p,
                                            keyCodes: r ? [27] : null,
                                            color:
                                                "aurora" === e.theme
                                                    ? "gray"
                                                    : null,
                                        },
                                        {
                                            text: e.params.dialog.buttonOk,
                                            bold: !0,
                                            onClick: c,
                                            keyCodes: r ? [13] : null,
                                        },
                                    ],
                                    destroyOnClose: a,
                                }).open()
                            );
                        },
                        login: function () {
                            for (
                                var o = arguments.length,
                                    i = new Array(o),
                                    s = 0;
                                s < o;
                                s++
                            )
                                i[s] = arguments[s];
                            var l = i[0],
                                c = i[1],
                                p = i[2],
                                d = i[3];
                            return (
                                "function" == typeof i[1] &&
                                    ((l = i[0]),
                                    (p = i[1]),
                                    (d = i[2]),
                                    (c = i[3])),
                                new cr(
                                    e,
                                    Se(
                                        {
                                            title: void 0 === c ? t() : c,
                                            text: l,
                                            content:
                                                '\n              <div class="dialog-input-field dialog-input-double input">\n                <input type="text" name="dialog-username" placeholder="' +
                                                e.params.dialog
                                                    .usernamePlaceholder +
                                                '" class="dialog-input">\n              </div>\n              <div class="dialog-input-field dialog-input-double input">\n                <input type="password" name="dialog-password" placeholder="' +
                                                e.params.dialog
                                                    .passwordPlaceholder +
                                                '" class="dialog-input">\n              </div>',
                                            buttons: [
                                                {
                                                    text: e.params.dialog
                                                        .buttonCancel,
                                                    keyCodes: r ? [27] : null,
                                                    color:
                                                        "aurora" === e.theme
                                                            ? "gray"
                                                            : null,
                                                },
                                                {
                                                    text: e.params.dialog
                                                        .buttonOk,
                                                    bold: !0,
                                                    keyCodes: r ? [13] : null,
                                                },
                                            ],
                                            onClick: function (e, t) {
                                                var a = e.$el
                                                        .find(
                                                            '[name="dialog-username"]'
                                                        )
                                                        .val(),
                                                    r = e.$el
                                                        .find(
                                                            '[name="dialog-password"]'
                                                        )
                                                        .val();
                                                0 === t && d && d(a, r),
                                                    1 === t && p && p(a, r);
                                            },
                                            destroyOnClose: a,
                                        },
                                        n
                                    )
                                ).open()
                            );
                        },
                        password: function () {
                            for (
                                var o = arguments.length,
                                    i = new Array(o),
                                    s = 0;
                                s < o;
                                s++
                            )
                                i[s] = arguments[s];
                            var l = i[0],
                                c = i[1],
                                p = i[2],
                                d = i[3];
                            return (
                                "function" == typeof i[1] &&
                                    ((l = i[0]),
                                    (p = i[1]),
                                    (d = i[2]),
                                    (c = i[3])),
                                new cr(
                                    e,
                                    Se(
                                        {
                                            title: void 0 === c ? t() : c,
                                            text: l,
                                            content:
                                                '\n              <div class="dialog-input-field input">\n                <input type="password" name="dialog-password" placeholder="' +
                                                e.params.dialog
                                                    .passwordPlaceholder +
                                                '" class="dialog-input">\n              </div>',
                                            buttons: [
                                                {
                                                    text: e.params.dialog
                                                        .buttonCancel,
                                                    keyCodes: r ? [27] : null,
                                                    color:
                                                        "aurora" === e.theme
                                                            ? "gray"
                                                            : null,
                                                },
                                                {
                                                    text: e.params.dialog
                                                        .buttonOk,
                                                    bold: !0,
                                                    keyCodes: r ? [13] : null,
                                                },
                                            ],
                                            onClick: function (e, t) {
                                                var a = e.$el
                                                    .find(
                                                        '[name="dialog-password"]'
                                                    )
                                                    .val();
                                                0 === t && d && d(a),
                                                    1 === t && p && p(a);
                                            },
                                            destroyOnClose: a,
                                        },
                                        n
                                    )
                                ).open()
                            );
                        },
                        preloader: function (t, r) {
                            var n =
                                {
                                    iosPreloaderContent: He,
                                    mdPreloaderContent: De,
                                    auroraPreloaderContent: Ne,
                                }[e.theme + "PreloaderContent"] || "";
                            return new cr(e, {
                                title:
                                    null == t
                                        ? e.params.dialog.preloaderTitle
                                        : t,
                                content:
                                    '<div class="preloader' +
                                    (r ? " color-" + r : "") +
                                    '">' +
                                    n +
                                    "</div>",
                                cssClass: "dialog-preloader",
                                destroyOnClose: a,
                            }).open();
                        },
                        progress: function () {
                            for (
                                var t = arguments.length,
                                    r = new Array(t),
                                    n = 0;
                                n < t;
                                n++
                            )
                                r[n] = arguments[n];
                            var o = r[0],
                                i = r[1],
                                s = r[2];
                            2 === r.length
                                ? "number" == typeof r[0]
                                    ? ((i = r[0]), (s = r[1]), (o = r[2]))
                                    : "string" == typeof r[0] &&
                                      "string" == typeof r[1] &&
                                      ((o = r[0]), (s = r[1]), (i = r[2]))
                                : 1 === r.length &&
                                  "number" == typeof r[0] &&
                                  ((i = r[0]), (o = r[1]), (s = r[2]));
                            var l = void 0 === i,
                                c = new cr(e, {
                                    title:
                                        void 0 === o
                                            ? e.params.dialog.progressTitle
                                            : o,
                                    cssClass: "dialog-progress",
                                    content:
                                        '\n              <div class="progressbar' +
                                        (l ? "-infinite" : "") +
                                        (s ? " color-" + s : "") +
                                        '">\n                ' +
                                        (l ? "" : "<span></span>") +
                                        "\n              </div>\n            ",
                                    destroyOnClose: a,
                                });
                            return l || c.setProgress(i), c.open();
                        },
                    }
                );
            },
        },
        dr = (function (e) {
            function t(t, a) {
                var n,
                    i,
                    s,
                    l,
                    c,
                    p = Qe({ on: {} }, t.params.popup, a),
                    d = ze((n = e.call(this, t, p) || this)),
                    u = o(),
                    h = r(),
                    f = ct(),
                    v = pt();
                if (
                    ((d.params = p),
                    (i = d.params.el
                        ? Ee(d.params.el).eq(0)
                        : Ee(d.params.content)
                              .filter(function (e) {
                                  return 1 === e.nodeType;
                              })
                              .eq(0)) &&
                        i.length > 0 &&
                        i[0].f7Modal)
                )
                    return i[0].f7Modal || ze(n);
                if (0 === i.length) return d.destroy() || ze(n);
                function m(e) {
                    var t = e.target,
                        a = Ee(t);
                    if (
                        !(
                            !v.desktop &&
                            v.cordova &&
                            ((u.Keyboard && u.Keyboard.isVisible) ||
                                (u.cordova.plugins &&
                                    u.cordova.plugins.Keyboard &&
                                    u.cordova.plugins.Keyboard.isVisible))
                        ) &&
                        0 === a.closest(d.el).length &&
                        d.params &&
                        d.params.closeByBackdropClick &&
                        d.params.backdrop &&
                        d.backdropEl &&
                        d.backdropEl === t
                    ) {
                        var r = !0;
                        d.$el.nextAll(".popup.modal-in").each(function (e) {
                            var t = e.f7Modal;
                            t &&
                                t.params.closeByBackdropClick &&
                                t.params.backdrop &&
                                t.backdropEl === d.backdropEl &&
                                (r = !1);
                        }),
                            r && d.close();
                    }
                }
                function g(e) {
                    27 === e.keyCode && d.params.closeOnEscape && d.close();
                }
                function b(e) {
                    return (t.height - 2 * e) / t.height;
                }
                d.params.backdrop && d.params.backdropEl
                    ? (s = Ee(d.params.backdropEl))
                    : d.params.backdrop &&
                      0 ===
                          (s = d.$containerEl.children(".popup-backdrop"))
                              .length &&
                      ((s = Ee('<div class="popup-backdrop"></div>')),
                      d.$containerEl.append(s)),
                    Qe(d, {
                        app: t,
                        push: i.hasClass("popup-push") || d.params.push,
                        $el: i,
                        el: i[0],
                        $backdropEl: s,
                        backdropEl: s && s[0],
                        type: "popup",
                        $htmlEl: Ee("html"),
                    }),
                    d.params.push && i.addClass("popup-push");
                var y,
                    w,
                    C,
                    E,
                    k,
                    x,
                    $,
                    T,
                    S,
                    M,
                    P,
                    O = !0,
                    I = !1,
                    B = !1;
                function L(e) {
                    !I &&
                        O &&
                        d.params.swipeToClose &&
                        ((d.params.swipeHandler &&
                            0 ===
                                Ee(e.target).closest(d.params.swipeHandler)
                                    .length) ||
                            ((I = !0),
                            (B = !1),
                            (y = {
                                x:
                                    "touchstart" === e.type
                                        ? e.targetTouches[0].pageX
                                        : e.pageX,
                                y:
                                    "touchstart" === e.type
                                        ? e.targetTouches[0].pageY
                                        : e.pageY,
                            }),
                            (E = Ye()),
                            (C = void 0),
                            d.params.swipeHandler ||
                                "touchstart" !== e.type ||
                                (x = Ee(e.target).closest(
                                    ".page-content"
                                )[0])));
                }
                function z(e) {
                    if (I) {
                        if (
                            ((w = {
                                x:
                                    "touchmove" === e.type
                                        ? e.targetTouches[0].pageX
                                        : e.pageX,
                                y:
                                    "touchmove" === e.type
                                        ? e.targetTouches[0].pageY
                                        : e.pageY,
                            }),
                            void 0 === C &&
                                (C = !!(
                                    C ||
                                    Math.abs(w.x - y.x) > Math.abs(w.y - y.y)
                                )),
                            C)
                        )
                            return (I = !1), void (B = !1);
                        (k = y.y - w.y), c && l && k > 0 && (k = 0);
                        var a = k < 0 ? "to-bottom" : "to-top";
                        if (
                            (i.transition(0),
                            "string" == typeof d.params.swipeToClose &&
                                a !== d.params.swipeToClose)
                        )
                            return i.transform(""), void i.transition("");
                        if (B)
                            d.emit("local::swipeMove popupSwipeMove", d),
                                d.$el.trigger("popup:swipemove");
                        else {
                            if (
                                (c &&
                                    l &&
                                    ((M = i[0].offsetHeight),
                                    0 ===
                                        (P = i.prevAll(".popup.modal-in").eq(0))
                                            .length &&
                                        (P = t.$el.children(".view, .views"))),
                                x &&
                                    (($ = x.scrollTop),
                                    (S = x.scrollHeight),
                                    (T = x.offsetHeight),
                                    !(
                                        S === T ||
                                        ("to-bottom" === a && 0 === $) ||
                                        ("to-top" === a && $ === S - T)
                                    )))
                            )
                                return (
                                    i.transform(""),
                                    i.transition(""),
                                    (I = !1),
                                    void (B = !1)
                                );
                            (B = !0),
                                d.emit("local::swipeStart popupSwipeStart", d),
                                d.$el.trigger("popup:swipestart");
                        }
                        if ((e.preventDefault(), c && l)) {
                            var r = 1 - Math.abs(k / M),
                                n = 1 - (1 - b(l)) * r;
                            P.hasClass("popup")
                                ? P.hasClass("popup-push")
                                    ? P.transition(0).forEach(function (e) {
                                          e.style.setProperty(
                                              "transform",
                                              "translate3d(0, calc(-1 * " +
                                                  r +
                                                  " * (var(--f7-popup-push-offset) + 10px)) , 0px) scale(" +
                                                  n +
                                                  ")",
                                              "important"
                                          );
                                      })
                                    : P.transition(0).forEach(function (e) {
                                          e.style.setProperty(
                                              "transform",
                                              "translate3d(0, 0px , 0px) scale(" +
                                                  n +
                                                  ")",
                                              "important"
                                          );
                                      })
                                : P.transition(0).forEach(function (e) {
                                      e.style.setProperty(
                                          "transform",
                                          "translate3d(0,0,0) scale(" + n + ")",
                                          "important"
                                      );
                                  });
                        }
                        i.transition(0).transform(
                            "translate3d(0," + -k + "px,0)"
                        );
                    }
                }
                function R() {
                    if (((I = !1), B)) {
                        d.emit("local::swipeEnd popupSwipeEnd", d),
                            d.$el.trigger("popup:swipeend"),
                            (B = !1),
                            (O = !1),
                            i.transition(""),
                            c && l && P.transition("").transform("");
                        var e = k <= 0 ? "to-bottom" : "to-top";
                        if (
                            "string" == typeof d.params.swipeToClose &&
                            e !== d.params.swipeToClose
                        )
                            return i.transform(""), void (O = !0);
                        var t = Math.abs(k),
                            a = new Date().getTime() - E;
                        (a < 300 && t > 20) || (a >= 300 && t > 100)
                            ? je(function () {
                                  "to-bottom" === e
                                      ? i.addClass("swipe-close-to-bottom")
                                      : i.addClass("swipe-close-to-top"),
                                      i.transform(""),
                                      d.emit(
                                          "local::swipeclose popupSwipeClose",
                                          d
                                      ),
                                      d.$el.trigger("popup:swipeclose"),
                                      d.close(),
                                      (O = !0);
                              })
                            : ((O = !0), i.transform(""));
                    }
                }
                var A,
                    D = !!f.passiveListener && { passive: !0 };
                d.params.swipeToClose &&
                    (i.on(t.touchEvents.start, L, D),
                    t.on("touchmove", z),
                    t.on("touchend:passive", R),
                    d.once("popupDestroy", function () {
                        i.off(t.touchEvents.start, L, D),
                            t.off("touchmove", z),
                            t.off("touchend:passive", R);
                    }));
                var H = function () {
                        var e = c;
                        d.push &&
                            (c =
                                d.push &&
                                (t.width < 630 ||
                                    t.height < 630 ||
                                    i.hasClass("popup-tablet-fullscreen"))),
                            c && !e
                                ? N()
                                : c && e
                                ? d.$htmlEl[0].style.setProperty(
                                      "--f7-popup-push-scale",
                                      b(l)
                                  )
                                : !c &&
                                  e &&
                                  (d.$htmlEl.removeClass(
                                      "with-modal-popup-push"
                                  ),
                                  d.$htmlEl[0].style.removeProperty(
                                      "--f7-popup-push-scale"
                                  ));
                    },
                    N = function () {
                        t.off("resize", H),
                            d.push &&
                                (c =
                                    d.push &&
                                    (t.width < 630 ||
                                        t.height < 630 ||
                                        i.hasClass("popup-tablet-fullscreen"))),
                            c &&
                                ((l = parseInt(
                                    i.css("--f7-popup-push-offset"),
                                    10
                                )),
                                Number.isNaN(l) && (l = 0),
                                l &&
                                    (i.addClass("popup-push"),
                                    d.$htmlEl.addClass("with-modal-popup-push"),
                                    d.$htmlEl[0].style.setProperty(
                                        "--f7-popup-push-scale",
                                        b(l)
                                    ))),
                            t.on("resize", H);
                    };
                return (
                    d.on("open", function () {
                        (A = !1),
                            d.params.closeOnEscape && Ee(h).on("keydown", g),
                            i
                                .prevAll(".popup.modal-in")
                                .addClass("popup-behind"),
                            N();
                    }),
                    d.on("opened", function () {
                        i.removeClass(
                            "swipe-close-to-bottom swipe-close-to-top"
                        ),
                            d.params.closeByBackdropClick && t.on("click", m);
                    }),
                    d.on("close", function () {
                        (A = d.$el.prevAll(".popup-push.modal-in").length > 0),
                            d.params.closeOnEscape && Ee(h).off("keydown", g),
                            d.params.closeByBackdropClick && t.off("click", m),
                            i
                                .prevAll(".popup.modal-in")
                                .eq(0)
                                .removeClass("popup-behind"),
                            c &&
                                l &&
                                !A &&
                                (d.$htmlEl.removeClass("with-modal-popup-push"),
                                d.$htmlEl.addClass(
                                    "with-modal-popup-push-closing"
                                )),
                            t.off("resize", H);
                    }),
                    d.on("closed", function () {
                        i.removeClass("popup-behind"),
                            c &&
                                l &&
                                !A &&
                                (d.$htmlEl.removeClass(
                                    "with-modal-popup-push-closing"
                                ),
                                d.$htmlEl[0].style.removeProperty(
                                    "--f7-popup-push-scale"
                                ));
                    }),
                    (i[0].f7Modal = d),
                    d || ze(n)
                );
            }
            return Me(t, e), t;
        })(or),
        ur = {
            name: "popup",
            params: {
                popup: {
                    backdrop: !0,
                    backdropEl: void 0,
                    closeByBackdropClick: !0,
                    closeOnEscape: !1,
                    swipeToClose: !1,
                    swipeHandler: null,
                    push: !1,
                    containerEl: null,
                },
            },
            static: { Popup: dr },
            create: function () {
                this.popup = ft({
                    app: this,
                    constructor: dr,
                    defaultSelector: ".popup.modal-in",
                    parentSelector: ".popup",
                });
            },
            clicks: {
                ".popup-open": function (e, t) {
                    void 0 === t && (t = {});
                    this.popup.open(t.popup, t.animate, e);
                },
                ".popup-close": function (e, t) {
                    void 0 === t && (t = {});
                    this.popup.close(t.popup, t.animate, e);
                },
            },
        },
        hr = (function (e) {
            function t(t, a) {
                var r,
                    n,
                    o = Qe({ on: {} }, a),
                    i = ze((r = e.call(this, t, o) || this));
                return (
                    (i.params = o),
                    (n = i.params.el
                        ? Ee(i.params.el).eq(0)
                        : Ee(i.params.content)
                              .filter(function (e) {
                                  return 1 === e.nodeType;
                              })
                              .eq(0)) &&
                    n.length > 0 &&
                    n[0].f7Modal
                        ? n[0].f7Modal || ze(r)
                        : 0 === n.length
                        ? i.destroy() || ze(r)
                        : (Qe(i, {
                              app: t,
                              $el: n,
                              el: n[0],
                              type: "loginScreen",
                          }),
                          (n[0].f7Modal = i),
                          i || ze(r))
                );
            }
            return Me(t, e), t;
        })(or),
        fr = {
            name: "loginScreen",
            static: { LoginScreen: hr },
            create: function () {
                this.loginScreen = ft({
                    app: this,
                    constructor: hr,
                    defaultSelector: ".login-screen.modal-in",
                });
            },
            clicks: {
                ".login-screen-open": function (e, t) {
                    void 0 === t && (t = {});
                    this.loginScreen.open(t.loginScreen, t.animate, e);
                },
                ".login-screen-close": function (e, t) {
                    void 0 === t && (t = {});
                    this.loginScreen.close(t.loginScreen, t.animate, e);
                },
            },
        },
        vr = (function (e) {
            function t(t, a) {
                var n,
                    i,
                    s = Qe({ on: {} }, t.params.popover, a),
                    l = ze((n = e.call(this, t, s) || this)),
                    c = pt(),
                    p = o(),
                    d = r();
                if (
                    ((l.params = s),
                    (i = l.params.el
                        ? Ee(l.params.el).eq(0)
                        : Ee(l.params.content)
                              .filter(function (e) {
                                  return 1 === e.nodeType;
                              })
                              .eq(0)) &&
                        i.length > 0 &&
                        i[0].f7Modal)
                )
                    return i[0].f7Modal || ze(n);
                var u,
                    h,
                    f = Ee(l.params.targetEl).eq(0);
                if (0 === i.length) return l.destroy() || ze(n);
                l.params.backdrop && l.params.backdropEl
                    ? (u = Ee(l.params.backdropEl))
                    : l.params.backdrop &&
                      0 ===
                          (u = l.$containerEl.children(".popover-backdrop"))
                              .length &&
                      ((u = Ee('<div class="popover-backdrop"></div>')),
                      l.$containerEl.append(u)),
                    0 === i.find(".popover-angle").length
                        ? ((h = Ee('<div class="popover-angle"></div>')),
                          i.prepend(h))
                        : (h = i.find(".popover-angle"));
                var v = l.open;
                function m() {
                    l.resize();
                }
                Qe(l, {
                    app: t,
                    $el: i,
                    el: i[0],
                    $targetEl: f,
                    targetEl: f[0],
                    $angleEl: h,
                    angleEl: h[0],
                    $backdropEl: u,
                    backdropEl: u && u[0],
                    type: "popover",
                    open: function () {
                        for (
                            var e = arguments.length, t = new Array(e), a = 0;
                            a < e;
                            a++
                        )
                            t[a] = arguments[a];
                        var r = t[0],
                            n = t[1];
                        return (
                            "boolean" == typeof t[0] &&
                                ((n = t[0]), (r = t[1])),
                            r &&
                                ((l.$targetEl = Ee(r)),
                                (l.targetEl = l.$targetEl[0])),
                            v.call(l, n)
                        );
                    },
                }),
                    l.on("popoverOpen", function () {
                        l.resize(),
                            t.on("resize", m),
                            Ee(p).on("keyboardDidShow keyboardDidHide", m),
                            l.on(
                                "popoverClose popoverBeforeDestroy",
                                function () {
                                    t.off("resize", m),
                                        Ee(p).off(
                                            "keyboardDidShow keyboardDidHide",
                                            m
                                        );
                                }
                            );
                    });
                var g = null;
                function b(e) {
                    g = e.target;
                }
                function y(e) {
                    var t = e.target,
                        a = Ee(t);
                    (!c.desktop &&
                        c.cordova &&
                        ((p.Keyboard && p.Keyboard.isVisible) ||
                            (p.cordova.plugins &&
                                p.cordova.plugins.Keyboard &&
                                p.cordova.plugins.Keyboard.isVisible))) ||
                        (0 === a.closest(l.el).length &&
                            ((l.params.closeByBackdropClick &&
                                l.params.backdrop &&
                                l.backdropEl &&
                                l.backdropEl === t &&
                                g === t) ||
                                (l.params.closeByOutsideClick && g === t)) &&
                            l.close());
                }
                function w(e) {
                    27 === e.keyCode && l.params.closeOnEscape && l.close();
                }
                return (
                    l.params.closeOnEscape &&
                        (l.on("popoverOpen", function () {
                            Ee(d).on("keydown", w);
                        }),
                        l.on("popoverClose", function () {
                            Ee(d).off("keydown", w);
                        })),
                    l.on("popoverOpened", function () {
                        (l.params.closeByOutsideClick ||
                            l.params.closeByBackdropClick) &&
                            (t.on("touchstart", b), t.on("click", y));
                    }),
                    l.on("popoverClose", function () {
                        (l.params.closeByOutsideClick ||
                            l.params.closeByBackdropClick) &&
                            (t.off("touchstart", b), t.off("click", y));
                    }),
                    (i[0].f7Modal = l),
                    l || ze(n)
                );
            }
            return (
                Me(t, e),
                (t.prototype.resize = function () {
                    var e = this,
                        t = e.app,
                        a = e.$el,
                        r = e.$targetEl,
                        n = e.$angleEl,
                        o = e.params,
                        i = o.targetX,
                        s = o.targetY;
                    a.css({ left: "", top: "" });
                    var l,
                        c,
                        p,
                        d,
                        u,
                        h,
                        f = [a.width(), a.height()],
                        v = f[0],
                        m = f[1],
                        g = 0;
                    "ios" === t.theme || "aurora" === t.theme
                        ? (n
                              .removeClass("on-left on-right on-top on-bottom")
                              .css({ left: "", top: "" }),
                          (g = n.width() / 2))
                        : a
                              .removeClass(
                                  "popover-on-left popover-on-right popover-on-top popover-on-bottom popover-on-middle"
                              )
                              .css({ left: "", top: "" });
                    var b = parseInt(Ee("html").css("--f7-safe-area-top"), 10),
                        y = parseInt(Ee("html").css("--f7-safe-area-left"), 10),
                        w = parseInt(
                            Ee("html").css("--f7-safe-area-right"),
                            10
                        );
                    if (
                        (Number.isNaN(b) && (b = 0),
                        Number.isNaN(y) && (y = 0),
                        Number.isNaN(w) && (w = 0),
                        r && r.length > 0)
                    ) {
                        (p = r.outerWidth()), (d = r.outerHeight());
                        var C = r.offset();
                        (u = C.left - t.left), (h = C.top - t.top);
                        var E = r.parents(".page");
                        E.length > 0 && (h -= E[0].scrollTop);
                    } else
                        void 0 !== i &&
                            "undefined" !== s &&
                            ((u = i),
                            (h = s),
                            (p = e.params.targetWidth || 0),
                            (d = e.params.targetHeight || 0));
                    var k,
                        x = 0,
                        $ = 0,
                        T = 0,
                        S = "md" === t.theme ? "bottom" : "top";
                    "md" === t.theme
                        ? (m < t.height - h - d
                              ? ((S = "bottom"), ($ = h + d))
                              : m < h - b
                              ? (($ = h - m), (S = "top"))
                              : ((S = "middle"), ($ = d / 2 + h - m / 2)),
                          ($ = Math.max(8, Math.min($, t.height - m - 8))),
                          u < t.width / 2
                              ? ((k = "right"),
                                (x = "middle" === S ? u + p : u))
                              : ((k = "left"),
                                (x = "middle" === S ? u - v : u + p - v)),
                          (x = Math.max(
                              8,
                              Math.min(x, t.width - v - 8 - w),
                              y
                          )),
                          a.addClass("popover-on-" + S + " popover-on-" + k))
                        : (m + g < h - b
                              ? ($ = h - m - g)
                              : m + g < t.height - h - d
                              ? ((S = "bottom"), ($ = h + d + g))
                              : ((S = "middle"),
                                (T = $ = d / 2 + h - m / 2),
                                (T -= $ =
                                    Math.max(
                                        5,
                                        Math.min($, t.height - m - 5)
                                    ))),
                          "top" === S || "bottom" === S
                              ? ((T = x = p / 2 + u - v / 2),
                                (x = Math.max(5, Math.min(x, t.width - v - 5))),
                                y && (x = Math.max(x, y)),
                                w &&
                                    x + v > t.width - 5 - w &&
                                    (x = t.width - 5 - w - v),
                                "top" === S && n.addClass("on-bottom"),
                                "bottom" === S && n.addClass("on-top"),
                                (l = v / 2 - g + (T -= x)),
                                (l = Math.max(Math.min(l, v - 2 * g - 13), 13)),
                                n.css({ left: l + "px" }))
                              : "middle" === S &&
                                ((x = u - v - g),
                                n.addClass("on-right"),
                                (x < 5 || x + v + w > t.width || x < y) &&
                                    (x < 5 && (x = u + p + g),
                                    x + v + w > t.width &&
                                        (x = t.width - v - 5 - w),
                                    x < y && (x = y),
                                    n
                                        .removeClass("on-right")
                                        .addClass("on-left")),
                                (c = m / 2 - g + T),
                                (c = Math.max(Math.min(c, m - 2 * g - 13), 13)),
                                n.css({ top: c + "px" })));
                    a.css({ top: $ + "px", left: x + "px" });
                }),
                t
            );
        })(or),
        mr = {
            name: "popover",
            params: {
                popover: {
                    backdrop: !0,
                    backdropEl: void 0,
                    closeByBackdropClick: !0,
                    closeByOutsideClick: !0,
                    closeOnEscape: !1,
                    containerEl: null,
                },
            },
            static: { Popover: vr },
            create: function () {
                var e = this;
                e.popover = Qe(
                    ft({
                        app: e,
                        constructor: vr,
                        defaultSelector: ".popover.modal-in",
                    }),
                    {
                        open: function (t, a, r) {
                            var n = Ee(t);
                            if (n.length > 1) {
                                var o = Ee(a).parents(".page");
                                o.length &&
                                    n.each(function (e) {
                                        var t = Ee(e);
                                        t.parents(o)[0] === o[0] && (n = t);
                                    });
                            }
                            n.length > 1 && (n = n.eq(n.length - 1));
                            var i = n[0].f7Modal,
                                s = n.dataset();
                            return (
                                i ||
                                    (i = new vr(
                                        e,
                                        Object.assign({ el: n, targetEl: a }, s)
                                    )),
                                i.open(a, r)
                            );
                        },
                    }
                );
            },
            clicks: {
                ".popover-open": function (e, t) {
                    void 0 === t && (t = {});
                    this.popover.open(t.popover, e, t.animate);
                },
                ".popover-close": function (e, t) {
                    void 0 === t && (t = {});
                    this.popover.close(t.popover, t.animate, e);
                },
            },
        },
        gr = (function (e) {
            function t(t, a) {
                var n,
                    i,
                    s,
                    l,
                    c = Qe({ on: {} }, t.params.actions, a),
                    p = ze((n = e.call(this, t, c) || this)),
                    d = pt(),
                    u = o(),
                    h = r();
                if (
                    ((p.params = c),
                    p.params.buttons &&
                        ((i = p.params.buttons),
                        Array.isArray(i[0]) || (i = [i])),
                    (p.groups = i),
                    p.params.el
                        ? (s = Ee(p.params.el).eq(0))
                        : p.params.content
                        ? (s = Ee(p.params.content)
                              .filter(function (e) {
                                  return 1 === e.nodeType;
                              })
                              .eq(0))
                        : p.params.buttons &&
                          (p.params.convertToPopover &&
                              (p.popoverHtml = p.renderPopover()),
                          (p.actionsHtml = p.render())),
                    s && s.length > 0 && s[0].f7Modal)
                )
                    return s[0].f7Modal || ze(n);
                if (s && 0 === s.length && !p.actionsHtml && !p.popoverHtml)
                    return p.destroy() || ze(n);
                p.params.backdrop && p.params.backdropEl
                    ? (l = Ee(p.params.backdropEl))
                    : p.params.backdrop &&
                      0 ===
                          (l = p.$containerEl.children(".actions-backdrop"))
                              .length &&
                      ((l = Ee('<div class="actions-backdrop"></div>')),
                      p.$containerEl.append(l));
                var f,
                    v = p.open,
                    m = p.close;
                function g(e) {
                    var t,
                        a,
                        r = Ee(this);
                    if (
                        (r.hasClass("list-button") || r.hasClass("item-link")
                            ? ((t = r.parents("li").index()),
                              (a = r.parents(".list").index()))
                            : ((t = r.index()),
                              (a = r.parents(".actions-group").index())),
                        void 0 !== i)
                    ) {
                        var n = i[a][t];
                        n.onClick && n.onClick(p, e),
                            p.params.onClick && p.params.onClick(p, e),
                            !1 !== n.close && p.close();
                    }
                }
                function b(e) {
                    var t = e.target,
                        a = Ee(t);
                    (!d.desktop &&
                        d.cordova &&
                        ((u.Keyboard && u.Keyboard.isVisible) ||
                            (u.cordova.plugins &&
                                u.cordova.plugins.Keyboard &&
                                u.cordova.plugins.Keyboard.isVisible))) ||
                        (0 === a.closest(p.el).length &&
                            ((p.params.closeByBackdropClick &&
                                p.params.backdrop &&
                                p.backdropEl &&
                                p.backdropEl === t) ||
                                p.params.closeByOutsideClick) &&
                            p.close());
                }
                function y(e) {
                    27 === e.keyCode && p.params.closeOnEscape && p.close();
                }
                return (
                    (p.open = function (e) {
                        var a = !1,
                            r = p.params,
                            n = r.targetEl,
                            o = r.targetX,
                            i = r.targetY,
                            s = r.targetWidth,
                            l = r.targetHeight;
                        return (
                            p.params.convertToPopover &&
                                (n || (void 0 !== o && void 0 !== i)) &&
                                (p.params.forceToPopover ||
                                    (d.ios && d.ipad) ||
                                    t.width >= 768 ||
                                    (d.desktop && "aurora" === t.theme)) &&
                                (a = !0),
                            a && p.popoverHtml
                                ? ((f = t.popover.create({
                                      containerEl: p.params.containerEl,
                                      content: p.popoverHtml,
                                      backdrop: p.params.backdrop,
                                      targetEl: n,
                                      targetX: o,
                                      targetY: i,
                                      targetWidth: s,
                                      targetHeight: l,
                                      on: {
                                          open: function () {
                                              p.$el || (p.$el = f.$el),
                                                  p.$el.trigger(
                                                      "modal:open " +
                                                          p.type.toLowerCase() +
                                                          ":open"
                                                  ),
                                                  p.emit(
                                                      "local::open modalOpen " +
                                                          p.type +
                                                          "Open",
                                                      p
                                                  );
                                          },
                                          opened: function () {
                                              p.$el || (p.$el = f.$el),
                                                  p.$el.trigger(
                                                      "modal:opened " +
                                                          p.type.toLowerCase() +
                                                          ":opened"
                                                  ),
                                                  p.emit(
                                                      "local::opened modalOpened " +
                                                          p.type +
                                                          "Opened",
                                                      p
                                                  );
                                          },
                                          close: function () {
                                              p.$el || (p.$el = f.$el),
                                                  p.$el.trigger(
                                                      "modal:close " +
                                                          p.type.toLowerCase() +
                                                          ":close"
                                                  ),
                                                  p.emit(
                                                      "local::close modalClose " +
                                                          p.type +
                                                          "Close",
                                                      p
                                                  );
                                          },
                                          closed: function () {
                                              p.$el || (p.$el = f.$el),
                                                  p.$el.trigger(
                                                      "modal:closed " +
                                                          p.type.toLowerCase() +
                                                          ":closed"
                                                  ),
                                                  p.emit(
                                                      "local::closed modalClosed " +
                                                          p.type +
                                                          "Closed",
                                                      p
                                                  );
                                          },
                                      },
                                  })).open(e),
                                  f.once("popoverOpened", function () {
                                      f.$el
                                          .find(".list-button, .item-link")
                                          .each(function (e) {
                                              Ee(e).on("click", g);
                                          });
                                  }),
                                  f.once("popoverClosed", function () {
                                      f.$el
                                          .find(".list-button, .item-link")
                                          .each(function (e) {
                                              Ee(e).off("click", g);
                                          }),
                                          je(function () {
                                              f.destroy(), (f = void 0);
                                          });
                                  }))
                                : ((p.$el = p.actionsHtml
                                      ? Ee(p.actionsHtml)
                                      : p.$el),
                                  (p.$el[0].f7Modal = p),
                                  p.groups &&
                                      (p.$el
                                          .find(".actions-button")
                                          .each(function (e) {
                                              Ee(e).on("click", g);
                                          }),
                                      p.once("actionsClosed", function () {
                                          p.$el
                                              .find(".actions-button")
                                              .each(function (e) {
                                                  Ee(e).off("click", g);
                                              });
                                      })),
                                  (p.el = p.$el[0]),
                                  v.call(p, e)),
                            p
                        );
                    }),
                    (p.close = function (e) {
                        return f ? f.close(e) : m.call(p, e), p;
                    }),
                    Qe(p, {
                        app: t,
                        $el: s,
                        el: s ? s[0] : void 0,
                        $backdropEl: l,
                        backdropEl: l && l[0],
                        type: "actions",
                    }),
                    p.params.closeOnEscape &&
                        (p.on("open", function () {
                            Ee(h).on("keydown", y);
                        }),
                        p.on("close", function () {
                            Ee(h).off("keydown", y);
                        })),
                    p.on("opened", function () {
                        (p.params.closeByBackdropClick ||
                            p.params.closeByOutsideClick) &&
                            t.on("click", b);
                    }),
                    p.on("close", function () {
                        (p.params.closeByBackdropClick ||
                            p.params.closeByOutsideClick) &&
                            t.off("click", b);
                    }),
                    s && (s[0].f7Modal = p),
                    p || ze(n)
                );
            }
            Me(t, e);
            var a = t.prototype;
            return (
                (a.render = function () {
                    var e = this;
                    if (e.params.render) return e.params.render.call(e, e);
                    var t = e.groups,
                        a = e.params.cssClass;
                    return lr(
                        "div",
                        {
                            class:
                                "actions-modal" +
                                (e.params.grid ? " actions-grid" : "") +
                                " " +
                                (a || ""),
                        },
                        t.map(function (e) {
                            return lr(
                                "div",
                                { class: "actions-group" },
                                e.map(function (e) {
                                    var t = [
                                            "actions-" +
                                                (e.label ? "label" : "button"),
                                        ],
                                        a = e.color,
                                        r = e.bg,
                                        n = e.bold,
                                        o = e.disabled,
                                        i = e.label,
                                        s = e.text,
                                        l = e.icon;
                                    return (
                                        a && t.push("color-" + a),
                                        r && t.push("bg-color-" + r),
                                        n && t.push("actions-button-bold"),
                                        o && t.push("disabled"),
                                        i
                                            ? lr(
                                                  "div",
                                                  { class: t.join(" ") },
                                                  s
                                              )
                                            : lr(
                                                  "div",
                                                  { class: t.join(" ") },
                                                  l &&
                                                      lr(
                                                          "div",
                                                          {
                                                              class: "actions-button-media",
                                                          },
                                                          l
                                                      ),
                                                  lr(
                                                      "div",
                                                      {
                                                          class: "actions-button-text",
                                                      },
                                                      s
                                                  )
                                              )
                                    );
                                })
                            );
                        })
                    );
                }),
                (a.renderPopover = function () {
                    var e = this;
                    if (e.params.renderPopover)
                        return e.params.renderPopover.call(e, e);
                    var t = e.groups,
                        a = e.params.cssClass;
                    return lr(
                        "div",
                        { class: "popover popover-from-actions " + (a || "") },
                        lr(
                            "div",
                            { class: "popover-inner" },
                            t.map(function (e) {
                                return lr(
                                    "div",
                                    { class: "list" },
                                    lr(
                                        "ul",
                                        null,
                                        e.map(function (e) {
                                            var t = [],
                                                a = e.color,
                                                r = e.bg,
                                                n = e.bold,
                                                o = e.disabled,
                                                i = e.label,
                                                s = e.text,
                                                l = e.icon;
                                            return (
                                                a && t.push("color-" + a),
                                                r && t.push("bg-color-" + r),
                                                n &&
                                                    t.push(
                                                        "popover-from-actions-bold"
                                                    ),
                                                o && t.push("disabled"),
                                                i
                                                    ? (t.push(
                                                          "popover-from-actions-label"
                                                      ),
                                                      '<li class="' +
                                                          t.join(" ") +
                                                          '">' +
                                                          s +
                                                          "</li>")
                                                    : l
                                                    ? (t.push(
                                                          "item-link item-content"
                                                      ),
                                                      lr(
                                                          "li",
                                                          null,
                                                          lr(
                                                              "a",
                                                              {
                                                                  class: t.join(
                                                                      " "
                                                                  ),
                                                              },
                                                              lr(
                                                                  "div",
                                                                  {
                                                                      class: "item-media",
                                                                  },
                                                                  l
                                                              ),
                                                              lr(
                                                                  "div",
                                                                  {
                                                                      class: "item-inner",
                                                                  },
                                                                  lr(
                                                                      "div",
                                                                      {
                                                                          class: "item-title",
                                                                      },
                                                                      s
                                                                  )
                                                              )
                                                          )
                                                      ))
                                                    : (t.push("list-button"),
                                                      lr(
                                                          "li",
                                                          null,
                                                          lr(
                                                              "a",
                                                              {
                                                                  class: t.join(
                                                                      " "
                                                                  ),
                                                              },
                                                              s
                                                          )
                                                      ))
                                            );
                                        })
                                    )
                                );
                            })
                        )
                    );
                }),
                t
            );
        })(or),
        br = {
            name: "actions",
            params: {
                actions: {
                    convertToPopover: !0,
                    forceToPopover: !1,
                    backdrop: !0,
                    backdropEl: void 0,
                    cssClass: null,
                    closeByBackdropClick: !0,
                    closeOnEscape: !1,
                    render: null,
                    renderPopover: null,
                    containerEl: null,
                },
            },
            static: { Actions: gr },
            create: function () {
                this.actions = ft({
                    app: this,
                    constructor: gr,
                    defaultSelector: ".actions-modal.modal-in",
                });
            },
            clicks: {
                ".actions-open": function (e, t) {
                    void 0 === t && (t = {});
                    this.actions.open(t.actions, t.animate, e);
                },
                ".actions-close": function (e, t) {
                    void 0 === t && (t = {});
                    this.actions.close(t.actions, t.animate, e);
                },
            },
        },
        yr = (function (e) {
            function t(t, a) {
                var n,
                    i,
                    s,
                    l,
                    c,
                    p = Qe({ on: {} }, t.params.sheet, a),
                    d = ze((n = e.call(this, t, p) || this)),
                    u = o(),
                    h = r(),
                    f = ct(),
                    v = pt();
                if (
                    ((d.params = p),
                    void 0 === d.params.backdrop &&
                        (d.params.backdrop = "ios" !== t.theme),
                    (i = d.params.el
                        ? Ee(d.params.el).eq(0)
                        : Ee(d.params.content)
                              .filter(function (e) {
                                  return 1 === e.nodeType;
                              })
                              .eq(0)) &&
                        i.length > 0 &&
                        i[0].f7Modal)
                )
                    return i[0].f7Modal || ze(n);
                if (0 === i.length) return d.destroy() || ze(n);
                function m(e) {
                    var t = e.target,
                        a = Ee(t);
                    (!v.desktop &&
                        v.cordova &&
                        ((u.Keyboard && u.Keyboard.isVisible) ||
                            (u.cordova.plugins &&
                                u.cordova.plugins.Keyboard &&
                                u.cordova.plugins.Keyboard.isVisible))) ||
                        (0 === a.closest(d.el).length &&
                            ((d.params.closeByBackdropClick &&
                                d.params.backdrop &&
                                d.backdropEl &&
                                d.backdropEl === t) ||
                                d.params.closeByOutsideClick) &&
                            d.close());
                }
                function g(e) {
                    27 === e.keyCode && d.params.closeOnEscape && d.close();
                }
                function b(e) {
                    return (t.height - 2 * e) / t.height;
                }
                d.params.backdrop && d.params.backdropEl
                    ? (s = Ee(d.params.backdropEl))
                    : d.params.backdrop &&
                      0 ===
                          (s = d.$containerEl.children(".sheet-backdrop"))
                              .length &&
                      ((s = Ee('<div class="sheet-backdrop"></div>')),
                      d.$containerEl.append(s)),
                    Qe(d, {
                        app: t,
                        push: i.hasClass("sheet-modal-push") || d.params.push,
                        $el: i,
                        el: i[0],
                        $backdropEl: s,
                        backdropEl: s && s[0],
                        type: "sheet",
                        $htmlEl: Ee("html"),
                    }),
                    d.params.push && i.addClass("sheet-modal-push");
                var y,
                    w,
                    C,
                    E,
                    k,
                    x,
                    $,
                    T,
                    S,
                    M,
                    P,
                    O,
                    I,
                    B,
                    L,
                    z,
                    R,
                    A,
                    D = !1,
                    H = !1;
                function N(e) {
                    D ||
                        (!d.params.swipeToClose && !d.params.swipeToStep) ||
                        (d.params.swipeHandler &&
                            0 ===
                                Ee(e.target).closest(d.params.swipeHandler)
                                    .length) ||
                        ((D = !0),
                        (H = !1),
                        (y = {
                            x:
                                "touchstart" === e.type
                                    ? e.targetTouches[0].pageX
                                    : e.pageX,
                            y:
                                "touchstart" === e.type
                                    ? e.targetTouches[0].pageY
                                    : e.pageY,
                        }),
                        (E = Ye()),
                        (C = void 0),
                        (x = i.hasClass("sheet-modal-top")),
                        d.params.swipeHandler ||
                            "touchstart" !== e.type ||
                            (L = Ee(e.target).closest(".page-content")[0]));
                }
                function V(e) {
                    if (D) {
                        if (
                            ((w = {
                                x:
                                    "touchmove" === e.type
                                        ? e.targetTouches[0].pageX
                                        : e.pageX,
                                y:
                                    "touchmove" === e.type
                                        ? e.targetTouches[0].pageY
                                        : e.pageY,
                            }),
                            void 0 === C &&
                                (C = !!(
                                    C ||
                                    Math.abs(w.x - y.x) > Math.abs(w.y - y.y)
                                )),
                            C)
                        )
                            return (D = !1), void (H = !1);
                        var a,
                            r = (k = y.y - w.y) < 0 ? "to-bottom" : "to-top";
                        if (!H) {
                            if (
                                L &&
                                !i.hasClass("modal-in-swipe-step") &&
                                ((z = L.scrollTop),
                                (R = L.scrollHeight),
                                (A = L.offsetHeight),
                                !(
                                    R === A ||
                                    ("to-bottom" === r && 0 === z) ||
                                    ("to-top" === r && z === R - A)
                                ))
                            )
                                return i.transform(""), (D = !1), void (H = !1);
                            d.push &&
                                c &&
                                (I = t.$el.children(".view, .views")),
                                (M = i[0].offsetHeight),
                                (T = Xe(i[0], "y")),
                                x
                                    ? ((P = d.params.swipeToClose ? -M : -$),
                                      (O = 0))
                                    : ((P = 0),
                                      (O = d.params.swipeToClose ? M : $)),
                                (H = !0);
                        }
                        if (
                            ((S = T - k),
                            (S = Math.min(Math.max(S, P), O)),
                            e.preventDefault(),
                            d.push && c)
                        ) {
                            var n = (S - T) / M;
                            d.params.swipeToStep &&
                                (n = x ? S / $ : 1 - ($ - S) / $),
                                (n = Math.abs(n));
                            var o = 1 - (n = Math.min(Math.max(n, 0), 1)),
                                s = 1 - (1 - b(c)) * o;
                            I.transition(0).forEach(function (e) {
                                e.style.setProperty(
                                    "transform",
                                    "translate3d(0,0,0) scale(" + s + ")",
                                    "important"
                                );
                            }),
                                d.params.swipeToStep &&
                                    I.css("border-radius", B * o + "px");
                        }
                        if (
                            (i
                                .transition(0)
                                .transform("translate3d(0," + S + "px,0)"),
                            d.params.swipeToStep)
                        )
                            (a = x ? 1 - S / $ : ($ - S) / $),
                                (a = Math.min(Math.max(a, 0), 1)),
                                i.trigger("sheet:stepprogress", a),
                                d.emit(
                                    "local::stepProgress sheetStepProgress",
                                    d,
                                    a
                                );
                    }
                }
                function F() {
                    if (((D = !1), H)) {
                        (H = !1),
                            i.transform("").transition(""),
                            d.push &&
                                c &&
                                (I.transition("").transform(""),
                                I.css("border-radius", ""));
                        var e = k < 0 ? "to-bottom" : "to-top",
                            t = Math.abs(k);
                        if (0 !== t && S !== T) {
                            var a = new Date().getTime() - E;
                            if (d.params.swipeToStep) {
                                var r = x ? "to-bottom" : "to-top",
                                    n = x ? "to-top" : "to-bottom",
                                    o = Math.abs(S),
                                    s = Math.abs($);
                                if (a < 300 && t > 10)
                                    return (
                                        e === r &&
                                            o < s &&
                                            (i.removeClass(
                                                "modal-in-swipe-step"
                                            ),
                                            i.trigger("sheet:stepprogress", 1),
                                            d.emit(
                                                "local::stepProgress sheetStepProgress",
                                                d,
                                                1
                                            ),
                                            d.emit("local::_swipeStep", !1),
                                            i.trigger("sheet:stepopen"),
                                            d.emit(
                                                "local::stepOpen sheetStepOpen",
                                                d
                                            ),
                                            d.push &&
                                                c &&
                                                (d.$htmlEl[0].style.setProperty(
                                                    "--f7-sheet-push-scale",
                                                    b(c)
                                                ),
                                                I.css("border-radius", ""))),
                                        e === n &&
                                            o > s &&
                                            (d.params.swipeToClose
                                                ? d.close()
                                                : (i.addClass(
                                                      "modal-in-swipe-step"
                                                  ),
                                                  i.trigger(
                                                      "sheet:stepprogress",
                                                      0
                                                  ),
                                                  d.emit(
                                                      "local::stepProgress sheetStepProgress",
                                                      d,
                                                      0
                                                  ),
                                                  d.emit(
                                                      "local::_swipeStep",
                                                      !0
                                                  ),
                                                  i.trigger("sheet:stepclose"),
                                                  d.emit(
                                                      "local::stepClose sheetStepClose",
                                                      d
                                                  ),
                                                  d.push &&
                                                      c &&
                                                      (d.$htmlEl[0].style.removeProperty(
                                                          "--f7-sheet-push-scale"
                                                      ),
                                                      I.css(
                                                          "border-radius",
                                                          "0px"
                                                      )))),
                                        void (
                                            e === n &&
                                            o <= s &&
                                            (i.addClass("modal-in-swipe-step"),
                                            i.trigger("sheet:stepprogress", 0),
                                            d.emit(
                                                "local::stepProgress sheetStepProgress",
                                                d,
                                                0
                                            ),
                                            d.emit("local::_swipeStep", !0),
                                            i.trigger("sheet:stepclose"),
                                            d.emit(
                                                "local::stepClose sheetStepClose",
                                                d
                                            ),
                                            d.push &&
                                                c &&
                                                (d.$htmlEl[0].style.removeProperty(
                                                    "--f7-sheet-push-scale"
                                                ),
                                                I.css("border-radius", "0px")))
                                        )
                                    );
                                if (a >= 300) {
                                    var l = !i.hasClass("modal-in-swipe-step");
                                    l
                                        ? l &&
                                          (o > s + (M - s) / 2
                                              ? d.params.swipeToClose &&
                                                d.close()
                                              : o > s / 2 &&
                                                (i.addClass(
                                                    "modal-in-swipe-step"
                                                ),
                                                i.trigger(
                                                    "sheet:stepprogress",
                                                    0
                                                ),
                                                d.emit(
                                                    "local::stepProgress sheetStepProgress",
                                                    d,
                                                    0
                                                ),
                                                d.emit("local::_swipeStep", !0),
                                                i.trigger("sheet:stepclose"),
                                                d.emit(
                                                    "local::stepClose sheetStepClose",
                                                    d
                                                ),
                                                d.push &&
                                                    c &&
                                                    (d.$htmlEl[0].style.removeProperty(
                                                        "--f7-sheet-push-scale"
                                                    ),
                                                    I.css(
                                                        "border-radius",
                                                        "0px"
                                                    ))))
                                        : o < s / 2
                                        ? (i.removeClass("modal-in-swipe-step"),
                                          i.trigger("sheet:stepprogress", 1),
                                          d.emit(
                                              "local::stepProgress sheetStepProgress",
                                              d,
                                              1
                                          ),
                                          d.emit("local::_swipeStep", !1),
                                          i.trigger("sheet:stepopen"),
                                          d.emit(
                                              "local::stepOpen sheetStepOpen",
                                              d
                                          ),
                                          d.push &&
                                              c &&
                                              (d.$htmlEl[0].style.setProperty(
                                                  "--f7-sheet-push-scale",
                                                  b(c)
                                              ),
                                              I.css("border-radius", "")))
                                        : o - s > (M - s) / 2 &&
                                          d.params.swipeToClose &&
                                          d.close();
                                }
                            } else {
                                if (e !== (x ? "to-top" : "to-bottom")) return;
                                ((a < 300 && t > 20) ||
                                    (a >= 300 && t > M / 2)) &&
                                    d.close();
                            }
                        }
                    }
                }
                function q() {
                    d.setSwipeStep(!0);
                }
                d.setSwipeStep = function (e) {
                    void 0 === e && (e = !0);
                    var t = i.find(".sheet-modal-swipe-step").eq(0);
                    t.length &&
                        (($ = i.hasClass("sheet-modal-top")
                            ? -(
                                  t.offset().top -
                                  i.offset().top +
                                  t[0].offsetHeight
                              )
                            : i[0].offsetHeight -
                              (t.offset().top -
                                  i.offset().top +
                                  t[0].offsetHeight)),
                        i[0].style.setProperty(
                            "--f7-sheet-swipe-step",
                            $ + "px"
                        ),
                        e ||
                            (i.addClass("modal-in-swipe-step"),
                            d.emit("local::_swipeStep", !0)));
                };
                var j = !!f.passiveListener && { passive: !0 };
                return (
                    (d.params.swipeToClose || d.params.swipeToStep) &&
                        (i.on(t.touchEvents.start, N, j),
                        t.on("touchmove", V),
                        t.on("touchend:passive", F),
                        d.once("sheetDestroy", function () {
                            i.off(t.touchEvents.start, N, j),
                                t.off("touchmove", V),
                                t.off("touchend:passive", F);
                        })),
                    d.on("open", function () {
                        d.params.closeOnEscape && Ee(h).on("keydown", g),
                            i
                                .prevAll(".popup.modal-in")
                                .addClass("popup-behind"),
                            d.params.swipeToStep &&
                                (d.setSwipeStep(!1), t.on("resize", q)),
                            d.params.scrollToEl &&
                                (function () {
                                    var e = Ee(d.params.scrollToEl).eq(0);
                                    if (
                                        0 !== e.length &&
                                        0 !==
                                            (l = e.parents(".page-content"))
                                                .length
                                    ) {
                                        var t,
                                            a = parseInt(
                                                l.css("padding-top"),
                                                10
                                            ),
                                            r = parseInt(
                                                l.css("padding-bottom"),
                                                10
                                            ),
                                            n =
                                                l[0].offsetHeight -
                                                a -
                                                i.height(),
                                            o =
                                                l[0].scrollHeight -
                                                a -
                                                i.height(),
                                            s = l.scrollTop(),
                                            c =
                                                e.offset().top -
                                                a +
                                                e[0].offsetHeight;
                                        if (c > n) {
                                            var p = s + c - n;
                                            p + n > o &&
                                                ((t = p + n - o + r),
                                                n === o && (t = i.height()),
                                                l.css({
                                                    "padding-bottom": t + "px",
                                                })),
                                                l.scrollTop(p, 300);
                                        }
                                    }
                                })(),
                            d.push &&
                                ((c = parseInt(
                                    i.css("--f7-sheet-push-offset"),
                                    10
                                )),
                                Number.isNaN(c) && (c = 0),
                                c &&
                                    (i.addClass("sheet-modal-push"),
                                    d.$htmlEl.addClass("with-modal-sheet-push"),
                                    d.params.swipeToStep
                                        ? ((I =
                                              t.$el.children(".view, .views")),
                                          (B = parseFloat(
                                              i.css(
                                                  "border-" +
                                                      (x ? "bottom" : "top") +
                                                      "-left-radius"
                                              )
                                          )),
                                          I.css("border-radius", "0px"))
                                        : d.$htmlEl[0].style.setProperty(
                                              "--f7-sheet-push-scale",
                                              b(c)
                                          )));
                    }),
                    d.on("opened", function () {
                        (d.params.closeByOutsideClick ||
                            d.params.closeByBackdropClick) &&
                            t.on("click", m);
                    }),
                    d.on("close", function () {
                        d.params.swipeToStep &&
                            (i.removeClass("modal-in-swipe-step"),
                            d.emit("local::_swipeStep", !1),
                            t.off("resize", q)),
                            d.params.closeOnEscape && Ee(h).off("keydown", g),
                            d.params.scrollToEl &&
                                l &&
                                l.length > 0 &&
                                l.css({ "padding-bottom": "" }),
                            (d.params.closeByOutsideClick ||
                                d.params.closeByBackdropClick) &&
                                t.off("click", m),
                            i
                                .prevAll(".popup.modal-in")
                                .eq(0)
                                .removeClass("popup-behind"),
                            d.push &&
                                c &&
                                (d.$htmlEl.removeClass("with-modal-sheet-push"),
                                d.$htmlEl.addClass(
                                    "with-modal-sheet-push-closing"
                                ));
                    }),
                    d.on("closed", function () {
                        d.push &&
                            c &&
                            (d.$htmlEl.removeClass(
                                "with-modal-sheet-push-closing"
                            ),
                            d.$htmlEl[0].style.removeProperty(
                                "--f7-sheet-push-scale"
                            ));
                    }),
                    (d.stepOpen = function () {
                        i.removeClass("modal-in-swipe-step"),
                            d.emit("local::_swipeStep", !1),
                            d.push &&
                                (c ||
                                    ((c = parseInt(
                                        i.css("--f7-sheet-push-offset"),
                                        10
                                    )),
                                    Number.isNaN(c) && (c = 0)),
                                c &&
                                    d.$htmlEl[0].style.setProperty(
                                        "--f7-sheet-push-scale",
                                        b(c)
                                    ));
                    }),
                    (d.stepClose = function () {
                        i.addClass("modal-in-swipe-step"),
                            d.emit("local::_swipeStep", !0),
                            d.push &&
                                d.$htmlEl[0].style.removeProperty(
                                    "--f7-sheet-push-scale"
                                );
                    }),
                    (d.stepToggle = function () {
                        i.toggleClass("modal-in-swipe-step"),
                            d.emit(
                                "local::_swipeStep",
                                i.hasClass("modal-in-swipe-step")
                            );
                    }),
                    (i[0].f7Modal = d),
                    d || ze(n)
                );
            }
            return Me(t, e), t;
        })(or),
        wr = {
            name: "sheet",
            params: {
                sheet: {
                    push: !1,
                    backdrop: void 0,
                    backdropEl: void 0,
                    closeByBackdropClick: !0,
                    closeByOutsideClick: !1,
                    closeOnEscape: !1,
                    swipeToClose: !1,
                    swipeToStep: !1,
                    swipeHandler: null,
                    containerEl: null,
                },
            },
            static: { Sheet: yr },
            create: function () {
                var e = this;
                e.sheet = Qe(
                    {},
                    ft({
                        app: e,
                        constructor: yr,
                        defaultSelector: ".sheet-modal.modal-in",
                    }),
                    {
                        stepOpen: function (t) {
                            var a = e.sheet.get(t);
                            if (a && a.stepOpen) return a.stepOpen();
                        },
                        stepClose: function (t) {
                            var a = e.sheet.get(t);
                            if (a && a.stepClose) return a.stepClose();
                        },
                        stepToggle: function (t) {
                            var a = e.sheet.get(t);
                            if (a && a.stepToggle) return a.stepToggle();
                        },
                    }
                );
            },
            clicks: {
                ".sheet-open": function (e, t) {
                    void 0 === t && (t = {});
                    Ee(".sheet-modal.modal-in").length > 0 &&
                        t.sheet &&
                        Ee(t.sheet)[0] !== Ee(".sheet-modal.modal-in")[0] &&
                        this.sheet.close(".sheet-modal.modal-in"),
                        this.sheet.open(t.sheet, t.animate, e);
                },
                ".sheet-close": function (e, t) {
                    void 0 === t && (t = {});
                    this.sheet.close(t.sheet, t.animate, e);
                },
            },
        },
        Cr = (function (e) {
            function t(t, a) {
                var r,
                    n = Qe({ on: {} }, t.params.toast, a),
                    i = ze((r = e.call(this, t, n) || this)),
                    s = o();
                (i.app = t), (i.params = n);
                var l,
                    c,
                    p = i.params,
                    d = p.closeButton,
                    u = p.closeTimeout;
                if (i.params.el) l = Ee(i.params.el);
                else {
                    var h = i.render();
                    l = Ee(h);
                }
                return l && l.length > 0 && l[0].f7Modal
                    ? l[0].f7Modal || ze(r)
                    : 0 === l.length
                    ? i.destroy() || ze(r)
                    : (Qe(i, { $el: l, el: l[0], type: "toast" }),
                      (l[0].f7Modal = i),
                      d &&
                          (l.find(".toast-button").on("click", function () {
                              i.emit(
                                  "local::closeButtonClick toastCloseButtonClick",
                                  i
                              ),
                                  i.close();
                          }),
                          i.on("beforeDestroy", function () {
                              l.find(".toast-button").off("click");
                          })),
                      i.on("open", function () {
                          Ee(".toast.modal-in").each(function (e) {
                              var a = t.toast.get(e);
                              e !== i.el && a && a.close();
                          }),
                              u &&
                                  (c = je(function () {
                                      i.close();
                                  }, u));
                      }),
                      i.on("close", function () {
                          s.clearTimeout(c);
                      }),
                      i.params.destroyOnClose &&
                          i.once("closed", function () {
                              setTimeout(function () {
                                  i.destroy();
                              }, 0);
                          }),
                      i || ze(r));
            }
            return (
                Me(t, e),
                (t.prototype.render = function () {
                    var e = this;
                    if (e.params.render) return e.params.render.call(e, e);
                    var t = e.params,
                        a = t.position,
                        r = t.horizontalPosition,
                        n = t.cssClass,
                        o = t.icon,
                        i = t.text,
                        s = t.closeButton,
                        l = t.closeButtonColor,
                        c = t.closeButtonText;
                    return lr(
                        "div",
                        {
                            class:
                                "toast toast-" +
                                a +
                                " " +
                                ("top" === a || "bottom" === a
                                    ? "toast-horizontal-" + r
                                    : "") +
                                " " +
                                (n || "") +
                                " " +
                                (o ? "toast-with-icon" : ""),
                        },
                        lr(
                            "div",
                            { class: "toast-content" },
                            o && lr("div", { class: "toast-icon" }, o),
                            lr("div", { class: "toast-text" }, i),
                            s &&
                                !o &&
                                lr(
                                    "a",
                                    {
                                        class:
                                            "toast-button button " +
                                            (l ? "color-" + l : ""),
                                    },
                                    c
                                )
                        )
                    );
                }),
                t
            );
        })(or),
        Er = {
            name: "toast",
            static: { Toast: Cr },
            create: function () {
                var e = this;
                e.toast = Qe(
                    {},
                    ft({
                        app: e,
                        constructor: Cr,
                        defaultSelector: ".toast.modal-in",
                    }),
                    {
                        show: function (t) {
                            return (
                                Qe(t, { destroyOnClose: !0 }),
                                new Cr(e, t).open()
                            );
                        },
                    }
                );
            },
            params: {
                toast: {
                    icon: null,
                    text: null,
                    position: "bottom",
                    horizontalPosition: "left",
                    closeButton: !1,
                    closeButtonColor: null,
                    closeButtonText: "Ok",
                    closeTimeout: null,
                    cssClass: null,
                    render: null,
                    containerEl: null,
                },
            },
        },
        kr = {
            init: function (e) {
                var t = {
                        iosPreloaderContent: He,
                        mdPreloaderContent: De,
                        auroraPreloaderContent: Ne,
                    },
                    a = Ee(e);
                0 === a.length ||
                    a.children(".preloader-inner").length > 0 ||
                    a.children(".preloader-inner-line").length > 0 ||
                    a.append(t[this.theme + "PreloaderContent"]);
            },
            visible: !1,
            show: function (e) {
                void 0 === e && (e = "white");
                if (!kr.visible) {
                    var t =
                        {
                            iosPreloaderContent: He,
                            mdPreloaderContent: De,
                            auroraPreloaderContent: Ne,
                        }[this.theme + "PreloaderContent"] || "";
                    Ee("html").addClass("with-modal-preloader"),
                        this.$el.append(
                            '\n      <div class="preloader-backdrop"></div>\n      <div class="preloader-modal">\n        <div class="preloader color-' +
                                e +
                                '">' +
                                t +
                                "</div>\n      </div>\n    "
                        ),
                        (kr.visible = !0);
                }
            },
            showIn: function (e, t) {
                void 0 === t && (t = "white");
                var a =
                    {
                        iosPreloaderContent: He,
                        mdPreloaderContent: De,
                        auroraPreloaderContent: Ne,
                    }[this.theme + "PreloaderContent"] || "";
                Ee(e || "html").addClass("with-modal-preloader"),
                    Ee(e || this.$el).append(
                        '\n      <div class="preloader-backdrop"></div>\n      <div class="preloader-modal">\n        <div class="preloader color-' +
                            t +
                            '">' +
                            a +
                            "</div>\n      </div>\n    "
                    );
            },
            hide: function () {
                kr.visible &&
                    (Ee("html").removeClass("with-modal-preloader"),
                    this.$el
                        .find(".preloader-backdrop, .preloader-modal")
                        .remove(),
                    (kr.visible = !1));
            },
            hideIn: function (e) {
                Ee(e || "html").removeClass("with-modal-preloader"),
                    Ee(e || this.$el)
                        .find(".preloader-backdrop, .preloader-modal")
                        .remove();
            },
        },
        xr = {
            name: "preloader",
            create: function () {
                nt(this, { preloader: kr });
            },
            on: {
                photoBrowserOpen: function (e) {
                    var t = this;
                    e.$el.find(".preloader").each(function (e) {
                        t.preloader.init(e);
                    });
                },
                tabMounted: function (e) {
                    var t = this;
                    Ee(e)
                        .find(".preloader")
                        .each(function (e) {
                            t.preloader.init(e);
                        });
                },
                pageInit: function (e) {
                    var t = this;
                    e.$el.find(".preloader").each(function (e) {
                        t.preloader.init(e);
                    });
                },
            },
            vnode: {
                preloader: {
                    insert: function (e) {
                        var t = e.elm;
                        this.preloader.init(t);
                    },
                },
            },
        },
        $r = {
            set: function () {
                for (
                    var e = this, t = arguments.length, a = new Array(t), r = 0;
                    r < t;
                    r++
                )
                    a[r] = arguments[r];
                var n = a[0],
                    o = a[1],
                    i = a[2];
                if (
                    ("number" == typeof a[0] &&
                        ((o = a[0]), (i = a[1]), (n = e.$el)),
                    null == o)
                )
                    return n;
                o || (o = 0);
                var s = Ee(n || e.$el);
                if (0 === s.length) return n;
                var l,
                    c = Math.min(Math.max(o, 0), 100);
                if (
                    0 ===
                        (l = s.hasClass("progressbar")
                            ? s.eq(0)
                            : s.children(".progressbar")).length ||
                    l.hasClass("progressbar-infinite")
                )
                    return l;
                var p = l.children("span");
                return (
                    0 === p.length && ((p = Ee("<span></span>")), l.append(p)),
                    p
                        .transition(void 0 !== i ? i : "")
                        .transform("translate3d(" + (-100 + c) + "%,0,0)"),
                    l[0]
                );
            },
            show: function () {
                for (
                    var e = this, t = arguments.length, a = new Array(t), r = 0;
                    r < t;
                    r++
                )
                    a[r] = arguments[r];
                var n = a[0],
                    o = a[1],
                    i = a[2],
                    s = "determined";
                2 === a.length
                    ? ("string" != typeof a[0] && "object" != typeof a[0]) ||
                      "string" != typeof a[1]
                        ? "number" == typeof a[0] &&
                          "string" == typeof a[1] &&
                          ((o = a[0]), (i = a[1]), (n = e.$el))
                        : ((n = a[0]), (i = a[1]), (o = a[2]), (s = "infinite"))
                    : 1 === a.length
                    ? "number" == typeof a[0]
                        ? ((n = e.$el), (o = a[0]))
                        : "string" == typeof a[0] &&
                          ((s = "infinite"), (n = e.$el), (i = a[0]))
                    : 0 === a.length && ((s = "infinite"), (n = e.$el));
                var l,
                    c = Ee(n);
                if (0 !== c.length)
                    return (
                        c.hasClass("progressbar") ||
                        c.hasClass("progressbar-infinite")
                            ? (l = c)
                            : 0 ===
                                  (l = c.children(
                                      ".progressbar:not(.progressbar-out), .progressbar-infinite:not(.progressbar-out)"
                                  )).length &&
                              ((l = Ee(
                                  '\n          <span class="progressbar' +
                                      ("infinite" === s ? "-infinite" : "") +
                                      (i ? " color-" + i : "") +
                                      ' progressbar-in">\n            ' +
                                      ("infinite" === s
                                          ? ""
                                          : "<span></span>") +
                                      "\n          </span>"
                              )),
                              c.append(l)),
                        void 0 !== o && e.progressbar.set(l, o),
                        l[0]
                    );
            },
            hide: function (e, t) {
                void 0 === t && (t = !0);
                var a,
                    r = Ee(e || this.$el);
                if (0 !== r.length)
                    return (
                        0 ===
                            (a =
                                r.hasClass("progressbar") ||
                                r.hasClass("progressbar-infinite")
                                    ? r
                                    : r.children(
                                          ".progressbar, .progressbar-infinite"
                                      )).length ||
                            !a.hasClass("progressbar-in") ||
                            a.hasClass("progressbar-out") ||
                            a
                                .removeClass("progressbar-in")
                                .addClass("progressbar-out")
                                .animationEnd(function () {
                                    t && a.remove();
                                }),
                        a
                    );
            },
        },
        Tr = {
            name: "progressbar",
            create: function () {
                nt(this, { progressbar: $r });
            },
            on: {
                tabMounted: function (e) {
                    var t = this;
                    Ee(e)
                        .find(".progressbar")
                        .each(function (e) {
                            var a = Ee(e);
                            t.progressbar.set(a, a.attr("data-progress"));
                        });
                },
                pageInit: function (e) {
                    var t = this;
                    e.$el.find(".progressbar").each(function (e) {
                        var a = Ee(e);
                        t.progressbar.set(a, a.attr("data-progress"));
                    });
                },
            },
            vnode: {
                progressbar: {
                    insert: function (e) {
                        var t = e.elm;
                        this.progressbar.set(
                            t,
                            t.getAttribute("data-progress")
                        );
                    },
                    update: function (e) {
                        var t = e.elm;
                        this.progressbar.set(
                            t,
                            t.getAttribute("data-progress")
                        );
                    },
                },
            },
        },
        Sr = {
            init: function () {
                var e,
                    t,
                    a,
                    n,
                    o,
                    i,
                    s,
                    l,
                    c,
                    p,
                    d,
                    u,
                    h,
                    f,
                    v,
                    m,
                    g,
                    b,
                    y,
                    w,
                    C,
                    E = this,
                    k = r();
                function x(r, n) {
                    (t = !1),
                        (e = !0),
                        (C = !1),
                        (a =
                            "touchstart" === r.type
                                ? r.targetTouches[0].pageY
                                : r.pageY),
                        (o = Ee(r.target).closest("li").eq(0)),
                        (h = o.index()),
                        (s = o.parents(".sortable"));
                    var l = o.parents(".list-group");
                    l.length && l.parents(s).length && (s = l),
                        (i = s
                            .children("ul")
                            .children(
                                "li:not(.disallow-sorting):not(.no-sorting)"
                            )),
                        E.panel && (E.panel.allowOpen = !1),
                        E.swipeout && (E.swipeout.allow = !1),
                        n &&
                            (o.addClass("sorting"),
                            s.addClass("sortable-sorting"),
                            (C = !0));
                }
                var $ = !!ct().passiveListener && { passive: !1, capture: !1 };
                Ee(k).on(
                    E.touchEvents.start,
                    ".list.sortable .sortable-handler",
                    x,
                    $
                ),
                    E.on("touchmove:active", function (r) {
                        if (e && o) {
                            var h =
                                "touchmove" === r.type
                                    ? r.targetTouches[0].pageY
                                    : r.pageY;
                            if (!t) {
                                (f = o.parents(".page")),
                                    (v = o.parents(".page-content"));
                                var C = parseInt(v.css("padding-top"), 10),
                                    k = parseInt(v.css("padding-bottom"), 10);
                                (w = v[0].scrollTop),
                                    (g = f.offset().top + C),
                                    (m = f.height() - C - k),
                                    o.addClass("sorting"),
                                    s.addClass("sortable-sorting"),
                                    (b = o[0].offsetTop),
                                    (c = o[0].offsetTop),
                                    (p = o.parent().height() - b - o.height()),
                                    (l = o[0].offsetHeight),
                                    (y = o.offset().top);
                            }
                            (t = !0),
                                r.preventDefault(),
                                (r.f7PreventSwipePanel = !0),
                                (n = h - a);
                            var x = v[0].scrollTop - w,
                                $ = Math.min(Math.max(n + x, -c), p);
                            o.transform("translate3d(0," + $ + "px,0)");
                            var T,
                                S = 44,
                                M = !0;
                            n + x + S < -c && (M = !1),
                                n + x - S > p && (M = !1),
                                (u = void 0),
                                (d = void 0),
                                M &&
                                    (y + n + l + S > g + m &&
                                        (T = y + n + l + S - (g + m)),
                                    y + n < g + S && (T = y + n - g - S),
                                    T && (v[0].scrollTop += T)),
                                i.each(function (e) {
                                    var t = Ee(e);
                                    if (t[0] !== o[0]) {
                                        var a,
                                            r = t[0].offsetTop,
                                            n = t.height(),
                                            i = b + $,
                                            c = t[0].f7Translate;
                                        i >= r - n / 2 && o.index() < t.index()
                                            ? ((a = -l),
                                              t.transform(
                                                  "translate3d(0, " +
                                                      a +
                                                      "px,0)"
                                              ),
                                              (d = t),
                                              (u = void 0))
                                            : i <= r + n / 2 &&
                                              o.index() > t.index()
                                            ? ((a = l),
                                              (t[0].f7Translate = a),
                                              t.transform(
                                                  "translate3d(0, " +
                                                      a +
                                                      "px,0)"
                                              ),
                                              (d = void 0),
                                              u || (u = t))
                                            : ((a = void 0),
                                              t.transform(
                                                  "translate3d(0, 0%,0)"
                                              )),
                                            c !== a &&
                                                (t.trigger("sortable:move"),
                                                E.emit(
                                                    "sortableMove",
                                                    t[0],
                                                    s[0]
                                                )),
                                            (t[0].f7Translate = a);
                                    }
                                });
                        }
                    }),
                    E.on("touchend:passive", function () {
                        if (!e || !t)
                            return (
                                e &&
                                    !t &&
                                    (E.panel && (E.panel.allowOpen = !0),
                                    E.swipeout && (E.swipeout.allow = !0),
                                    C &&
                                        (o.removeClass("sorting"),
                                        s.removeClass("sortable-sorting"))),
                                (e = !1),
                                void (t = !1)
                            );
                        var a;
                        E.panel && (E.panel.allowOpen = !0),
                            E.swipeout && (E.swipeout.allow = !0),
                            i.transform(""),
                            o.removeClass("sorting"),
                            s.removeClass("sortable-sorting"),
                            d ? (a = d.index()) : u && (a = u.index());
                        var r = s.dataset().sortableMoveElements;
                        if (
                            (void 0 === r &&
                                (r = E.params.sortable.moveElements),
                            r &&
                                (d && o.insertAfter(d), u && o.insertBefore(u)),
                            (d || u) && s.hasClass("virtual-list"))
                        ) {
                            void 0 === (h = o[0].f7VirtualListIndex) &&
                                (h = o.attr("data-virtual-list-index")),
                                u
                                    ? void 0 ===
                                          (a = u[0].f7VirtualListIndex) &&
                                      (a = u.attr("data-virtual-list-index"))
                                    : void 0 ===
                                          (a = d[0].f7VirtualListIndex) &&
                                      (a = d.attr("data-virtual-list-index")),
                                (a = null !== a ? parseInt(a, 10) : void 0);
                            var n = s[0].f7VirtualList;
                            h && (h = parseInt(h, 10)),
                                a && (a = parseInt(a, 10)),
                                n && n.moveItem(h, a);
                        }
                        void 0 === a ||
                            Number.isNaN(a) ||
                            a === h ||
                            (o.trigger("sortable:sort", { from: h, to: a }),
                            E.emit(
                                "sortableSort",
                                o[0],
                                { from: h, to: a, el: o[0] },
                                s[0]
                            )),
                            (u = void 0),
                            (d = void 0),
                            (e = !1),
                            (t = !1);
                    }),
                    Ee(k).on("taphold", ".sortable-tap-hold", function (e, t) {
                        x(t, !0);
                    });
            },
            enable: function (e) {
                void 0 === e && (e = ".list.sortable");
                var t = Ee(e);
                0 !== t.length &&
                    (t.addClass("sortable-enabled"),
                    t.trigger("sortable:enable"),
                    this.emit("sortableEnable", t[0]));
            },
            disable: function (e) {
                void 0 === e && (e = ".list.sortable");
                var t = Ee(e);
                0 !== t.length &&
                    (t.removeClass("sortable-enabled"),
                    t.trigger("sortable:disable"),
                    this.emit("sortableDisable", t[0]));
            },
            toggle: function (e) {
                void 0 === e && (e = ".list.sortable");
                var t = Ee(e);
                0 !== t.length &&
                    (t.hasClass("sortable-enabled")
                        ? this.sortable.disable(t)
                        : this.sortable.enable(t));
            },
        },
        Mr = {
            name: "sortable",
            params: { sortable: { moveElements: !0 } },
            create: function () {
                nt(this, { sortable: Sr });
            },
            on: {
                init: function () {
                    this.params.sortable && this.sortable.init();
                },
            },
            clicks: {
                ".sortable-enable": function (e, t) {
                    void 0 === t && (t = {});
                    this.sortable.enable(t.sortable);
                },
                ".sortable-disable": function (e, t) {
                    void 0 === t && (t = {});
                    this.sortable.disable(t.sortable);
                },
                ".sortable-toggle": function (e, t) {
                    void 0 === t && (t = {});
                    this.sortable.toggle(t.sortable);
                },
            },
        },
        Pr = {
            init: function () {
                var e,
                    t,
                    a,
                    n,
                    o,
                    i,
                    s,
                    l,
                    c,
                    p,
                    d,
                    u,
                    h,
                    f,
                    v,
                    m,
                    g,
                    b,
                    y,
                    w,
                    C,
                    E = this,
                    k = r(),
                    x = {};
                var $ = !!ct().passiveListener && { passive: !0 };
                E.on("touchstart", function (e) {
                    if (Pr.el) {
                        var t = Ee(e.target);
                        Ee(Pr.el).is(t[0]) ||
                            t.parents(".swipeout").is(Pr.el) ||
                            t.hasClass("modal-in") ||
                            (t.attr("class") || "").indexOf("-backdrop") > 0 ||
                            t.hasClass("actions-modal") ||
                            t.parents(
                                ".actions-modal.modal-in, .dialog.modal-in"
                            ).length > 0 ||
                            E.swipeout.close(Pr.el);
                    }
                }),
                    Ee(k).on(
                        E.touchEvents.start,
                        "li.swipeout",
                        function (r) {
                            E.swipeout.allow &&
                                ((t = !1),
                                (e = !0),
                                (a = void 0),
                                (x.x =
                                    "touchstart" === r.type
                                        ? r.targetTouches[0].pageX
                                        : r.pageX),
                                (x.y =
                                    "touchstart" === r.type
                                        ? r.targetTouches[0].pageY
                                        : r.pageY),
                                (n = new Date().getTime()),
                                (i = Ee(this)));
                        },
                        $
                    ),
                    E.on("touchmove:active", function (r) {
                        if (e) {
                            var n =
                                    "touchmove" === r.type
                                        ? r.targetTouches[0].pageX
                                        : r.pageX,
                                k =
                                    "touchmove" === r.type
                                        ? r.targetTouches[0].pageY
                                        : r.pageY;
                            if (
                                (void 0 === a &&
                                    (a = !!(
                                        a ||
                                        Math.abs(k - x.y) > Math.abs(n - x.x)
                                    )),
                                a)
                            )
                                e = !1;
                            else {
                                if (!t) {
                                    if (Ee(".list.sortable-opened").length > 0)
                                        return;
                                    (s = i.find(".swipeout-content")),
                                        (l = i.find(".swipeout-actions-right")),
                                        (c = i.find(".swipeout-actions-left")),
                                        (p = null),
                                        (d = null),
                                        (v = null),
                                        (m = null),
                                        (y = null),
                                        (b = null),
                                        c.length > 0 &&
                                            ((p = c.outerWidth()),
                                            (v = c.children("a")),
                                            (b = c.find(
                                                ".swipeout-overswipe"
                                            ))),
                                        l.length > 0 &&
                                            ((d = l.outerWidth()),
                                            (m = l.children("a")),
                                            (y = l.find(
                                                ".swipeout-overswipe"
                                            ))),
                                        (h = i.hasClass("swipeout-opened")) &&
                                            (f =
                                                i.find(
                                                    ".swipeout-actions-left.swipeout-actions-opened"
                                                ).length > 0
                                                    ? "left"
                                                    : "right"),
                                        i.removeClass("swipeout-transitioning"),
                                        E.params.swipeout.noFollow ||
                                            (i
                                                .find(
                                                    ".swipeout-actions-opened"
                                                )
                                                .removeClass(
                                                    "swipeout-actions-opened"
                                                ),
                                            i.removeClass("swipeout-opened"));
                                }
                                if (
                                    ((t = !0),
                                    r.cancelable && r.preventDefault(),
                                    (o = n - x.x),
                                    (u = o),
                                    h && ("right" === f ? (u -= d) : (u += p)),
                                    (u > 0 && 0 === c.length) ||
                                        (u < 0 && 0 === l.length))
                                ) {
                                    if (!h)
                                        return (
                                            (e = !1),
                                            (t = !1),
                                            s.transform(""),
                                            m &&
                                                m.length > 0 &&
                                                m.transform(""),
                                            void (
                                                v &&
                                                v.length > 0 &&
                                                v.transform("")
                                            )
                                        );
                                    u = 0;
                                }
                                var $, T;
                                if (
                                    (u < 0
                                        ? (g = "to-left")
                                        : u > 0
                                        ? (g = "to-right")
                                        : g || (g = "to-left"),
                                    (r.f7PreventSwipePanel = !0),
                                    E.params.swipeout.noFollow)
                                )
                                    return (
                                        h
                                            ? ("right" === f &&
                                                  o > 0 &&
                                                  E.swipeout.close(i),
                                              "left" === f &&
                                                  o < 0 &&
                                                  E.swipeout.close(i))
                                            : (o < 0 &&
                                                  l.length > 0 &&
                                                  E.swipeout.open(i, "right"),
                                              o > 0 &&
                                                  c.length > 0 &&
                                                  E.swipeout.open(i, "left")),
                                        (e = !1),
                                        void (t = !1)
                                    );
                                if (((w = !1), (C = !1), l.length > 0)) {
                                    var S = u;
                                    if (((T = S / d), S < -d)) {
                                        var M = S / -d;
                                        (S = -d - Math.pow(-S - d, 0.8)),
                                            (u = S),
                                            y.length > 0 &&
                                                M >
                                                    E.params.swipeout
                                                        .overswipeRatio &&
                                                (C = !0);
                                    }
                                    "to-left" !== g && ((T = 0), (S = 0)),
                                        m.each(function (e) {
                                            var t = Ee(e);
                                            void 0 ===
                                                e.f7SwipeoutButtonOffset &&
                                                (t[0].f7SwipeoutButtonOffset =
                                                    e.offsetLeft),
                                                ($ = e.f7SwipeoutButtonOffset),
                                                y.length > 0 &&
                                                    t.hasClass(
                                                        "swipeout-overswipe"
                                                    ) &&
                                                    "to-left" === g &&
                                                    (t.css({
                                                        left:
                                                            (C ? -$ : 0) + "px",
                                                    }),
                                                    C
                                                        ? (t.hasClass(
                                                              "swipeout-overswipe-active"
                                                          ) ||
                                                              (i.trigger(
                                                                  "swipeout:overswipeenter"
                                                              ),
                                                              E.emit(
                                                                  "swipeoutOverswipeEnter",
                                                                  i[0]
                                                              )),
                                                          t.addClass(
                                                              "swipeout-overswipe-active"
                                                          ))
                                                        : (t.hasClass(
                                                              "swipeout-overswipe-active"
                                                          ) &&
                                                              (i.trigger(
                                                                  "swipeout:overswipeexit"
                                                              ),
                                                              E.emit(
                                                                  "swipeoutOverswipeExit",
                                                                  i[0]
                                                              )),
                                                          t.removeClass(
                                                              "swipeout-overswipe-active"
                                                          ))),
                                                t.transform(
                                                    "translate3d(" +
                                                        (S -
                                                            $ *
                                                                (1 +
                                                                    Math.max(
                                                                        T,
                                                                        -1
                                                                    ))) +
                                                        "px,0,0)"
                                                );
                                        });
                                }
                                if (c.length > 0) {
                                    var P = u;
                                    if (((T = P / p), P > p)) {
                                        var O = P / d;
                                        (P = p + Math.pow(P - p, 0.8)),
                                            (u = P),
                                            b.length > 0 &&
                                                O >
                                                    E.params.swipeout
                                                        .overswipeRatio &&
                                                (w = !0);
                                    }
                                    "to-right" !== g && ((P = 0), (T = 0)),
                                        v.each(function (e, t) {
                                            var a = Ee(e);
                                            void 0 ===
                                                e.f7SwipeoutButtonOffset &&
                                                (a[0].f7SwipeoutButtonOffset =
                                                    p -
                                                    e.offsetLeft -
                                                    e.offsetWidth),
                                                ($ = e.f7SwipeoutButtonOffset),
                                                b.length > 0 &&
                                                    a.hasClass(
                                                        "swipeout-overswipe"
                                                    ) &&
                                                    "to-right" === g &&
                                                    (a.css({
                                                        left:
                                                            (w ? $ : 0) + "px",
                                                    }),
                                                    w
                                                        ? (a.hasClass(
                                                              "swipeout-overswipe-active"
                                                          ) ||
                                                              (i.trigger(
                                                                  "swipeout:overswipeenter"
                                                              ),
                                                              E.emit(
                                                                  "swipeoutOverswipeEnter",
                                                                  i[0]
                                                              )),
                                                          a.addClass(
                                                              "swipeout-overswipe-active"
                                                          ))
                                                        : (a.hasClass(
                                                              "swipeout-overswipe-active"
                                                          ) &&
                                                              (i.trigger(
                                                                  "swipeout:overswipeexit"
                                                              ),
                                                              E.emit(
                                                                  "swipeoutOverswipeExit",
                                                                  i[0]
                                                              )),
                                                          a.removeClass(
                                                              "swipeout-overswipe-active"
                                                          ))),
                                                v.length > 1 &&
                                                    a.css(
                                                        "z-index",
                                                        v.length - t
                                                    ),
                                                a.transform(
                                                    "translate3d(" +
                                                        (P +
                                                            $ *
                                                                (1 -
                                                                    Math.min(
                                                                        T,
                                                                        1
                                                                    ))) +
                                                        "px,0,0)"
                                                );
                                        });
                                }
                                i.trigger("swipeout", T),
                                    E.emit("swipeout", i[0], T),
                                    s.transform("translate3d(" + u + "px,0,0)");
                            }
                        }
                    }),
                    E.on("touchend:passive", function () {
                        if (!e || !t) return (e = !1), void (t = !1);
                        (e = !1), (t = !1);
                        var a,
                            r,
                            f,
                            b,
                            y = new Date().getTime() - n,
                            k = "to-left" === g ? l : c,
                            x = "to-left" === g ? d : p;
                        if (
                            ((a =
                                (y < 300 &&
                                    ((o < -10 && "to-left" === g) ||
                                        (o > 10 && "to-right" === g))) ||
                                (y >= 300 && Math.abs(u) > x / 2)
                                    ? "open"
                                    : "close"),
                            y < 300 &&
                                (0 === Math.abs(u) && (a = "close"),
                                Math.abs(u) === x && (a = "open")),
                            "open" === a)
                        ) {
                            (Pr.el = i[0]),
                                i.trigger("swipeout:open"),
                                E.emit("swipeoutOpen", i[0]),
                                i.addClass(
                                    "swipeout-opened swipeout-transitioning"
                                );
                            var $ = "to-left" === g ? -x : x;
                            if (
                                (s.transform("translate3d(" + $ + "px,0,0)"),
                                k.addClass("swipeout-actions-opened"),
                                (r = "to-left" === g ? m : v))
                            )
                                for (f = 0; f < r.length; f += 1)
                                    Ee(r[f]).transform(
                                        "translate3d(" + $ + "px,0,0)"
                                    );
                            C &&
                                l
                                    .find(".swipeout-overswipe")
                                    .trigger("click", "f7Overswipe"),
                                w &&
                                    c
                                        .find(".swipeout-overswipe")
                                        .trigger("click", "f7Overswipe");
                        } else i.trigger("swipeout:close"), E.emit("swipeoutClose", i[0]), (Pr.el = void 0), i.addClass("swipeout-transitioning").removeClass("swipeout-opened"), s.transform(""), k.removeClass("swipeout-actions-opened");
                        v &&
                            v.length > 0 &&
                            v !== r &&
                            v.each(function (e) {
                                var t = Ee(e);
                                void 0 === (b = e.f7SwipeoutButtonOffset) &&
                                    (t[0].f7SwipeoutButtonOffset =
                                        p - e.offsetLeft - e.offsetWidth),
                                    t.transform("translate3d(" + b + "px,0,0)");
                            }),
                            m &&
                                m.length > 0 &&
                                m !== r &&
                                m.each(function (e) {
                                    var t = Ee(e);
                                    void 0 === (b = e.f7SwipeoutButtonOffset) &&
                                        (t[0].f7SwipeoutButtonOffset =
                                            e.offsetLeft),
                                        t.transform(
                                            "translate3d(" + -b + "px,0,0)"
                                        );
                                }),
                            s.transitionEnd(function () {
                                (h && "open" === a) ||
                                    (!h && "close" === a) ||
                                    (i.trigger(
                                        "open" === a
                                            ? "swipeout:opened"
                                            : "swipeout:closed"
                                    ),
                                    E.emit(
                                        "open" === a
                                            ? "swipeoutOpened"
                                            : "swipeoutClosed",
                                        i[0]
                                    ),
                                    i.removeClass("swipeout-transitioning"),
                                    h &&
                                        "close" === a &&
                                        (l.length > 0 && m.transform(""),
                                        c.length > 0 && v.transform("")));
                            });
                    });
            },
            allow: !0,
            el: void 0,
            open: function () {
                for (
                    var e = this, t = arguments.length, a = new Array(t), r = 0;
                    r < t;
                    r++
                )
                    a[r] = arguments[r];
                var n = a[0],
                    o = a[1],
                    i = a[2];
                "function" == typeof a[1] &&
                    ((n = a[0]), (i = a[1]), (o = a[2]));
                var s = Ee(n).eq(0);
                if (
                    0 !== s.length &&
                    s.hasClass("swipeout") &&
                    !s.hasClass("swipeout-opened")
                ) {
                    o ||
                        (o =
                            s.find(".swipeout-actions-right").length > 0
                                ? "right"
                                : "left");
                    var l = s.find(".swipeout-actions-" + o),
                        c = s.find(".swipeout-content");
                    if (0 !== l.length) {
                        s
                            .trigger("swipeout:open")
                            .addClass("swipeout-opened")
                            .removeClass("swipeout-transitioning"),
                            e.emit("swipeoutOpen", s[0]),
                            l.addClass("swipeout-actions-opened");
                        var p = l.children("a"),
                            d = l.outerWidth(),
                            u = "right" === o ? -d : d;
                        p.length > 1 &&
                            p.each(function (e, t) {
                                var a = Ee(e);
                                "right" === o
                                    ? a.transform(
                                          "translate3d(" +
                                              -e.offsetLeft +
                                              "px,0,0)"
                                      )
                                    : a
                                          .css("z-index", p.length - t)
                                          .transform(
                                              "translate3d(" +
                                                  (d -
                                                      e.offsetWidth -
                                                      e.offsetLeft) +
                                                  "px,0,0)"
                                          );
                            }),
                            s.addClass("swipeout-transitioning"),
                            c.transitionEnd(function () {
                                s.trigger("swipeout:opened"),
                                    e.emit("swipeoutOpened", s[0]),
                                    i && i.call(s[0]);
                            }),
                            _e(function () {
                                p.transform("translate3d(" + u + "px,0,0)"),
                                    c.transform("translate3d(" + u + "px,0,0)");
                            }),
                            (Pr.el = s[0]);
                    }
                }
            },
            close: function (e, t) {
                var a = this,
                    r = Ee(e).eq(0);
                if (0 !== r.length && r.hasClass("swipeout-opened")) {
                    var n,
                        o = r
                            .find(".swipeout-actions-opened")
                            .hasClass("swipeout-actions-right")
                            ? "right"
                            : "left",
                        i = r
                            .find(".swipeout-actions-opened")
                            .removeClass("swipeout-actions-opened"),
                        s = i.children("a"),
                        l = i.outerWidth();
                    (a.swipeout.allow = !1),
                        r.trigger("swipeout:close"),
                        a.emit("swipeoutClose", r[0]),
                        r
                            .removeClass("swipeout-opened")
                            .addClass("swipeout-transitioning"),
                        r
                            .find(".swipeout-content")
                            .transform("")
                            .transitionEnd(c),
                        (n = setTimeout(c, 500)),
                        s.each(function (e) {
                            var t = Ee(e);
                            "right" === o
                                ? t.transform(
                                      "translate3d(" + -e.offsetLeft + "px,0,0)"
                                  )
                                : t.transform(
                                      "translate3d(" +
                                          (l - e.offsetWidth - e.offsetLeft) +
                                          "px,0,0)"
                                  ),
                                t
                                    .css({ left: "0px" })
                                    .removeClass("swipeout-overswipe-active");
                        }),
                        Pr.el && Pr.el === r[0] && (Pr.el = void 0);
                }
                function c() {
                    (a.swipeout.allow = !0),
                        r.hasClass("swipeout-opened") ||
                            (r.removeClass("swipeout-transitioning"),
                            s.transform(""),
                            r.trigger("swipeout:closed"),
                            a.emit("swipeoutClosed", r[0]),
                            t && t.call(r[0]),
                            n && clearTimeout(n));
                }
            },
            delete: function (e, t) {
                var a = this,
                    r = Ee(e).eq(0);
                0 !== r.length &&
                    ((Pr.el = void 0),
                    r.trigger("swipeout:delete"),
                    a.emit("swipeoutDelete", r[0]),
                    r.css({ height: r.outerHeight() + "px" }),
                    r.transitionEnd(function () {
                        if (
                            (r.trigger("swipeout:deleted"),
                            a.emit("swipeoutDeleted", r[0]),
                            t && t.call(r[0]),
                            r.parents(".virtual-list").length > 0)
                        ) {
                            var e = r.parents(".virtual-list")[0].f7VirtualList,
                                n = r[0].f7VirtualListIndex;
                            e && void 0 !== n && e.deleteItem(n);
                        } else
                            a.params.swipeout.removeElements
                                ? a.params.swipeout.removeElementsWithTimeout
                                    ? setTimeout(function () {
                                          r.remove();
                                      }, a
                                          .params.swipeout.removeElementsTimeout)
                                    : r.remove()
                                : r.removeClass(
                                      "swipeout-deleting swipeout-transitioning"
                                  );
                    }),
                    _e(function () {
                        r.addClass("swipeout-deleting swipeout-transitioning")
                            .css({ height: "0px" })
                            .find(".swipeout-content")
                            .transform("translate3d(-100%,0,0)");
                    }));
            },
        },
        Or = {
            name: "swipeout",
            params: {
                swipeout: {
                    actionsNoFold: !1,
                    noFollow: !1,
                    removeElements: !0,
                    removeElementsWithTimeout: !1,
                    removeElementsTimeout: 0,
                    overswipeRatio: 1.2,
                },
            },
            create: function () {
                nt(this, { swipeout: Pr });
            },
            clicks: {
                ".swipeout-open": function (e, t) {
                    void 0 === t && (t = {});
                    this.swipeout.open(t.swipeout, t.side);
                },
                ".swipeout-close": function (e) {
                    var t = e.closest(".swipeout");
                    0 !== t.length && this.swipeout.close(t);
                },
                ".swipeout-delete": function (e, t) {
                    void 0 === t && (t = {});
                    var a = this,
                        r = e.closest(".swipeout");
                    if (0 !== r.length) {
                        var n = t,
                            o = n.confirm,
                            i = n.confirmTitle;
                        t.confirm
                            ? a.dialog.confirm(o, i, function () {
                                  a.swipeout.delete(r);
                              })
                            : a.swipeout.delete(r);
                    }
                },
            },
            on: {
                init: function () {
                    this.params.swipeout && this.swipeout.init();
                },
            },
        },
        Ir = {
            toggleClicked: function (e) {
                var t = e.closest(".accordion-item").eq(0);
                t.length || (t = e.parents("li").eq(0));
                var a = e.parents(".accordion-item-content").eq(0);
                (a.length && a.parents(t).length) ||
                    (e.parents("li").length > 1 &&
                        e.parents("li")[0] !== t[0]) ||
                    this.accordion.toggle(t);
            },
            open: function (e) {
                var t = this,
                    a = Ee(e),
                    r = !1;
                function n() {
                    r = !0;
                }
                if (
                    (a.trigger("accordion:beforeopen", { prevent: n }, n),
                    t.emit("accordionBeforeOpen", a[0], n),
                    !r)
                ) {
                    var o = a.parents(".accordion-list").eq(0),
                        i = a.children(".accordion-item-content");
                    if (
                        (i.removeAttr("aria-hidden"),
                        0 === i.length &&
                            (i = a.find(".accordion-item-content")),
                        0 !== i.length)
                    ) {
                        var s =
                            o.length > 0 &&
                            a.parent().children(".accordion-item-opened");
                        s.length > 0 && t.accordion.close(s),
                            i.transitionEnd(function () {
                                a.hasClass("accordion-item-opened")
                                    ? (i.transition(0),
                                      i.css("height", "auto"),
                                      _e(function () {
                                          i.transition(""),
                                              a.trigger("accordion:opened"),
                                              t.emit("accordionOpened", a[0]);
                                      }))
                                    : (i.css("height", ""),
                                      a.trigger("accordion:closed"),
                                      t.emit("accordionClosed", a[0]));
                            }),
                            i.css("height", i[0].scrollHeight + "px"),
                            a.trigger("accordion:open"),
                            a.addClass("accordion-item-opened"),
                            t.emit("accordionOpen", a[0]);
                    }
                }
            },
            close: function (e) {
                var t = this,
                    a = Ee(e),
                    r = !1;
                function n() {
                    r = !0;
                }
                if (
                    (a.trigger("accordion:beforeclose", { prevent: n }, n),
                    t.emit("accordionBeforeClose", a[0], n),
                    !r)
                ) {
                    var o = a.children(".accordion-item-content");
                    0 === o.length && (o = a.find(".accordion-item-content")),
                        a.removeClass("accordion-item-opened"),
                        o.attr("aria-hidden", !0),
                        o.transition(0),
                        o.css("height", o[0].scrollHeight + "px"),
                        o.transitionEnd(function () {
                            a.hasClass("accordion-item-opened")
                                ? (o.transition(0),
                                  o.css("height", "auto"),
                                  _e(function () {
                                      o.transition(""),
                                          a.trigger("accordion:opened"),
                                          t.emit("accordionOpened", a[0]);
                                  }))
                                : (o.css("height", ""),
                                  a.trigger("accordion:closed"),
                                  t.emit("accordionClosed", a[0]));
                        }),
                        _e(function () {
                            o.transition(""),
                                o.css("height", ""),
                                a.trigger("accordion:close"),
                                t.emit("accordionClose", a[0]);
                        });
                }
            },
            toggle: function (e) {
                var t = Ee(e);
                0 !== t.length &&
                    (t.hasClass("accordion-item-opened")
                        ? this.accordion.close(e)
                        : this.accordion.open(e));
            },
        },
        Br = {
            name: "accordion",
            create: function () {
                nt(this, { accordion: Ir });
            },
            clicks: {
                ".accordion-item .item-link, .accordion-item-toggle, .links-list.accordion-list > ul > li > a":
                    function (e) {
                        Ir.toggleClicked.call(this, e);
                    },
            },
        },
        Lr = (function (e) {
            function t(t, a) {
                var n;
                void 0 === a && (a = {});
                var o,
                    i = ze((n = e.call(this, a, [t]) || this)),
                    s = pt(),
                    l = r();
                "md" === t.theme
                    ? (o = 48)
                    : "ios" === t.theme
                    ? (o = 44)
                    : "aurora" === t.theme && (o = 38);
                var c = {
                    cols: 1,
                    height: o,
                    cache: !0,
                    dynamicHeightBufferSize: 1,
                    showFilteredItemsOnly: !1,
                    renderExternal: void 0,
                    setListHeight: !0,
                    searchByItem: void 0,
                    searchAll: void 0,
                    ul: null,
                    createUl: !0,
                    scrollableParentEl: void 0,
                    renderItem: function (e) {
                        return (
                            '\n          <li>\n            <div class="item-content">\n              <div class="item-inner">\n                <div class="item-title">' +
                            e +
                            "</div>\n              </div>\n            </div>\n          </li>\n        "
                        ).trim();
                    },
                    on: {},
                };
                if (
                    (i.useModulesParams(c),
                    (i.params = Qe(c, a)),
                    (void 0 !== i.params.height && i.params.height) ||
                        (i.params.height = o),
                    (i.$el = Ee(a.el)),
                    (i.el = i.$el[0]),
                    0 === i.$el.length)
                )
                    return ze(n);
                (i.$el[0].f7VirtualList = i),
                    (i.items = i.params.items),
                    i.params.showFilteredItemsOnly && (i.filteredItems = []),
                    i.params.renderItem && (i.renderItem = i.params.renderItem),
                    (i.$pageContentEl = i.$el.parents(".page-content")),
                    (i.pageContentEl = i.$pageContentEl[0]),
                    (i.$scrollableParentEl = i.params.scrollableParentEl
                        ? Ee(i.params.scrollableParentEl).eq(0)
                        : i.$pageContentEl),
                    !i.$scrollableParentEl.length &&
                        i.$pageContentEl.length &&
                        (i.$scrollableParentEl = i.$pageContentEl),
                    (i.scrollableParentEl = i.$scrollableParentEl[0]),
                    void 0 !== i.params.updatableScroll
                        ? (i.updatableScroll = i.params.updatableScroll)
                        : ((i.updatableScroll = !0),
                          s.ios &&
                              s.osVersion.split(".")[0] < 8 &&
                              (i.updatableScroll = !1));
                var p,
                    d = i.params.ul;
                (i.$ul = d ? Ee(i.params.ul) : i.$el.children("ul")),
                    0 === i.$ul.length &&
                        i.params.createUl &&
                        (i.$el.append("<ul></ul>"),
                        (i.$ul = i.$el.children("ul"))),
                    (i.ul = i.$ul[0]),
                    (p = i.ul || i.params.createUl ? i.$ul : i.$el),
                    Qe(i, {
                        $itemsWrapEl: p,
                        itemsWrapEl: p[0],
                        domCache: {},
                        displayDomCache: {},
                        tempDomElement: l.createElement("ul"),
                        lastRepaintY: null,
                        fragment: l.createDocumentFragment(),
                        pageHeight: void 0,
                        rowsPerScreen: void 0,
                        rowsBefore: void 0,
                        rowsAfter: void 0,
                        rowsToRender: void 0,
                        maxBufferHeight: 0,
                        listHeight: void 0,
                        dynamicHeight: "function" == typeof i.params.height,
                    }),
                    i.useModules();
                var u,
                    h,
                    f,
                    v,
                    m = i.handleScroll.bind(i),
                    g = i.handleResize.bind(i);
                return (
                    (i.attachEvents = function () {
                        (u = i.$el.parents(".page").eq(0)),
                            (h = i.$el
                                .parents(".tab")
                                .filter(function (e) {
                                    return (
                                        0 ===
                                        Ee(e)
                                            .parent(".tabs")
                                            .parent(
                                                ".tabs-animated-wrap, .tabs-swipeable-wrap"
                                            ).length
                                    );
                                })
                                .eq(0)),
                            (f = i.$el.parents(".panel").eq(0)),
                            (v = i.$el.parents(".popup").eq(0)),
                            i.$scrollableParentEl.on("scroll", m),
                            u.length && u.on("page:reinit", g),
                            h.length && h.on("tab:show", g),
                            f.length && f.on("panel:open", g),
                            v.length && v.on("popup:open", g),
                            t.on("resize", g);
                    }),
                    (i.detachEvents = function () {
                        i.$scrollableParentEl.off("scroll", m),
                            u.length && u.off("page:reinit", g),
                            h.length && h.off("tab:show", g),
                            f.length && f.off("panel:open", g),
                            v.length && v.off("popup:open", g),
                            t.off("resize", g);
                    }),
                    i.init(),
                    i || ze(n)
                );
            }
            Me(t, e);
            var a = t.prototype;
            return (
                (a.setListSize = function () {
                    var e = this,
                        t = e.filteredItems || e.items;
                    if (
                        ((e.pageHeight = e.$scrollableParentEl[0].offsetHeight),
                        e.dynamicHeight)
                    ) {
                        (e.listHeight = 0), (e.heights = []);
                        for (var a = 0; a < t.length; a += 1) {
                            var r = e.params.height(t[a]);
                            (e.listHeight += r), e.heights.push(r);
                        }
                    } else
                        (e.listHeight =
                            Math.ceil(t.length / e.params.cols) *
                            e.params.height),
                            (e.rowsPerScreen = Math.ceil(
                                e.pageHeight / e.params.height
                            )),
                            (e.rowsBefore =
                                e.params.rowsBefore || 2 * e.rowsPerScreen),
                            (e.rowsAfter =
                                e.params.rowsAfter || e.rowsPerScreen),
                            (e.rowsToRender =
                                e.rowsPerScreen + e.rowsBefore + e.rowsAfter),
                            (e.maxBufferHeight =
                                (e.rowsBefore / 2) * e.params.height);
                    (e.updatableScroll || e.params.setListHeight) &&
                        e.$itemsWrapEl.css({ height: e.listHeight + "px" });
                }),
                (a.render = function (e, t) {
                    var a = this;
                    e && (a.lastRepaintY = null);
                    var r = -(
                        a.$el[0].getBoundingClientRect().top -
                        a.$scrollableParentEl[0].getBoundingClientRect().top
                    );
                    if (
                        (void 0 !== t && (r = t),
                        null === a.lastRepaintY ||
                            Math.abs(r - a.lastRepaintY) > a.maxBufferHeight ||
                            (!a.updatableScroll &&
                                a.$scrollableParentEl[0].scrollTop +
                                    a.pageHeight >=
                                    a.$scrollableParentEl[0].scrollHeight))
                    ) {
                        a.lastRepaintY = r;
                        var n,
                            o,
                            i,
                            s = a.filteredItems || a.items,
                            l = 0,
                            c = 0;
                        if (a.dynamicHeight) {
                            var p,
                                d = 0;
                            a.maxBufferHeight = a.pageHeight;
                            for (var u = 0; u < a.heights.length; u += 1)
                                (p = a.heights[u]),
                                    void 0 === n &&
                                        (d + p >=
                                        r -
                                            2 *
                                                a.pageHeight *
                                                a.params.dynamicHeightBufferSize
                                            ? (n = u)
                                            : (l += p)),
                                    void 0 === o &&
                                        ((d + p >=
                                            r +
                                                2 *
                                                    a.pageHeight *
                                                    a.params
                                                        .dynamicHeightBufferSize ||
                                            u === a.heights.length - 1) &&
                                            (o = u + 1),
                                        (c += p)),
                                    (d += p);
                            o = Math.min(o, s.length);
                        } else
                            (n =
                                (parseInt(r / a.params.height, 10) -
                                    a.rowsBefore) *
                                a.params.cols) < 0 && (n = 0),
                                (o = Math.min(
                                    n + a.rowsToRender * a.params.cols,
                                    s.length
                                ));
                        var h,
                            f = [];
                        for (a.reachEnd = !1, h = n; h < o; h += 1) {
                            var v = void 0,
                                m = a.items.indexOf(s[h]);
                            h === n && (a.currentFromIndex = m),
                                h === o - 1 && (a.currentToIndex = m),
                                a.filteredItems
                                    ? a.items[m] ===
                                          a.filteredItems[
                                              a.filteredItems.length - 1
                                          ] && (a.reachEnd = !0)
                                    : m === a.items.length - 1 &&
                                      (a.reachEnd = !0),
                                a.params.renderExternal
                                    ? f.push(s[h])
                                    : a.domCache[m]
                                    ? ((v = a.domCache[m]).f7VirtualListIndex =
                                          m)
                                    : (a.renderItem
                                          ? (a.tempDomElement.innerHTML = a
                                                .renderItem(s[h], m)
                                                .trim())
                                          : (a.tempDomElement.innerHTML = s[h]
                                                .toString()
                                                .trim()),
                                      (v = a.tempDomElement.childNodes[0]),
                                      a.params.cache && (a.domCache[m] = v),
                                      (v.f7VirtualListIndex = m)),
                                h === n &&
                                    (i = a.dynamicHeight
                                        ? l
                                        : (h * a.params.height) /
                                          a.params.cols),
                                a.params.renderExternal ||
                                    ((v.style.top = i + "px"),
                                    a.emit(
                                        "local::itemBeforeInsert vlItemBeforeInsert",
                                        a,
                                        v,
                                        s[h]
                                    ),
                                    a.fragment.appendChild(v));
                        }
                        a.updatableScroll ||
                            (a.dynamicHeight
                                ? (a.itemsWrapEl.style.height = c + "px")
                                : (a.itemsWrapEl.style.height =
                                      (h * a.params.height) / a.params.cols +
                                      "px")),
                            a.params.renderExternal
                                ? s && 0 === s.length && (a.reachEnd = !0)
                                : (a.emit(
                                      "local::beforeClear vlBeforeClear",
                                      a,
                                      a.fragment
                                  ),
                                  (a.itemsWrapEl.innerHTML = ""),
                                  a.emit(
                                      "local::itemsBeforeInsert vlItemsBeforeInsert",
                                      a,
                                      a.fragment
                                  ),
                                  s && 0 === s.length
                                      ? ((a.reachEnd = !0),
                                        a.params.emptyTemplate &&
                                            (a.itemsWrapEl.innerHTML =
                                                a.params.emptyTemplate))
                                      : a.itemsWrapEl.appendChild(a.fragment),
                                  a.emit(
                                      "local::itemsAfterInsert vlItemsAfterInsert",
                                      a,
                                      a.fragment
                                  )),
                            void 0 !== t &&
                                e &&
                                a.$scrollableParentEl.scrollTop(t, 0),
                            a.params.renderExternal &&
                                a.params.renderExternal(a, {
                                    fromIndex: n,
                                    toIndex: o,
                                    listHeight: a.listHeight,
                                    topPosition: i,
                                    items: f,
                                });
                    }
                }),
                (a.filterItems = function (e, t) {
                    void 0 === t && (t = !0);
                    var a = this;
                    a.filteredItems = [];
                    for (var r = 0; r < e.length; r += 1)
                        a.filteredItems.push(a.items[e[r]]);
                    t && (a.$scrollableParentEl[0].scrollTop = 0), a.update();
                }),
                (a.resetFilter = function () {
                    var e = this;
                    e.params.showFilteredItemsOnly
                        ? (e.filteredItems = [])
                        : ((e.filteredItems = null), delete e.filteredItems),
                        e.update();
                }),
                (a.scrollToItem = function (e) {
                    var t = this;
                    if (e > t.items.length) return !1;
                    var a = 0;
                    if (t.dynamicHeight)
                        for (var r = 0; r < e; r += 1) a += t.heights[r];
                    else a = e * t.params.height;
                    var n = t.$el[0].offsetTop;
                    return (
                        t.render(
                            !0,
                            n +
                                a -
                                parseInt(
                                    t.$scrollableParentEl.css("padding-top"),
                                    10
                                )
                        ),
                        !0
                    );
                }),
                (a.handleScroll = function () {
                    this.render();
                }),
                (a.isVisible = function () {
                    var e = this;
                    return !!(
                        e.el.offsetWidth ||
                        e.el.offsetHeight ||
                        e.el.getClientRects().length
                    );
                }),
                (a.handleResize = function () {
                    var e = this;
                    e.isVisible() && (e.setListSize(), e.render(!0));
                }),
                (a.appendItems = function (e) {
                    for (var t = 0; t < e.length; t += 1) this.items.push(e[t]);
                    this.update();
                }),
                (a.appendItem = function (e) {
                    this.appendItems([e]);
                }),
                (a.replaceAllItems = function (e) {
                    var t = this;
                    (t.items = e),
                        delete t.filteredItems,
                        (t.domCache = {}),
                        t.update();
                }),
                (a.replaceItem = function (e, t) {
                    var a = this;
                    (a.items[e] = t),
                        a.params.cache && delete a.domCache[e],
                        a.update();
                }),
                (a.prependItems = function (e) {
                    for (var t = this, a = e.length - 1; a >= 0; a -= 1)
                        t.items.unshift(e[a]);
                    if (t.params.cache) {
                        var r = {};
                        Object.keys(t.domCache).forEach(function (a) {
                            r[parseInt(a, 10) + e.length] = t.domCache[a];
                        }),
                            (t.domCache = r);
                    }
                    t.update();
                }),
                (a.prependItem = function (e) {
                    this.prependItems([e]);
                }),
                (a.moveItem = function (e, t) {
                    var a = this,
                        r = e,
                        n = t;
                    if (r !== n) {
                        var o = a.items.splice(r, 1)[0];
                        if (
                            (n >= a.items.length
                                ? (a.items.push(o), (n = a.items.length - 1))
                                : a.items.splice(n, 0, o),
                            a.params.cache)
                        ) {
                            var i = {};
                            Object.keys(a.domCache).forEach(function (e) {
                                var t = parseInt(e, 10),
                                    o = r < n ? r : n,
                                    s = r < n ? n : r,
                                    l = r < n ? -1 : 1;
                                (t < o || t > s) && (i[t] = a.domCache[t]),
                                    t === o && (i[s] = a.domCache[t]),
                                    t > o &&
                                        t <= s &&
                                        (i[t + l] = a.domCache[t]);
                            }),
                                (a.domCache = i);
                        }
                        a.update();
                    }
                }),
                (a.insertItemBefore = function (e, t) {
                    var a = this;
                    if (0 !== e)
                        if (e >= a.items.length) a.appendItem(t);
                        else {
                            if ((a.items.splice(e, 0, t), a.params.cache)) {
                                var r = {};
                                Object.keys(a.domCache).forEach(function (t) {
                                    var n = parseInt(t, 10);
                                    n >= e && (r[n + 1] = a.domCache[n]);
                                }),
                                    (a.domCache = r);
                            }
                            a.update();
                        }
                    else a.prependItem(t);
                }),
                (a.deleteItems = function (e) {
                    for (
                        var t,
                            a = this,
                            r = 0,
                            n = function (n) {
                                var o = e[n];
                                void 0 !== t && o > t && (r = -n),
                                    (o += r),
                                    (t = e[n]);
                                var i = a.items.splice(o, 1)[0];
                                if (
                                    (a.filteredItems &&
                                        a.filteredItems.indexOf(i) >= 0 &&
                                        a.filteredItems.splice(
                                            a.filteredItems.indexOf(i),
                                            1
                                        ),
                                    a.params.cache)
                                ) {
                                    var s = {};
                                    Object.keys(a.domCache).forEach(function (
                                        e
                                    ) {
                                        var t = parseInt(e, 10);
                                        t === o
                                            ? delete a.domCache[o]
                                            : parseInt(e, 10) > o
                                            ? (s[t - 1] = a.domCache[e])
                                            : (s[t] = a.domCache[e]);
                                    }),
                                        (a.domCache = s);
                                }
                            },
                            o = 0;
                        o < e.length;
                        o += 1
                    )
                        n(o);
                    a.update();
                }),
                (a.deleteAllItems = function () {
                    var e = this;
                    (e.items = []),
                        delete e.filteredItems,
                        e.params.cache && (e.domCache = {}),
                        e.update();
                }),
                (a.deleteItem = function (e) {
                    this.deleteItems([e]);
                }),
                (a.clearCache = function () {
                    this.domCache = {};
                }),
                (a.update = function (e) {
                    var t = this;
                    e && t.params.cache && (t.domCache = {}),
                        t.setListSize(),
                        t.render(!0);
                }),
                (a.init = function () {
                    var e = this;
                    e.attachEvents(), e.setListSize(), e.render();
                }),
                (a.destroy = function () {
                    var e = this;
                    e.detachEvents(),
                        (e.$el[0].f7VirtualList = null),
                        delete e.$el[0].f7VirtualList,
                        Fe(e),
                        (e = null);
                }),
                t
            );
        })(ut),
        zr = {
            name: "virtualList",
            static: { VirtualList: Lr },
            create: function () {
                this.virtualList = ht({
                    defaultSelector: ".virtual-list",
                    constructor: Lr,
                    app: this,
                    domProp: "f7VirtualList",
                });
            },
        },
        Rr = (function (e) {
            function t(t, a) {
                var r;
                void 0 === a && (a = {});
                var n,
                    o,
                    i,
                    s,
                    l = ze((r = e.call(this, a, [t]) || this)),
                    c = {
                        el: null,
                        listEl: null,
                        indexes: "auto",
                        iosItemHeight: 14,
                        mdItemHeight: 14,
                        auroraItemHeight: 14,
                        scrollList: !0,
                        label: !1,
                        renderItem: function (e, t) {
                            return (
                                "\n          <li>" +
                                e +
                                "</li>\n        "
                            ).trim();
                        },
                        renderSkipPlaceholder: function () {
                            return '<li class="list-index-skip-placeholder"></li>';
                        },
                        on: {},
                    };
                if (
                    (l.useModulesParams(c), (l.params = Qe(c, a)), !l.params.el)
                )
                    return l || ze(r);
                if ((n = Ee(l.params.el))[0].f7ListIndex)
                    return n[0].f7ListIndex || ze(r);
                if (
                    (0 === (s = n.find("ul")).length &&
                        ((s = Ee("<ul></ul>")), n.append(s)),
                    l.params.listEl && (o = Ee(l.params.listEl)),
                    "auto" === l.params.indexes && !o)
                )
                    return l || ze(r);
                function p() {
                    var e = { index: l };
                    l.calcSize(), e !== l.height && l.render();
                }
                function d(e) {
                    var t = Ee(e.target).closest("li");
                    if (t.length) {
                        var a = t.index();
                        if (l.skipRate > 0) {
                            var r = a / (t.siblings("li").length - 1);
                            a = Math.round((l.indexes.length - 1) * r);
                        }
                        var n = l.indexes[a];
                        l.$el.trigger("listindex:click", {
                            content: n,
                            index: a,
                        }),
                            l.emit("local::click listIndexClick", l, n, a),
                            l.$el.trigger("listindex:select", {
                                content: n,
                                index: a,
                            }),
                            l.emit("local::select listIndexSelect", l, n, a),
                            l.$listEl &&
                                l.params.scrollList &&
                                l.scrollListToIndex(n, a);
                    }
                }
                o
                    ? (i = o.parents(".page-content").eq(0))
                    : 0 === (i = n.siblings(".page-content").eq(0)).length &&
                      (i = n
                          .parents(".page")
                          .eq(0)
                          .find(".page-content")
                          .eq(0)),
                    (n[0].f7ListIndex = l),
                    Qe(l, {
                        app: t,
                        $el: n,
                        el: n && n[0],
                        $ul: s,
                        ul: s && s[0],
                        $listEl: o,
                        listEl: o && o[0],
                        $pageContentEl: i,
                        pageContentEl: i && i[0],
                        indexes: a.indexes,
                        height: 0,
                        skipRate: 0,
                    }),
                    l.useModules();
                var u,
                    h,
                    f,
                    v,
                    m,
                    g = {},
                    b = null;
                function y(e) {
                    var t = s.children();
                    t.length &&
                        ((f = t[0].getBoundingClientRect().top),
                        (v =
                            t[t.length - 1].getBoundingClientRect().top +
                            t[0].offsetHeight),
                        (g.x =
                            "touchstart" === e.type
                                ? e.targetTouches[0].pageX
                                : e.pageX),
                        (g.y =
                            "touchstart" === e.type
                                ? e.targetTouches[0].pageY
                                : e.pageY),
                        (u = !0),
                        (h = !1),
                        (b = null));
                }
                function w(e) {
                    if (u) {
                        !h &&
                            l.params.label &&
                            ((m = Ee('<span class="list-index-label"></span>')),
                            n.append(m)),
                            (h = !0);
                        var t =
                            "touchmove" === e.type
                                ? e.targetTouches[0].pageY
                                : e.pageY;
                        e.preventDefault();
                        var a = (t - f) / (v - f);
                        a = Math.min(Math.max(a, 0), 1);
                        var r = Math.round((l.indexes.length - 1) * a),
                            o = l.indexes[r],
                            i = v - f,
                            s = (l.height - i) / 2 + (1 - a) * i;
                        r !== b &&
                            (l.params.label &&
                                m.html(o).transform("translateY(-" + s + "px)"),
                            l.$listEl &&
                                l.params.scrollList &&
                                l.scrollListToIndex(o, r)),
                            (b = r),
                            l.$el.trigger("listindex:select"),
                            l.emit("local::select listIndexSelect", l, o, r);
                    }
                }
                function C() {
                    u &&
                        ((u = !1),
                        (h = !1),
                        l.params.label && (m && m.remove(), (m = void 0)));
                }
                var E = !!ct().passiveListener && { passive: !0 };
                return (
                    (l.attachEvents = function () {
                        n.parents(".tab").on("tab:show", p),
                            n.parents(".page").on("page:reinit", p),
                            n.parents(".panel").on("panel:open", p),
                            n
                                .parents(
                                    ".sheet-modal, .actions-modal, .popup, .popover, .login-screen, .dialog, .toast"
                                )
                                .on("modal:open", p),
                            t.on("resize", p),
                            n.on("click", d),
                            n.on(t.touchEvents.start, y, E),
                            t.on("touchmove:active", w),
                            t.on("touchend:passive", C);
                    }),
                    (l.detachEvents = function () {
                        n.parents(".tab").off("tab:show", p),
                            n.parents(".page").off("page:reinit", p),
                            n.parents(".panel").off("panel:open", p),
                            n
                                .parents(
                                    ".sheet-modal, .actions-modal, .popup, .popover, .login-screen, .dialog, .toast"
                                )
                                .off("modal:open", p),
                            t.off("resize", p),
                            n.off("click", d),
                            n.off(t.touchEvents.start, y, E),
                            t.off("touchmove:active", w),
                            t.off("touchend:passive", C);
                    }),
                    l.init(),
                    l || ze(r)
                );
            }
            Me(t, e);
            var a = t.prototype;
            return (
                (a.scrollListToIndex = function (e, t) {
                    var a,
                        r = this,
                        n = r.$listEl,
                        o = r.$pageContentEl,
                        i = r.app;
                    if (!n || !o || 0 === o.length) return r;
                    if (
                        (n
                            .find(".list-group-title, .item-divider")
                            .each(function (t) {
                                if (!a) {
                                    var r = Ee(t);
                                    r.text() === e && (a = r);
                                }
                            }),
                        !a || 0 === a.length)
                    )
                        return r;
                    var s = a.parent().offset().top,
                        l = parseInt(o.css("padding-top"), 10),
                        c = o[0].scrollTop,
                        p = a.offset().top;
                    if (o.parents(".page-with-navbar-large").length) {
                        var d = i.navbar.getElByPage(
                                o.parents(".page-with-navbar-large").eq(0)
                            ),
                            u = Ee(d).find(".title-large");
                        u.length && (l -= u[0].offsetHeight || 0);
                    }
                    return (
                        s <= l
                            ? o.scrollTop(s + c - l)
                            : o.scrollTop(p + c - l),
                        r
                    );
                }),
                (a.renderSkipPlaceholder = function () {
                    return this.params.renderSkipPlaceholder.call(this);
                }),
                (a.renderItem = function (e, t) {
                    return this.params.renderItem.call(this, e, t);
                }),
                (a.render = function () {
                    var e,
                        t = this,
                        a = t.$ul,
                        r = t.indexes,
                        n = t.skipRate,
                        o = r
                            .map(function (a, r) {
                                if (r % n != 0 && n > 0) return (e = !0), "";
                                var o = t.renderItem(a, r);
                                return (
                                    e && (o = t.renderSkipPlaceholder() + o),
                                    (e = !1),
                                    o
                                );
                            })
                            .join("");
                    return a.html(o), t;
                }),
                (a.calcSize = function () {
                    var e = this,
                        t = e.app,
                        a = e.params,
                        r = e.el,
                        n = e.indexes,
                        o = r.offsetHeight,
                        i = a[t.theme + "ItemHeight"],
                        s = Math.floor(o / i),
                        l = n.length,
                        c = 0;
                    return (
                        l > s && (c = Math.ceil((2 * l - 1) / s)),
                        (e.height = o),
                        (e.skipRate = c),
                        e
                    );
                }),
                (a.calcIndexes = function () {
                    var e = this;
                    return (
                        "auto" === e.params.indexes
                            ? ((e.indexes = []),
                              e.$listEl
                                  .find(".list-group-title, .item-divider")
                                  .each(function (t) {
                                      var a = Ee(t).text();
                                      e.indexes.indexOf(a) < 0 &&
                                          e.indexes.push(a);
                                  }))
                            : (e.indexes = e.params.indexes),
                        e
                    );
                }),
                (a.update = function () {
                    var e = this;
                    return e.calcIndexes(), e.calcSize(), e.render(), e;
                }),
                (a.init = function () {
                    var e = this;
                    e.calcIndexes(), e.calcSize(), e.render(), e.attachEvents();
                }),
                (a.destroy = function () {
                    var e = this;
                    e.$el.trigger("listindex:beforedestroy", e),
                        e.emit("local::beforeDestroy listIndexBeforeDestroy"),
                        e.detachEvents(),
                        e.$el[0] &&
                            ((e.$el[0].f7ListIndex = null),
                            delete e.$el[0].f7ListIndex),
                        Fe(e),
                        (e = null);
                }),
                t
            );
        })(ut),
        Ar = {
            name: "listIndex",
            static: { ListIndex: Rr },
            create: function () {
                this.listIndex = ht({
                    defaultSelector: ".list-index",
                    constructor: Rr,
                    app: this,
                    domProp: "f7ListIndex",
                });
            },
            on: {
                tabMounted: function (e) {
                    var t = this;
                    Ee(e)
                        .find(".list-index-init")
                        .each(function (e) {
                            var a = Qe(Ee(e).dataset(), { el: e });
                            t.listIndex.create(a);
                        });
                },
                tabBeforeRemove: function (e) {
                    Ee(e)
                        .find(".list-index-init")
                        .each(function (e) {
                            e.f7ListIndex && e.f7ListIndex.destroy();
                        });
                },
                pageInit: function (e) {
                    var t = this;
                    e.$el.find(".list-index-init").each(function (e) {
                        var a = Qe(Ee(e).dataset(), { el: e });
                        t.listIndex.create(a);
                    });
                },
                pageBeforeRemove: function (e) {
                    e.$el.find(".list-index-init").each(function (e) {
                        e.f7ListIndex && e.f7ListIndex.destroy();
                    });
                },
            },
            vnode: {
                "list-index-init": {
                    insert: function (e) {
                        var t = e.elm,
                            a = Qe(Ee(t).dataset(), { el: t });
                        this.listIndex.create(a);
                    },
                    destroy: function (e) {
                        var t = e.elm;
                        t.f7ListIndex && t.f7ListIndex.destroy();
                    },
                },
            },
        },
        Dr = {
            show: function () {
                for (
                    var e,
                        t,
                        a,
                        r,
                        n,
                        o = this,
                        i = arguments.length,
                        s = new Array(i),
                        l = 0;
                    l < i;
                    l++
                )
                    s[l] = arguments[l];
                1 === s.length && s[0] && s[0].constructor === Object
                    ? ((e = s[0].tabEl),
                      (t = s[0].tabLinkEl),
                      (a = s[0].animate),
                      (r = s[0].tabRoute),
                      (n = s[0].animatedInit))
                    : ((e = s[0]),
                      (t = s[1]),
                      (a = s[2]),
                      (r = s[3]),
                      "boolean" == typeof s[1] &&
                          ((e = s[0]),
                          (a = s[1]),
                          (t = s[2]),
                          (r = s[3]),
                          s.length > 2 &&
                              t.constructor === Object &&
                              ((e = s[0]),
                              (a = s[1]),
                              (r = s[2]),
                              (t = s[3])))),
                    void 0 === a && (a = !0);
                var c,
                    p = Ee(e);
                if (
                    (r && p[0] && (p[0].f7TabRoute = r),
                    !n && (0 === p.length || p.hasClass("tab-active")))
                )
                    return { $newTabEl: p, newTabEl: p[0] };
                t && (c = Ee(t));
                var d = p.parent(".tabs");
                if (0 === d.length) return { $newTabEl: p, newTabEl: p[0] };
                o.swipeout && (o.swipeout.allowOpen = !0);
                var u = [];
                function h(e) {
                    u.push(e);
                }
                function f() {
                    u.forEach(function (e) {
                        e();
                    });
                }
                var v,
                    m = !1;
                if (d.parent().hasClass("tabs-animated-wrap")) {
                    d.parent()[a ? "removeClass" : "addClass"]("not-animated");
                    var g = parseFloat(
                        d.css("transition-duration").replace(",", ".")
                    );
                    a && g && (d.transitionEnd(f), (m = !0));
                    var b = 100 * (o.rtl ? p.index() : -p.index());
                    d.transform("translate3d(" + b + "%,0,0)");
                }
                d.parent().hasClass("tabs-swipeable-wrap") &&
                    o.swiper &&
                    ((v = d.parent()[0].swiper) && v.activeIndex !== p.index()
                        ? ((m = !0),
                          v
                              .once("slideChangeTransitionEnd", function () {
                                  f();
                              })
                              .slideTo(p.index(), a ? void 0 : 0))
                        : v &&
                          v.animating &&
                          ((m = !0),
                          v.once("slideChangeTransitionEnd", function () {
                              f();
                          })));
                var y = d.children(".tab-active");
                if (
                    (y.removeClass("tab-active"),
                    !n &&
                        (!v || (v && !v.animating) || (v && r)) &&
                        (y.hasClass("view") &&
                            y.children(".page").length &&
                            y.children(".page").each(function (e) {
                                Ee(e).trigger("page:tabhide"),
                                    o.emit("pageTabHide", e);
                            }),
                        y.trigger("tab:hide"),
                        o.emit("tabHide", y[0])),
                    p.addClass("tab-active"),
                    !n &&
                        (!v || (v && !v.animating) || (v && r)) &&
                        (p.hasClass("view") &&
                            p.children(".page").length &&
                            p.children(".page").each(function (e) {
                                Ee(e).trigger("page:tabshow"),
                                    o.emit("pageTabShow", e);
                            }),
                        p.trigger("tab:show"),
                        o.emit("tabShow", p[0])),
                    !c &&
                        ((!(c = Ee(
                            "string" == typeof e
                                ? '.tab-link[href="' + e + '"]'
                                : '.tab-link[href="#' + p.attr("id") + '"]'
                        )) ||
                            (c && 0 === c.length)) &&
                            Ee("[data-tab]").each(function (e) {
                                p.is(Ee(e).attr("data-tab")) && (c = Ee(e));
                            }),
                        r &&
                            (!c || (c && 0 === c.length)) &&
                            0 ===
                                (c = Ee(
                                    '[data-route-tab-id="' +
                                        r.route.tab.id +
                                        '"]'
                                )).length &&
                            (c = Ee('.tab-link[href="' + r.url + '"]')),
                        c.length > 1 &&
                            p.parents(".page").length &&
                            ((c = c.filter(function (e) {
                                return (
                                    Ee(e).parents(".page")[0] ===
                                    p.parents(".page")[0]
                                );
                            })),
                            "ios" === o.theme && 0 === c.length && r)))
                ) {
                    var w = p.parents(".page"),
                        C = Ee(o.navbar.getElByPage(w));
                    0 ===
                        (c = C.find(
                            '[data-route-tab-id="' + r.route.tab.id + '"]'
                        )).length &&
                        (c = C.find('.tab-link[href="' + r.url + '"]'));
                }
                if (c.length > 0) {
                    var E;
                    if (y && y.length > 0) {
                        var k = y.attr("id");
                        k &&
                            (!(E = Ee('.tab-link[href="#' + k + '"]')) ||
                                (E && 0 === E.length)) &&
                            (E = Ee(
                                '.tab-link[data-route-tab-id="' + k + '"]'
                            )),
                            (!E || (E && 0 === E.length)) &&
                                Ee("[data-tab]").each(function (e) {
                                    y.is(Ee(e).attr("data-tab")) && (E = Ee(e));
                                }),
                            (!E || (E && 0 === E.length)) &&
                                (E = c.siblings(".tab-link-active"));
                    } else r && (E = c.siblings(".tab-link-active"));
                    if (
                        (E &&
                            E.length > 1 &&
                            y &&
                            y.parents(".page").length &&
                            (E = E.filter(function (e) {
                                return (
                                    Ee(e).parents(".page")[0] ===
                                    y.parents(".page")[0]
                                );
                            })),
                        E && E.length > 0 && E.removeClass("tab-link-active"),
                        c && c.length > 0)
                    ) {
                        c.addClass("tab-link-active");
                        var x = c.parents(".tabbar, .tabbar-labels"),
                            $ =
                                o.toolbar &&
                                x.length > 0 &&
                                (x.hasClass("tabbar-highlight") ||
                                    "ios" !== o.theme);
                        $ && o.toolbar.setHighlight(x);
                    }
                }
                return {
                    $newTabEl: p,
                    newTabEl: p[0],
                    $oldTabEl: y,
                    oldTabEl: y[0],
                    onTabsChanged: h,
                    animated: m,
                };
            },
        },
        Hr = {
            name: "tabs",
            create: function () {
                Qe(this, { tab: { show: Dr.show.bind(this) } });
            },
            on: {
                "pageInit tabMounted": function (e) {
                    var t = Ee(e.el || e).find(
                        ".tabs-animated-wrap > .tabs > .tab-active"
                    )[0];
                    if (t) {
                        this.tab.show({
                            tabEl: t,
                            animatedInit: !0,
                            animate: !1,
                        });
                    }
                },
            },
            clicks: {
                ".tab-link": function (e, t) {
                    if (
                        (void 0 === t && (t = {}),
                        (e.attr("href") && 0 === e.attr("href").indexOf("#")) ||
                            e.attr("data-tab"))
                    ) {
                        this.tab.show({
                            tabEl: t.tab || e.attr("href"),
                            tabLinkEl: e,
                            animate: t.animate,
                        });
                    }
                },
            },
        };
    function Nr(e) {
        var t = e.app,
            a = ct();
        if (!e.resizableInitialized) {
            Qe(e, {
                resizable: !0,
                resizableWidth: null,
                resizableInitialized: !0,
            });
            var r = Ee("html"),
                n = e.$el,
                o = e.$backdropEl,
                i = e.side,
                s = e.effect;
            if (n) {
                var l,
                    c,
                    p,
                    d,
                    u,
                    h,
                    f,
                    v,
                    m = {};
                0 === e.$el.find(".panel-resize-handler").length &&
                    e.$el.append('<div class="panel-resize-handler"></div>'),
                    (e.$resizeHandlerEl = e.$el.children(
                        ".panel-resize-handler"
                    )),
                    n.addClass("panel-resizable");
                var g = !!a.passiveListener && { passive: !0 };
                e.$el.on(t.touchEvents.start, ".panel-resize-handler", y, g),
                    t.on("touchmove:active", w),
                    t.on("touchend:passive", C),
                    t.on("resize", E),
                    e.on("beforeOpen", E),
                    e.once("panelDestroy", function () {
                        n.removeClass("panel-resizable"),
                            e.$resizeHandlerEl.remove(),
                            e.$el.off(
                                t.touchEvents.start,
                                ".panel-resize-handler",
                                y,
                                g
                            ),
                            t.off("touchmove:active", w),
                            t.off("touchend:passive", C),
                            t.off("resize", E),
                            e.off("beforeOpen", E);
                    });
            }
        }
        function b(e) {
            if (!e) return null;
            if (e.indexOf("%") >= 0 || e.indexOf("vw") >= 0)
                return (parseInt(e, 10) / 100) * t.width;
            var a = parseInt(e, 10);
            return Number.isNaN(a) ? null : a;
        }
        function y(t) {
            e.resizable &&
                n.hasClass("panel-resizable") &&
                ((m.x =
                    "touchstart" === t.type
                        ? t.targetTouches[0].pageX
                        : t.pageX),
                (m.y =
                    "touchstart" === t.type
                        ? t.targetTouches[0].pageY
                        : t.pageY),
                (c = !1),
                (l = !0),
                (h = b(n.css("min-width"))),
                (f = b(n.css("max-width"))),
                (v = n.hasClass("panel-in-breakpoint")));
        }
        function w(a) {
            if (l) {
                var g =
                    "touchmove" === a.type ? a.targetTouches[0].pageX : a.pageX;
                c ||
                    ((d = n[0].offsetWidth),
                    n.transition(0),
                    n.addClass("panel-resizing"),
                    r.css("cursor", "col-resize"),
                    ("cover" !== s || v) &&
                        ((u = Ee(e.getViewEl())),
                        e.$containerEl &&
                            e.$containerEl.hasClass("page") &&
                            u.add(
                                e.$containerEl.children(
                                    ".page-content, .tabs, .fab"
                                )
                            )),
                    "cover" === s || v || (o.transition(0), u.transition(0))),
                    (c = !0),
                    a.preventDefault(),
                    (p = g - m.x);
                var b = "left" === i ? d + p : d - p;
                h && !Number.isNaN(h) && (b = Math.max(b, h)),
                    f && !Number.isNaN(f) && (b = Math.min(b, f)),
                    (b = Math.min(Math.max(b, 0), t.width)),
                    (e.resizableWidth = b),
                    (n[0].style.width = b + "px"),
                    "cover" === s || v
                        ? v && u && u.css("margin-" + i, b + "px")
                        : (u &&
                              u.transform(
                                  "translate3d(" +
                                      ("left" === i ? b : -b) +
                                      "px, 0, 0)"
                              ),
                          o &&
                              o.transform(
                                  "translate3d(" +
                                      ("left" === i ? b : -b) +
                                      "px, 0, 0)"
                              )),
                    n.trigger("panel:resize", b),
                    e.emit("local::resize panelResize", e, b);
            }
        }
        function C() {
            if ((Ee("html").css("cursor", ""), !l || !c))
                return (l = !1), void (c = !1);
            (l = !1),
                (c = !1),
                r[0].style.setProperty(
                    "--f7-panel-" + i + "-width",
                    e.resizableWidth + "px"
                ),
                (n[0].style.width = ""),
                "cover" === s || v || (u.transform(""), o.transform("")),
                n.removeClass("panel-resizing"),
                _e(function () {
                    n.transition(""),
                        "cover" !== s &&
                            (o.transition(""), u && u.transition(""));
                });
        }
        function E() {
            e.opened &&
                e.resizableWidth &&
                ((h = b(n.css("min-width"))),
                (f = b(n.css("max-width"))),
                h &&
                    !Number.isNaN(h) &&
                    e.resizableWidth < h &&
                    (e.resizableWidth = Math.max(e.resizableWidth, h)),
                f &&
                    !Number.isNaN(f) &&
                    e.resizableWidth > f &&
                    (e.resizableWidth = Math.min(e.resizableWidth, f)),
                (e.resizableWidth = Math.min(
                    Math.max(e.resizableWidth, 0),
                    t.width
                )),
                r[0].style.setProperty(
                    "--f7-panel-" + i + "-width",
                    e.resizableWidth + "px"
                ));
        }
    }
    var Vr = (function (e) {
            function t(t, a) {
                var r;
                void 0 === a && (a = {});
                var n,
                    o = Qe({ on: {} }, t.params.panel, a),
                    i = ze((r = e.call(this, o, [t]) || this));
                if (
                    ((i.params = o),
                    (i.$containerEl = i.params.containerEl
                        ? Ee(i.params.containerEl).eq(0)
                        : t.$el),
                    (i.containerEl = i.$containerEl[0]),
                    i.containerEl ||
                        ((i.$containerEl = t.$el), (i.containerEl = t.$el[0])),
                    i.params.el
                        ? (n = Ee(i.params.el).eq(0))
                        : i.params.content &&
                          (n = Ee(i.params.content)
                              .filter(function (e) {
                                  return 1 === e.nodeType;
                              })
                              .eq(0)),
                    0 === n.length)
                )
                    return i || ze(r);
                if (n[0].f7Panel) return n[0].f7Panel || ze(r);
                n[0].f7Panel = i;
                var s,
                    l = i.params,
                    c = l.side,
                    p = l.effect,
                    d = l.resizable;
                return (
                    void 0 === c &&
                        (c = n.hasClass("panel-left") ? "left" : "right"),
                    void 0 === p &&
                        (p = n.hasClass("panel-cover")
                            ? "cover"
                            : n.hasClass("panel-push")
                            ? "push"
                            : "reveal"),
                    void 0 === d && (d = n.hasClass("panel-resizable")),
                    i.params.backdrop && i.params.backdropEl
                        ? (s = Ee(i.params.backdropEl))
                        : i.params.backdrop &&
                          0 ===
                              (s = i.$containerEl.children(".panel-backdrop"))
                                  .length &&
                          ((s = Ee('<div class="panel-backdrop"></div>')),
                          i.$containerEl.prepend(s)),
                    Qe(i, {
                        app: t,
                        side: c,
                        effect: p,
                        resizable: d,
                        $el: n,
                        el: n[0],
                        opened: !1,
                        $backdropEl: s,
                        backdropEl: s && s[0],
                    }),
                    i.useModules(),
                    i.init(),
                    i || ze(r)
                );
            }
            Me(t, e);
            var a = t.prototype;
            return (
                (a.getViewEl = function () {
                    var e = this;
                    return e.$containerEl.children(".views").length > 0
                        ? e.$containerEl.children(".views")[0]
                        : e.$containerEl.children(".view")[0];
                }),
                (a.setStateClasses = function (e) {
                    var t = this,
                        a = t.side,
                        r = t.el,
                        n = t.getViewEl(),
                        o = n && n.contains(r),
                        i = !n || o ? t.$containerEl : Ee("html");
                    "open" === e &&
                        i.addClass(
                            "with-panel with-panel-" + t.side + "-" + t.effect
                        ),
                        "before-closing" === e &&
                            i.addClass("with-panel-closing"),
                        "closing" === e &&
                            (i.addClass("with-panel-closing"),
                            i.removeClass(
                                "with-panel with-panel-" +
                                    t.side +
                                    "-" +
                                    t.effect
                            )),
                        "after-closing" === e &&
                            i.removeClass("with-panel-closing"),
                        "closed" === e &&
                            i.removeClass(
                                "with-panel-" +
                                    a +
                                    "-reveal with-panel-" +
                                    a +
                                    "-cover with-panel-" +
                                    a +
                                    "-push with-panel"
                            );
                }),
                (a.enableVisibleBreakpoint = function () {
                    var e = this;
                    return (
                        (e.visibleBreakpointDisabled = !1),
                        e.setVisibleBreakpoint(),
                        e
                    );
                }),
                (a.disableVisibleBreakpoint = function () {
                    var e = this;
                    return (
                        (e.visibleBreakpointDisabled = !0),
                        e.setVisibleBreakpoint(),
                        e
                    );
                }),
                (a.toggleVisibleBreakpoint = function () {
                    var e = this;
                    return (
                        (e.visibleBreakpointDisabled =
                            !e.visibleBreakpointDisabled),
                        e.setVisibleBreakpoint(),
                        e
                    );
                }),
                (a.setVisibleBreakpoint = function (e) {
                    void 0 === e && (e = !0);
                    var t = this,
                        a = t.app;
                    t.visibleBreakpointResizeHandler ||
                        ((t.visibleBreakpointResizeHandler = function () {
                            t.setVisibleBreakpoint();
                        }),
                        a.on("resize", t.visibleBreakpointResizeHandler));
                    var r,
                        n,
                        o = t.side,
                        i = t.$el,
                        s = t.$containerEl,
                        l = t.params,
                        c = t.visibleBreakpointDisabled,
                        p = l.visibleBreakpoint,
                        d = Ee(t.getViewEl()),
                        u = i.hasClass("panel-in-breakpoint");
                    if (
                        (s &&
                            s.hasClass("page") &&
                            d.add(s.children(".page-content, .tabs, .fab")),
                        a.width >= p && null != p && !c)
                    )
                        u
                            ? d.css(
                                  (((r = {})["margin-" + o] = i.width() + "px"),
                                  r)
                              )
                            : (t.setStateClasses("closed"),
                              i
                                  .addClass("panel-in-breakpoint")
                                  .removeClass("panel-in panel-in-collapsed"),
                              t.onOpen(!1),
                              t.onOpened(),
                              d.css(
                                  (((n = {})["margin-" + o] = i.width() + "px"),
                                  n)
                              ),
                              (a.allowPanelOpen = !0),
                              e &&
                                  (t.emit(
                                      "local::breakpoint panelBreakpoint",
                                      t
                                  ),
                                  t.$el.trigger("panel:breakpoint")));
                    else if (u) {
                        var h;
                        i.removeClass("panel-in-breakpoint panel-in"),
                            t.onClose(),
                            t.onClosed(),
                            d.css((((h = {})["margin-" + o] = ""), h)),
                            e &&
                                (t.emit("local::breakpoint panelBreakpoint", t),
                                t.$el.trigger("panel:breakpoint"));
                    }
                }),
                (a.enableCollapsedBreakpoint = function () {
                    var e = this;
                    return (
                        (e.collapsedBreakpointDisabled = !1),
                        e.setCollapsedBreakpoint(),
                        e
                    );
                }),
                (a.disableCollapsedBreakpoint = function () {
                    var e = this;
                    return (
                        (e.collapsedBreakpointDisabled = !0),
                        e.setCollapsedBreakpoint(),
                        e
                    );
                }),
                (a.toggleCollapsedBreakpoint = function () {
                    var e = this;
                    return (
                        (e.collapsedBreakpointDisabled =
                            !e.collapsedBreakpointDisabled),
                        e.setCollapsedBreakpoint(),
                        e
                    );
                }),
                (a.setCollapsedBreakpoint = function (e) {
                    void 0 === e && (e = !0);
                    var t = this,
                        a = t.app;
                    t.collapsedBreakpointResizeHandler ||
                        ((t.collapsedBreakpointResizeHandler = function () {
                            t.setCollapsedBreakpoint();
                        }),
                        a.on("resize", t.collapsedBreakpointResizeHandler));
                    var r = t.$el,
                        n = t.params,
                        o = t.collapsedBreakpointDisabled;
                    if (!r.hasClass("panel-in-breakpoint")) {
                        var i = n.collapsedBreakpoint,
                            s = r.hasClass("panel-in-collapsed");
                        a.width >= i && null != i && !o
                            ? s ||
                              (t.setStateClasses("closed"),
                              r
                                  .addClass("panel-in-collapsed")
                                  .removeClass("panel-in"),
                              (t.collapsed = !0),
                              (a.allowPanelOpen = !0),
                              e &&
                                  (t.emit(
                                      "local::collapsedBreakpoint panelCollapsedBreakpoint",
                                      t
                                  ),
                                  t.$el.trigger("panel:collapsedbreakpoint")))
                            : s &&
                              (r.removeClass("panel-in-collapsed panel-in"),
                              (t.collapsed = !1),
                              e &&
                                  (t.emit(
                                      "local::collapsedBreakpoint panelCollapsedBreakpoint",
                                      t
                                  ),
                                  t.$el.trigger("panel:collapsedbreakpoint")));
                    }
                }),
                (a.enableResizable = function () {
                    var e = this;
                    return (
                        e.resizableInitialized
                            ? ((e.resizable = !0),
                              e.$el.addClass("panel-resizable"))
                            : Nr(e),
                        e
                    );
                }),
                (a.disableResizable = function () {
                    var e = this;
                    return (
                        (e.resizable = !1),
                        e.$el.removeClass("panel-resizable"),
                        e
                    );
                }),
                (a.enableSwipe = function () {
                    var e = this;
                    return (
                        e.swipeInitialized
                            ? (e.swipeable = !0)
                            : (function (e) {
                                  var t = e.app;
                                  if (!e.swipeInitialized) {
                                      Qe(e, {
                                          swipeable: !0,
                                          swipeInitialized: !0,
                                      });
                                      var a,
                                          r,
                                          n,
                                          o,
                                          i,
                                          s,
                                          l,
                                          c,
                                          p,
                                          d,
                                          u,
                                          h,
                                          f,
                                          v = e.params,
                                          m = e.$el,
                                          g = e.$backdropEl,
                                          b = e.side,
                                          y = e.effect,
                                          w = {},
                                          C = 0;
                                      t.on("touchstart:passive", E),
                                          t.on("touchmove:active", k),
                                          t.on("touchend:passive", x),
                                          t.on("gesturestart", $),
                                          t.on("gestureend", T),
                                          e.on("panelDestroy", function () {
                                              t.off("touchstart:passive", E),
                                                  t.off("touchmove:active", k),
                                                  t.off("touchend:passive", x),
                                                  t.off("gesturestart", $),
                                                  t.off("gestureend", T);
                                          });
                                  }
                                  function E(c) {
                                      if (
                                          e.swipeable &&
                                          !n &&
                                          t.panel.allowOpen &&
                                          (v.swipe || v.swipeOnlyClose) &&
                                          !r &&
                                          !(
                                              Ee(
                                                  ".modal-in:not(.toast):not(.notification), .photo-browser-in"
                                              ).length > 0
                                          )
                                      ) {
                                          var p =
                                              (a =
                                                  t.panel.get(
                                                      "left" === b
                                                          ? "right"
                                                          : "left"
                                                  ) || {}).opened &&
                                              a.$el &&
                                              !a.$el.hasClass(
                                                  "panel-in-breakpoint"
                                              );
                                          if (
                                              (e.opened || !p) &&
                                              (v.swipeOnlyClose || !p) &&
                                              (!c.target ||
                                                  "input" !==
                                                      c.target.nodeName.toLowerCase() ||
                                                  "range" !== c.target.type) &&
                                              !(
                                                  Ee(c.target).closest(
                                                      ".range-slider, .tabs-swipeable-wrap, .calendar-months, .no-swipe-panel, .card-opened"
                                                  ).length > 0
                                              ) &&
                                              ((w.x =
                                                  "touchstart" === c.type
                                                      ? c.targetTouches[0].pageX
                                                      : c.pageX),
                                              (w.y =
                                                  "touchstart" === c.type
                                                      ? c.targetTouches[0].pageY
                                                      : c.pageY),
                                              !v.swipeOnlyClose || e.opened)
                                          ) {
                                              if (
                                                  v.swipeActiveArea &&
                                                  !e.opened
                                              ) {
                                                  if (
                                                      "left" === b &&
                                                      w.x > v.swipeActiveArea
                                                  )
                                                      return;
                                                  if (
                                                      "right" === b &&
                                                      w.x <
                                                          t.width -
                                                              v.swipeActiveArea
                                                  )
                                                      return;
                                              }
                                              (C = 0),
                                                  (f = Ee(e.getViewEl())),
                                                  (o = !1),
                                                  (r = !0),
                                                  (i = void 0),
                                                  (s = !1),
                                                  (l = Ye()),
                                                  (h = void 0);
                                          }
                                      }
                                  }
                                  function k(a) {
                                      if (r && !n && !s && !((C += 1) < 2))
                                          if (
                                              a.f7PreventSwipePanel ||
                                              t.preventSwipePanelBySwipeBack ||
                                              t.preventSwipePanel
                                          )
                                              r = !1;
                                          else {
                                              var l =
                                                      "touchmove" === a.type
                                                          ? a.targetTouches[0]
                                                                .pageX
                                                          : a.pageX,
                                                  E =
                                                      "touchmove" === a.type
                                                          ? a.targetTouches[0]
                                                                .pageY
                                                          : a.pageY;
                                              if (
                                                  (void 0 === i &&
                                                      (i = !!(
                                                          i ||
                                                          Math.abs(E - w.y) >
                                                              Math.abs(l - w.x)
                                                      )),
                                                  i)
                                              )
                                                  r = !1;
                                              else {
                                                  if (!h) {
                                                      if (
                                                          ((h =
                                                              l > w.x
                                                                  ? "to-right"
                                                                  : "to-left"),
                                                          v.swipeActiveArea >
                                                              0 && !e.opened)
                                                      ) {
                                                          if (
                                                              "left" === b &&
                                                              w.x >
                                                                  v.swipeActiveArea
                                                          )
                                                              return void (r =
                                                                  !1);
                                                          if (
                                                              "right" === b &&
                                                              w.x <
                                                                  t.width -
                                                                      v.swipeActiveArea
                                                          )
                                                              return void (r =
                                                                  !1);
                                                      }
                                                      if (
                                                          m.hasClass(
                                                              "panel-in-breakpoint"
                                                          )
                                                      )
                                                          return void (r = !1);
                                                      if (
                                                          ("left" === b &&
                                                              "to-left" === h &&
                                                              !m.hasClass(
                                                                  "panel-in"
                                                              )) ||
                                                          ("right" === b &&
                                                              "to-right" ===
                                                                  h &&
                                                              !m.hasClass(
                                                                  "panel-in"
                                                              ))
                                                      )
                                                          return void (r = !1);
                                                  }
                                                  var k = e.opened
                                                      ? 0
                                                      : -v.swipeThreshold;
                                                  "right" === b && (k = -k),
                                                      o ||
                                                          (e.opened ||
                                                              (e.insertToRoot(),
                                                              m.addClass(
                                                                  "panel-in-swipe"
                                                              ),
                                                              g.css(
                                                                  "visibility",
                                                                  "visible"
                                                              ),
                                                              m.trigger(
                                                                  "panel:swipeopen"
                                                              ),
                                                              e.emit(
                                                                  "local::swipeOpen panelSwipeOpen",
                                                                  e
                                                              )),
                                                          (u =
                                                              m[0].offsetWidth),
                                                          "reveal" === y &&
                                                              m.hasClass(
                                                                  "panel-in-collapsed"
                                                              ) &&
                                                              (u -= parseFloat(
                                                                  f.css(
                                                                      "margin-" +
                                                                          b
                                                                  )
                                                              )),
                                                          m.transition(0)),
                                                      (o = !0),
                                                      a.cancelable &&
                                                          a.preventDefault(),
                                                      (c = l - w.x + k),
                                                      "right" === b
                                                          ? "cover" === y ||
                                                            "push" === y
                                                              ? ((p =
                                                                    c +
                                                                    (e.opened
                                                                        ? 0
                                                                        : u)) <
                                                                    0 &&
                                                                    (p = 0),
                                                                p > u &&
                                                                    (p = u))
                                                              : ((p =
                                                                    c -
                                                                    (e.opened
                                                                        ? u
                                                                        : 0)) >
                                                                    0 &&
                                                                    (p = 0),
                                                                p < -u &&
                                                                    (p = -u))
                                                          : ((p =
                                                                c +
                                                                (e.opened
                                                                    ? u
                                                                    : 0)) < 0 &&
                                                                (p = 0),
                                                            p > u && (p = u));
                                                  var $ = Math.abs(p / u);
                                                  if ("reveal" === y)
                                                      v.swipeNoFollow ||
                                                          (f
                                                              .transform(
                                                                  "translate3d(" +
                                                                      p +
                                                                      "px,0,0)"
                                                              )
                                                              .transition(0),
                                                          g
                                                              .transform(
                                                                  "translate3d(" +
                                                                      p +
                                                                      "px,0,0)"
                                                              )
                                                              .transition(0)),
                                                          m.trigger(
                                                              "panel:swipe",
                                                              Math.abs(p / u)
                                                          ),
                                                          e.emit(
                                                              "local::swipe panelSwipe",
                                                              e,
                                                              Math.abs(p / u)
                                                          );
                                                  else {
                                                      if (
                                                          ("left" === b &&
                                                              (p -= u),
                                                          !v.swipeNoFollow &&
                                                              (g.transition(0),
                                                              (d =
                                                                  1 -
                                                                  Math.abs(
                                                                      p / u
                                                                  )),
                                                              g.css({
                                                                  opacity: d,
                                                              }),
                                                              m
                                                                  .transform(
                                                                      "translate3d(" +
                                                                          p +
                                                                          "px,0,0)"
                                                                  )
                                                                  .transition(
                                                                      0
                                                                  ),
                                                              "push" === y))
                                                      ) {
                                                          var T =
                                                              "left" === b
                                                                  ? p + u
                                                                  : p - u;
                                                          f
                                                              .transform(
                                                                  "translate3d(" +
                                                                      T +
                                                                      "px,0,0)"
                                                              )
                                                              .transition(0),
                                                              g
                                                                  .transform(
                                                                      "translate3d(" +
                                                                          T +
                                                                          "px,0,0)"
                                                                  )
                                                                  .transition(
                                                                      0
                                                                  );
                                                      }
                                                      m.trigger(
                                                          "panel:swipe",
                                                          Math.abs(p / u)
                                                      ),
                                                          e.emit(
                                                              "local::swipe panelSwipe",
                                                              e,
                                                              Math.abs(p / u)
                                                          );
                                                  }
                                                  v.swipeNoFollow &&
                                                      ((e.opened && 0 === $) ||
                                                          (!e.opened &&
                                                              1 === $)) &&
                                                      ((s = !0), x(a));
                                              }
                                          }
                                  }
                                  function x(t) {
                                      if (!r || !o)
                                          return (r = !1), void (o = !1);
                                      var a = "gesturestart" === t.type || n;
                                      (r = !1), (o = !1);
                                      var i,
                                          s = new Date().getTime() - l,
                                          d =
                                              (0 === p || Math.abs(p) === u) &&
                                              !v.swipeNoFollow,
                                          h = v.swipeThreshold || 0;
                                      "swap" ==
                                          (i = a
                                              ? "reset"
                                              : e.opened
                                              ? "cover" === y || "push" === y
                                                  ? 0 === p
                                                      ? "reset"
                                                      : s < 300 &&
                                                        Math.abs(p) > 0
                                                      ? "swap"
                                                      : s >= 300 &&
                                                        Math.abs(p) < u / 2
                                                      ? "reset"
                                                      : "swap"
                                                  : p === -u
                                                  ? "reset"
                                                  : (s < 300 &&
                                                        Math.abs(p) >= 0) ||
                                                    (s >= 300 &&
                                                        Math.abs(p) <= u / 2)
                                                  ? "left" === b && p === u
                                                      ? "reset"
                                                      : "swap"
                                                  : "reset"
                                              : Math.abs(c) < h
                                              ? "reset"
                                              : "cover" === y || "push" === y
                                              ? 0 === p ||
                                                (s < 300 && Math.abs(p) > 0) ||
                                                (s >= 300 &&
                                                    Math.abs(p) < u / 2)
                                                  ? "swap"
                                                  : "reset"
                                              : 0 === p
                                              ? "reset"
                                              : (s < 300 && Math.abs(p) > 0) ||
                                                (s >= 300 &&
                                                    Math.abs(p) >= u / 2)
                                              ? "swap"
                                              : "reset") &&
                                          (e.opened ? e.close(!d) : e.open(!d));
                                      var w = !0;
                                      if ("reset" === i && !e.opened)
                                          if (d)
                                              m.removeClass("panel-in-swipe");
                                          else {
                                              w = !1;
                                              var C = "reveal" === y ? f : m;
                                              e.setStateClasses(
                                                  "before-closing"
                                              ),
                                                  C.transitionEnd(function () {
                                                      m.hasClass("panel-in") ||
                                                          (m.removeClass(
                                                              "panel-in-swipe"
                                                          ),
                                                          e.setStateClasses(
                                                              "after-closing"
                                                          ));
                                                  });
                                          }
                                      ("reveal" !== y && "push" !== y) ||
                                          _e(function () {
                                              f.transition(""), f.transform("");
                                          }),
                                          w && m.removeClass("panel-in-swipe"),
                                          m.transition("").transform(""),
                                          g
                                              .transform("")
                                              .transition("")
                                              .css({
                                                  opacity: "",
                                                  visibility: "",
                                              });
                                  }
                                  function $(e) {
                                      (n = !0), x(e);
                                  }
                                  function T() {
                                      n = !1;
                                  }
                              })(e),
                        e
                    );
                }),
                (a.disableSwipe = function () {
                    return (this.swipeable = !1), this;
                }),
                (a.onOpen = function (e) {
                    void 0 === e && (e = !0);
                    var t = this,
                        a = t.app;
                    (t.opened = !0),
                        (a.panel.allowOpen = !1),
                        t.$el.trigger("panel:beforeopen"),
                        t.emit("local::beforeOpen panelBeforeOpen", t),
                        e && t.setStateClasses("open"),
                        t.$el.trigger("panel:open"),
                        t.emit("local::open panelOpen", t);
                }),
                (a.onOpened = function () {
                    var e = this;
                    (e.app.panel.allowOpen = !0),
                        e.$el.trigger("panel:opened"),
                        e.emit("local::opened panelOpened", e);
                }),
                (a.onClose = function () {
                    var e = this,
                        t = e.app;
                    (e.opened = !1),
                        (t.panel.allowOpen = !1),
                        e.$el.trigger("panel:beforeclose"),
                        e.emit("local::beforeClose panelBeforeClose", e),
                        e.setStateClasses("closing"),
                        e.$el.trigger("panel:close"),
                        e.emit("local::close panelClose", e);
                }),
                (a.onClosed = function () {
                    var e = this,
                        t = e.app;
                    if (
                        ((t.panel.allowOpen = !0),
                        e.setStateClasses("after-closing"),
                        e.$el.removeClass("panel-out"),
                        e.$backdropEl)
                    ) {
                        var a = t.panel.get(".panel-in");
                        (!a || (a && !a.$backdropEl)) &&
                            e.$backdropEl.removeClass("panel-backdrop-in");
                    }
                    e.$el.trigger("panel:closed"),
                        e.emit("local::closed panelClosed", e);
                }),
                (a.toggle = function (e) {
                    void 0 === e && (e = !0);
                    var t = this,
                        a = t.params.visibleBreakpoint;
                    return t.app.width >= a && null != a
                        ? t.toggleVisibleBreakpoint()
                        : (t.opened ? t.close(e) : t.open(e), t);
                }),
                (a.insertToRoot = function () {
                    var e = this,
                        t = r(),
                        a = e.$el,
                        n = e.$backdropEl,
                        o = e.$containerEl,
                        i = a.parent(),
                        s = a.parents(t).length > 0;
                    if (!i.is(o) || a.prevAll(".views, .view").length) {
                        var l = o.children(".panel, .views, .view").eq(0),
                            c = o.children(".panel-backdrop").eq(0);
                        l.length
                            ? a.insertBefore(l)
                            : c
                            ? a.insertBefore(c)
                            : o.prepend(a),
                            n &&
                                n.length &&
                                ((!n.parent().is(o) &&
                                    0 === n.nextAll(".panel").length) ||
                                    (n.parent().is(o) &&
                                        0 === n.nextAll(".panel").length)) &&
                                n.insertBefore(a),
                            e.once("panelClosed", function () {
                                s ? i.append(a) : a.remove();
                            });
                    }
                }),
                (a.open = function (e) {
                    void 0 === e && (e = !0);
                    var t = this,
                        a = t.app;
                    if (!a.panel.allowOpen) return !1;
                    var r = t.effect,
                        n = t.$el,
                        o = t.$backdropEl,
                        i = t.opened,
                        s = t.$containerEl;
                    if (!n || n.hasClass("panel-in")) return t;
                    if (
                        (t.insertToRoot(),
                        i ||
                            n.hasClass("panel-in-breakpoint") ||
                            n.hasClass("panel-in"))
                    )
                        return !1;
                    var l = a.panel.get(".panel-in");
                    l && l !== t && l.close(e),
                        n[e ? "removeClass" : "addClass"]("not-animated"),
                        n.addClass("panel-in"),
                        o &&
                            (o.addClass("panel-backdrop-in"),
                            o[e ? "removeClass" : "addClass"]("not-animated")),
                        ("cover" !== t.effect && "push" !== t.effect) ||
                            (t._clientLeft = n[0].clientLeft);
                    var c = Ee(t.getViewEl());
                    s &&
                        s.hasClass("page") &&
                        c.add(s.children(".page-content, .tabs"));
                    var p = "reveal" === r ? c : n;
                    return (
                        e
                            ? (o && o.removeClass("not-animated"),
                              (function e() {
                                  p.transitionEnd(function (a) {
                                      Ee(a.target).is(p)
                                          ? n.hasClass("panel-out")
                                              ? t.onClosed()
                                              : t.onOpened()
                                          : e();
                                  });
                              })(),
                              n
                                  .removeClass("panel-out not-animated")
                                  .addClass("panel-in"),
                              t.onOpen())
                            : (o && o.addClass("not-animated"),
                              n
                                  .removeClass("panel-out")
                                  .addClass("panel-in not-animated"),
                              t.onOpen(),
                              t.onOpened()),
                        !0
                    );
                }),
                (a.close = function (e) {
                    void 0 === e && (e = !0);
                    var t = this,
                        a = t.effect,
                        r = t.$el,
                        n = t.$backdropEl,
                        o = t.opened,
                        i = t.$containerEl;
                    if (
                        !o ||
                        r.hasClass("panel-in-breakpoint") ||
                        !r.hasClass("panel-in")
                    )
                        return t;
                    r[e ? "removeClass" : "addClass"]("not-animated"),
                        n && n[e ? "removeClass" : "addClass"]("not-animated");
                    var s = Ee(t.getViewEl());
                    return (
                        i &&
                            i.hasClass("page") &&
                            s.add(i.children(".page-content, .tabs")),
                        e
                            ? (("reveal" === a ? s : r).transitionEnd(
                                  function () {
                                      r.hasClass("panel-out")
                                          ? t.onClosed()
                                          : r.hasClass("panel-in") &&
                                            t.onOpened(),
                                          t.setStateClasses("after-closing");
                                  }
                              ),
                              r.removeClass("panel-in").addClass("panel-out"),
                              t.onClose())
                            : (r
                                  .addClass("not-animated")
                                  .removeClass("panel-in")
                                  .addClass("panel-out"),
                              t.onClose(),
                              t.onClosed()),
                        t
                    );
                }),
                (a.init = function () {
                    var e = this;
                    void 0 !== e.params.visibleBreakpoint &&
                        e.setVisibleBreakpoint(),
                        void 0 !== e.params.collapsedBreakpoint &&
                            e.setCollapsedBreakpoint(),
                        e.params.swipe && e.enableSwipe(),
                        e.resizable && e.enableResizable();
                }),
                (a.destroy = function () {
                    var e = this,
                        t = e.app,
                        a = e.$containerEl;
                    if (e.$el) {
                        if (
                            (e.emit(
                                "local::beforeDestroy panelBeforeDestroy",
                                e
                            ),
                            e.$el.trigger("panel:beforedestroy"),
                            e.visibleBreakpointResizeHandler &&
                                t.off(
                                    "resize",
                                    e.visibleBreakpointResizeHandler
                                ),
                            e.collapsedBreakpointResizeHandler &&
                                t.off(
                                    "resize",
                                    e.collapsedBreakpointResizeHandler
                                ),
                            e.$el.hasClass("panel-in-breakpoint") ||
                                e.$el.hasClass("panel-in-collapsed"))
                        ) {
                            var r,
                                n = Ee(e.getViewEl());
                            a &&
                                a.hasClass("page") &&
                                n.add(a.children(".page-content, .tabs")),
                                e.$el.removeClass(
                                    "panel-in-breakpoint panel-in-collapsed panel-in"
                                ),
                                n.css((((r = {})["margin-" + e.side] = ""), r)),
                                e.emit("local::breakpoint panelBreakpoint", e),
                                e.$el.trigger("panel:breakpoint");
                        }
                        e.$el.trigger("panel:destroy"),
                            e.emit("local::destroy panelDestroy", e),
                            e.el &&
                                ((e.el.f7Panel = null), delete e.el.f7Panel),
                            Fe(e),
                            (e = null);
                    }
                }),
                t
            );
        })(ut),
        Fr = {
            name: "panel",
            params: {
                panel: {
                    opened: void 0,
                    side: void 0,
                    effect: void 0,
                    resizable: void 0,
                    backdrop: !0,
                    backdropEl: void 0,
                    visibleBreakpoint: void 0,
                    collapsedBreakpoint: void 0,
                    swipe: !1,
                    swipeNoFollow: !1,
                    swipeOnlyClose: !1,
                    swipeActiveArea: 0,
                    swipeThreshold: 0,
                    closeByBackdropClick: !0,
                    containerEl: void 0,
                },
            },
            static: { Panel: Vr },
            create: function () {
                var e = this;
                Qe(e, {
                    panel: {
                        allowOpen: !0,
                        create: function (t) {
                            return new Vr(e, t);
                        },
                        get: function (e) {
                            if (
                                (void 0 === e && (e = ".panel"),
                                e instanceof Vr)
                            )
                                return e;
                            ("left" !== e && "right" !== e) ||
                                (e = ".panel-" + e);
                            var t = Ee(e);
                            return 0 === t.length || t.length > 1
                                ? void 0
                                : t[0].f7Panel;
                        },
                        destroy: function (t) {
                            void 0 === t && (t = ".panel");
                            var a = e.panel.get(t);
                            if (a && a.destroy) return a.destroy();
                        },
                        open: function (t, a) {
                            void 0 === t && (t = ".panel"),
                                ("left" !== t && "right" !== t) ||
                                    (t = ".panel-" + t);
                            var r = e.panel.get(t);
                            return r && r.open
                                ? r.open(a)
                                : r
                                ? void 0
                                : (r = e.panel.create({ el: t })).open(a);
                        },
                        close: function (t, a) {
                            void 0 === t && (t = ".panel-in"),
                                ("left" !== t && "right" !== t) ||
                                    (t = ".panel-" + t);
                            var r = e.panel.get(t);
                            return r && r.open
                                ? r.close(a)
                                : r
                                ? void 0
                                : (r = e.panel.create({ el: t })).close(a);
                        },
                        toggle: function (t, a) {
                            void 0 === t && (t = ".panel"),
                                ("left" !== t && "right" !== t) ||
                                    (t = ".panel-" + t);
                            var r = e.panel.get(t);
                            return r && r.toggle
                                ? r.toggle(a)
                                : r
                                ? void 0
                                : (r = e.panel.create({ el: t })).toggle(a);
                        },
                    },
                });
            },
            on: {
                init: function () {
                    var e = this;
                    Ee(".panel-init").each(function (t) {
                        var a = Object.assign({ el: t }, Ee(t).dataset() || {});
                        e.panel.create(a);
                    });
                },
                pageInit: function (e) {
                    var t = this;
                    e.$el.find(".panel-init").each(function (e) {
                        var a = Object.assign({ el: e }, Ee(e).dataset() || {});
                        t.panel.create(a);
                    });
                },
                pageBeforeRemove: function (e) {
                    var t = this;
                    e.$el.find(".panel-init").each(function (e) {
                        var a = t.panel.get(e);
                        a && a.destroy && a.destroy();
                    });
                },
            },
            vnode: {
                "panel-init": {
                    insert: function (e) {
                        var t = e.elm,
                            a = Object.assign({ el: t }, Ee(t).dataset() || {});
                        this.panel.create(a);
                    },
                    destroy: function (e) {
                        var t = e.elm,
                            a = this.panel.get(t);
                        a && a.destroy && a.destroy();
                    },
                },
            },
            clicks: {
                ".panel-open": function (e, t) {
                    void 0 === t && (t = {});
                    this.panel.open(t.panel, t.animate);
                },
                ".panel-close": function (e, t) {
                    void 0 === t && (t = {});
                    this.panel.close(t.panel, t.animate);
                },
                ".panel-toggle": function (e, t) {
                    void 0 === t && (t = {});
                    this.panel.toggle(t.panel, t.animate);
                },
                ".panel-backdrop": function () {
                    var e = this,
                        t = Ee(".panel-in:not(.panel-out)");
                    if (t.length) {
                        var a = t[0] && t[0].f7Panel;
                        t.trigger("panel:backdrop-click"),
                            a && a.emit("backdropClick", a),
                            e.emit("panelBackdropClick", a || t[0]),
                            e.params.panel.closeByBackdropClick &&
                                e.panel.close();
                    }
                },
            },
        },
        qr = {
            open: function (e, t) {
                void 0 === e && (e = ".card-expandable"),
                    void 0 === t && (t = !0);
                var a = this,
                    n = pt(),
                    o = r(),
                    i = ct(),
                    s = Ee(e).eq(0);
                if (
                    s &&
                    s.length &&
                    !(
                        s.hasClass("card-opened") ||
                        s.hasClass("card-opening") ||
                        s.hasClass("card-closing")
                    )
                ) {
                    var l,
                        c = s.parents(".page").eq(0);
                    if (c.length)
                        if (!c.find(".card-opened").length)
                            if (
                                (s.trigger("card:beforeopen", { prevent: Q }),
                                a.emit("cardBeforeOpen", s[0], Q),
                                !l)
                            ) {
                                var p,
                                    d,
                                    u,
                                    h = Object.assign(
                                        { animate: t },
                                        a.params.card,
                                        s.dataset()
                                    ),
                                    f = s.parents(".page-content");
                                s.attr("data-backdrop-el") &&
                                    (p = Ee(s.attr("data-backdrop-el"))),
                                    !p &&
                                        h.backdrop &&
                                        ((p = f.find(".card-backdrop"))
                                            .length ||
                                            ((p = Ee(
                                                '<div class="card-backdrop"></div>'
                                            )),
                                            f.append(p))),
                                    h.hideNavbarOnOpen &&
                                        ((d = c.children(".navbar")).length ||
                                            (c[0].f7Page &&
                                                (d = c[0].f7Page.$navbarEl))),
                                    h.hideToolbarOnOpen &&
                                        ((u = c.children(".toolbar")).length ||
                                            (u = c
                                                .parents(".view")
                                                .children(".toolbar")),
                                        u.length ||
                                            (u = c
                                                .parents(".views")
                                                .children(".toolbar")));
                                var v,
                                    m = s.css("transform");
                                m && m.match(/[2-9]/) && (v = !0);
                                var g = s.children(".card-content"),
                                    b = Ee(o.createElement("div")).addClass(
                                        "card-expandable-size"
                                    );
                                s.append(b);
                                var y,
                                    w = s[0].offsetWidth,
                                    C = s[0].offsetHeight,
                                    E = c[0].offsetWidth,
                                    k = c[0].offsetHeight,
                                    x = b[0].offsetWidth || E,
                                    $ = b[0].offsetHeight || k;
                                d &&
                                    !h.hideStatusbarOnOpen &&
                                    $ === k &&
                                    ((y = parseInt(
                                        d.css("--f7-safe-area-top"),
                                        10
                                    )),
                                    Number.isNaN(y) && (y = 0)),
                                    y && ($ -= y);
                                var T,
                                    S,
                                    M = x / w,
                                    P = $ / C,
                                    O = s.offset(),
                                    I = c.offset();
                                if (
                                    (y && (I.top += y / 2),
                                    (O.left -= I.left),
                                    v)
                                ) {
                                    var B = m
                                        .replace(/matrix\(|\)/g, "")
                                        .split(",")
                                        .map(function (e) {
                                            return e.trim();
                                        });
                                    if (B && B.length > 1) {
                                        var L = parseFloat(B[0]);
                                        (T = O.left - (w * (1 - L)) / 2),
                                            (S =
                                                O.top -
                                                I.top -
                                                (C * (1 - L)) / 2),
                                            a.rtl && (T -= s[0].scrollLeft);
                                    } else
                                        (T = s[0].offsetLeft),
                                            (S =
                                                s[0].offsetTop -
                                                (f.length
                                                    ? f[0].scrollTop
                                                    : 0));
                                } else
                                    (T = O.left),
                                        (S = O.top - I.top),
                                        a.rtl && (T -= s[0].scrollLeft);
                                S -= (k - $) / 2;
                                var z = x - w - (T -= (E - x) / 2);
                                if (a.rtl) {
                                    var R = [z, T];
                                    (T = R[0]), (z = R[1]);
                                }
                                var A,
                                    D,
                                    H,
                                    N,
                                    V,
                                    F,
                                    q,
                                    j,
                                    _,
                                    Y,
                                    W,
                                    X,
                                    G = $ - C - S,
                                    U = (z - T) / 2,
                                    K = (G - S) / 2;
                                h.hideNavbarOnOpen &&
                                    d &&
                                    d.length &&
                                    (d.closest(".navbar-hidden").length
                                        ? (s[0].f7KeepNavbarOnClose = !0)
                                        : (delete s[0].f7KeepNavbarOnClose,
                                          a.navbar.hide(
                                              d,
                                              h.animate,
                                              h.hideStatusbarOnOpen,
                                              !0
                                          ))),
                                    h.hideToolbarOnOpen &&
                                        u &&
                                        u.length &&
                                        (u.closest(".toolbar-hidden").length
                                            ? (s[0].f7KeepToolbarOnClose = !0)
                                            : (delete s[0].f7KeepToolbarOnClose,
                                              a.toolbar.hide(u, h.animate))),
                                    p &&
                                        p
                                            .removeClass("card-backdrop-out")
                                            .addClass("card-backdrop-in"),
                                    s.removeClass("card-transitioning"),
                                    h.animate && s.addClass("card-opening"),
                                    s.trigger("card:open"),
                                    a.emit("cardOpen", s[0]),
                                    g
                                        .css({
                                            width: x + "px",
                                            height: $ + "px",
                                        })
                                        .transform(
                                            "translate3d(" +
                                                (a.rtl ? T + U : -T - U) +
                                                "px, 0px, 0) scale(" +
                                                1 / M +
                                                ", " +
                                                1 / P +
                                                ")"
                                        ),
                                    s.transform(
                                        "translate3d(" +
                                            (a.rtl ? -U : U) +
                                            "px, " +
                                            K +
                                            "px, 0) scale(" +
                                            M +
                                            ", " +
                                            P +
                                            ")"
                                    ),
                                    h.animate
                                        ? s.transitionEnd(function () {
                                              J();
                                          })
                                        : J(),
                                    (s[0].detachEventHandlers = function () {
                                        a.off("resize", Z),
                                            i.touch &&
                                                h.swipeToClose &&
                                                (a.off(
                                                    "touchstart:passive",
                                                    ee
                                                ),
                                                a.off("touchmove:active", te),
                                                a.off("touchend:passive", ae));
                                    }),
                                    a.on("resize", Z),
                                    i.touch &&
                                        h.swipeToClose &&
                                        (a.on("touchstart:passive", ee),
                                        a.on("touchmove:active", te),
                                        a.on("touchend:passive", ae));
                            }
                }
                function Q() {
                    l = !0;
                }
                function J() {
                    c.addClass("page-with-card-opened"),
                        n.ios &&
                            f.length &&
                            (f.css("height", f[0].offsetHeight + 1 + "px"),
                            setTimeout(function () {
                                f.css("height", "");
                            })),
                        s.addClass("card-opened"),
                        s.removeClass("card-opening"),
                        s.trigger("card:opened"),
                        a.emit("cardOpened", s[0], c[0]);
                }
                function Z() {
                    if (
                        (s.removeClass("card-transitioning"),
                        (w = s[0].offsetWidth),
                        (C = s[0].offsetHeight),
                        (E = c[0].offsetWidth),
                        (k = c[0].offsetHeight),
                        (x = b[0].offsetWidth || E),
                        ($ = b[0].offsetHeight || k),
                        (y = 0),
                        d &&
                            !h.hideStatusbarOnOpen &&
                            $ === k &&
                            ((y = parseInt(d.css("--f7-safe-area-top"), 10)),
                            Number.isNaN(y) && (y = 0)),
                        y && ($ -= y),
                        (M = x / w),
                        (P = $ / C),
                        s.transform("translate3d(0px, 0px, 0) scale(1)"),
                        (O = s.offset()),
                        (I = c.offset()),
                        y && (I.top += y / 2),
                        (O.left -= I.left),
                        (O.top -= I.top),
                        (T = O.left - (E - x) / 2),
                        a.rtl && (T -= s[0].scrollLeft),
                        (S = O.top - (k - $) / 2),
                        (z = x - w - T),
                        (G = $ - C - S),
                        a.rtl)
                    ) {
                        var e = [z, T];
                        (T = e[0]), (z = e[1]);
                    }
                    (U = (z - T) / 2),
                        (K = (G - S) / 2),
                        s.transform(
                            "translate3d(" +
                                (a.rtl ? -U : U) +
                                "px, " +
                                K +
                                "px, 0) scale(" +
                                M +
                                ", " +
                                P +
                                ")"
                        ),
                        g
                            .css({ width: x + "px", height: $ + "px" })
                            .transform(
                                "translate3d(" +
                                    (a.rtl ? T + U : -T - U) +
                                    "px, 0px, 0) scale(" +
                                    1 / M +
                                    ", " +
                                    1 / P +
                                    ")"
                            );
                }
                function ee(e) {
                    Ee(e.target).closest(s).length &&
                        s.hasClass("card-opened") &&
                        ((X = s.find(h.scrollableEl)),
                        (A =
                            X[0] && X[0] !== g[0] && !X[0].contains(e.target)
                                ? 0
                                : X.scrollTop()),
                        (D = !0),
                        (N = e.targetTouches[0].pageX),
                        (V = e.targetTouches[0].pageY),
                        (j = void 0),
                        (Y = !1),
                        (W = !1));
                }
                function te(e) {
                    if (D) {
                        if (
                            ((F = e.targetTouches[0].pageX),
                            (q = e.targetTouches[0].pageY),
                            void 0 === j &&
                                (j = !!(
                                    j || Math.abs(q - V) > Math.abs(F - N)
                                )),
                            W ||
                                Y ||
                                (!j && e.targetTouches[0].clientX <= 50
                                    ? (W = !0)
                                    : (Y = !0)),
                            (!W && !Y) || (Y && 0 !== A))
                        )
                            return (D = !0), void (H = !0);
                        H || s.removeClass("card-transitioning"),
                            (H = !0),
                            (((_ = Y
                                ? Math.max((q - V) / 150, 0)
                                : Math.max((F - N) / (w / 2), 0)) > 0 &&
                                Y) ||
                                W) &&
                                (Y &&
                                    n.ios &&
                                    X[0] === g[0] &&
                                    (X.css(
                                        "-webkit-overflow-scrolling",
                                        "auto"
                                    ),
                                    X.scrollTop(0)),
                                e.preventDefault()),
                            _ > 1 && (_ = Math.pow(_, 0.3)),
                            _ > (Y ? 1.3 : 1.1)
                                ? ((D = !1), (H = !1), a.card.close(s))
                                : s.transform(
                                      "translate3d(" +
                                          (a.rtl ? -U : U) +
                                          "px, " +
                                          K +
                                          "px, 0) scale(" +
                                          M * (1 - 0.2 * _) +
                                          ", " +
                                          P * (1 - 0.2 * _) +
                                          ")"
                                  );
                    }
                }
                function ae() {
                    D &&
                        H &&
                        ((D = !1),
                        (H = !1),
                        n.ios && X.css("-webkit-overflow-scrolling", ""),
                        _ >= 0.8
                            ? a.card.close(s)
                            : s
                                  .addClass("card-transitioning")
                                  .transform(
                                      "translate3d(" +
                                          (a.rtl ? -U : U) +
                                          "px, " +
                                          K +
                                          "px, 0) scale(" +
                                          M +
                                          ", " +
                                          P +
                                          ")"
                                  ));
                }
            },
            close: function (e, t) {
                void 0 === e && (e = ".card-expandable.card-opened"),
                    void 0 === t && (t = !0);
                var a = this,
                    r = pt(),
                    n = Ee(e).eq(0);
                if (
                    n &&
                    n.length &&
                    n.hasClass("card-opened") &&
                    !n.hasClass("card-opening") &&
                    !n.hasClass("card-closing")
                ) {
                    var o = n.children(".card-content"),
                        i = n.parents(".page-content"),
                        s = n.parents(".page").eq(0);
                    if (s.length) {
                        var l,
                            c,
                            p,
                            d = Object.assign(
                                { animate: t },
                                a.params.card,
                                n.dataset()
                            ),
                            u = n.find(d.scrollableEl);
                        n.attr("data-backdrop-el") &&
                            (p = Ee(n.attr("data-backdrop-el"))),
                            d.backdrop &&
                                (p = n
                                    .parents(".page-content")
                                    .find(".card-backdrop")),
                            d.hideNavbarOnOpen &&
                                ((l = s.children(".navbar")).length ||
                                    (s[0].f7Page &&
                                        (l = s[0].f7Page.$navbarEl)),
                                l &&
                                    l.length &&
                                    !n[0].f7KeepNavbarOnClose &&
                                    a.navbar.show(l, d.animate, !0)),
                            d.hideToolbarOnOpen &&
                                ((c = s.children(".toolbar")).length ||
                                    (c = s
                                        .parents(".view")
                                        .children(".toolbar")),
                                c.length ||
                                    (c = s
                                        .parents(".views")
                                        .children(".toolbar")),
                                c &&
                                    c.length &&
                                    !n[0].f7KeepToolbarOnClose &&
                                    a.toolbar.show(c, d.animate)),
                            s.removeClass("page-with-card-opened"),
                            r.ios &&
                                i.length &&
                                (i.css("height", i[0].offsetHeight + 1 + "px"),
                                setTimeout(function () {
                                    i.css("height", "");
                                })),
                            p &&
                                p.length &&
                                p
                                    .removeClass("card-backdrop-in")
                                    .addClass("card-backdrop-out"),
                            n.removeClass("card-opened card-transitioning"),
                            d.animate
                                ? n.addClass("card-closing")
                                : n.addClass("card-no-transition"),
                            n.transform(""),
                            n.trigger("card:close"),
                            a.emit("cardClose", n[0], s[0]);
                        var h = n.hasClass("card-expandable-animate-width");
                        h && o.css({ width: "", height: "" }),
                            o.transform("").scrollTop(0, t ? 300 : 0),
                            u.length &&
                                u[0] !== o[0] &&
                                u.scrollTop(0, t ? 300 : 0),
                            t
                                ? o.transitionEnd(function () {
                                      f();
                                  })
                                : f(),
                            n[0].detachEventHandlers &&
                                (n[0].detachEventHandlers(),
                                delete n[0].detachEventHandlers);
                    }
                }
                function f() {
                    h || o.css({ width: "", height: "" }),
                        p &&
                            p.length &&
                            p.removeClass("card-backdrop-in card-backdrop-out"),
                        n.removeClass("card-closing card-no-transition"),
                        n.trigger("card:closed"),
                        n.find(".card-expandable-size").remove(),
                        a.emit("cardClosed", n[0], s[0]);
                }
            },
            toggle: function (e, t) {
                void 0 === e && (e = ".card-expandable");
                var a = Ee(e).eq(0);
                a.length &&
                    (a.hasClass("card-opened")
                        ? this.card.close(a, t)
                        : this.card.open(a, t));
            },
        },
        jr = {
            name: "card",
            params: {
                card: {
                    hideNavbarOnOpen: !0,
                    hideStatusbarOnOpen: !0,
                    hideToolbarOnOpen: !0,
                    scrollableEl: ".card-content",
                    swipeToClose: !0,
                    closeByBackdropClick: !0,
                    backdrop: !0,
                },
            },
            create: function () {
                nt(this, { card: qr });
            },
            on: {
                pageBeforeIn: function (e) {
                    var t = this;
                    if (
                        (t.params.card.hideNavbarOnOpen &&
                            e.navbarEl &&
                            e.$el.find(".card-opened.card-expandable").length &&
                            t.navbar.hide(
                                e.navbarEl,
                                !0,
                                t.params.card.hideStatusbarOnOpen,
                                !0
                            ),
                        t.params.card.hideToolbarOnOpen &&
                            e.$el.find(".card-opened.card-expandable").length)
                    ) {
                        var a = e.$el.children(".toolbar");
                        a.length ||
                            (a = e.$el.parents(".view").children(".toolbar")),
                            a.length ||
                                (a = e.$el
                                    .parents(".views")
                                    .children(".toolbar")),
                            a && a.length && t.toolbar.hide(a);
                    }
                },
            },
            clicks: {
                ".card-close": function (e, t) {
                    this.card.close(t.card, t.animate);
                },
                ".card-open": function (e, t) {
                    this.card.open(t.card, t.animate);
                },
                ".card-expandable": function (e, t, a) {
                    e.hasClass("card-opened") ||
                        e.hasClass("card-opening") ||
                        e.hasClass("card-closing") ||
                        Ee(a.target).closest(".card-prevent-open, .card-close")
                            .length ||
                        this.card.open(e);
                },
                ".card-backdrop-in": function () {
                    var e = !1;
                    this.params.card.closeByBackdropClick && (e = !0);
                    var t = Ee(".card-opened");
                    t.length &&
                        ("true" === t.attr("data-close-by-backdrop-click")
                            ? (e = !0)
                            : "false" ===
                                  t.attr("data-close-by-backdrop-click") &&
                              (e = !1),
                        e && this.card.close(t));
                },
            },
        },
        _r = {
            store: function (e, t) {
                var a = o(),
                    r = e,
                    n = Ee(e);
                n.length && n.is("form") && n.attr("id") && (r = n.attr("id")),
                    (this.form.data["form-" + r] = t),
                    (a.localStorage["f7form-" + r] = JSON.stringify(t));
            },
            get: function (e) {
                var t = o(),
                    a = e,
                    r = Ee(e);
                return (
                    r.length &&
                        r.is("form") &&
                        r.attr("id") &&
                        (a = r.attr("id")),
                    t.localStorage["f7form-" + a]
                        ? JSON.parse(t.localStorage["f7form-" + a])
                        : this.form.data["form-" + a]
                        ? this.form.data["form-" + a]
                        : void 0
                );
            },
            remove: function (e) {
                var t = this,
                    a = o(),
                    r = e,
                    n = Ee(e);
                n.length && n.is("form") && n.attr("id") && (r = n.attr("id")),
                    t.form.data["form-" + r] &&
                        ((t.form.data["form-" + r] = ""),
                        delete t.form.data["form-" + r]),
                    a.localStorage["f7form-" + r] &&
                        ((a.localStorage["f7form-" + r] = ""),
                        a.localStorage.removeItem("f7form-" + r));
            },
        },
        Yr = {
            init: function (e) {
                var t = this,
                    a = Ee(e),
                    r = a.attr("id");
                if (r) {
                    var n = t.form.getFormData(r);
                    n && t.form.fillFromData(a, n),
                        a.on("change submit", function () {
                            var e = t.form.convertToData(a);
                            e &&
                                (t.form.storeFormData(r, e),
                                a.trigger("form:storedata", e),
                                t.emit("formStoreData", a[0], e));
                        });
                }
            },
            destroy: function (e) {
                Ee(e).off("change submit");
            },
        };
    function Wr(e) {
        var t = Ee(e).eq(0);
        if (0 !== t.length) {
            var a = {},
                r = ["submit", "image", "button", "file"],
                n = [];
            return (
                t.find("input, select, textarea").each(function (e) {
                    var o = Ee(e);
                    if (
                        !o.hasClass("ignore-store-data") &&
                        !o.hasClass("no-store-data")
                    ) {
                        var i = o.attr("name"),
                            s = o.attr("type"),
                            l = e.nodeName.toLowerCase();
                        if (!(r.indexOf(s) >= 0) && !(n.indexOf(i) >= 0) && i)
                            if ("select" === l && o.prop("multiple"))
                                n.push(i),
                                    (a[i] = []),
                                    t
                                        .find('select[name="' + i + '"] option')
                                        .each(function (e) {
                                            e.selected && a[i].push(e.value);
                                        });
                            else
                                switch (s) {
                                    case "checkbox":
                                        n.push(i),
                                            (a[i] = []),
                                            t
                                                .find('input[name="' + i + '"]')
                                                .each(function (e) {
                                                    e.checked &&
                                                        a[i].push(e.value);
                                                });
                                        break;
                                    case "radio":
                                        n.push(i),
                                            t
                                                .find('input[name="' + i + '"]')
                                                .each(function (e) {
                                                    e.checked &&
                                                        (a[i] = e.value);
                                                });
                                        break;
                                    default:
                                        a[i] = o.val();
                                }
                    }
                }),
                t.trigger("form:todata", a),
                this.emit("formToData", t[0], a),
                a
            );
        }
    }
    function Xr(e, t) {
        var a = Ee(e).eq(0);
        if (a.length) {
            var r = t,
                n = a.attr("id");
            if ((!r && n && (r = this.form.getFormData(n)), r)) {
                var o = ["submit", "image", "button", "file"],
                    i = [];
                a.find("input, select, textarea").each(function (e) {
                    var t = Ee(e);
                    if (
                        !t.hasClass("ignore-store-data") &&
                        !t.hasClass("no-store-data")
                    ) {
                        var n = t.attr("name"),
                            s = t.attr("type"),
                            l = e.nodeName.toLowerCase();
                        if (
                            void 0 !== r[n] &&
                            null !== r[n] &&
                            !(o.indexOf(s) >= 0) &&
                            !(i.indexOf(n) >= 0) &&
                            n
                        ) {
                            if ("select" === l && t.prop("multiple"))
                                i.push(n),
                                    a
                                        .find('select[name="' + n + '"] option')
                                        .each(function (e) {
                                            var t = e;
                                            r[n].indexOf(e.value) >= 0
                                                ? (t.selected = !0)
                                                : (t.selected = !1);
                                        });
                            else
                                switch (s) {
                                    case "checkbox":
                                        i.push(n),
                                            a
                                                .find('input[name="' + n + '"]')
                                                .each(function (e) {
                                                    var t = e;
                                                    r[n].indexOf(e.value) >= 0
                                                        ? (t.checked = !0)
                                                        : (t.checked = !1);
                                                });
                                        break;
                                    case "radio":
                                        i.push(n),
                                            a
                                                .find('input[name="' + n + '"]')
                                                .each(function (e) {
                                                    var t = e;
                                                    r[n] === e.value
                                                        ? (t.checked = !0)
                                                        : (t.checked = !1);
                                                });
                                        break;
                                    default:
                                        t.val(r[n]);
                                }
                            ("select" !== l &&
                                "input" !== l &&
                                "textarea" !== l) ||
                                t.trigger("change", "fromdata");
                        }
                    }
                }),
                    a.trigger("form:fromdata", r),
                    this.emit("formFromData", a[0], r);
            }
        }
    }
    function Gr() {
        var e = this,
            t = o(),
            a = r();
        Ee(a).on(
            "submit change",
            "form.form-ajax-submit, form.form-ajax-submit-onchange",
            function (a, r) {
                var n = Ee(this);
                if (
                    ("change" !== a.type ||
                        n.hasClass("form-ajax-submit-onchange")) &&
                    ("submit" === a.type && a.preventDefault(),
                    "change" !== a.type || "fromdata" !== r)
                ) {
                    var o,
                        i = (n.attr("method") || "GET").toUpperCase(),
                        s = n.prop("enctype") || n.attr("enctype"),
                        l = n.attr("action");
                    if (l)
                        (o =
                            "POST" === i
                                ? "application/x-www-form-urlencoded" === s
                                    ? e.form.convertToData(n[0])
                                    : new t.FormData(n[0])
                                : Ge(e.form.convertToData(n[0]))),
                            e.request({
                                method: i,
                                url: l,
                                contentType: s,
                                data: o,
                                beforeSend: function (t) {
                                    n.trigger("formajax:beforesend", {
                                        data: o,
                                        xhr: t,
                                    }),
                                        e.emit(
                                            "formAjaxBeforeSend",
                                            n[0],
                                            o,
                                            t
                                        );
                                },
                                error: function (t) {
                                    n.trigger("formajax:error", {
                                        data: o,
                                        xhr: t,
                                    }),
                                        e.emit("formAjaxError", n[0], o, t);
                                },
                                complete: function (t) {
                                    n.trigger("formajax:complete", {
                                        data: o,
                                        xhr: t,
                                    }),
                                        e.emit("formAjaxComplete", n[0], o, t);
                                },
                                success: function (t, a, r) {
                                    n.trigger("formajax:success", {
                                        data: o,
                                        xhr: r,
                                    }),
                                        e.emit("formAjaxSuccess", n[0], o, r);
                                },
                            });
                }
            }
        );
    }
    var Ur = {
            name: "form",
            create: function () {
                var e = this;
                Qe(e, {
                    form: {
                        data: {},
                        storeFormData: _r.store.bind(e),
                        getFormData: _r.get.bind(e),
                        removeFormData: _r.remove.bind(e),
                        convertToData: Wr.bind(e),
                        fillFromData: Xr.bind(e),
                        storage: {
                            init: Yr.init.bind(e),
                            destroy: Yr.destroy.bind(e),
                        },
                    },
                });
            },
            on: {
                init: function () {
                    Gr.call(this);
                },
                tabBeforeRemove: function (e) {
                    var t = this;
                    Ee(e)
                        .find(".form-store-data")
                        .each(function (e) {
                            t.form.storage.destroy(e);
                        });
                },
                tabMounted: function (e) {
                    var t = this;
                    Ee(e)
                        .find(".form-store-data")
                        .each(function (e) {
                            t.form.storage.init(e);
                        });
                },
                pageBeforeRemove: function (e) {
                    var t = this;
                    e.$el.find(".form-store-data").each(function (e) {
                        t.form.storage.destroy(e);
                    });
                },
                pageInit: function (e) {
                    var t = this;
                    e.$el.find(".form-store-data").each(function (e) {
                        t.form.storage.init(e);
                    });
                },
            },
        },
        Kr = {
            ignoreTypes: [
                "checkbox",
                "button",
                "submit",
                "range",
                "radio",
                "image",
            ],
            createTextareaResizableShadow: function () {
                var e = r(),
                    t = Ee(e.createElement("textarea"));
                t.addClass("textarea-resizable-shadow"),
                    t.prop({ disabled: !0, readonly: !0 }),
                    (Kr.textareaResizableShadow = t);
            },
            textareaResizableShadow: void 0,
            resizeTextarea: function (e) {
                var t = o(),
                    a = Ee(e);
                Kr.textareaResizableShadow ||
                    Kr.createTextareaResizableShadow();
                var r = Kr.textareaResizableShadow;
                if (a.length && a.hasClass("resizable")) {
                    0 === Kr.textareaResizableShadow.parents().length &&
                        this.$el.append(r);
                    var n = t.getComputedStyle(a[0]);
                    "padding-top padding-bottom padding-left padding-right margin-left margin-right margin-top margin-bottom width font-size font-family font-style font-weight line-height font-variant text-transform letter-spacing border box-sizing display"
                        .split(" ")
                        .forEach(function (e) {
                            var t = n[e];
                            "font-size line-height letter-spacing width"
                                .split(" ")
                                .indexOf(e) >= 0 && (t = t.replace(",", ".")),
                                r.css(e, t);
                        });
                    var i = a[0].clientHeight;
                    r.val("");
                    var s = r[0].scrollHeight;
                    r.val(a.val()), r.css("height", 0);
                    var l = r[0].scrollHeight;
                    i !== l &&
                        (l > s
                            ? a.css("height", l + "px")
                            : l < i && a.css("height", ""),
                        (l > s || l < i) &&
                            (a.trigger("textarea:resize", {
                                initialHeight: s,
                                currentHeight: i,
                                scrollHeight: l,
                            }),
                            this.emit("textareaResize", {
                                initialHeight: s,
                                currentHeight: i,
                                scrollHeight: l,
                            })));
                }
            },
            validate: function (e) {
                var t = Ee(e);
                if (!t.length) return !0;
                var a = t.parents(".item-input"),
                    r = t.parents(".input");
                function n() {
                    t[0].f7ValidateReadonly && (t[0].readOnly = !0);
                }
                t[0].f7ValidateReadonly && (t[0].readOnly = !1);
                var o = t[0].validity,
                    i =
                        t.dataset().errorMessage ||
                        t[0].validationMessage ||
                        "";
                if (!o) return n(), !0;
                if (!o.valid) {
                    var s = t.nextAll(
                        ".item-input-error-message, .input-error-message"
                    );
                    return (
                        i &&
                            (0 === s.length &&
                                (s = Ee(
                                    '<div class="' +
                                        (r.length
                                            ? "input-error-message"
                                            : "item-input-error-message") +
                                        '"></div>'
                                )).insertAfter(t),
                            s.text(i)),
                        s.length > 0 &&
                            (a.addClass("item-input-with-error-message"),
                            r.addClass("input-with-error-message")),
                        a.addClass("item-input-invalid"),
                        r.addClass("input-invalid"),
                        t.addClass("input-invalid"),
                        n(),
                        !1
                    );
                }
                return (
                    a.removeClass(
                        "item-input-invalid item-input-with-error-message"
                    ),
                    r.removeClass("input-invalid input-with-error-message"),
                    t.removeClass("input-invalid"),
                    n(),
                    !0
                );
            },
            validateInputs: function (e) {
                var t = this;
                return (
                    Ee(e)
                        .find("input, textarea, select")
                        .map(function (e) {
                            return t.input.validate(e);
                        })
                        .indexOf(!1) < 0
                );
            },
            focus: function (e) {
                var t = Ee(e),
                    a = t.attr("type");
                Kr.ignoreTypes.indexOf(a) >= 0 ||
                    (t.parents(".item-input").addClass("item-input-focused"),
                    t.parents(".input").addClass("input-focused"),
                    t.addClass("input-focused"));
            },
            blur: function (e) {
                var t = Ee(e);
                t.parents(".item-input").removeClass("item-input-focused"),
                    t.parents(".input").removeClass("input-focused"),
                    t.removeClass("input-focused");
            },
            checkEmptyState: function (e) {
                var t = Ee(e);
                if (
                    (t.is(
                        "input, select, textarea, .item-input [contenteditable]"
                    ) ||
                        (t = t
                            .find(
                                "input, select, textarea, .item-input [contenteditable]"
                            )
                            .eq(0)),
                    t.length)
                ) {
                    var a;
                    a = t[0].hasAttribute("contenteditable")
                        ? t.find(".text-editor-placeholder").length
                            ? ""
                            : t.html()
                        : t.val();
                    var r = t.parents(".item-input"),
                        n = t.parents(".input");
                    (a && "string" == typeof a && "" !== a.trim()) ||
                    (Array.isArray(a) && a.length > 0)
                        ? (r.addClass("item-input-with-value"),
                          n.addClass("input-with-value"),
                          t.addClass("input-with-value"),
                          t.trigger("input:notempty"),
                          this.emit("inputNotEmpty", t[0]))
                        : (r.removeClass("item-input-with-value"),
                          n.removeClass("input-with-value"),
                          t.removeClass("input-with-value"),
                          t.trigger("input:empty"),
                          this.emit("inputEmpty", t[0]));
                }
            },
            scrollIntoView: function (e, t, a, r) {
                void 0 === t && (t = 0);
                var n = Ee(e),
                    o = n
                        .parents(
                            ".page-content, .panel, .card-expandable .card-content"
                        )
                        .eq(0);
                if (!o.length) return !1;
                var i = o[0].offsetHeight,
                    s = o[0].scrollTop,
                    l = parseInt(o.css("padding-top"), 10),
                    c = parseInt(o.css("padding-bottom"), 10),
                    p = o.offset().top - s,
                    d = n.offset().top - p,
                    u = d + s - l,
                    h = d + s - i + c + n[0].offsetHeight,
                    f = u + (h - u) / 2;
                return s > u
                    ? (o.scrollTop(a ? f : u, t), !0)
                    : s < h
                    ? (o.scrollTop(a ? f : h, t), !0)
                    : (r && o.scrollTop(a ? f : h, t), !1);
            },
            init: function () {
                var e = this,
                    t = pt(),
                    a = o(),
                    n = r();
                Kr.createTextareaResizableShadow(),
                    Ee(n).on("click", ".input-clear-button", function () {
                        var t = Ee(this).siblings("input, textarea").eq(0),
                            a = t.val();
                        t
                            .val("")
                            .trigger("input change")
                            .focus()
                            .trigger("input:clear", a),
                            e.emit("inputClear", a);
                    }),
                    Ee(n).on("mousedown", ".input-clear-button", function (e) {
                        e.preventDefault();
                    }),
                    Ee(n).on(
                        "change input",
                        "input, textarea, select, .item-input [contenteditable]",
                        function () {
                            var t = Ee(this),
                                a = t.attr("type"),
                                r = t[0].nodeName.toLowerCase(),
                                n = t[0].hasAttribute("contenteditable");
                            Kr.ignoreTypes.indexOf(a) >= 0 ||
                                (e.input.checkEmptyState(t),
                                n ||
                                    (null !== t.attr("data-validate-on-blur") ||
                                        (!t.dataset().validate &&
                                            null === t.attr("validate")) ||
                                        e.input.validate(t),
                                    "textarea" === r &&
                                        t.hasClass("resizable") &&
                                        e.input.resizeTextarea(t)));
                        },
                        !0
                    ),
                    Ee(n).on(
                        "focus",
                        "input, textarea, select, .item-input [contenteditable]",
                        function () {
                            var r = this;
                            e.params.input.scrollIntoViewOnFocus &&
                                (t.android
                                    ? Ee(a).once("resize", function () {
                                          n &&
                                              n.activeElement === r &&
                                              e.input.scrollIntoView(
                                                  r,
                                                  e.params.input
                                                      .scrollIntoViewDuration,
                                                  e.params.input
                                                      .scrollIntoViewCentered,
                                                  e.params.input
                                                      .scrollIntoViewAlways
                                              );
                                      })
                                    : e.input.scrollIntoView(
                                          r,
                                          e.params.input.scrollIntoViewDuration,
                                          e.params.input.scrollIntoViewCentered,
                                          e.params.input.scrollIntoViewAlways
                                      )),
                                e.input.focus(r);
                        },
                        !0
                    ),
                    Ee(n).on(
                        "blur",
                        "input, textarea, select, .item-input [contenteditable]",
                        function () {
                            var t = Ee(this),
                                a = t[0].nodeName.toLowerCase();
                            e.input.blur(t),
                                (t.dataset().validate ||
                                    null !== t.attr("validate") ||
                                    null !== t.attr("data-validate-on-blur")) &&
                                    e.input.validate(t),
                                "textarea" === a &&
                                    t.hasClass("resizable") &&
                                    Kr.textareaResizableShadow &&
                                    Kr.textareaResizableShadow.remove();
                        },
                        !0
                    ),
                    Ee(n).on(
                        "invalid",
                        "input, textarea, select",
                        function (t) {
                            var a = Ee(this);
                            null !== a.attr("data-validate-on-blur") ||
                                (!a.dataset().validate &&
                                    null === a.attr("validate")) ||
                                (t.preventDefault(), e.input.validate(a));
                        },
                        !0
                    );
            },
        },
        Qr = {
            name: "input",
            params: {
                input: {
                    scrollIntoViewOnFocus: void 0,
                    scrollIntoViewCentered: !1,
                    scrollIntoViewDuration: 0,
                    scrollIntoViewAlways: !1,
                },
            },
            create: function () {
                var e = this;
                void 0 === e.params.input.scrollIntoViewOnFocus &&
                    (e.params.input.scrollIntoViewOnFocus = pt().android),
                    nt(e, { input: Kr });
            },
            on: {
                init: function () {
                    this.input.init();
                },
                tabMounted: function (e) {
                    var t = this,
                        a = Ee(e);
                    a.find(".item-input, .input").each(function (e) {
                        Ee(e)
                            .find("input, select, textarea, [contenteditable]")
                            .each(function (e) {
                                var a = Ee(e);
                                Kr.ignoreTypes.indexOf(a.attr("type")) >= 0 ||
                                    t.input.checkEmptyState(a);
                            });
                    }),
                        a.find("textarea.resizable").each(function (e) {
                            t.input.resizeTextarea(e);
                        });
                },
                pageInit: function (e) {
                    var t = this,
                        a = e.$el;
                    a.find(".item-input, .input").each(function (e) {
                        Ee(e)
                            .find("input, select, textarea, [contenteditable]")
                            .each(function (e) {
                                var a = Ee(e);
                                Kr.ignoreTypes.indexOf(a.attr("type")) >= 0 ||
                                    t.input.checkEmptyState(a);
                            });
                    }),
                        a.find("textarea.resizable").each(function (e) {
                            t.input.resizeTextarea(e);
                        });
                },
                "panelBreakpoint panelCollapsedBreakpoint panelResize panelOpen panelSwipeOpen resize viewMasterDetailBreakpoint":
                    function (e) {
                        var t = this;
                        e && e.$el
                            ? e.$el
                                  .find("textarea.resizable")
                                  .each(function (e) {
                                      t.input.resizeTextarea(e);
                                  })
                            : Ee("textarea.resizable").each(function (e) {
                                  t.input.resizeTextarea(e);
                              });
                    },
            },
        },
        Jr = (function (e) {
            function t(t, a) {
                var r;
                void 0 === a && (a = {});
                var n = ze((r = e.call(this, a, [t]) || this)),
                    o = ct(),
                    i = {};
                n.useModulesParams(i), (n.params = Qe(i, a));
                var s = n.params.el;
                if (!s) return n || ze(r);
                var l = Ee(s);
                if (0 === l.length) return n || ze(r);
                if (l[0].f7Toggle) return l[0].f7Toggle || ze(r);
                var c,
                    p = l.children('input[type="checkbox"]');
                Qe(n, {
                    app: t,
                    $el: l,
                    el: l[0],
                    $inputEl: p,
                    inputEl: p[0],
                    disabled:
                        l.hasClass("disabled") ||
                        p.hasClass("disabled") ||
                        p.attr("disabled") ||
                        p[0].disabled,
                }),
                    Object.defineProperty(n, "checked", {
                        enumerable: !0,
                        configurable: !0,
                        set: function (e) {
                            n &&
                                void 0 !== n.$inputEl &&
                                n.checked !== e &&
                                ((p[0].checked = e),
                                n.$inputEl.trigger("change"));
                        },
                        get: function () {
                            return p[0].checked;
                        },
                    }),
                    (l[0].f7Toggle = n);
                var d,
                    u,
                    h,
                    f,
                    v,
                    m = {};
                function g(e) {
                    c ||
                        n.disabled ||
                        ((m.x =
                            "touchstart" === e.type
                                ? e.targetTouches[0].pageX
                                : e.pageX),
                        (m.y =
                            "touchstart" === e.type
                                ? e.targetTouches[0].pageY
                                : e.pageY),
                        (u = 0),
                        (c = !0),
                        (d = void 0),
                        (f = Ye()),
                        (v = n.checked),
                        (h = l[0].offsetWidth),
                        je(function () {
                            c && l.addClass("toggle-active-state");
                        }));
                }
                function b(e) {
                    if (c && !n.disabled) {
                        var a,
                            r =
                                "touchmove" === e.type
                                    ? e.targetTouches[0].pageX
                                    : e.pageX,
                            o =
                                "touchmove" === e.type
                                    ? e.targetTouches[0].pageY
                                    : e.pageY,
                            i = t.rtl ? -1 : 1;
                        if (
                            (void 0 === d &&
                                (d = !!(
                                    d || Math.abs(o - m.y) > Math.abs(r - m.x)
                                )),
                            d)
                        )
                            c = !1;
                        else
                            e.preventDefault(),
                                (u = r - m.x) * i < 0 &&
                                    Math.abs(u) > h / 3 &&
                                    v &&
                                    (a = !0),
                                u * i > 0 &&
                                    Math.abs(u) > h / 3 &&
                                    !v &&
                                    (a = !0),
                                a && ((m.x = r), (n.checked = !v), (v = !v));
                    }
                }
                function y() {
                    if (!c || n.disabled)
                        return (
                            d && l.removeClass("toggle-active-state"),
                            void (c = !1)
                        );
                    var e,
                        a = t.rtl ? -1 : 1;
                    (c = !1),
                        l.removeClass("toggle-active-state"),
                        Ye() - f < 300 &&
                            (u * a < 0 && v && (e = !0),
                            u * a > 0 && !v && (e = !0),
                            e && (n.checked = !v));
                }
                function w() {
                    n.$el.trigger("toggle:change"),
                        n.emit("local::change toggleChange", n);
                }
                return (
                    (n.attachEvents = function () {
                        var e = !!o.passiveListener && { passive: !0 };
                        l.on(t.touchEvents.start, g, e),
                            t.on("touchmove", b),
                            t.on("touchend:passive", y),
                            n.$inputEl.on("change", w);
                    }),
                    (n.detachEvents = function () {
                        var e = !!o.passiveListener && { passive: !0 };
                        l.off(t.touchEvents.start, g, e),
                            t.off("touchmove", b),
                            t.off("touchend:passive", y),
                            n.$inputEl.off("change", w);
                    }),
                    n.useModules(),
                    n.init(),
                    r
                );
            }
            Me(t, e);
            var a = t.prototype;
            return (
                (a.toggle = function () {
                    this.checked = !this.checked;
                }),
                (a.init = function () {
                    this.attachEvents();
                }),
                (a.destroy = function () {
                    var e = this;
                    e.$el.trigger("toggle:beforedestroy"),
                        e.emit("local::beforeDestroy toggleBeforeDestroy", e),
                        delete e.$el[0].f7Toggle,
                        e.detachEvents(),
                        Fe(e),
                        (e = null);
                }),
                t
            );
        })(ut),
        Zr = {
            name: "toggle",
            create: function () {
                this.toggle = ht({
                    defaultSelector: ".toggle",
                    constructor: Jr,
                    app: this,
                    domProp: "f7Toggle",
                });
            },
            static: { Toggle: Jr },
            on: {
                tabMounted: function (e) {
                    var t = this;
                    Ee(e)
                        .find(".toggle-init")
                        .each(function (e) {
                            return t.toggle.create({ el: e });
                        });
                },
                tabBeforeRemove: function (e) {
                    Ee(e)
                        .find(".toggle-init")
                        .each(function (e) {
                            e.f7Toggle && e.f7Toggle.destroy();
                        });
                },
                pageInit: function (e) {
                    var t = this;
                    e.$el.find(".toggle-init").each(function (e) {
                        return t.toggle.create({ el: e });
                    });
                },
                pageBeforeRemove: function (e) {
                    e.$el.find(".toggle-init").each(function (e) {
                        e.f7Toggle && e.f7Toggle.destroy();
                    });
                },
            },
            vnode: {
                "toggle-init": {
                    insert: function (e) {
                        var t = e.elm;
                        this.toggle.create({ el: t });
                    },
                    destroy: function (e) {
                        var t = e.elm;
                        t.f7Toggle && t.f7Toggle.destroy();
                    },
                },
            },
        },
        en = (function (e) {
            function t(t, a) {
                var r,
                    n = ze((r = e.call(this, a, [t]) || this)),
                    o = ct(),
                    i = {
                        el: null,
                        inputEl: null,
                        dual: !1,
                        step: 1,
                        label: !1,
                        min: 0,
                        max: 100,
                        value: 0,
                        draggableBar: !0,
                        vertical: !1,
                        verticalReversed: !1,
                        formatLabel: null,
                        scale: !1,
                        scaleSteps: 5,
                        scaleSubSteps: 0,
                        formatScaleLabel: null,
                        limitKnobPosition: "ios" === t.theme,
                    };
                n.useModulesParams(i), (n.params = Qe(i, a));
                var s = n.params.el;
                if (!s) return n || ze(r);
                var l = Ee(s);
                if (0 === l.length) return n || ze(r);
                if (l[0].f7Range) return l[0].f7Range || ze(r);
                var c,
                    p = l.dataset();
                "step min max value scaleSteps scaleSubSteps"
                    .split(" ")
                    .forEach(function (e) {
                        void 0 === a[e] &&
                            void 0 !== p[e] &&
                            (n.params[e] = parseFloat(p[e]));
                    }),
                    "dual label vertical verticalReversed scale"
                        .split(" ")
                        .forEach(function (e) {
                            void 0 === a[e] &&
                                void 0 !== p[e] &&
                                (n.params[e] = p[e]);
                        }),
                    n.params.value ||
                        (void 0 !== p.value && (n.params.value = p.value),
                        void 0 !== p.valueLeft &&
                            void 0 !== p.valueRight &&
                            (n.params.value = [
                                parseFloat(p.valueLeft),
                                parseFloat(p.valueRight),
                            ])),
                    n.params.dual ||
                        (n.params.inputEl
                            ? (c = Ee(n.params.inputEl))
                            : l.find('input[type="range"]').length &&
                              (c = l.find('input[type="range"]').eq(0)));
                var d = n.params,
                    u = d.dual,
                    h = d.step,
                    f = d.label,
                    v = d.min,
                    m = d.max,
                    g = d.value,
                    b = d.vertical,
                    y = d.verticalReversed,
                    w = d.scale,
                    C = d.scaleSteps,
                    E = d.scaleSubSteps,
                    k = d.limitKnobPosition;
                Qe(n, {
                    app: t,
                    $el: l,
                    el: l[0],
                    $inputEl: c,
                    inputEl: c ? c[0] : void 0,
                    dual: u,
                    step: h,
                    label: f,
                    min: v,
                    max: m,
                    value: g,
                    previousValue: g,
                    vertical: b,
                    verticalReversed: y,
                    scale: w,
                    scaleSteps: C,
                    scaleSubSteps: E,
                    limitKnobPosition: k,
                }),
                    c &&
                        ("step min max".split(" ").forEach(function (e) {
                            !a[e] &&
                                c.attr(e) &&
                                ((n.params[e] = parseFloat(c.attr(e))),
                                (n[e] = parseFloat(c.attr(e))));
                        }),
                        void 0 !== c.val() &&
                            ((n.params.value = parseFloat(c.val())),
                            (n.value = parseFloat(c.val())))),
                    n.dual && l.addClass("range-slider-dual"),
                    n.label && l.addClass("range-slider-label"),
                    n.vertical
                        ? (l.addClass("range-slider-vertical"),
                          n.verticalReversed &&
                              l.addClass("range-slider-vertical-reversed"))
                        : l.addClass("range-slider-horizontal");
                var x = Ee('<div class="range-bar"></div>'),
                    $ = Ee('<div class="range-bar-active"></div>');
                x.append($);
                var T =
                        '\n      <div class="range-knob-wrap">\n        <div class="range-knob"></div>\n        ' +
                        (n.label
                            ? '<div class="range-knob-label"></div>'
                            : "") +
                        "\n      </div>\n    ",
                    S = [Ee(T)];
                n.dual && S.push(Ee(T)),
                    l.append(x),
                    S.forEach(function (e) {
                        l.append(e);
                    });
                var M,
                    P,
                    O = [];
                n.label &&
                    (O.push(S[0].find(".range-knob-label")),
                    n.dual && O.push(S[1].find(".range-knob-label"))),
                    n.scale &&
                        n.scaleSteps >= 1 &&
                        ((M = Ee(
                            '\n        <div class="range-scale">\n          ' +
                                n.renderScale() +
                                "\n        </div>\n      "
                        )),
                        l.append(M)),
                    Qe(n, {
                        knobs: S,
                        labels: O,
                        $barEl: x,
                        $barActiveEl: $,
                        $scaleEl: M,
                    }),
                    (l[0].f7Range = n);
                var I,
                    B,
                    L,
                    z,
                    R,
                    A,
                    D,
                    H,
                    N,
                    V,
                    F,
                    q = {};
                function j() {
                    D = !0;
                }
                function _(e) {
                    if (
                        !P &&
                        (n.params.draggableBar ||
                            0 !== Ee(e.target).closest(".range-knob").length)
                    ) {
                        var t;
                        (D = !1),
                            (q.x =
                                "touchstart" === e.type
                                    ? e.targetTouches[0].pageX
                                    : e.pageX),
                            (q.y =
                                "touchstart" === e.type
                                    ? e.targetTouches[0].pageY
                                    : e.pageY),
                            "touchstart" === e.type &&
                                (H = e.targetTouches[0].identifier),
                            (P = !0),
                            (I = void 0),
                            (B = l.offset()),
                            (L = B.left),
                            (z = B.top),
                            n.vertical
                                ? ((t = (q.y - z) / n.rangeHeight),
                                  n.verticalReversed || (t = 1 - t))
                                : (t = n.app.rtl
                                      ? (L + n.rangeWidth - q.x) / n.rangeWidth
                                      : (q.x - L) / n.rangeWidth);
                        var a = t * (n.max - n.min) + n.min;
                        n.dual
                            ? Math.abs(n.value[0] - a) <
                              Math.abs(n.value[1] - a)
                                ? ((A = 0),
                                  (R = n.knobs[0]),
                                  (a = [a, n.value[1]]))
                                : ((A = 1),
                                  (R = n.knobs[1]),
                                  (a = [n.value[0], a]))
                            : ((R = n.knobs[0]),
                              (a = t * (n.max - n.min) + n.min)),
                            je(function () {
                                P && R.addClass("range-knob-active-state");
                            }, 70),
                            n.on("change", j),
                            n.setValue(a, !0);
                    }
                }
                function Y(e) {
                    if (P) {
                        var t, a;
                        if ("touchmove" === e.type)
                            for (var r = 0; r < e.targetTouches.length; r += 1)
                                e.targetTouches[r].identifier === H &&
                                    ((t = e.targetTouches[r].pageX),
                                    (a = e.targetTouches[r].pageY));
                        else (t = e.pageX), (a = e.pageY);
                        if (void 0 !== t || void 0 !== a)
                            if (
                                (void 0 !== I ||
                                    n.vertical ||
                                    (I = !!(
                                        I ||
                                        Math.abs(a - q.y) > Math.abs(t - q.x)
                                    )),
                                I)
                            )
                                P = !1;
                            else {
                                var o;
                                e.preventDefault(),
                                    n.vertical
                                        ? ((o = (a - z) / n.rangeHeight),
                                          n.verticalReversed || (o = 1 - o))
                                        : (o = n.app.rtl
                                              ? (L + n.rangeWidth - t) /
                                                n.rangeWidth
                                              : (t - L) / n.rangeWidth);
                                var i,
                                    s,
                                    l = o * (n.max - n.min) + n.min;
                                if (n.dual)
                                    0 === A
                                        ? (i = l) > (s = n.value[1]) && (s = i)
                                        : (s = l) < (i = n.value[0]) && (i = s),
                                        (l = [i, s]);
                                n.setValue(l, !0);
                            }
                    }
                }
                function W(e) {
                    if ("touchend" === e.type) {
                        for (var t, a = 0; a < e.changedTouches.length; a += 1)
                            e.changedTouches[a].identifier === H && (t = !0);
                        if (!t) return;
                    }
                    if (!P)
                        return (
                            I && R.removeClass("range-knob-active-state"),
                            void (P = !1)
                        );
                    n.off("change", j),
                        (P = !1),
                        R.removeClass("range-knob-active-state"),
                        D &&
                            n.$inputEl &&
                            !n.dual &&
                            n.$inputEl.trigger("change"),
                        (D = !1),
                        void 0 !== n.previousValue &&
                            ((n.dual &&
                                (n.previousValue[0] !== n.value[0] ||
                                    n.previousValue[1] !== n.value[1])) ||
                                (!n.dual && n.previousValue !== n.value)) &&
                            (n.$el.trigger("range:changed", n.value),
                            n.emit("local::changed rangeChanged", n, n.value));
                }
                function X() {
                    n.calcSize(), n.layout();
                }
                return (
                    (n.attachEvents = function () {
                        var e = !!o.passiveListener && { passive: !0 };
                        n.$el.on(t.touchEvents.start, _, e),
                            t.on("touchmove", Y),
                            t.on("touchend:passive", W),
                            t.on("tabShow", X),
                            t.on("resize", X),
                            (N = n.$el.parents(
                                ".sheet-modal, .actions-modal, .popup, .popover, .login-screen, .dialog, .toast"
                            )).on("modal:open", X),
                            (V = n.$el.parents(".panel")).on(
                                "panel:open panel:resize",
                                X
                            ),
                            (F = n.$el.parents(".page").eq(0)).on(
                                "page:reinit",
                                X
                            );
                    }),
                    (n.detachEvents = function () {
                        var e = !!o.passiveListener && { passive: !0 };
                        n.$el.off(t.touchEvents.start, _, e),
                            t.off("touchmove", Y),
                            t.off("touchend:passive", W),
                            t.off("tabShow", X),
                            t.off("resize", X),
                            N && N.off("modal:open", X),
                            V && V.off("panel:open panel:resize", X),
                            F && F.off("page:reinit", X),
                            (N = null),
                            (V = null),
                            (F = null);
                    }),
                    n.useModules(),
                    n.init(),
                    n || ze(r)
                );
            }
            Me(t, e);
            var a = t.prototype;
            return (
                (a.calcSize = function () {
                    var e = this;
                    if (e.vertical) {
                        var t = e.$el.outerHeight();
                        if (0 === t) return;
                        (e.rangeHeight = t),
                            (e.knobHeight = e.knobs[0].outerHeight());
                    } else {
                        var a = e.$el.outerWidth();
                        if (0 === a) return;
                        (e.rangeWidth = a),
                            (e.knobWidth = e.knobs[0].outerWidth());
                    }
                }),
                (a.layout = function () {
                    var e = this,
                        t = e.app,
                        a = e.knobWidth,
                        r = e.knobHeight,
                        n = e.rangeWidth,
                        o = e.rangeHeight,
                        i = e.min,
                        s = e.max,
                        l = e.knobs,
                        c = e.$barActiveEl,
                        p = e.value,
                        d = e.label,
                        u = e.labels,
                        h = e.vertical,
                        f = e.verticalReversed,
                        v = e.limitKnobPosition,
                        m = h ? r : a,
                        g = h ? o : n,
                        b = h
                            ? f
                                ? "top"
                                : "bottom"
                            : t.rtl
                            ? "right"
                            : "left";
                    if (e.dual) {
                        var y,
                            w = [(p[0] - i) / (s - i), (p[1] - i) / (s - i)];
                        c.css(
                            (((y = {})[b] = 100 * w[0] + "%"),
                            (y[h ? "height" : "width"] =
                                100 * (w[1] - w[0]) + "%"),
                            y)
                        ),
                            l.forEach(function (t, a) {
                                var r = g * w[a];
                                if (v) {
                                    var n = g * w[a] - m / 2;
                                    n < 0 && (r = m / 2),
                                        n + m > g && (r = g - m / 2);
                                }
                                t.css(b, r + "px"),
                                    d &&
                                        u[a].text(e.formatLabel(p[a], u[a][0]));
                            });
                    } else {
                        var C = (p - i) / (s - i);
                        c.css(h ? "height" : "width", 100 * C + "%");
                        var E = g * C;
                        if (v) {
                            var k = g * C - m / 2;
                            k < 0 && (E = m / 2), k + m > g && (E = g - m / 2);
                        }
                        l[0].css(b, E + "px"),
                            d && u[0].text(e.formatLabel(p, u[0][0]));
                    }
                    (e.dual && p.indexOf(i) >= 0) || (!e.dual && p === i)
                        ? e.$el.addClass("range-slider-min")
                        : e.$el.removeClass("range-slider-min"),
                        (e.dual && p.indexOf(s) >= 0) || (!e.dual && p === s)
                            ? e.$el.addClass("range-slider-max")
                            : e.$el.removeClass("range-slider-max");
                }),
                (a.setValue = function (e, t) {
                    var a,
                        r,
                        n = this,
                        o = n.step,
                        i = n.min,
                        s = n.max;
                    if (n.dual) {
                        r = [n.value[0], n.value[1]];
                        var l = e;
                        if (
                            (Array.isArray(l) || (l = [e, e]),
                            e[0] > e[1] && (l = [l[0], l[0]]),
                            (l = l.map(function (e) {
                                return Math.max(
                                    Math.min(Math.round(e / o) * o, s),
                                    i
                                );
                            }))[0] === n.value[0] && l[1] === n.value[1])
                        )
                            return n;
                        l.forEach(function (e, t) {
                            n.value[t] = e;
                        }),
                            (a = r[0] !== l[0] || r[1] !== l[1]),
                            n.layout();
                    } else {
                        r = n.value;
                        var c = Math.max(Math.min(Math.round(e / o) * o, s), i);
                        (n.value = c), n.layout(), (a = r !== c);
                    }
                    return (
                        a && (n.previousValue = r),
                        a
                            ? (n.$el.trigger("range:change", n.value),
                              n.$inputEl &&
                                  !n.dual &&
                                  (n.$inputEl.val(n.value),
                                  t
                                      ? n.$inputEl.trigger("input")
                                      : n.$inputEl.trigger("input change")),
                              t ||
                                  (n.$el.trigger("range:changed", n.value),
                                  n.emit(
                                      "local::changed rangeChanged",
                                      n,
                                      n.value
                                  )),
                              n.emit("local::change rangeChange", n, n.value),
                              n)
                            : n
                    );
                }),
                (a.getValue = function () {
                    return this.value;
                }),
                (a.formatLabel = function (e, t) {
                    var a = this;
                    return a.params.formatLabel
                        ? a.params.formatLabel.call(a, e, t)
                        : e;
                }),
                (a.formatScaleLabel = function (e) {
                    var t = this;
                    return t.params.formatScaleLabel
                        ? t.params.formatScaleLabel.call(t, e)
                        : e;
                }),
                (a.renderScale = function () {
                    var e = this,
                        t = e.app,
                        a = e.verticalReversed,
                        r = e.vertical
                            ? a
                                ? "top"
                                : "bottom"
                            : t.rtl
                            ? "right"
                            : "left",
                        n = "";
                    return (
                        Array.from({ length: e.scaleSteps + 1 }).forEach(
                            function (t, a) {
                                var o = (e.max - e.min) / e.scaleSteps,
                                    i = e.min + o * a,
                                    s = (i - e.min) / (e.max - e.min);
                                (n +=
                                    '<div class="range-scale-step" style="' +
                                    r +
                                    ": " +
                                    100 * s +
                                    '%">' +
                                    e.formatScaleLabel(i) +
                                    "</div>"),
                                    e.scaleSubSteps &&
                                        e.scaleSubSteps > 1 &&
                                        a < e.scaleSteps &&
                                        Array.from({
                                            length: e.scaleSubSteps - 1,
                                        }).forEach(function (t, a) {
                                            var s = o / e.scaleSubSteps,
                                                l =
                                                    (i + s * (a + 1) - e.min) /
                                                    (e.max - e.min);
                                            n +=
                                                '<div class="range-scale-step range-scale-substep" style="' +
                                                r +
                                                ": " +
                                                100 * l +
                                                '%"></div>';
                                        });
                            }
                        ),
                        n
                    );
                }),
                (a.updateScale = function () {
                    var e = this;
                    if (!e.scale || e.scaleSteps < 1)
                        return (
                            e.$scaleEl && e.$scaleEl.remove(),
                            void delete e.$scaleEl
                        );
                    e.$scaleEl ||
                        ((e.$scaleEl = Ee('<div class="range-scale"></div>')),
                        e.$el.append(e.$scaleEl)),
                        e.$scaleEl.html(e.renderScale());
                }),
                (a.init = function () {
                    var e = this;
                    return e.calcSize(), e.layout(), e.attachEvents(), e;
                }),
                (a.destroy = function () {
                    var e = this;
                    e.$el.trigger("range:beforedestroy"),
                        e.emit("local::beforeDestroy rangeBeforeDestroy", e),
                        delete e.$el[0].f7Range,
                        e.detachEvents(),
                        Fe(e),
                        (e = null);
                }),
                t
            );
        })(ut),
        tn = {
            name: "range",
            create: function () {
                var e = this;
                e.range = Qe(
                    ht({
                        defaultSelector: ".range-slider",
                        constructor: en,
                        app: e,
                        domProp: "f7Range",
                    }),
                    {
                        getValue: function (t) {
                            void 0 === t && (t = ".range-slider");
                            var a = e.range.get(t);
                            if (a) return a.getValue();
                        },
                        setValue: function (t, a) {
                            void 0 === t && (t = ".range-slider");
                            var r = e.range.get(t);
                            if (r) return r.setValue(a);
                        },
                    }
                );
            },
            static: { Range: en },
            on: {
                tabMounted: function (e) {
                    var t = this;
                    Ee(e)
                        .find(".range-slider-init")
                        .each(function (e) {
                            return new en(t, { el: e });
                        });
                },
                tabBeforeRemove: function (e) {
                    Ee(e)
                        .find(".range-slider-init")
                        .each(function (e) {
                            e.f7Range && e.f7Range.destroy();
                        });
                },
                pageInit: function (e) {
                    var t = this;
                    e.$el.find(".range-slider-init").each(function (e) {
                        return new en(t, { el: e });
                    });
                },
                pageBeforeRemove: function (e) {
                    e.$el.find(".range-slider-init").each(function (e) {
                        e.f7Range && e.f7Range.destroy();
                    });
                },
            },
            vnode: {
                "range-slider-init": {
                    insert: function (e) {
                        var t = e.elm;
                        this.range.create({ el: t });
                    },
                    destroy: function (e) {
                        var t = e.elm;
                        t.f7Range && t.f7Range.destroy();
                    },
                },
            },
        },
        an = (function (e) {
            function t(t, a) {
                var r,
                    n = ze((r = e.call(this, a, [t]) || this)),
                    o = {
                        el: null,
                        inputEl: null,
                        valueEl: null,
                        value: 0,
                        formatValue: null,
                        step: 1,
                        min: 0,
                        max: 100,
                        watchInput: !0,
                        autorepeat: !1,
                        autorepeatDynamic: !1,
                        wraps: !1,
                        manualInputMode: !1,
                        decimalPoint: 4,
                        buttonsEndInputMode: !0,
                    };
                n.useModulesParams(o),
                    (n.params = Qe(o, a)),
                    n.params.value < n.params.min &&
                        (n.params.value = n.params.min),
                    n.params.value > n.params.max &&
                        (n.params.value = n.params.max);
                var i = n.params.el;
                if (!i) return n || ze(r);
                var s,
                    l,
                    c = Ee(i);
                if (0 === c.length) return n || ze(r);
                if (c[0].f7Stepper) return c[0].f7Stepper || ze(r);
                if (
                    (n.params.inputEl
                        ? (s = Ee(n.params.inputEl))
                        : c.find(".stepper-input-wrap").find("input, textarea")
                              .length &&
                          (s = c
                              .find(".stepper-input-wrap")
                              .find("input, textarea")
                              .eq(0)),
                    s && s.length)
                ) {
                    "step min max".split(" ").forEach(function (e) {
                        !a[e] &&
                            s.attr(e) &&
                            (n.params[e] = parseFloat(s.attr(e)));
                    });
                    var p = parseInt(n.params.decimalPoint, 10);
                    Number.isNaN(p)
                        ? (n.params.decimalPoint = 0)
                        : (n.params.decimalPoint = p);
                    var d = parseFloat(s.val());
                    void 0 !== a.value ||
                        Number.isNaN(d) ||
                        (!d && 0 !== d) ||
                        (n.params.value = d);
                }
                n.params.valueEl
                    ? (l = Ee(n.params.valueEl))
                    : c.find(".stepper-value").length &&
                      (l = c.find(".stepper-value").eq(0));
                var u = c.find(".stepper-button-plus"),
                    h = c.find(".stepper-button-minus"),
                    f = n.params,
                    v = f.step,
                    m = f.min,
                    g = f.max,
                    b = f.value,
                    y = f.decimalPoint;
                Qe(n, {
                    app: t,
                    $el: c,
                    el: c[0],
                    $buttonPlusEl: u,
                    buttonPlusEl: u[0],
                    $buttonMinusEl: h,
                    buttonMinusEl: h[0],
                    $inputEl: s,
                    inputEl: s ? s[0] : void 0,
                    $valueEl: l,
                    valueEl: l ? l[0] : void 0,
                    step: v,
                    min: m,
                    max: g,
                    value: b,
                    decimalPoint: y,
                    typeModeChanged: !1,
                }),
                    (c[0].f7Stepper = n);
                var w,
                    C,
                    E,
                    k,
                    x,
                    $ = {},
                    T = null,
                    S = !1,
                    M = !1;
                function P(e, t, a, r, n, o) {
                    clearTimeout(x),
                        (x = setTimeout(
                            function () {
                                1 === e && ((E = !0), (S = !0)),
                                    clearInterval(k),
                                    o(),
                                    (k = setInterval(function () {
                                        o();
                                    }, n)),
                                    e < t && P(e + 1, t, a, r, n / 2, o);
                            },
                            1 === e ? a : r
                        ));
                }
                function O(e) {
                    w ||
                        M ||
                        (Ee(e.target).closest(u).length
                            ? (T = "increment")
                            : Ee(e.target).closest(h).length &&
                              (T = "decrement"),
                        T &&
                            (($.x =
                                "touchstart" === e.type
                                    ? e.targetTouches[0].pageX
                                    : e.pageX),
                            ($.y =
                                "touchstart" === e.type
                                    ? e.targetTouches[0].pageY
                                    : e.pageY),
                            (w = !0),
                            (C = void 0),
                            P(
                                1,
                                n.params.autorepeatDynamic ? 4 : 1,
                                500,
                                1e3,
                                300,
                                function () {
                                    n[T]();
                                }
                            )));
                }
                function I(e) {
                    if (w && !M) {
                        var t =
                                "touchmove" === e.type
                                    ? e.targetTouches[0].pageX
                                    : e.pageX,
                            a =
                                "touchmove" === e.type
                                    ? e.targetTouches[0].pageY
                                    : e.pageY;
                        void 0 !== C ||
                            S ||
                            (C = !!(
                                C || Math.abs(a - $.y) > Math.abs(t - $.x)
                            ));
                        var r = Math.pow(
                            Math.pow(t - $.x, 2) + Math.pow(a - $.y, 2),
                            0.5
                        );
                        (C || r > 20) &&
                            ((w = !1), clearTimeout(x), clearInterval(k));
                    }
                }
                function B() {
                    clearTimeout(x),
                        clearInterval(k),
                        (T = null),
                        (S = !1),
                        (w = !1);
                }
                function L() {
                    M
                        ? n.params.buttonsEndInputMode &&
                          ((M = !1), n.endTypeMode(!0))
                        : E
                        ? (E = !1)
                        : n.decrement(!0);
                }
                function z() {
                    M
                        ? n.params.buttonsEndInputMode &&
                          ((M = !1), n.endTypeMode(!0))
                        : E
                        ? (E = !1)
                        : n.increment(!0);
                }
                function R(e) {
                    !e.target.readOnly &&
                        n.params.manualInputMode &&
                        ((M = !0),
                        "number" == typeof e.target.selectionStart &&
                            ((e.target.selectionStart = e.target.value.length),
                            (e.target.selectionEnd = e.target.value.length)));
                }
                function A(e) {
                    (13 !== e.keyCode && 13 !== e.which) ||
                        (e.preventDefault(), (M = !1), n.endTypeMode());
                }
                function D() {
                    (M = !1), n.endTypeMode(!0);
                }
                function H(e) {
                    M
                        ? n.typeValue(e.target.value)
                        : (e.detail && e.detail.sentByF7Stepper) ||
                          n.setValue(e.target.value, !0);
                }
                return (
                    (n.attachEvents = function () {
                        h.on("click", L),
                            u.on("click", z),
                            n.params.watchInput &&
                                s &&
                                s.length &&
                                (s.on("input", H),
                                s.on("click", R),
                                s.on("blur", D),
                                s.on("keyup", A)),
                            n.params.autorepeat &&
                                (t.on("touchstart:passive", O),
                                t.on("touchmove:active", I),
                                t.on("touchend:passive", B));
                    }),
                    (n.detachEvents = function () {
                        h.off("click", L),
                            u.off("click", z),
                            n.params.watchInput &&
                                s &&
                                s.length &&
                                (s.off("input", H),
                                s.off("click", R),
                                s.off("blur", D),
                                s.off("keyup", A));
                    }),
                    n.useModules(),
                    n.init(),
                    n || ze(r)
                );
            }
            Me(t, e);
            var a = t.prototype;
            return (
                (a.minus = function () {
                    return this.decrement();
                }),
                (a.plus = function () {
                    return this.increment();
                }),
                (a.decrement = function () {
                    var e = this;
                    return e.setValue(e.value - e.step, !1, !0);
                }),
                (a.increment = function () {
                    var e = this;
                    return e.setValue(e.value + e.step, !1, !0);
                }),
                (a.setValue = function (e, t, a) {
                    var r = this,
                        n = r.step,
                        o = r.min,
                        i = r.max,
                        s = r.value,
                        l = Math.round(e / n) * n;
                    if (
                        (r.params.wraps && a
                            ? (l > i && (l = o), l < o && (l = i))
                            : (l = Math.max(Math.min(l, i), o)),
                        Number.isNaN(l) && (l = s),
                        (r.value = l),
                        !(s !== l) && !t)
                    )
                        return r;
                    r.$el.trigger("stepper:change", r.value);
                    var c = r.formatValue(r.value);
                    return (
                        r.$inputEl &&
                            r.$inputEl.length &&
                            (r.$inputEl.val(c),
                            r.$inputEl.trigger("input change", {
                                sentByF7Stepper: !0,
                            })),
                        r.$valueEl && r.$valueEl.length && r.$valueEl.html(c),
                        r.emit("local::change stepperChange", r, r.value),
                        r
                    );
                }),
                (a.endTypeMode = function (e) {
                    var t = this,
                        a = t.min,
                        r = t.max,
                        n = parseFloat(t.value);
                    if (
                        (Number.isNaN(n) && (n = 0),
                        (n = Math.max(Math.min(n, r), a)),
                        (t.value = n),
                        !t.typeModeChanged)
                    )
                        return (
                            t.$inputEl &&
                                t.$inputEl.length &&
                                !e &&
                                t.$inputEl.blur(),
                            t
                        );
                    (t.typeModeChanged = !1),
                        t.$el.trigger("stepper:change", t.value);
                    var o = t.formatValue(t.value);
                    return (
                        t.$inputEl &&
                            t.$inputEl.length &&
                            (t.$inputEl.val(o),
                            t.$inputEl.trigger("input change", {
                                sentByF7Stepper: !0,
                            }),
                            e || t.$inputEl.blur()),
                        t.$valueEl && t.$valueEl.length && t.$valueEl.html(o),
                        t.emit("local::change stepperChange", t, t.value),
                        t
                    );
                }),
                (a.typeValue = function (e) {
                    var t = this;
                    t.typeModeChanged = !0;
                    var a = String(e);
                    if (1 === a.length && "-" === a) return t;
                    if (
                        a.lastIndexOf(".") + 1 !== a.length &&
                        a.lastIndexOf(",") + 1 !== a.length
                    ) {
                        var r = parseFloat(a.replace(",", "."));
                        if (0 === r)
                            return (
                                (t.value = a.replace(",", ".")),
                                t.$inputEl.val(t.value),
                                t
                            );
                        if (Number.isNaN(r))
                            return (t.value = 0), t.$inputEl.val(t.value), t;
                        var n = Math.pow(10, t.params.decimalPoint);
                        return (
                            (r =
                                Math.round(r * n).toFixed(
                                    t.params.decimalPoint + 1
                                ) / n),
                            (t.value = parseFloat(String(r).replace(",", "."))),
                            t.$inputEl.val(t.value),
                            t
                        );
                    }
                    return a.lastIndexOf(".") !== a.indexOf(".") ||
                        a.lastIndexOf(",") !== a.indexOf(",")
                        ? ((a = a.slice(0, -1)),
                          (t.value = a),
                          t.$inputEl.val(t.value),
                          t)
                        : ((t.value = a), t.$inputEl.val(a), t);
                }),
                (a.getValue = function () {
                    return this.value;
                }),
                (a.formatValue = function (e) {
                    var t = this;
                    return t.params.formatValue
                        ? t.params.formatValue.call(t, e)
                        : e;
                }),
                (a.init = function () {
                    var e = this;
                    if ((e.attachEvents(), e.$valueEl && e.$valueEl.length)) {
                        var t = e.formatValue(e.value);
                        e.$valueEl.html(t);
                    }
                    return e;
                }),
                (a.destroy = function () {
                    var e = this;
                    e.$el.trigger("stepper:beforedestroy"),
                        e.emit("local::beforeDestroy stepperBeforeDestroy", e),
                        delete e.$el[0].f7Stepper,
                        e.detachEvents(),
                        Fe(e),
                        (e = null);
                }),
                t
            );
        })(ut),
        rn = {
            name: "stepper",
            create: function () {
                var e = this;
                e.stepper = Qe(
                    ht({
                        defaultSelector: ".stepper",
                        constructor: an,
                        app: e,
                        domProp: "f7Stepper",
                    }),
                    {
                        getValue: function (t) {
                            void 0 === t && (t = ".stepper");
                            var a = e.stepper.get(t);
                            if (a) return a.getValue();
                        },
                        setValue: function (t, a) {
                            void 0 === t && (t = ".stepper");
                            var r = e.stepper.get(t);
                            if (r) return r.setValue(a);
                        },
                    }
                );
            },
            static: { Stepper: an },
            on: {
                tabMounted: function (e) {
                    var t = this;
                    Ee(e)
                        .find(".stepper-init")
                        .each(function (e) {
                            var a = Ee(e).dataset();
                            t.stepper.create(Qe({ el: e }, a || {}));
                        });
                },
                tabBeforeRemove: function (e) {
                    Ee(e)
                        .find(".stepper-init")
                        .each(function (e) {
                            e.f7Stepper && e.f7Stepper.destroy();
                        });
                },
                pageInit: function (e) {
                    var t = this;
                    e.$el.find(".stepper-init").each(function (e) {
                        var a = Ee(e).dataset();
                        t.stepper.create(Qe({ el: e }, a || {}));
                    });
                },
                pageBeforeRemove: function (e) {
                    e.$el.find(".stepper-init").each(function (e) {
                        e.f7Stepper && e.f7Stepper.destroy();
                    });
                },
            },
            vnode: {
                "stepper-init": {
                    insert: function (e) {
                        var t = e.elm,
                            a = Ee(t).dataset();
                        this.stepper.create(Qe({ el: t }, a || {}));
                    },
                    destroy: function (e) {
                        var t = e.elm;
                        t.f7Stepper && t.f7Stepper.destroy();
                    },
                },
            },
        },
        nn = (function (e) {
            function t(t, a) {
                var r;
                void 0 === a && (a = {});
                var n = ze((r = e.call(this, a, [t]) || this)),
                    o = Qe({ on: {} }, t.params.smartSelect);
                void 0 === o.searchbarDisableButton &&
                    (o.searchbarDisableButton = "aurora" !== t.theme),
                    n.useModulesParams(o),
                    (n.params = Qe({}, o, a)),
                    (n.app = t);
                var i = Ee(n.params.el).eq(0);
                if (0 === i.length) return n || ze(r);
                if (i[0].f7SmartSelect) return i[0].f7SmartSelect || ze(r);
                var s,
                    l = i.find("select").eq(0);
                if (0 === l.length) return n || ze(r);
                n.params.setValueText &&
                    (0 === (s = Ee(n.params.valueEl)).length &&
                        (s = i.find(".item-after")),
                    0 === s.length &&
                        (s = Ee('<div class="item-after"></div>')).insertAfter(
                            i.find(".item-title")
                        ));
                var c = a.url;
                c ||
                    (i.attr("href") && "#" !== i.attr("href")
                        ? (c = i.attr("href"))
                        : l.attr("name") &&
                          (c = l.attr("name").toLowerCase() + "-select/")),
                    c || (c = n.params.url);
                var p = l[0].multiple,
                    d = p ? "checkbox" : "radio",
                    u = Ae();
                function h() {
                    n.open();
                }
                function f() {
                    var e = n.$selectEl.val();
                    n.$el.trigger("smartselect:change", e),
                        n.emit("local::change smartSelectChange", n, e),
                        n.vl && n.vl.clearCache(),
                        n.setValueText();
                }
                function v() {
                    var e,
                        t,
                        a,
                        r = this,
                        o = r.value,
                        i = [];
                    if ("checkbox" === r.type) {
                        for (var s = 0; s < n.selectEl.options.length; s += 1)
                            (e = n.selectEl.options[s]).value === o &&
                                (e.selected = r.checked),
                                e.selected &&
                                    ((t =
                                        (a = e.dataset
                                            ? e.dataset.displayAs
                                            : Ee(e).data("display-value-as")) &&
                                        void 0 !== a
                                            ? a
                                            : e.textContent),
                                    i.push(t.trim()));
                        n.maxLength && n.checkMaxLength();
                    } else
                        (e = n.$selectEl.find(
                            'option[value="' + o + '"]'
                        )[0]) ||
                            (e = n.$selectEl
                                .find("option")
                                .filter(function (e) {
                                    return e.value === o;
                                })[0]),
                            (i = [
                                (t =
                                    (a = e.dataset
                                        ? e.dataset.displayAs
                                        : Ee(e).data("display-as")) &&
                                    void 0 !== a
                                        ? a
                                        : e.textContent),
                            ]),
                            (n.selectEl.value = o);
                    n.$selectEl.trigger("change"),
                        n.params.setValueText &&
                            n.$valueEl.text(n.formatValueText(i)),
                        n.params.closeOnSelect &&
                            "radio" === n.inputType &&
                            n.close();
                }
                return (
                    Qe(n, {
                        $el: i,
                        el: i[0],
                        $selectEl: l,
                        selectEl: l[0],
                        $valueEl: s,
                        valueEl: s && s[0],
                        url: c,
                        multiple: p,
                        inputType: d,
                        id: u,
                        inputName: d + "-" + u,
                        selectName: l.attr("name"),
                        maxLength: l.attr("maxlength") || a.maxLength,
                    }),
                    (i[0].f7SmartSelect = n),
                    (n.attachEvents = function () {
                        i.on("click", h), i.on("change", "select", f);
                    }),
                    (n.detachEvents = function () {
                        i.off("click", h), i.off("change", "select", f);
                    }),
                    (n.attachInputsEvents = function () {
                        n.$containerEl.on(
                            "change",
                            'input[type="checkbox"], input[type="radio"]',
                            v
                        );
                    }),
                    (n.detachInputsEvents = function () {
                        n.$containerEl.off(
                            "change",
                            'input[type="checkbox"], input[type="radio"]',
                            v
                        );
                    }),
                    n.useModules(),
                    n.init(),
                    n || ze(r)
                );
            }
            Me(t, e);
            var a = t.prototype;
            return (
                (a.setValue = function (e) {
                    var t,
                        a,
                        r,
                        n = this,
                        o = e,
                        i = [];
                    if (n.multiple) {
                        Array.isArray(o) || (o = [o]);
                        for (var s = 0; s < n.selectEl.options.length; s += 1)
                            (t = n.selectEl.options[s]),
                                o.indexOf(t.value) >= 0
                                    ? (t.selected = !0)
                                    : (t.selected = !1),
                                t.selected &&
                                    ((r =
                                        (a = t.dataset
                                            ? t.dataset.displayAs
                                            : Ee(t).data("display-value-as")) &&
                                        void 0 !== a
                                            ? a
                                            : t.textContent),
                                    i.push(r.trim()));
                    } else
                        (t = n.$selectEl.find(
                            'option[value="' + o + '"]'
                        )[0]) &&
                            (i = [
                                (r =
                                    (a = t.dataset
                                        ? t.dataset.displayAs
                                        : Ee(t).data("display-as")) &&
                                    void 0 !== a
                                        ? a
                                        : t.textContent),
                            ]),
                            (n.selectEl.value = o);
                    return (
                        n.params.setValueText &&
                            n.$valueEl.text(n.formatValueText(i)),
                        n.$selectEl.trigger("change"),
                        n
                    );
                }),
                (a.unsetValue = function () {
                    var e = this;
                    e.params.setValueText &&
                        e.$valueEl.text(e.formatValueText([])),
                        e.$selectEl.find("option").each(function (e) {
                            (e.selected = !1), (e.checked = !1);
                        }),
                        (e.$selectEl[0].value = null),
                        e.$containerEl &&
                            e.$containerEl
                                .find(
                                    'input[name="' +
                                        e.inputName +
                                        '"][type="checkbox"], input[name="' +
                                        e.inputName +
                                        '"][type="radio"]'
                                )
                                .prop("checked", !1),
                        e.$selectEl.trigger("change");
                }),
                (a.getValue = function () {
                    return this.$selectEl.val();
                }),
                (a.checkMaxLength = function () {
                    var e = this,
                        t = e.$containerEl;
                    e.selectEl.selectedOptions.length >= e.maxLength
                        ? t.find('input[type="checkbox"]').each(function (e) {
                              e.checked
                                  ? Ee(e).parents("li").removeClass("disabled")
                                  : Ee(e).parents("li").addClass("disabled");
                          })
                        : t.find(".disabled").removeClass("disabled");
                }),
                (a.formatValueText = function (e) {
                    var t = this;
                    return t.params.formatValueText
                        ? t.params.formatValueText.call(t, e, t)
                        : e.join(", ");
                }),
                (a.setValueText = function (e) {
                    var t = this,
                        a = [];
                    void 0 !== e
                        ? (a = Array.isArray(e) ? e : [e])
                        : t.$selectEl.find("option").each(function (e) {
                              var t = Ee(e);
                              if (e.selected) {
                                  var r = e.dataset
                                      ? e.dataset.displayAs
                                      : t.data("display-value-as");
                                  r && void 0 !== r
                                      ? a.push(r)
                                      : a.push(e.textContent.trim());
                              }
                          }),
                        t.params.setValueText &&
                            t.$valueEl.text(t.formatValueText(a));
                }),
                (a.getItemsData = function () {
                    var e,
                        t = this,
                        a = t.app.theme,
                        r = [];
                    return (
                        t.$selectEl.find("option").each(function (n) {
                            var o = Ee(n),
                                i = o.dataset(),
                                s = i.optionImage || t.params.optionImage,
                                l = i.optionIcon || t.params.optionIcon,
                                c =
                                    "ios" === a &&
                                    (i.optionIconIos || t.params.optionIconIos),
                                p =
                                    "md" === a &&
                                    (i.optionIconMd || t.params.optionIconMd),
                                d =
                                    "aurora" === a &&
                                    (i.optionIconAurora ||
                                        t.params.optionIconAurora),
                                u = s || l || c || p || d,
                                h = i.optionColor,
                                f = i.optionClass || "";
                            o[0].disabled && (f += " disabled");
                            var v = o.parent("optgroup")[0],
                                m = v && v.label,
                                g = !1;
                            v &&
                                v !== e &&
                                ((g = !0),
                                (e = v),
                                r.push({ groupLabel: m, isLabel: g })),
                                r.push({
                                    value: o[0].value,
                                    text: o[0].textContent.trim(),
                                    selected: o[0].selected,
                                    groupEl: v,
                                    groupLabel: m,
                                    image: s,
                                    icon: l,
                                    iconIos: c,
                                    iconMd: p,
                                    iconAurora: d,
                                    color: h,
                                    className: f,
                                    disabled: o[0].disabled,
                                    id: t.id,
                                    hasMedia: u,
                                    checkbox: "checkbox" === t.inputType,
                                    radio: "radio" === t.inputType,
                                    inputName: t.inputName,
                                    inputType: t.inputType,
                                });
                        }),
                        (t.items = r),
                        r
                    );
                }),
                (a.renderSearchbar = function () {
                    var e = this;
                    return e.params.renderSearchbar
                        ? e.params.renderSearchbar.call(e)
                        : lr(
                              "form",
                              { class: "searchbar" },
                              lr(
                                  "div",
                                  { class: "searchbar-inner" },
                                  lr(
                                      "div",
                                      { class: "searchbar-input-wrap" },
                                      lr("input", {
                                          type: "search",
                                          spellcheck:
                                              e.params.searchbarSpellcheck ||
                                              "false",
                                          placeholder:
                                              e.params.searchbarPlaceholder,
                                      }),
                                      lr("i", { class: "searchbar-icon" }),
                                      lr("span", {
                                          class: "input-clear-button",
                                      })
                                  ),
                                  e.params.searchbarDisableButton &&
                                      lr(
                                          "span",
                                          { class: "searchbar-disable-button" },
                                          e.params.searchbarDisableText
                                      )
                              )
                          );
                }),
                (a.renderItem = function (e, t) {
                    var a,
                        r,
                        n = this;
                    if (n.params.renderItem)
                        return n.params.renderItem.call(n, e, t);
                    if (e.isLabel)
                        a =
                            '<li class="item-divider">' +
                            e.groupLabel +
                            "</li>";
                    else {
                        var o,
                            i = e.selected;
                        if (n.params.virtualList) {
                            var s = n.getValue();
                            (i = n.multiple
                                ? s.indexOf(e.value) >= 0
                                : s === e.value),
                                n.multiple &&
                                    (o =
                                        n.multiple &&
                                        !i &&
                                        s.length === parseInt(n.maxLength, 10));
                        }
                        var l = e.icon,
                            c = e.iconIos,
                            p = e.iconMd,
                            d = e.iconAurora,
                            u = l || c || p || d,
                            h =
                                (void 0 === (r = l || c || p || d || "") &&
                                    (r = ""),
                                r.indexOf(":") >= 0 ? r.split(":")[1] : ""),
                            f = (function (e) {
                                if (
                                    (void 0 === e && (e = ""),
                                    e.indexOf(":") >= 0)
                                ) {
                                    var t = e.split(":")[0];
                                    return (
                                        "f7" === t && (t = "f7-icons"),
                                        "material" === t &&
                                            (t = "material-icons"),
                                        t
                                    );
                                }
                                return e;
                            })(l || c || p || d || "");
                        a = lr(
                            "li",
                            {
                                class:
                                    (e.className || "") +
                                    (o ? " disabled" : ""),
                            },
                            lr(
                                "label",
                                {
                                    class:
                                        "item-" + e.inputType + " item-content",
                                },
                                lr("input", {
                                    type: e.inputType,
                                    name: e.inputName,
                                    value: e.value,
                                    _checked: i,
                                }),
                                lr("i", { class: "icon icon-" + e.inputType }),
                                e.hasMedia &&
                                    lr(
                                        "div",
                                        { class: "item-media" },
                                        u && lr("i", { class: "icon " + f }, h),
                                        e.image && lr("img", { src: e.image })
                                    ),
                                lr(
                                    "div",
                                    { class: "item-inner" },
                                    lr(
                                        "div",
                                        {
                                            class:
                                                "item-title" +
                                                (e.color
                                                    ? " text-color-" + e.color
                                                    : ""),
                                        },
                                        e.text
                                    )
                                )
                            )
                        );
                    }
                    return a;
                }),
                (a.renderItems = function () {
                    var e = this;
                    return e.params.renderItems
                        ? e.params.renderItems.call(e, e.items)
                        : "\n      " +
                              e.items
                                  .map(function (t, a) {
                                      return "" + e.renderItem(t, a);
                                  })
                                  .join("") +
                              "\n    ";
                }),
                (a.renderPage = function () {
                    var e = this;
                    if (e.params.renderPage)
                        return e.params.renderPage.call(e, e.items);
                    var t = e.params.pageTitle;
                    if (void 0 === t) {
                        var a = e.$el.find(".item-title");
                        t = a.length ? a.text().trim() : "";
                    }
                    var r = e.params.cssClass;
                    return lr(
                        "div",
                        {
                            class: "page smart-select-page " + r,
                            "data-name": "smart-select-page",
                            "data-select-name": e.selectName,
                        },
                        lr(
                            "div",
                            {
                                class:
                                    "navbar " +
                                    (e.params.navbarColorTheme
                                        ? "color-" + e.params.navbarColorTheme
                                        : ""),
                            },
                            lr("div", { class: "navbar-bg" }),
                            lr(
                                "div",
                                {
                                    class:
                                        "navbar-inner sliding " +
                                        (e.params.navbarColorTheme
                                            ? "color-" +
                                              e.params.navbarColorTheme
                                            : ""),
                                },
                                lr(
                                    "div",
                                    { class: "left" },
                                    lr(
                                        "a",
                                        { class: "link back" },
                                        lr("i", { class: "icon icon-back" }),
                                        lr(
                                            "span",
                                            { class: "if-not-md" },
                                            e.params.pageBackLinkText
                                        )
                                    )
                                ),
                                t && lr("div", { class: "title" }, t),
                                e.params.searchbar &&
                                    lr(
                                        "div",
                                        { class: "subnavbar" },
                                        e.renderSearchbar()
                                    )
                            )
                        ),
                        e.params.searchbar &&
                            lr("div", { class: "searchbar-backdrop" }),
                        lr(
                            "div",
                            { class: "page-content" },
                            lr(
                                "div",
                                {
                                    class:
                                        "list smart-select-list-" +
                                        e.id +
                                        " " +
                                        (e.params.virtualList
                                            ? " virtual-list"
                                            : "") +
                                        " " +
                                        (e.params.formColorTheme
                                            ? "color-" + e.params.formColorTheme
                                            : ""),
                                },
                                lr(
                                    "ul",
                                    null,
                                    !e.params.virtualList &&
                                        e.renderItems(e.items)
                                )
                            )
                        )
                    );
                }),
                (a.renderPopup = function () {
                    var e = this;
                    if (e.params.renderPopup)
                        return e.params.renderPopup.call(e, e.items);
                    var t = e.params.pageTitle;
                    if (void 0 === t) {
                        var a = e.$el.find(".item-title");
                        t = a.length ? a.text().trim() : "";
                    }
                    var r = e.params.cssClass || "";
                    return lr(
                        "div",
                        {
                            class:
                                "popup smart-select-popup " +
                                r +
                                " " +
                                (e.params.popupTabletFullscreen
                                    ? "popup-tablet-fullscreen"
                                    : ""),
                            "data-select-name": e.selectName,
                        },
                        lr(
                            "div",
                            { class: "view" },
                            lr(
                                "div",
                                {
                                    class:
                                        "page smart-select-page " +
                                        (e.params.searchbar
                                            ? "page-with-subnavbar"
                                            : ""),
                                    "data-name": "smart-select-page",
                                },
                                lr(
                                    "div",
                                    {
                                        class:
                                            "navbar " +
                                            (e.params.navbarColorTheme
                                                ? "color-" +
                                                  e.params.navbarColorTheme
                                                : ""),
                                    },
                                    lr("div", { class: "navbar-bg" }),
                                    lr(
                                        "div",
                                        { class: "navbar-inner sliding" },
                                        t && lr("div", { class: "title" }, t),
                                        lr(
                                            "div",
                                            { class: "right" },
                                            lr(
                                                "a",
                                                {
                                                    class: "link popup-close",
                                                    "data-popup":
                                                        ".smart-select-popup[data-select-name='" +
                                                        e.selectName +
                                                        "']",
                                                },
                                                e.params.popupCloseLinkText
                                            )
                                        ),
                                        e.params.searchbar &&
                                            lr(
                                                "div",
                                                { class: "subnavbar" },
                                                e.renderSearchbar()
                                            )
                                    )
                                ),
                                e.params.searchbar &&
                                    lr("div", { class: "searchbar-backdrop" }),
                                lr(
                                    "div",
                                    { class: "page-content" },
                                    lr(
                                        "div",
                                        {
                                            class:
                                                "list smart-select-list-" +
                                                e.id +
                                                " " +
                                                (e.params.virtualList
                                                    ? " virtual-list"
                                                    : "") +
                                                " " +
                                                (e.params.formColorTheme
                                                    ? "color-" +
                                                      e.params.formColorTheme
                                                    : ""),
                                        },
                                        lr(
                                            "ul",
                                            null,
                                            !e.params.virtualList &&
                                                e.renderItems(e.items)
                                        )
                                    )
                                )
                            )
                        )
                    );
                }),
                (a.renderSheet = function () {
                    var e = this;
                    if (e.params.renderSheet)
                        return e.params.renderSheet.call(e, e.items);
                    var t = e.params.cssClass;
                    return lr(
                        "div",
                        {
                            class: "sheet-modal smart-select-sheet " 