
<?php $__env->startSection('isi'); ?>
    <div class="container-fluid">
        <div class="card" style="border-radius: 20px">
            <div class="card-body">
                <form action="<?php echo e(url('/pajak-pph21')); ?>">
                    <?php
                        $bulan = array(
                        [
                            "id" => "1",
                            "bulan" => "Januari"
                        ],
                        [
                            "id" => "2",
                            "bulan" => "Februari"
                        ],
                        [
                            "id" => "3",
                            "bulan" => "Maret"
                        ],
                        [
                            "id" => "4",
                            "bulan" => "April"
                        ],
                        [
                            "id" => "5",
                            "bulan" => "Mei"
                        ],
                        [
                            "id" => "6",
                            "bulan" => "Juni"
                        ],
                        [
                            "id" => "7",
                            "bulan" => "Juli"
                        ],
                        [
                            "id" => "8",
                            "bulan" => "Agustus"
                        ],
                        [
                            "id" => "9",
                            "bulan" => "September"
                        ],
                        [
                            "id" => "10",
                            "bulan" => "Oktober"
                        ],
                        [
                            "id" => "11",
                            "bulan" => "November"
                        ],
                        [
                            "id" => "12",
                            "bulan" => "Desember"
                        ]);

                        $last = date('Y')-10;
                        $now = date('Y');
                    ?>
                    <div class="form-row mb-2">
                        <div class="col-2">
                            <select name="tahun" id="tahun" class="form-control selectpicker" data-live-search="true">
                                <?php for($i = $now; $i >= $last; $i--): ?>
                                    <?php if(old('tahun', $now) == $i): ?>
                                        <option value="<?php echo e($i); ?>" selected><?php echo e($i); ?></option>
                                    <?php else: ?>
                                        <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                    <?php endif; ?>
                                <?php endfor; ?>
                            </select>
                        </div>
                        <div class="col-2">
                            <select name="bulan" id="bulan" class="form-control selectpicker" data-live-search="true">
                                <option value=""selected>Bulan</option>
                                <?php $__currentLoopData = $bulan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bul): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(request('bulan') == $bul['id']): ?>
                                        <option value="<?php echo e($bul['id']); ?>"selected><?php echo e($bul['bulan']); ?></option>
                                    <?php else: ?>
                                        <option value="<?php echo e($bul['id']); ?>"><?php echo e($bul['bulan']); ?></option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div>
                            <button type="submit" id="search" class="form-control btn btn-secondary" style="border-radius: 10px"><i class="fas fa-search"></i></button>
                        </div>
                    </div>
                </form>
                <table id="tablePayroll" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <th>Nama</th>
                            <th>Bulan</th>
                            <th>Tahun</th>
                            <th>Status</th>
                            <th>Penghasilan Bruto</th>
                            <th>Penghasilan Netto Sebulan</th>
                            <th>Penghasilan Netto Setahun</th>
                            <th>PTKP</th>
                            <th>PKP Setahun</th>
                            <th>PPH 21 Setahun</th>
                            <th>PPH 21 Sebulan</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($d->User->name); ?></td>
                                <td>
                                    <?php
                                        if ($d->bulan == 1){
                                            $nama_bulan = 'Januari';
                                        } else if($d->bulan == 2) {
                                            $nama_bulan = 'Februari';
                                        } else if($d->bulan == 3) {
                                            $nama_bulan = 'Maret';
                                        } else if($d->bulan == 4) {
                                            $nama_bulan = 'April';
                                        } else if($d->bulan == 5) {
                                            $nama_bulan = 'Mei';
                                        } else if($d->bulan == 6) {
                                            $nama_bulan = 'Juni';
                                        } else if($d->bulan == 7) {
                                            $nama_bulan = 'Juli';
                                        } else if($d->bulan == 8) {
                                            $nama_bulan = 'Agustus';
                                        } else if($d->bulan == 9) {
                                            $nama_bulan = 'September';
                                        } else if($d->bulan == 10) {
                                            $nama_bulan = 'Oktober';
                                        } else if($d->bulan == 11) {
                                            $nama_bulan = 'November';
                                        } else if($d->bulan == 12) {
                                            $nama_bulan = 'Desember';
                                        } else {
                                            $nama_bulan = '-';
                                        }
                                    ?>
                                    <?php echo e($nama_bulan); ?>

                                </td>
                                <td><?php echo e($d->tahun); ?></td>
                                <td><?php echo e($d->ptkp->name); ?></td>
                                <td>
                                    <?php
                                        if ($d->gaji > 500000) {
                                            $biaya_jabatan = 500000;
                                        } else {
                                            $biaya_jabatan = $gaji * (5/100);
                                        }
                                        $jumlah_hadir = $d->JumlahHadir($d->user_id, $d->bulan, $d->tahun, 'Masuk') + $d->JumlahHadir($d->user_id, $d->bulan, $d->tahun, 'Izin Pulang Cepat') + $d->JumlahHadir($d->user_id, $d->bulan, $d->tahun, 'Izin Telat');
                                        $bruto = ($d->User->Golongan->Tunjangan->first()->tunjangan_makan * $jumlah_hadir) + ($d->User->Golongan->Tunjangan->first()->tunjangan_transport * $jumlah_hadir) + $d->gaji + $d->lembur;
                                        $netto = $bruto - $biaya_jabatan - ($d->setoran_bpjs_kes - $d->tunjangan_bpjs_kes);
                                        $nettoYear = $netto * 12;
                                        $cekPkp = $nettoYear - $d->ptkp->ptkp_2016;
                                    ?>
                                    <?php echo e(number_format($bruto, 2, ".", ",")); ?>

                                </td>
                                <td><?php echo e(number_format($netto, 2, ".", ",")); ?></td>
                                <td><?php echo e(number_format($nettoYear, 2, ".", ",")); ?></td>
                                <td><?php echo e(number_format($d->ptkp->ptkp_2016, 2, ".", ",")); ?></td>
                                <td>
                                    <?php
                                        if ($cekPkp > 0) {
                                            $pkpSetahun = $cekPkp;
                                        } else {
                                            $pkpSetahun = 0;
                                        }
                                    ?>
                                    <?php echo e(number_format($pkpSetahun, 2, ".", ",")); ?>

                                </td>
                                <td>
                                    <?php
                                        if ($pkpSetahun <= 50000000) {
                                            $tax = 5;
                                        } else if ($pkpSetahun > 50000000 && $pkpSetahun <= 250000000) {
                                            $tax = 15;
                                        } else if ($pkpSetahun > 250000000 && $pkpSetahun <= 500000000) {
                                            $tax = 25;
                                        } else {
                                            $tax = 50;
                                        }
                                    ?>
                                    <?php echo e(number_format($pkpSetahun * ($tax/100), 2, ".", ",")); ?>

                                </td>
                                <td><?php echo e(number_format(($pkpSetahun * ($tax/100)) / 12, 2, ".", ",")); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="d-flex justify-content-end mr-4">
                <?php echo e($data->links()); ?>

            </div>
        </div>
    </div>
    <br>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\absensi\resources\views/pajak/index.blade.php ENDPATH**/ ?>