<?php $__env->startSection('isi'); ?>
    <div class="row">
        <div class="col-md-12 project-list">
            <div class="card">
                <div class="row">
                    <div class="col-md-6 mt-2 p-0 d-flex">
                        <h4><?php echo e($title); ?></h4>
                    </div>
                    <div class="col-md-6 p-0">    
                        <a href="<?php echo e(url('/shift/create')); ?>" class="btn btn-primary">+ Tambah</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <form action="<?php echo e(url('/shift')); ?>">
                        <div class="row mb-2">
                            <div class="col-2">
                                <input type="text" placeholder="Search...." class="form-control" value="<?php echo e(request('search')); ?>" name="search">
                            </div>
                            <div class="col">
                                <button type="submit" id="search"class="border-0 mt-3" style="background-color: transparent;"><i class="fas fa-search"></i></button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="mytable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>No.</th>
                                    <th>Nama Shift</th>
                                    <th>Jam Masuk</th>
                                    <th>Jam Keluar</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $shift; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($s->nama_shift); ?></td>
                                        <td><?php echo e($s->jam_masuk); ?></td>
                                        <td><?php echo e($s->jam_keluar); ?></td>
                                        <td>
                                            <ul class="action">
                                                <?php if($s->nama_shift == 'Libur'): ?>
                                                    <li>
                                                        <span class="badge badge-success">Default Shift</span>
                                                    </li>
                                                <?php else: ?>
                                                    <li class="edit">
                                                        <a href="<?php echo e(url('/shift/'.$s->id.'/edit')); ?>"><i class="fa fa-solid fa-edit"></i></a>
                                                    </li>
                                                    <li class="delete">
                                                        <form action="<?php echo e(url('/shift/'.$s->id)); ?>" method="post" class="d-inline">
                                                            <?php echo method_field('delete'); ?>
                                                            <?php echo csrf_field(); ?>
                                                            <button class="border-0" style="background-color: transparent;" onClick="return confirm('Are You Sure')"><i class="fa fa-solid fa-trash"></i></button>
                                                        </form>
                                                    </li>
                                                <?php endif; ?>
                                            </ul>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-end mt-4">
                        <?php echo e($shift->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <br>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('templates.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iusoluti/absensi.igtax.net/resources/views/shift/index.blade.php ENDPATH**/ ?>