<?php $__env->startSection('isi'); ?>
    <?php $__env->startPush('style'); ?>
        <style>
            canvas {
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
            }
        </style>
    <?php $__env->stopPush(); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="p-4">
                    <div class="form-group">
                        <label for="name" class="float-left">Nama</label>
                        <input type="text" class="form-control" value="<?php echo e($karyawan->name); ?>" disabled id="name">
                    </div>
                    <input type="hidden" name="username" id="username" value="<?php echo e($karyawan->username); ?>">
                    <video id="video" autoplay playsinline class="col-lg-12 col-md-12 col-sm-12 mx-auto"></video>
                    <br>
                    <center>
                        <button id="capture" class="btn btn-primary mt-4">Capture Image</button>
                    </center>
                </div>
            </div>
        </div>
    </div>
    <?php $__env->startPush('script'); ?>
        <script src="<?php echo e(url('/face/dist/face-api.min.js')); ?>"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script>
            let video = document.getElementById("video");
            let width = 640;
            let height = 480;

            const startStream = () => {
                navigator.mediaDevices.getUserMedia({
                    video: { facingMode: "user", width, height },
                    audio: false
                }).then((stream) => {
                    video.srcObject = stream;
                });
            }

            Promise.all([
                faceapi.nets.tinyFaceDetector.loadFromUri("<?php echo e(url('/face/weights')); ?>"),
                faceapi.nets.faceLandmark68Net.loadFromUri("<?php echo e(url('/face/weights')); ?>"),
                faceapi.nets.faceRecognitionNet.loadFromUri("<?php echo e(url('/face/weights')); ?>")
            ]).then(startStream);

            $(document).ready(function(){
                const descriptions = [];

                $("#capture").click(async function(){
                    Swal.fire({
                        title: 'Processing...',
                        text: 'Detecting face, please wait.',
                        allowOutsideClick: false,
                        didOpen: () => {
                            Swal.showLoading()
                        }
                    });

                    var username = $('#username').val();
                    const label = username;

                    var canvas = document.createElement('canvas');
                    canvas.width = width;
                    canvas.height = height;
                    var context = canvas.getContext('2d');
                    context.drawImage(video, 0, 0, width, height);

                    var img = document.createElement('img');
                    img.src = canvas.toDataURL('image/png');

                    const detections = await faceapi.detectSingleFace(img, new faceapi.TinyFaceDetectorOptions()).withFaceLandmarks().withFaceDescriptor();

                    if(detections) {
                        descriptions.push(detections.descriptor);
                        var descrip = descriptions;

                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });

                        $.ajax({
                            type : 'POST',
                            url : "<?php echo e(url('/pegawai/face/ajaxPhoto')); ?>",
                            data :  {image: img.src ,path: username},
                            cache : false,
                            success: function(msg){
                                console.log(msg);
                            },
                            error: function(data){
                                console.log('error:', data);
                            }
                        });

                        var postData = new faceapi.LabeledFaceDescriptors(label, descrip);
                        $.ajax({
                            type : 'POST',
                            url : "<?php echo e(url('/pegawai/face/ajaxDescrip')); ?>",
                            data :  { myData: JSON.stringify(postData), user_id:<?php echo e($karyawan->id); ?> },
                            datatype : 'json',
                            cache : false,
                            success: function(msg){
                                Swal.fire('Berhasil Daftar Wajah!', '', 'success');
                                setTimeout(function() {
                                    window.location.href = "<?php echo e(url('/pegawai')); ?>";
                                }, 2000);
                            },
                            error: function(data){
                                console.log('error:', data);
                            }
                        });
                    } else {
                        Swal.fire('Gagal Deteksi Wajah!', 'Silakan coba lagi.', 'error');
                    }
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('templates.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iusoluti/absensi.igtax.net/resources/views/karyawan/face.blade.php ENDPATH**/ ?>