<?php $__env->startSection('isi'); ?>
    <div class="row">
        <div class="col-md-12 project-list">
            <div class="card">
                <div class="row">
                    <div class="col-md-6 mt-2 p-0 d-flex">
                        <h4><?php echo e($title); ?></h4>
                    </div>
                    <div class="col-md-6 p-0">    
                        <a class="btn btn-primary btn-sm" href="<?php echo e(url('/data-cuti/tambah')); ?>">+ Tambah</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <form action="<?php echo e(url('/data-cuti')); ?>">
                            <div class="row">
                            <div class="col-3">
                                <input type="datetime" class="form-control" name="mulai" placeholder="Tanggal Mulai" id="mulai" value="<?php echo e(request('mulai')); ?>">
                            </div>
                            <div class="col-3">
                                <input type="datetime" class="form-control" name="akhir" placeholder="Tanggal Akhir" id="akhir" value="<?php echo e(request('akhir')); ?>">
                            </div>
                            <div class="col-3">
                                <button type="submit" id="search"class="border-0 mt-3" style="background-color: transparent;"><i class="fas fa-search"></i></button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="mytable">
                            <thead>
                                <tr>
                                    <th>No.</th>
                                    <th>Nama Pegawai</th>
                                    <th>Nama Cuti</th>
                                    <th>Tanggal</th>
                                    <th>Alasan Cuti</th>
                                    <th>Foto Cuti</th>
                                    <th>Status Cuti</th>
                                    <th>Catatan</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data_cuti; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($dc->User->name); ?></td>
                                    <td><?php echo e($dc->nama_cuti); ?></td>
                                    <td><?php echo e($dc->tanggal); ?></td>
                                    <td><?php echo e($dc->alasan_cuti); ?></td>
                                    <td>
                                        <img src="<?php echo e(url('storage/'.$dc->foto_cuti)); ?>" style="width: 70px" alt="">
                                    </td>
                                    <td>
                                        <?php if($dc->status_cuti == "Diterima"): ?>
                                            <span class="badge badge-success"><?php echo e($dc->status_cuti); ?></span>
                                        <?php elseif($dc->status_cuti == "Ditolak"): ?>
                                            <span class="badge badge-danger"><?php echo e($dc->status_cuti); ?></span>
                                        <?php else: ?>
                                            <span class="badge badge-warning"><?php echo e($dc->status_cuti); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($dc->catatan); ?></td>
                                    <td>
                                        <ul class="action">
                                            <?php if($dc->status_cuti == "Diterima"): ?>
                                                <li class="me-2">
                                                    <span class="badge badge-success">Sudah Approve</span>
                                                </li>
                                            <?php else: ?>
                                                <li>
                                                    <a href="<?php echo e(url('/data-cuti/edit/'.$dc->id)); ?>"><i style="color: blue" class="fas fa-edit"></i></a>
                                                </li>
                                            <?php endif; ?>
            
                                            <?php if($dc->status_cuti == "Diterima"): ?>
                                                <li>
                                                    <span class="badge badge-success">Sudah Approve</span>
                                                </li>
                                            <?php else: ?>
                                                <li class="delete">
                                                    <form action="<?php echo e(url('/data-cuti/delete/'.$dc->id)); ?>" method="post" class="d-inline">
                                                        <?php echo method_field('delete'); ?>
                                                        <?php echo csrf_field(); ?>
                                                        <button class="border-0" style="background-color: transparent" onClick="return confirm('Are You Sure')"><i class="fas fa-trash"></i></button>
                                                    </form>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-end mr-4">
                        <?php echo e($data_cuti->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $__env->startPush('script'); ?>
        <script>
            $(document).ready(function() {
                $('#mulai').change(function(){
                    var mulai = $(this).val();
                $('#akhir').val(mulai);
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('templates.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\absensi\resources\views/cuti/datacuti.blade.php ENDPATH**/ ?>