
<?php $__env->startSection('isi'); ?>
    <div class="container-fluid">
        <div class="card">
            <div class="card-header">
                <a href="<?php echo e(url('/status-ptkp/tambah')); ?>" class="btn btn-primary">+ Tambah Status Pegawai</a>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <form action="<?php echo e(url('/status-ptkp')); ?>">
                    <div class="form-row mb-2">
                        <div class="col-2">
                            <input type="text" class="form-control" name="search" value="<?php echo e(request('search')); ?>">
                        </div>
                        <div>
                            <button type="submit" id="search" class="form-control btn btn-secondary" style="border-radius: 10px"><i class="fas fa-search"></i></button>
                        </div>
                    </div>
                </form>
                <table id="tablePayroll" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <th>Status</th>
                            <th>Nilai PKTP 2016 DST</th>
                            <th>Nilai PKTP 2015</th>
                            <th>Nilai PKTP 2009 - 2012</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($d->name); ?></td>
                                <td>Rp <?php echo e(number_format($d->ptkp_2016, 2, ".", ",")); ?></td>
                                <td>Rp <?php echo e(number_format($d->ptkp_2015, 2, ".", ",")); ?></td>
                                <td>Rp <?php echo e(number_format($d->ptkp_2009_2012, 2, ".", ",")); ?></td>
                                <td>
                                    <a href="<?php echo e(url('/status-ptkp/'.$d->id.'/edit')); ?>" class="btn btn-sm btn-warning"><i class="fa fa-solid fa-edit"></i></a>
                                    <form action="<?php echo e(url('/status-ptkp/'.$d->id.'/delete')); ?>" method="post" class="d-inline">
                                        <?php echo method_field('delete'); ?>
                                        <?php echo csrf_field(); ?>
                                        <button class="btn btn-danger btn-sm btn-circle" onClick="return confirm('Are You Sure')"><i class="fa fa-solid fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <!-- /.card-body -->
        </div>
    </div>
    <br>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\absensi\resources\views/statusPtkp/index.blade.php ENDPATH**/ ?>