
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Mobile Specific Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, viewport-fit=cover">
    <title><?php echo e($title); ?></title>
    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="<?php echo e(url('/myhr/images/logo.png')); ?>" />
    <link rel="apple-touch-icon-precomposed" href="<?php echo e(url('/myhr/images/logo.png')); ?>" />
    <!-- Font -->
    <link rel="stylesheet" href="<?php echo e(url('/myhr/fonts/fonts.css')); ?>" />
    <!-- Icons -->
    <link rel="stylesheet" href="<?php echo e(url('/myhr/fonts/icons-alipay.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(url('/myhr/styles/bootstrap.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(url('/myhr/styles/swiper-bundle.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/myhr/styles/styles.css')); ?>" />
    <link rel="manifest" href="<?php echo e(url('/myhr/_manifest.json')); ?>" data-pwa-version="set_in_manifest_and_pwa_js">
    <link rel="apple-touch-icon" sizes="192x192" href="<?php echo e(url('/myhr/app/icons/icon-192x192.png')); ?>">
</head>

<body class="bg_surface_color">
     <!-- preloade -->
     <div class="preload preload-container">
        <div class="preload-logo">
          <div class="spinner"></div>
        </div>
      </div>
    <!-- /preload -->
    <div class="header is-fixed">
        <div class="tf-container">
            <div class="tf-statusbar d-flex justify-content-center align-items-center">
                <a href="#" class="back-btn"> <i class="icon-left"></i> </a>
                <h3><?php echo e($title); ?></h3>
            </div>
        </div>
    </div>
    <div id="app-wrap" class="style1">
            <div class="app-section bg_white_color mt-1">
                <div class="tf-container">
                      <ul class="box-service mt-5">
                          <li>
                              <a href="<?php echo e(url('/absen')); ?>">
                              <div class="icon-box bg_service-2">
                                  <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                      <path d="M6.45831 5.67188C6.07 5.67188 5.75519 5.98669 5.75519 6.375C5.75519 6.76331 6.07 7.07812 6.45831 7.07812C6.84663 7.07812 7.16144 6.76331 7.16144 6.375C7.16144 5.98669 6.84663 5.67188 6.45831 5.67188ZM3.64581 11.2969C3.2575 11.2969 2.94269 11.6117 2.94269 12C2.94269 12.3883 3.2575 12.7031 3.64581 12.7031H6.45831C6.84663 12.7031 7.16144 12.3883 7.16144 12C7.16144 11.6117 6.84663 11.2969 6.45831 11.2969H3.64581ZM2.94269 3.5625V9.1875C2.94269 9.57581 3.2575 9.89062 3.64581 9.89062H9.27081C9.65913 9.89062 9.97394 9.57581 9.97394 9.1875V3.5625C9.97394 3.17419 9.65913 2.85938 9.27081 2.85938H3.64581C3.2575 2.85938 2.94269 3.17419 2.94269 3.5625ZM4.34894 4.26562H8.56769V8.48438H4.34894V4.26562ZM8.56769 12C8.56769 12.3883 8.8825 12.7031 9.27081 12.7031H14.8958C15.2841 12.7031 15.5989 12.3883 15.5989 12C15.5989 11.6117 15.2841 11.2969 14.8958 11.2969H12.7864L12.7864 3.5625C12.7864 3.17419 12.4716 2.85938 12.0833 2.85938C11.695 2.85938 11.3802 3.17419 11.3802 3.5625L11.3801 11.2969H9.27081C8.8825 11.2969 8.56769 11.6117 8.56769 12ZM14.8958 4.26562H19.8177V9.1875C19.8177 9.57581 20.1325 9.89062 20.5208 9.89062C20.9091 9.89062 21.2239 9.57581 21.2239 9.1875V3.5625C21.2239 3.17419 20.9091 2.85938 20.5208 2.85938H14.8958C14.5075 2.85938 14.1927 3.17419 14.1927 3.5625C14.1927 3.95081 14.5075 4.26562 14.8958 4.26562ZM17.0052 6.375C17.0052 6.76331 17.32 7.07812 17.7083 7.07812C18.0966 7.07812 18.4114 6.76331 18.4114 6.375C18.4114 5.98669 18.0966 5.67188 17.7083 5.67188C17.32 5.67188 17.0052 5.98669 17.0052 6.375ZM20.5208 11.2969H17.7083C17.32 11.2969 17.0052 11.6117 17.0052 12C17.0052 12.3883 17.32 12.7031 17.7083 12.7031H20.5208C20.9091 12.7031 21.2239 12.3883 21.2239 12C21.2239 11.6117 20.9091 11.2969 20.5208 11.2969ZM14.8958 9.89062H17.7083C18.0966 9.89062 18.4114 9.57581 18.4114 9.1875C18.4114 8.79919 18.0966 8.48438 17.7083 8.48438H15.5989V6.375C15.5989 5.98669 15.2841 5.67188 14.8958 5.67188C14.5075 5.67188 14.1927 5.98669 14.1927 6.375V9.1875C14.1927 9.57581 14.5075 9.89062 14.8958 9.89062ZM21.9739 0H19.1614C18.7731 0 18.4583 0.314812 18.4583 0.703125C18.4583 1.09144 18.7731 1.40625 19.1614 1.40625H21.9739C22.3616 1.40625 22.6771 1.72167 22.6771 2.10938V4.92188C22.6771 5.31019 22.9919 5.625 23.3802 5.625C23.7685 5.625 24.0833 5.31019 24.0833 4.92188V2.10938C24.0833 0.946266 23.137 0 21.9739 0ZM21.2239 20.4375V14.8125C21.2239 14.4242 20.9091 14.1094 20.5208 14.1094H14.8958C14.5075 14.1094 14.1927 14.4242 14.1927 14.8125V20.4375C14.1927 20.8258 14.5075 21.1406 14.8958 21.1406H20.5208C20.9091 21.1406 21.2239 20.8258 21.2239 20.4375ZM19.8177 19.7344H15.5989V15.5156H19.8177V19.7344ZM12.0833 14.1094C11.695 14.1094 11.3802 14.4242 11.3802 14.8125V20.4375C11.3802 20.8258 11.695 21.1406 12.0833 21.1406C12.4716 21.1406 12.7864 20.8258 12.7864 20.4375V14.8125C12.7864 14.4242 12.4716 14.1094 12.0833 14.1094ZM17.7083 18.3281C18.0966 18.3281 18.4114 18.0133 18.4114 17.625C18.4114 17.2367 18.0966 16.9219 17.7083 16.9219C17.32 16.9219 17.0052 17.2367 17.0052 17.625C17.0052 18.0133 17.32 18.3281 17.7083 18.3281ZM23.3802 18.375C22.9919 18.375 22.6771 18.6898 22.6771 19.0781V21.8906C22.6771 22.2783 22.3616 22.5938 21.9739 22.5938H19.1614C18.7731 22.5938 18.4583 22.9086 18.4583 23.2969C18.4583 23.6852 18.7731 24 19.1614 24H21.9739C23.137 24 24.0833 23.0537 24.0833 21.8906V19.0781C24.0833 18.6898 23.7685 18.375 23.3802 18.375ZM6.45831 18.3281C6.84663 18.3281 7.16144 18.0133 7.16144 17.625C7.16144 17.2367 6.84663 16.9219 6.45831 16.9219C6.07 16.9219 5.75519 17.2367 5.75519 17.625C5.75519 18.0133 6.07 18.3281 6.45831 18.3281ZM9.27081 14.1094H3.64581C3.2575 14.1094 2.94269 14.4242 2.94269 14.8125V20.4375C2.94269 20.8258 3.2575 21.1406 3.64581 21.1406H9.27081C9.65913 21.1406 9.97394 20.8258 9.97394 20.4375V14.8125C9.97394 14.4242 9.65913 14.1094 9.27081 14.1094ZM8.56769 19.7344H4.34894V15.5156H8.56769V19.7344ZM5.00519 22.5938H2.19269C1.80498 22.5938 1.48956 22.2783 1.48956 21.8906V19.0781C1.48956 18.6898 1.17475 18.375 0.786438 18.375C0.398125 18.375 0.083313 18.6898 0.083313 19.0781V21.8906C0.083313 23.0537 1.02958 24 2.19269 24H5.00519C5.3935 24 5.70831 23.6852 5.70831 23.2969C5.70831 22.9086 5.3935 22.5938 5.00519 22.5938ZM0.786438 5.625C1.17475 5.625 1.48956 5.31019 1.48956 4.92188V2.10938C1.48956 1.72167 1.80498 1.40625 2.19269 1.40625H5.00519C5.3935 1.40625 5.70831 1.09144 5.70831 0.703125C5.70831 0.314812 5.3935 0 5.00519 0H2.19269C1.02958 0 0.083313 0.946266 0.083313 2.10938V4.92188C0.083313 5.31019 0.398125 5.625 0.786438 5.625Z" fill="url(#paint0_linear_4552_4954)"/>
                                      <defs>
                                      <linearGradient id="paint0_linear_4552_4954" x1="12.0833" y1="24" x2="12.0833" y2="0" gradientUnits="userSpaceOnUse">
                                      <stop stop-color="#5558FF"/>
                                      <stop offset="1" stop-color="#00C0FF"/>
                                      </linearGradient>
                                      </defs>
                                      </svg>
                              </div>
                              Absensi
                              </a>
                          </li>

                          <li>
                              <a href="<?php echo e(url('/cuti')); ?>">
                                  <div class="icon-box bg_color_2">
                                      <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <g clip-path="url(#clip0_4355_17182)">
                                          <path fill-rule="evenodd" clip-rule="evenodd" d="M12.1251 3.44482C11.8537 3.44482 11.5823 3.44929 11.3754 3.45819C7.2762 3.6346 3.36945 5.25275 0.34614 8.02658C0.0409477 8.30659 0.0419856 8.78279 0.334879 9.07568L1.73847 10.4793C2.03137 10.7722 2.50495 10.7704 2.81312 10.4937C5.17879 8.36971 8.20079 7.11796 11.3755 6.94708C11.7891 6.92482 12.4612 6.92482 12.8748 6.94708C16.0495 7.11796 19.0716 8.36971 21.4372 10.4937C21.7454 10.7704 22.219 10.7722 22.5119 10.4793L23.9154 9.07568C24.2083 8.78279 24.2094 8.30659 23.9042 8.02658C20.8809 5.25275 16.9742 3.63459 12.8749 3.45819C12.668 3.44929 12.3966 3.44482 12.1251 3.44482ZM12.0831 10.4116L11.3339 10.4416C9.09872 10.6112 6.9762 11.4953 5.28166 12.9627C4.9686 13.2338 4.97027 13.7111 5.26316 14.004L6.66667 15.4076C6.95956 15.7005 7.43228 15.6967 7.75477 15.437C8.79066 14.603 10.0444 14.0826 11.3663 13.9378L12.1251 13.8964C14.1994 14.0799 15.4569 14.6008 16.4955 15.437C16.818 15.6967 17.2907 15.7005 17.5836 15.4076L18.9872 14.004C19.2801 13.7111 19.2817 13.2338 18.9686 12.9627C17.2632 11.4859 15.1247 10.6002 12.8745 10.4385C12.4614 10.4089 12.1063 10.4116 12.0831 10.4116ZM12.1251 17.3954C11.854 17.3954 11.5828 17.4175 11.3809 17.4616C10.9771 17.5499 10.5921 17.7094 10.2442 17.9325C9.89616 18.1556 9.89855 18.6394 10.1914 18.9323L11.5949 20.3357C11.7355 20.4763 11.9263 20.5553 12.1252 20.5553C12.3241 20.5553 12.5148 20.4763 12.6555 20.3357L14.0589 18.9323C14.3518 18.6394 14.3542 18.1556 14.0062 17.9325C13.6582 17.7094 13.2732 17.5499 12.8694 17.4616C12.6674 17.4175 12.3963 17.3954 12.1251 17.3954Z" fill="#1E90FF"/>
                                          <path fill-rule="evenodd" clip-rule="evenodd" d="M12.134 3.44482V6.93042C12.4023 6.93056 12.6702 6.93599 12.8746 6.94699C16.0493 7.11786 19.0714 8.36962 21.4371 10.4937C21.7453 10.7703 22.2189 10.7721 22.5118 10.4792L23.9153 9.07559C24.2082 8.7827 24.2093 8.3065 23.9041 8.02649C20.8808 5.25266 16.974 3.6345 12.8748 3.4581C12.6703 3.4493 12.4024 3.44492 12.134 3.44482ZM0.133981 8.39334C0.110813 8.49681 0.111064 8.60452 0.133981 8.70874V8.39334ZM12.134 10.4115V13.8971C14.2028 14.0814 15.4582 14.602 16.4954 15.437C16.8179 15.6966 17.2906 15.7004 17.5835 15.4075L18.9871 14.0039C19.28 13.711 19.2815 13.2337 18.9685 12.9626C17.2631 11.4858 15.1246 10.6001 12.8744 10.4384C12.5312 10.4138 12.2401 10.4116 12.134 10.4115ZM12.134 17.3955V20.5552C12.3298 20.5529 12.5169 20.474 12.6554 20.3356L14.0588 18.9322C14.3517 18.6393 14.3541 18.1556 14.0061 17.9324C13.6581 17.7093 13.273 17.5498 12.8692 17.4615C12.6695 17.4179 12.4021 17.396 12.134 17.3955Z" fill="#0584FF"/>
                                          </g>
                                          <defs>
                                          <clipPath id="clip0_4355_17182">
                                          <rect width="24" height="24" fill="white" transform="translate(0.125)"/>
                                          </clipPath>
                                          </defs>
                                          </svg>
                                          
                                  </div>
                                  Cuti & Izin
                              </a> 
                          </li>  

                          <li>
                              <a href="<?php echo e(url('/dinas-luar')); ?>">
                              
                                <div class="icon-box bg_color_3">
                                    <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M5.87511 1.25C5.49974 1.24954 5.1266 1.30757 4.76911 1.422C4.00043 1.65173 3.32708 2.12475 2.85029 2.76998C2.37349 3.4152 2.11901 4.19775 2.12511 5V10C2.12564 10.7292 2.41554 11.4284 2.93115 11.944C3.44676 12.4596 4.14592 12.7495 4.87511 12.75H8.87511C9.07402 12.75 9.26479 12.671 9.40544 12.5303C9.54609 12.3897 9.62511 12.1989 9.62511 12V5C9.62379 4.00585 9.22827 3.05279 8.5253 2.34981C7.82232 1.64684 6.86926 1.25133 5.87511 1.25Z" fill="#DA9B00"/>
                                        <path d="M23.6248 6.00002V20C23.625 20.3612 23.5541 20.7189 23.416 21.0527C23.2779 21.3865 23.0753 21.6897 22.8199 21.9452C22.5645 22.2006 22.2612 22.4031 21.9275 22.5412C21.5937 22.6793 21.236 22.7503 20.8748 22.75H10.8748C10.5136 22.7503 10.1558 22.6793 9.82208 22.5412C9.48831 22.4031 9.18505 22.2006 8.92964 21.9452C8.67422 21.6897 8.47167 21.3865 8.33356 21.0527C8.19545 20.7189 8.1245 20.3612 8.12477 20V4.25002C8.12328 3.54389 7.87275 2.86092 7.41729 2.32131C6.96182 1.78171 6.33062 1.42006 5.63477 1.30002C5.70929 1.26345 5.79184 1.24626 5.87477 1.25002H18.8748C20.1342 1.25108 21.3418 1.75186 22.2324 2.64243C23.1229 3.533 23.6237 4.74057 23.6248 6.00002Z" fill="#FECC0E"/>
                                        <path d="M15.875 8.75H12.875C12.6761 8.75 12.4853 8.67098 12.3447 8.53033C12.204 8.38968 12.125 8.19891 12.125 8C12.125 7.80109 12.204 7.61032 12.3447 7.46967C12.4853 7.32902 12.6761 7.25 12.875 7.25H15.875C16.0739 7.25 16.2647 7.32902 16.4053 7.46967C16.546 7.61032 16.625 7.80109 16.625 8C16.625 8.19891 16.546 8.38968 16.4053 8.53033C16.2647 8.67098 16.0739 8.75 15.875 8.75Z" fill="white"/>
                                        <path d="M18.875 11.75H12.875C12.6761 11.75 12.4853 11.671 12.3447 11.5303C12.204 11.3897 12.125 11.1989 12.125 11C12.125 10.8011 12.204 10.6103 12.3447 10.4697C12.4853 10.329 12.6761 10.25 12.875 10.25H18.875C19.0739 10.25 19.2647 10.329 19.4053 10.4697C19.546 10.6103 19.625 10.8011 19.625 11C19.625 11.1989 19.546 11.3897 19.4053 11.5303C19.2647 11.671 19.0739 11.75 18.875 11.75Z" fill="white"/>
                                        <path d="M18.875 14.75H12.875C12.6761 14.75 12.4853 14.671 12.3447 14.5303C12.204 14.3897 12.125 14.1989 12.125 14C12.125 13.8011 12.204 13.6103 12.3447 13.4697C12.4853 13.329 12.6761 13.25 12.875 13.25H18.875C19.0739 13.25 19.2647 13.329 19.4053 13.4697C19.546 13.6103 19.625 13.8011 19.625 14C19.625 14.1989 19.546 14.3897 19.4053 14.5303C19.2647 14.671 19.0739 14.75 18.875 14.75Z" fill="white"/>
                                        <path d="M18.875 17.75H12.875C12.6761 17.75 12.4853 17.671 12.3447 17.5303C12.204 17.3897 12.125 17.1989 12.125 17C12.125 16.8011 12.204 16.6103 12.3447 16.4697C12.4853 16.329 12.6761 16.25 12.875 16.25H18.875C19.0739 16.25 19.2647 16.329 19.4053 16.4697C19.546 16.6103 19.625 16.8011 19.625 17C19.625 17.1989 19.546 17.3897 19.4053 17.5303C19.2647 17.671 19.0739 17.75 18.875 17.75Z" fill="white"/>
                                    </svg>
                                </div>
                                Dinas Luar
                              </a> 
                          </li>

                          <li>
                              <a href="<?php echo e(url('/lembur')); ?>">
                                    <div class="icon-box bg_color_4">
                                        <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_4355_16088)">
                                            <path d="M20.3247 10.3362C20.1985 10.1213 19.9678 9.98934 19.7186 9.98934H14.5737L15.2515 0.754543C15.2756 0.425527 15.0678 0.12398 14.7518 0.0294335C14.4357 -0.0653009 13.7855 -0.288481 13.625 -0.000246391L6.91695 12.9651C6.79568 13.1828 6.79878 13.4485 6.92506 13.6634C7.05134 13.8783 7.28201 14.0102 7.53124 14.0102H12.6762L11.625 23.9998H12.625C12.9436 24.0952 13.1548 23.9244 13.3139 23.6386L20.3329 11.0346C20.4541 10.8168 20.451 10.5511 20.3247 10.3362Z" fill="#C8A52A"/>
                                            <path d="M19.3247 10.3364C19.1985 10.1215 18.9678 9.98956 18.7186 9.98956H13.5737L14.2515 0.754767C14.2756 0.425751 14.0678 0.124204 13.7518 0.0296573C13.4357 -0.0650771 13.0965 0.0729229 12.936 0.361157L5.91695 12.9653C5.79568 13.1831 5.79878 13.4487 5.92506 13.6636C6.05134 13.8785 6.28201 14.0105 6.53124 14.0105H11.6762L10.9983 23.2453C10.9742 23.5743 11.182 23.8758 11.4981 23.9704C11.8167 24.0658 12.1548 23.9246 12.3139 23.6389L19.3329 11.0348C19.4541 10.817 19.451 10.5513 19.3247 10.3364Z" fill="#F2C31C"/>
                                            </g>
                                            <defs>
                                            <clipPath id="clip0_4355_16088">
                                            <rect width="24" height="24" fill="white" transform="translate(0.625)"/>
                                            </clipPath>
                                            </defs>
                                        </svg>
                                    </div>
                                  Lembur
                              </a> 
                          </li>

                          <li>
                              <a href="<?php echo e(url('/request-location')); ?>">
                                <div class="icon-box bg_color_5">
                                    <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_4355_16445)">
                                        <path d="M12.9209 20.7275C18.6446 20.7275 23.2846 16.0875 23.2846 10.3637C23.2846 4.64 18.6446 0 12.9209 0C7.19713 0 2.55713 4.64 2.55713 10.3637C2.55713 16.0875 7.19713 20.7275 12.9209 20.7275Z" fill="#F57C04"/>
                                        <path d="M12.9204 19.6363C18.0415 19.6363 22.1929 15.4848 22.1929 10.3638C22.1929 5.24274 18.0415 1.09131 12.9204 1.09131C7.79938 1.09131 3.64795 5.24274 3.64795 10.3638C3.64795 15.4848 7.79938 19.6363 12.9204 19.6363Z" fill="#F55600"/>
                                        <path d="M10.7389 18.5456C15.2575 18.5456 18.9206 14.8825 18.9206 10.3639C18.9206 5.84522 15.2575 2.18213 10.7389 2.18213C6.22022 2.18213 2.55713 5.84522 2.55713 10.3639C2.55713 14.8825 6.22022 18.5456 10.7389 18.5456Z" fill="#744EC1"/>
                                        <path d="M10.7385 17.4545C14.6548 17.4545 17.8295 14.2797 17.8295 10.3635C17.8295 6.44722 14.6548 3.27246 10.7385 3.27246C6.82222 3.27246 3.64746 6.44722 3.64746 10.3635C3.64746 14.2797 6.82222 17.4545 10.7385 17.4545Z" fill="#653BBA"/>
                                        <path d="M10.7386 15.2727C13.4498 15.2727 15.6477 13.0748 15.6477 10.3636C15.6477 7.65245 13.4498 5.45459 10.7386 5.45459C8.02745 5.45459 5.82959 7.65245 5.82959 10.3636C5.82959 13.0748 8.02745 15.2727 10.7386 15.2727Z" fill="#5628B4"/>
                                        <path d="M10.7388 13.0909C12.2449 13.0909 13.4659 11.8699 13.4659 10.3638C13.4659 8.85767 12.2449 7.63672 10.7388 7.63672C9.23267 7.63672 8.01172 8.85767 8.01172 10.3638C8.01172 11.8699 9.23267 13.0909 10.7388 13.0909Z" fill="#3E0AA9"/>
                                        <path d="M10.7385 2.18194C9.23226 2.18194 8.01123 3.40297 8.01123 4.90918C8.01123 6.41539 9.23226 7.63641 10.7385 7.63641H10.7432H10.7449H10.7479H10.7499H10.7526H10.7547H10.7573H10.7595H10.762H10.7643H10.7667H10.769H10.7713L10.7737 7.63636H10.7752L10.7815 7.63626H10.7828L10.7859 7.63621L10.7874 7.63616L10.7903 7.63611L10.7921 7.63605L10.795 7.636L10.7966 7.63595L10.7997 7.6359L10.8011 7.63585L10.8043 7.63575H10.8054L10.8089 7.63565H10.8092C10.8148 7.63549 10.8204 7.63534 10.8259 7.63519H10.8267L10.8302 7.63508L10.8313 7.63503L10.8347 7.63493L10.8358 7.63488L10.8392 7.63478L10.8403 7.63473L10.8436 7.63462L10.8448 7.63457L10.8483 7.63442H10.8485C10.8522 7.63426 10.856 7.63411 10.8597 7.63396L10.8618 7.63386L10.8639 7.63375L10.8666 7.63365L10.8684 7.63355L10.8716 7.6334L10.8729 7.63334L10.8766 7.63314L10.8774 7.63309C10.8838 7.63278 10.8903 7.63242 10.8967 7.63207C11.1975 7.61488 11.4274 7.35711 11.4101 7.05633C11.3936 6.76782 11.155 6.54226 10.866 6.542C10.8556 6.542 10.845 6.54231 10.8344 6.54292C10.8027 6.54476 10.7707 6.54563 10.7385 6.54568C9.83479 6.54568 9.10217 5.81306 9.10217 4.90933C9.10217 4.00561 9.83479 3.27298 10.7385 3.27298C11.0374 3.31062 11.3107 3.09452 11.3484 2.79563C11.386 2.49674 11.1742 2.22398 10.8753 2.18634C10.83 2.18051 10.7842 2.18051 10.7385 2.18194Z" fill="#3E0AA9"/>
                                        <path d="M7.53387 12.0493C6.02767 12.0493 4.80664 13.2703 4.80664 14.7766C4.80664 16.2828 6.02767 17.5038 7.53387 17.5038H7.53858H7.54027H7.54328H7.54533H7.54804H7.55009H7.55274H7.55494H7.5574H7.5597H7.5621H7.56445H7.5667L7.56916 17.5037H7.57064L7.57693 17.5036H7.57821L7.58128 17.5036L7.58281 17.5035L7.58573 17.5035L7.58747 17.5034L7.59043 17.5034L7.59197 17.5033L7.59514 17.5033L7.59647 17.5032L7.59974 17.5031H7.60081L7.60434 17.503H7.6046C7.61017 17.5029 7.61579 17.5027 7.62132 17.5026H7.62208L7.62561 17.5025L7.62669 17.5024L7.63006 17.5023L7.63119 17.5023L7.63456 17.5021L7.63574 17.5021L7.63901 17.502L7.64019 17.5019L7.64366 17.5018H7.64392C7.64765 17.5016 7.65139 17.5015 7.65512 17.5013L7.65716 17.5012L7.65926 17.5011L7.66197 17.501L7.66376 17.5009L7.66698 17.5008L7.66826 17.5007L7.67199 17.5005L7.67281 17.5005C7.67925 17.5002 7.6857 17.4998 7.69214 17.4994C7.99292 17.4823 8.22278 17.2245 8.20555 16.9238C8.18903 16.6352 7.95043 16.4097 7.66146 16.4094C7.65098 16.4094 7.64044 16.4097 7.62986 16.4103C7.5981 16.4122 7.56609 16.4131 7.53393 16.4131C6.6302 16.4131 5.89758 15.6805 5.89758 14.7768C5.89758 13.873 6.6302 13.1404 7.53393 13.1404C7.83517 13.1404 8.07939 12.8962 8.07939 12.5949C8.07934 12.2935 7.83512 12.0493 7.53387 12.0493Z" fill="#3E0AA9"/>
                                        <path d="M5.55145 5.95068C4.04524 5.95068 2.82422 7.17171 2.82422 8.67792C2.82422 10.1841 4.04524 11.4052 5.55145 11.4052H5.55616H5.55785H5.56086H5.56291H5.56562H5.56766H5.57032H5.57252H5.57498H5.57728H5.57968H5.58203H5.58428L5.58674 11.4051H5.58822L5.59451 11.405H5.59579L5.59886 11.4049L5.60039 11.4049L5.60331 11.4048L5.60504 11.4048L5.60801 11.4047L5.60954 11.4047L5.61271 11.4046L5.61404 11.4046L5.61732 11.4045H5.61839L5.62192 11.4044H5.62217C5.62775 11.4042 5.63337 11.4041 5.6389 11.4039H5.63966L5.64319 11.4038L5.64426 11.4038L5.64764 11.4037L5.64877 11.4036L5.65214 11.4035L5.65332 11.4035L5.65659 11.4034L5.65776 11.4033L5.66124 11.4032H5.6615C5.66523 11.403 5.66896 11.4029 5.6727 11.4027L5.67474 11.4026L5.67684 11.4025L5.67955 11.4024L5.68134 11.4023L5.68456 11.4021L5.68584 11.4021L5.68957 11.4019L5.69039 11.4018C5.69683 11.4015 5.70328 11.4012 5.70972 11.4008C6.0105 11.3836 6.24036 11.1258 6.22312 10.8251C6.20661 10.5366 5.96801 10.311 5.67904 10.3107C5.66855 10.3107 5.65802 10.311 5.64744 10.3117C5.61568 10.3135 5.58367 10.3144 5.5515 10.3144C4.64778 10.3144 3.91515 9.5818 3.91515 8.67807C3.91515 7.77435 4.64778 7.04172 5.5515 7.04172C5.85275 7.04203 6.09723 6.79811 6.09753 6.49682C6.09784 6.19552 5.85392 5.95109 5.55263 5.95079C5.55217 5.95068 5.55181 5.95068 5.55145 5.95068Z" fill="#3E0AA9"/>
                                        <path d="M15.9255 5.95068C14.4193 5.95068 13.1982 7.17171 13.1982 8.67792C13.1982 10.1841 14.4193 11.4052 15.9255 11.4052H15.9302H15.9319H15.9349H15.9369H15.9396H15.9417H15.9443H15.9465H15.949H15.9513H15.9537H15.9561H15.9583L15.9608 11.4051H15.9622L15.9685 11.405H15.9698L15.9729 11.4049L15.9744 11.4049L15.9773 11.4048L15.9791 11.4048L15.982 11.4047L15.9836 11.4047L15.9867 11.4046L15.9881 11.4046L15.9913 11.4045H15.9924L15.9959 11.4044H15.9962C16.0018 11.4042 16.0074 11.4041 16.0129 11.4039H16.0137L16.0172 11.4038L16.0183 11.4038L16.0217 11.4037L16.0228 11.4036L16.0262 11.4035L16.0273 11.4035L16.0306 11.4034L16.0318 11.4033L16.0353 11.4032H16.0355C16.0393 11.403 16.043 11.4029 16.0467 11.4027L16.0488 11.4026L16.0509 11.4025L16.0536 11.4024L16.0553 11.4023L16.0585 11.4021L16.0598 11.4021L16.0635 11.4019L16.0644 11.4018C16.0708 11.4015 16.0772 11.4012 16.0837 11.4008C16.3845 11.3836 16.6143 11.1258 16.5971 10.8251C16.5806 10.5366 16.342 10.311 16.053 10.3107C16.0425 10.3107 16.032 10.311 16.0214 10.3117C15.9897 10.3135 15.9576 10.3144 15.9255 10.3144C15.0218 10.3144 14.2891 9.5818 14.2891 8.67807C14.2891 7.77435 15.0218 7.04172 15.9255 7.04172C16.2267 7.04203 16.4712 6.79811 16.4715 6.49682C16.4718 6.19557 16.2279 5.95109 15.9266 5.95079C15.9262 5.95068 15.9259 5.95068 15.9255 5.95068Z" fill="#3E0AA9"/>
                                        <path d="M13.9455 12.0493C12.4393 12.0493 11.2183 13.2703 11.2183 14.7766C11.2183 16.2828 12.4393 17.5038 13.9455 17.5038H13.9502H13.9519H13.9549H13.957H13.9597H13.9617H13.9644H13.9666H13.969H13.9713H13.9737H13.9761H13.9783L13.9808 17.5037H13.9823L13.9886 17.5036H13.9898L13.9929 17.5036L13.9944 17.5035L13.9973 17.5035L13.9991 17.5034L14.0021 17.5034L14.0036 17.5033L14.0068 17.5033L14.0081 17.5032L14.0114 17.5031H14.0124L14.016 17.503H14.0162C14.0218 17.5029 14.0274 17.5027 14.0329 17.5026H14.0337L14.0372 17.5025L14.0383 17.5024L14.0417 17.5023L14.0428 17.5023L14.0462 17.5021L14.0474 17.5021L14.0506 17.502L14.0518 17.5019L14.0553 17.5018H14.0555C14.0593 17.5016 14.063 17.5015 14.0667 17.5013L14.0688 17.5012L14.0709 17.5011L14.0736 17.501L14.0753 17.5009L14.0786 17.5008L14.0798 17.5007L14.0836 17.5005L14.0844 17.5005C14.0908 17.5002 14.0973 17.4998 14.1037 17.4994C14.4045 17.4823 14.6343 17.2245 14.6171 16.9238C14.6006 16.6352 14.362 16.4097 14.073 16.4094C14.0625 16.4094 14.052 16.4097 14.0414 16.4103C14.0097 16.4122 13.9777 16.4131 13.9455 16.4131C13.0418 16.4131 12.3091 15.6805 12.3091 14.7768C12.3091 13.873 13.0418 13.1404 13.9455 13.1404C14.2467 13.1404 14.491 12.8962 14.491 12.5949C14.491 12.2935 14.2467 12.0493 13.9455 12.0493Z" fill="#3E0AA9"/>
                                        <path d="M21.1023 10.9092V16.3637C21.1023 18.1712 22.5675 19.6364 24.375 19.6364V24C20.7601 24 17.8296 21.0695 17.8296 17.4546V10.9092H21.1023Z" fill="#5628B4"/>
                                        <path d="M10.7386 0C5.01492 0 0.375 4.63992 0.375 10.3636C0.375 16.0872 5.01492 20.7271 10.7386 20.7271C16.4622 20.7271 21.1021 16.0872 21.1021 10.3636C21.1021 4.63992 16.4622 0 10.7386 0ZM10.7386 2.18182C12.2448 2.18182 13.4658 3.40284 13.4658 4.90905C13.4658 6.41526 12.2448 7.63629 10.7386 7.63629C9.23236 7.63629 8.01134 6.41526 8.01134 4.90905C8.01134 3.40284 9.23231 2.18182 10.7385 2.18182C10.7385 2.18182 10.7385 2.18182 10.7386 2.18182ZM2.95721 7.83526C3.42265 6.40273 4.96123 5.61877 6.39375 6.08421C7.82628 6.54965 8.61024 8.08823 8.1448 9.52075C7.67936 10.9533 6.14078 11.7372 4.70826 11.2718H4.70821C3.27574 10.8064 2.49182 9.26778 2.95721 7.83526ZM9.73886 16.3794C8.85355 17.5979 7.14801 17.8681 5.92944 16.9827C4.71087 16.0973 4.44072 14.3919 5.32604 13.1733C6.21135 11.9547 7.91689 11.6846 9.13546 12.5699C10.354 13.4553 10.6242 15.1608 9.73886 16.3794ZM9.10222 10.3636C9.10222 9.45985 9.83485 8.72722 10.7386 8.72722C11.6423 8.72722 12.3749 9.45985 12.3749 10.3636C12.3749 11.2673 11.6423 11.9999 10.7386 11.9999C9.83485 11.9999 9.10222 11.2673 9.10222 10.3636ZM15.5477 16.9828C14.3291 17.8681 12.6235 17.5979 11.7382 16.3794C10.8529 15.1608 11.1231 13.4553 12.3416 12.57C13.5601 11.6847 15.2657 11.9548 16.151 13.1733C17.0363 14.3919 16.7662 16.0974 15.5477 16.9828ZM16.7689 11.2717C15.3364 11.7372 13.7978 10.9532 13.3323 9.52075C12.8669 8.08828 13.6509 6.5497 15.0833 6.08421C16.5158 5.61872 18.0544 6.40273 18.5199 7.83521C18.9853 9.26778 18.2014 10.8063 16.7689 11.2717Z" fill="#F7B236"/>
                                        <path d="M10.7386 0C5.01492 0 0.375 4.63992 0.375 10.3636C0.375 16.0872 5.01492 20.7271 10.7386 20.7271C16.4622 20.7271 21.1021 16.0872 21.1021 10.3636C21.1021 4.63992 16.4622 0 10.7386 0ZM10.7386 2.18182C12.2448 2.18182 13.4658 3.40284 13.4658 4.90905C13.4658 6.41526 12.2448 7.63629 10.7386 7.63629C9.23236 7.63629 8.01134 6.41526 8.01134 4.90905C8.01134 3.40284 9.23231 2.18182 10.7385 2.18182C10.7385 2.18182 10.7385 2.18182 10.7386 2.18182ZM2.95721 7.83526C3.42265 6.40273 4.96123 5.61877 6.39375 6.08421C7.82628 6.54965 8.61024 8.08823 8.1448 9.52075C7.67936 10.9533 6.14078 11.7372 4.70826 11.2718H4.70821C3.27574 10.8064 2.49182 9.26778 2.95721 7.83526ZM9.73886 16.3794C8.85355 17.5979 7.14801 17.8681 5.92944 16.9827C4.71087 16.0973 4.44072 14.3919 5.32604 13.1733C6.21135 11.9547 7.91689 11.6846 9.13546 12.5699C10.354 13.4553 10.6242 15.1608 9.73886 16.3794ZM9.10222 10.3636C9.10222 9.45985 9.83485 8.72722 10.7386 8.72722C11.6423 8.72722 12.3749 9.45985 12.3749 10.3636C12.3749 11.2673 11.6423 11.9999 10.7386 11.9999C9.83485 11.9999 9.10222 11.2673 9.10222 10.3636ZM15.5477 16.9828C14.3291 17.8681 12.6235 17.5979 11.7382 16.3794C10.8529 15.1608 11.1231 13.4553 12.3416 12.57C13.5601 11.6847 15.2657 11.9548 16.151 13.1733C17.0363 14.3919 16.7662 16.0974 15.5477 16.9828ZM16.7689 11.2717C15.3364 11.7372 13.7978 10.9532 13.3323 9.52075C12.8669 8.08828 13.6509 6.5497 15.0833 6.08421C16.5158 5.61872 18.0544 6.40273 18.5199 7.83521C18.9853 9.26778 18.2014 10.8063 16.7689 11.2717Z" fill="#F7B236"/>
                                        <path d="M10.7385 1.09131C5.61729 1.09131 1.46582 5.24283 1.46582 10.3639C1.46582 15.4851 5.61734 19.6366 10.7385 19.6366C15.8596 19.6366 20.0111 15.4851 20.0111 10.3639C20.0111 5.24278 15.8596 1.09131 10.7385 1.09131ZM10.7385 2.18219C12.2447 2.18219 13.4657 3.40322 13.4657 4.90943C13.4657 6.41564 12.2447 7.63666 10.7385 7.63666C9.23225 7.63666 8.01122 6.41564 8.01122 4.90943C8.01122 3.40322 9.2322 2.18219 10.7384 2.18219C10.7384 2.18219 10.7384 2.18219 10.7385 2.18219ZM2.9571 7.83563C3.42254 6.40311 4.96112 5.61914 6.39364 6.08458C7.82616 6.55002 8.61013 8.0886 8.14469 9.52112C7.67925 10.9536 6.14067 11.7376 4.70815 11.2722H4.7081C3.27562 10.8067 2.49171 9.26815 2.9571 7.83563ZM9.73875 16.3797C8.85343 17.5983 7.1479 17.8685 5.92933 16.9831C4.71076 16.0977 4.4406 14.3922 5.32592 13.1737C6.21124 11.9551 7.91678 11.6849 9.13535 12.5703C10.3539 13.4557 10.6241 15.1612 9.73875 16.3797ZM9.10211 10.3639C9.10211 9.46022 9.83473 8.7276 10.7385 8.7276C11.6422 8.7276 12.3748 9.46022 12.3748 10.3639C12.3748 11.2677 11.6422 12.0003 10.7385 12.0003C9.83473 12.0003 9.10211 11.2677 9.10211 10.3639ZM15.5475 16.9831C14.329 17.8685 12.6234 17.5983 11.7381 16.3798C10.8528 15.1612 11.1229 13.4557 12.3415 12.5704C13.56 11.685 15.2656 11.9552 16.1509 13.1737C17.0362 14.3923 16.7661 16.0978 15.5475 16.9831ZM16.7688 11.2721C15.3363 11.7376 13.7977 10.9536 13.3322 9.52112C12.8668 8.08865 13.6508 6.55007 15.0832 6.08458C16.5157 5.61909 18.0543 6.40311 18.5198 7.83558C18.9852 9.26815 18.2012 10.8067 16.7688 11.2721Z" fill="#F9C15D"/>
                                        <path d="M10.7386 0H10.7304H10.729H10.722H10.7212H10.7136H10.713H10.7057H10.704H10.6985H10.6943H10.6927C10.6879 0 10.6831 5.1136e-05 10.6784 5.1136e-05H10.677H10.6728C10.0704 0.00649427 9.58722 0.50011 9.59367 1.10254C9.60006 1.70165 10.0885 2.18345 10.6876 2.18177H10.6907L10.7385 2.18161C15.2499 2.18161 18.9203 5.85195 18.9203 10.3634C18.9203 14.8748 15.2499 18.5451 10.7385 18.5451C9.64593 18.5475 8.56415 18.3296 7.55769 17.9044C7.00281 17.6697 6.36269 17.9292 6.12798 18.4841C5.89326 19.039 6.15278 19.6791 6.70766 19.9138C6.70796 19.914 6.70832 19.9141 6.70863 19.9142C6.86342 19.9796 7.0201 20.0413 7.17872 20.0993L7.17898 20.0995L7.18624 20.1021L7.18629 20.1022L7.1935 20.1048L7.19391 20.1049L7.20102 20.1075L7.20122 20.1076L7.20838 20.1102L7.20874 20.1103L7.21595 20.1129H7.216L7.22336 20.1156L7.22352 20.1157C7.22602 20.1166 7.22837 20.1174 7.23088 20.1183H7.23093L7.23814 20.1209L7.2386 20.1211L7.24561 20.1236L7.24602 20.1237L7.25302 20.1262L7.25353 20.1264L7.26054 20.129L7.26095 20.1291L7.26785 20.1316L7.26867 20.1319L7.27532 20.1342L7.27608 20.1345C7.27823 20.1352 7.28058 20.1361 7.28278 20.1368L7.2836 20.1371L7.29025 20.1395L7.29102 20.1397L7.29756 20.142L7.29874 20.1425L7.30503 20.1447L7.30615 20.1451L7.31249 20.1473L7.31367 20.1477L7.32001 20.1499L7.32108 20.1502L7.32732 20.1524L7.3287 20.1529L7.33484 20.155L7.33612 20.1555L7.34236 20.1576L7.34363 20.1581L7.34987 20.1603L7.35105 20.1607L7.35729 20.1628L7.35872 20.1633L7.36475 20.1654L7.36613 20.1659L7.37217 20.168L7.37375 20.1685L7.37974 20.1706L7.38117 20.171L7.3872 20.1731L7.38874 20.1736L7.39467 20.1756L7.39625 20.1762L7.40213 20.1781L7.40387 20.1788L7.40965 20.1807L7.41134 20.1813L7.41712 20.1832L7.41906 20.1839L7.42458 20.1857L7.42653 20.1864L7.4321 20.1883L7.43399 20.1889L7.43967 20.1908L7.44146 20.1914L7.44708 20.1933L7.44918 20.194L7.45465 20.1958L7.4567 20.1965L7.46212 20.1983L7.46437 20.199L7.46968 20.2008L7.47183 20.2015L7.4772 20.2033L7.4794 20.204L7.48472 20.2057L7.48697 20.2065L7.49229 20.2082L7.49454 20.209L7.49991 20.2108L7.50195 20.2114L7.50747 20.2132L7.50957 20.2139L7.51504 20.2157L7.51709 20.2163L7.52251 20.2181L7.52471 20.2189L7.53018 20.2206L7.53212 20.2213L7.53754 20.223L7.54 20.2238L7.54506 20.2254L7.54756 20.2263L7.55268 20.2279L7.55518 20.2287L7.56025 20.2304L7.5627 20.2312L7.56781 20.2328L7.57032 20.2336L7.57543 20.2353L7.57768 20.236L7.583 20.2377L7.58541 20.2384L7.59062 20.2401L7.59297 20.2408L7.59809 20.2425L7.6009 20.2434L7.6056 20.2449L7.60836 20.2458L7.61322 20.2473L7.61598 20.2482L7.62089 20.2497L7.62345 20.2505L7.62841 20.2521L7.63112 20.253L7.63603 20.2545L7.63864 20.2553L7.64355 20.2568L7.64631 20.2577L7.65117 20.2593L7.65382 20.2601L7.65868 20.2616L7.66165 20.2625L7.66625 20.264L7.66917 20.2648L7.67377 20.2663L7.67689 20.2672L7.68144 20.2686L7.68435 20.2695L7.68906 20.271L7.69218 20.2719L7.69657 20.2733L7.6998 20.2743L7.70424 20.2756L7.70747 20.2766L7.71192 20.2779L7.71504 20.2788L7.71953 20.2802L7.72281 20.2812L7.72715 20.2826L7.73032 20.2835L7.73477 20.2849L7.73805 20.2858L7.74239 20.2872L7.74551 20.2881L7.75001 20.2895L7.75328 20.2904L7.75768 20.2918L7.7608 20.2927L7.76535 20.294L7.76847 20.2949L7.77302 20.2963L7.77609 20.2972L7.78054 20.2985L7.78392 20.2995L7.78821 20.3008L7.79148 20.3018L7.79578 20.3031L7.79926 20.3041L7.8035 20.3053L7.80677 20.3063L7.81112 20.3076L7.81449 20.3085L7.81874 20.3098L7.82211 20.3107L7.82641 20.312L7.82978 20.313L7.83413 20.3142L7.83735 20.3151L7.8417 20.3164L7.84523 20.3174L7.84937 20.3186L7.85279 20.3196L7.85694 20.3209L7.86057 20.3219L7.86466 20.3231L7.86803 20.324L7.87233 20.3253L7.87581 20.3262L7.88 20.3274L7.88348 20.3284L7.88762 20.3296L7.89125 20.3306L7.89534 20.3318L7.89872 20.3328L7.90296 20.334L7.90654 20.335L7.91058 20.3362L7.91416 20.3372L7.9183 20.3384L7.92178 20.3393L7.92602 20.3405L7.9294 20.3415L7.93364 20.3427L7.93722 20.3437L7.94126 20.3448L7.94489 20.3458L7.94898 20.3469L7.95261 20.348L7.95665 20.3491L7.96018 20.3501L7.96437 20.3512L7.96806 20.3523L7.97199 20.3533L7.97562 20.3544L7.97982 20.3555L7.98329 20.3565L7.98754 20.3577L7.99096 20.3586L7.99521 20.3598L7.99884 20.3608L8.00288 20.3619L8.00656 20.3629L8.0106 20.364L8.01428 20.3651L8.01832 20.3662L8.0219 20.3671L8.02604 20.3683L8.02973 20.3692L8.03376 20.3704L8.03729 20.3713L8.04149 20.3725L8.04507 20.3734L8.04921 20.3746L8.05279 20.3755L8.05683 20.3766L8.06071 20.3776L8.06455 20.3787L8.06844 20.3797L8.07227 20.3807L8.07616 20.3817L8.08009 20.3828L8.08367 20.3837L8.08782 20.3848L8.0915 20.3858L8.09559 20.3869L8.09917 20.3878L8.10326 20.3889L8.10704 20.3899L8.11103 20.3909L8.11471 20.3919L8.1187 20.3929L8.12264 20.3939L8.12642 20.3949L8.13026 20.3959L8.13425 20.397L8.13803 20.3979L8.14197 20.399L8.14575 20.3999L8.14969 20.4009L8.15373 20.402L8.15741 20.4029L8.16145 20.4039L8.16524 20.4049L8.16933 20.406L8.17296 20.4069L8.17705 20.4079L8.18073 20.4088L8.18492 20.4099L8.1885 20.4108L8.19264 20.4119L8.19628 20.4128L8.20047 20.4139L8.20405 20.4148L8.20814 20.4158L8.21182 20.4167L8.21606 20.4178L8.21954 20.4187L8.22374 20.4198L8.22737 20.4207L8.23151 20.4217L8.23524 20.4226L8.23918 20.4236L8.24301 20.4245L8.2471 20.4255L8.25079 20.4265L8.25483 20.4274L8.25861 20.4284L8.26255 20.4293L8.26648 20.4303L8.27027 20.4312L8.2741 20.4321L8.2786 20.4332L8.28177 20.434L8.28633 20.4351L8.2896 20.4359L8.29405 20.437L8.29747 20.4378L8.30172 20.4388L8.30519 20.4397L8.3098 20.4408L8.31297 20.4416L8.31742 20.4427L8.32079 20.4435L8.32524 20.4446L8.32862 20.4454L8.33286 20.4464L8.33644 20.4473L8.34084 20.4483L8.34421 20.4491L8.34856 20.4501L8.35214 20.451L8.35643 20.452L8.35991 20.4528L8.36415 20.4538L8.36779 20.4546L8.37198 20.4556L8.37566 20.4565L8.3796 20.4574L8.38348 20.4583L8.38757 20.4593L8.39126 20.4602L8.39535 20.4611L8.39903 20.462L8.40348 20.463L8.40685 20.4637L8.4111 20.4647L8.41468 20.4655L8.41897 20.4665L8.42255 20.4673L8.4268 20.4683L8.43027 20.4691L8.43488 20.4701L8.4381 20.4709L8.44255 20.4719L8.44602 20.4726L8.45052 20.4737L8.45385 20.4744L8.4583 20.4755L8.46167 20.4762L8.46632 20.4772L8.46949 20.478L8.4741 20.479L8.47737 20.4797L8.48207 20.4808L8.48519 20.4815L8.48974 20.4825L8.49302 20.4832L8.49767 20.4842L8.50089 20.485L8.50544 20.4859L8.50877 20.4867L8.51337 20.4877L8.51659 20.4884L8.52109 20.4894L8.52447 20.4901L8.52917 20.4911L8.53229 20.4918L8.53694 20.4928L8.54022 20.4935L8.54477 20.4945L8.54814 20.4952L8.55249 20.4961L8.55602 20.4969L8.56052 20.4979L8.56384 20.4986L8.56829 20.4995L8.57177 20.5003L8.57622 20.5012L8.57964 20.5019L8.58399 20.5029L8.58757 20.5036L8.59202 20.5045L8.59544 20.5053L8.59984 20.5062L8.60337 20.507L8.60777 20.5079L8.61124 20.5086L8.61559 20.5095L8.61922 20.5103L8.62352 20.5112L8.6271 20.5119L8.63124 20.5128L8.63502 20.5135L8.63922 20.5144L8.6429 20.5152L8.64709 20.5161L8.65077 20.5168L8.65532 20.5177L8.6586 20.5184L8.6632 20.5193L8.66647 20.52L8.67107 20.5209L8.6744 20.5216L8.67885 20.5224L8.68232 20.5232L8.68682 20.5241L8.69025 20.5247L8.69475 20.5257L8.69812 20.5263L8.70278 20.5273L8.70605 20.5279L8.7105 20.5288L8.71398 20.5295L8.71858 20.5304L8.72185 20.5311L8.7263 20.532L8.72983 20.5326L8.73423 20.5335L8.73775 20.5342L8.7421 20.535L8.74563 20.5357L8.75013 20.5366L8.75361 20.5373L8.75795 20.5381L8.76153 20.5388L8.76593 20.5397L8.76941 20.5403L8.77375 20.5412L8.77733 20.5418L8.78168 20.5426L8.78531 20.5433L8.78945 20.5441L8.79329 20.5448L8.79753 20.5457L8.80121 20.5464L8.80541 20.5472L8.80914 20.5479L8.81349 20.5487L8.81707 20.5494L8.82131 20.5502L8.82509 20.5509L8.82924 20.5517L8.83307 20.5524L8.83716 20.5532L8.84095 20.5539L8.84529 20.5547L8.84892 20.5554L8.85322 20.5562L8.85685 20.5569L8.8614 20.5577L8.86478 20.5583L8.86928 20.5591L8.8728 20.5598L8.87715 20.5606L8.88073 20.5613L8.88518 20.5621L8.88866 20.5627L8.89331 20.5635L8.89663 20.5641L8.90113 20.5649L8.90461 20.5656L8.90916 20.5664L8.91264 20.567L8.91704 20.5678L8.92062 20.5684L8.92501 20.5691L8.92859 20.5697L8.93294 20.5705L8.93652 20.5711L8.94107 20.5719L8.9445 20.5726L8.94884 20.5733L8.95258 20.574L8.95682 20.5748L8.9605 20.5754L8.96485 20.5761L8.96848 20.5768L8.97303 20.5775L8.97651 20.5781L8.98091 20.5789L8.98454 20.5795L8.98893 20.5803L8.99251 20.5809L8.99706 20.5817L9.00044 20.5822L9.00525 20.583L9.00842 20.5836L9.01307 20.5843L9.01645 20.5849L9.02105 20.5857L9.02442 20.5862L9.02897 20.587L9.03245 20.5875L9.037 20.5883L9.04048 20.5889L9.04498 20.5896L9.04846 20.5902L9.05306 20.591L9.05643 20.5915L9.06098 20.5923L9.06441 20.5929L9.06927 20.5936L9.07239 20.5941L9.07725 20.5949L9.08036 20.5954L9.08563 20.5962L9.08829 20.5966L9.09346 20.5975L9.09637 20.5979L9.10159 20.5987L9.10435 20.5992L9.10972 20.6001L9.11238 20.6005L9.11785 20.6014L9.1204 20.6018L9.12542 20.6025L9.12864 20.603L9.13329 20.6038L9.13667 20.6043L9.14122 20.605L9.14475 20.6055L9.14914 20.6062L9.15282 20.6068L9.15717 20.6074L9.16085 20.608L9.1654 20.6087L9.16898 20.6092L9.17323 20.6099L9.17701 20.6105L9.18146 20.6111L9.18504 20.6117L9.18949 20.6123L9.19302 20.6129L9.19788 20.6136L9.20105 20.614L9.2057 20.6147L9.20912 20.6153L9.21373 20.6159L9.2172 20.6164L9.22165 20.6171L9.22534 20.6177L9.22983 20.6183L9.23336 20.6188L9.23781 20.6195L9.24149 20.62L9.2461 20.6207L9.24952 20.6212L9.25397 20.6219L9.2576 20.6224L9.26215 20.623L9.26568 20.6235L9.27008 20.6242L9.27376 20.6247L9.27831 20.6253L9.28179 20.6258L9.28629 20.6265L9.28987 20.627L9.29457 20.6276L9.29795 20.6281L9.30265 20.6288L9.30603 20.6292L9.31073 20.6299L9.31411 20.6303L9.31851 20.631L9.32219 20.6315L9.32664 20.6321L9.33027 20.6326L9.33461 20.6332L9.3384 20.6337L9.34274 20.6342L9.34648 20.6347L9.35072 20.6353L9.35461 20.6358L9.3589 20.6364L9.36274 20.6369L9.36678 20.6374L9.37082 20.6379L9.37501 20.6385L9.37895 20.639L9.38299 20.6395L9.38703 20.64L9.39127 20.6406L9.39511 20.6411L9.39925 20.6416L9.40319 20.6421L9.40743 20.6427L9.41127 20.6432L9.41556 20.6437L9.41935 20.6442L9.42385 20.6448L9.42742 20.6452L9.43177 20.6458L9.43556 20.6462L9.4399 20.6468L9.44369 20.6473L9.44803 20.6478L9.45182 20.6482L9.45616 20.6488L9.45995 20.6492L9.46414 20.6497L9.46803 20.6502L9.47258 20.6507L9.47611 20.6512L9.48071 20.6517L9.48419 20.6521L9.48899 20.6527L9.49226 20.6531L9.49707 20.6537L9.50034 20.6541L9.5052 20.6546L9.50848 20.655L9.51308 20.6556L9.51661 20.656L9.52116 20.6565L9.52479 20.6569L9.52939 20.6574L9.53276 20.6578L9.53773 20.6584L9.54095 20.6587L9.54555 20.6592L9.54913 20.6596L9.55373 20.6602L9.55726 20.6606L9.56171 20.6611L9.56544 20.6615L9.56984 20.662L9.57362 20.6624L9.57797 20.6629L9.58175 20.6633L9.58615 20.6638L9.58993 20.6642L9.59428 20.6647L9.59807 20.6651L9.60231 20.6656L9.60625 20.666L9.61034 20.6664L9.61438 20.6669L9.61862 20.6674L9.62251 20.6678L9.62665 20.6682L9.63069 20.6686L9.63493 20.6691L9.63882 20.6695L9.64306 20.67L9.647 20.6704L9.6513 20.6708L9.65518 20.6713L9.65938 20.6717L9.66337 20.6721L9.66761 20.6725L9.6715 20.6729L9.67584 20.6734L9.67963 20.6738L9.68413 20.6742L9.68781 20.6746L9.69216 20.675L9.69604 20.6754L9.70039 20.6758L9.70422 20.6762L9.70852 20.6766L9.71241 20.677L9.7167 20.6774L9.72059 20.6777L9.72483 20.6782L9.72877 20.6786L9.73306 20.679L9.73695 20.6793L9.74109 20.6797L9.74513 20.6801L9.74938 20.6805L9.75331 20.6809L9.75756 20.6813L9.7615 20.6816L9.76564 20.682L9.76968 20.6824L9.77382 20.6828L9.77786 20.6832L9.782 20.6836L9.78604 20.6839L9.79003 20.6843L9.79417 20.6847L9.79842 20.685L9.8023 20.6854L9.8067 20.6858L9.81048 20.6861L9.81498 20.6865L9.81867 20.6868L9.82322 20.6873L9.8269 20.6876L9.83135 20.6879L9.83513 20.6883L9.83927 20.6886L9.84331 20.689L9.8473 20.6894L9.85155 20.6897L9.85538 20.69L9.85973 20.6904L9.86382 20.6907L9.86786 20.6911L9.87205 20.6915L9.87609 20.6918L9.88064 20.6921L9.88427 20.6924L9.88898 20.6928L9.89246 20.6931L9.89711 20.6934L9.90069 20.6938L9.90524 20.6941L9.90887 20.6944L9.91347 20.6948L9.91705 20.695L9.9216 20.6954L9.92528 20.6957L9.92953 20.696L9.93352 20.6963L9.93776 20.6966L9.94165 20.6969L9.94686 20.6973L9.94978 20.6975L9.95479 20.6979L9.95806 20.6981L9.96266 20.6985L9.96624 20.6988L9.97044 20.6991L9.97458 20.6994L9.97852 20.6997L9.98276 20.7L9.98655 20.7002L9.99104 20.7006L9.99447 20.7008L9.99928 20.7012L10.0026 20.7014L10.0075 20.7017L10.0111 20.702L10.0157 20.7023L10.0191 20.7025L10.0239 20.7029L10.0272 20.7031L10.0322 20.7034L10.0351 20.7036L10.0404 20.704L10.0438 20.7042L10.0487 20.7045L10.052 20.7047L10.0569 20.705L10.0601 20.7052L10.0652 20.7055L10.0686 20.7057L10.0734 20.706L10.0774 20.7063L10.0816 20.7065L10.0857 20.7068L10.0898 20.707L10.0941 20.7073L10.0981 20.7076L10.102 20.7078L10.1064 20.7081L10.1103 20.7083L10.1146 20.7085L10.1181 20.7087L10.1229 20.709L10.1261 20.7092L10.1312 20.7096L10.1345 20.7098L10.1394 20.7101L10.1433 20.7103L10.1477 20.7105L10.1524 20.7108L10.1558 20.711L10.1609 20.7112L10.1641 20.7114L10.1684 20.7117L10.1725 20.7119L10.1763 20.7121L10.1808 20.7124L10.1843 20.7126L10.1891 20.7128L10.193 20.713L10.1973 20.7132L10.2014 20.7134L10.2056 20.7136L10.2094 20.7138L10.2139 20.714L10.2173 20.7142L10.2222 20.7144L10.2258 20.7146L10.2304 20.7148L10.2343 20.715L10.2387 20.7152L10.2428 20.7154L10.247 20.7156L10.2508 20.7158L10.2553 20.716L10.2586 20.7162L10.2636 20.7164L10.2667 20.7165L10.2718 20.7167L10.2755 20.7169L10.2801 20.7171L10.2835 20.7172L10.2884 20.7174L10.292 20.7176L10.2967 20.7178L10.3004 20.7179L10.305 20.7181L10.3093 20.7183L10.3133 20.7185L10.3177 20.7186L10.3215 20.7188L10.3258 20.7189L10.3299 20.7191L10.334 20.7192L10.3382 20.7194L10.3426 20.7195L10.3464 20.7197L10.3511 20.7198L10.3547 20.72L10.3589 20.7201L10.3631 20.7203L10.3666 20.7204L10.3713 20.7205L10.376 20.7207L10.3796 20.7208L10.3842 20.721L10.388 20.7211L10.3921 20.7213L10.3963 20.7214L10.4001 20.7215L10.4047 20.7217L10.408 20.7218L10.413 20.7219L10.4156 20.722L10.4213 20.7222L10.4242 20.7223L10.4296 20.7224L10.4332 20.7225L10.4379 20.7227L10.4418 20.7228L10.4463 20.7229L10.4505 20.723L10.4545 20.7231L10.4588 20.7232L10.4629 20.7233L10.4673 20.7234L10.4712 20.7235L10.4754 20.7236L10.4795 20.7237L10.4836 20.7238L10.4878 20.7239L10.493 20.724L10.4961 20.7241L10.502 20.7242L10.5044 20.7243L10.51 20.7244L10.5128 20.7244L10.5178 20.7245L10.5211 20.7246L10.5258 20.7247L10.5295 20.7247L10.5341 20.7248L10.5378 20.7249L10.5417 20.7249L10.5462 20.725L10.5493 20.7251L10.5545 20.7252L10.5579 20.7253L10.5629 20.7254L10.5659 20.7254L10.5712 20.7255L10.5753 20.7256L10.5796 20.7256L10.5835 20.7257L10.5879 20.7257L10.5921 20.7258L10.5962 20.7258L10.5998 20.7259L10.6046 20.7259L10.6077 20.726L10.613 20.726L10.6155 20.7261L10.6297 20.7262H10.6314L10.6381 20.7263H10.6396C10.6475 20.7263 10.6553 20.7264 10.6631 20.7265L10.6684 20.7265H10.6716H10.6754H10.6799H10.6824L10.6883 20.7266L10.701 20.7266C10.7134 20.7267 10.726 20.7267 10.7385 20.7267C16.4621 20.7267 21.1021 16.0868 21.1021 10.3631C21.1021 4.63946 16.4622 0 10.7386 0Z" fill="#F59500"/>
                                        <path d="M3.78559 3.13623C3.47458 3.13587 3.17835 3.26898 2.97212 3.5018L2.96849 3.50589L2.96787 3.50661C2.96475 3.51019 2.96158 3.51377 2.95841 3.51735C2.95713 3.51878 2.9555 3.52062 2.95427 3.5221L2.95355 3.52292L2.94941 3.52768L2.94839 3.5288L2.94609 3.53141C2.94302 3.53489 2.93995 3.53836 2.93693 3.54189C2.93244 3.54701 2.92783 3.55227 2.92333 3.55744C2.91801 3.56357 2.9128 3.56976 2.90763 3.576C2.90196 3.58224 2.89638 3.58853 2.89081 3.59497C2.61657 3.91258 2.36181 4.24655 2.12791 4.59499L2.12771 4.59529C2.10311 4.63201 2.07882 4.66862 2.05469 4.70565L2.05453 4.70585L2.05049 4.71199L2.05014 4.71255C2.0487 4.71475 2.04763 4.71633 2.04625 4.71853L2.04594 4.71899C2.04451 4.72119 2.04344 4.72283 2.04206 4.72497L2.0417 4.72554C2.03321 4.73863 2.02498 4.75136 2.01649 4.7645L2.01623 4.76496C2.0148 4.76716 2.01378 4.7688 2.01235 4.771L2.01199 4.77161L2.00841 4.77713L2.00759 4.77841C2.00652 4.78005 2.00524 4.78214 2.00416 4.78378L2.00355 4.78475C2.00212 4.78695 2.00115 4.78849 1.99977 4.79068L1.99951 4.79109C1.9925 4.80204 1.98565 4.81283 1.97865 4.82382L1.97849 4.82408L1.97466 4.83011L1.9741 4.83103C1.97302 4.83267 1.97159 4.83497 1.97057 4.8366L1.97 4.83752C1.96893 4.83916 1.96745 4.84156 1.96643 4.8432L1.96591 4.84407C1.96453 4.84627 1.96346 4.84796 1.96208 4.85016L1.96193 4.85036C1.95497 4.86135 1.94822 4.87209 1.94137 4.88314L1.94086 4.88391L1.93728 4.88963L1.93672 4.8905L1.93329 4.89602L1.93257 4.8972L1.92915 4.90272L1.92858 4.90364L1.92511 4.90927L1.92449 4.91019L1.92081 4.91612L1.92045 4.91663C1.91498 4.92548 1.90966 4.93407 1.90419 4.94297L1.90389 4.94348L1.9002 4.94941L1.89959 4.95048C1.89857 4.95217 1.89724 4.95432 1.89622 4.95596L1.89555 4.95703C1.89453 4.95872 1.8933 4.96071 1.89228 4.96235L1.89141 4.96373C1.89039 4.96542 1.88926 4.96726 1.88824 4.96894L1.88747 4.97017C1.88645 4.97186 1.88522 4.9738 1.8842 4.97549L1.88343 4.97677C1.8821 4.97897 1.88108 4.9806 1.87975 4.9828L1.87955 4.98311C1.87551 4.98976 1.87157 4.9963 1.86748 5.003L1.86712 5.00356C1.86594 5.00551 1.86466 5.0076 1.86349 5.00955L1.86293 5.01052C1.8619 5.01221 1.86068 5.0142 1.8597 5.01589L1.85868 5.01757C1.85766 5.01926 1.85674 5.0208 1.85572 5.02248L1.8548 5.02402C1.85377 5.0257 1.8528 5.02734 1.85178 5.02903L1.85091 5.03051C1.84989 5.0322 1.84866 5.03424 1.84764 5.03593L1.84702 5.03695C1.84585 5.0389 1.84472 5.04074 1.84355 5.04268L1.84309 5.04345C1.83772 5.0524 1.83265 5.06094 1.82728 5.06989L1.82672 5.07081L1.82345 5.07633L1.82278 5.07761L1.81972 5.08272L1.81874 5.08441L1.81583 5.08927L1.81481 5.09095L1.81199 5.09571L1.81092 5.0976C1.8099 5.09929 1.80872 5.10128 1.80775 5.10297L1.80724 5.10384L1.80356 5.11008L1.8034 5.11039C1.79942 5.11714 1.79558 5.12368 1.79164 5.13043L1.79128 5.13105C1.79026 5.13273 1.78888 5.13508 1.78791 5.13677L1.78694 5.13841L1.78407 5.14327L1.783 5.14516C1.78198 5.14685 1.78136 5.14797 1.78039 5.14966L1.77917 5.15176C1.77814 5.15344 1.77738 5.15477 1.77646 5.15646L1.77543 5.1582C1.77461 5.15963 1.77354 5.16142 1.77272 5.16285L1.77155 5.16485L1.76873 5.16975L1.76781 5.17129C1.76669 5.17328 1.76551 5.17523 1.76439 5.17722L1.76403 5.17783C1.76142 5.18233 1.75902 5.18648 1.75641 5.19103L1.75539 5.19277C1.75457 5.1942 1.75344 5.19609 1.75268 5.19752L1.7514 5.19967L1.74894 5.20397L1.74746 5.20652L1.74526 5.21041L1.74373 5.21307C1.74306 5.21419 1.74209 5.21588 1.74148 5.217L1.74 5.21951L1.73754 5.22386L1.73636 5.2259C1.73555 5.22733 1.73458 5.22902 1.73376 5.23045L1.73253 5.23255L1.72946 5.23792L1.7289 5.23889C1.72634 5.24344 1.72384 5.24779 1.72128 5.25234L1.72102 5.25275C1.7199 5.25474 1.71877 5.25669 1.71765 5.25868L1.71642 5.26083C1.7156 5.26226 1.71473 5.26379 1.71392 5.26523C1.71351 5.26599 1.713 5.26686 1.71254 5.26763L1.71023 5.27172L1.7088 5.27428L1.70645 5.27842L1.70507 5.28087L1.70287 5.28476L1.70134 5.28747L1.69904 5.29156C1.69852 5.29248 1.69822 5.29309 1.69765 5.29396L1.69515 5.29846L1.69402 5.30046L1.69131 5.30527L1.69024 5.30716L1.68676 5.31345L1.68502 5.31657L1.68308 5.32004L1.6816 5.32275C1.68093 5.32388 1.68006 5.32552 1.6794 5.32664L1.67781 5.3295L1.67577 5.33313L1.67408 5.33615L1.67214 5.33968C1.67152 5.3407 1.67096 5.34173 1.6704 5.34275L1.66835 5.34638L1.66687 5.34909C1.6661 5.35052 1.66549 5.35159 1.66472 5.35303L1.66319 5.35584L1.66109 5.35957L1.65961 5.36233L1.65756 5.36601L1.65593 5.36903L1.6524 5.37542L1.6523 5.37563L1.64882 5.38192L1.64744 5.38447C1.64667 5.38591 1.64606 5.38703 1.64524 5.38846L1.64366 5.39128L1.64166 5.39496L1.64002 5.39792L1.63803 5.40161L1.63634 5.40467L1.63455 5.40795L1.63271 5.41127L1.63092 5.41454L1.62913 5.41782L1.62739 5.42099C1.62683 5.42201 1.62612 5.42334 1.62555 5.42436L1.62376 5.42758L1.62192 5.43101L1.61998 5.43459C1.61952 5.43551 1.61896 5.43653 1.61845 5.43745L1.61497 5.44389L1.61374 5.4462C1.61292 5.44763 1.61216 5.44916 1.61139 5.45059L1.60996 5.4532L1.60786 5.45714L1.60633 5.45995L1.60428 5.46374L1.60264 5.4668C1.60203 5.46798 1.60142 5.46905 1.6008 5.47023L1.59912 5.47335C1.5985 5.47447 1.59784 5.4757 1.59727 5.47683L1.59549 5.4801C1.59508 5.48097 1.59421 5.48255 1.59375 5.48337C1.59318 5.48439 1.59257 5.48552 1.59206 5.48654C1.59145 5.48772 1.59068 5.4891 1.59006 5.49028C1.5895 5.4913 1.58904 5.49212 1.58853 5.49314L1.58618 5.49754L1.58505 5.49963L1.58183 5.50567L1.58014 5.50889C1.57953 5.51006 1.57866 5.51165 1.57805 5.51283L1.57651 5.51574C1.5759 5.51692 1.57524 5.51814 1.57462 5.51927L1.57293 5.52249C1.57232 5.52367 1.57171 5.52479 1.57109 5.52592L1.5693 5.52924C1.56869 5.53042 1.56828 5.53118 1.56767 5.53231C1.56705 5.53349 1.56644 5.53466 1.56583 5.53584L1.56414 5.53906C1.56353 5.54024 1.56301 5.54121 1.5624 5.54238L1.56061 5.54571C1.56 5.54688 1.55954 5.54775 1.55892 5.54893C1.55831 5.5501 1.5577 5.55133 1.55708 5.55246C1.55657 5.55348 1.55601 5.55455 1.55539 5.55563L1.55381 5.55864L1.55187 5.56227L1.55079 5.56437L1.54691 5.57179L1.54512 5.57516L1.54348 5.57833L1.54169 5.58171L1.5399 5.58513L1.53826 5.5883L1.53642 5.59183C1.53601 5.5927 1.53525 5.59413 1.53479 5.595L1.5331 5.59822L1.53126 5.60175C1.53064 5.60293 1.53018 5.60385 1.52957 5.60502C1.52896 5.6062 1.5285 5.60712 1.52788 5.6083L1.52614 5.61167L1.52456 5.61474C1.52384 5.61607 1.52328 5.61719 1.52262 5.61847L1.52113 5.62134L1.51929 5.62492L1.51766 5.62804C1.51633 5.63064 1.51505 5.6331 1.51372 5.63571L1.51259 5.6379C1.51188 5.63923 1.51121 5.64056 1.51055 5.64184L1.50927 5.6444L1.50743 5.64803C1.50682 5.64921 1.50636 5.65013 1.50574 5.6513C1.50518 5.65238 1.50462 5.6535 1.50405 5.65452C1.50359 5.65539 1.50283 5.65693 1.50237 5.6578L1.50058 5.66127L1.49889 5.66455L1.4972 5.66792L1.49557 5.67109L1.49378 5.67462C1.49332 5.67549 1.49255 5.67697 1.49209 5.67789L1.49035 5.68132L1.48866 5.68459L1.48697 5.68797L1.48518 5.69144L1.48355 5.69467L1.48222 5.69732L1.47833 5.70505L1.47705 5.70765L1.47516 5.71139L1.47368 5.71435L1.47184 5.71803L1.47036 5.7211L1.46857 5.72458L1.46698 5.72775L1.46514 5.73138L1.46366 5.73435C1.46304 5.73552 1.46243 5.73675 1.46187 5.73793C1.46141 5.7388 1.46074 5.74018 1.46028 5.74105L1.45844 5.74468L1.45696 5.74769L1.45517 5.75122L1.45363 5.75429L1.45174 5.75807L1.45092 5.75971L1.44341 5.7749L1.44203 5.77766L1.44013 5.78144C1.43957 5.78262 1.43937 5.78303 1.43875 5.7842L1.43686 5.78804L1.43538 5.79101C1.43482 5.79218 1.4342 5.79351 1.43359 5.79469L1.43211 5.79765C1.43149 5.79898 1.43098 5.79995 1.43032 5.80128L1.42868 5.80461L1.42699 5.80798C1.42658 5.80885 1.42587 5.81028 1.42546 5.81115C1.42484 5.81233 1.42428 5.81356 1.42367 5.81473C1.42305 5.81591 1.42265 5.81678 1.42208 5.81795L1.4204 5.82138L1.41855 5.82522L1.41717 5.82803C1.41605 5.83038 1.41513 5.83217 1.414 5.83452L1.41242 5.83774L1.41073 5.84122L1.40904 5.84475L1.40746 5.84802C1.40695 5.8491 1.40638 5.85017 1.40587 5.85124L1.40408 5.85487L1.4025 5.8582C1.40194 5.85937 1.40148 5.8603 1.40091 5.86147C1.40035 5.86265 1.39979 5.86387 1.39917 5.86505C1.39877 5.86592 1.39815 5.86715 1.39774 5.86802C1.39718 5.86919 1.39646 5.87068 1.3959 5.87185C1.39549 5.87272 1.39488 5.87395 1.39447 5.87482L1.39278 5.8784L1.3912 5.88167L1.38946 5.8853C1.38905 5.88617 1.38854 5.88719 1.38813 5.88811C1.38746 5.88944 1.3869 5.89067 1.38629 5.892L1.38511 5.89451C1.38394 5.89691 1.38276 5.89931 1.38163 5.90172C1.38123 5.90258 1.38036 5.90432 1.37995 5.90519C1.37944 5.90627 1.37887 5.90739 1.37836 5.90846L1.37673 5.91184L1.37504 5.91537L1.37345 5.91864L1.37177 5.92222L1.37028 5.92529L1.36859 5.92892L1.36701 5.93224L1.36542 5.93562L1.36384 5.93894L1.3622 5.94237L1.36052 5.94585C1.36 5.94692 1.35949 5.94804 1.35898 5.94912C1.35847 5.95029 1.35781 5.95157 1.35729 5.9528C1.35678 5.95387 1.35632 5.95485 1.35581 5.95592L1.35366 5.96047C1.35331 5.96129 1.35305 5.9619 1.35264 5.96267C1.35157 5.96502 1.35065 5.96691 1.34952 5.96932C1.34906 5.97024 1.34865 5.97116 1.34819 5.97213C1.34768 5.97331 1.34691 5.97489 1.34635 5.97612L1.34487 5.97939C1.34431 5.98057 1.34379 5.98164 1.34328 5.98282L1.3416 5.9864L1.34011 5.98962L1.33853 5.99299C1.33802 5.99417 1.3375 5.99524 1.33694 5.99647L1.33536 5.99985L1.33372 6.00337L1.33224 6.0066C1.33167 6.00777 1.33116 6.00885 1.33065 6.01007L1.32902 6.0136L1.32758 6.01667L1.3259 6.02035C1.32549 6.02122 1.32482 6.02265 1.32441 6.02357C1.3239 6.0248 1.32334 6.02598 1.32278 6.02715L1.31976 6.0337L1.31828 6.03697C1.31771 6.03815 1.31725 6.03917 1.31669 6.04034C1.31613 6.04157 1.31557 6.0428 1.315 6.04398L1.31347 6.04725C1.31301 6.04832 1.31245 6.0495 1.31199 6.05057C1.31148 6.05175 1.31091 6.05292 1.31035 6.0541C1.30989 6.05517 1.30938 6.05625 1.30887 6.05732C1.30831 6.0585 1.30774 6.05978 1.30718 6.06095L1.3056 6.06438L1.30416 6.0675L1.30242 6.07128L1.30104 6.0743L1.29931 6.07808L1.29803 6.08095C1.29741 6.08228 1.29685 6.08355 1.29624 6.08488C1.29583 6.0858 1.29552 6.08652 1.29506 6.08744L1.29312 6.09179L1.29291 6.09225C1.29036 6.09792 1.2878 6.10355 1.28524 6.10922L1.28412 6.11173C1.2835 6.11306 1.28284 6.11459 1.28223 6.11592L1.28115 6.11843C1.28054 6.11976 1.27987 6.12124 1.27926 6.12262L1.27808 6.12528L1.27624 6.12942L1.27507 6.13213C1.27445 6.13346 1.27389 6.13474 1.27328 6.13612L1.272 6.13893L1.27016 6.14303L1.26903 6.14558L1.26719 6.14978L1.26607 6.15233L1.26412 6.15668L1.2631 6.15898C1.2609 6.16399 1.25865 6.16905 1.2564 6.17407L1.25523 6.17672L1.25344 6.18071L1.25226 6.18347L1.25047 6.18751L1.24919 6.19033L1.24745 6.19426L1.24623 6.19708L1.24444 6.20112L1.24321 6.20388L1.24142 6.20802C1.24101 6.20894 1.2407 6.2096 1.24035 6.21053L1.23845 6.21482L1.23733 6.21748C1.23672 6.21886 1.23605 6.22029 1.23549 6.22167L1.23452 6.22382C1.23232 6.22883 1.22997 6.23425 1.22777 6.23926L1.22669 6.24172C1.22608 6.2432 1.22541 6.24468 1.22475 6.24617L1.22373 6.24842C1.22311 6.2499 1.22255 6.25123 1.22189 6.25271L1.22081 6.25532C1.2202 6.2567 1.21964 6.25803 1.21902 6.25936L1.21774 6.26227L1.21616 6.26601C1.21565 6.26724 1.21529 6.26795 1.21478 6.26918L1.21309 6.27306L1.21181 6.27603C1.2113 6.27726 1.21074 6.27864 1.21018 6.27987C1.20966 6.28109 1.20946 6.28155 1.20895 6.28278C1.20833 6.28416 1.20777 6.28554 1.20716 6.28687L1.20675 6.28953L1.20486 6.29398L1.2043 6.29531C1.20184 6.30104 1.19939 6.30687 1.19693 6.31259L1.19632 6.31397L1.19437 6.31852L1.19335 6.32098L1.19141 6.32563L1.19059 6.32758L1.18855 6.33238L1.18762 6.33453L1.18568 6.33908L1.18471 6.34143C1.18405 6.34292 1.18353 6.34425 1.18287 6.34573C1.18246 6.34665 1.18205 6.34762 1.18169 6.34854C1.18108 6.34992 1.18052 6.3513 1.1799 6.35268L1.17888 6.35504L1.17704 6.35954L1.17612 6.36168C1.17392 6.3669 1.17177 6.37212 1.16957 6.37733L1.16855 6.37973L1.16676 6.38413L1.16569 6.38664C1.16507 6.38817 1.16451 6.3895 1.1639 6.39098L1.16282 6.39354L1.16109 6.39768C1.16073 6.3986 1.16037 6.39952 1.15996 6.40039L1.15817 6.40469L1.1571 6.4073L1.15541 6.41144L1.15423 6.4142C1.15362 6.41573 1.15311 6.41701 1.15244 6.4185L1.15142 6.4209C1.15081 6.42243 1.15024 6.42371 1.14963 6.42525L1.14856 6.4279C1.14549 6.43532 1.14252 6.44268 1.13945 6.4501L1.13843 6.45255L1.13674 6.45664L1.13567 6.4594L1.13398 6.46349L1.13281 6.46646L1.13122 6.4704L1.12999 6.47336L1.12846 6.47715L1.12708 6.48063L1.1257 6.48415L1.12437 6.48743L1.12284 6.49121L1.12161 6.49428L1.12002 6.49822L1.11905 6.50057C1.1169 6.50594 1.11481 6.5112 1.11261 6.51657L1.11184 6.51852C1.11128 6.5199 1.11061 6.52164 1.11005 6.52302L1.10903 6.52552L1.10739 6.52956L1.10622 6.53253C1.10565 6.53391 1.10509 6.53529 1.10453 6.53667L1.10345 6.53933C1.10294 6.54071 1.10238 6.54214 1.10177 6.54352L1.10069 6.54628C1.10018 6.54766 1.09957 6.5492 1.09901 6.55058L1.09803 6.55309L1.09624 6.55753L1.09538 6.55968C1.09471 6.56132 1.0941 6.56295 1.09343 6.56459L1.09307 6.56541C1.09088 6.57093 1.08868 6.57656 1.08648 6.58213L1.0854 6.58494C1.08489 6.58617 1.08433 6.58765 1.08382 6.58893L1.08269 6.59185C1.08218 6.59323 1.08167 6.59451 1.08111 6.59589C1.08075 6.59681 1.08029 6.59798 1.07993 6.5989C1.07937 6.60028 1.07891 6.60151 1.07835 6.60289L1.07722 6.60581C1.07676 6.60703 1.07615 6.60862 1.07564 6.60985L1.07446 6.61286L1.07288 6.61685L1.0718 6.61966C1.07129 6.62104 1.07073 6.62248 1.07017 6.62386C1.06981 6.62478 1.06945 6.6258 1.06909 6.62672L1.06751 6.63081L1.06628 6.63393L1.06485 6.63772L1.06326 6.64175C1.06234 6.64411 1.06152 6.64626 1.06065 6.64861C1.0603 6.64953 1.05994 6.65045 1.05958 6.65137L1.05805 6.65531C1.05769 6.65623 1.05723 6.65756 1.05687 6.65848C1.05641 6.6597 1.05605 6.66068 1.05554 6.6619L1.05416 6.66558L1.05283 6.66911C1.05247 6.67003 1.05186 6.67162 1.05155 6.67254C1.05104 6.67382 1.05058 6.67504 1.05012 6.67627L1.04894 6.67944L1.04741 6.68343L1.04623 6.68665L1.04485 6.69023L1.04342 6.69402L1.04214 6.69734L1.04076 6.70107L1.03948 6.7044L1.03821 6.70787L1.0359 6.71396L1.03427 6.71831L1.03299 6.72178L1.03171 6.72521L1.03023 6.7292C1.02977 6.73042 1.02951 6.73104 1.0291 6.73227C1.02859 6.73354 1.02803 6.73508 1.02757 6.73636L1.0265 6.73917L1.02496 6.74326C1.0246 6.74418 1.02414 6.74546 1.02379 6.74643C1.02327 6.74781 1.02286 6.74888 1.02235 6.75027L1.02118 6.75338L1.01969 6.75732C1.01934 6.75824 1.01888 6.75952 1.01852 6.76044L1.01704 6.76438C1.01663 6.76561 1.01642 6.76607 1.01596 6.76729C1.01545 6.76867 1.01494 6.77 1.01443 6.77144C1.01407 6.77236 1.01376 6.77328 1.0134 6.7742C1.01289 6.77558 1.01233 6.77711 1.01182 6.77849L1.01156 6.77921L1.00763 6.79005L1.00686 6.79209L1.00527 6.79644L1.0043 6.79915L1.00267 6.80355C1.00246 6.80416 1.00195 6.80554 1.00169 6.80621L1.00016 6.81045L0.999137 6.81327C0.998626 6.81465 0.998115 6.81603 0.997603 6.81746C0.997194 6.81869 0.99699 6.81915 0.99653 6.82037L0.995047 6.82436L0.993973 6.82743L0.99249 6.83157L0.991467 6.83438L0.989984 6.83853L0.98891 6.84149L0.987427 6.84569L0.986507 6.84824C0.984666 6.85346 0.982672 6.85888 0.980831 6.86404L0.980013 6.8664L0.978427 6.87074L0.977456 6.8735L0.975973 6.87759L0.974899 6.88071L0.973467 6.8847L0.972393 6.88767L0.970962 6.89176L0.969785 6.89498C0.969376 6.89626 0.968916 6.89749 0.968456 6.89871C0.968098 6.89963 0.967535 6.90122 0.96728 6.90214L0.966001 6.90577C0.965541 6.907 0.965183 6.90802 0.964774 6.90925L0.963445 6.91298C0.963138 6.9139 0.962831 6.91477 0.962473 6.91569C0.960734 6.9206 0.958996 6.92571 0.957257 6.93062L0.956081 6.93395L0.954803 6.93768L0.953627 6.941L0.952246 6.94494L0.951172 6.94806L0.949791 6.952L0.948615 6.95537C0.948155 6.95665 0.947797 6.95762 0.947388 6.9589L0.94611 6.96258C0.945752 6.96371 0.945291 6.96504 0.944882 6.96616L0.943706 6.96959L0.942428 6.97327L0.941303 6.97644C0.940843 6.97787 0.940382 6.97915 0.939922 6.98058L0.93895 6.98334C0.938439 6.98477 0.937979 6.9861 0.937519 6.98754C0.937161 6.98846 0.936649 6.98999 0.936343 6.99091L0.933837 6.99822L0.932712 7.0015L0.931433 7.00533L0.930309 7.0086L0.92903 7.01244L0.927854 7.01587L0.926576 7.01965C0.926269 7.02057 0.925809 7.02195 0.925502 7.02287L0.924172 7.02686L0.923098 7.03003L0.921718 7.03407L0.920746 7.03698C0.920235 7.03842 0.919775 7.03985 0.919263 7.04128L0.91824 7.0443C0.917729 7.04573 0.91732 7.04691 0.91686 7.04834L0.915837 7.05141L0.914456 7.05555L0.913638 7.05805L0.910672 7.06685L0.909803 7.06946C0.909292 7.07089 0.908883 7.07211 0.908422 7.0735C0.908064 7.07442 0.907706 7.07559 0.9074 7.07651L0.90607 7.08045L0.904996 7.08383L0.903769 7.08746L0.902593 7.09109L0.901417 7.09456C0.901008 7.09584 0.900598 7.09692 0.900241 7.09819L0.899013 7.10193C0.898604 7.10321 0.898297 7.10413 0.897888 7.10535C0.897479 7.10648 0.897019 7.10786 0.896661 7.10904L0.895485 7.11267L0.894309 7.11625C0.8939 7.11752 0.893388 7.1189 0.89303 7.12018L0.892008 7.1233C0.891599 7.12458 0.890985 7.12632 0.890627 7.12755L0.889604 7.13061C0.888888 7.13281 0.888326 7.13465 0.887559 7.13685L0.88628 7.14079C0.885871 7.14207 0.885462 7.1434 0.885002 7.14463L0.883826 7.14826L0.88265 7.15189C0.882241 7.15317 0.881832 7.15444 0.881423 7.15572L0.8804 7.15894C0.87994 7.16038 0.87953 7.1615 0.879121 7.16293C0.878763 7.1639 0.878354 7.16528 0.878048 7.1662L0.876871 7.16999C0.876462 7.17127 0.876155 7.17219 0.875746 7.17347C0.875337 7.17474 0.874979 7.17582 0.87457 7.1771L0.873394 7.18078C0.872985 7.18206 0.872627 7.18318 0.872218 7.18446L0.871195 7.18758L0.869866 7.19167L0.868843 7.19484C0.868383 7.19627 0.868025 7.1974 0.867565 7.19883C0.867207 7.1998 0.866747 7.20144 0.86644 7.20236C0.865724 7.20466 0.864957 7.20686 0.864292 7.20911C0.863883 7.21039 0.863474 7.21156 0.863116 7.21284L0.861837 7.21678L0.860815 7.22005L0.859587 7.22394L0.858514 7.22742L0.85744 7.23079L0.856212 7.23468C0.855803 7.23595 0.855445 7.23698 0.855036 7.23831L0.853962 7.24173L0.852735 7.24557L0.851661 7.24894L0.850383 7.25293L0.84936 7.25615C0.848951 7.25743 0.848542 7.25871 0.848133 7.26004L0.84711 7.26341L0.845832 7.26745L0.845116 7.26981C0.843428 7.27512 0.841741 7.2806 0.840105 7.28591L0.839235 7.28868L0.838008 7.29272L0.837036 7.29584L0.83586 7.29972L0.834787 7.3032L0.83361 7.30703L0.832588 7.31031C0.83223 7.31158 0.831821 7.31291 0.831412 7.31419L0.830287 7.31782C0.829929 7.31895 0.829571 7.32023 0.829213 7.3214C0.828957 7.32237 0.828395 7.32416 0.828088 7.32514L0.827014 7.32866L0.825838 7.33255L0.824815 7.33603L0.823639 7.33991L0.822616 7.34329C0.8219 7.34549 0.821235 7.34779 0.820571 7.35004C0.820315 7.35091 0.820059 7.35178 0.819804 7.35265C0.819292 7.35423 0.818781 7.35607 0.81827 7.35766L0.817196 7.36124C0.816787 7.36252 0.81648 7.36364 0.816122 7.36492L0.815048 7.3685L0.813974 7.37223L0.812798 7.37602C0.812542 7.37699 0.812082 7.37847 0.811775 7.37939L0.810599 7.38333C0.810241 7.38461 0.810037 7.38532 0.809628 7.3866L0.8084 7.39069L0.80748 7.39386C0.807071 7.39514 0.806662 7.39652 0.806304 7.3978L0.805281 7.40118C0.804872 7.40261 0.804514 7.40378 0.804105 7.40521C0.803849 7.40619 0.803491 7.40726 0.803184 7.40823C0.802827 7.40951 0.802366 7.4111 0.801957 7.41237C0.801702 7.41334 0.801241 7.41493 0.800935 7.41585C0.800321 7.41785 0.799861 7.41963 0.799247 7.42168L0.797764 7.42669L0.796844 7.42991C0.796435 7.43119 0.796025 7.43257 0.795667 7.43385C0.795258 7.43513 0.794952 7.43625 0.794594 7.43758L0.79352 7.44127C0.793162 7.44244 0.792804 7.44362 0.792497 7.44474L0.791372 7.44858L0.790349 7.45195L0.789173 7.45599L0.788151 7.45937L0.787077 7.463L0.786003 7.46678L0.78498 7.47036L0.783906 7.47399L0.782781 7.47788L0.781452 7.481L0.780224 7.48534L0.779304 7.48841C0.778793 7.49036 0.778281 7.49194 0.777719 7.49383L0.776236 7.4989L0.775162 7.50278L0.774242 7.506L0.773065 7.5102L0.772145 7.51352L0.77102 7.51751L0.769997 7.52099L0.768923 7.52467L0.76785 7.5284L0.766827 7.53203L0.765804 7.53561C0.765446 7.53689 0.765037 7.53827 0.76473 7.53955L0.763759 7.54292L0.762583 7.54712C0.762327 7.54814 0.76202 7.54916 0.761713 7.55019C0.761304 7.55177 0.760895 7.55325 0.760435 7.55484L0.759668 7.5576C0.758236 7.56271 0.757009 7.56706 0.755577 7.57217C0.755321 7.57304 0.755117 7.57396 0.754861 7.57483L0.753583 7.57959L0.75256 7.58276C0.752202 7.58404 0.751844 7.58537 0.751486 7.58665L0.750463 7.59028C0.750003 7.59186 0.74985 7.59258 0.749389 7.59421C0.749134 7.59524 0.748776 7.59651 0.748469 7.59754C0.748111 7.59882 0.747753 7.6002 0.747395 7.60147L0.746424 7.60495C0.746066 7.60623 0.745708 7.60766 0.74535 7.60894L0.744429 7.61232C0.744071 7.61359 0.743713 7.61508 0.743355 7.61636C0.742997 7.61753 0.742742 7.6185 0.742435 7.61968L0.741259 7.62403L0.740441 7.62709C0.740083 7.62837 0.739623 7.63006 0.739265 7.63134L0.737935 7.6362C0.737424 7.63814 0.737015 7.63957 0.736503 7.64151L0.73548 7.64525L0.734509 7.64883C0.734151 7.65016 0.733793 7.65154 0.733435 7.65282C0.733077 7.65409 0.732873 7.65486 0.732515 7.65614L0.731441 7.66003C0.731185 7.661 0.730725 7.66258 0.73052 7.66355L0.729498 7.66729L0.728475 7.67107C0.728168 7.67225 0.727861 7.67337 0.727554 7.6745L0.726481 7.67854C0.726174 7.67971 0.725867 7.68084 0.72556 7.68196L0.724537 7.6859L0.723617 7.68933L0.722543 7.69342L0.721623 7.69679C0.721265 7.69807 0.720804 7.69996 0.720447 7.70124C0.720242 7.70211 0.719935 7.70318 0.719731 7.7041L0.718606 7.70835C0.717992 7.7107 0.717378 7.71305 0.716765 7.71541C0.716509 7.71638 0.716151 7.71766 0.715947 7.71863C0.715589 7.7198 0.715231 7.72124 0.714924 7.72236L0.713952 7.72599C0.713645 7.72717 0.713339 7.72834 0.713032 7.72952L0.712009 7.73351L0.711089 7.73704L0.710066 7.74082C0.709708 7.74215 0.709452 7.74317 0.709094 7.7445L0.708123 7.74834C0.707765 7.74967 0.707509 7.75059 0.707202 7.75192L0.70618 7.7557L0.705259 7.75933L0.704236 7.76312L0.703316 7.76675L0.702396 7.77022C0.702038 7.77171 0.701782 7.77278 0.701373 7.77421C0.701117 7.77518 0.700759 7.77667 0.700503 7.77764L0.699021 7.78347L0.697691 7.78868L0.696924 7.7916C0.696617 7.79288 0.696106 7.79482 0.695799 7.7961C0.695543 7.79712 0.695185 7.7984 0.694981 7.79942L0.693958 7.80341L0.693038 7.80709L0.692117 7.81083L0.691197 7.81446L0.690225 7.81829L0.689305 7.82202L0.688384 7.82571L0.687464 7.82939C0.687157 7.83067 0.68685 7.83189 0.686543 7.83317L0.685623 7.8368C0.685316 7.83808 0.684907 7.83972 0.6846 7.841C0.684345 7.84202 0.684089 7.84304 0.683833 7.84406C0.683424 7.8457 0.682964 7.84744 0.682555 7.84902C0.68235 7.84989 0.682146 7.85066 0.681941 7.85153L0.680151 7.85874L0.679333 7.86196C0.679026 7.86324 0.678617 7.86482 0.67831 7.8661L0.677441 7.86958C0.677083 7.87086 0.676725 7.87234 0.676418 7.87362L0.675549 7.8771L0.674629 7.88098L0.673708 7.88472L0.672788 7.88835L0.671765 7.89218C0.671458 7.89346 0.671203 7.89453 0.670845 7.89586C0.670538 7.89719 0.670282 7.89817 0.669975 7.89949C0.669617 7.90077 0.669259 7.90241 0.668953 7.90369C0.668697 7.90471 0.668441 7.90578 0.668186 7.90681L0.667112 7.9112C0.666856 7.91223 0.6666 7.9133 0.666345 7.91438L0.66522 7.91903L0.664606 7.92179C0.663992 7.9244 0.66343 7.92655 0.662816 7.92915L0.662509 7.93028C0.661998 7.93258 0.661538 7.93437 0.660975 7.93667L0.660413 7.93897C0.660055 7.94061 0.659595 7.9424 0.659237 7.94403C0.658981 7.94506 0.658777 7.94603 0.658521 7.94705C0.658163 7.94869 0.657856 7.94997 0.657447 7.9516C0.657191 7.95263 0.656987 7.9536 0.656731 7.95462C0.656424 7.9559 0.656015 7.95764 0.655708 7.95897L0.65489 7.96244C0.654532 7.96372 0.654277 7.9651 0.65397 7.96638C0.653663 7.96756 0.653407 7.96873 0.653152 7.96991C0.652794 7.97119 0.652487 7.97262 0.65218 7.9739L0.651311 7.97732C0.650902 7.97896 0.650646 7.98019 0.650237 7.98177L0.649572 7.98464C0.649214 7.98627 0.648856 7.98765 0.648498 7.98929L0.647782 7.99231C0.647424 7.99394 0.646913 7.99604 0.646504 7.99768L0.646044 7.99967L0.644356 8.00703C0.644203 8.00775 0.643947 8.00877 0.643743 8.00949L0.642566 8.01465C0.642311 8.01552 0.642157 8.01654 0.641902 8.01741L0.640879 8.02197L0.640061 8.02544L0.63914 8.02948L0.638322 8.03296L0.637504 8.03685L0.636686 8.04048L0.635765 8.04452L0.634998 8.04794L0.634078 8.05203L0.633311 8.05541L0.632237 8.06006L0.631623 8.06277L0.630396 8.06824L0.629936 8.07029C0.629322 8.0729 0.628862 8.0752 0.628248 8.07781L0.62789 8.07944L0.626612 8.08517L0.625743 8.08854L0.624822 8.09274L0.624106 8.09596L0.623135 8.10031L0.622419 8.10358C0.622112 8.10491 0.621754 8.10654 0.621498 8.10782L0.620783 8.11104C0.620527 8.11237 0.620169 8.11401 0.619862 8.11534L0.619095 8.11877C0.618839 8.1201 0.618481 8.12168 0.618175 8.12301L0.61751 8.12608L0.616487 8.13078L0.615822 8.13375C0.615464 8.13539 0.615158 8.13677 0.6148 8.1384L0.614186 8.14127L0.613163 8.14597C0.612754 8.14776 0.612396 8.14945 0.612038 8.15119L0.610964 8.1562C0.61076 8.15707 0.610555 8.15814 0.610351 8.15906C0.610044 8.16039 0.609635 8.16233 0.609328 8.16361L0.608612 8.16699L0.607692 8.17123L0.606976 8.17456C0.606669 8.17589 0.606362 8.17737 0.606055 8.17865C0.6058 8.17982 0.605595 8.1809 0.605339 8.18207L0.604419 8.18637L0.603703 8.18959C0.603447 8.19092 0.603089 8.19245 0.602783 8.19378L0.602067 8.19721L0.601197 8.20135C0.600942 8.20253 0.600686 8.2036 0.600482 8.20478C0.600226 8.20611 0.599919 8.20749 0.599612 8.20882L0.598896 8.2124C0.59859 8.21373 0.598334 8.21505 0.598078 8.21633C0.597669 8.21812 0.597362 8.21986 0.596953 8.2216C0.596544 8.22359 0.596237 8.22518 0.595777 8.22717L0.595061 8.23029L0.594141 8.23474L0.593476 8.23802C0.593169 8.23934 0.592862 8.24103 0.592555 8.24236L0.591788 8.24594L0.59097 8.24983L0.590254 8.25346C0.589948 8.25479 0.589743 8.25601 0.589436 8.25734L0.588669 8.26118C0.588413 8.26251 0.588209 8.26348 0.587902 8.26481C0.587646 8.26614 0.587391 8.26737 0.587084 8.2687L0.586368 8.27217L0.585499 8.27637L0.584834 8.27969C0.584527 8.28102 0.584271 8.28235 0.584016 8.28373L0.583198 8.28762L0.582482 8.29135C0.58197 8.29401 0.58151 8.296 0.580999 8.29861L0.580487 8.30137L0.579516 8.30603L0.5788 8.30955L0.577982 8.31375L0.577317 8.31707C0.576959 8.31871 0.576806 8.31968 0.576499 8.32132C0.576243 8.32234 0.575987 8.32367 0.575783 8.32469L0.574965 8.32888L0.574249 8.33241L0.573482 8.33625L0.572715 8.34003C0.572459 8.34136 0.572203 8.34259 0.571948 8.34392L0.571232 8.3475L0.570414 8.35174L0.5698 8.35501C0.569442 8.35665 0.569186 8.35813 0.56888 8.35982C0.568675 8.36074 0.56847 8.36176 0.568317 8.36263C0.567908 8.36463 0.567703 8.36586 0.567294 8.36785L0.566578 8.37158L0.565402 8.37762L0.564891 8.38043C0.564533 8.38207 0.564277 8.3836 0.56397 8.38529L0.563357 8.3883C0.56305 8.38994 0.562845 8.39117 0.562488 8.3928L0.561874 8.39608C0.561567 8.39771 0.561363 8.39868 0.561056 8.40032C0.560851 8.4015 0.560647 8.40262 0.560391 8.40385C0.560135 8.40518 0.55988 8.40671 0.559573 8.40799C0.559368 8.40917 0.559215 8.41004 0.558959 8.41126L0.55809 8.41571L0.557476 8.41893C0.557118 8.42057 0.556914 8.42175 0.556607 8.42343L0.556044 8.42645C0.555738 8.42809 0.555431 8.42957 0.555124 8.43121L0.554561 8.43417L0.553334 8.44082L0.553181 8.44159C0.552721 8.44425 0.55226 8.44665 0.551749 8.44931L0.551442 8.45089L0.550317 8.45698L0.549908 8.45933L0.548937 8.4646L0.548425 8.46721L0.547505 8.47232L0.546993 8.47498L0.546073 8.47984C0.545868 8.48091 0.545715 8.48173 0.545562 8.4828C0.545306 8.48413 0.544948 8.48623 0.544692 8.48756L0.54413 8.49052L0.543312 8.49513L0.542749 8.49825L0.54188 8.50305L0.541368 8.50587L0.540397 8.51123L0.539988 8.51348C0.539527 8.51614 0.539118 8.51844 0.538607 8.5211L0.538454 8.52192C0.538045 8.52422 0.537635 8.52637 0.537226 8.52867C0.537073 8.52959 0.536868 8.53067 0.536715 8.53159L0.535897 8.53624C0.535692 8.53731 0.535488 8.53839 0.535334 8.53946L0.534516 8.54396L0.533954 8.54713L0.533135 8.55163C0.532982 8.55271 0.532778 8.55378 0.532573 8.55485L0.531806 8.5593L0.531192 8.56263L0.530425 8.56713L0.529914 8.57009L0.529045 8.57505C0.528891 8.57597 0.528687 8.57689 0.528584 8.57781C0.528278 8.57945 0.527868 8.5817 0.527613 8.58339L0.527255 8.58538L0.526181 8.59177L0.525925 8.59321L0.524596 8.60088L0.52434 8.60256C0.524033 8.60425 0.523624 8.60676 0.523317 8.60844L0.522806 8.61126C0.52255 8.61294 0.522295 8.61453 0.521988 8.61617L0.521476 8.61908C0.521221 8.62077 0.520965 8.62205 0.520658 8.62373L0.520147 8.6269C0.519942 8.62823 0.519636 8.63013 0.51938 8.63146C0.519226 8.63253 0.519022 8.6336 0.518869 8.63463C0.518664 8.63595 0.518357 8.63774 0.518153 8.63907L0.517641 8.6423C0.517334 8.64398 0.51713 8.64516 0.516874 8.64685L0.516363 8.65007L0.515647 8.65426L0.515033 8.65784L0.514317 8.66224L0.513806 8.66541C0.513346 8.66807 0.512988 8.67027 0.512528 8.67293L0.512221 8.67482L0.5113 8.68055L0.510789 8.68351C0.510533 8.6852 0.510329 8.68653 0.510022 8.68816L0.509511 8.69139L0.508744 8.69604C0.50859 8.69711 0.508488 8.69783 0.508283 8.6989L0.507516 8.70381C0.507363 8.70489 0.50721 8.7057 0.507005 8.70673C0.5068 8.70806 0.506494 8.7102 0.506238 8.71153L0.505778 8.71445L0.505062 8.71905L0.50455 8.72237C0.504295 8.72406 0.50409 8.72529 0.503835 8.72698L0.503323 8.72994C0.503068 8.73163 0.502761 8.73368 0.502505 8.73531L0.502147 8.73761C0.501329 8.74298 0.500562 8.74758 0.499744 8.7529C0.49959 8.75382 0.499488 8.75469 0.499335 8.75556C0.499079 8.75725 0.498823 8.75894 0.498568 8.76062L0.498056 8.76364C0.497801 8.76533 0.497647 8.76651 0.49734 8.76819L0.496829 8.77167L0.496215 8.77581L0.495653 8.77954L0.495039 8.78338L0.494477 8.78721C0.494221 8.78854 0.494068 8.78993 0.493863 8.79125C0.49371 8.79248 0.493505 8.79361 0.493352 8.79483C0.493096 8.79652 0.492943 8.79744 0.492738 8.79908L0.492227 8.80245C0.491971 8.80414 0.491715 8.80573 0.491511 8.80736L0.491102 8.81002C0.490744 8.81237 0.490488 8.81391 0.490181 8.81626L0.489926 8.81769L0.488749 8.82546L0.488545 8.82679L0.487624 8.83308C0.487471 8.83416 0.487369 8.83503 0.487215 8.83605C0.48696 8.83774 0.486806 8.83907 0.486499 8.84075C0.486346 8.84183 0.486193 8.8429 0.486039 8.84398L0.485426 8.84837C0.485221 8.8496 0.485068 8.85067 0.484914 8.8519L0.484301 8.85609C0.484096 8.85732 0.483943 8.85835 0.483789 8.85957L0.483176 8.86382L0.482664 8.86734C0.482409 8.86903 0.482255 8.87021 0.482 8.8719L0.48159 8.87486L0.480875 8.87972C0.480721 8.88079 0.480619 8.88166 0.480465 8.88274L0.47975 8.88785C0.479647 8.88862 0.479494 8.88959 0.479392 8.89036C0.479034 8.89307 0.478676 8.89532 0.478318 8.89798L0.478062 8.89982C0.477806 8.90181 0.4775 8.90375 0.477244 8.9058L0.476835 8.90856L0.47617 8.91342C0.476017 8.91449 0.475812 8.91572 0.47571 8.91679L0.475096 8.92124L0.474687 8.92441L0.474073 8.92902C0.47392 8.93009 0.473767 8.93101 0.473664 8.93203L0.472948 8.93699C0.472846 8.93791 0.472693 8.93888 0.47259 8.93975L0.471926 8.94456C0.471772 8.94563 0.47167 8.94661 0.471517 8.94768L0.470852 8.95254C0.47075 8.95346 0.470596 8.95443 0.470494 8.95535L0.469727 8.96087C0.469625 8.96164 0.469573 8.9623 0.46942 8.96302L0.4685 8.96992L0.468346 8.97084L0.467323 8.97846L0.466966 8.98133L0.466301 8.98624L0.465892 8.9892C0.465687 8.99089 0.465483 8.99232 0.465278 8.99401L0.464869 8.99728C0.464664 8.99897 0.464511 9.00004 0.464306 9.00173C0.464153 9.00296 0.464 9.00388 0.463897 9.00505C0.463693 9.00638 0.463488 9.00812 0.463284 9.00945L0.462875 9.01288C0.46267 9.01421 0.462466 9.01595 0.462312 9.01728C0.462159 9.01835 0.462005 9.01947 0.461903 9.0205C0.461647 9.02219 0.461545 9.02336 0.461289 9.02505C0.461136 9.02612 0.461034 9.02725 0.46088 9.02832L0.460318 9.03292L0.459909 9.03604C0.459653 9.03773 0.459449 9.03962 0.459244 9.04131L0.458886 9.04382L0.457914 9.05159L0.457761 9.05261C0.457505 9.05466 0.457147 9.05721 0.456943 9.05926L0.456585 9.06202C0.45638 9.06371 0.456176 9.06534 0.455971 9.06703L0.455613 9.07015C0.455358 9.07184 0.455255 9.07301 0.455051 9.0747L0.454642 9.07803L0.454079 9.08258L0.45367 9.08585L0.453159 9.0903L0.45275 9.09362C0.452494 9.09531 0.452392 9.09649 0.452187 9.09817L0.451369 9.1015C0.451165 9.10318 0.451011 9.10436 0.450807 9.10605C0.450704 9.10712 0.450551 9.10814 0.450449 9.10922L0.449784 9.11464L0.449528 9.11694C0.448915 9.12236 0.448352 9.12706 0.447687 9.13248L0.447432 9.13479L0.446818 9.14031C0.446665 9.14123 0.446562 9.14225 0.44646 9.14317L0.445795 9.14803L0.445437 9.15105L0.444875 9.15585L0.444517 9.15897C0.444363 9.1603 0.444108 9.1624 0.444005 9.16378C0.443852 9.1647 0.44375 9.16577 0.443648 9.1667C0.443443 9.16838 0.443238 9.16992 0.443085 9.1716C0.442932 9.17268 0.442829 9.1737 0.442727 9.17477C0.442523 9.17646 0.442369 9.17779 0.442216 9.17948L0.441858 9.18245C0.441704 9.18413 0.441449 9.18602 0.441244 9.18776L0.440988 9.19027L0.43925 9.20587L0.438994 9.20796C0.43879 9.20965 0.438534 9.212 0.438381 9.21369L0.438023 9.21645C0.437869 9.21814 0.437665 9.21977 0.437511 9.22146L0.437153 9.22448L0.436642 9.22923L0.436284 9.23266L0.435875 9.2368L0.435466 9.24054C0.435312 9.24192 0.435159 9.24335 0.435006 9.24468L0.434596 9.24831L0.434187 9.25265L0.433829 9.25603C0.433625 9.25772 0.433471 9.25905 0.433318 9.26073C0.433165 9.26181 0.433062 9.26283 0.43296 9.2639C0.432807 9.26529 0.432602 9.26718 0.432449 9.26851C0.432346 9.26958 0.432244 9.27065 0.432091 9.27173C0.431835 9.27444 0.431579 9.27659 0.431273 9.2793L0.431017 9.2815L0.430454 9.28712L0.430148 9.29019C0.429943 9.29188 0.42979 9.29315 0.429636 9.29484C0.429534 9.29592 0.429381 9.29725 0.429278 9.29832C0.429125 9.30001 0.429023 9.30093 0.428869 9.30261C0.428767 9.30384 0.428614 9.30512 0.428511 9.30635L0.428102 9.31039C0.427949 9.31161 0.427847 9.31279 0.427744 9.31402C0.427591 9.3154 0.427437 9.31688 0.427335 9.31826L0.426977 9.32189L0.426568 9.32609L0.42621 9.32956L0.42575 9.33411L0.425443 9.33739L0.424932 9.34265L0.424676 9.34511L0.423142 9.36086L0.422937 9.36316L0.422426 9.36858C0.422375 9.3695 0.422222 9.37083 0.422119 9.37175C0.421966 9.37344 0.421812 9.37482 0.42171 9.37651L0.421403 9.37963C0.42125 9.38131 0.421097 9.38259 0.420994 9.38433C0.420841 9.3854 0.42079 9.38648 0.420636 9.38755C0.420534 9.38893 0.42033 9.39087 0.420227 9.39226L0.41992 9.39548C0.419767 9.39716 0.419665 9.39855 0.419511 9.40023L0.419256 9.4032C0.419102 9.40489 0.418949 9.40663 0.418795 9.40831L0.41854 9.41113C0.418386 9.41281 0.418182 9.4147 0.41808 9.41644L0.417824 9.41895C0.417568 9.42135 0.417466 9.42304 0.41721 9.42544L0.417108 9.42677C0.416852 9.42948 0.416648 9.43194 0.416392 9.43465L0.416239 9.43639C0.416085 9.43807 0.41583 9.44078 0.415727 9.44247L0.415472 9.44523C0.415318 9.44692 0.415165 9.44861 0.415063 9.4503L0.414807 9.45336C0.414653 9.45505 0.414551 9.45638 0.414398 9.45812L0.414091 9.46129C0.413989 9.46267 0.413835 9.46466 0.413682 9.46599L0.413426 9.46932L0.413017 9.47372L0.412761 9.47714C0.412608 9.47883 0.412506 9.4799 0.412352 9.48164C0.41225 9.48287 0.412199 9.48384 0.412046 9.48507L0.411688 9.48967L0.411432 9.49284C0.41133 9.49422 0.411125 9.49627 0.411023 9.49765L0.410665 9.50087C0.410409 9.50358 0.410256 9.50583 0.410051 9.50859L0.41 9.50941L0.409438 9.51636L0.409233 9.51902L0.408824 9.52439L0.408568 9.5272L0.408159 9.53211C0.408108 9.53319 0.408006 9.53426 0.407904 9.53539C0.40775 9.53712 0.407699 9.5383 0.407546 9.54004L0.40729 9.54341C0.407136 9.54479 0.407034 9.54648 0.406932 9.54786C0.406881 9.54894 0.406779 9.55021 0.406676 9.55129L0.406318 9.55569C0.406216 9.55676 0.406114 9.55819 0.406063 9.55927C0.405909 9.56065 0.405807 9.56203 0.405705 9.56336C0.405602 9.56458 0.4055 9.56581 0.405449 9.56709L0.40504 9.572L0.404835 9.57486C0.404682 9.57727 0.404477 9.57957 0.404324 9.58197L0.404273 9.58269L0.40371 9.59061L0.403557 9.59286C0.403404 9.5946 0.40325 9.5967 0.403148 9.59844L0.402892 9.60156L0.402534 9.60631L0.402279 9.60948C0.402176 9.61122 0.402074 9.61245 0.401921 9.61419L0.401665 9.61756L0.401358 9.62206L0.401102 9.62554L0.400796 9.62983C0.400744 9.63106 0.400642 9.63229 0.40054 9.63357C0.400438 9.63531 0.400387 9.63633 0.400233 9.63802L0.400029 9.64113C0.399875 9.64287 0.399773 9.64461 0.399671 9.64635L0.399466 9.64911C0.399364 9.65085 0.39921 9.6532 0.399057 9.65494L0.398904 9.65699C0.39875 9.65975 0.398546 9.662 0.398392 9.66476C0.398341 9.66568 0.398239 9.66634 0.398239 9.66726C0.398085 9.66931 0.397983 9.67069 0.397881 9.67274C0.397779 9.67381 0.397727 9.67468 0.397676 9.67575C0.397523 9.67749 0.397472 9.67867 0.397369 9.68041L0.397114 9.68424L0.396858 9.68828L0.396602 9.69217L0.396347 9.69616L0.396091 9.69999C0.395989 9.70137 0.395887 9.70286 0.395835 9.70424L0.39558 9.70776L0.395324 9.71211C0.395273 9.71334 0.395171 9.71446 0.395068 9.71569L0.394813 9.72029L0.394608 9.72346L0.394301 9.72847C0.39425 9.7294 0.394148 9.73047 0.394148 9.73139C0.393995 9.73379 0.393841 9.73614 0.393739 9.73855L0.393585 9.74039L0.393227 9.74704L0.393023 9.75021L0.392767 9.75496L0.392563 9.75823L0.392307 9.76284L0.392102 9.76647L0.391847 9.77071L0.391642 9.77429C0.39154 9.77567 0.391489 9.77731 0.391387 9.77864C0.391335 9.77971 0.391233 9.78109 0.391182 9.78217L0.390926 9.78667L0.390722 9.79004C0.390671 9.79142 0.390568 9.79311 0.390466 9.79449L0.390262 9.79812L0.390006 9.80262L0.389853 9.80595L0.389546 9.81147C0.389495 9.81223 0.389495 9.81305 0.389392 9.81387C0.389239 9.81663 0.389137 9.81893 0.388983 9.8217L0.38883 9.82435C0.388728 9.82609 0.388676 9.82778 0.388574 9.82952L0.388421 9.83315L0.388165 9.83745L0.388012 9.84108L0.387756 9.84532C0.387705 9.84655 0.387654 9.84767 0.387603 9.84895L0.387398 9.85345C0.387347 9.85468 0.387245 9.8556 0.387245 9.85683L0.386989 9.86127L0.386835 9.86475C0.386784 9.86649 0.386682 9.86782 0.38658 9.86956L0.386426 9.87258L0.386171 9.878L0.386017 9.88045L0.385762 9.88679L0.385659 9.88843C0.385557 9.89119 0.385404 9.89369 0.385301 9.89646L0.38525 9.89717C0.385097 9.89958 0.384995 9.90193 0.384892 9.90438L0.38479 9.90684L0.384534 9.91231C0.384483 9.91338 0.384432 9.9142 0.384381 9.91533L0.384176 9.92029C0.384125 9.92136 0.384074 9.92238 0.384023 9.92351C0.383972 9.92489 0.38387 9.92678 0.383818 9.92816C0.383767 9.92923 0.383716 9.93051 0.383665 9.93159L0.383461 9.93624C0.383409 9.93731 0.383358 9.93829 0.383307 9.93936L0.383103 9.94432L0.382949 9.94739L0.382796 9.9523C0.382745 9.95322 0.382693 9.95444 0.382642 9.95536L0.382438 9.96033L0.382336 9.96339C0.38208 9.96892 0.381926 9.97362 0.381722 9.97914L0.38162 9.9817L0.381415 9.98712L0.381313 9.99024L0.381159 9.99505L0.381057 9.99822C0.381006 9.99996 0.380904 10.0015 0.380904 10.0032L0.380801 10.0061C0.38075 10.0075 0.380648 10.0097 0.380648 10.0111L0.380495 10.0143C0.380443 10.0161 0.380392 10.0173 0.380341 10.0191C0.38029 10.0202 0.38029 10.0213 0.380188 10.0224C0.380137 10.0241 0.380137 10.0252 0.380034 10.027L0.379932 10.0304L0.379779 10.0352L0.379676 10.0383C0.379625 10.04 0.379574 10.0423 0.379523 10.0441L0.379472 10.0463C0.379421 10.049 0.379318 10.0514 0.379216 10.0542L0.379165 10.0566C0.379114 10.0583 0.379063 10.0604 0.379012 10.0621L0.378909 10.0654C0.378858 10.0668 0.378858 10.0687 0.378756 10.0701C0.378756 10.0711 0.378705 10.0724 0.378705 10.0735C0.378654 10.0752 0.378603 10.0764 0.378551 10.0781L0.378449 10.0815C0.378398 10.0828 0.378398 10.0847 0.378296 10.0861L0.378245 10.0895L0.378091 10.094C0.37804 10.0953 0.37804 10.0963 0.37804 10.0976C0.377989 10.0993 0.377938 10.1003 0.377887 10.1021C0.377836 10.1031 0.377836 10.1044 0.377836 10.1054C0.377784 10.1072 0.377733 10.1086 0.377682 10.1103L0.377631 10.1134C0.37758 10.1155 0.377529 10.1175 0.377478 10.1195L0.377426 10.1212C0.377375 10.124 0.377324 10.1265 0.377273 10.1293V10.1296C0.377222 10.1324 0.37712 10.1345 0.37712 10.1374L0.377069 10.1397L0.376966 10.1452C0.376915 10.1463 0.376915 10.1473 0.376915 10.1484L0.376813 10.1532C0.376762 10.1543 0.376762 10.1555 0.376762 10.1566L0.376659 10.1611C0.376659 10.1622 0.376608 10.1635 0.376608 10.1646C0.376557 10.166 0.376557 10.1678 0.376557 10.1692C0.376506 10.1703 0.376506 10.1716 0.376506 10.1726L0.376404 10.1772L0.376353 10.1806L0.37625 10.1855L0.376199 10.1885C0.376199 10.1903 0.376148 10.1918 0.376148 10.1935C0.376097 10.1946 0.376097 10.1955 0.376097 10.1966L0.375995 10.2021L0.375944 10.2046C0.375892 10.2073 0.375892 10.2096 0.37579 10.2124C0.37579 10.2132 0.37579 10.2143 0.375739 10.215C0.375739 10.2168 0.375688 10.2187 0.375688 10.2204L0.375637 10.2237L0.375586 10.2283C0.375534 10.2296 0.375534 10.2306 0.375534 10.2319L0.375483 10.2364C0.375432 10.2377 0.375432 10.2385 0.375432 10.2397C0.375381 10.2411 0.375381 10.2431 0.375381 10.2444L0.37533 10.2479C0.375279 10.2492 0.375279 10.251 0.375279 10.2524C0.375279 10.2536 0.375279 10.2546 0.375228 10.2558C0.375228 10.2576 0.375228 10.2587 0.375176 10.2604L0.375125 10.2639C0.375125 10.2657 0.375074 10.267 0.375074 10.2687C0.375023 10.2699 0.375023 10.2708 0.375023 10.2718C0.374972 10.2736 0.374972 10.2754 0.374972 10.2771C0.374921 10.278 0.374921 10.279 0.374921 10.2799C0.37487 10.2827 0.37487 10.285 0.37487 10.2878V10.2895C0.374819 10.2913 0.374819 10.2939 0.374819 10.2957V10.2988C0.374819 10.3005 0.374767 10.3021 0.374767 10.3038V10.307C0.374716 10.3088 0.374716 10.3099 0.374716 10.3117L0.374665 10.3152V10.3199L0.374614 10.3232V10.3278C0.374614 10.3289 0.374614 10.3302 0.374563 10.3313V10.344C0.374512 10.3452 0.374512 10.3462 0.374512 10.3473V10.376C0.374512 10.3783 0.374512 10.3807 0.374563 10.383V10.3938L0.374614 10.396C0.374614 10.3992 0.374614 10.4024 0.374665 10.4057V10.4082C0.374665 10.4106 0.374716 10.4131 0.374716 10.4155V10.4188C0.374767 10.4211 0.374767 10.4233 0.374767 10.4256V10.4287C0.374819 10.4315 0.374819 10.4343 0.374819 10.4371V10.4385C0.37487 10.4417 0.37487 10.4449 0.37487 10.4481L0.374921 10.4512C0.374972 10.4535 0.374972 10.4557 0.374972 10.458C0.374972 10.4594 0.374972 10.46 0.375023 10.4614C0.375023 10.4637 0.375074 10.466 0.375074 10.4683C0.375074 10.4693 0.375074 10.4702 0.375125 10.4712L0.375228 10.4808V10.4824L0.37533 10.4905L0.375381 10.4938L0.375483 10.5005L0.375534 10.5037L0.375637 10.5111L0.375688 10.5136C0.375739 10.5167 0.37579 10.5199 0.375841 10.523L0.375892 10.5262L0.375995 10.5326C0.375995 10.534 0.376046 10.5352 0.376046 10.5366L0.376148 10.5427C0.376148 10.5437 0.376199 10.5452 0.376199 10.5462C0.37625 10.5492 0.376301 10.5521 0.376353 10.5551L0.376404 10.5574C0.376455 10.56 0.376455 10.5627 0.376557 10.5653L0.376608 10.5689C0.376659 10.5709 0.376659 10.573 0.376762 10.575L0.376813 10.579C0.376864 10.581 0.376915 10.5831 0.376966 10.5852L0.377017 10.5886L0.377222 10.5977L0.377324 10.6014C0.377375 10.6034 0.377375 10.6054 0.377478 10.6073L0.37758 10.6116C0.377631 10.6134 0.377631 10.6153 0.377733 10.6171L0.377836 10.6214C0.377887 10.6235 0.377938 10.6256 0.377989 10.6278C0.37804 10.6295 0.378091 10.6309 0.378142 10.6327L0.378347 10.6399L0.378449 10.6443C0.3785 10.646 0.378551 10.6477 0.378603 10.6494C0.378654 10.6508 0.378705 10.6527 0.378756 10.654C0.378807 10.6557 0.378858 10.6575 0.378909 10.6591C0.378961 10.6609 0.379012 10.6619 0.379063 10.6636C0.379114 10.6661 0.379216 10.6685 0.379318 10.6709C0.37937 10.6726 0.379421 10.6752 0.379472 10.6769C0.379523 10.6785 0.379574 10.6802 0.379625 10.6818L0.379779 10.6868L0.379932 10.6913L0.380086 10.6963L0.380239 10.7008C0.380341 10.7043 0.380495 10.7076 0.380597 10.7111L0.380699 10.7142L0.380904 10.7199C0.380955 10.7211 0.380955 10.7224 0.381057 10.7236L0.381211 10.7293C0.381262 10.7305 0.381313 10.7318 0.381364 10.733C0.381466 10.7351 0.381517 10.7367 0.381568 10.7388L0.381671 10.7413C0.381824 10.7455 0.381978 10.7491 0.38208 10.7532C0.382131 10.7543 0.382131 10.7552 0.382233 10.7562C0.382284 10.7579 0.382387 10.7602 0.382438 10.762L0.382591 10.7657L0.382847 10.7714C0.382898 10.7725 0.382898 10.7736 0.383 10.7747C0.383256 10.7816 0.383512 10.7883 0.383818 10.7952C0.38387 10.7961 0.383921 10.7971 0.383972 10.798C0.384023 10.8001 0.384125 10.8022 0.384228 10.8043L0.38433 10.8071C0.384432 10.8092 0.384534 10.8115 0.384586 10.8135L0.384688 10.8152L0.385301 10.8295L0.385353 10.8305C0.385455 10.8329 0.385506 10.8349 0.385659 10.8373L0.385762 10.8397L0.386068 10.8464L0.386171 10.8484L0.387245 10.8714L0.387296 10.872C0.387449 10.8744 0.387551 10.877 0.387654 10.8794L0.387705 10.881C0.387858 10.8834 0.38796 10.886 0.388063 10.8884L0.388114 10.8886C0.388523 10.8966 0.388932 10.9047 0.389341 10.9126L0.389392 10.9137C0.389546 10.9165 0.389648 10.9186 0.389801 10.9214L0.389853 10.922C0.390466 10.9331 0.391029 10.9436 0.391642 10.9546V10.9548C0.406114 11.2114 0.429739 11.4654 0.462619 11.7167C0.463693 11.7249 0.464869 11.7331 0.466147 11.7412C0.467068 11.7494 0.468039 11.7576 0.469164 11.7657C0.469471 11.7681 0.469778 11.7702 0.470085 11.7725L0.470136 11.7728C0.470698 11.7768 0.47121 11.7809 0.471823 11.7849L0.472284 11.7882L0.472539 11.7899C0.47484 11.8067 0.477193 11.8236 0.479596 11.8403C0.557476 12.374 1.01484 12.7699 1.55412 12.7705C2.1587 12.7705 2.64889 12.2804 2.64894 11.6758C2.64894 11.6256 2.64551 11.5755 2.63861 11.5258L2.63211 11.4789C2.63109 11.4715 2.62997 11.4642 2.62884 11.4569C2.62797 11.4486 2.627 11.4403 2.62587 11.4319C2.58001 11.0776 2.55699 10.7207 2.55699 10.3635C2.55664 8.40283 3.26068 6.50727 4.54081 5.02218C4.54623 5.01584 4.55166 5.00944 4.55692 5.00305C4.56199 4.99753 4.56695 4.99201 4.57185 4.98638L4.6032 4.95074C5.00068 4.49747 4.95686 3.80816 4.50517 3.40884C4.30682 3.23298 4.05078 3.13598 3.78559 3.13623Z" fill="#F69900"/>
                                        </g>
                                        <defs>
                                        <clipPath id="clip0_4355_16445">
                                        <rect width="24" height="24" fill="white" transform="translate(0.375)"/>
                                        </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                Request Location
                              </a>
                          </li>

                          <li>
                              <a href="<?php echo e(url('/my-profile/edit-password')); ?>">
                                <div class="icon-box bg_service-6">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M4.12146 3.3103H5.77663V7.03444H4.12146V3.3103Z" fill="#95A5A5"/>
                                        <path d="M9.91455 3.3103H11.5697V7.03444H9.91455V3.3103Z" fill="#95A5A5"/>
                                        <path d="M6.19052 1.65527V3.72424C6.19052 3.95277 6.00526 4.13803 5.77673 4.13803H4.12156C3.89303 4.13803 3.70776 3.95277 3.70776 3.72424V1.65527H6.19052Z" fill="#35495E"/>
                                        <path d="M11.9836 1.65527V3.72424C11.9836 3.95277 11.7984 4.13803 11.5698 4.13803H9.91465C9.68612 4.13803 9.50085 3.95277 9.50085 3.72424V1.65527H11.9836Z" fill="#35495E"/>
                                        <path d="M13.2249 1.03448C13.2258 1.30911 13.1171 1.57275 12.9229 1.76695C12.7287 1.96114 12.4651 2.06985 12.1904 2.06897H3.50079C2.92946 2.06897 2.46631 1.60581 2.46631 1.03448C2.46631 0.463154 2.92946 0 3.50079 0H12.1904C12.7618 0 13.2249 0.463154 13.2249 1.03448Z" fill="#3F5C6C"/>
                                        <path d="M15.5918 10.3861C15.9974 8.49506 15.2732 8.8261 15.2732 7.78334C15.2732 7.71713 15.2774 7.65506 15.2815 7.59713C15.3224 7.24544 15.2118 6.89295 14.9773 6.62766C14.7428 6.36238 14.4066 6.20935 14.0525 6.20679H1.63874C1.28427 6.2091 0.947475 6.36189 0.712268 6.62709C0.477061 6.89229 0.365593 7.24493 0.405639 7.59713C0.409777 7.65506 0.413915 7.71713 0.413915 7.78334C0.413915 8.56955 0.00012207 8.56955 0.00012207 9.35575C0.00012207 10.142 0.413915 10.142 0.413915 10.9282C0.413915 11.7144 0.00012207 11.7144 0.00012207 12.5006C0.00012207 13.2868 0.413915 13.2868 0.413915 14.073C0.413915 14.8592 0.00012207 14.8592 0.00012207 15.6454C0.00012207 16.4316 0.413915 16.4316 0.413915 17.2178C0.413915 18.004 0.00012207 18.004 0.00012207 18.7902C0.00012207 19.5764 0.413915 19.5764 0.413915 20.3585C0.413915 20.4247 0.409777 20.4826 0.405639 20.5364C0.364867 20.8892 0.47595 21.2427 0.711187 21.5087C0.946424 21.7747 1.28364 21.9282 1.63874 21.9309H4.13805L16.5518 16.5516L15.5918 10.3861Z" fill="#2980BA"/>
                                        <path d="M13.6387 11.1723V16.5516H11.9835V11.1723C11.9835 10.7152 12.354 10.3447 12.8111 10.3447C13.2668 10.3481 13.6353 10.7167 13.6387 11.1723Z" fill="#3B97D3"/>
                                        <path d="M10.3284 11.1723V16.5516H8.67322V11.1723C8.67322 10.7152 9.04374 10.3447 9.5008 10.3447C9.95646 10.3481 10.325 10.7167 10.3284 11.1723Z" fill="#3B97D3"/>
                                        <path d="M7.01809 11.1723V16.5516H5.36292V11.1723C5.36292 10.7152 5.73344 10.3447 6.1905 10.3447C6.64616 10.3481 7.01471 10.7167 7.01809 11.1723Z" fill="#3B97D3"/>
                                        <path d="M3.7077 11.1724V19.0344C3.70634 19.4909 3.33661 19.8607 2.88011 19.862C2.42446 19.8587 2.05591 19.4901 2.05253 19.0344V11.2179C2.0441 10.7782 2.36916 10.4031 2.80563 10.3489C3.0367 10.3293 3.26546 10.4071 3.43673 10.5634C3.608 10.7197 3.70622 10.9405 3.7077 11.1724Z" fill="#3B97D3"/>
                                        <path d="M11.9819 9.51723C11.7534 9.51723 11.5681 9.33197 11.5681 9.10344V8.27585C11.5681 8.04732 11.7534 7.86206 11.9819 7.86206C12.2104 7.86206 12.3957 8.04732 12.3957 8.27585V9.10344C12.3957 9.33197 12.2104 9.51723 11.9819 9.51723Z" fill="#35495E"/>
                                        <path d="M12.8096 8.68965H2.87851C2.64998 8.68965 2.46472 8.50439 2.46472 8.27585C2.46472 8.04732 2.64998 7.86206 2.87851 7.86206H12.8096C13.0381 7.86206 13.2233 8.04732 13.2233 8.27585C13.2233 8.50439 13.0381 8.68965 12.8096 8.68965Z" fill="#95A5A5"/>
                                        <path d="M21.9312 10.3448C21.7027 10.3448 21.5174 10.1595 21.5174 9.931V9.10341C21.5174 8.64635 21.1469 8.27583 20.6898 8.27583H18.6209C18.1638 8.27583 17.7933 8.64635 17.7933 9.10341V9.931C17.7933 10.1595 17.608 10.3448 17.3795 10.3448C17.151 10.3448 16.9657 10.1595 16.9657 9.931V9.10341C16.9657 8.18929 17.7067 7.44824 18.6209 7.44824H20.6898C21.604 7.44824 22.345 8.18929 22.345 9.10341V9.931C22.345 10.1595 22.1597 10.3448 21.9312 10.3448Z" fill="#E57E25"/>
                                        <path d="M5.37948 24.0001H2.46638C2.00932 24.0001 1.63879 23.6296 1.63879 23.1725V21.9312H4.5519V23.1725C4.55326 23.629 4.92299 23.9988 5.37948 24.0001Z" fill="#3F5C6C"/>
                                        <path d="M24.0001 11.1725V15.3105C24.0001 15.9961 23.4443 16.5518 22.7587 16.5518H16.5518C15.8662 16.5518 15.3104 15.9961 15.3104 15.3105V11.1725C15.3113 10.8859 15.4106 10.6084 15.5918 10.3863C15.827 10.0979 16.1796 9.93071 16.5518 9.93115H22.7587C23.4443 9.93115 24.0001 10.4869 24.0001 11.1725Z" fill="#F29C1F"/>
                                        <path d="M21.5173 13.2413C21.2888 13.2413 21.1035 13.0561 21.1035 12.8275V11.5862C21.1035 11.3576 21.2888 11.1724 21.5173 11.1724C21.7458 11.1724 21.9311 11.3576 21.9311 11.5862V12.8275C21.9311 13.0561 21.7458 13.2413 21.5173 13.2413Z" fill="#802F34"/>
                                        <path d="M22.345 11.9999H16.9657C16.7371 11.9999 16.5519 11.8147 16.5519 11.5862C16.5519 11.3576 16.7371 11.1724 16.9657 11.1724H22.345C22.5735 11.1724 22.7588 11.3576 22.7588 11.5862C22.7588 11.8147 22.5735 11.9999 22.345 11.9999Z" fill="#C03A2B"/>
                                        <path d="M23.1725 16.5518H4.96565C4.50915 16.5531 4.13942 16.9228 4.13806 17.3793V23.1724C4.13942 23.6289 4.50915 23.9987 4.96565 24H23.1725C23.629 23.9987 23.9988 23.6289 24.0001 23.1724V17.3793C23.9988 16.9228 23.629 16.5531 23.1725 16.5518Z" fill="#A56A43"/>
                                        <path d="M24.0001 20.2759V21.5173C22.6289 21.5173 21.5174 22.6288 21.5174 24H6.62082C6.62082 22.6288 5.50925 21.5173 4.13806 21.5173V20.2759H7.03461V21.1035C7.03461 21.332 7.21987 21.5173 7.44841 21.5173H8.27599C8.50452 21.5173 8.68979 21.332 8.68979 21.1035V20.2759H10.345C10.345 21.19 11.086 21.9311 12.0001 21.9311H16.1381C17.0522 21.9311 17.7932 21.19 17.7932 20.2759H19.4484V21.1035C19.4484 21.332 19.6337 21.5173 19.8622 21.5173H20.6898C20.9183 21.5173 21.1036 21.332 21.1036 21.1035V20.2759H24.0001Z" fill="#805333"/>
                                        <path d="M6.62082 16.5518C6.62082 17.9229 5.50925 19.0345 4.13806 19.0345V17.3793C4.13942 16.9228 4.50915 16.5531 4.96565 16.5518H6.62082Z" fill="#F3D55B"/>
                                        <path d="M6.62082 24.0001H4.96565C4.50915 23.9987 4.13942 23.629 4.13806 23.1725V21.5173C5.50925 21.5173 6.62082 22.6289 6.62082 24.0001Z" fill="#F3D55B"/>
                                        <path d="M24.0001 17.3793V19.0345C22.6289 19.0345 21.5173 17.9229 21.5173 16.5518H23.1725C23.629 16.5531 23.9987 16.9228 24.0001 17.3793Z" fill="#F3D55B"/>
                                        <path d="M24.0001 21.5173V23.1725C23.9987 23.629 23.629 23.9987 23.1725 24.0001H21.5173C21.5173 23.3416 21.7789 22.7101 22.2445 22.2445C22.7101 21.7789 23.3416 21.5173 24.0001 21.5173Z" fill="#F3D55B"/>
                                        <path d="M17.7932 19.4482V20.2758C17.7932 21.1899 17.0522 21.9309 16.1381 21.9309H12.0001C11.086 21.9309 10.345 21.1899 10.345 20.2758V19.4482C10.345 18.9911 10.7155 18.6206 11.1726 18.6206C11.6296 18.6206 12.0001 18.9911 12.0001 19.4482V20.2758H16.1381V19.4482C16.1381 18.9911 16.5086 18.6206 16.9657 18.6206C17.4227 18.6206 17.7932 18.9911 17.7932 19.4482Z" fill="#F3D55B"/>
                                        <path d="M8.27593 19.0344H7.44834C7.21981 19.0344 7.03455 19.2197 7.03455 19.4482V21.1034C7.03455 21.3319 7.21981 21.5172 7.44834 21.5172H8.27593C8.50446 21.5172 8.68972 21.3319 8.68972 21.1034V19.4482C8.68972 19.2197 8.50446 19.0344 8.27593 19.0344Z" fill="#BDC3C7"/>
                                        <path d="M20.6897 19.0344H19.8622C19.6336 19.0344 19.4484 19.2197 19.4484 19.4482V21.1034C19.4484 21.3319 19.6336 21.5172 19.8622 21.5172H20.6897C20.9183 21.5172 21.1035 21.3319 21.1035 21.1034V19.4482C21.1035 19.2197 20.9183 19.0344 20.6897 19.0344Z" fill="#BDC3C7"/>
                                    </svg>
                                </div>
                                Change Password
                              </a> 
                          </li>

                          <li>
                              <a href="<?php echo e(url('/pegawai')); ?>">
                                  <div class="icon-box bg_surface_color">
                                      <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <path d="M7.14721 0H16.717C17.152 0 17.5047 0.288097 17.5047 0.643459V2.41376C17.5047 2.76912 17.152 3.05722 16.717 3.05722H15.5176L13.9173 3.91499H8.77838L7.14721 3.05722C6.7122 3.05722 6.35956 2.76912 6.35956 2.41376V0.643459C6.35956 0.288097 6.7122 0 7.14721 0V0Z" fill="#FABE2C"/>
                                          <path d="M16.717 0H11.75V3.05722L12.2187 3.91504H13.9174L15.5176 3.05726H16.717C17.152 3.05726 17.5047 2.76917 17.5047 2.4138V0.643459C17.5047 0.288097 17.152 0 16.717 0V0Z" fill="#FF9100"/>
                                          <path d="M5.94777 3.05713H15.5176C15.9526 3.05713 16.3052 3.34523 16.3052 3.70059V5.47089C16.3052 5.82625 15.9526 6.11435 15.5176 6.11435L14.3112 6.54321H8.3845L7.14718 6.11435H5.94777C5.51277 6.11435 5.16013 5.82625 5.16013 5.47089V3.70064C5.16017 3.34523 5.51282 3.05713 5.94777 3.05713Z" fill="#FFE666"/>
                                          <path d="M15.5176 3.05713H11.75V6.11432L12.2187 6.54318H14.3113L15.5176 6.11432C15.9526 6.11432 16.3052 5.82622 16.3052 5.47086V3.70063C16.3052 3.34522 15.9526 3.05713 15.5176 3.05713Z" fill="#FABE2C"/>
                                          <path d="M7.06285 6.1145H16.8014C17.1898 6.1145 17.5046 6.42936 17.5046 6.81777V8.46845C17.5046 8.85686 17.1898 9.17172 16.8014 9.17172L11.9321 10.1092L7.0628 9.17172C6.67439 9.17172 6.35953 8.85686 6.35953 8.46845V6.81777C6.35957 6.42936 6.67444 6.1145 7.06285 6.1145Z" fill="#FABE2C"/>
                                          <path d="M16.8014 6.1145H11.75V9.17177L11.9321 10.1093L16.8014 9.17177C17.1898 9.17177 17.5046 8.8569 17.5046 8.46849V6.81782C17.5047 6.42937 17.1898 6.1145 16.8014 6.1145Z" fill="#FF9100"/>
                                          <path d="M19.4778 9.17163H4.11213C3.74139 9.17163 3.44083 9.4722 3.44083 9.84293V13.2938C3.44083 13.6645 3.74139 13.9651 4.11213 13.9651C4.48287 13.9651 4.78343 13.6645 4.78343 13.2938V10.5142H11.0787V13.2938C11.0787 13.6645 11.3793 13.9651 11.75 13.9651C12.1208 13.9651 12.4213 13.6645 12.4213 13.2938V10.5142H18.8065V13.2938C18.8065 13.6645 19.1071 13.9651 19.4778 13.9651C19.8485 13.9651 20.1491 13.6645 20.1491 13.2938V9.84293C20.1491 9.47215 19.8485 9.17163 19.4778 9.17163Z" fill="#5C7099"/>
                                          <path d="M7.93107 20.827C7.93107 18.9625 6.51173 17.4297 4.6946 17.2497C5.73055 16.9889 6.49823 16.0427 6.49823 14.915C6.49823 13.5861 5.43223 12.5088 4.11728 12.5088C2.80233 12.5088 1.73634 13.5861 1.73634 14.915C1.73634 16.0418 2.50275 16.9874 3.53743 17.2491C1.7166 17.4255 0.293182 18.9598 0.293182 20.8269V23.3288C0.293182 23.6995 0.593701 24 0.964392 24H8.86858L7.93107 20.827Z" fill="#9EE2F8"/>
                                          <path d="M19.4778 9.17163H11.75V12.5086L12.4213 13.2937V10.5142H18.8065V13.2937C18.8065 13.6645 19.107 13.965 19.4778 13.965C19.8485 13.965 20.1491 13.6645 20.1491 13.2937V9.84289C20.1491 9.47215 19.8485 9.17163 19.4778 9.17163Z" fill="#404A80"/>
                                          <path d="M19.9704 17.2497C21.0063 16.9889 21.774 16.0427 21.774 14.915C21.774 13.5861 20.708 12.5088 19.393 12.5088C18.0781 12.5088 17.0121 13.5861 17.0121 14.915C17.0121 16.0418 17.7786 16.9874 18.8132 17.2491C16.9924 17.4255 15.5689 18.9598 15.5689 20.8269L14.6314 24H22.5357C22.9064 24 23.2069 23.6995 23.2069 23.3288V20.8269C23.2068 18.9625 21.7875 17.4297 19.9704 17.2497Z" fill="#E62E6B"/>
                                          <path d="M12.2773 17.2625C13.341 17.0219 14.1361 16.0626 14.1361 14.915C14.1361 13.5861 13.0701 12.5088 11.7552 12.5088C10.4402 12.5088 9.37423 13.5861 9.37423 14.915C9.37423 16.0613 10.1676 17.0197 11.2294 17.2617C9.37034 17.492 7.93103 19.0761 7.93103 20.9975V24.0001H15.5689V20.9974C15.569 19.0784 14.1331 17.4958 12.2773 17.2625Z" fill="#00DD80"/>
                                          <path d="M12.2773 17.2625C13.341 17.0219 14.1361 16.0626 14.1361 14.9151C14.1361 13.5844 13.0674 12.506 11.7501 12.5088C11.7501 12.5088 11.75 12.5089 11.75 12.5089V24H15.569V20.9974C15.569 19.0784 14.1331 17.4958 12.2773 17.2625Z" fill="#00AA95"/>
                                          </svg>
                                          
                                  </div>
                                  Pegawai
                              </a> 
                          </li> 

                          

                          <li>
                              <a href="<?php echo e(url('/payroll')); ?>">
                              <div class="icon-box bg_service-8">
                                  <svg width="25" height="22" viewBox="0 0 25 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                      <path d="M22.7003 14.8487L6.19428 17.7592C5.17447 17.939 4.202 17.258 4.02219 16.2383L2.20531 5.93436C2.0255 4.91454 2.70645 3.94208 3.72622 3.76226L20.2322 0.851795C21.252 0.671982 22.2245 1.35294 22.4043 2.3727L24.2212 12.6766C24.401 13.6964 23.7201 14.6689 22.7003 14.8487Z" fill="#3555A2"/>
                                      <path d="M20.2322 0.851795L11.9792 2.30703L14.4473 16.304L22.7003 14.8488C23.7201 14.669 24.401 13.6965 24.2212 12.6767L22.4043 2.37275C22.2245 1.35294 21.2521 0.671982 20.2322 0.851795Z" fill="#1B3555"/>
                                      <path d="M18.5312 21.177H2.125C1.08948 21.177 0.25 20.3375 0.25 19.302V9.09644C0.25 8.06092 1.08948 7.22144 2.125 7.22144H18.5312C19.5668 7.22144 20.4062 8.06092 20.4062 9.09644V19.302C20.4062 20.3375 19.5668 21.177 18.5312 21.177Z" fill="#53D8E3"/>
                                      <path d="M18.5312 7.22144H10.3281V21.177H18.5312C19.5668 21.177 20.4062 20.3375 20.4062 19.302V9.09644C20.4062 8.06092 19.5668 7.22144 18.5312 7.22144Z" fill="#18A8C9"/>
                                      <path d="M0.25 10.4111H20.4062V13.601H0.25V10.4111Z" fill="#ECF6FD"/>
                                      <path d="M5.83218 18.0813H2.64233C2.25402 18.0813 1.93921 18.3961 1.93921 18.7844C1.93921 19.1727 2.25402 19.4875 2.64233 19.4875H5.83218C6.22049 19.4875 6.5353 19.1727 6.5353 18.7844C6.5353 18.3961 6.22049 18.0813 5.83218 18.0813Z" fill="#EAF6FF"/>
                                      <path d="M10.3281 10.4111H20.4062V13.601H10.3281V10.4111Z" fill="#D6E8FE"/>
                                      </svg>
                                      
                              </div>
                              Payroll
                              </a>
                          </li>
                          
                          <li>
                              <a href="<?php echo e(url('/my-dokumen')); ?>">
                              <div class="icon-box bg_service-2">
                                  <svg width="20" height="24" viewBox="0 0 20 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                      <path d="M10.0833 3.25424C9.85864 3.25424 9.67651 3.07212 9.67651 2.84746V0.40678C9.67651 0.182121 9.85864 0 10.0833 0C10.308 0 10.4901 0.182121 10.4901 0.40678V2.84746C10.4901 3.07212 10.308 3.25424 10.0833 3.25424Z" fill="#F0C419"/>
                                      <path d="M12.9308 3.66102C12.7061 3.66102 12.524 3.4789 12.524 3.25424V0.40678C12.524 0.182121 12.7061 0 12.9308 0C13.1554 0 13.3375 0.182121 13.3375 0.40678V3.25424C13.3375 3.4789 13.1554 3.66102 12.9308 3.66102Z" fill="#F0C419"/>
                                      <path d="M15.7782 4.88135C15.5536 4.88135 15.3715 4.69923 15.3715 4.47457V2.84745C15.3715 2.6228 15.5536 2.44067 15.7782 2.44067C16.0029 2.44067 16.185 2.6228 16.185 2.84745V4.47457C16.185 4.69923 16.0029 4.88135 15.7782 4.88135Z" fill="#F0C419"/>
                                      <path d="M15.7782 1.62712C15.5536 1.62712 15.3715 1.445 15.3715 1.22034V0.40678C15.3715 0.182121 15.5536 0 15.7782 0C16.0029 0 16.185 0.182121 16.185 0.40678V1.22034C16.185 1.445 16.0029 1.62712 15.7782 1.62712Z" fill="#F0C419"/>
                                      <path d="M18.6257 11.7966C18.401 11.7966 18.2189 11.6145 18.2189 11.3899V2.44072C18.2189 2.21606 18.401 2.03394 18.6257 2.03394C18.8503 2.03394 19.0324 2.21606 19.0324 2.44072V11.3899C19.0324 11.6145 18.8503 11.7966 18.6257 11.7966Z" fill="#F0C419"/>
                                      <path d="M7.23582 3.66102C7.01116 3.66102 6.82904 3.4789 6.82904 3.25424V0.40678C6.82904 0.182121 7.01116 0 7.23582 0C7.46048 0 7.6426 0.182121 7.6426 0.40678V3.25424C7.6426 3.4789 7.46048 3.66102 7.23582 3.66102Z" fill="#F0C419"/>
                                      <path d="M4.38841 4.88135C4.16375 4.88135 3.98163 4.69923 3.98163 4.47457V2.84745C3.98163 2.6228 4.16375 2.44067 4.38841 2.44067C4.61307 2.44067 4.79519 2.6228 4.79519 2.84745V4.47457C4.79519 4.69923 4.61307 4.88135 4.38841 4.88135Z" fill="#F0C419"/>
                                      <path d="M4.38841 1.62712C4.16375 1.62712 3.98163 1.445 3.98163 1.22034V0.40678C3.98163 0.182121 4.16375 0 4.38841 0C4.61307 0 4.79519 0.182121 4.79519 0.40678V1.22034C4.79519 1.445 4.61307 1.62712 4.38841 1.62712Z" fill="#F0C419"/>
                                      <path d="M1.54093 11.7966C1.31628 11.7966 1.13416 11.6145 1.13416 11.3899V2.44072C1.13416 2.21606 1.31628 2.03394 1.54093 2.03394C1.76559 2.03394 1.94771 2.21606 1.94771 2.44072V11.3899C1.94771 11.6145 1.76559 11.7966 1.54093 11.7966Z" fill="#F0C419"/>
                                      <path d="M10.0833 24C15.4751 24 19.846 19.6291 19.846 14.2373C19.846 8.84552 15.4751 4.47461 10.0833 4.47461C4.69153 4.47461 0.320618 8.84552 0.320618 14.2373C0.320618 19.6291 4.69153 24 10.0833 24Z" fill="#F29C1F"/>
                                      <path d="M10.0833 22.373C14.5765 22.373 18.2189 18.7306 18.2189 14.2374C18.2189 9.74424 14.5765 6.10181 10.0833 6.10181C5.59018 6.10181 1.94775 9.74424 1.94775 14.2374C1.94775 18.7306 5.59018 22.373 10.0833 22.373Z" fill="#F0C419"/>
                                      <path d="M10.0833 22.7797C5.36762 22.7745 1.54609 18.953 1.54093 14.2373C1.53692 12.9018 1.84946 11.5843 2.45293 10.3928C2.5156 10.2584 2.64646 10.1688 2.79444 10.1589C2.94242 10.149 3.08406 10.2204 3.16409 10.3452C3.24411 10.4701 3.24984 10.6286 3.17903 10.759C2.63325 11.837 2.35068 13.029 2.35449 14.2373C2.35449 17.1648 4.00848 19.841 6.62687 21.1502C9.24527 22.4594 12.3786 22.1769 14.7206 20.4204C14.8369 20.3332 14.9908 20.3146 15.1245 20.3717C15.2581 20.4288 15.3511 20.5529 15.3685 20.6971C15.3859 20.8414 15.325 20.984 15.2087 21.0712C13.7325 22.1849 11.9325 22.7849 10.0833 22.7797Z" fill="#E57E25"/>
                                      <path d="M17.3386 18.3277C17.1973 18.3275 17.0662 18.254 16.9924 18.1334C16.9186 18.0129 16.9126 17.8627 16.9766 17.7367C17.5294 16.6532 17.8158 15.4535 17.8121 14.2372C17.8121 11.3097 16.1582 8.63351 13.5398 7.32431C10.9214 6.01511 7.788 6.29764 5.44604 8.05412C5.26631 8.18891 5.01134 8.15249 4.87655 7.97276C4.74175 7.79304 4.77818 7.53807 4.9579 7.40327C8.1358 5.0217 12.5356 5.1436 15.5768 7.69747C18.618 10.2513 19.4987 14.5639 17.7023 18.1056C17.6327 18.2423 17.492 18.3282 17.3386 18.3277Z" fill="#E57E25"/>
                                      <path d="M10.8289 8.62117L11.9492 10.9829C12.0659 11.2364 12.301 11.4153 12.5765 11.4601L15.0619 11.8351C15.3845 11.8993 15.6458 12.1356 15.7418 12.4503C15.8378 12.7649 15.753 13.1069 15.5211 13.3402L13.7382 15.1471C13.5366 15.3549 13.446 15.6463 13.4942 15.9318L13.9172 18.4945C13.9854 18.8123 13.8651 19.1411 13.6079 19.3399C13.3507 19.5387 13.0023 19.5722 12.7119 19.426L10.4665 18.1988C10.2276 18.0674 9.93817 18.0674 9.69931 18.1988L7.45388 19.426C7.16352 19.5722 6.81506 19.5387 6.55786 19.3399C6.30067 19.1411 6.18039 18.8123 6.24859 18.4945L6.67165 15.9318C6.71982 15.6463 6.62919 15.3549 6.42758 15.1471L4.64466 13.3402C4.4128 13.1069 4.32802 12.7649 4.42403 12.4503C4.52003 12.1356 4.78127 11.8993 5.10392 11.8351L7.58934 11.4601C7.86508 11.4155 8.10056 11.2366 8.21741 10.9829L9.33768 8.62361C9.4666 8.32693 9.75903 8.13481 10.0825 8.13428C10.406 8.13375 10.699 8.32491 10.8289 8.62117Z" fill="#F29C1F"/>
                                  </svg> 
                              </div>
                              Dokumen
                              </a> 
                          </li>

                          <li>
                              <a href="<?php echo e(url('/kasbon')); ?>">
                                  <div class="icon-box bg_service-3">
                                      <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <path d="M23.1834 10.0255H23.1572H3.01642L13.0996 3.63647L14.5332 4.55682H14.5344C14.4507 4.85654 14.4064 5.17262 14.4064 5.4984C14.4064 7.45252 16.0002 9.04571 17.9531 9.04571C18.8352 9.04571 19.6434 8.72054 20.2658 8.18419L23.1834 10.0255Z" fill="#E4E8EB"/>
                                          <path d="M23.1573 10.0256V12.0884H22.308H19.5172H18.4858H15.695H10.4775H7.74743H6.71604H3.92529H3.01526V10.0256H3.01643H23.1573Z" fill="#CAD0D7"/>
                                          <path d="M22.3079 12.0884V12.9984H21.7012H20.1239H19.5172V12.0884H22.3079Z" fill="#E4E8EB"/>
                                          <path d="M20.1239 12.9983H21.7012V21.9166H20.1239V12.9983Z" fill="#CAD0D7"/>
                                          <path d="M20.2658 8.18416C19.6433 8.72051 18.8352 9.04568 17.9531 9.04568C16.0002 9.04568 14.4064 7.45249 14.4064 5.49837C14.4064 5.17258 14.4507 4.85651 14.5344 4.55679C14.9481 3.05829 16.3259 1.95288 17.9531 1.95288C19.906 1.95288 21.5004 3.54485 21.5004 5.49837C21.5004 6.57035 21.0205 7.53316 20.2658 8.18416Z" fill="#FDCD56"/>
                                          <path d="M20.1239 12.9984V21.9168H17.8791V12.9984H18.4858V12.0884H19.5172V12.9984H20.1239Z" fill="#636C77"/>
                                          <path d="M18.4858 12.0884V12.9984H17.8791H16.3017H15.695V12.0884H18.4858Z" fill="#E4E8EB"/>
                                          <path d="M16.3018 12.9983H17.8791V21.9166H16.3018V12.9983Z" fill="#CAD0D7"/>
                                          <path d="M16.3017 12.9984V21.9168H15.2097V16.2139H11.0235V21.9168H9.87079V12.9984H10.4775V12.0884H15.695V12.9984H16.3017Z" fill="#636C77"/>
                                          <path d="M11.0235 16.2139H15.2097V21.9167H11.0235V16.2139Z" fill="#424852"/>
                                          <path d="M13.8628 0.687988C14.2839 0.687988 14.626 1.03139 14.626 1.45121C14.626 1.87285 14.2839 2.21443 13.8628 2.21443C13.443 2.21443 13.0996 1.87285 13.0996 1.45121C13.0996 1.03135 13.443 0.687988 13.8628 0.687988Z" fill="#F76C82"/>
                                          <path d="M10.4775 12.0884V12.9984H9.87083H8.35409H7.74744V12.0884H10.4775Z" fill="#E4E8EB"/>
                                          <path d="M8.35406 12.9983H9.8708V21.9166H8.35406V12.9983Z" fill="#CAD0D7"/>
                                          <path d="M8.35406 12.9984V21.9168H6.10931V12.9984H6.71602V12.0884H7.74741V12.9984H8.35406Z" fill="#636C77"/>
                                          <path d="M6.71604 12.0884V12.9984H6.10934H4.53195H3.92529V12.0884H6.71604Z" fill="#E4E8EB"/>
                                          <path d="M4.53192 12.9983H6.10931V21.9166H4.53192V12.9983Z" fill="#CAD0D7"/>
                                          <path d="M23.1573 21.6094H17.0904H15.2097H11.0235H9.08209H3.01524C2.84771 21.6094 2.71191 21.7465 2.71191 21.9141C2.71191 22.0816 2.84766 22.2188 3.01524 22.2188H9.08213H11.0236H15.2097H17.0904H23.1573C23.3249 22.2188 23.4607 22.0816 23.4607 21.9141C23.4607 21.7465 23.3248 21.6094 23.1573 21.6094Z" fill="#424852"/>
                                          <path d="M23.1573 23.3121H3.01524C2.84771 23.3121 2.71191 23.1763 2.71191 23.0087C2.71191 22.8411 2.84766 22.7053 3.01524 22.7053H23.1573C23.3248 22.7053 23.4607 22.8411 23.4607 23.0087C23.4607 23.1763 23.3248 23.3121 23.1573 23.3121Z" fill="#424852"/>
                                          <path d="M18.1669 5.18951C17.6911 5.02053 17.5613 4.80799 17.5729 4.73154C17.5824 4.66971 17.7095 4.57835 17.961 4.56884C18.1292 4.5634 18.317 4.59288 18.5193 4.6564C18.679 4.70656 18.8494 4.61763 18.8995 4.45779C18.9497 4.29795 18.8695 4.1277 18.7096 4.07754C18.5524 4.02823 18.3542 3.99504 18.2604 3.97718V3.59463C18.2604 3.4271 18.1232 3.29126 17.9557 3.29126C17.7882 3.29126 17.651 3.4271 17.651 3.59463V4.00517C17.276 4.09709 17.0281 4.32851 16.9804 4.6399C16.9266 4.99273 17.1548 5.47263 17.9676 5.76129C18.2909 5.87595 18.421 6.02435 18.4084 6.12054C18.3961 6.21438 18.2571 6.34957 18.0225 6.39804C17.9963 6.39068 17.9688 6.38543 17.9402 6.38543C17.8939 6.38543 17.8502 6.39663 17.811 6.4152C17.6533 6.41051 17.4895 6.36753 17.3316 6.28728C17.1823 6.21148 16.9996 6.27096 16.9237 6.42031C16.8478 6.56965 16.9147 6.75228 17.064 6.82817C17.2518 6.9236 17.4635 6.98459 17.651 7.00976V7.35617C17.651 7.5237 17.7881 7.65949 17.9557 7.65949C18.1232 7.65949 18.2604 7.5237 18.2604 7.35617V6.9671C18.6822 6.84907 18.9702 6.55371 19.0167 6.19953C19.0377 6.04001 19.0303 5.49579 18.1669 5.18951Z" fill="white"/>
                                          <path d="M4.6533 6.68873H3.13657C2.96903 6.68873 2.83319 6.55289 2.83319 6.38536C2.83319 6.21783 2.96899 6.08203 3.13657 6.08203H4.65325C4.82078 6.08203 4.95663 6.21783 4.95663 6.38536C4.95663 6.55289 4.82083 6.68873 4.6533 6.68873Z" fill="#424852"/>
                                          <path d="M3.92528 7.41689C3.75774 7.41689 3.62195 7.28105 3.62195 7.11352V5.59683C3.62195 5.4293 3.7577 5.29346 3.92528 5.29346C4.09285 5.29346 4.22865 5.4293 4.22865 5.59683V7.11352C4.2286 7.28105 4.09281 7.41689 3.92528 7.41689Z" fill="#424852"/>
                                          <path d="M24.6133 14.8792H23.036C22.8684 14.8792 22.7326 14.7434 22.7326 14.5758C22.7326 14.4083 22.8684 14.2725 23.036 14.2725H24.6133C24.7809 14.2725 24.9167 14.4083 24.9167 14.5758C24.9167 14.7434 24.7809 14.8792 24.6133 14.8792Z" fill="#424852"/>
                                          <path d="M23.8246 15.6679C23.6571 15.6679 23.5213 15.5321 23.5213 15.3645V13.8478C23.5213 13.6803 23.6571 13.5444 23.8246 13.5444C23.9922 13.5444 24.128 13.6802 24.128 13.8478V15.3645C24.128 15.5321 23.9922 15.6679 23.8246 15.6679Z" fill="#424852"/>
                                          <path d="M2.74825 21.1504C2.67067 21.1504 2.59304 21.1208 2.53384 21.0617L1.00567 19.5353C0.887121 19.4169 0.887027 19.2248 1.00539 19.1063C1.12365 18.9878 1.3157 18.9876 1.43434 19.106L2.96265 20.6325C3.08115 20.7509 3.0812 20.943 2.96284 21.0615C2.90364 21.1208 2.82592 21.1504 2.74825 21.1504Z" fill="#424852"/>
                                          <path d="M1.22009 21.1505C1.14237 21.1505 1.0647 21.1208 1.00545 21.0615C0.887088 20.943 0.887182 20.7509 1.00573 20.6325L2.5339 19.1061C2.6524 18.9877 2.84445 18.9877 2.9629 19.1063C3.08126 19.2248 3.08121 19.4169 2.96271 19.5353L1.4344 21.0618C1.37515 21.1209 1.29762 21.1505 1.22009 21.1505Z" fill="#424852"/>
                                          <path d="M24.2517 21.0771C24.174 21.0771 24.0963 21.0474 24.0371 20.9881L22.5107 19.4593C22.3923 19.3407 22.3924 19.1487 22.511 19.0303C22.6297 18.9119 22.8217 18.9122 22.94 19.0306L24.4664 20.5595C24.5847 20.678 24.5846 20.8701 24.466 20.9884C24.4069 21.0476 24.3294 21.0771 24.2517 21.0771Z" fill="#424852"/>
                                          <path d="M22.7253 21.0772C22.6478 21.0772 22.5702 21.0476 22.511 20.9885C22.3924 20.8701 22.3923 20.6781 22.5107 20.5596L24.0371 19.0307C24.1554 18.9122 24.3474 18.9119 24.4661 19.0303C24.5846 19.1487 24.5847 19.3408 24.4664 19.4593L22.94 20.9881C22.8807 21.0475 22.8031 21.0772 22.7253 21.0772Z" fill="#424852"/>
                                      </svg>
                                  </div>
                                  Kasbon
                              </a> 
                          </li>

                          

                          

                           
                          
                          <li>
                              <a href="<?php echo e(url('/my-absen')); ?>">
                              <div class="icon-box bg_color_1">
                                  <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                      <g clip-path="url(#clip0_4355_17017)">
                                      <rect x="6.375" y="2" width="12" height="19" fill="white"/>
                                      <path d="M17.7247 0H7.02484C6.13341 0 5.40381 0.728914 5.40381 1.62103V22.3783C5.40381 23.2704 6.13341 24 7.02484 24H17.7247C18.6161 24 19.3457 23.2718 19.3457 22.379V1.62103C19.3457 0.728914 18.6161 0 17.7247 0ZM10.6632 1.16846H14.0863C14.1947 1.16846 14.2824 1.25623 14.2824 1.36526C14.2824 1.4736 14.1947 1.56137 14.0863 1.56137H10.6632C10.5549 1.56137 10.4671 1.4736 10.4671 1.36526C10.4671 1.25623 10.5549 1.16846 10.6632 1.16846ZM12.3748 23.1895C11.927 23.1895 11.5643 22.8267 11.5643 22.3783C11.5643 21.9298 11.927 21.5678 12.3748 21.5678C12.8226 21.5678 13.1853 21.9298 13.1853 22.3783C13.1853 22.8267 12.8226 23.1895 12.3748 23.1895ZM18.2177 21H6.53181V2.57074H18.2177V21Z" fill="#283EB4"/>
                                      <path d="M12.3749 6C13.9704 6 15.4719 6.6175 16.6019 7.7385C16.7979 7.9325 16.7994 8.2495 16.6049 8.445C16.5074 8.5435 16.3784 8.593 16.2499 8.593C16.1229 8.593 15.9954 8.5445 15.8979 8.448C14.9564 7.5145 13.7049 7 12.3749 7C11.0449 7 9.79344 7.5145 8.85194 8.4485C8.65644 8.643 8.33944 8.642 8.14494 8.4455C7.95044 8.2495 7.95194 7.9325 8.14794 7.7385C9.27794 6.6175 10.7794 6 12.3749 6Z" fill="#39A3F8"/>
                                      <path d="M11.25 12.75H10C9.793 12.75 9.625 12.918 9.625 13.125C9.625 13.332 9.793 13.5 10 13.5H11.25C11.319 13.5 11.375 13.556 11.375 13.625V14.375H10C9.793 14.375 9.625 14.543 9.625 14.75C9.625 14.957 9.793 15.125 10 15.125H11.375V15.875C11.375 15.944 11.319 16 11.25 16H10C9.793 16 9.625 16.168 9.625 16.375C9.625 16.582 9.793 16.75 10 16.75H11.25C11.7325 16.75 12.125 16.3575 12.125 15.875V13.625C12.125 13.1425 11.7325 12.75 11.25 12.75Z" fill="#39A3F8"/>
                                      <path d="M14.75 14.5H14C13.793 14.5 13.625 14.668 13.625 14.875C13.625 15.082 13.793 15.25 14 15.25H14.375V16H13.5C13.431 16 13.375 15.944 13.375 15.875V13.625C13.375 13.556 13.431 13.5 13.5 13.5H14.75C14.957 13.5 15.125 13.332 15.125 13.125C15.125 12.918 14.957 12.75 14.75 12.75H13.5C13.0175 12.75 12.625 13.1425 12.625 13.625V15.875C12.625 16.3575 13.0175 16.75 13.5 16.75H14.75C14.957 16.75 15.125 16.582 15.125 16.375V14.875C15.125 14.668 14.957 14.5 14.75 14.5Z" fill="#39A3F8"/>
                                      <path d="M12.3751 7.89099C11.2896 7.89099 10.2671 8.31199 9.49706 9.07649C9.30106 9.27099 9.29956 9.58699 9.49406 9.78299C9.68906 9.97949 10.0051 9.98049 10.2011 9.78599C10.7831 9.20849 11.5551 8.89099 12.3751 8.89099C13.1951 8.89099 13.9671 9.20899 14.5491 9.78649C14.6466 9.88299 14.7736 9.93149 14.9011 9.93149C15.0296 9.93149 15.1586 9.88199 15.2561 9.78349C15.4506 9.58749 15.4491 9.27099 15.2531 9.07649C14.4831 8.31199 13.4606 7.89099 12.3751 7.89099Z" fill="#39A3F8"/>
                                      <path d="M10.8429 10.4165C11.2489 10.0075 11.7929 9.78198 12.3749 9.78198C12.9569 9.78198 13.5009 10.0075 13.9069 10.416C14.1014 10.612 14.1004 10.9285 13.9044 11.123C13.8064 11.22 13.6794 11.2685 13.5519 11.2685C13.4234 11.2685 13.2949 11.2195 13.1974 11.121C12.7629 10.6835 11.9869 10.6835 11.5524 11.121C11.3579 11.3165 11.0414 11.318 10.8454 11.1235C10.6494 10.929 10.6484 10.6125 10.8429 10.4165Z" fill="#39A3F8"/>
                                      </g>
                                      <defs>
                                      <clipPath id="clip0_4355_17017">
                                      <rect width="24" height="24" fill="white" transform="translate(0.375)"/>
                                      </clipPath>
                                      </defs>
                                  </svg>    
                              </div>
                              History Absen
                              </a> 
                          </li>

                          <li>
                              <a href="<?php echo e(url('/my-dinas-luar')); ?>">
                                    <div class="icon-box bg_service-4">
                                        <svg width="23" height="24" viewBox="0 0 23 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M11.6667 22.0593C17.7582 22.0593 22.6964 17.1211 22.6964 11.0296C22.6964 4.93814 17.7582 0 11.6667 0C5.57522 0 0.637085 4.93814 0.637085 11.0296C0.637085 17.1211 5.57522 22.0593 11.6667 22.0593Z" fill="#F7B239"/>
                                            <path d="M11.6668 18.2896C15.6763 18.2896 18.9267 15.0392 18.9267 11.0297C18.9267 7.02015 15.6763 3.76978 11.6668 3.76978C7.65723 3.76978 4.40686 7.02015 4.40686 11.0297C4.40686 15.0392 7.65723 18.2896 11.6668 18.2896Z" fill="#E09B2D"/>
                                            <path d="M21.5902 22.7714C21.6128 22.8559 21.6237 22.941 21.6237 23.0243C21.6237 23.4555 21.3361 23.8495 20.9004 23.9664C20.3801 24.1059 19.8448 23.7969 19.7053 23.2766L18.0658 17.1579C17.9264 16.6377 18.2354 16.1024 18.7556 15.9629C19.2765 15.8235 19.8112 16.1325 19.9507 16.6533L21.5902 22.7714Z" fill="#F24C8F"/>
                                            <path d="M3.35615 17.2773L4.19458 17.502L6.40766 9.24224L5.56923 9.01759L3.35615 17.2773Z" fill="#CCCCCC"/>
                                            <path d="M17.1337 11.5794L18.3372 16.0732L19.1757 15.8487L17.9722 11.3549L17.1337 11.5794Z" fill="#CCCCCC"/>
                                            <path d="M7.56286 3.2568C8.95003 3.62833 9.58139 5.76841 8.97375 8.0358C8.36611 10.3037 6.99398 10.9282 5.60681 10.5566C4.2202 10.1851 3.34406 8.95825 3.9517 6.6903C4.55934 4.42234 6.17625 2.88526 7.56286 3.2568Z" fill="#E6E6E6"/>
                                            <path d="M4.15828 15.9629C4.67911 16.1024 4.9876 16.6377 4.8481 17.158L3.20921 23.2767C3.0923 23.7124 2.69817 24 2.26707 24C2.18372 24 2.09864 23.989 2.01417 23.9665C1.49335 23.827 1.1843 23.2917 1.32375 22.7714L2.96325 16.6533C3.10271 16.1325 3.63802 15.8234 4.15828 15.9629Z" fill="#F24C8F"/>
                                            <path d="M19.2656 9.03291L17.8784 3.85557C17.8236 3.65147 17.6112 3.53157 17.4071 3.5926C17.2096 3.65171 17.1024 3.86644 17.1558 4.06557L18.2618 8.1924C18.3444 8.50102 18.1614 8.81827 17.8527 8.901L17.8522 8.9011C17.5435 8.98393 17.2261 8.80069 17.1434 8.49202L16.0334 4.34968C15.9787 4.14544 15.766 4.02558 15.5619 4.08675C15.3645 4.14596 15.2575 4.36065 15.3108 4.55972L16.4168 8.68693C16.4995 8.9956 16.3163 9.31285 16.0077 9.39563C15.699 9.47832 15.3818 9.29518 15.299 8.9865L14.189 4.84393C14.1343 4.63974 13.9219 4.51993 13.7177 4.58096C13.5202 4.64007 13.4131 4.85475 13.4664 5.05388L14.8494 10.2156C15.0072 10.8056 15.3854 11.2987 15.9143 11.6041C16.2666 11.8075 16.6575 11.9114 17.0537 11.9114C17.2523 11.9114 17.4524 11.8853 17.6494 11.8325C18.647 11.5651 19.3437 10.6577 19.3437 9.62597C19.3437 9.42511 19.3174 9.22529 19.2656 9.03291Z" fill="#E6E6E6"/>
                                        </svg>
                                    </div>
                              
                              History Dinas  
                              </a> 
                          </li>

                          <li>
                              <a href="<?php echo e(url('/my-lembur')); ?>">
                                <div class="icon-box bg_service-2">
                                  <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                      <path d="M23.5002 12.5C23.5017 13.4318 23.3161 14.3545 22.9546 15.2134C22.593 16.0722 22.0627 16.8498 21.3952 17.5H11.6052C10.7799 16.6926 10.1671 15.6936 9.82138 14.592C9.47569 13.4904 9.40784 12.3204 9.6239 11.1862C9.83995 10.052 10.3332 8.98888 11.0597 8.09151C11.7862 7.19415 12.7234 6.49042 13.7877 6.04302C14.8521 5.59561 16.0106 5.41843 17.16 5.52726C18.3095 5.63609 19.4142 6.02754 20.3756 6.66675C21.3371 7.30596 22.1256 8.17307 22.6708 9.19084C23.2159 10.2086 23.5009 11.3454 23.5002 12.5Z" fill="#DE4A8C"/>
                                      <path d="M23.5002 12.4999C23.5016 13.4317 23.3161 14.3544 22.9545 15.2132C22.5929 16.0721 22.0627 16.8496 21.3952 17.4999H14.3952C13.4471 16.9321 12.6469 16.1479 12.0601 15.2115C11.4732 14.2751 11.1164 13.213 11.0189 12.1122C10.9214 11.0114 11.0858 9.9032 11.4988 8.87818C11.9119 7.85317 12.5617 6.9405 13.3952 6.21486C14.4633 5.68623 15.6486 5.43905 16.839 5.49673C18.0293 5.55441 19.1853 5.91504 20.1972 6.54446C21.2092 7.17387 22.0437 8.05123 22.6217 9.09342C23.1997 10.1356 23.5021 11.3081 23.5002 12.4999Z" fill="#F26DA6"/>
                                      <path d="M22.5002 18.5V19.5H10.5002V18.5C10.5002 18.2348 10.6056 17.9804 10.7931 17.7929C10.9807 17.6054 11.235 17.5 11.5002 17.5H21.5002C21.7655 17.5 22.0198 17.6054 22.2074 17.7929C22.3949 17.9804 22.5002 18.2348 22.5002 18.5Z" fill="#F6CCAF"/>
                                      <path d="M22.5003 18.5H12.5003C12.2351 18.5 11.9807 18.3946 11.7932 18.2071C11.6057 18.0196 11.5003 17.7652 11.5003 17.5C11.5003 17.45 11.0553 17.5 21.5003 17.5C21.7655 17.5 22.0199 17.6054 22.2074 17.7929C22.3949 17.9804 22.5003 18.2348 22.5003 18.5Z" fill="#FFDEC7"/>
                                      <path d="M0.500244 13.5H7.50025V15.5H0.500244V13.5Z" fill="#374F68"/>
                                      <path d="M7.50024 13.5V14.5H2.50024C2.23503 14.5 1.98067 14.3946 1.79314 14.2071C1.6056 14.0196 1.50024 13.7652 1.50024 13.5H7.50024Z" fill="#425B72"/>
                                      <path d="M7.50025 15.5C7.50025 22.565 7.52524 22.125 7.43525 22.435C7.34193 22.743 7.15205 23.0127 6.89365 23.2045C6.63525 23.3963 6.32203 23.4999 6.00024 23.5H2.00024C1.60242 23.5 1.22089 23.342 0.939584 23.0607C0.658279 22.7794 0.500244 22.3978 0.500244 22V15.5H7.50025Z" fill="#374F68"/>
                                      <path d="M7.50024 15.5C7.50024 22.565 7.52524 22.125 7.43524 22.435C7.29389 22.4764 7.14753 22.4983 7.00024 22.5C5.54155 22.5 4.14261 21.9205 3.11116 20.8891C2.07971 19.8576 1.50024 18.4587 1.50024 17V15.5H7.50024Z" fill="#425B72"/>
                                      <path d="M1.50024 8.5H6.50024V13.5H1.50024V8.5Z" fill="#374F68"/>
                                      <path d="M6.50025 8.5C6.50025 12.775 6.45025 12.5 6.50025 12.5C5.43938 12.5 4.42196 12.0786 3.67182 11.3284C2.92167 10.5783 2.50024 9.56087 2.50024 8.5H6.50025Z" fill="#425B72"/>
                                      <path d="M6.00025 1.55493V8.49993H2.00024V3.44493C3.26024 2.85493 2.40524 3.25993 6.00025 1.55493Z" fill="#DB5669"/>
                                      <path d="M6.00024 1.55493V7.49993H4.00024C3.73503 7.49993 3.48067 7.39458 3.29314 7.20704C3.1056 7.0195 3.00024 6.76515 3.00024 6.49993V2.99993L6.00024 1.55493Z" fill="#F26674"/>
                                      <path d="M21.5002 12.5C21.5009 13.4028 21.2571 14.2888 20.7947 15.0642C20.3324 15.8396 19.6687 16.4753 18.8742 16.9039C18.0797 17.3325 17.184 17.538 16.2821 17.4987C15.3802 17.4593 14.5058 17.1764 13.7517 16.6802C12.9976 16.1839 12.3919 15.4928 11.9989 14.68C11.6059 13.8673 11.4403 12.9634 11.5196 12.0641C11.5989 11.1648 11.9202 10.3038 12.4494 9.57245C12.9786 8.84107 13.6959 8.2666 14.5252 7.91001C15.2856 7.5831 16.1151 7.45004 16.9396 7.52276C17.764 7.59548 18.5575 7.8717 19.2488 8.32666C19.9402 8.78162 20.5078 9.40107 20.9007 10.1295C21.2937 10.8579 21.4997 11.6724 21.5002 12.5Z" fill="#9FDBF3"/>
                                      <path d="M21.5003 12.5C21.5029 13.1683 21.3714 13.8303 21.1138 14.4469C20.8562 15.0635 20.4775 15.6222 20.0003 16.09C19.3697 16.3652 18.6883 16.5048 18.0003 16.5C17.0052 16.499 16.0331 16.201 15.2083 15.6444C14.3835 15.0877 13.7436 14.2975 13.3704 13.3751C12.9972 12.4526 12.9078 11.4398 13.1135 10.4662C13.3193 9.49267 13.8108 8.60263 14.5253 7.91001C15.2856 7.5831 16.1152 7.45004 16.9396 7.52276C17.764 7.59548 18.5575 7.8717 19.2489 8.32666C19.9402 8.78162 20.5078 9.40107 20.9008 10.1295C21.2937 10.8579 21.4997 11.6724 21.5003 12.5Z" fill="#B2E5FB"/>
                                      <path d="M5.92531 2.0649C5.45531 3.8099 3.17031 5.0999 2.2853 4.2149C1.6053 3.5349 2.2253 2.2149 2.97031 1.4699C4.54531 -0.0951043 6.41031 0.334896 5.92531 2.0649Z" fill="#DB5669"/>
                                      <path d="M5.92525 2.06495C4.50025 4.07995 2.00025 3.90995 2.57525 1.93495C4.00025 -0.0550495 6.50025 0.0749506 5.92525 2.06495Z" fill="#F26674"/>
                                      <path d="M23.5002 19.5C23.5002 22.115 23.5352 22.18 23.4102 22.5C23.3071 22.7918 23.1162 23.0445 22.8638 23.2235C22.6113 23.4026 22.3097 23.4991 22.0002 23.5H11.0002C10.6024 23.5 10.2209 23.342 9.93958 23.0607C9.65828 22.7794 9.50024 22.3978 9.50024 22V19.5H23.5002Z" fill="#DE4A8C"/>
                                      <path d="M23.5002 19.5C23.5002 22.115 23.5352 22.18 23.4102 22.5H12.5002C12.1024 22.5 11.7209 22.342 11.4396 22.0607C11.1583 21.7794 11.0002 21.3978 11.0002 21V19.5H23.5002Z" fill="#F26DA6"/>
                                      <path d="M19.0002 19.5L18.6902 20.745C18.6357 20.9609 18.5107 21.1524 18.3349 21.2891C18.1592 21.4259 17.9429 21.5001 17.7202 21.5H15.2802C15.0576 21.5001 14.8413 21.4259 14.6655 21.2891C14.4898 21.1524 14.3648 20.9609 14.3102 20.745L14.0002 19.5H19.0002Z" fill="#DE4A8C"/>
                                      <path d="M19.0002 19.5C18.7352 20.555 18.7702 20.5 18.7202 20.5H16.2802C16.0576 20.5001 15.8413 20.4259 15.6655 20.2891C15.4898 20.1524 15.3648 19.9609 15.3102 19.745L15.2502 19.5H19.0002Z" fill="#F26DA6"/>
                                  </svg>    
                                </div>
                                History Lembur
                              </a> 
                          </li>

                          <li>
                            <a href="<?php echo e(url('/euforia')); ?>">
                                <div class="icon-box bg_service-8">
                                  <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                      <path d="M23.875 12V15.375C23.8744 15.5737 23.7952 15.7642 23.6547 15.9047C23.5142 16.0452 23.3237 16.1244 23.125 16.125H17.875C17.6763 16.1244 17.4858 16.0452 17.3453 15.9047C17.2048 15.7642 17.1256 15.5737 17.125 15.375V13.125C17.1256 12.9263 17.2048 12.7358 17.3453 12.5953C17.4858 12.4548 17.6763 12.3756 17.875 12.375H22.375V11.25H23.125C23.3237 11.2506 23.5142 11.3298 23.6547 11.4703C23.7952 11.6108 23.8744 11.8013 23.875 12ZM19.75 14.25C19.75 14.1017 19.706 13.9567 19.6236 13.8333C19.5412 13.71 19.4241 13.6139 19.287 13.5571C19.15 13.5003 18.9992 13.4855 18.8537 13.5144C18.7082 13.5433 18.5746 13.6148 18.4697 13.7197C18.3648 13.8246 18.2933 13.9582 18.2644 14.1037C18.2355 14.2492 18.2503 14.4 18.3071 14.537C18.3639 14.6741 18.46 14.7912 18.5833 14.8736C18.7067 14.956 18.8517 15 19 15C19.1987 14.9994 19.3892 14.9202 19.5297 14.7797C19.6702 14.6392 19.7494 14.4487 19.75 14.25Z" fill="#E03E3E"/>
                                      <path d="M20.74 0.375L23.875 9.2925L22.375 9.82875V7.5C22.3744 7.30127 22.2952 7.11085 22.1547 6.97033C22.0142 6.8298 21.8237 6.75059 21.625 6.75H21.0062L19.9487 3.7425C19.7693 3.80644 19.579 3.83425 19.3887 3.82433C19.1985 3.81441 19.0121 3.76696 18.8402 3.6847C18.6684 3.60245 18.5145 3.48701 18.3875 3.34504C18.2604 3.20308 18.1627 3.03738 18.1 2.8575L7.18 6.735V6.75H4C3.90704 6.75012 3.81423 6.74259 3.7225 6.7275L3.625 6.4575L16.39 1.92L20.74 0.375Z" fill="#36CE94"/>
                                      <path d="M2.1625 5.23875C2.23704 5.61758 2.42701 5.96406 2.70632 6.23061C2.98563 6.49717 3.3406 6.67074 3.7225 6.7275C3.81423 6.74259 3.90704 6.75012 4 6.75H21.625C21.8237 6.7506 22.0142 6.82981 22.1547 6.97033C22.2952 7.11085 22.3744 7.30127 22.375 7.5V12.375H17.875C17.6763 12.3756 17.4858 12.4548 17.3453 12.5953C17.2048 12.7359 17.1256 12.9263 17.125 13.125V15.375C17.1256 15.5737 17.2048 15.7642 17.3453 15.9047C17.4858 16.0452 17.6763 16.1244 17.875 16.125H22.375V20.25C22.375 20.7038 21.7038 21.375 20.875 21.375H15.625V15.375C15.6244 15.1763 15.5452 14.9859 15.4047 14.8453C15.2642 14.7048 15.0737 14.6256 14.875 14.625H2.875C2.67627 14.6256 2.48585 14.7048 2.34533 14.8453C2.2048 14.9859 2.12559 15.1763 2.125 15.375V21.375C1.72718 21.375 1.34564 21.217 1.06434 20.9357C0.783035 20.6544 0.625 20.2728 0.625 19.875V5.25C0.625 4.65327 0.862053 4.08097 1.28401 3.65901C1.70597 3.23706 2.27826 3 2.875 3H4.07875C3.60291 2.99238 3.14102 3.16082 2.7818 3.47298C2.42257 3.78513 2.19134 4.219 2.1325 4.69125C2.11398 4.8742 2.1241 5.05892 2.1625 5.23875Z" fill="#FEBD55"/>
                                      <path d="M19.9487 3.74242L21.0062 6.74992H7.17999V6.73492L18.1 2.85742C18.1627 3.0373 18.2604 3.203 18.3875 3.34496C18.5145 3.48693 18.6684 3.60237 18.8402 3.68462C19.012 3.76688 19.1985 3.81434 19.3887 3.82426C19.579 3.83418 19.7693 3.80636 19.9487 3.74242Z" fill="#2FB380"/>
                                      <path d="M19 15C19.4142 15 19.75 14.6642 19.75 14.25C19.75 13.8358 19.4142 13.5 19 13.5C18.5858 13.5 18.25 13.8358 18.25 14.25C18.25 14.6642 18.5858 15 19 15Z" fill="#2B2B37"/>
                                      <path d="M8.35748 3L15.625 0.375L16.375 1.875L16.39 1.92L3.62498 6.4575L3.72248 6.7275C3.34058 6.67074 2.98561 6.49717 2.7063 6.23061C2.42698 5.96405 2.23702 5.61758 2.16248 5.23875L8.35748 3Z" fill="#2FB380"/>
                                      <path d="M8.35753 3L2.16253 5.23875C2.12413 5.05892 2.11401 4.8742 2.13253 4.69125C2.19137 4.219 2.4226 3.78513 2.78182 3.47298C3.14105 3.16082 3.60293 2.99238 4.07878 3H8.35753Z" fill="#BD6F08"/>
                                      <path d="M15.625 21.375V22.875C15.6244 23.0737 15.5452 23.2642 15.4047 23.4047C15.2642 23.5452 15.0737 23.6244 14.875 23.625H2.875C2.67627 23.6244 2.48585 23.5452 2.34533 23.4047C2.2048 23.2642 2.12559 23.0737 2.125 22.875V18H15.625V21.375Z" fill="#FF6161"/>
                                      <path d="M15.625 16.875V18H15.25H2.5H2.125V16.875H2.5H15.25H15.625Z" fill="#EDF4FA"/>
                                      <path d="M15.625 15.375V16.875H2.125V15.375C2.12559 15.1763 2.2048 14.9858 2.34533 14.8453C2.48585 14.7048 2.67627 14.6256 2.875 14.625H14.875C15.0737 14.6256 15.2642 14.7048 15.4047 14.8453C15.5452 14.9858 15.6244 15.1763 15.625 15.375Z" fill="#CB3541"/>
                                      <path d="M14.875 22.5H10.75C9.35509 22.4992 7.99474 22.066 6.85617 21.2601C5.71761 20.4542 4.85681 19.3153 4.39225 18H2.125V22.875C2.12559 23.0737 2.2048 23.2642 2.34533 23.4047C2.48585 23.5452 2.67627 23.6244 2.875 23.625H14.875C15.0737 23.6244 15.2642 23.5452 15.4047 23.4047C15.5452 23.2642 15.6244 23.0737 15.625 22.875V21.75C15.625 21.9489 15.546 22.1397 15.4053 22.2803C15.2647 22.421 15.0739 22.5 14.875 22.5Z" fill="#E03E3E"/>
                                      <path d="M4.39225 18C4.26286 17.6341 4.1655 17.2577 4.10125 16.875H2.125V18H4.39225Z" fill="#C1CFE8"/>
                                      <path d="M4.10125 16.875C4.03628 16.5035 4.00242 16.1272 4 15.75V14.625H2.875C2.67627 14.6256 2.48585 14.7048 2.34533 14.8453C2.2048 14.9858 2.12559 15.1763 2.125 15.375V16.875H4.10125Z" fill="#A81E29"/>
                                      <path d="M16.375 1.87511L16.0705 1.26611L4.68173 5.37874C4.49881 5.44478 4.2974 5.43719 4.11997 5.35757C3.94255 5.27796 3.80299 5.13253 3.73073 4.95199L3.63285 4.70749L2.16248 5.23886C2.23702 5.61769 2.42698 5.96417 2.7063 6.23072C2.98561 6.49728 3.34058 6.67085 3.72248 6.72761L3.62498 6.45761L16.39 1.92011L16.375 1.87511Z" fill="#2AA173"/>
                                      <path d="M10.306 5.625H5.96688L3.625 6.4575L3.7225 6.7275C3.81423 6.74259 3.90704 6.75012 4 6.75H7.18V6.735L10.306 5.625Z" fill="#2FB380"/>
                                      <path d="M23.875 9.2925L22.5857 5.625H20.6125L21.0081 6.75H21.625C21.8237 6.75059 22.0141 6.8298 22.1547 6.97033C22.2952 7.11085 22.3744 7.30127 22.375 7.5V9.82875L23.875 9.2925Z" fill="#2FB380"/>
                                      <path d="M10.306 5.625L7.17999 6.735V6.75H21.0062L20.6106 5.625H10.306Z" fill="#2AA173"/>
                                      <path d="M23.5 15.375H19.75C19.5906 15.3746 19.433 15.3401 19.288 15.2738C19.143 15.2075 19.0139 15.111 18.9092 14.9906C18.7275 14.9697 18.5597 14.8827 18.4379 14.7461C18.3162 14.6096 18.2489 14.433 18.2489 14.25C18.2489 14.067 18.3162 13.8904 18.4379 13.7539C18.5597 13.6173 18.7275 13.5303 18.9092 13.5094C19.0139 13.389 19.143 13.2925 19.288 13.2262C19.433 13.1599 19.5906 13.1254 19.75 13.125H22.375C22.5739 13.125 22.7647 13.046 22.9053 12.9053C23.046 12.7647 23.125 12.5739 23.125 12.375V11.25H22.375V12.375H17.875C17.6763 12.3756 17.4858 12.4548 17.3453 12.5953C17.2048 12.7358 17.1256 12.9263 17.125 13.125V15.375C17.1256 15.5737 17.2048 15.7642 17.3453 15.9047C17.4858 16.0452 17.6763 16.1244 17.875 16.125H23.125C23.3237 16.1244 23.5142 16.0452 23.6547 15.9047C23.7952 15.7642 23.8744 15.5737 23.875 15.375V15C23.875 15.0995 23.8355 15.1948 23.7652 15.2652C23.6948 15.3355 23.5995 15.375 23.5 15.375Z" fill="#CB3541"/>
                                      <path d="M18.25 17.2499H22.375V16.1249H17.875C17.7429 16.1241 17.6134 16.088 17.5 16.0203V16.4999C17.5 16.6988 17.579 16.8896 17.7197 17.0302C17.8603 17.1709 18.0511 17.2499 18.25 17.2499Z" fill="#FC9E20"/>
                                      <path d="M2.125 16.875V15.375C2.12559 15.1763 2.2048 14.9859 2.34533 14.8453C2.48585 14.7048 2.67627 14.6256 2.875 14.625H3.625V6.705C3.26367 6.63235 2.93195 6.45433 2.67167 6.19339C2.4114 5.93244 2.23422 5.60027 2.1625 5.23875C2.1241 5.05892 2.11398 4.8742 2.1325 4.69125C2.19134 4.219 2.42257 3.78513 2.7818 3.47298C3.14102 3.16082 3.60291 2.99238 4.07875 3H2.875C2.27826 3 1.70597 3.23706 1.28401 3.65901C0.862053 4.08097 0.625 4.65327 0.625 5.25V19.875C0.625 20.2728 0.783035 20.6544 1.06434 20.9357C1.34564 21.217 1.72718 21.375 2.125 21.375V16.875Z" fill="#FC9E20"/>
                                      <path d="M21.25 19.875H18.25C17.8522 19.875 17.4706 19.717 17.1893 19.4357C16.908 19.1544 16.75 18.7728 16.75 18.375V16.5C16.75 16.3011 16.671 16.1103 16.5303 15.9697C16.3897 15.829 16.1989 15.75 16 15.75H15.625V21.375H20.875C21.7038 21.375 22.375 20.7038 22.375 20.25V18.75C22.375 19.0484 22.2565 19.3345 22.0455 19.5455C21.8345 19.7565 21.5484 19.875 21.25 19.875Z" fill="#FC9E20"/>
                                  </svg>  
                                </div>
                                Euforia
                            </a> 
                        </li>

                        <li>
                            <a href="<?php echo e(url('/pengajuan-absensi')); ?>">
                            <div class="icon-box bg_color_6">
                                <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_4355_17382)">
                                    <path d="M16.2934 5.2658C15.0651 3.69961 13.7962 2.08087 12.7721 0.343495C12.5019 -0.114498 11.748 -0.114498 11.4793 0.343495C10.4536 2.08087 9.18478 3.69961 7.95645 5.2658C5.46677 8.44173 3.11523 11.442 3.11523 14.9903C3.11523 19.9591 7.15609 24 12.1249 24C17.0938 24 21.1347 19.9591 21.1347 14.9903C21.1347 11.442 18.7831 8.44173 16.2934 5.2658Z" fill="#2B8CD9"/>
                                    <path d="M15.125 8C13.8967 6.43381 13.7962 2.08087 12.7721 0.343495C12.5019 -0.114498 11.748 -0.114498 11.4793 0.343495C10.4536 2.08087 9.18478 3.69961 7.95645 5.2658C5.46677 8.44173 3.11523 11.442 3.11523 14.9903C3.11523 19.9591 7.15609 24 12.1249 24C17.0938 24 17.625 17 17.625 17C17.625 13.4517 17.6147 11.1759 15.125 8Z" fill="#39A3F8"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_4355_17382">
                                    <rect width="24" height="24" fill="white" transform="translate(0.125)"/>
                                    </clipPath>
                                    </defs>
                                </svg>  
                            </div>
                            Pengajuan Absensi
                            </a> 
                        </li>

                        <li>
                            <a href="<?php echo e(url('/my-profile')); ?>">
                                <div class="icon-box bg_color_8">
                                    <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M19.7505 19.874V22.8748C19.7497 23.0819 19.9169 23.2504 20.124 23.2512H21.6248C21.8319 23.2505 21.9991 23.0819 21.9983 22.8748V19.874H19.7505Z" fill="#5A626E"/>
                                        <path d="M20.4985 19.874V22.8748C20.4993 23.0819 20.3321 23.2505 20.125 23.2512H21.625C21.8321 23.2505 21.9993 23.0819 21.9985 22.8748V19.874H20.4985Z" fill="#515763"/>
                                        <path d="M19.7505 19.874V20.9998H21.9983V19.874H19.7505Z" fill="#515763"/>
                                        <path d="M3.24951 6.37598V12.7484H3.9997V6.37598H3.24951Z" fill="#E7EBEF"/>
                                        <path d="M6.61841 8.24421C6.51946 8.24615 6.42529 8.28712 6.35642 8.35818C6.28755 8.42925 6.24956 8.52463 6.25073 8.62359V9.00006H5.87353C5.77459 9.00046 5.6798 9.03996 5.60984 9.10993C5.53987 9.17989 5.50039 9.27465 5.5 9.3736V12.3743C5.49991 12.4674 5.53442 12.5572 5.59682 12.6262C5.65922 12.6952 5.74505 12.7386 5.83765 12.7479C5.8496 12.7484 5.86158 12.7484 5.87353 12.7479H7.37427C7.47372 12.7482 7.56925 12.7091 7.63985 12.639C7.71045 12.569 7.75033 12.4738 7.75073 12.3743V9.3736C7.75034 9.27414 7.71046 9.17894 7.63986 9.10889C7.56926 9.03884 7.47372 8.99968 7.37427 9.00006H7.00073V8.62359C7.00133 8.57335 6.99182 8.52354 6.97278 8.47704C6.95374 8.43055 6.92555 8.38834 6.88989 8.35295C6.85423 8.31756 6.81183 8.28971 6.76519 8.27103C6.71855 8.25235 6.66864 8.24323 6.61841 8.24421Z" fill="#FB4F56"/>
                                        <path d="M9.6189 8.24421C9.51995 8.24615 9.42578 8.28712 9.35691 8.35818C9.28804 8.42925 9.25005 8.52463 9.25122 8.62359V9.00006H8.87403C8.77508 9.00046 8.68029 9.03991 8.61033 9.10988C8.54036 9.17985 8.50088 9.27465 8.50049 9.3736V12.3743C8.5004 12.4674 8.5349 12.5572 8.59731 12.6262C8.65971 12.6952 8.74554 12.7386 8.83813 12.7479C8.85009 12.7484 8.86207 12.7484 8.87402 12.7479H10.3748C10.4737 12.7475 10.5685 12.708 10.6384 12.638C10.7084 12.568 10.7479 12.4733 10.7483 12.3743V9.3736C10.7479 9.27465 10.7084 9.17989 10.6385 9.10993C10.5685 9.03996 10.4737 9.00046 10.3748 9.00006H10.0012V8.62359C10.0018 8.57335 9.99231 8.52354 9.97327 8.47704C9.95423 8.43055 9.92605 8.38834 9.89038 8.35295C9.85472 8.31756 9.81232 8.28971 9.76568 8.27103C9.71904 8.25235 9.66913 8.24323 9.6189 8.24421Z" fill="#FCB860"/>
                                        <path d="M12.249 5.24902V12.3747C12.2498 12.5818 12.4184 12.7491 12.6255 12.7483H21.6248C21.8307 12.7475 21.9975 12.5807 21.9983 12.3747V5.24902H12.249Z" fill="#E7EBEF"/>
                                        <path d="M12.999 5.62598H21.2512L21.2498 8.62451H12.9976L12.999 5.62598Z" fill="#68B1FC"/>
                                        <path d="M12.9976 9.37451H21.2498L21.2513 12.001H12.9991L12.9976 9.37451Z" fill="#68B1FC"/>
                                        <path d="M21.9971 14.1235C21.9979 13.9164 21.8306 13.7478 21.6234 13.7471H3.62453C3.41627 13.7463 3.24725 13.9153 3.24805 14.1235L3.24947 19.8737C3.24866 20.0819 3.41769 20.251 3.62594 20.2502L21.9998 20.2496L21.9971 14.1235Z" fill="#FCB860"/>
                                        <path d="M21.9985 13.8753C21.9997 13.6679 21.8324 13.4989 21.625 13.498H20.125C20.3324 13.4988 20.4997 13.6679 20.4985 13.8753L20.4986 19.8738C20.4993 20.0809 20.3321 20.2494 20.125 20.2503L22 20.2495L21.9985 13.8753Z" fill="#FBB04F"/>
                                        <path d="M8.12445 16.499C6.26493 16.499 4.75 18.014 4.75 19.8735C4.75 21.733 6.26493 23.2507 8.12445 23.2507C9.98397 23.2507 11.4989 21.733 11.4989 19.8735C11.4989 18.014 9.98397 16.499 8.12445 16.499Z" fill="#5A626E"/>
                                        <path d="M3.62623 13.4981C3.57661 13.4978 3.52743 13.5074 3.48154 13.5262C3.43565 13.5451 3.39395 13.5728 3.35887 13.6079C3.32378 13.643 3.29601 13.6847 3.27716 13.7306C3.2583 13.7765 3.24874 13.8256 3.24903 13.8753V14.9988H21.9983V13.8753C21.9986 13.826 21.9891 13.7771 21.9705 13.7314C21.9519 13.6858 21.9244 13.6442 21.8897 13.6092C21.8551 13.5742 21.8138 13.5463 21.7683 13.5272C21.7229 13.5082 21.6741 13.4982 21.6248 13.4981H3.62623Z" fill="#FBB04F"/>
                                        <path d="M2.46321 12.0009C2.37057 12.0102 2.28469 12.0536 2.22227 12.1226C2.15985 12.1917 2.12535 12.2815 2.12549 12.3746V13.875C2.12584 13.974 2.16533 14.0688 2.23533 14.1388C2.30534 14.2088 2.40019 14.2484 2.4992 14.2487H22.7486C22.7979 14.2489 22.8467 14.2394 22.8923 14.2207C22.9379 14.202 22.9793 14.1745 23.0143 14.1398C23.0493 14.1051 23.077 14.0639 23.0961 14.0184C23.1151 13.973 23.1249 13.9243 23.1251 13.875V12.3746C23.1249 12.3254 23.1151 12.2766 23.0961 12.2312C23.077 12.1857 23.0493 12.1445 23.0143 12.1098C22.9793 12.0751 22.9379 12.0476 22.8923 12.0289C22.8467 12.0102 22.7979 12.0007 22.7486 12.0009H2.4992C2.48721 12.0003 2.4752 12.0003 2.46321 12.0009Z" fill="#FCB860"/>
                                        <path d="M21.2485 12.001C21.2978 12.0007 21.3467 12.0101 21.3924 12.0288C21.438 12.0474 21.4796 12.0749 21.5146 12.1095C21.5496 12.1442 21.5775 12.1855 21.5965 12.231C21.6156 12.2764 21.6255 12.3252 21.6257 12.3745V13.8752C21.6255 13.9245 21.6156 13.9733 21.5965 14.0188C21.5775 14.0643 21.5496 14.1056 21.5146 14.1402C21.4796 14.1749 21.438 14.2024 21.3924 14.221C21.3467 14.2396 21.2978 14.2491 21.2485 14.2488H22.7485C22.7978 14.2491 22.8467 14.2396 22.8924 14.221C22.938 14.2024 22.9796 14.1749 23.0146 14.1402C23.0496 14.1056 23.0775 14.0643 23.0965 14.0188C23.1156 13.9733 23.1255 13.9245 23.1257 13.8752V12.3745C23.1255 12.3252 23.1156 12.2764 23.0965 12.231C23.0775 12.1855 23.0496 12.1442 23.0146 12.1095C22.9796 12.0749 22.938 12.0474 22.8924 12.0288C22.8467 12.0101 22.7978 12.0007 22.7485 12.001H21.2485Z" fill="#FBB04F"/>
                                        <path d="M8.12402 18.373C7.30004 18.373 6.62402 19.0498 6.62402 19.8738C6.62402 20.6977 7.30004 21.3738 8.12402 21.3738C8.94801 21.3738 9.62475 20.6977 9.62475 19.8738C9.62475 19.0498 8.94801 18.373 8.12402 18.373Z" fill="#E7EBEF"/>
                                        <path d="M8.12402 16.499C7.99714 16.499 7.87233 16.5075 7.74902 16.521C9.43276 16.7085 10.7483 18.1414 10.7483 19.874C10.7483 21.6066 9.43276 23.0413 7.74902 23.2292C7.87233 23.2434 7.99714 23.2512 8.12402 23.2512C9.98354 23.2512 11.4983 21.7335 11.4983 19.874C11.4983 18.0145 9.98354 16.499 8.12402 16.499Z" fill="#515763"/>
                                        <path d="M20.5 5.62451L21.2514 5.62594L21.25 8.62443L20.4985 8.623L20.5 5.62451Z" fill="#4FA4FB"/>
                                        <path d="M20.4985 9.37305L21.25 9.37447L21.2516 12.0009L20.5001 11.9995L20.4985 9.37305Z" fill="#4FA4FB"/>
                                        <path d="M3.99792 0.749512C3.86951 0.750631 3.7507 0.817701 3.68298 0.926764L1.80579 3.9275C1.76342 3.99582 1.74414 4.07592 1.7508 4.15601V4.87375C1.7508 5.90602 2.59207 6.75099 3.62433 6.75099C4.23934 6.75099 4.78228 6.45868 5.12434 5.99803C5.46721 6.45847 6.01024 6.75099 6.62507 6.75099C7.23971 6.75099 7.78225 6.45896 8.12433 5.99877C8.46643 6.45896 9.00824 6.75099 9.62287 6.75099C10.2377 6.75099 10.7815 6.45852 11.1243 5.99803C11.4664 6.45868 12.0093 6.75099 12.6243 6.75099C13.2392 6.75099 13.7822 6.45852 14.1251 5.99803C14.4671 6.45868 15.0093 6.75099 15.6243 6.75099C16.2393 6.75099 16.7823 6.45868 17.1243 5.99803C17.4672 6.45852 18.0109 6.75099 18.6258 6.75099C19.2404 6.75099 19.7822 6.45896 20.1243 5.99877C20.4664 6.45896 21.009 6.75099 21.6236 6.75099C22.6559 6.75099 23.5001 5.90602 23.5001 4.87375V4.12673C23.5003 4.0458 23.4744 3.96685 23.4261 3.90185L21.5679 0.926764C21.4995 0.816638 21.379 0.749512 21.2493 0.749512H3.99792Z" fill="#FC6067"/>
                                        <path d="M1.75287 4.125C1.75286 4.13492 1.74989 4.14541 1.7506 4.15575V4.8735C1.7506 5.90576 2.59186 6.75073 3.62413 6.75073C4.23913 6.75073 4.78208 6.45842 5.12413 5.99778C5.467 6.45821 6.01003 6.75073 6.62486 6.75073C7.2395 6.75073 7.78204 6.45871 8.12413 5.99851C8.46623 6.45871 9.00804 6.75073 9.62266 6.75073C10.2375 6.75073 10.7813 6.45827 11.1241 5.99778C11.4662 6.45842 12.0091 6.75073 12.6241 6.75073C13.239 6.75073 13.782 6.45827 14.1249 5.99778C14.4669 6.45842 15.0091 6.75073 15.6241 6.75073C16.2391 6.75073 16.7821 6.45842 17.1241 5.99778C17.467 6.45827 18.0107 6.75073 18.6256 6.75073C19.2402 6.75073 19.782 6.45871 20.1241 5.99851C20.4662 6.45871 21.0088 6.75073 21.6234 6.75073C22.6557 6.75073 23.4999 5.90575 23.4999 4.8735V4.12643C23.4999 4.12606 23.4999 4.12534 23.4999 4.12504L1.75287 4.125Z" fill="#FB4F56"/>
                                        <path d="M6.81201 0.749512L5.12451 4.12526V5.99803C5.46737 6.45847 6.01042 6.75099 6.62524 6.75099C7.23988 6.75099 7.78242 6.45896 8.12451 5.99877V4.12526L9.39014 0.749512H6.81201ZM11.5464 0.749512L11.1245 4.12526V5.99803C11.4666 6.45868 12.0095 6.75099 12.6245 6.75099C13.239 6.75099 13.7816 6.45879 14.1245 5.99877V4.12526L13.7026 0.749512H11.5464ZM15.8596 0.749512L17.1252 4.12526V5.99877C17.4673 6.45896 18.0099 6.75099 18.6245 6.75099C19.2393 6.75099 19.7824 6.45847 20.1252 5.99803V4.12526L18.4377 0.749512H15.8596Z" fill="#E7EBEF"/>
                                        <path d="M5.12451 4.125V5.99778C5.46737 6.45821 6.01042 6.75073 6.62524 6.75073C7.23988 6.75073 7.78242 6.45871 8.12451 5.99851V4.125H5.12451ZM11.1245 4.125V5.99778C11.4666 6.45842 12.0095 6.75073 12.6245 6.75073C13.239 6.75073 13.7816 6.45854 14.1245 5.99851V4.125H11.1245ZM17.1252 4.125V5.99851C17.4673 6.45871 18.0099 6.75073 18.6245 6.75073C19.2393 6.75073 19.7824 6.45821 20.1252 5.99778V4.125H17.1252Z" fill="#DBE1E7"/>
                                        <path d="M19.7495 0.749512C19.8792 0.749526 19.9997 0.816553 20.0681 0.926764L21.9263 3.90185C21.9746 3.96691 22.0005 4.04574 22.0002 4.12673H23.5002C23.5005 4.0458 23.4746 3.96685 23.4263 3.90185L21.5681 0.926764C21.4997 0.816638 21.3792 0.749526 21.2495 0.749512H19.7495Z" fill="#FB4F56"/>
                                        <path d="M22.0002 4.12549V4.87364C22.0002 5.63956 21.5346 6.30089 20.873 6.59192C20.8738 6.59223 20.8746 6.59229 20.8753 6.59265C20.9299 6.61647 20.986 6.6376 21.043 6.65645C21.0504 6.65929 21.0576 6.66071 21.065 6.66355C21.117 6.67999 21.1701 6.69402 21.224 6.70606C21.2416 6.71032 21.2596 6.71172 21.2774 6.71597C21.3248 6.72447 21.3724 6.73398 21.421 6.73937C21.4877 6.74646 21.5552 6.7507 21.6239 6.7507C22.6561 6.7507 23.5003 5.90576 23.5003 4.87351V4.12562L22.0002 4.12549Z" fill="#FB3B43"/>
                                    </svg>
                                        
                                </div>
                                Profile
                            </a> 
                        </li>

                          <li>
                              <a href="<?php echo e(url('/dashboard')); ?>">
                                <div class="icon-box bg_service-3">
                                      <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <path d="M24.2838 7.48567C22.5636 -5.34697 15.3153 2.01241 6.99199 5.99402C4.62414 7.12675 1.38339 7.13603 0.529097 10.1115C-0.458746 13.5521 2.49213 15.7224 4.86696 17.5562C7.726 19.7638 7.32082 24.1061 11.9929 23.7198C12.874 23.647 13.9302 23.7352 14.4994 23.0587C16.8551 20.2588 17.5094 16.0487 20.5731 13.8156C22.7339 12.2406 24.6702 10.3686 24.2838 7.48567V7.48567Z" fill="url(#paint0_linear_4516_5327)"/>
                                          <path d="M11.1101 8.50233C10.8512 8.50233 10.6413 8.29243 10.6413 8.03358V4.51604C10.6413 3.36872 9.70791 2.4353 8.56059 2.4353C7.41328 2.4353 6.47986 3.36872 6.47986 4.51604V8.03358C6.47986 8.29243 6.27 8.50233 6.01111 8.50233C5.75222 8.50233 5.54236 8.29243 5.54236 8.03358V4.51604C5.54236 2.85179 6.89634 1.4978 8.56059 1.4978C10.2248 1.4978 11.5788 2.85179 11.5788 4.51604V8.03358C11.5788 8.29248 11.369 8.50233 11.1101 8.50233V8.50233Z" fill="#FFC498"/>
                                          <path d="M4.77612 20.4084H2.87707C2.74085 20.4084 2.63332 20.2927 2.64335 20.1568L3.59196 7.27699C3.60096 7.15455 3.70296 7.05981 3.82568 7.05981H5.72482L4.77612 20.4084Z" fill="#FF7300"/>
                                          <path d="M10.2019 1.98511C9.70002 2.02945 9.26681 2.20284 8.90198 2.46379C9.5587 2.57269 10.1121 2.99006 10.4085 3.56161C10.4256 3.56119 10.4425 3.56029 10.4596 3.56029C10.8392 3.56029 11.1951 3.663 11.5018 3.84131C11.3243 3.06712 10.8485 2.40586 10.2019 1.98511V1.98511Z" fill="#FFAA66"/>
                                          <path d="M13.3223 5.13473C14.475 5.29359 15.5495 5.49229 16.5249 5.72507C16.6042 5.74396 16.6598 5.81503 16.6598 5.8965V9.13706C16.6598 9.26034 16.5367 9.34537 16.4213 9.30168C15.46 8.93756 14.4044 8.66198 13.2743 8.50078C13.1872 8.48836 13.1222 8.41434 13.1222 8.3264V5.30939C13.1222 5.2027 13.2166 5.12015 13.3223 5.13473V5.13473Z" fill="#9393FF"/>
                                          <path d="M19.934 11.522C19.3646 10.9961 18.6909 10.5108 17.9281 10.086C17.8721 10.0548 17.837 9.99604 17.837 9.93201V6.37448C17.837 6.25486 17.9539 6.16978 18.0677 6.20672C20.528 7.0057 22.0239 8.06062 22.0239 9.21736L21.8832 11.1587L19.934 11.522Z" fill="#9393FF"/>
                                          <path d="M22.0238 13.3463L21.8386 14.0752L22.0238 14.2763V14.5922L21.9179 15.2644L22.0238 15.5222V16.0791C22.0238 17.1707 20.6922 18.5447 18.4754 19.6873C18.2885 19.7836 18.0657 19.6472 18.0657 19.4369V12.4824C18.0657 12.3314 18.1622 12.1974 18.3052 12.1486C20.6241 11.3602 22.0238 10.3364 22.0238 9.21753V13.3463Z" fill="#D8D8FF"/>
                                          <path d="M22.0238 14.592V15.522C21.4594 16.2172 20.5032 16.8463 19.4996 17.4355C19.4625 17.4575 19.4217 17.4678 19.3814 17.4678C19.3008 17.4678 19.2225 17.4266 19.1789 17.352C19.1133 17.2405 19.1508 17.0966 19.2624 17.0314C20.9536 16.0386 21.8133 15.2853 22.0238 14.592V14.592Z" fill="#9393FF"/>
                                          <path d="M22.0238 13.3462V14.2762C21.4589 14.9713 20.5032 15.6004 19.4996 16.1896C19.4625 16.2112 19.4217 16.2215 19.3814 16.2215C19.3008 16.2215 19.2225 16.1803 19.1789 16.1062C19.1133 15.9942 19.1508 15.8507 19.2624 15.7851C20.9536 14.7923 21.8133 14.0395 22.0238 13.3462Z" fill="#9393FF"/>
                                          <path d="M19.3813 15.2074C19.3025 15.2074 19.2256 15.1678 19.1813 15.0957C19.1136 14.9854 19.148 14.8411 19.2583 14.7734C19.5345 14.6037 19.7758 14.4484 19.996 14.2986C20.1032 14.2258 20.2489 14.2537 20.3216 14.3607C20.3944 14.4678 20.3666 14.6136 20.2596 14.6863C20.0333 14.8401 19.786 14.9993 19.5037 15.1727C19.4655 15.1962 19.4231 15.2074 19.3813 15.2074V15.2074Z" fill="#9393FF"/>
                                          <path d="M19.3812 13.4436C19.2918 13.4436 19.2064 13.3922 19.1674 13.3054C19.1142 13.1874 19.1668 13.0486 19.2848 12.9955C19.6547 12.8289 19.9883 12.6536 20.2766 12.4743C20.3866 12.406 20.5311 12.4397 20.5994 12.5495C20.6677 12.6595 20.634 12.804 20.5242 12.8724C20.2183 13.0626 19.8661 13.2478 19.4773 13.4229C19.4461 13.4369 19.4134 13.4436 19.3812 13.4436V13.4436Z" fill="#FF9393"/>
                                          <path d="M18.0681 6.20699C17.9542 6.17001 17.837 6.2549 17.837 6.37462V9.93215C17.837 9.99623 17.8721 10.055 17.9281 10.0862C18.6779 10.5038 19.3408 10.9801 19.904 11.4957C19.4371 11.7274 18.9017 11.946 18.3048 12.149C18.1621 12.1976 18.0658 12.3317 18.0658 12.4826V19.437C18.0658 19.6473 18.2886 19.7838 18.4756 19.6874C20.6923 18.5446 22.0239 17.1709 22.0239 16.0793V9.21749C22.0239 8.0608 20.5282 7.00593 18.0681 6.20699Z" fill="url(#paint1_linear_4516_5327)"/>
                                          <path d="M16.1433 20.4084H4.77616C4.63975 20.4084 4.53241 20.2926 4.54225 20.1567L5.491 7.27685C5.49991 7.1545 5.6021 7.05981 5.72491 7.05981H15.1946C15.3174 7.05981 15.4191 7.1545 15.4285 7.27685L16.3768 20.1567C16.3871 20.2926 16.2793 20.4084 16.1433 20.4084Z" fill="#FFAA66"/>
                                          <path d="M11.0447 10.5326C10.9228 10.6545 10.7608 10.7216 10.5884 10.7216C10.4161 10.7216 10.2541 10.6545 10.1322 10.5326C10.0104 10.4107 9.94324 10.2487 9.94324 10.0763C9.94324 9.90399 10.0104 9.74199 10.1322 9.62011C10.3838 9.36849 10.7932 9.36854 11.0447 9.62011L11.2104 9.78586L11.5419 9.45441L11.3761 9.28866C11.2188 9.13135 11.0257 9.03188 10.8228 8.98847V8.53955H10.3541V8.98852C10.1512 9.03188 9.95805 9.13139 9.80074 9.28866C9.59036 9.49908 9.47449 9.77883 9.47449 10.0763C9.47449 10.3739 9.59036 10.6537 9.80074 10.864C9.95472 11.018 10.146 11.1211 10.3541 11.1655V11.6131H10.8228V11.1655C11.0309 11.1211 11.2221 11.018 11.3761 10.864L11.5419 10.6983L11.2104 10.3668L11.0447 10.5326Z" fill="white"/>
                                          <path d="M7.44153 7.05981H8.37903V8.87763C8.37903 9.13638 8.16903 9.34638 7.91028 9.34638C7.65153 9.34638 7.44153 9.13638 7.44153 8.87763V7.05981Z" fill="#FF9C33"/>
                                          <path d="M13.4781 7.05981V8.87763C13.4781 9.13638 13.2681 9.34638 13.0094 9.34638C12.7502 9.34638 12.5406 9.13638 12.5406 8.87763V7.05981H13.4781Z" fill="#FF9C33"/>
                                          <path d="M10.9984 13.5775C12.884 13.4304 14.6278 13.183 16.1577 12.8558C16.3769 12.8089 16.5833 12.9764 16.5833 13.2005V20.4353C16.5833 20.5874 16.4858 20.7222 16.3414 20.7701C14.7835 21.2871 12.9957 21.6755 11.0566 21.8444C10.8508 21.8623 10.6738 21.6995 10.6738 21.4929V13.9288C10.6738 13.745 10.8151 13.5918 10.9984 13.5775V13.5775Z" fill="#D8D8FF"/>
                                          <path d="M15.4929 20.1811C15.3913 20.1811 15.2977 20.1146 15.2679 20.0122C15.2318 19.8879 15.3032 19.7578 15.4274 19.7216C15.4987 19.7009 15.5694 19.6798 15.6398 19.6586C15.7636 19.621 15.8946 19.6911 15.9321 19.815C15.9696 19.9389 15.8995 20.0697 15.7756 20.1072C15.7036 20.129 15.6313 20.1505 15.5584 20.1717C15.5366 20.1781 15.5146 20.1811 15.4929 20.1811V20.1811Z" fill="#8282FF"/>
                                          <path d="M15.4929 19.4651C15.3913 19.4651 15.2977 19.3986 15.2679 19.2961C15.2318 19.1719 15.3032 19.0418 15.4274 19.0056C15.4987 18.9848 15.5694 18.9638 15.6398 18.9425C15.7636 18.9049 15.8946 18.9751 15.9321 19.0989C15.9696 19.2228 15.8995 19.3537 15.7756 19.3912C15.7036 19.413 15.6313 19.4344 15.5584 19.4556C15.5366 19.462 15.5146 19.4651 15.4929 19.4651V19.4651Z" fill="#8282FF"/>
                                          <path d="M16.0011 15.6087L14.8434 14.5739C14.8277 14.5598 14.8076 14.5527 14.7878 14.5541L14.2639 14.5906C14.2315 14.5929 14.2048 14.6166 14.1978 14.6498C14.1563 14.846 13.9983 14.997 13.7931 15.013C13.586 15.0292 13.3922 14.9033 13.3049 14.713C13.29 14.6807 13.2572 14.6607 13.2233 14.6631L12.6622 14.7021C12.6407 14.7036 12.6207 14.714 12.6071 14.7308L11.5495 16.0345C11.5196 16.0715 11.5257 16.1262 11.5632 16.1566L12.2405 16.7049C12.2768 16.7343 12.3301 16.7283 12.359 16.6915L12.7033 16.2534L12.643 18.6497C12.6416 18.7057 12.6911 18.7494 12.7465 18.7411L15.0027 18.4026C15.0469 18.396 15.0795 18.3579 15.0794 18.3132L15.074 16.0106L15.4573 16.3438C15.4903 16.3725 15.5408 16.3668 15.5666 16.3314L16.0137 15.7194C16.038 15.6862 16.0324 15.6366 16.0011 15.6087V15.6087Z" fill="#FFAA66"/>
                                          <path d="M12.9243 20.3039C13.5523 20.3039 14.0615 19.7948 14.0615 19.1667C14.0615 18.5387 13.5523 18.0295 12.9243 18.0295C12.2962 18.0295 11.7871 18.5387 11.7871 19.1667C11.7871 19.7948 12.2962 20.3039 12.9243 20.3039Z" fill="#FF6C6C"/>
                                          <path d="M12.7735 19.6973C12.7114 19.6973 12.6518 19.6726 12.6078 19.6287L12.3171 19.3379C12.2255 19.2464 12.2255 19.098 12.3171 19.0065C12.4086 18.915 12.5571 18.915 12.6485 19.0065L12.7735 19.1315L13.2002 18.7049C13.2917 18.6134 13.4402 18.6134 13.5316 18.7049C13.6232 18.7964 13.6232 18.9448 13.5316 19.0363L12.9392 19.6287C12.8953 19.6726 12.8357 19.6973 12.7735 19.6973V19.6973Z" fill="white"/>
                                          <path d="M14.3828 16.2914C14.2533 16.2914 14.1484 16.1864 14.1484 16.057V15.9878C14.1484 15.8584 14.2533 15.7534 14.3828 15.7534C14.5123 15.7534 14.6172 15.8584 14.6172 15.9878V16.057C14.6172 16.1864 14.5122 16.2914 14.3828 16.2914Z" fill="#FFD5BA"/>
                                          <path d="M13.0091 8.50233C12.7502 8.50233 12.5404 8.29243 12.5404 8.03358V4.51604C12.5404 3.36872 11.607 2.4353 10.4596 2.4353C9.31233 2.4353 8.37891 3.36872 8.37891 4.51604V8.03358C8.37891 8.29243 8.16905 8.50233 7.91016 8.50233C7.65127 8.50233 7.44141 8.29243 7.44141 8.03358V4.51604C7.44141 2.85179 8.79539 1.4978 10.4596 1.4978C12.1239 1.4978 13.4779 2.85179 13.4779 4.51604V8.03358C13.4779 8.29248 13.268 8.50233 13.0091 8.50233Z" fill="#FFD5BA"/>
                                          <path d="M8.8133 19.1614H6.17639C6.04697 19.1614 5.94202 19.0564 5.94202 18.927C5.94202 18.7976 6.04697 18.6926 6.17639 18.6926H8.8133C8.94272 18.6926 9.04767 18.7976 9.04767 18.927C9.04767 19.0564 8.94272 19.1614 8.8133 19.1614Z" fill="#FFD5BA"/>
                                          <path d="M8.86591 18.2642H6.229C6.09958 18.2642 5.99463 18.1592 5.99463 18.0298C5.99463 17.9004 6.09958 17.7954 6.229 17.7954H8.86591C8.99533 17.7954 9.10028 17.9004 9.10028 18.0298C9.10028 18.1592 8.99533 18.2642 8.86591 18.2642Z" fill="#FFD5BA"/>
                                          <path d="M7.0261 17.3667H6.28149C6.15207 17.3667 6.04712 17.2617 6.04712 17.1323C6.04712 17.0029 6.15207 16.8979 6.28149 16.8979H7.0261C7.15553 16.8979 7.26048 17.0029 7.26048 17.1323C7.26048 17.2617 7.15553 17.3667 7.0261 17.3667Z" fill="#FFD5BA"/>
                                          <path d="M16.525 5.72504C15.5939 5.5028 14.5715 5.31202 13.478 5.15696V4.51604C13.478 2.85179 12.124 1.4978 10.4597 1.4978C10.128 1.4978 9.80901 1.55237 9.51023 1.65169C9.21145 1.55237 8.89242 1.4978 8.56073 1.4978C6.89648 1.4978 5.5425 2.85179 5.5425 4.51604V7.05976H3.82584C3.70307 7.05976 3.60112 7.15449 3.59212 7.27693L2.64347 20.1568C2.63348 20.2927 2.74097 20.4084 2.87723 20.4084H10.6739V21.4929C10.6739 21.6995 10.8509 21.8623 11.0567 21.8444C12.9958 21.6755 14.7836 21.2871 16.3415 20.7701C16.4859 20.7222 16.5833 20.5874 16.5833 20.4353V13.2006C16.5833 12.9764 16.377 12.809 16.1578 12.8558C16.0543 12.878 15.9496 12.8997 15.8441 12.9211L15.5559 9.00638C15.852 9.09694 16.1408 9.19538 16.4214 9.30165C16.5367 9.34533 16.6598 9.2603 16.6598 9.13702V5.89646C16.6598 5.81504 16.6042 5.74397 16.525 5.72504V5.72504ZM7.4415 7.05976H6.48V4.51604C6.48 3.47265 7.25207 2.6064 8.25487 2.45799C7.75087 2.99757 7.4415 3.72118 7.4415 4.51604V7.05976ZM8.379 4.51604C8.379 3.71068 8.83926 3.01126 9.51023 2.66555C10.1812 3.01126 10.6415 3.71068 10.6415 4.51604V7.05976H8.379V4.51604ZM12.5405 7.05976H11.579V4.51604C11.579 3.72118 11.2696 2.99757 10.7656 2.45799C11.7684 2.6064 12.5405 3.47265 12.5405 4.51604V7.05976Z" fill="url(#paint2_linear_4516_5327)"/>
                                          <path d="M2.97083 3.40723H2.50208C2.24361 3.40723 2.03333 3.19695 2.03333 2.93848V2.46973C2.03333 2.21126 2.24361 2.00098 2.50208 2.00098H2.97083C3.22929 2.00098 3.43958 2.21126 3.43958 2.46973V2.93848C3.43958 3.19695 3.22929 3.40723 2.97083 3.40723V3.40723ZM2.50208 2.46973V2.93876L2.97083 2.93848V2.46973H2.50208Z" fill="#FF6C6C"/>
                                          <path d="M22.1149 20.8145H21.6461C21.3876 20.8145 21.1774 20.6042 21.1774 20.3457V19.877C21.1774 19.6185 21.3876 19.4082 21.6461 19.4082H22.1149C22.3733 19.4082 22.5836 19.6185 22.5836 19.877V20.3457C22.5836 20.6042 22.3733 20.8145 22.1149 20.8145ZM21.6461 19.877V20.346L22.1149 20.3457V19.877H21.6461Z" fill="#FF6C6C"/>
                                          <path d="M16.8109 4.39062H16.3422C16.0837 4.39062 15.8734 4.18034 15.8734 3.92188V3.45312C15.8734 3.19466 16.0837 2.98438 16.3422 2.98438H16.8109C17.0694 2.98438 17.2797 3.19466 17.2797 3.45312V3.92188C17.2797 4.18034 17.0694 4.39062 16.8109 4.39062ZM16.3422 3.45312V3.92216L16.8109 3.92188V3.45312H16.3422Z" fill="#6C6CFF"/>
                                          <path d="M3.7439 5.73242C3.6839 5.73242 3.62394 5.70955 3.57815 5.6638L3.50727 5.59292C3.37935 5.46495 3.17104 5.46495 3.04297 5.59292L2.9721 5.6638C2.88055 5.7553 2.73219 5.7553 2.64065 5.6638C2.5949 5.618 2.57202 5.55805 2.57202 5.49805C2.57202 5.43805 2.5949 5.37809 2.64065 5.3323L2.71152 5.26142C2.77354 5.19941 2.80771 5.11695 2.80771 5.0293C2.80771 4.94164 2.77354 4.85919 2.71157 4.79717L2.64065 4.7263C2.5949 4.6805 2.57202 4.62055 2.57202 4.56055C2.57202 4.50055 2.5949 4.44059 2.64065 4.3948C2.73219 4.3033 2.88055 4.3033 2.9721 4.3948L3.04297 4.46567C3.17094 4.59364 3.37926 4.59364 3.50722 4.46567L3.5781 4.3948C3.66965 4.3033 3.81801 4.3033 3.90955 4.3948C3.9553 4.44059 3.97818 4.50055 3.97818 4.56055C3.97818 4.62055 3.9553 4.6805 3.90955 4.7263L3.83868 4.79717C3.71066 4.92514 3.71066 5.13345 3.83868 5.26142L3.90955 5.3323C3.9553 5.37809 3.97818 5.43805 3.97818 5.49805C3.97818 5.55805 3.9553 5.618 3.90955 5.6638C3.86385 5.70955 3.8039 5.73242 3.7439 5.73242V5.73242Z" fill="#FF9C33"/>
                                          <path d="M9.3708 23.1479C9.3108 23.1479 9.25085 23.1251 9.20505 23.0793L9.13418 23.0084C9.00621 22.8805 8.7979 22.8805 8.66993 23.0084L8.59905 23.0793C8.50751 23.1708 8.35915 23.1708 8.2676 23.0793C8.22185 23.0335 8.19897 22.9736 8.19897 22.9136C8.19897 22.8536 8.22185 22.7936 8.2676 22.7478L8.33847 22.6769C8.46649 22.549 8.46649 22.3407 8.33847 22.2127L8.2676 22.1418C8.22185 22.096 8.19897 22.0361 8.19897 21.9761C8.19897 21.9161 8.22185 21.8561 8.2676 21.8103C8.35915 21.7188 8.50751 21.7188 8.59905 21.8103L8.66993 21.8812C8.79785 22.0092 9.00616 22.0092 9.13422 21.8812L9.2051 21.8103C9.29665 21.7188 9.44501 21.7188 9.53655 21.8103C9.5823 21.8561 9.60518 21.9161 9.60518 21.9761C9.60518 22.0361 9.5823 22.096 9.53655 22.1418L9.46568 22.2127C9.40366 22.2747 9.36949 22.3572 9.36949 22.4448C9.36949 22.5325 9.40366 22.6149 9.46563 22.6769L9.53655 22.7478C9.5823 22.7936 9.60518 22.8536 9.60518 22.9136C9.60518 22.9736 9.5823 23.0335 9.53655 23.0793C9.49076 23.125 9.4308 23.1479 9.3708 23.1479Z" fill="#FF9C33"/>
                                       
                                      </svg>
                                          
                                            
                                </div>
                                Home   
                              </a> 
                          </li>

                          <li>
                              <a href="<?php echo e(url('/logout')); ?>" onclick="return confirm('Are You Sure?')">
                                  <div class="icon-box bg_color_7">
                                      <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <g clip-path="url(#clip0_4355_15432)">
                                          <path d="M4.2248 7.60006L16.7592 0.603265C17.1297 0.396475 17.5672 0.345328 17.9754 0.461073C18.3836 0.576818 18.7292 0.849977 18.936 1.22047L20.146 3.38807C20.2362 3.54579 20.2691 3.72987 20.2391 3.90908C20.209 4.08828 20.1179 4.25158 19.9812 4.37127C19.5254 4.75969 19.1876 5.26814 19.0063 5.83888C18.8249 6.40962 18.8072 7.01978 18.9552 7.60006L18.8752 8.80007H4.0752L4.2248 7.60006Z" fill="#F7C331"/>
                                          <path d="M21.2749 15.6001C21.275 16.3406 21.5317 17.0583 22.0014 17.6308C22.4711 18.2033 23.1247 18.5953 23.8509 18.7401C24.0286 18.7774 24.1879 18.875 24.3016 19.0165C24.4154 19.158 24.4766 19.3346 24.4749 19.5161V22.0001C24.4749 22.4244 24.3063 22.8314 24.0063 23.1315C23.7062 23.4315 23.2993 23.6001 22.8749 23.6001H2.8749C2.45056 23.6001 2.04359 23.4315 1.74353 23.1315C1.44347 22.8314 1.2749 22.4244 1.2749 22.0001V9.2001C1.2749 8.77575 1.44347 8.36879 1.74353 8.06873C2.04359 7.76867 2.45056 7.6001 2.8749 7.6001H22.8749C23.2993 7.6001 23.7062 7.76867 24.0063 8.06873C24.3063 8.36879 24.4749 8.77575 24.4749 9.2001V11.6841C24.4766 11.8656 24.4154 12.0422 24.3016 12.1837C24.1879 12.3251 24.0286 12.4228 23.8509 12.4601C23.1247 12.6049 22.4711 12.9969 22.0014 13.5694C21.5317 14.1419 21.275 14.8596 21.2749 15.6001Z" fill="#E5354B"/>
                                          <path d="M18.4748 22.4V23.6H17.6748V22.4C17.6748 22.2939 17.7169 22.1922 17.792 22.1172C17.867 22.0421 17.9687 22 18.0748 22C18.1809 22 18.2826 22.0421 18.3576 22.1172C18.4327 22.1922 18.4748 22.2939 18.4748 22.4Z" fill="#C12748"/>
                                          <path d="M18.0748 19.6001C17.9687 19.6001 17.867 19.6422 17.792 19.7173C17.7169 19.7923 17.6748 19.894 17.6748 20.0001V20.8001C17.6748 20.9062 17.7169 21.0079 17.792 21.0829C17.867 21.158 17.9687 21.2001 18.0748 21.2001C18.1809 21.2001 18.2826 21.158 18.3576 21.0829C18.4327 21.0079 18.4748 20.9062 18.4748 20.8001V20.0001C18.4748 19.894 18.4327 19.7923 18.3576 19.7173C18.2826 19.6422 18.1809 19.6001 18.0748 19.6001Z" fill="#C12748"/>
                                          <path d="M18.0748 17.2002C17.9687 17.2002 17.867 17.2423 17.792 17.3174C17.7169 17.3924 17.6748 17.4941 17.6748 17.6002V18.4002C17.6748 18.5063 17.7169 18.608 17.792 18.683C17.867 18.7581 17.9687 18.8002 18.0748 18.8002C18.1809 18.8002 18.2826 18.7581 18.3576 18.683C18.4327 18.608 18.4748 18.5063 18.4748 18.4002V17.6002C18.4748 17.4941 18.4327 17.3924 18.3576 17.3174C18.2826 17.2423 18.1809 17.2002 18.0748 17.2002Z" fill="#C12748"/>
                                          <path d="M18.0748 14.8003C17.9687 14.8003 17.867 14.8424 17.792 14.9174C17.7169 14.9925 17.6748 15.0942 17.6748 15.2003V16.0003C17.6748 16.1064 17.7169 16.2081 17.792 16.2831C17.867 16.3582 17.9687 16.4003 18.0748 16.4003C18.1809 16.4003 18.2826 16.3582 18.3576 16.2831C18.4327 16.2081 18.4748 16.1064 18.4748 16.0003V15.2003C18.4748 15.0942 18.4327 14.9925 18.3576 14.9174C18.2826 14.8424 18.1809 14.8003 18.0748 14.8003Z" fill="#C12748"/>
                                          <path d="M18.0748 12.3999C17.9687 12.3999 17.867 12.442 17.792 12.5171C17.7169 12.5921 17.6748 12.6938 17.6748 12.7999V13.5999C17.6748 13.706 17.7169 13.8077 17.792 13.8827C17.867 13.9578 17.9687 13.9999 18.0748 13.9999C18.1809 13.9999 18.2826 13.9578 18.3576 13.8827C18.4327 13.8077 18.4748 13.706 18.4748 13.5999V12.7999C18.4748 12.6938 18.4327 12.5921 18.3576 12.5171C18.2826 12.442 18.1809 12.3999 18.0748 12.3999Z" fill="#C12748"/>
                                          <path d="M18.0748 10C17.9687 10 17.867 10.0421 17.792 10.1172C17.7169 10.1922 17.6748 10.2939 17.6748 10.4V11.2C17.6748 11.3061 17.7169 11.4078 17.792 11.4828C17.867 11.5579 17.9687 11.6 18.0748 11.6C18.1809 11.6 18.2826 11.5579 18.3576 11.4828C18.4327 11.4078 18.4748 11.3061 18.4748 11.2V10.4C18.4748 10.2939 18.4327 10.1922 18.3576 10.1172C18.2826 10.0421 18.1809 10 18.0748 10Z" fill="#C12748"/>
                                          <path d="M18.4748 7.6001V8.8001C18.4748 8.90618 18.4327 9.00793 18.3576 9.08294C18.2826 9.15796 18.1809 9.2001 18.0748 9.2001C17.9687 9.2001 17.867 9.15796 17.792 9.08294C17.7169 9.00793 17.6748 8.90618 17.6748 8.8001V7.6001H18.4748Z" fill="#C12748"/>
                                          <path d="M5.67482 20.8002C5.59572 20.8001 5.5184 20.7767 5.45263 20.7327C5.38687 20.6888 5.33561 20.6263 5.30535 20.5532C5.27508 20.4801 5.26716 20.3997 5.28258 20.3222C5.29801 20.2446 5.33609 20.1733 5.39202 20.1174L14.192 11.3174C14.2675 11.2445 14.3685 11.2042 14.4734 11.2051C14.5783 11.206 14.6786 11.2481 14.7527 11.3222C14.8269 11.3964 14.869 11.4967 14.8699 11.6016C14.8708 11.7065 14.8305 11.8075 14.7576 11.883L5.95762 20.683C5.88262 20.758 5.7809 20.8001 5.67482 20.8002Z" fill="white"/>
                                          <path d="M7.2749 15.2002C6.87934 15.2002 6.49266 15.0829 6.16376 14.8631C5.83486 14.6434 5.57852 14.331 5.42714 13.9656C5.27577 13.6001 5.23616 13.198 5.31333 12.81C5.3905 12.4221 5.58098 12.0657 5.86069 11.786C6.14039 11.5063 6.49676 11.3158 6.88472 11.2386C7.27268 11.1615 7.67482 11.2011 8.04027 11.3524C8.40572 11.5038 8.71808 11.7602 8.93784 12.0891C9.15761 12.418 9.2749 12.8046 9.2749 13.2002C9.27427 13.7304 9.06335 14.2388 8.68842 14.6137C8.31348 14.9886 7.80514 15.1996 7.2749 15.2002ZM7.2749 12.0002C7.03757 12.0002 6.80556 12.0706 6.60822 12.2024C6.41088 12.3343 6.25707 12.5217 6.16625 12.741C6.07542 12.9602 6.05166 13.2015 6.09796 13.4343C6.14426 13.6671 6.25855 13.8809 6.42638 14.0487C6.5942 14.2165 6.80802 14.3308 7.0408 14.3771C7.27357 14.4234 7.51485 14.3997 7.73412 14.3089C7.95339 14.218 8.14081 14.0642 8.27267 13.8669C8.40452 13.6695 8.4749 13.4375 8.4749 13.2002C8.4749 12.8819 8.34848 12.5767 8.12343 12.3517C7.89839 12.1266 7.59316 12.0002 7.2749 12.0002Z" fill="white"/>
                                          <path d="M12.875 20.7998C12.4794 20.7998 12.0928 20.6825 11.7639 20.4627C11.435 20.243 11.1786 19.9306 11.0272 19.5652C10.8759 19.1997 10.8363 18.7976 10.9134 18.4096C10.9906 18.0217 11.1811 17.6653 11.4608 17.3856C11.7405 17.1059 12.0969 16.9154 12.4848 16.8382C12.8728 16.7611 13.2749 16.8007 13.6404 16.952C14.0058 17.1034 14.3182 17.3598 14.5379 17.6887C14.7577 18.0176 14.875 18.4042 14.875 18.7998C14.8744 19.33 14.6634 19.8384 14.2885 20.2133C13.9136 20.5883 13.4052 20.7992 12.875 20.7998ZM12.875 17.5998C12.6377 17.5998 12.4057 17.6702 12.2083 17.802C12.011 17.9339 11.8572 18.1213 11.7663 18.3406C11.6755 18.5599 11.6518 18.8011 11.6981 19.0339C11.7444 19.2667 11.8586 19.4805 12.0265 19.6483C12.1943 19.8162 12.4081 19.9304 12.6409 19.9767C12.8737 20.0231 13.1149 19.9993 13.3342 19.9085C13.5535 19.8176 13.7409 19.6638 13.8728 19.4665C14.0046 19.2692 14.075 19.0371 14.075 18.7998C14.075 18.4815 13.9486 18.1763 13.7235 17.9513C13.4985 17.7262 13.1933 17.5998 12.875 17.5998Z" fill="white"/>
                                          </g>
                                          <defs>
                                          <clipPath id="clip0_4355_15432">
                                          <rect width="24" height="24" fill="white" transform="translate(0.875)"/>
                                          </clipPath>
                                          </defs>
                                          </svg>
                                          
                                  </div>
                                  Logout
                              </a> 
                          </li>
                          
                      </ul>
                </div> 
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
                <br>
            </div>
    </div>
    
    
 


    <script type="text/javascript" src="<?php echo e(url('/myhr/javascript/jquery.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('/myhr/javascript/bootstrap.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('/myhr/javascript/swiper-bundle.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('/myhr/javascript/swiper.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(url('/myhr/javascript/main.js')); ?>"></script>

</body>

</html><?php /**PATH C:\xampp\htdocs\absensi\resources\views/dashboard/menu.blade.php ENDPATH**/ ?>