<?php $__env->startSection('isi'); ?>
    <div class="container-fluid">
        <div class="card">
            <div class="card-header">
                <form action="<?php echo e(url('/data-absen')); ?>">
                            <span>Filter Nama dan Rentang Tanggal</span><br><br>
                            <div class="form-row">
                                <div class="col-3">
                                    <select name="user_id" id="user_id" class="form-control selectpicker" data-live-search="true">
                                        <option value=""selected>Pilih Karyawan</option>
                                        <?php $__currentLoopData = $user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(request('user_id') == $u->id): ?>
                                                <option value="<?php echo e($u->id); ?>"selected><?php echo e($u->name); ?></option>
                                            <?php else: ?>
                                                <option value="<?php echo e($u->id); ?>"><?php echo e($u->name); ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-3">
                                    <input type="datetime" class="form-control" name="mulai" placeholder="Tanggal Mulai" id="mulai" value="<?php echo e(request('mulai')); ?>">
                                </div>
                                <div class="col-3">
                                    <input type="datetime" class="form-control" name="akhir" placeholder="Tanggal Akhir" id="akhir" value="<?php echo e(request('akhir')); ?>">
                                </div>
                                <div>
                                    <button type="submit" id="search" class="form-control btn btn-primary"><i class="fas fa-search"></i></button>
                                </div>
                            </div>
                </form>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <table id="tableprint" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <th>Nama Karyawan</th>
                            <th>Shift</th>
                            <th>Tanggal</th>
                            <th>Jam Masuk</th>
                            <th>Telat</th>
                            <th>Lokasi Masuk</th>
                            <th>Foto Masuk</th>
                            <th>Jam Pulang</th>
                            <th>Pulang Cepat</th>
                            <th>Lokasi Pulang</th>
                            <th>Foto Pulang</th>
                            <th>Status Absen</th>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ricky')): ?>
                                <th>Actions</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $data_absen; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $da): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($da->User->name); ?></td>
                        <td><?php echo e($da->Shift->nama_shift); ?> (<?php echo e($da->Shift->jam_masuk); ?> - <?php echo e($da->Shift->jam_keluar); ?>)</td>
                        <td><?php echo e($da->tanggal); ?></td>
                        <td>
                            <?php if($da->status_absen == 'Libur'): ?>
                                <span class="badge badge-info">Libur</span>
                            <?php elseif($da->status_absen == 'Cuti'): ?>
                                <span class="badge badge-warning">Sedang Cuti</span>
                            <?php elseif($da->jam_absen == null): ?>
                                <span class="badge badge-danger">Belum Absen</span>
                            <?php else: ?>
                                <?php echo e($da->jam_absen); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($da->status_absen == 'Libur'): ?>
                                <span class="badge badge-info">Libur</span>
                            <?php elseif($da->status_absen == 'Cuti'): ?>
                                <span class="badge badge-warning">Sedang Cuti</span>
                            <?php elseif($da->status_absen == 'Izin Telat'): ?>
                                <span class="badge badge-warning">Izin Telat</span>
                            <?php elseif($da->jam_absen == null): ?>
                                <span class="badge badge-danger">Belum Absen</span>
                            <?php else: ?>
                            <?php
                                $telat = $da->telat;
                                $jam   = floor($telat / (60 * 60));
                                $menit = $telat - ( $jam * (60 * 60) );
                                $menit2 = floor( $menit / 60 );
                                $detik = $telat % 60;
                            ?>
                                <?php if($jam <= 0 && $menit2 <= 0): ?>
                                    <span class="badge badge-success">Tepat Waktu</span>
                                <?php else: ?>
                                    <span class="badge badge-danger"><?php echo e($jam." Jam ".$menit2." Menit"); ?></span>
                                <?php endif; ?>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($da->status_absen == 'Libur'): ?>
                                <span class="badge badge-info">Libur</span>
                            <?php elseif($da->status_absen == 'Cuti'): ?>
                                <span class="badge badge-warning">Sedang Cuti</span>
                            <?php elseif($da->jam_absen == null): ?>
                                <span class="badge badge-danger">Belum Absen</span>
                            <?php else: ?>
                                <?php
                                    $jarak_masuk = explode(".", $da->jarak_masuk);
                                ?>
                                <a href="<?php echo e(url('/maps/'.$da->lat_absen.'/'.$da->long_absen)); ?>" class="btn btn-sm btn-secondary" target="_blank">lihat</a>
                                <span class="badge badge-warning"><?php echo e($jarak_masuk[0]); ?> Meter</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($da->status_absen == 'Libur'): ?>
                                <span class="badge badge-info">Libur</span>
                            <?php elseif($da->status_absen == 'Cuti'): ?>
                                <span class="badge badge-warning">Sedang Cuti</span>
                            <?php elseif($da->jam_absen == null): ?>
                                <span class="badge badge-danger">Belum Absen</span>
                            <?php else: ?>
                                <img src="<?php echo e(url('storage/' . $da->foto_jam_absen)); ?>" style="width: 60px">
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($da->status_absen == 'Libur'): ?>
                                <span class="badge badge-info">Libur</span>
                            <?php elseif($da->status_absen == 'Cuti'): ?>
                                <span class="badge badge-warning">Sedang Cuti</span>
                            <?php elseif($da->jam_absen == null): ?>
                                <span class="badge badge-danger">Belum Absen</span>
                            <?php elseif($da->jam_pulang == null): ?>
                                <span class="badge badge-warning">Belum Pulang</span>
                            <?php else: ?>
                                <?php echo e($da->jam_pulang); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($da->status_absen == 'Libur'): ?>
                                <span class="badge badge-info">Libur</span>
                            <?php elseif($da->status_absen == 'Cuti'): ?>
                                <span class="badge badge-warning">Sedang Cuti</span>
                            <?php elseif($da->status_absen == 'Izin Pulang Cepat'): ?>
                                <span class="badge badge-warning">Izin Pulang Cepat</span>
                            <?php elseif($da->jam_absen == null): ?>
                                <span class="badge badge-danger">Belum Absen</span>
                            <?php elseif($da->jam_pulang == null): ?>
                                <span class="badge badge-warning">Belum Pulang</span>
                            <?php else: ?>
                                <?php
                                    $pulang_cepat = $da->pulang_cepat;

                                    $jam   = floor($pulang_cepat / (60 * 60));
                                    $menit = $pulang_cepat - ( $jam * (60 * 60) );
                                    $menit2 = floor( $menit / 60 );
                                    $detik = $pulang_cepat % 60;
                                ?>
                                 <?php if($jam <= 0 && $menit2 <= 0): ?>
                                    <span class="badge badge-success">Tidak Pulang Cepat</span>
                                 <?php else: ?>
                                    <span class="badge badge-danger"><?php echo e($jam." Jam ".$menit2." Menit"); ?></span>
                                 <?php endif; ?>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($da->status_absen == 'Libur'): ?>
                                <span class="badge badge-info">Libur</span>
                            <?php elseif($da->status_absen == 'Cuti'): ?>
                                <span class="badge badge-warning">Sedang Cuti</span>
                            <?php elseif($da->jam_absen == null): ?>
                                <span class="badge badge-danger">Belum Absen</span>
                            <?php elseif($da->jam_pulang == null): ?>
                                <span class="badge badge-warning">Belum Pulang</span>
                            <?php else: ?>
                                <?php
                                    $jarak_pulang = explode(".", $da->jarak_pulang);
                                ?>
                                <a href="<?php echo e(url('/maps/'.$da->lat_pulang.'/'.$da->long_pulang)); ?>" class="btn btn-sm btn-secondary" target="_blank">lihat</a>
                                <span class="badge badge-warning"><?php echo e($jarak_pulang[0]); ?> Meter</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($da->status_absen == 'Libur'): ?>
                                <span class="badge badge-info">Libur</span>
                            <?php elseif($da->status_absen == 'Cuti'): ?>
                                <span class="badge badge-warning">Sedang Cuti</span>
                            <?php elseif($da->jam_absen == null): ?>
                                <span class="badge badge-danger">Belum Absen</span>
                            <?php elseif($da->jam_pulang == null): ?>
                                <span class="badge badge-warning">Belum Pulang</span>
                            <?php else: ?>
                                <img src="<?php echo e(url('storage/' . $da->foto_jam_pulang)); ?>" style="width: 60px">
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($da->status_absen == 'Libur'): ?>
                                <span class="badge badge-info"><?php echo e($da->status_absen); ?></span>
                            <?php elseif($da->status_absen == 'Cuti' || $da->status_absen == 'Izin Telat' || $da->status_absen == 'Izin Pulang Cepat'): ?>
                                <span class="badge badge-warning"><?php echo e($da->status_absen); ?></span>
                            <?php elseif($da->status_absen == 'Masuk'): ?>
                                <span class="badge badge-success"><?php echo e($da->status_absen); ?></span>
                            <?php else: ?>
                                <span class="badge badge-danger"><?php echo e($da->status_absen); ?></span>
                            <?php endif; ?>
                        </td>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ricky')): ?>
                            <td>
                                <?php if($da->status_absen == 'Libur'): ?>
                                    <span class="badge badge-info">Libur</span>
                                 <?php elseif($da->status_absen == 'Cuti'): ?>
                                    <span class="badge badge-warning">Sedang Cuti</span>
                                <?php else: ?>
                                    <a href="<?php echo e(url('/data-absen/'.$da->id.'/edit-masuk')); ?>" class="btn btn-warning">Edit Masuk</a>
                                <?php endif; ?>

                                <?php if($da->status_absen == 'Libur'): ?>
                                    <span class="badge badge-info">Libur</span>
                                <?php elseif($da->status_absen == 'Cuti'): ?>
                                    <span class="badge badge-warning">Sedang Cuti</span>
                                <?php elseif($da->jam_absen == null): ?>
                                    <span class="badge badge-danger">Belum Masuk</span>
                                <?php else: ?>
                                    <a href="<?php echo e(url('/data-absen/'.$da->id.'/edit-pulang')); ?>" class="btn btn-warning">Edit Pulang</a>
                                <?php endif; ?>

                                <form action="<?php echo e(url('/data-absen/'.$da->id.'/delete')); ?>" method="post" class="d-inline">
                                    <?php echo method_field('delete'); ?>
                                    <?php echo csrf_field(); ?>
                                    <button class="btn btn-danger" onClick="return confirm('Are You Sure')"><i class="fas fa-trash"></i></button>
                                </form>
                            </td>
                        <?php endif; ?>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <!-- /.card-body -->
        </div>
    </div>
    <br>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\gpiclick\resources\views/absen/dataabsen.blade.php ENDPATH**/ ?>